/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.zip.Adler32;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.FilterParser;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.LogIterator;
import org.apache.zookeeper.graph.LogSkipList;
import org.apache.zookeeper.graph.LogSource;
import org.apache.zookeeper.graph.RandomAccessFileReader;
import org.apache.zookeeper.graph.TransactionEntry;
import org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnLogSource
implements LogSource {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogSource.class);
    private LogSkipList skiplist = null;
    private static final int skipN = 10000;
    private String file = null;
    private long starttime = 0L;
    private long endtime = 0L;
    private long size = 0L;

    @Override
    public boolean overlapsRange(long starttime, long endtime) {
        return starttime <= this.endtime && endtime >= this.starttime;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getStartTime() {
        return this.starttime;
    }

    @Override
    public long getEndTime() {
        return this.endtime;
    }

    public LogSkipList getSkipList() {
        return this.skiplist;
    }

    public static boolean isTransactionFile(String file) throws IOException {
        RandomAccessFileReader reader = new RandomAccessFileReader(new File(file));
        BinaryInputArchive logStream = new BinaryInputArchive((DataInput)reader);
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize((InputArchive)logStream, "fileheader");
        reader.close();
        return fhdr.getMagic() == FileTxnLog.TXNLOG_MAGIC;
    }

    @Override
    public LogIterator iterator(long starttime, long endtime) throws IllegalArgumentException {
        try {
            return this.iterator(starttime, endtime, null);
        }
        catch (FilterException fe) {
            assert (false);
            return null;
        }
    }

    @Override
    public LogIterator iterator(long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
        if (endtime < starttime) {
            throw new IllegalArgumentException("End time (" + endtime + ") must be greater or equal to starttime (" + starttime + ")");
        }
        return new TxnLogSourceIterator(this, starttime, endtime, filter);
    }

    @Override
    public LogIterator iterator() throws IllegalArgumentException {
        return this.iterator(this.starttime, this.endtime + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TxnLogSource(String file) throws IOException {
        this.file = file;
        this.skiplist = new LogSkipList();
        RandomAccessFileReader reader = new RandomAccessFileReader(new File(file));
        try {
            BinaryInputArchive logStream = new BinaryInputArchive((DataInput)reader);
            FileHeader fhdr = new FileHeader();
            fhdr.deserialize((InputArchive)logStream, "fileheader");
            byte[] bytes = null;
            while (true) {
                long crcValue;
                long lastFp = reader.getPosition();
                try {
                    crcValue = logStream.readLong("crcvalue");
                    bytes = logStream.readBuffer("txnEntry");
                }
                catch (EOFException e) {
                    break;
                }
                if (bytes.length == 0) break;
                Adler32 crc = new Adler32();
                crc.update(bytes, 0, bytes.length);
                if (crcValue != crc.getValue()) {
                    throw new IOException("CRC doesn't match " + crcValue + " vs " + crc.getValue());
                }
                if (logStream.readByte("EOR") != 66) {
                    throw new EOFException("Last transaction was partial.");
                }
                TxnHeader hdr = new TxnHeader();
                Record r = SerializeUtils.deserializeTxn((byte[])bytes, (TxnHeader)hdr);
                if (this.starttime == 0L) {
                    this.starttime = hdr.getTime();
                }
                this.endtime = hdr.getTime();
                if (this.size % 10000L == 0L) {
                    this.skiplist.addMark(hdr.getTime(), lastFp, this.size);
                }
                ++this.size;
            }
            if (bytes == null) {
                throw new IOException("Nothing read from (" + file + ")");
            }
        }
        finally {
            reader.close();
        }
    }

    public String toString() {
        return "TxnLogSource(file=" + this.file + ", size=" + this.size + ", start=" + this.starttime + ", end=" + this.endtime + ")";
    }

    public static void main(String[] args) throws IOException, FilterException {
        LogIterator iter;
        TxnLogSource s = new TxnLogSource(args[0]);
        System.out.println(s);
        if (args.length == 3) {
            long starttime = Long.valueOf(args[1]);
            long endtime = Long.valueOf(args[2]);
            FilterOp fo = new FilterParser("(or (and (> zxid 0x2f0bd6f5e0) (< zxid 0x2f0bd6f5e9)) (= operation \"error\"))").parse();
            System.out.println("fo: " + fo);
            iter = s.iterator(starttime, endtime, fo);
        } else {
            iter = s.iterator();
        }
        System.out.println(iter);
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
        iter.close();
    }

    private class TxnLogSourceIterator
    implements LogIterator {
        private LogEntry next = null;
        private long starttime = 0L;
        private long endtime = 0L;
        private TxnLogSource src = null;
        private RandomAccessFileReader reader = null;
        private BinaryInputArchive logStream = null;
        private long skippedAtStart = 0L;
        private FilterOp filter = null;

        public TxnLogSourceIterator(TxnLogSource src, long starttime, long endtime) throws IllegalArgumentException, FilterException {
            this(src, starttime, endtime, null);
        }

        public TxnLogSourceIterator(TxnLogSource src, long starttime, long endtime, FilterOp filter) throws IllegalArgumentException, FilterException {
            LogEntry e;
            try {
                this.src = src;
                this.starttime = starttime;
                this.endtime = endtime;
                this.reader = new RandomAccessFileReader(new File(src.file));
                this.logStream = new BinaryInputArchive((DataInput)this.reader);
                FileHeader fhdr = new FileHeader();
                fhdr.deserialize((InputArchive)this.logStream, "fileheader");
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Cannot open transaction log (" + src.file + ") :" + e2);
            }
            LogSkipList.Mark start = src.getSkipList().findMarkBefore(starttime);
            try {
                this.reader.seek(start.getBytes());
                this.skippedAtStart = start.getEntriesSkipped();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.filter = filter;
            while ((e = this.readNextEntry()) != null && e.getTimestamp() < endtime) {
                if (e.getTimestamp() >= starttime && (filter == null || filter.matches(e))) {
                    this.next = e;
                    return;
                }
                ++this.skippedAtStart;
            }
        }

        @Override
        public long size() throws IOException {
            LogEntry e;
            if (this.endtime >= this.src.getEndTime()) {
                return this.src.size() - this.skippedAtStart;
            }
            long pos = this.reader.getPosition();
            LogSkipList.Mark lastseg = this.src.getSkipList().findMarkBefore(this.endtime);
            this.reader.seek(lastseg.getBytes());
            long count = lastseg.getEntriesSkipped() - this.skippedAtStart;
            while ((e = this.readNextEntry()) != null && e.getTimestamp() <= this.endtime) {
                ++count;
            }
            this.reader.seek(pos);
            return count;
        }

        private LogEntry readNextEntry() {
            TransactionEntry e = null;
            try {
                byte[] bytes;
                long crcValue;
                try {
                    crcValue = this.logStream.readLong("crcvalue");
                    bytes = this.logStream.readBuffer("txnEntry");
                }
                catch (EOFException ex) {
                    return null;
                }
                if (bytes.length == 0) {
                    return null;
                }
                Adler32 crc = new Adler32();
                crc.update(bytes, 0, bytes.length);
                if (crcValue != crc.getValue()) {
                    throw new IOException("CRC doesn't match " + crcValue + " vs " + crc.getValue());
                }
                TxnHeader hdr = new TxnHeader();
                Record r = SerializeUtils.deserializeTxn((byte[])bytes, (TxnHeader)hdr);
                switch (hdr.getType()) {
                    case -10: {
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "createSession");
                        break;
                    }
                    case -11: {
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "closeSession");
                        break;
                    }
                    case 1: {
                        if (r == null) break;
                        CreateTxn create = (CreateTxn)r;
                        String path = create.getPath();
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "create", path);
                        break;
                    }
                    case 5: {
                        if (r == null) break;
                        SetDataTxn set = (SetDataTxn)r;
                        String path = set.getPath();
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "setData", path);
                        break;
                    }
                    case 7: {
                        if (r == null) break;
                        SetACLTxn setacl = (SetACLTxn)r;
                        String path = setacl.getPath();
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "setACL", path);
                        break;
                    }
                    case -1: {
                        if (r == null) break;
                        ErrorTxn error = (ErrorTxn)r;
                        e = new TransactionEntry(hdr.getTime(), hdr.getClientId(), hdr.getCxid(), hdr.getZxid(), "error", "Error: " + error.getErr());
                        break;
                    }
                    default: {
                        LOG.info("Unknown op: " + hdr.getType());
                    }
                }
                if (this.logStream.readByte("EOR") != 66) {
                    throw new EOFException("Last transaction was partial.");
                }
            }
            catch (Exception ex) {
                LOG.error("Error reading transaction from (" + this.src.file + ") :" + e);
                return null;
            }
            return e;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LogEntry next() throws NoSuchElementException {
            LogEntry ret = this.next;
            LogEntry e = this.readNextEntry();
            if (this.filter != null) {
                try {
                    while (e != null && !this.filter.matches(e)) {
                        e = this.readNextEntry();
                    }
                }
                catch (FilterException fe) {
                    throw new NoSuchElementException(fe.toString());
                }
            }
            this.next = e != null && e.getTimestamp() < this.endtime ? e : null;
            return ret;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove not supported for Txn logs");
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

