/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test.system;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.system.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceContainer
implements Watcher,
AsyncCallback.ChildrenCallback {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceContainer.class);
    String name;
    String zkHostPort;
    String prefixNode;
    String statusNode = "available";
    String reportsNode = "reports";
    String assignmentsNode = "assignments";
    ZooKeeper zk;
    static final int sessTimeout = 5000;
    static final int maxTries = 3;
    HashMap<String, Instance> instances = new HashMap();

    public InstanceContainer(String name, String zkHostPort, String prefix) throws UnknownHostException {
        if (name.length() == 0 || name.equals("hostname")) {
            name = InetAddress.getLocalHost().getCanonicalHostName();
        }
        this.name = name;
        this.zkHostPort = zkHostPort;
        this.prefixNode = prefix;
        this.statusNode = prefix + '/' + this.statusNode + '/' + name;
        this.reportsNode = prefix + '/' + this.reportsNode;
        this.assignmentsNode = prefix + '/' + this.assignmentsNode + '/' + name;
    }

    private void rmnod(String path) throws InterruptedException, KeeperException {
        KeeperException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.delete(path, -1);
                lastException = null;
                break;
            }
            catch (KeeperException.NoNodeException e) {
                break;
            }
            catch (KeeperException e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void mknod_inner(String path, CreateMode mode) throws KeeperException, InterruptedException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
                break;
            }
            catch (KeeperException.NodeExistsException e) {
                if (mode != CreateMode.EPHEMERAL) {
                    return;
                }
                Stat stat = this.zk.exists(path, false);
                if (stat == null) continue;
                if (stat.getEphemeralOwner() == this.zk.getSessionId()) break;
                throw e;
            }
            catch (KeeperException.ConnectionLossException e) {
                e.printStackTrace();
            }
        }
    }

    private void mknod(String path, CreateMode mode) throws KeeperException, InterruptedException {
        String[] subpath = path.split("/");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < subpath.length; ++i) {
            sb.append("/");
            sb.append(subpath[i]);
            CreateMode m = CreateMode.PERSISTENT;
            if (i == subpath.length - 1) {
                m = mode;
            }
            this.mknod_inner(sb.toString(), m);
        }
    }

    public void run() throws IOException, InterruptedException, KeeperException {
        this.zk = new ZooKeeper(this.zkHostPort, 5000, (Watcher)this);
        this.mknod(this.assignmentsNode, CreateMode.PERSISTENT);
        this.mknod(this.statusNode, CreateMode.EPHEMERAL);
        this.mknod(this.reportsNode, CreateMode.PERSISTENT);
        this.zk.getChildren(this.assignmentsNode, true, (AsyncCallback.ChildrenCallback)this, null);
    }

    public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException, KeeperException {
        if (args.length != 3) {
            System.err.println("USAGE: " + InstanceContainer.class.getName() + " name zkHostPort znodePrefix");
            System.exit(2);
        }
        new InstanceContainer(args[0], args[1], args[2]).run();
        while (true) {
            Thread.sleep(1000L);
        }
    }

    public void process(WatchedEvent event) {
        if (Watcher.Event.KeeperState.Expired == event.getState()) {
            LOG.error("Lost session");
            System.exit(4);
        }
        if (event.getPath() != null && event.getPath().equals(this.assignmentsNode)) {
            this.zk.getChildren(this.assignmentsNode, true, (AsyncCallback.ChildrenCallback)this, null);
        }
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        if (rc != KeeperException.Code.OK.intValue()) {
            this.zk.getChildren(this.assignmentsNode, true, (AsyncCallback.ChildrenCallback)this, null);
            return;
        }
        HashMap<String, Instance> newList = new HashMap<String, Instance>();
        Stat stat = new Stat();
        for (String string : children) {
            Instance i = this.instances.remove(string);
            if (i == null) {
                String conf;
                String clazz;
                byte[] data = null;
                String myNode = this.assignmentsNode + '/' + string;
                while (true) {
                    try {
                        data = this.zk.getData(myNode, true, stat);
                    }
                    catch (KeeperException.NoNodeException e) {
                    }
                    catch (KeeperException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    break;
                }
                if (data == null) continue;
                String instanceSpec = new String(data);
                int spaceIndex = instanceSpec.indexOf(32);
                if (spaceIndex == -1) {
                    clazz = instanceSpec;
                    conf = null;
                } else {
                    clazz = instanceSpec.substring(0, spaceIndex);
                    conf = instanceSpec.substring(spaceIndex + 1);
                }
                try {
                    Class<?> c = Class.forName(clazz);
                    i = (Instance)c.newInstance();
                    MyReporter reporter = new MyReporter(string);
                    i.setReporter(reporter);
                    i.configure(conf);
                    i.start();
                    newList.put(string, i);
                    int ver = stat.getVersion();
                    Instance myInstance = i;
                    MyDataCallback dc = new MyDataCallback(myNode, myInstance, ver);
                    MyWatcher watcher = new MyWatcher(myNode, dc);
                    this.zk.getData(myNode, (Watcher)watcher, (AsyncCallback.DataCallback)dc, (Object)watcher);
                }
                catch (Exception e) {
                    LOG.warn("Skipping " + string, (Throwable)e);
                    if (e.getCause() == null) continue;
                    LOG.warn("Caused by", e.getCause());
                }
                continue;
            }
            newList.put(string, i);
        }
        for (Map.Entry entry : this.instances.entrySet()) {
            ((Instance)entry.getValue()).stop();
            try {
                this.rmnod(this.reportsNode + '/' + (String)entry.getKey());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
        }
        this.instances = newList;
    }

    private final class MyReporter
    implements Instance.Reporter {
        String myReportNode;

        public MyReporter(String child) {
            this.myReportNode = InstanceContainer.this.reportsNode + '/' + child;
        }

        @Override
        public void report(String report) throws KeeperException, InterruptedException {
            for (int j = 0; j < 3; ++j) {
                try {
                    try {
                        InstanceContainer.this.zk.setData(this.myReportNode, report.getBytes(), -1);
                    }
                    catch (KeeperException.NoNodeException e) {
                        InstanceContainer.this.zk.create(this.myReportNode, report.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                    }
                    break;
                }
                catch (KeeperException.ConnectionLossException connectionLossException) {
                    continue;
                }
            }
        }
    }

    private final class MyDataCallback
    implements AsyncCallback.DataCallback {
        int lastVer;
        String myNode;
        Instance myInstance;

        MyDataCallback(String myNode, Instance myInstance, int ver) {
            this.myNode = myNode;
            this.myInstance = myInstance;
            this.lastVer = ver;
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            int currVer;
            if (rc == KeeperException.Code.NONODE.intValue()) {
                return;
            }
            if (rc != KeeperException.Code.OK.intValue()) {
                InstanceContainer.this.zk.getData(this.myNode, (Watcher)ctx, (AsyncCallback.DataCallback)this, ctx);
            }
            if ((currVer = stat.getVersion()) != this.lastVer) {
                String[] parts = new String(data).split(" ", 2);
                this.myInstance.configure(parts[1]);
                this.lastVer = currVer;
            }
        }
    }

    private final class MyWatcher
    implements Watcher {
        String myNode;
        AsyncCallback.DataCallback dc;

        MyWatcher(String myNode, AsyncCallback.DataCallback dc) {
            this.myNode = myNode;
            this.dc = dc;
        }

        public void process(WatchedEvent event) {
            if (event.getPath() != null && event.getPath().equals(this.myNode)) {
                InstanceContainer.this.zk.getData(this.myNode, (Watcher)this, this.dc, (Object)this);
            }
        }
    }
}

