/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLETest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLETest.class);
    private LEThread leThread;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    HashMap<Integer, HashSet<TestVote>> voteMap;
    File[] tmpdir;
    int[] port;
    int successCount;
    Object finalObj;
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();
    Set<Long> joinedThreads;

    int countVotes(HashSet<TestVote> hs, long id) {
        int counter = 0;
        for (TestVote v : hs) {
            if (v.leader != id) continue;
            ++counter;
        }
        return counter;
    }

    @Before
    public void setUp() throws Exception {
        this.count = 7;
        this.peers = new HashMap(this.count);
        this.threads = new ArrayList(this.count);
        this.voteMap = new HashMap();
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.successCount = 0;
        this.finalObj = new Object();
        this.joinedThreads = new HashSet<Long>();
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            this.leThread = this.threads.get(i);
            QuorumBase.shutdown(this.leThread.peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLE() throws Exception {
        Object peer;
        int i;
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        boolean allowOneBadLeader = this.leaderDies = true;
        LOG.info("TestLE: " + this.getTestName() + ", " + this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, "0.0.0.0", Integer.valueOf(PortAssignment.unique()), Integer.valueOf(PortAssignment.unique()), null));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 0; i < le.length; ++i) {
            peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2);
            peer.startLeaderElection();
            LEThread thread = new LEThread((QuorumPeer)peer, i);
            thread.start();
            this.threads.add(thread);
        }
        LOG.info("Started threads " + this.getTestName());
        peer = this.finalObj;
        synchronized (peer) {
            for (int waitCounter = 0; this.successCount <= this.count / 2 && waitCounter < 50; ++waitCounter) {
                this.finalObj.wait(2000L);
            }
        }
        for (int i2 = 0; i2 < this.threads.size(); ++i2) {
            if (!this.threads.get(i2).isAlive()) continue;
            LOG.info("Threads didn't join: " + i2);
        }
        if (this.successCount <= this.count / 2) {
            Assert.fail((String)"Fewer than a a majority has joined");
        }
        Object object = this.finalObj;
        synchronized (object) {
            if (!this.joinedThreads.contains(this.leader)) {
                Assert.fail((String)("Leader hasn't joined: " + this.leader));
            }
        }
    }

    @Test
    public void testJoin() throws Exception {
        QuorumPeer peer;
        int sid;
        int waitTime = 10000;
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        for (sid = 0; sid < 3; ++sid) {
            this.peers.put(Long.valueOf(sid), new QuorumPeer.QuorumServer((long)sid, "0.0.0.0", Integer.valueOf(PortAssignment.unique()), Integer.valueOf(PortAssignment.unique()), null));
            this.tmpdir[sid] = ClientBase.createTmpDir();
            this.port[sid] = PortAssignment.unique();
        }
        for (sid = 0; sid < 2; ++sid) {
            peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2);
            LOG.info("Starting peer " + peer.getId());
            peer.start();
            peerList.add(sid, peer);
        }
        peer = (QuorumPeer)peerList.get(0);
        VerifyState v1 = new VerifyState((QuorumPeer)peerList.get(0));
        v1.start();
        v1.join(waitTime);
        Assert.assertFalse((String)("Unable to form cluster in " + waitTime + " ms"), (!v1.isSuccess() ? 1 : 0) != 0);
        peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2);
        LOG.info("Starting peer " + peer.getId());
        peer.start();
        peerList.add(sid, peer);
        v1 = new VerifyState(peer);
        v1.start();
        v1.join(waitTime);
        if (v1.isAlive()) {
            Assert.fail((String)("Peer " + peer.getId() + " failed to join the cluster " + "within " + waitTime + " ms"));
        } else if (!v1.isSuccess()) {
            Assert.fail((String)("Incorrect LEADING state for peer " + peer.getId()));
        }
        for (int id = 0; id < 3; ++id) {
            peer = (QuorumPeer)peerList.get(id);
            if (peer == null) continue;
            peer.shutdown();
        }
    }

    @Test
    public void testJoinInconsistentEnsemble() throws Exception {
        QuorumPeer peer;
        int sid;
        int waitTime = 10000;
        ArrayList<QuorumPeer> peerList = new ArrayList<QuorumPeer>();
        for (sid = 0; sid < 3; ++sid) {
            this.peers.put(Long.valueOf(sid), new QuorumPeer.QuorumServer((long)sid, "0.0.0.0", Integer.valueOf(PortAssignment.unique()), Integer.valueOf(PortAssignment.unique()), null));
            this.tmpdir[sid] = ClientBase.createTmpDir();
            this.port[sid] = PortAssignment.unique();
        }
        for (sid = 0; sid < 2; ++sid) {
            peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 2000, 2, 2);
            LOG.info("Starting peer " + peer.getId());
            peer.start();
            peerList.add(sid, peer);
        }
        peer = (QuorumPeer)peerList.get(0);
        VerifyState v1 = new VerifyState((QuorumPeer)peerList.get(0));
        v1.start();
        v1.join(waitTime);
        Assert.assertFalse((String)("Unable to form cluster in " + waitTime + " ms"), (!v1.isSuccess() ? 1 : 0) != 0);
        long leaderSid = peer.getCurrentVote().getId();
        long zxid = peer.getCurrentVote().getZxid();
        long electionEpoch = peer.getCurrentVote().getElectionEpoch();
        QuorumPeer.ServerState state = peer.getCurrentVote().getState();
        long peerEpoch = peer.getCurrentVote().getPeerEpoch();
        Vote newVote = new Vote(leaderSid, zxid + 100L, electionEpoch + 100L, peerEpoch, state);
        peer.setCurrentVote(newVote);
        peer = new QuorumPeer(this.peers, this.tmpdir[2], this.tmpdir[2], this.port[2], 3, 2L, 2000, 2, 2);
        LOG.info("Starting peer " + peer.getId());
        peer.start();
        peerList.add(sid, peer);
        v1 = new VerifyState(peer);
        v1.start();
        v1.join(waitTime);
        if (v1.isAlive()) {
            Assert.fail((String)("Peer " + peer.getId() + " failed to join the cluster " + "within " + waitTime + " ms"));
        }
        for (int id = 0; id < 3; ++id) {
            peer = (QuorumPeer)peerList.get(id);
            if (peer == null) continue;
            peer.shutdown();
        }
    }

    class VerifyState
    extends Thread {
        private volatile boolean success = false;
        QuorumPeer peer;

        public VerifyState(QuorumPeer peer) {
            this.peer = peer;
        }

        @Override
        public void run() {
            this.setName("VerifyState-" + this.peer.getId());
            while (true) {
                if (this.peer.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                    LOG.info("I am following");
                    this.success = true;
                    break;
                }
                if (this.peer.getPeerState() == QuorumPeer.ServerState.LEADING) {
                    LOG.info("I am leading");
                    this.success = false;
                    break;
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Exception e) {
                    LOG.warn("Sleep failed ", (Throwable)e);
                }
            }
        }

        public boolean isSuccess() {
            return this.success;
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    HashSet<TestVote> hs;
                    HashMap<Integer, HashSet<TestVote>> hashMap;
                    Object object;
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread " + this.i + " got a null vote");
                        break;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.getId());
                    FLETest.this.votes[this.i] = v;
                    int lc = (int)((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock();
                    if (v.getId() == (long)this.i) {
                        LOG.info("I'm the leader: " + this.i);
                        object = FLETest.this;
                        synchronized (object) {
                            if (FLETest.this.leaderDies) {
                                LOG.info("Leader " + this.i + " dying");
                                FLETest.this.leaderDies = false;
                                ((FastLeaderElection)this.peer.getElectionAlg()).shutdown();
                                FLETest.this.leader = -1L;
                                LOG.info("Leader " + this.i + " dead");
                                FLETest.this.notifyAll();
                                break;
                            }
                            hashMap = FLETest.this.voteMap;
                            synchronized (hashMap) {
                                if (FLETest.this.voteMap.get(lc) == null) {
                                    FLETest.this.voteMap.put(lc, new HashSet());
                                }
                                hs = FLETest.this.voteMap.get(lc);
                                hs.add(new TestVote(this.i, v.getId()));
                                if (FLETest.this.countVotes(hs, v.getId()) > FLETest.this.count / 2) {
                                    FLETest.this.leader = this.i;
                                    LOG.info("Got majority: " + this.i);
                                } else {
                                    FLETest.this.voteMap.wait(3000L);
                                    LOG.info("Notified or expired: " + this.i);
                                    hs = FLETest.this.voteMap.get(lc);
                                    if (FLETest.this.countVotes(hs, v.getId()) > FLETest.this.count / 2) {
                                        FLETest.this.leader = this.i;
                                        LOG.info("Got majority: " + this.i);
                                    }
                                }
                            }
                            FLETest.this.notifyAll();
                            if (FLETest.this.leader == (long)this.i) {
                                hashMap = FLETest.this.finalObj;
                                synchronized (hashMap) {
                                    ++FLETest.this.successCount;
                                    FLETest.this.joinedThreads.add(Long.valueOf(this.i));
                                    if (FLETest.this.successCount > FLETest.this.count / 2) {
                                        FLETest.this.finalObj.notify();
                                    }
                                }
                            }
                        }
                    }
                    LOG.info("Logical clock " + ((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock());
                    object = FLETest.this.voteMap;
                    synchronized (object) {
                        LOG.info("Voting on " + FLETest.this.votes[this.i].getId() + ", round " + ((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock());
                        if (FLETest.this.voteMap.get(lc) == null) {
                            FLETest.this.voteMap.put(lc, new HashSet());
                        }
                        HashSet<TestVote> hs2 = FLETest.this.voteMap.get(lc);
                        hs2.add(new TestVote(this.i, FLETest.this.votes[this.i].getId()));
                        if (FLETest.this.countVotes(hs2, FLETest.this.votes[this.i].getId()) > FLETest.this.count / 2) {
                            LOG.info("Logical clock: " + lc + ", " + FLETest.this.votes[this.i].getId());
                            FLETest.this.voteMap.notify();
                        }
                    }
                    object = FLETest.this;
                    synchronized (object) {
                        if (FLETest.this.leader != FLETest.this.votes[this.i].getId()) {
                            FLETest.this.wait(3000L);
                        }
                        LOG.info("The leader: " + FLETest.this.leader + " and my vote " + FLETest.this.votes[this.i].getId());
                        hashMap = FLETest.this.voteMap;
                        synchronized (hashMap) {
                            if (FLETest.this.leader == FLETest.this.votes[this.i].getId()) {
                                hs = FLETest.this.finalObj;
                                synchronized (hs) {
                                    ++FLETest.this.successCount;
                                    FLETest.this.joinedThreads.add(Long.valueOf(this.i));
                                    if (FLETest.this.successCount > FLETest.this.count / 2) {
                                        FLETest.this.finalObj.notify();
                                    }
                                }
                            }
                            hs = FLETest.this.voteMap.get(lc);
                            TestVote toRemove = null;
                            for (TestVote tv : hs) {
                                if (v.getId() != (long)this.i) continue;
                                toRemove = tv;
                                break;
                            }
                            hs.remove(toRemove);
                        }
                    }
                    Thread.sleep(FLETest.this.rand.nextInt(500));
                    this.peer.setCurrentVote(new Vote(this.peer.getId(), 0L));
                }
                LOG.debug("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class TestVote {
        long leader;

        TestVote(int id, long leader) {
            this.leader = leader;
        }
    }
}

