/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class AuthTest
extends ClientBase {
    private final CountDownLatch authFailed = new CountDownLatch(1);

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadAuthNotifiesWatch() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.addAuthInfo("FOO", "BAR".getBytes());
            zk.getData("/path1", false, null);
            Assert.fail((String)"Should get auth state error");
        }
        catch (KeeperException.AuthFailedException e) {
            if (!this.authFailed.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Should have called my watcher");
            }
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadAuthThenSendOtherCommands() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.addAuthInfo("INVALID", "BAR".getBytes());
            zk.exists("/foobar", false);
            zk.getData("/path1", false, null);
            Assert.fail((String)"Should get auth state error");
        }
        catch (KeeperException.AuthFailedException e) {
            if (!this.authFailed.await(CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
                Assert.fail((String)"Should have called my watcher");
            }
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuper() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "pat:pass".getBytes());
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            try {
                zk.getData("/path1", false, null);
                Assert.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException e) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "pat:pass2".getBytes());
            try {
                zk.getData("/path1", false, null);
                Assert.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException e) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test2".getBytes());
            try {
                zk.getData("/path1", false, null);
                Assert.fail((String)"auth verification");
            }
            catch (KeeperException.NoAuthException noAuthException) {
                // empty catch block
            }
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test".getBytes());
            zk.getData("/path1", false, null);
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuperACL() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "pat:pass".getBytes());
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "super:test".getBytes());
            zk.getData("/path1", false, null);
            zk.setACL("/path1", ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            zk.create("/path1/foo", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            zk.setACL("/path1", ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.test.InvalidAuthProvider");
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                AuthTest.this.authFailed.countDown();
            } else {
                super.process(event);
            }
        }
    }
}

