/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslException;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumAuthPacket;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.auth.NullQuorumAuthLearner;
import org.apache.zookeeper.server.quorum.auth.NullQuorumAuthServer;
import org.apache.zookeeper.server.quorum.auth.QuorumAuth;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthLearner;
import org.apache.zookeeper.server.quorum.auth.QuorumAuthServer;
import org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthLearner;
import org.apache.zookeeper.server.quorum.auth.SaslQuorumAuthServer;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumCnxManagerTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumCnxManagerTest.class);
    private int count;
    private HashMap<Long, QuorumPeer.QuorumServer> peers;
    private int[] peerQuorumPort;
    private int[] peerClientPort;
    private ThreadPoolExecutor executor;
    private final int quorumCnxnThreadsSize = 20;
    private Set<String> authzHosts;
    private static File saslConfigFile = null;

    @BeforeClass
    public static void setupSasl() throws Exception {
        String jaasEntries = new String("QuorumServer {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       user_test=\"mypassword\";\n};\nQuorumLearner {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"mypassword\";\n};\nQuorumLearnerInvalid {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"test\"\n       password=\"invalid\";\n};\n");
        saslConfigFile = File.createTempFile("jaas.", ".conf");
        FileWriter fwriter = new FileWriter(saslConfigFile);
        fwriter.write(jaasEntries);
        fwriter.close();
        System.setProperty("java.security.auth.login.config", saslConfigFile.getAbsolutePath());
    }

    @AfterClass
    public static void cleanupSasl() throws Exception {
        if (saslConfigFile != null) {
            saslConfigFile.delete();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.peerQuorumPort = new int[this.count];
        this.peerClientPort = new int[this.count];
        this.authzHosts = new HashSet<String>();
        for (int i = 0; i < this.count; ++i) {
            this.peerQuorumPort[i] = PortAssignment.unique();
            this.peerClientPort[i] = PortAssignment.unique();
            QuorumPeer.QuorumServer qs = new QuorumPeer.QuorumServer((long)i, "0.0.0.0", Integer.valueOf(this.peerQuorumPort[i]), Integer.valueOf(PortAssignment.unique()), null);
            this.peers.put(Long.valueOf(i), qs);
            this.authzHosts.add(qs.hostname);
        }
        this.executor = new ThreadPoolExecutor(3, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @After
    public void tearDown() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test(timeout=30000L)
    public void testNoAuthConnection() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L);
        QuorumCnxManager peer1 = this.createAndStartManager(1L);
        peer0.connectOne(1L);
        this.assertEventuallyConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testAuthConnection() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearner", true, true);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearner", true, true);
        peer0.connectOne(1L);
        this.assertEventuallyConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testClientAuthAgainstNoAuthServerWithLowerSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearner", false, false);
        peer1.connectOne(0L);
        peer0.connectOne(1L);
        this.assertEventuallyConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testClientAuthAgainstNoAuthServerWithHigherSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearner", false, false);
        QuorumCnxManager peer1 = this.createAndStartManager(1L);
        peer0.connectOne(1L);
        peer1.connectOne(0L);
        this.assertEventuallyConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testNoAuthLearnerConnectToAuthRequiredServerWithLowerSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearner", true, true);
        QuorumCnxManager peer1 = this.createAndStartManager(1L);
        peer0.connectOne(1L);
        peer1.connectOne(0L);
        this.assertEventuallyNotConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testNoAuthLearnerConnectToAuthRequiredServerWithHigherSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearner", true, true);
        peer0.connectOne(1L);
        peer1.connectOne(0L);
        this.assertEventuallyNotConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testAuthLearnerBadCredToAuthRequiredServerWithLowerSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearner", true, true);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearnerInvalid", true, true);
        peer0.connectOne(1L);
        peer1.connectOne(0L);
        this.assertEventuallyNotConnected(peer0, 1L);
    }

    @Test(timeout=30000L)
    public void testAuthLearnerBadCredToAuthRequiredServerWithHigherSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearnerInvalid", true, true);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearner", true, true);
        peer0.connectOne(1L);
        peer1.connectOne(0L);
        this.assertEventuallyConnected(peer0, 1L);
        this.assertEventuallyConnected(peer1, 0L);
    }

    @Test(timeout=30000L)
    public void testAuthLearnerBadCredToNoAuthServerWithHigherSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearner", false, false);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearnerInvalid", true, true);
        peer1.connectOne(0L);
        this.assertEventuallyNotConnected(peer1, 0L);
    }

    @Test(timeout=30000L)
    public void testAuthLearnerBadCredToNoAuthServerWithLowerSid() throws Exception {
        QuorumCnxManager peer0 = this.createAndStartManager(0L, "QuorumServer", "QuorumLearnerInvalid", true, true);
        QuorumCnxManager peer1 = this.createAndStartManager(1L, "QuorumServer", "QuorumLearner", false, true);
        peer0.connectOne(1L);
        this.assertEventuallyConnected(peer0, 1L);
        this.assertEventuallyConnected(peer1, 0L);
    }

    @Test(timeout=30000L)
    public void testLearnerHandlerAuthFailed() throws Exception {
        File testData = ClientBase.createTmpDir();
        Socket leaderSocket = QuorumCnxManagerTest.getSocketPair();
        File tmpDir = File.createTempFile("test", ".dir", testData);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, true, false, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        peer.leader = leader = this.createLeader(tmpDir, peer);
        try {
            new LearnerHandler(leaderSocket, new BufferedInputStream(leaderSocket.getInputStream()), leader);
            Assert.fail((String)"Must throw exception as there is an authentication failure");
        }
        catch (SaslException e) {
            Assert.assertEquals((String)"Mistakely added to learners", (long)0L, (long)leader.getLearners().size());
        }
        ClientBase.recursiveDelete(testData);
    }

    @Test(timeout=30000L)
    public void testAuthLearnerConnectsToServerWithAuthRequired() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, true, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, true, true, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        String hostname = this.getLeaderHostname(peer);
        sl.connectToLeader(peer.getQuorumAddress(), hostname);
        Assert.assertTrue((String)"Leader should accept the auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 1000, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"Failed to added the learner", (long)1L, (long)leader.getLearners().size());
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    private String getLeaderHostname(QuorumPeer peer) {
        String hostname = null;
        for (QuorumPeer.QuorumServer p : peer.getView().values()) {
            if (p.id != peer.getId()) continue;
            hostname = p.hostname;
            break;
        }
        Assert.assertNotNull((String)"Didn't find leader", hostname);
        return hostname;
    }

    @Test(timeout=30000L)
    public void testAuthLearnerConnectsToServerWithAuthNotRequired() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, true, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, true, true, false, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        String hostname = this.getLeaderHostname(peer);
        sl.connectToLeader(peer.getQuorumAddress(), hostname);
        Assert.assertTrue((String)"Leader should accept the auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 1000, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"Failed to added the learner", (long)1L, (long)leader.getLearners().size());
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    private void startLearnerCnxAcceptorThread(Leader leader) throws InterruptedException {
        final CountDownLatch cnxAcceptorWatcher = new CountDownLatch(1);
        Leader leader2 = leader;
        leader2.getClass();
        leader.cnxAcceptor = new Leader.LearnerCnxAcceptor(leader2){

            public void run() {
                cnxAcceptorWatcher.countDown();
                super.run();
            }
        };
        leader.cnxAcceptor.start();
        Assert.assertTrue((String)"Failed to start leader.cnxAcceptor thread!", (boolean)cnxAcceptorWatcher.await(15L, TimeUnit.SECONDS));
        LOG.info("Started leader.cnxAcceptor:{} thread, state:{}", (Object)leader.cnxAcceptor.getName(), (Object)leader.cnxAcceptor.getState());
    }

    @Test(timeout=30000L)
    public void testAuthLearnerConnectsToNullAuthServer() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, true, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, false, false, false, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        try {
            String hostname = this.getLeaderHostname(peer);
            sl.connectToLeader(peer.getQuorumAddress(), hostname);
            Assert.fail((String)"Must throw exception as server doesn't supports authentication");
        }
        catch (IOException e) {
            Assert.assertTrue((String)"Leader should accept the auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 500, TimeUnit.MILLISECONDS));
        }
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    @Test(timeout=30000L)
    public void testNoAuthLearnerConnectsToServerWithAuthNotRequired() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, false, false, "QuorumLearner", "QuorumServer", "");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, true, false, false, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        String hostname = this.getLeaderHostname(peer);
        sl.connectToLeader(peer.getQuorumAddress(), hostname);
        Assert.assertTrue((String)"Leader should accept no auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 1000, TimeUnit.MILLISECONDS));
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    @Test(timeout=30000L)
    public void testNoAuthLearnerConnectsToServerWithAuthRequired() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, false, false, "QuorumLearner", "QuorumServer", "");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, true, true, true, "QuorumLearner", "QuorumServer", "zkquorum/localhost");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        String hostname = this.getLeaderHostname(peer);
        sl.connectToLeader(peer.getQuorumAddress(), hostname);
        Assert.assertFalse((String)"Leader shouldn't accept no auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 1000, TimeUnit.MILLISECONDS));
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    @Test(timeout=30000L)
    public void testNoAuthLearnerConnectsToNullAuthServer() throws Exception {
        File testDataLearner = ClientBase.createTmpDir();
        File tmpDir = File.createTempFile("test", ".dir", testDataLearner);
        tmpDir.delete();
        FileTxnSnapLog ftsl = new FileTxnSnapLog(tmpDir, tmpDir);
        QuorumPeer learnerPeer = this.createQuorumPeer(tmpDir, true, false, false, "QuorumLearner", "QuorumServer", "");
        SimpleLearner sl = new SimpleLearner(ftsl, learnerPeer);
        File testDataLeader = ClientBase.createTmpDir();
        tmpDir = File.createTempFile("test", ".dir", testDataLeader);
        tmpDir.delete();
        tmpDir.mkdir();
        Leader leader = null;
        QuorumPeer peer = this.createQuorumPeer(tmpDir, false, false, false, "", "", "");
        CountDownLatch learnerLatch = new CountDownLatch(1);
        peer.leader = leader = this.createSimpleLeader(tmpDir, peer, learnerLatch);
        this.startLearnerCnxAcceptorThread(leader);
        LOG.info("Start establishing a connection with the Leader");
        String hostname = this.getLeaderHostname(peer);
        sl.connectToLeader(peer.getQuorumAddress(), hostname);
        Assert.assertTrue((String)"Leader should accept no auth learner connection", (boolean)learnerLatch.await(leader.self.tickTime * leader.self.initLimit + 1000, TimeUnit.MILLISECONDS));
        ClientBase.recursiveDelete(testDataLearner);
        ClientBase.recursiveDelete(testDataLeader);
    }

    @Test(timeout=30000L)
    public void testSaslQuorumAuthServerWithInvalidQuorumAuthPacket() throws Exception {
        Socket socket = QuorumCnxManagerTest.getSocketPair();
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(dout);
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)bufferedOutput);
        QuorumAuthPacket authPacket = QuorumAuth.createPacket((QuorumAuth.Status)QuorumAuth.Status.IN_PROGRESS, null);
        authPacket.setMagic(Long.MAX_VALUE);
        boa.writeRecord((Record)authPacket, null);
        bufferedOutput.flush();
        SaslQuorumAuthServer authServer = new SaslQuorumAuthServer(true, "QuorumServer", this.authzHosts);
        BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
        try {
            authServer.authenticate(socket, new DataInputStream(is));
            Assert.fail((String)"Must throw exception as QuorumAuthPacket is invalid");
        }
        catch (SaslException e) {
            // empty catch block
        }
    }

    @Test(timeout=30000L)
    public void testNullQuorumAuthServerShouldReturnTrue() throws Exception {
        Socket socket = QuorumCnxManagerTest.getSocketPair();
        NullQuorumAuthServer authServer = new NullQuorumAuthServer();
        BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
        authServer.authenticate(socket, new DataInputStream(is));
    }

    @Test(timeout=30000L)
    public void testNullQuorumAuthServerWithValidQuorumAuthPacket() throws Exception {
        Socket socket = QuorumCnxManagerTest.getSocketPair();
        DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(dout);
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)bufferedOutput);
        QuorumAuthPacket authPacket = QuorumAuth.createPacket((QuorumAuth.Status)QuorumAuth.Status.IN_PROGRESS, null);
        boa.writeRecord((Record)authPacket, null);
        bufferedOutput.flush();
        NullQuorumAuthServer authServer = new NullQuorumAuthServer();
        BufferedInputStream is = new BufferedInputStream(socket.getInputStream());
        authServer.authenticate(socket, new DataInputStream(is));
    }

    private QuorumCnxManager createAndStartManager(long sid) {
        QuorumCnxManager peer = new QuorumCnxManager(sid, this.peers, (QuorumAuthServer)new NullQuorumAuthServer(), (QuorumAuthLearner)new NullQuorumAuthLearner(), 10000, false, 20, false);
        this.executor.submit((Runnable)peer.listener);
        InetSocketAddress electionAddr = ((QuorumPeer.QuorumServer)peer.view.get((Object)Long.valueOf((long)sid))).electionAddr;
        this.waitForElectionAddrBinding(electionAddr, 15);
        return peer;
    }

    private QuorumCnxManager createAndStartManager(long sid, String serverLoginContext, String learnerLoginContext, boolean serverRequireSasl, boolean learnerRequireSasl) throws Exception {
        SaslQuorumAuthLearner authClient = new SaslQuorumAuthLearner(learnerRequireSasl, "NOT_USING_KRB_PRINCIPAL", learnerLoginContext);
        SaslQuorumAuthServer authServer = new SaslQuorumAuthServer(serverRequireSasl, serverLoginContext, this.authzHosts);
        QuorumCnxManager peer = new QuorumCnxManager(sid, this.peers, (QuorumAuthServer)authServer, (QuorumAuthLearner)authClient, 10000, false, 20, true);
        this.executor.submit((Runnable)peer.listener);
        InetSocketAddress electionAddr = ((QuorumPeer.QuorumServer)peer.view.get((Object)Long.valueOf((long)sid))).electionAddr;
        this.waitForElectionAddrBinding(electionAddr, 15);
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForElectionAddrBinding(InetSocketAddress electionAddr, int retries) {
        boolean success = false;
        while (retries > 0) {
            Socket sock = new Socket();
            try {
                sock.setTcpNoDelay(true);
                sock.setSoTimeout(5000);
                sock.connect(electionAddr, 5000);
                success = true;
            }
            catch (IOException e) {
                LOG.error("IOException while checking election addr", (Throwable)e);
            }
            finally {
                this.cleanup(sock);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            --retries;
        }
        Assert.assertTrue((String)"Did not connect to election port", (boolean)success);
    }

    private void cleanup(Socket sock) {
        try {
            sock.close();
        }
        catch (IOException ie) {
            LOG.error("Exception while closing socket", (Throwable)ie);
        }
    }

    private void assertEventuallyConnected(QuorumCnxManager peer, long sid) throws Exception {
        for (int i = 0; i < 20 && !peer.connectedToPeer(sid); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((String)"Not connected to peer", (boolean)peer.connectedToPeer(sid));
    }

    private void assertEventuallyNotConnected(QuorumCnxManager peer, long sid) throws Exception {
        for (int i = 0; i < 3 && !peer.connectedToPeer(sid); ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertFalse((String)"Connected to peer (shouldn't be)", (boolean)peer.connectedToPeer(sid));
    }

    private QuorumPeer createQuorumPeer(File tmpDir, boolean isQuorumAuthEnabled, boolean isQuorumLearnerAuthRequired, boolean isQuorumServerAuthRequired, String quorumLearnerLoginContext, String quorumServerLoginContext, String quorumServicePrincipal) throws IOException, FileNotFoundException {
        QuorumPeer peer = QuorumPeer.testingQuorumPeer();
        peer.syncLimit = 2;
        peer.initLimit = 2;
        peer.tickTime = 2000;
        peer.quorumPeers = new HashMap();
        peer.quorumPeers.put(0L, new QuorumPeer.QuorumServer(0L, "0.0.0.0", Integer.valueOf(PortAssignment.unique()), null, null));
        peer.quorumPeers.put(1L, new QuorumPeer.QuorumServer(1L, "0.0.0.0", Integer.valueOf(PortAssignment.unique()), null, null));
        peer.setQuorumVerifier((QuorumVerifier)new QuorumMaj(3));
        peer.setCnxnFactory((ServerCnxnFactory)new NullServerCnxnFactory());
        if (isQuorumAuthEnabled) {
            peer.authServer = new SaslQuorumAuthServer(isQuorumServerAuthRequired, quorumServerLoginContext, this.authzHosts);
            peer.authLearner = new SaslQuorumAuthLearner(isQuorumLearnerAuthRequired, quorumServicePrincipal, quorumLearnerLoginContext);
        }
        File version2 = new File(tmpDir, "version-2");
        version2.mkdir();
        FileOutputStream fos = new FileOutputStream(new File(version2, "currentEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        fos = new FileOutputStream(new File(version2, "acceptedEpoch"));
        fos.write("0\n".getBytes());
        fos.close();
        return peer;
    }

    private static Socket getSocketPair() throws IOException {
        ServerSocket ss = new ServerSocket();
        ss.bind(null);
        InetSocketAddress endPoint = (InetSocketAddress)ss.getLocalSocketAddress();
        Socket s = new Socket(endPoint.getAddress(), endPoint.getPort());
        s.setSoTimeout(5000);
        return s;
    }

    private Leader createLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        LeaderZooKeeperServer zk = this.prepareLeader(tmpDir, peer);
        return new Leader(peer, zk);
    }

    private Leader createSimpleLeader(File tmpDir, QuorumPeer peer, CountDownLatch learnerLatch) throws IOException, NoSuchFieldException, IllegalAccessException {
        LeaderZooKeeperServer zk = this.prepareLeader(tmpDir, peer);
        return new SimpleLeader(peer, zk, learnerLatch);
    }

    private LeaderZooKeeperServer prepareLeader(File tmpDir, QuorumPeer peer) throws IOException, NoSuchFieldException, IllegalAccessException {
        FileTxnSnapLog logFactory = new FileTxnSnapLog(tmpDir, tmpDir);
        peer.setTxnFactory(logFactory);
        Field addrField = peer.getClass().getDeclaredField("myQuorumAddr");
        addrField.setAccessible(true);
        addrField.set(peer, new InetSocketAddress(PortAssignment.unique()));
        ZKDatabase zkDb = new ZKDatabase(logFactory);
        LeaderZooKeeperServer zk = new LeaderZooKeeperServer(logFactory, peer, (ZooKeeperServer.DataTreeBuilder)new ZooKeeperServer.BasicDataTreeBuilder(), zkDb);
        return zk;
    }

    class SimpleLearner
    extends Learner {
        SimpleLearner(FileTxnSnapLog ftsl, QuorumPeer learner) throws IOException {
            this.self = learner;
            this.zk = new SimpleLearnerZooKeeperServer(ftsl, this.self);
            ((SimpleLearnerZooKeeperServer)this.zk).learner = this;
        }
    }

    class SimpleLearnerZooKeeperServer
    extends LearnerZooKeeperServer {
        boolean startupCalled;
        Learner learner;

        public SimpleLearnerZooKeeperServer(FileTxnSnapLog ftsl, QuorumPeer self) throws IOException {
            super(ftsl, 2000, 2000, 2000, null, new ZKDatabase(ftsl), self);
        }

        public Learner getLearner() {
            return this.learner;
        }

        public void startup() {
            this.startupCalled = true;
        }
    }

    class SimpleLeader
    extends Leader {
        final CountDownLatch learnerLatch;

        SimpleLeader(QuorumPeer self, LeaderZooKeeperServer zk, CountDownLatch latch) throws IOException {
            super(self, zk);
            this.learnerLatch = latch;
        }

        void addLearnerHandler(LearnerHandler learner) {
            super.addLearnerHandler(learner);
            this.learnerLatch.countDown();
        }
    }

    private static final class NullServerCnxnFactory
    extends ServerCnxnFactory {
        private NullServerCnxnFactory() {
        }

        public void startup(ZooKeeperServer zkServer) throws IOException, InterruptedException {
        }

        public void start() {
        }

        public void shutdown() {
        }

        public void setMaxClientCnxnsPerHost(int max) {
        }

        public void join() throws InterruptedException {
        }

        public int getMaxClientCnxnsPerHost() {
            return 0;
        }

        public int getLocalPort() {
            return 0;
        }

        public InetSocketAddress getLocalAddress() {
            return null;
        }

        public Iterable<ServerCnxn> getConnections() {
            return null;
        }

        public void configure(InetSocketAddress addr, int maxClientCnxns) throws IOException {
        }

        public void closeSession(long sessionId) {
        }

        public void closeAll() {
        }

        public int getNumAliveConnections() {
            return 0;
        }
    }
}

