/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Set;
import org.apache.zookeeper.server.DataNode;
import org.junit.Assert;
import org.junit.Test;

public class DataNodeTest {
    @Test
    public void testGetChildrenShouldReturnEmptySetWhenThereAreNoChidren() {
        DataNode dataNode = new DataNode();
        Set children = dataNode.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
        String child = "child";
        dataNode.addChild(child);
        dataNode.removeChild(child);
        children = dataNode.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
        children = dataNode.getChildren();
        try {
            children.add("new child");
            Assert.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
    }

    @Test
    public void testGetChildrenReturnsImmutableEmptySet() {
        DataNode dataNode = new DataNode();
        Set children = dataNode.getChildren();
        try {
            children.add("new child");
            Assert.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

