/**
 * @file	vstmidievent.h
 * @brief	VST MIDI NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <vector>
#include <pluginterfaces/vst2.x/aeffectx.h>

/**
 * @brief VST MIDI NX
 */
class CVstMidiEvent
{
public:
	CVstMidiEvent();
	~CVstMidiEvent();
	void Clear();
	void ShortMessage(UINT nTick, UINT nMessage);
	void LongMessage(UINT nTick, const void* lpMessage, UINT cbMessage);
	const VstEvents* GetEvents();

protected:

private:
	UINT m_nEvents;							/*!< Cxg */
	std::vector<unsigned char> m_header;	/*!< wb_ */
	std::vector<unsigned char> m_event;		/*!< Cxg */
	void Add(const VstEvent* pEvent, const void* lpMessage = NULL, UINT cbMessage = 0);
};
