/*!
 * @file	threadbase.h
 * @brief	XbhNX̐錾уC^[tFCX̒`܂
 */

#pragma once

/*!
 * @brief XbhNX
 */
class CThreadBase
{
public:
	CThreadBase();
	virtual ~CThreadBase();

	bool Start();
	void Stop();
	bool Restart();
	void SetStackSize(size_t nStackSize);
	static void Delay(unsigned int usec);

protected:
	virtual bool Task() = 0;	//!< Xbh ^XN

private:
	HANDLE m_hThread;			//!< Xbh nh
	DWORD m_dwThreadId;			//!< Xbh ID
	bool m_bAbort;				//!< ftO
	bool m_bDone;				//!< tO
	size_t m_nStackSize;		//!< X^bN TCY
	static unsigned __stdcall ThreadProc(LPVOID pParam);
};

/**
 * X^bN TCY̐ݒ
 * @param[in] nStackSize X^bN TCY
 */
inline void CThreadBase::SetStackSize(size_t nStackSize)
{
	m_nStackSize = nStackSize;
}

/**
 * X[v
 * @param[in] usec }CNb
 */
inline void CThreadBase::Delay(unsigned int usec)
{
	::Sleep((usec + 999) / 1000);
}
