(: Wrapper around eval to set the language to XQuery (rather than XPath) :)
declare function local:eval($tpl) {
  x:eval($tpl, {"language": "xquery"})
};
(: Wrapper around file:write, to write an HTML file rather than an XML file :)
declare function local:write($file, $data, $format){
  file:write($output-dir || $file, $data, 
    <output:serialization-parameters xmlns:output="http://www.w3.org/2010/xslt-xquery-serialization">
      <output:method value="{$format}"/>
    </output:serialization-parameters>
  )
};
(: Function for additional transformations of the content. It does not do anything in this example. :)
declare function local:apply-transformations($node){
  $node
};
(: Returns the name of the HTML file generated by a XML file :)
declare function local:file-url($fileinfo){
  x"{$fileinfo/@base}{ ($fileinfo/extension, ".html")[1] }"
};
declare function local:file-url(){
  local:file-url($fileinfo)
};
(: Load global.xml. (using standard XQuery rather than Xidel's extension variables) :)
declare variable $global := doc("global.xml")/global;
(: This just returns the file names listed in $global. It is very Makefile syntax specific :)
declare function local:deps(){
	 "PAGES := " || join( 
	   for $fi in $global//fileinfo
	   let $url := local:file-url($fi) 
	   where not(contains($url, "//"))
     return ($url) ! ($output-dir || .) )
};
(: This is the final transformation. See the readme :)
declare function local:doit(){ 
  let $inputstyle := "style.xq.html"
  let $format := "html"
  let $file-raw := doc($source || ".xml")/file
  let $style := file:read-text($inputstyle)
  return (
    $fileinfo := $global//fileinfo[@base = $source],
    $file := local:apply-transformations( $file-raw ),
    local:write(local:file-url($fileinfo),  local:eval($style), $format)
  )[0]
};


()