{Copyright (C) [Benito van der Zander]
All rights reserved.

How you can contact me:
  Mail: BeniBela@aol.com
  WWW:  http://www.benibela.de

This program is distributed unter the terms of the MPL license:

"The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NVCanvas.pas, nvHashClass.pas and NVResMan.pas.

The Initial Developer of the Original Code is Benito van der Zander.
All Rights Reserved.

Alternatively, the contents of this file may be used under the terms
of the Gnu Public License Version 2 or higher license (the  "GPL 2 License"), in which case the
provisions of GPL 2 License are applicable instead of those
above. If you wish to allow use of your version of this file only
under the terms of the GPL 2 License and not to allow others to use
your version of this file under the MPL, indicate your decision by
deleting the provisions above and replace them with the notice and
other provisions required by the GPL 2 License. If you do not delete
the provisions above, a recipient may use your version of this file
under either the MPL or the GPL 2 License."}

{21.12: change in TNVHashClass.DeleteHashRec by M. Springwald:
        test for nil}
    

unit NVHashClass;

interface
type
  //Die ID 0 dar nicht verwendet werden!
  PNVHashRec=^TNVHashRec;
  TNVHashRec=record
    id: cardinal;
    wert:cardinal;
    next:PNVHashRec;
  end;
  THashProc=procedure (const id:cardinal;var hash:integer) of object;
  TNVHashClass=class
  protected
    res:array[0..1023] of TNVHashRec;
    function GetHash(const id:cardinal):integer;
  public
    OnGetHash:THashProc;
    function GetHashRec(const id:cardinal):PNVHashRec;
    procedure DeleteHashRec(const id:cardinal);
    function InsertHashRec(const id,wert:cardinal):PNVHashRec;

    constructor Create;
  end;
implementation
//generiert einen Hashcode durch mod und ruft OnGetHash auf, wenn vorhanden
function TNVHashClass.GetHash(const id:cardinal):integer;
begin
  result:=id mod 1024;
  if assigned(OnGetHash) then OnGetHash(id,result);
end;

function TNVHashClass.GetHashRec(const id:cardinal):PNVHashRec;
var i:integer;
begin
  i:=getHash(id);
  result:=@res[i];
  while (result<>nil) and (result^.id<>id) do result:=result^.next;
end;
procedure TNVHashClass.DeleteHashRec(const id:cardinal);
var i:integer;
    pres,prev:PNVHashRec;
begin
  i:=getHash(id);
  pres:=@res[i];
  prev:=nil;
  while (pres<>nil) and (pres^.id<>id) do begin prev:=pres;pres:=pres^.next;end;
  if prev=nil then begin
    if pres^.next=nil then res[i].id:=0
    else res[i]:=pres^.next^;
  end else  
    if pres^.next <> NIl then //suggested by M. Springwald
      prev^:=pres^.next^; 
end;
function TNVHashClass.InsertHashRec(const id,wert:cardinal):PNVHashRec;
var i:integer;
    pres:PNVHashRec;
begin
  i:=getHash(id);
  if res[i].id=0 then begin
    res[i].next:=nil;
    res[i].id:=id;
    res[i].wert:=wert;
    result:=@res[i];
  end else begin
    new(pres);
    pres^.next:=res[i].next;
    pres^.id:=id;
    pres^.wert:=wert;
    res[i].next:=pres;
    result:=pres;
  end;
end;

constructor TNVHashClass.Create;
begin
  inherited;
  OnGetHash:=nil;
  FillChar(res,sizeof(res),0);
end;

end.
