{Copyright (C) [Benito van der Zander]
All rights reserved.

How you can contact me:
  Mail: BeniBela@aol.com
  WWW:  http://www.benibela.de

This program is distributed under the terms of the MPL license:

"The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is NVCanvas.pas, nvHashClass.pas and NVResMan.pas.

The Initial Developer of the Original Code is Benito van der Zander.
A small change was suggested by Michael Springwald.
All Rights Reserved.

Alternatively, the contents of this file may be used under the terms
of the Gnu Public License Version 2 or higher license (the  "GPL 2 License"), in which case the
provisions of GPL 2 License are applicable instead of those
above. If you wish to allow use of your version of this file only
under the terms of the GPL 2 License and not to allow others to use
your version of this file under the MPL, indicate your decision by
deleting the provisions above and replace them with the notice and
other provisions required by the GPL 2 License. If you do not delete
the provisions above, a recipient may use your version of this file
under either the MPL or the GPL 2 License."}
unit NVResMan;

interface
uses windows,NVHashClass;

type TResDeleteProc=procedure (const id:THandle) of object;
type TNVRessourceManager=class (TNVHashClass)
  protected
    function GetHashRec(const id:cardinal):PNVHashRec;
    procedure DeleteHashRec(const id:cardinal);
    function InsertHashRec(const id,wert:cardinal):PNVHashRec;
  public
    OnDelete:TResDeleteProc;
    procedure DeleteRes(const id:THandle);  //Verringert die count Anzahl der entsprechenden ID, und fhrt DeleteProc aus, wenn sie 0 ist
    procedure GetRes(const id:THandle); //Erhht count um 1
    constructor Create;
end;
implementation
function TNVRessourceManager.GetHashRec(const id:cardinal):PNVHashRec; begin result:=inherited GetHashRec(id); end;
procedure TNVRessourceManager.DeleteHashRec(const id:cardinal);begin inherited; end;
function TNVRessourceManager.InsertHashRec(const id,wert:cardinal):PNVHashRec;begin result:=inherited InsertHashRec(id,wert); end;

//Verringert die count Anzahl der entsprechenden ID, und fhrt DeleteProc aus, wenn sie 0 ist
procedure TNVRessourceManager.DeleteRes(const id:THandle);
var pres:PNVHashRec;
begin
  pres:=inherited GetHashRec(id);
  if (pres<>nil) then begin
    dec(pres^.wert);
    if pres^.wert<=0 then begin
      OnDelete(id);
      inherited DeleteHashRec(id);
    end;
  end;
end;

//Erhht count um 1
procedure TNVRessourceManager.GetRes(const id:THandle);
var pres:PNVHashRec;
begin
  pres:=inherited GetHashRec(id);
  if (pres<>nil) then inc(pres^.wert)
  else inherited InsertHashRec(id,1);
end;
constructor TNVRessourceManager.Create;
begin
  inherited;
  OnGetHash:=nil;
  OnDelete:=nil;
  ZeroMemory(@res,sizeof(res));
end;
end.
