{programmiert von BeniBela (Benito van der Zander, BeniBela@aol.com)}
//{$DEFINE UseVCL}
unit NVScreenCanvas;

interface
uses
  Windows, {$IFDEF UseVCL}graphics{$ELSE}NVCanvas{$ENDIF};

type TNVScreenCanvas=class({$IFDEF UseVCL}TCanvas{$ELSE}TNVCanvas{$ENDIF})
  private
    screenSize:TSize;
  public
    procedure MirrowVertical;
    procedure MirrowHorizontal;
    constructor create; {$IFNDEF UseVCL}override;{$ENDIF}

    destructor destroy;override;
end;
implementation
constructor TNVScreenCanvas.create;
begin
  inherited;
  self.Handle := GetWindowDC(GetDesktopWindow);
  screenSize.cx:=GetSystemMetrics(SM_CXSCREEN);
  screenSize.cy:=GetSystemMetrics(SM_CYSCREEN);
end;
procedure TNVScreenCanvas.MirrowVertical;
begin
  StretchBlt(handle, 0, 0, screenSize.cx, screenSize.cy
    , handle, 0, screenSize.cy, screenSize.cx, -screenSize.cy, SRCCOPY);
end;
procedure TNVScreenCanvas.MirrowHorizontal;
begin
  StretchBlt(handle, 0, 0, screenSize.cx, screenSize.cy
    , handle, screenSize.cx, 0, -screenSize.cx, screenSize.cy, SRCCOPY);
end;
destructor TNVScreenCanvas.destroy;
var old:HDC;
begin
  old:=handle;
  Handle:=0;
  ReleaseDC(GetDesktopWindow,old);
  inherited;
end;
end.
