(******************************************************************************
 *                     PUCU Pascal UniCode Utils Libary                       *
 ******************************************************************************
 *                        Version 2016-06-28-05-31-0000                       *
 ******************************************************************************
 *                                zlib license                                *
 *============================================================================*
 *                                                                            *
 * Copyright (C) 2016, Benjamin Rosseaux (benjamin@rosseaux.de)               *
 *                                                                            *
 * This software is provided 'as-is', without any express or implied          *
 * warranty. In no event will the authors be held liable for any damages      *
 * arising from the use of this software.                                     *
 *                                                                            *
 * Permission is granted to anyone to use this software for any purpose,      *
 * including commercial applications, and to alter it and redistribute it     *
 * freely, subject to the following restrictions:                             *
 *                                                                            *
 * 1. The origin of this software must not be misrepresented; you must not    *
 *    claim that you wrote the original software. If you use this software    *
 *    in a product, an acknowledgement in the product documentation would be  *
 *    appreciated but is not required.                                        *
 * 2. Altered source versions must be plainly marked as such, and must not be *
 *    misrepresented as being the original software.                          *
 * 3. This notice may not be removed or altered from any source distribution. *
 *                                                                            *
 ******************************************************************************
 *                  General guidelines for code contributors                  *
 *============================================================================*
 *                                                                            *
 * 1. Make sure you are legally allowed to make a contribution under the zlib *
 *    license.                                                                *
 * 2. The zlib license header goes at the top of each source file, with       *
 *    appropriate copyright notice.                                           *
 * 3. After a pull request, check the status of your pull request on          *
      http://github.com/BeRo1985/pucu                                         *
 * 4. Write code, which is compatible with Delphi 7-XE7 and FreePascal >= 3.0 *
 *    so don't use generics/templates, operator overloading and another newer *
 *    syntax features than Delphi 7 has support for that, but if needed, make *
 *    it out-ifdef-able.                                                      *
 * 5. Don't use Delphi-only, FreePascal-only or Lazarus-only libraries/units, *
 *    but if needed, make it out-ifdef-able.                                  *
 * 6. No use of third-party libraries/units as possible, but if needed, make  *
 *    it out-ifdef-able.                                                      *
 * 7. Try to use const when possible.                                         *
 * 8. Make sure to comment out writeln, used while debugging.                 *
 * 9. Make sure the code compiles on 32-bit and 64-bit platforms (x86-32,     *
 *    x86-64, ARM, ARM64, etc.).                                              *
 *                                                                            *
 ******************************************************************************)
unit PUCU;
{$define PUCUStrictUTF8}
{$ifdef fpc}
 {$mode delphi}
 {$ifdef cpui386}
  {$define cpu386}
 {$endif}
 {$ifdef cpu386}
  {$asmmode intel}
 {$endif}
 {$ifdef cpuamd64}
  {$asmmode intel}
 {$endif}
 {$ifdef FPC_LITTLE_ENDIAN}
  {$define LITTLE_ENDIAN}
 {$else}
  {$ifdef FPC_BIG_ENDIAN}
   {$define BIG_ENDIAN}
  {$endif}
 {$endif}
 {-$pic off}
 {$define CanInline}
 {$ifdef FPC_HAS_TYPE_EXTENDED}
  {$define HAS_TYPE_EXTENDED}
 {$else}
  {$undef HAS_TYPE_EXTENDED}
 {$endif}
 {$ifdef FPC_HAS_TYPE_DOUBLE}
  {$define HAS_TYPE_DOUBLE}
 {$else}
  {$undef HAS_TYPE_DOUBLE}
 {$endif}
 {$ifdef FPC_HAS_TYPE_SINGLE}
  {$define HAS_TYPE_SINGLE}
 {$else}
  {$undef HAS_TYPE_SINGLE}
 {$endif}
 {$if declared(RawByteString)}
  {$define HAS_TYPE_RAWBYTESTRING}
 {$else}
  {$undef HAS_TYPE_RAWBYTESTRING}
 {$ifend}
 {$if declared(UTF8String)}
  {$define HAS_TYPE_UTF8STRING}
 {$else}
  {$undef HAS_TYPE_UTF8STRING}
 {$ifend}
 {$if declared(UnicodeString)}
  {$define HAS_TYPE_UNICODESTRING}
 {$else}
  {$undef HAS_TYPE_UNICODESTRING}
 {$ifend}
{$else}
 {$realcompatibility off}
 {$localsymbols on}
 {$define LITTLE_ENDIAN}
 {$ifndef cpu64}
  {$define cpu32}
 {$endif}
 {$define HAS_TYPE_EXTENDED}
 {$define HAS_TYPE_DOUBLE}
 {$define HAS_TYPE_SINGLE}
 {$ifdef conditionalexpressions}
  {$if declared(RawByteString)}
   {$define HAS_TYPE_RAWBYTESTRING}
  {$else}
   {$undef HAS_TYPE_RAWBYTESTRING}
  {$ifend}
  {$if declared(UTF8String)}
   {$define HAS_TYPE_UTF8STRING}
  {$else}
   {$undef HAS_TYPE_UTF8STRING}
  {$ifend}
  {$if declared(UnicodeString)}
   {$define HAS_TYPE_UNICODESTRING}
  {$else}
   {$undef HAS_TYPE_UNICODESTRING}
  {$ifend}
 {$else}
  {$undef HAS_TYPE_RAWBYTESTRING}
  {$undef HAS_TYPE_UTF8STRING}
  {$undef HAS_TYPE_UNICODESTRING}
 {$endif}
 {$ifndef BCB}
  {$ifdef ver120}
   {$define Delphi4or5}
  {$endif}
  {$ifdef ver130}
   {$define Delphi4or5}
  {$endif}
  {$ifdef ver140}
   {$define Delphi6}
  {$endif}
  {$ifdef ver150}
   {$define Delphi7}
  {$endif}
  {$ifdef ver170}
   {$define Delphi2005}
  {$endif}
 {$else}
  {$ifdef ver120}
   {$define Delphi4or5}
   {$define BCB4}
  {$endif}
  {$ifdef ver130}
   {$define Delphi4or5}
  {$endif}
 {$endif}
 {$ifdef conditionalexpressions}
  {$if CompilerVersion>=24}
   {$legacyifend on}
  {$ifend}
  {$if CompilerVersion>=14.0}
   {$if CompilerVersion=14.0}
    {$define Delphi6}
   {$ifend}
   {$define Delphi6AndUp}
  {$ifend}
  {$if CompilerVersion>=15.0}
   {$if CompilerVersion=15.0}
    {$define Delphi7}
   {$ifend}
   {$define Delphi7AndUp}
  {$ifend}
  {$if CompilerVersion>=17.0}
   {$if CompilerVersion=17.0}
    {$define Delphi2005}
   {$ifend}
   {$define Delphi2005AndUp}
  {$ifend}
  {$if CompilerVersion>=18.0}
   {$if CompilerVersion=18.0}
    {$define BDS2006}
    {$define Delphi2006}
   {$ifend}
   {$define Delphi2006AndUp}
  {$ifend}
  {$if CompilerVersion>=18.5}
   {$if CompilerVersion=18.5}
    {$define Delphi2007}
   {$ifend}
   {$define Delphi2007AndUp}
  {$ifend}
  {$if CompilerVersion=19.0}
   {$define Delphi2007Net}
  {$ifend}
  {$if CompilerVersion>=20.0}
   {$if CompilerVersion=20.0}
    {$define Delphi2009}
   {$ifend}
   {$define Delphi2009AndUp}
  {$ifend}
  {$if CompilerVersion>=21.0}
   {$if CompilerVersion=21.0}
    {$define Delphi2010}
   {$ifend}
   {$define Delphi2010AndUp}
  {$ifend}
  {$if CompilerVersion>=22.0}
   {$if CompilerVersion=22.0}
    {$define DelphiXE}
   {$ifend}
   {$define DelphiXEAndUp}
  {$ifend}
  {$if CompilerVersion>=23.0}
   {$if CompilerVersion=23.0}
    {$define DelphiXE2}
   {$ifend}
   {$define DelphiXE2AndUp}
  {$ifend}
  {$if CompilerVersion>=24.0}
   {$if CompilerVersion=24.0}
    {$define DelphiXE3}
   {$ifend}
   {$define DelphiXE3AndUp}
  {$ifend}
  {$if CompilerVersion>=25.0}
   {$if CompilerVersion=25.0}
    {$define DelphiXE4}
   {$ifend}
   {$define DelphiXE4AndUp}
  {$ifend}
  {$if CompilerVersion>=26.0}
   {$if CompilerVersion=26.0}
    {$define DelphiXE5}
   {$ifend}
   {$define DelphiXE5AndUp}
  {$ifend}
  {$if CompilerVersion>=27.0}
   {$if CompilerVersion=27.0}
    {$define DelphiXE6}
   {$ifend}
   {$define DelphiXE6AndUp}
  {$ifend}
  {$if CompilerVersion>=28.0}
   {$if CompilerVersion=28.0}
    {$define DelphiXE7}
   {$ifend}
   {$define DelphiXE7AndUp}
  {$ifend}
  {$if CompilerVersion>=29.0}
   {$if CompilerVersion=29.0}
    {$define DelphiXE8}
   {$ifend}
   {$define DelphiXE8AndUp}
  {$ifend}
  {$if CompilerVersion>=30.0}
   {$if CompilerVersion=30.0}
    {$define Delphi10Seattle}
   {$ifend}
   {$define Delphi10SeattleAndUp}
  {$ifend}
  {$if CompilerVersion>=31.0}
   {$if CompilerVersion=31.0}
    {$define Delphi10Berlin}
   {$ifend}
   {$define Delphi10BerlinAndUp}
  {$ifend}
 {$endif}
 {$ifndef Delphi4or5}
  {$ifndef BCB}
   {$define Delphi6AndUp}
  {$endif}
   {$ifndef Delphi6}
    {$define BCB6OrDelphi7AndUp}
    {$ifndef BCB}
     {$define Delphi7AndUp}
    {$endif}
    {$ifndef BCB}
     {$ifndef Delphi7}
      {$ifndef Delphi2005}
       {$define BDS2006AndUp}
      {$endif}
     {$endif}
    {$endif}
   {$endif}
 {$endif}
 {$ifdef Delphi6AndUp}
  {$warn symbol_platform off}
  {$warn symbol_deprecated off}
 {$endif}
{$endif}
{$ifdef win32}
 {$define windows}
{$endif}
{$ifdef win64}
 {$define windows}
{$endif}
{$ifdef wince}
 {$define windows}
{$endif}
{$rangechecks off}
{$extendedsyntax on}
{$writeableconst on}
{$hints off}
{$booleval off}
{$typedaddress off}
{$stackframes off}
{$varstringchecks on}
{$typeinfo on}
{$overflowchecks off}
{$longstrings on}
{$openstrings on}

interface

uses SysUtils,Classes;

const suDONOTKNOW=-1;
      suNOUTF8=0;
      suPOSSIBLEUTF8=1;
      suISUTF8=2;

      ucACCEPT=0;
      ucERROR=16;

      cpLATIN1=28591;
      cpISO_8859_1=28591;

      cpUTF16LE=1200;
      cpUTF16BE=1200;

      cpUTF7=65000;
      cpUTF8=65001;

type PPUCUInt8=^TPUCUInt8;
     TPUCUInt8={$ifdef fpc}Int8{$else}ShortInt{$endif};

     PPUCUUInt8=^TPUCUUInt8;
     TPUCUUInt8={$ifdef fpc}UInt8{$else}Byte{$endif};

     PPUCUInt16=^TPUCUInt16;
     TPUCUInt16={$ifdef fpc}Int16{$else}SmallInt{$endif};

     PPUCUUInt16=^TPUCUUInt16;
     TPUCUUInt16={$ifdef fpc}UInt16{$else}Word{$endif};

     PPUCUInt32=^TPUCUInt32;
     TPUCUInt32={$ifdef fpc}Int32{$else}LongInt{$endif};

     PPUCUUInt32=^TPUCUUInt32;
     TPUCUUInt32={$ifdef fpc}UInt32{$else}LongWord{$endif};

     PPUCUInt64=^TPUCUInt64;
     TPUCUInt64=Int64;

     PPUCUUInt64=^TPUCUUInt64;
     TPUCUUInt64=UInt64;

     PPUCUPtrUInt=^TPUCUPtrUInt;
     PPUCUPtrInt=^TPUCUPtrInt;

{$ifdef fpc}
     TPUCUPtrUInt=PtrUInt;
     TPUCUPtrInt=PtrInt;
{$else}
{$if Declared(CompilerVersion) and (CompilerVersion>=23.0)}
     TPUCUPtrUInt=NativeUInt;
     TPUCUPtrInt=NativeInt;
{$else}
{$ifdef cpu64}
     TPUCUPtrUInt=UInt64;
     TPUCUPtrInt=int64;
{$else}
     TPUCUPtrUInt=TPUCUUInt32;
     TPUCUPtrInt=TPUCUInt32;
{$endif}
{$ifend}
{$endif}

     PPUCUNativeUInt=^TPUCUNativeUInt;
     PPUCUNativeInt=^TPUCUNativeInt;
     TPUCUNativeUInt=TPUCUPtrUInt;
     TPUCUNativeInt=TPUCUPtrInt;

     PPUCURawByteChar=PAnsiChar;
     TPUCURawByteChar=AnsiChar;

     PPUCURawByteCharSet=^TPUCURawByteCharSet;
     TPUCURawByteCharSet=set of TPUCURawByteChar;

     PPUCURawByteString=^TPUCURawByteString;
     TPUCURawByteString={$ifdef HAS_TYPE_RAWBYTESTRING}RawByteString{$else}AnsiString{$endif};

     PPUCUUTF8Char=PAnsiChar;
     TPUCUUTF8Char=AnsiChar;

     PPUCUUTF8String=^TPUCUUTF8String;
     TPUCUUTF8String={$ifdef HAS_TYPE_UTF8STRING}UTF8String{$else}AnsiString{$endif};

     PPUCUUTF16Char={$ifdef HAS_TYPE_UNICODESTRING}{$ifdef fpc}PUnicodeChar{$else}PWideChar{$endif}{$else}PWideChar{$endif};
     TPUCUUTF16Char={$ifdef HAS_TYPE_UNICODESTRING}{$ifdef fpc}UnicodeChar{$else}WideChar{$endif}{$else}WideChar{$endif};

     PPUCUUTF16String=^TPUCUUTF16String;
     TPUCUUTF16String={$ifdef HAS_TYPE_UNICODESTRING}UnicodeString{$else}WideString{$endif};

     PPUCUUTF32Char=^TPUCUUTF32Char;
     TPUCUUTF32Char=TPUCUUInt32;

     TPUCUUTF32String=array of TPUCUUTF32Char;

type TPUCUUnicodeBlock=record
      Name:TPUCURawByteString;
      FromChar,ToChar:longword;
     end;
const PUCUUnicodeBlockCount=273;
      PUCUUnicodeBlocks:array[0..272] of TPUCUUnicodeBlock=(
       (Name:'Basic Latin';FromChar:0;ToChar:127),
       (Name:'Latin-1 Supplement';FromChar:128;ToChar:255),
       (Name:'Latin Extended-A';FromChar:256;ToChar:383),
       (Name:'Latin Extended-B';FromChar:384;ToChar:591),
       (Name:'IPA Extensions';FromChar:592;ToChar:687),
       (Name:'Spacing Modifier Letters';FromChar:688;ToChar:767),
       (Name:'Combining Diacritical Marks';FromChar:768;ToChar:879),
       (Name:'Greek and Coptic';FromChar:880;ToChar:1023),
       (Name:'Cyrillic';FromChar:1024;ToChar:1279),
       (Name:'Cyrillic Supplement';FromChar:1280;ToChar:1327),
       (Name:'Armenian';FromChar:1328;ToChar:1423),
       (Name:'Hebrew';FromChar:1424;ToChar:1535),
       (Name:'Arabic';FromChar:1536;ToChar:1791),
       (Name:'Syriac';FromChar:1792;ToChar:1871),
       (Name:'Arabic Supplement';FromChar:1872;ToChar:1919),
       (Name:'Thaana';FromChar:1920;ToChar:1983),
       (Name:'NKo';FromChar:1984;ToChar:2047),
       (Name:'Samaritan';FromChar:2048;ToChar:2111),
       (Name:'Mandaic';FromChar:2112;ToChar:2143),
       (Name:'Arabic Extended-A';FromChar:2208;ToChar:2303),
       (Name:'Devanagari';FromChar:2304;ToChar:2431),
       (Name:'Bengali';FromChar:2432;ToChar:2559),
       (Name:'Gurmukhi';FromChar:2560;ToChar:2687),
       (Name:'Gujarati';FromChar:2688;ToChar:2815),
       (Name:'Oriya';FromChar:2816;ToChar:2943),
       (Name:'Tamil';FromChar:2944;ToChar:3071),
       (Name:'Telugu';FromChar:3072;ToChar:3199),
       (Name:'Kannada';FromChar:3200;ToChar:3327),
       (Name:'Malayalam';FromChar:3328;ToChar:3455),
       (Name:'Sinhala';FromChar:3456;ToChar:3583),
       (Name:'Thai';FromChar:3584;ToChar:3711),
       (Name:'Lao';FromChar:3712;ToChar:3839),
       (Name:'Tibetan';FromChar:3840;ToChar:4095),
       (Name:'Myanmar';FromChar:4096;ToChar:4255),
       (Name:'Georgian';FromChar:4256;ToChar:4351),
       (Name:'Hangul Jamo';FromChar:4352;ToChar:4607),
       (Name:'Ethiopic';FromChar:4608;ToChar:4991),
       (Name:'Ethiopic Supplement';FromChar:4992;ToChar:5023),
       (Name:'Cherokee';FromChar:5024;ToChar:5119),
       (Name:'Unified Canadian Aboriginal Syllabics';FromChar:5120;ToChar:5759),
       (Name:'Ogham';FromChar:5760;ToChar:5791),
       (Name:'Runic';FromChar:5792;ToChar:5887),
       (Name:'Tagalog';FromChar:5888;ToChar:5919),
       (Name:'Hanunoo';FromChar:5920;ToChar:5951),
       (Name:'Buhid';FromChar:5952;ToChar:5983),
       (Name:'Tagbanwa';FromChar:5984;ToChar:6015),
       (Name:'Khmer';FromChar:6016;ToChar:6143),
       (Name:'Mongolian';FromChar:6144;ToChar:6319),
       (Name:'Unified Canadian Aboriginal Syllabics Extended';FromChar:6320;ToChar:6399),
       (Name:'Limbu';FromChar:6400;ToChar:6479),
       (Name:'Tai Le';FromChar:6480;ToChar:6527),
       (Name:'New Tai Lue';FromChar:6528;ToChar:6623),
       (Name:'Khmer Symbols';FromChar:6624;ToChar:6655),
       (Name:'Buginese';FromChar:6656;ToChar:6687),
       (Name:'Tai Tham';FromChar:6688;ToChar:6831),
       (Name:'Combining Diacritical Marks Extended';FromChar:6832;ToChar:6911),
       (Name:'Balinese';FromChar:6912;ToChar:7039),
       (Name:'Sundanese';FromChar:7040;ToChar:7103),
       (Name:'Batak';FromChar:7104;ToChar:7167),
       (Name:'Lepcha';FromChar:7168;ToChar:7247),
       (Name:'Ol Chiki';FromChar:7248;ToChar:7295),
       (Name:'Cyrillic Extended-C';FromChar:7296;ToChar:7311),
       (Name:'Sundanese Supplement';FromChar:7360;ToChar:7375),
       (Name:'Vedic Extensions';FromChar:7376;ToChar:7423),
       (Name:'Phonetic Extensions';FromChar:7424;ToChar:7551),
       (Name:'Phonetic Extensions Supplement';FromChar:7552;ToChar:7615),
       (Name:'Combining Diacritical Marks Supplement';FromChar:7616;ToChar:7679),
       (Name:'Latin Extended Additional';FromChar:7680;ToChar:7935),
       (Name:'Greek Extended';FromChar:7936;ToChar:8191),
       (Name:'General Punctuation';FromChar:8192;ToChar:8303),
       (Name:'Superscripts and Subscripts';FromChar:8304;ToChar:8351),
       (Name:'Currency Symbols';FromChar:8352;ToChar:8399),
       (Name:'Combining Diacritical Marks for Symbols';FromChar:8400;ToChar:8447),
       (Name:'Letterlike Symbols';FromChar:8448;ToChar:8527),
       (Name:'Number Forms';FromChar:8528;ToChar:8591),
       (Name:'Arrows';FromChar:8592;ToChar:8703),
       (Name:'Mathematical Operators';FromChar:8704;ToChar:8959),
       (Name:'Miscellaneous Technical';FromChar:8960;ToChar:9215),
       (Name:'Control Pictures';FromChar:9216;ToChar:9279),
       (Name:'Optical Character Recognition';FromChar:9280;ToChar:9311),
       (Name:'Enclosed Alphanumerics';FromChar:9312;ToChar:9471),
       (Name:'Box Drawing';FromChar:9472;ToChar:9599),
       (Name:'Block Elements';FromChar:9600;ToChar:9631),
       (Name:'Geometric Shapes';FromChar:9632;ToChar:9727),
       (Name:'Miscellaneous Symbols';FromChar:9728;ToChar:9983),
       (Name:'Dingbats';FromChar:9984;ToChar:10175),
       (Name:'Miscellaneous Mathematical Symbols-A';FromChar:10176;ToChar:10223),
       (Name:'Supplemental Arrows-A';FromChar:10224;ToChar:10239),
       (Name:'Braille Patterns';FromChar:10240;ToChar:10495),
       (Name:'Supplemental Arrows-B';FromChar:10496;ToChar:10623),
       (Name:'Miscellaneous Mathematical Symbols-B';FromChar:10624;ToChar:10751),
       (Name:'Supplemental Mathematical Operators';FromChar:10752;ToChar:11007),
       (Name:'Miscellaneous Symbols and Arrows';FromChar:11008;ToChar:11263),
       (Name:'Glagolitic';FromChar:11264;ToChar:11359),
       (Name:'Latin Extended-C';FromChar:11360;ToChar:11391),
       (Name:'Coptic';FromChar:11392;ToChar:11519),
       (Name:'Georgian Supplement';FromChar:11520;ToChar:11567),
       (Name:'Tifinagh';FromChar:11568;ToChar:11647),
       (Name:'Ethiopic Extended';FromChar:11648;ToChar:11743),
       (Name:'Cyrillic Extended-A';FromChar:11744;ToChar:11775),
       (Name:'Supplemental Punctuation';FromChar:11776;ToChar:11903),
       (Name:'CJK Radicals Supplement';FromChar:11904;ToChar:12031),
       (Name:'Kangxi Radicals';FromChar:12032;ToChar:12255),
       (Name:'Ideographic Description Characters';FromChar:12272;ToChar:12287),
       (Name:'CJK Symbols and Punctuation';FromChar:12288;ToChar:12351),
       (Name:'Hiragana';FromChar:12352;ToChar:12447),
       (Name:'Katakana';FromChar:12448;ToChar:12543),
       (Name:'Bopomofo';FromChar:12544;ToChar:12591),
       (Name:'Hangul Compatibility Jamo';FromChar:12592;ToChar:12687),
       (Name:'Kanbun';FromChar:12688;ToChar:12703),
       (Name:'Bopomofo Extended';FromChar:12704;ToChar:12735),
       (Name:'CJK Strokes';FromChar:12736;ToChar:12783),
       (Name:'Katakana Phonetic Extensions';FromChar:12784;ToChar:12799),
       (Name:'Enclosed CJK Letters and Months';FromChar:12800;ToChar:13055),
       (Name:'CJK Compatibility';FromChar:13056;ToChar:13311),
       (Name:'CJK Unified Ideographs Extension A';FromChar:13312;ToChar:19903),
       (Name:'Yijing Hexagram Symbols';FromChar:19904;ToChar:19967),
       (Name:'CJK Unified Ideographs';FromChar:19968;ToChar:40959),
       (Name:'Yi Syllables';FromChar:40960;ToChar:42127),
       (Name:'Yi Radicals';FromChar:42128;ToChar:42191),
       (Name:'Lisu';FromChar:42192;ToChar:42239),
       (Name:'Vai';FromChar:42240;ToChar:42559),
       (Name:'Cyrillic Extended-B';FromChar:42560;ToChar:42655),
       (Name:'Bamum';FromChar:42656;ToChar:42751),
       (Name:'Modifier Tone Letters';FromChar:42752;ToChar:42783),
       (Name:'Latin Extended-D';FromChar:42784;ToChar:43007),
       (Name:'Syloti Nagri';FromChar:43008;ToChar:43055),
       (Name:'Common Indic Number Forms';FromChar:43056;ToChar:43071),
       (Name:'Phags-pa';FromChar:43072;ToChar:43135),
       (Name:'Saurashtra';FromChar:43136;ToChar:43231),
       (Name:'Devanagari Extended';FromChar:43232;ToChar:43263),
       (Name:'Kayah Li';FromChar:43264;ToChar:43311),
       (Name:'Rejang';FromChar:43312;ToChar:43359),
       (Name:'Hangul Jamo Extended-A';FromChar:43360;ToChar:43391),
       (Name:'Javanese';FromChar:43392;ToChar:43487),
       (Name:'Myanmar Extended-B';FromChar:43488;ToChar:43519),
       (Name:'Cham';FromChar:43520;ToChar:43615),
       (Name:'Myanmar Extended-A';FromChar:43616;ToChar:43647),
       (Name:'Tai Viet';FromChar:43648;ToChar:43743),
       (Name:'Meetei Mayek Extensions';FromChar:43744;ToChar:43775),
       (Name:'Ethiopic Extended-A';FromChar:43776;ToChar:43823),
       (Name:'Latin Extended-E';FromChar:43824;ToChar:43887),
       (Name:'Cherokee Supplement';FromChar:43888;ToChar:43967),
       (Name:'Meetei Mayek';FromChar:43968;ToChar:44031),
       (Name:'Hangul Syllables';FromChar:44032;ToChar:55215),
       (Name:'Hangul Jamo Extended-B';FromChar:55216;ToChar:55295),
       (Name:'High Surrogates';FromChar:55296;ToChar:56191),
       (Name:'High Private Use Surrogates';FromChar:56192;ToChar:56319),
       (Name:'Low Surrogates';FromChar:56320;ToChar:57343),
       (Name:'Private Use Area';FromChar:57344;ToChar:63743),
       (Name:'CJK Compatibility Ideographs';FromChar:63744;ToChar:64255),
       (Name:'Alphabetic Presentation Forms';FromChar:64256;ToChar:64335),
       (Name:'Arabic Presentation Forms-A';FromChar:64336;ToChar:65023),
       (Name:'Variation Selectors';FromChar:65024;ToChar:65039),
       (Name:'Vertical Forms';FromChar:65040;ToChar:65055),
       (Name:'Combining Half Marks';FromChar:65056;ToChar:65071),
       (Name:'CJK Compatibility Forms';FromChar:65072;ToChar:65103),
       (Name:'Small Form Variants';FromChar:65104;ToChar:65135),
       (Name:'Arabic Presentation Forms-B';FromChar:65136;ToChar:65279),
       (Name:'Halfwidth and Fullwidth Forms';FromChar:65280;ToChar:65519),
       (Name:'Specials';FromChar:65520;ToChar:65535),
       (Name:'Linear B Syllabary';FromChar:65536;ToChar:65663),
       (Name:'Linear B Ideograms';FromChar:65664;ToChar:65791),
       (Name:'Aegean Numbers';FromChar:65792;ToChar:65855),
       (Name:'Ancient Greek Numbers';FromChar:65856;ToChar:65935),
       (Name:'Ancient Symbols';FromChar:65936;ToChar:65999),
       (Name:'Phaistos Disc';FromChar:66000;ToChar:66047),
       (Name:'Lycian';FromChar:66176;ToChar:66207),
       (Name:'Carian';FromChar:66208;ToChar:66271),
       (Name:'Coptic Epact Numbers';FromChar:66272;ToChar:66303),
       (Name:'Old Italic';FromChar:66304;ToChar:66351),
       (Name:'Gothic';FromChar:66352;ToChar:66383),
       (Name:'Old Permic';FromChar:66384;ToChar:66431),
       (Name:'Ugaritic';FromChar:66432;ToChar:66463),
       (Name:'Old Persian';FromChar:66464;ToChar:66527),
       (Name:'Deseret';FromChar:66560;ToChar:66639),
       (Name:'Shavian';FromChar:66640;ToChar:66687),
       (Name:'Osmanya';FromChar:66688;ToChar:66735),
       (Name:'Osage';FromChar:66736;ToChar:66815),
       (Name:'Elbasan';FromChar:66816;ToChar:66863),
       (Name:'Caucasian Albanian';FromChar:66864;ToChar:66927),
       (Name:'Linear A';FromChar:67072;ToChar:67455),
       (Name:'Cypriot Syllabary';FromChar:67584;ToChar:67647),
       (Name:'Imperial Aramaic';FromChar:67648;ToChar:67679),
       (Name:'Palmyrene';FromChar:67680;ToChar:67711),
       (Name:'Nabataean';FromChar:67712;ToChar:67759),
       (Name:'Hatran';FromChar:67808;ToChar:67839),
       (Name:'Phoenician';FromChar:67840;ToChar:67871),
       (Name:'Lydian';FromChar:67872;ToChar:67903),
       (Name:'Meroitic Hieroglyphs';FromChar:67968;ToChar:67999),
       (Name:'Meroitic Cursive';FromChar:68000;ToChar:68095),
       (Name:'Kharoshthi';FromChar:68096;ToChar:68191),
       (Name:'Old South Arabian';FromChar:68192;ToChar:68223),
       (Name:'Old North Arabian';FromChar:68224;ToChar:68255),
       (Name:'Manichaean';FromChar:68288;ToChar:68351),
       (Name:'Avestan';FromChar:68352;ToChar:68415),
       (Name:'Inscriptional Parthian';FromChar:68416;ToChar:68447),
       (Name:'Inscriptional Pahlavi';FromChar:68448;ToChar:68479),
       (Name:'Psalter Pahlavi';FromChar:68480;ToChar:68527),
       (Name:'Old Turkic';FromChar:68608;ToChar:68687),
       (Name:'Old Hungarian';FromChar:68736;ToChar:68863),
       (Name:'Rumi Numeral Symbols';FromChar:69216;ToChar:69247),
       (Name:'Brahmi';FromChar:69632;ToChar:69759),
       (Name:'Kaithi';FromChar:69760;ToChar:69839),
       (Name:'Sora Sompeng';FromChar:69840;ToChar:69887),
       (Name:'Chakma';FromChar:69888;ToChar:69967),
       (Name:'Mahajani';FromChar:69968;ToChar:70015),
       (Name:'Sharada';FromChar:70016;ToChar:70111),
       (Name:'Sinhala Archaic Numbers';FromChar:70112;ToChar:70143),
       (Name:'Khojki';FromChar:70144;ToChar:70223),
       (Name:'Multani';FromChar:70272;ToChar:70319),
       (Name:'Khudawadi';FromChar:70320;ToChar:70399),
       (Name:'Grantha';FromChar:70400;ToChar:70527),
       (Name:'Newa';FromChar:70656;ToChar:70783),
       (Name:'Tirhuta';FromChar:70784;ToChar:70879),
       (Name:'Siddham';FromChar:71040;ToChar:71167),
       (Name:'Modi';FromChar:71168;ToChar:71263),
       (Name:'Mongolian Supplement';FromChar:71264;ToChar:71295),
       (Name:'Takri';FromChar:71296;ToChar:71375),
       (Name:'Ahom';FromChar:71424;ToChar:71487),
       (Name:'Warang Citi';FromChar:71840;ToChar:71935),
       (Name:'Pau Cin Hau';FromChar:72384;ToChar:72447),
       (Name:'Bhaiksuki';FromChar:72704;ToChar:72815),
       (Name:'Marchen';FromChar:72816;ToChar:72895),
       (Name:'Cuneiform';FromChar:73728;ToChar:74751),
       (Name:'Cuneiform Numbers and Punctuation';FromChar:74752;ToChar:74879),
       (Name:'Early Dynastic Cuneiform';FromChar:74880;ToChar:75087),
       (Name:'Egyptian Hieroglyphs';FromChar:77824;ToChar:78895),
       (Name:'Anatolian Hieroglyphs';FromChar:82944;ToChar:83583),
       (Name:'Bamum Supplement';FromChar:92160;ToChar:92735),
       (Name:'Mro';FromChar:92736;ToChar:92783),
       (Name:'Bassa Vah';FromChar:92880;ToChar:92927),
       (Name:'Pahawh Hmong';FromChar:92928;ToChar:93071),
       (Name:'Miao';FromChar:93952;ToChar:94111),
       (Name:'Ideographic Symbols and Punctuation';FromChar:94176;ToChar:94207),
       (Name:'Tangut';FromChar:94208;ToChar:100351),
       (Name:'Tangut Components';FromChar:100352;ToChar:101119),
       (Name:'Kana Supplement';FromChar:110592;ToChar:110847),
       (Name:'Duployan';FromChar:113664;ToChar:113823),
       (Name:'Shorthand Format Controls';FromChar:113824;ToChar:113839),
       (Name:'Byzantine Musical Symbols';FromChar:118784;ToChar:119039),
       (Name:'Musical Symbols';FromChar:119040;ToChar:119295),
       (Name:'Ancient Greek Musical Notation';FromChar:119296;ToChar:119375),
       (Name:'Tai Xuan Jing Symbols';FromChar:119552;ToChar:119647),
       (Name:'Counting Rod Numerals';FromChar:119648;ToChar:119679),
       (Name:'Mathematical Alphanumeric Symbols';FromChar:119808;ToChar:120831),
       (Name:'Sutton SignWriting';FromChar:120832;ToChar:121519),
       (Name:'Glagolitic Supplement';FromChar:122880;ToChar:122927),
       (Name:'Mende Kikakui';FromChar:124928;ToChar:125151),
       (Name:'Adlam';FromChar:125184;ToChar:125279),
       (Name:'Arabic Mathematical Alphabetic Symbols';FromChar:126464;ToChar:126719),
       (Name:'Mahjong Tiles';FromChar:126976;ToChar:127023),
       (Name:'Domino Tiles';FromChar:127024;ToChar:127135),
       (Name:'Playing Cards';FromChar:127136;ToChar:127231),
       (Name:'Enclosed Alphanumeric Supplement';FromChar:127232;ToChar:127487),
       (Name:'Enclosed Ideographic Supplement';FromChar:127488;ToChar:127743),
       (Name:'Miscellaneous Symbols and Pictographs';FromChar:127744;ToChar:128511),
       (Name:'Emoticons';FromChar:128512;ToChar:128591),
       (Name:'Ornamental Dingbats';FromChar:128592;ToChar:128639),
       (Name:'Transport and Map Symbols';FromChar:128640;ToChar:128767),
       (Name:'Alchemical Symbols';FromChar:128768;ToChar:128895),
       (Name:'Geometric Shapes Extended';FromChar:128896;ToChar:129023),
       (Name:'Supplemental Arrows-C';FromChar:129024;ToChar:129279),
       (Name:'Supplemental Symbols and Pictographs';FromChar:129280;ToChar:129535),
       (Name:'CJK Unified Ideographs Extension B';FromChar:131072;ToChar:173791),
       (Name:'CJK Unified Ideographs Extension C';FromChar:173824;ToChar:177983),
       (Name:'CJK Unified Ideographs Extension D';FromChar:177984;ToChar:178207),
       (Name:'CJK Unified Ideographs Extension E';FromChar:178208;ToChar:183983),
       (Name:'CJK Compatibility Ideographs Supplement';FromChar:194560;ToChar:195103),
       (Name:'Tags';FromChar:917504;ToChar:917631),
       (Name:'Variation Selectors Supplement';FromChar:917760;ToChar:917999),
       (Name:'Supplementary Private Use Area-A';FromChar:983040;ToChar:1048575),
       (Name:'Supplementary Private Use Area-B';FromChar:1048576;ToChar:1114111));

const PUCUUnicodeCategoryIDs:array[0..29] of TPUCURawByteString=(
'Cn',
'Lu',
'Ll',
'Lt',
'Lm',
'Lo',
'Mn',
'Me',
'Mc',
'Nd',
'Nl',
'No',
'Zs',
'Zl',
'Zp',
'Cc',
'Cf',
'Co',
'Cs',
'Pd',
'Ps',
'Pe',
'Pc',
'Po',
'Sm',
'Sc',
'Sk',
'So',
'Pi',
'Pf'
);
      PUCUUnicodeCategoryCn=0;
      PUCUUnicodeCategoryLu=1;
      PUCUUnicodeCategoryLl=2;
      PUCUUnicodeCategoryLt=3;
      PUCUUnicodeCategoryLm=4;
      PUCUUnicodeCategoryLo=5;
      PUCUUnicodeCategoryMn=6;
      PUCUUnicodeCategoryMe=7;
      PUCUUnicodeCategoryMc=8;
      PUCUUnicodeCategoryNd=9;
      PUCUUnicodeCategoryNl=10;
      PUCUUnicodeCategoryNo=11;
      PUCUUnicodeCategoryZs=12;
      PUCUUnicodeCategoryZl=13;
      PUCUUnicodeCategoryZp=14;
      PUCUUnicodeCategoryCc=15;
      PUCUUnicodeCategoryCf=16;
      PUCUUnicodeCategoryCo=17;
      PUCUUnicodeCategoryCs=18;
      PUCUUnicodeCategoryPd=19;
      PUCUUnicodeCategoryPs=20;
      PUCUUnicodeCategoryPe=21;
      PUCUUnicodeCategoryPc=22;
      PUCUUnicodeCategoryPo=23;
      PUCUUnicodeCategorySm=24;
      PUCUUnicodeCategorySc=25;
      PUCUUnicodeCategorySk=26;
      PUCUUnicodeCategorySo=27;
      PUCUUnicodeCategoryPi=28;
      PUCUUnicodeCategoryPf=29;
      PUCUUnicodeCategoryCount=30;
      PUCU_CT_UNASSIGNED=PUCUUnicodeCategoryCn;
      PUCU_CT_UPPERCASE_LETTER=PUCUUnicodeCategoryLu;
      PUCU_CT_LOWERCASE_LETTER=PUCUUnicodeCategoryLl;
      PUCU_CT_TITLECASE_LETTER=PUCUUnicodeCategoryLt;
      PUCU_CT_MODIFIER_LETTER=PUCUUnicodeCategoryLm;
      PUCU_CT_OTHER_LETTER=PUCUUnicodeCategoryLo;
      PUCU_CT_NON_SPACING_MARK=PUCUUnicodeCategoryMn;
      PUCU_CT_ENCLOSING_MARK=PUCUUnicodeCategoryMe;
      PUCU_CT_COMBINING_SPACING_MARK=PUCUUnicodeCategoryMc;
      PUCU_CT_DECIMAL_DIGIT_NUMBER=PUCUUnicodeCategoryNd;
      PUCU_CT_LETTER_NUMBER=PUCUUnicodeCategoryNl;
      PUCU_CT_OTHER_NUMBER=PUCUUnicodeCategoryNo;
      PUCU_CT_SPACE_SEPARATOR=PUCUUnicodeCategoryZs;
      PUCU_CT_LINE_SEPARATOR=PUCUUnicodeCategoryZl;
      PUCU_CT_PARAGRAPH_SEPARATOR=PUCUUnicodeCategoryZp;
      PUCU_CT_CONTROL=PUCUUnicodeCategoryCc;
      PUCU_CT_FORMAT=PUCUUnicodeCategoryCf;
      PUCU_CT_PRIVATE_USE=PUCUUnicodeCategoryCo;
      PUCU_CT_SURROGATE=PUCUUnicodeCategoryCs;
      PUCU_CT_DASH_PUNCTUATION=PUCUUnicodeCategoryPd;
      PUCU_CT_START_PUNCTUATION=PUCUUnicodeCategoryPs;
      PUCU_CT_END_PUNCTUATION=PUCUUnicodeCategoryPe;
      PUCU_CT_INITIAL_PUNCTUATION=PUCUUnicodeCategoryPi;
      PUCU_CT_FINAL_PUNCTUATION=PUCUUnicodeCategoryPf;
      PUCU_CT_CONNECTOR_PUNCTUATION=PUCUUnicodeCategoryPc;
      PUCU_CT_OTHER_PUNCTUATION=PUCUUnicodeCategoryPo;
      PUCU_CT_MATH_SYMBOL=PUCUUnicodeCategorySm;
      PUCU_CT_CURRENCY_SYMBOL=PUCUUnicodeCategorySc;
      PUCU_CT_MODIFIER_SYMBOL=PUCUUnicodeCategorySk;
      PUCU_CT_OTHER_SYMBOL=PUCUUnicodeCategorySo;

const PUCUUnicodeScriptIDs:array[0..137] of TPUCURawByteString=(
'Unknown',
'Common',
'Latin',
'Greek',
'Cyrillic',
'Armenian',
'Hebrew',
'Arabic',
'Syriac',
'Thaana',
'Devanagari',
'Bengali',
'Gurmukhi',
'Gujarati',
'Oriya',
'Tamil',
'Telugu',
'Kannada',
'Malayalam',
'Sinhala',
'Thai',
'Lao',
'Tibetan',
'Myanmar',
'Georgian',
'Hangul',
'Ethiopic',
'Cherokee',
'Canadian_Aboriginal',
'Ogham',
'Runic',
'Khmer',
'Mongolian',
'Hiragana',
'Katakana',
'Bopomofo',
'Han',
'Yi',
'Old_Italic',
'Gothic',
'Deseret',
'Inherited',
'Tagalog',
'Hanunoo',
'Buhid',
'Tagbanwa',
'Limbu',
'Tai_Le',
'Linear_B',
'Ugaritic',
'Shavian',
'Osmanya',
'Cypriot',
'Braille',
'Buginese',
'Coptic',
'New_Tai_Lue',
'Glagolitic',
'Tifinagh',
'Syloti_Nagri',
'Old_Persian',
'Kharoshthi',
'Balinese',
'Cuneiform',
'Phoenician',
'Phags_Pa',
'Nko',
'Sundanese',
'Lepcha',
'Ol_Chiki',
'Vai',
'Saurashtra',
'Kayah_Li',
'Rejang',
'Lycian',
'Carian',
'Lydian',
'Cham',
'Tai_Tham',
'Tai_Viet',
'Avestan',
'Egyptian_Hieroglyphs',
'Samaritan',
'Lisu',
'Bamum',
'Javanese',
'Meetei_Mayek',
'Imperial_Aramaic',
'Old_South_Arabian',
'Inscriptional_Parthian',
'Inscriptional_Pahlavi',
'Old_Turkic',
'Kaithi',
'Batak',
'Brahmi',
'Mandaic',
'Chakma',
'Meroitic_Cursive',
'Meroitic_Hieroglyphs',
'Miao',
'Sharada',
'Sora_Sompeng',
'Takri',
'Caucasian_Albanian',
'Bassa_Vah',
'Duployan',
'Elbasan',
'Grantha',
'Pahawh_Hmong',
'Khojki',
'Linear_A',
'Mahajani',
'Manichaean',
'Mende_Kikakui',
'Modi',
'Mro',
'Old_North_Arabian',
'Nabataean',
'Palmyrene',
'Pau_Cin_Hau',
'Old_Permic',
'Psalter_Pahlavi',
'Siddham',
'Khudawadi',
'Tirhuta',
'Warang_Citi',
'Ahom',
'Anatolian_Hieroglyphs',
'Hatran',
'Multani',
'Old_Hungarian',
'SignWriting',
'Adlam',
'Bhaiksuki',
'Marchen',
'Newa',
'Osage',
'Tangut'
);
     PUCUUnicodeScriptUnknown=0;
     PUCUUnicodeScriptCommon=1;
     PUCUUnicodeScriptLatin=2;
     PUCUUnicodeScriptGreek=3;
     PUCUUnicodeScriptCyrillic=4;
     PUCUUnicodeScriptArmenian=5;
     PUCUUnicodeScriptHebrew=6;
     PUCUUnicodeScriptArabic=7;
     PUCUUnicodeScriptSyriac=8;
     PUCUUnicodeScriptThaana=9;
     PUCUUnicodeScriptDevanagari=10;
     PUCUUnicodeScriptBengali=11;
     PUCUUnicodeScriptGurmukhi=12;
     PUCUUnicodeScriptGujarati=13;
     PUCUUnicodeScriptOriya=14;
     PUCUUnicodeScriptTamil=15;
     PUCUUnicodeScriptTelugu=16;
     PUCUUnicodeScriptKannada=17;
     PUCUUnicodeScriptMalayalam=18;
     PUCUUnicodeScriptSinhala=19;
     PUCUUnicodeScriptThai=20;
     PUCUUnicodeScriptLao=21;
     PUCUUnicodeScriptTibetan=22;
     PUCUUnicodeScriptMyanmar=23;
     PUCUUnicodeScriptGeorgian=24;
     PUCUUnicodeScriptHangul=25;
     PUCUUnicodeScriptEthiopic=26;
     PUCUUnicodeScriptCherokee=27;
     PUCUUnicodeScriptCanadian_Aboriginal=28;
     PUCUUnicodeScriptOgham=29;
     PUCUUnicodeScriptRunic=30;
     PUCUUnicodeScriptKhmer=31;
     PUCUUnicodeScriptMongolian=32;
     PUCUUnicodeScriptHiragana=33;
     PUCUUnicodeScriptKatakana=34;
     PUCUUnicodeScriptBopomofo=35;
     PUCUUnicodeScriptHan=36;
     PUCUUnicodeScriptYi=37;
     PUCUUnicodeScriptOld_Italic=38;
     PUCUUnicodeScriptGothic=39;
     PUCUUnicodeScriptDeseret=40;
     PUCUUnicodeScriptInherited=41;
     PUCUUnicodeScriptTagalog=42;
     PUCUUnicodeScriptHanunoo=43;
     PUCUUnicodeScriptBuhid=44;
     PUCUUnicodeScriptTagbanwa=45;
     PUCUUnicodeScriptLimbu=46;
     PUCUUnicodeScriptTai_Le=47;
     PUCUUnicodeScriptLinear_B=48;
     PUCUUnicodeScriptUgaritic=49;
     PUCUUnicodeScriptShavian=50;
     PUCUUnicodeScriptOsmanya=51;
     PUCUUnicodeScriptCypriot=52;
     PUCUUnicodeScriptBraille=53;
     PUCUUnicodeScriptBuginese=54;
     PUCUUnicodeScriptCoptic=55;
     PUCUUnicodeScriptNew_Tai_Lue=56;
     PUCUUnicodeScriptGlagolitic=57;
     PUCUUnicodeScriptTifinagh=58;
     PUCUUnicodeScriptSyloti_Nagri=59;
     PUCUUnicodeScriptOld_Persian=60;
     PUCUUnicodeScriptKharoshthi=61;
     PUCUUnicodeScriptBalinese=62;
     PUCUUnicodeScriptCuneiform=63;
     PUCUUnicodeScriptPhoenician=64;
     PUCUUnicodeScriptPhags_Pa=65;
     PUCUUnicodeScriptNko=66;
     PUCUUnicodeScriptSundanese=67;
     PUCUUnicodeScriptLepcha=68;
     PUCUUnicodeScriptOl_Chiki=69;
     PUCUUnicodeScriptVai=70;
     PUCUUnicodeScriptSaurashtra=71;
     PUCUUnicodeScriptKayah_Li=72;
     PUCUUnicodeScriptRejang=73;
     PUCUUnicodeScriptLycian=74;
     PUCUUnicodeScriptCarian=75;
     PUCUUnicodeScriptLydian=76;
     PUCUUnicodeScriptCham=77;
     PUCUUnicodeScriptTai_Tham=78;
     PUCUUnicodeScriptTai_Viet=79;
     PUCUUnicodeScriptAvestan=80;
     PUCUUnicodeScriptEgyptian_Hieroglyphs=81;
     PUCUUnicodeScriptSamaritan=82;
     PUCUUnicodeScriptLisu=83;
     PUCUUnicodeScriptBamum=84;
     PUCUUnicodeScriptJavanese=85;
     PUCUUnicodeScriptMeetei_Mayek=86;
     PUCUUnicodeScriptImperial_Aramaic=87;
     PUCUUnicodeScriptOld_South_Arabian=88;
     PUCUUnicodeScriptInscriptional_Parthian=89;
     PUCUUnicodeScriptInscriptional_Pahlavi=90;
     PUCUUnicodeScriptOld_Turkic=91;
     PUCUUnicodeScriptKaithi=92;
     PUCUUnicodeScriptBatak=93;
     PUCUUnicodeScriptBrahmi=94;
     PUCUUnicodeScriptMandaic=95;
     PUCUUnicodeScriptChakma=96;
     PUCUUnicodeScriptMeroitic_Cursive=97;
     PUCUUnicodeScriptMeroitic_Hieroglyphs=98;
     PUCUUnicodeScriptMiao=99;
     PUCUUnicodeScriptSharada=100;
     PUCUUnicodeScriptSora_Sompeng=101;
     PUCUUnicodeScriptTakri=102;
     PUCUUnicodeScriptCaucasian_Albanian=103;
     PUCUUnicodeScriptBassa_Vah=104;
     PUCUUnicodeScriptDuployan=105;
     PUCUUnicodeScriptElbasan=106;
     PUCUUnicodeScriptGrantha=107;
     PUCUUnicodeScriptPahawh_Hmong=108;
     PUCUUnicodeScriptKhojki=109;
     PUCUUnicodeScriptLinear_A=110;
     PUCUUnicodeScriptMahajani=111;
     PUCUUnicodeScriptManichaean=112;
     PUCUUnicodeScriptMende_Kikakui=113;
     PUCUUnicodeScriptModi=114;
     PUCUUnicodeScriptMro=115;
     PUCUUnicodeScriptOld_North_Arabian=116;
     PUCUUnicodeScriptNabataean=117;
     PUCUUnicodeScriptPalmyrene=118;
     PUCUUnicodeScriptPau_Cin_Hau=119;
     PUCUUnicodeScriptOld_Permic=120;
     PUCUUnicodeScriptPsalter_Pahlavi=121;
     PUCUUnicodeScriptSiddham=122;
     PUCUUnicodeScriptKhudawadi=123;
     PUCUUnicodeScriptTirhuta=124;
     PUCUUnicodeScriptWarang_Citi=125;
     PUCUUnicodeScriptAhom=126;
     PUCUUnicodeScriptAnatolian_Hieroglyphs=127;
     PUCUUnicodeScriptHatran=128;
     PUCUUnicodeScriptMultani=129;
     PUCUUnicodeScriptOld_Hungarian=130;
     PUCUUnicodeScriptSignWriting=131;
     PUCUUnicodeScriptAdlam=132;
     PUCUUnicodeScriptBhaiksuki=133;
     PUCUUnicodeScriptMarchen=134;
     PUCUUnicodeScriptNewa=135;
     PUCUUnicodeScriptOsage=136;
     PUCUUnicodeScriptTangut=137;
     PUCUUnicodeScriptCount=138;

// PUCUUnicodeCategoryArray: 36480 bytes, 217 blocks with 128 items per 1 bytes and 8704 indices per 1 bytes
const PUCUUnicodeCategoryArrayBlockBits=7;
      PUCUUnicodeCategoryArrayBlockMask=127;
      PUCUUnicodeCategoryArrayBlockSize=128;
      PUCUUnicodeCategoryArrayBlockCount=217;
      PUCUUnicodeCategoryArrayBlockData:array[0..216,0..127] of byte=(
(15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
15,15,15,15,15,12,23,23,23,25,23,23,23,20,21,23,24,23,19,23,23,9,9,9,9,9,9,9,9,9,
9,23,23,24,24,24,23,23,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,20,23,
21,26,22,26,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,20,24,21,24,15),
(15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
15,15,15,15,15,12,23,25,25,25,25,27,23,26,27,5,28,24,16,27,26,27,24,11,11,26,2,23,
23,26,11,5,29,11,11,11,23,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,1,1,1,
1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24,2,2,2,2,2,2,2,2),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,1,
2,1,2,1,2,2),
(2,1,1,2,1,2,1,1,2,1,1,1,2,2,1,1,1,1,2,1,1,2,1,1,1,2,2,2,1,1,2,1,1,2,1,2,1,2,1,1,
2,1,2,2,1,2,1,1,2,1,1,1,2,1,2,1,1,2,2,5,1,2,2,2,5,5,5,5,1,3,2,1,3,2,1,3,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,3,2,1,2,1,1,1,2,
1,2,1,2,1,2),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,2,2,2,2,2,2,1,1,2,1,1,2,2,1,2,1,1,1,1,2,1,2,1,2,1,2,1,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,26,26,26,26,4,4,4,4,4,4,4,4,4,
4,4,4,26,26,26,26,26,26,26,26,26,26,26,26,26,26,4,4,4,4,4,26,26,26,26,26,26,26,4,
26,4,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26),
(6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,1,2,1,2,4,26,1,2,0,
0,4,2,2,2,23,1),
(0,0,0,0,26,26,1,23,1,1,1,0,1,0,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,
1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,
2,2,1,1,1,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,2,2,2,1,2,24,1,
2,1,1,2,2,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2),
(1,2,27,6,6,6,6,6,7,7,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,4,23,23,23,23,23,23,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,0,23,19,0,0,27,27,25,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,19,6,23,6,6,23,6,6,23,6,0,0,0,0,0,
0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,5,23,23,
0,0,0,0,0,0,0,0,0,0,0),
(16,16,16,16,16,16,24,24,24,23,23,25,23,23,27,27,6,6,6,6,6,6,6,6,6,6,6,23,16,0,23,
23,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,5,5,5,5,5,5,
5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,9,9,9,9,9,9,9,9,9,9,23,23,23,23,
5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,23,5,6,6,6,6,6,6,6,16,27,6,6,6,6,6,6,4,4,6,6,27,6,6,6,6,5,5,9,9,9,9,9,9,9,9,
9,9,5,5,5,27,27,5),
(23,23,23,23,23,23,23,23,23,23,23,23,23,23,0,16,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,
6,6,6,6,6,6,6,6,6,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,4,4,27,23,23,
23,4,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,4,6,6,6,6,6,6,6,6,6,4,6,6,6,
4,6,6,6,6,6,0,0,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,0,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,0,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,16,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6),
(6,6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,8,6,5,8,8,8,6,6,6,6,6,6,6,6,8,8,8,8,6,8,8,5,
6,6,6,6,6,6,6,5,5,5,5,5,5,5,5,5,5,6,6,23,23,9,9,9,9,9,9,9,9,9,9,23,4,5,5,5,5,5,5,
5,5,5,5,5,5,5,5),
(5,6,8,8,0,5,5,5,5,5,5,5,5,0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,0,5,0,0,0,5,5,5,5,0,0,6,5,8,8,8,6,6,6,6,0,0,8,8,0,0,8,8,6,5,0,0,
0,0,0,0,0,0,8,0,0,0,0,5,5,0,5,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,5,5,25,25,11,11,11,
11,11,11,27,25,0,0,0,0),
(0,6,6,8,0,5,5,5,5,5,5,0,0,0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,0,5,5,0,5,5,0,5,5,0,0,6,0,8,8,8,6,6,0,0,0,0,6,6,0,0,6,6,6,0,0,0,
6,0,0,0,0,0,0,0,5,5,5,5,0,5,0,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,6,6,5,5,5,6,0,0,0,0,
0,0,0,0,0,0),
(0,6,6,8,0,5,5,5,5,5,5,5,5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,6,5,8,8,8,6,6,6,6,6,0,6,6,8,0,8,8,6,0,0,5,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,23,25,0,0,0,0,0,0,0,
5,0,0,0,0,0,0),
(0,6,8,8,0,5,5,5,5,5,5,5,5,0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,6,5,8,6,8,6,6,6,6,0,0,8,8,0,0,8,8,6,0,0,0,
0,0,0,0,0,6,8,0,0,0,0,5,5,0,5,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,27,5,11,11,11,11,11,
11,0,0,0,0,0,0,0,0),
(0,0,6,5,0,5,5,5,5,5,5,0,0,0,5,5,5,0,5,5,5,5,0,0,0,5,5,0,5,0,5,5,0,0,0,5,5,0,0,0,
5,5,5,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,8,8,6,8,8,0,0,0,8,8,8,0,8,8,8,6,0,0,5,
0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,11,11,11,27,27,27,27,
27,27,25,27,0,0,0,0,0),
(6,8,8,8,0,5,5,5,5,5,5,5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,5,6,6,6,8,8,8,8,0,6,6,6,0,6,6,6,6,0,0,0,
0,0,0,0,6,6,0,5,5,5,0,0,0,0,0,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,11,
11,11,11,11,11,11,27),
(5,6,8,8,0,5,5,5,5,5,5,5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,0,0,6,5,8,6,8,8,8,8,8,0,6,8,8,0,8,8,6,6,0,0,0,
0,0,0,0,8,8,0,0,0,0,0,0,0,5,0,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,0,5,5,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,6,8,8,0,5,5,5,5,5,5,5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,8,8,8,6,6,6,6,0,8,8,8,0,8,8,8,6,5,27,
0,0,0,0,5,5,5,8,11,11,11,11,11,11,11,5,5,5,6,6,0,0,9,9,9,9,9,9,9,9,9,9,11,11,11,11,
11,11,11,11,11,27,5,5,5,5,5,5),
(0,0,8,8,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,0,5,0,0,5,5,5,5,5,5,5,0,0,0,6,0,0,0,0,8,8,
8,6,6,6,0,6,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,8,8,23,0,0,0,0,
0,0,0,0,0,0,0),
(0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,6,5,5,6,6,6,6,6,6,6,0,0,0,0,25,5,5,5,5,5,5,4,6,6,6,6,6,6,6,6,23,
9,9,9,9,9,9,9,9,9,9,23,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(0,5,5,0,5,0,0,5,5,0,5,0,0,5,0,0,0,0,0,0,5,5,5,5,0,5,5,5,5,5,5,5,0,5,5,5,0,5,0,5,
0,0,5,5,0,5,5,5,5,6,5,5,6,6,6,6,6,6,0,6,6,5,0,0,5,5,5,5,5,0,4,0,6,6,6,6,6,6,0,0,9,
9,9,9,9,9,9,9,9,9,0,0,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,27,27,27,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,27,23,27,27,27,6,6,27,27,
27,27,27,27,9,9,9,9,9,9,9,9,9,9,11,11,11,11,11,11,11,11,11,11,27,6,27,6,27,6,20,21,
20,21,8,8,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8),
(6,6,6,6,6,23,6,6,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,27,27,27,27,27,27,27,27,6,27,27,27,27,
27,27,0,27,27,23,23,23,23,23,27,27,27,27,23,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,8,8,6,6,6,6,8,6,6,6,6,6,6,8,6,6,8,8,6,6,5,9,9,9,9,9,9,9,9,9,9,23,23,23,23,23,
23,5,5,5,5,5,5,8,8,6,6,5,5,5,5,6,6,6,5,8,8,8,5,5,8,8,8,8,8,8,8,5,5,5,6,6,6,6,5,5,
5,5,5,5,5,5,5,5,5),
(5,5,6,8,8,6,6,8,8,8,8,8,8,6,5,8,9,9,9,9,9,9,9,9,9,9,8,8,8,6,27,27,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,1,0,0,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,23,4,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,0,5,
5,5,5,5,5,5,0,5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,0,5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,0,0,6,6,6,23,23,23,23,23,23,23,23,23,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,2,2,2,2,2,2,0,0),
(19,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,23,23,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5),
(12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,21,0,0,0,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,23,23,23,10,10,10,5,5,5,5,5,
5,5,5,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,6,6,6,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,6,6,6,23,23,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,6,6,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,0,6,6,0,0,0,0,0,
0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,6,6,8,6,6,6,6,6,6,6,8,8,8,8,8,8,8,8,6,8,8,6,6,6,6,6,6,6,6,
6,6,6,23,23,23,4,23,23,23,25,5,6,0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,11,11,11,11,
11,11,11,11,11,11,0,0,0,0,0,0),
(23,23,23,23,23,23,19,23,23,23,23,6,6,6,16,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,0,0,0,0,0,0,0,0),
(5,5,5,5,5,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,6,5,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,6,6,6,8,8,8,8,6,
6,8,8,8,0,0,0,0,8,8,6,8,8,8,8,8,8,6,6,6,0,0,0,0,27,0,0,0,23,23,9,9,9,9,9,9,9,9,9,
9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,5,5,5,5,0,0,0,
0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,9,
9,9,9,9,9,9,9,9,9,11,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,8,8,6,0,0,23,23,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,8,6,8,6,6,6,6,6,6,6,0,6,8,6,8,8,6,6,6,6,6,6,6,6,8,8,8,8,8,8,6,6,6,6,6,6,
6,6,6,6,0,0,6),
(9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,23,23,23,23,23,23,
23,4,23,23,23,23,23,23,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0),
(6,6,6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,6,8,6,6,6,6,6,8,6,8,8,8,8,8,6,8,8,5,5,5,5,5,5,5,0,0,0,0,9,
9,9,9,9,9,9,9,9,9,23,23,23,23,23,23,23,27,27,27,27,27,27,27,27,27,27,6,6,6,6,6,6,
6,6,6,27,27,27,27,27,27,27,27,27,0,0,0),
(6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,6,6,6,6,8,8,
6,6,8,6,6,6,5,5,9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,8,6,6,8,8,8,6,8,6,6,6,8,8,0,0,0,0,0,0,
0,0,23,23,23,23),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,8,
8,8,8,8,6,6,6,6,6,6,6,6,8,8,6,6,0,0,0,23,23,23,23,23,9,9,9,9,9,9,9,9,9,9,0,0,0,5,
5,5,9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,4,4,4,4,4,4,23,23),
(2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,23,23,23,23,23,23,23,23,0,0,0,0,0,
0,0,0,6,6,6,23,6,6,6,6,6,6,6,6,6,6,6,6,6,8,6,6,6,6,6,6,6,5,5,5,5,6,5,5,5,5,8,8,6,
5,5,0,6,6,0,0,0,0,0,0),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,
0,6,6,6,6,6),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,2,2,2,2,2,2,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2),
(2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,
1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,0,0,1,1,1,1,1,1,0,0,2,
2,2,2,2,2,2,2,0,1,0,1,0,1,0,1,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,0,0),
(2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,
3,3,3,3,3,3,3,3,2,2,2,2,2,0,2,2,1,1,1,1,3,26,2,26,26,26,2,2,2,0,2,2,1,1,1,1,3,26,
26,26,2,2,2,2,0,0,2,2,1,1,1,1,0,26,26,26,2,2,2,2,2,2,2,2,1,1,1,1,1,26,26,26,0,0,2,
2,2,0,2,2,1,1,1,1,3,26,26,0),
(12,12,12,12,12,12,12,12,12,12,12,16,16,16,16,16,19,19,19,19,19,19,23,23,28,29,20,
28,28,29,20,28,23,23,23,23,23,23,23,23,13,14,16,16,16,16,16,12,23,23,23,23,23,23,
23,23,23,28,29,23,23,23,23,22,22,23,23,23,24,20,21,23,23,23,23,23,23,23,23,23,23,
23,24,23,22,23,23,23,23,23,23,23,23,23,23,12,16,16,16,16,16,0,16,16,16,16,16,16,16,
16,16,16,11,4,0,0,11,11,11,11,11,11,24,24,24,20,21,4),
(11,11,11,11,11,11,11,11,11,11,24,24,24,20,21,0,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,6,7,
7,7,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,1,27,27,27,27,1,27,27,2,1,1,1,2,2,1,1,1,2,27,1,27,27,24,1,1,1,1,1,27,27,27,
27,27,27,1,27,1,27,1,27,1,1,1,1,27,2,1,1,1,1,2,5,5,5,5,2,27,27,2,2,1,1,24,24,24,24,
24,1,2,2,2,2,27,24,27,27,2,27,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10),
(10,10,10,1,2,10,10,10,10,11,27,27,0,0,0,0,24,24,24,24,24,27,27,27,27,27,24,24,27,
27,27,27,24,27,27,24,27,27,24,27,27,27,27,27,27,27,24,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,24,27,27,24,
27,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,24,24,24,24,24,24,24,24,24,24,24,24),
(24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24),
(27,27,27,27,27,27,27,27,20,21,20,21,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,24,24,27,27,27,27,27,27,27,20,21,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,24,24,24,24,24,24,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11),
(11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,24,27,27,27,27,27,27,27,27,27,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,24,24,24,24,24,24,24,24),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,24,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,20,21,20,21,
20,21,20,21,20,21,20,21,20,21,11,11,11,11,11,11,11,11,11,11),
(11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,24,24,24,24,24,20,21,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,20,21,20,21,20,21,
20,21,20,21,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24),
(24,24,24,20,21,20,21,20,21,20,21,20,21,20,21,20,21,20,21,20,21,20,21,20,21,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,20,21,20,21,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,20,21,24,24),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,27,27,24,24,24,24,24,24,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,0,0,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,0,27,27,27,27,27,27,27,27,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,2,1,1,1,2,2,1,2,1,2,1,2,1,1,1,1,2,1,2,2,1,2,2,2,2,
2,2,4,4,1,1),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,27,27,27,27,27,27,1,2,1,2,6,6,6,1,2,0,0,0,
0,0,23,23,23,23,11,23,23),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,2,
0,0,0,0,0,2,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,4,23,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,6),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,0,
5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,5,
5,5,5,5,5,5,0,5,5,5,5,5,5,5,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6),
(23,23,28,29,28,29,23,23,23,28,29,23,28,29,23,23,23,23,23,23,23,23,23,19,23,23,19,
23,28,29,23,23,28,29,20,21,20,21,20,21,20,21,23,23,23,23,23,4,23,23,23,23,23,23,23,
23,23,23,19,19,23,23,23,23,19,23,20,23,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,
27,27,27,27,27,27,27,0,0,0,0),
(12,23,23,23,27,4,5,10,20,21,20,21,20,21,20,21,20,21,27,27,20,21,20,21,20,21,20,21,
19,20,21,21,27,10,10,10,10,10,10,10,10,10,6,6,6,6,8,8,19,4,4,4,4,4,27,27,10,10,10,
4,5,23,27,27,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,6,6,26,26,4,4,5,19,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,23,4,4,4,5),
(0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,27,27,11,11,11,11,27,27,27,27,27,27,27,27,27,27,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,0,11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,11,11,11,11,11,11,11,11,27,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,4,4,4,4,23,23),
(5,5,5,5,5,5,5,5,5,5,5,5,4,23,23,23,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,9,9,9,9,9,9,9,
9,9,9,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,5,6,7,7,7,23,6,6,6,6,
6,6,6,6,6,6,23,4),
(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,4,4,6,6,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,10,10,10,10,10,10,10,10,10,10,6,6,23,23,
23,23,23,23,0,0,0,0,0,0,0,0),
(26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,4,4,4,4,4,4,
4,4,4,26,26,1,2,1,2,1,2,1,2,1,2,1,2,1,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,
1,2,4,2,2,2,2,2,2,2,2,1,2,1,2,1,1,2),
(1,2,1,2,1,2,1,2,4,26,26,1,2,1,2,5,1,2,1,2,2,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,
2,1,2,1,1,1,1,1,0,1,1,1,1,1,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,4,
4,2,5,5,5,5,5),
(5,5,6,5,5,5,6,5,5,5,5,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,6,6,8,
27,27,27,27,0,0,0,0,11,11,11,11,11,11,27,27,25,27,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,23,23,23,23,0,0,0,0,0,0,0,0),
(8,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,6,6,0,0,0,0,0,0,0,0,23,23,
9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,5,5,5,5,5,23,
23,23,5,23,5,0,0),
(9,9,9,9,9,9,9,9,9,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,
6,6,6,6,6,6,23,23,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,
6,6,8,8,0,0,0,0,0,0,0,0,0,0,0,23,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,0,0,0),
(6,6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,6,8,8,6,6,6,6,8,8,6,8,8,8,8,23,23,23,23,23,23,23,23,23,23,23,
23,23,0,4,9,9,9,9,9,9,9,9,9,9,0,0,0,0,23,23,5,5,5,5,5,6,4,5,5,5,5,5,5,5,5,5,9,9,9,
9,9,9,9,9,9,9,5,5,5,5,5,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,6,6,6,6,6,6,8,8,6,6,8,8,6,6,0,0,0,0,0,0,0,0,0,5,5,5,6,5,5,5,5,5,5,5,5,6,8,0,0,9,
9,9,9,9,9,9,9,9,9,0,0,23,23,23,23,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,5,5,5,5,5,5,27,
27,27,5,8,6,8,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,6,5,6,6,6,5,5,6,6,5,5,5,5,5,6,6,5,6,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,5,5,4,23,23,5,5,5,5,5,5,5,5,5,5,5,8,6,6,8,8,23,23,5,4,4,8,6,0,
0,0,0,0,0,0,0,0),
(0,5,5,5,5,5,5,0,0,5,5,5,5,5,5,0,0,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,0,
5,5,5,5,5,5,5,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,26,4,4,4,4,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,6,8,8,6,8,8,23,8,6,0,0,9,9,9,9,9,9,9,9,9,
9,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,
0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,0,0,0,0),
(18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18),
(17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,0,0,0,0,0,5,6,5,5,5,5,5,5,5,5,5,
5,24,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,0,5,0,5,5,0,5,5,0,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,21,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,
5,5,25,27,0,0),
(6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,23,23,23,23,23,23,23,20,21,23,0,0,0,0,0,0,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,23,19,19,22,22,20,21,20,21,20,21,20,21,20,21,20,21,20,21,
20,21,23,23,20,21,23,23,23,23,22,22,22,23,23,23,0,23,23,23,23,19,20,21,20,21,20,21,
23,23,23,24,19,24,24,24,0,23,25,23,23,0,0,0,0,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,0,0,16),
(0,23,23,23,25,23,23,23,20,21,23,24,23,19,23,23,9,9,9,9,9,9,9,9,9,9,23,23,24,24,24,
23,23,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,20,23,21,26,22,26,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,20,24,21,24,20,21,23,20,21,23,23,5,
5,5,5,5,5,5,5,5,5,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,4,4,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,5,5,5,5,5,5,0,0,5,5,5,5,5,5,0,
0,5,5,5,5,5,5,0,0,5,5,5,0,0,0,25,25,24,26,27,25,25,0,27,24,24,24,24,27,27,0,0,0,0,
0,0,0,0,0,0,16,16,16,27,27,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,0,0,0,0),
(23,23,23,0,0,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,0,27,
27,27,27,27,27,27,27,27,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,11,11,11,11,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,11,11,27,27,27,0,27,27,27,27,27,27,27,27,27,27,27,
27,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,6,0,
0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,11,11,11,11,0,0,
0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,10,5,5,5,5,5,5,5,5,10,0,0,0,
0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
6,6,6,6,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,23,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,5,5,5,5,5,5,5,5,23,
10,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,9,9,9,9,9,9,9,9,
9,9,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,0,0,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,0,0,0,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,0,23,11,11,11,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,27,27,11,11,11,11,11,11,11),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,11,
11,11,11,11,11,11,11,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,
0,0,0,0,0,11,11,11,11,11),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,11,11,11,11,11,11,0,0,0,23,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,11,11,5,5,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11),
(5,6,6,6,0,6,6,0,0,0,0,0,6,6,6,6,5,5,5,5,0,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,6,6,6,0,0,0,0,6,11,11,11,11,11,11,11,11,0,0,0,0,0,
0,0,0,23,23,23,23,23,23,23,23,23,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,11,11,23),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,11,11,11,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,27,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,0,0,0,0,11,11,11,11,11,23,23,23,23,
23,23,23,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,23,23,23,23,23,23,23,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,0,0,11,11,11,11,11,11,11,11,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,0,0,0,0,11,11,11,11,11,11,11,11),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,23,23,23,23,0,0,0,0,0,0,0,0,0,
0,0,0,11,11,11,11,11,11,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,
11,11,11,11,11,11),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,0),
(8,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,23,23,23,23,23,23,23,
0,0,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,9,9,9,9,9,9,9,
9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6),
(6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,8,8,8,6,6,6,6,8,8,6,6,23,23,16,23,23,23,23,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,9,9,9,9,9,9,
9,9,9,9,0,0,0,0,0,0),
(6,6,6,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,
6,6,6,6,8,6,6,6,6,6,6,6,6,0,9,9,9,9,9,9,9,9,9,9,23,23,23,23,0,0,0,0,0,0,0,0,0,0,0,
0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,23,23,5,
0,0,0,0,0,0,0,0,0),
(6,6,8,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,8,8,8,6,6,6,6,6,6,6,6,6,8,8,5,5,5,5,23,23,23,23,23,6,6,6,23,
0,0,9,9,9,9,9,9,9,9,9,9,5,23,5,23,23,23,0,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,8,8,8,6,6,6,8,8,6,8,6,6,23,23,23,23,23,23,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,0,5,0,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,
5,23,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,8,8,8,6,6,6,6,6,6,6,6,0,0,0,0,0,9,9,9,9,9,9,9,9,9,
9,0,0,0,0,0,0),
(6,6,8,8,0,5,5,5,5,5,5,5,5,0,0,5,5,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,0,5,5,5,5,5,5,5,0,5,5,0,5,5,5,5,5,0,0,6,5,8,8,6,8,8,8,8,0,0,8,8,0,0,8,8,8,0,0,5,
0,0,0,0,0,0,8,0,0,0,0,0,5,5,5,5,5,8,8,0,0,6,6,6,6,6,6,6,0,0,0,6,6,6,6,6,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,8,8,8,6,6,6,6,6,6,6,6,8,8,6,6,6,8,6,5,5,5,5,23,23,23,23,
23,9,9,9,9,9,9,9,9,9,9,0,23,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,8,8,8,6,6,6,6,6,6,8,6,8,8,8,8,6,6,8,6,6,5,5,23,5,0,0,0,0,0,0,0,0,
9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,8,8,8,6,6,6,6,0,0,8,8,8,8,6,6,8,6,6,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,5,5,5,5,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,8,8,8,6,6,6,6,6,6,6,6,8,8,6,8,6,6,23,23,23,5,0,0,0,0,0,0,0,0,0,0,
0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,23,23,23,23,23,23,23,23,23,23,23,23,23,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,6,8,6,8,8,6,6,6,6,6,6,8,6,0,0,0,0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,6,6,6,8,8,6,6,6,6,8,6,
6,6,6,6,0,0,0,0,9,9,9,9,9,9,9,9,9,9,11,11,23,23,23,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,9,9,9,9,9,9,9,9,9,9,11,11,11,11,11,11,11,11,11,0,0,
0,0,0,0,0,0,0,0,0,0,5),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,8,6,6,6,6,6,6,6,0,6,6,6,6,6,6,8,6,5,23,23,23,23,23,0,0,0,0,0,0,0,0,
0,0,9,9,9,9,9,9,9,9,9,9,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
0,0,0,23,23,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
0,8,6,6,6,6,6,6,6,8,6,6,8,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,0,23,23,23,23,23,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,9,9,9,9,9,9,9,9,9,9,0,0,0,0,23,23,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,6,6,6,6,6,23,0,0,0,
0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,23,23,23,23,23,27,27,27,27,4,4,4,4,23,27,0,0,0,0,0,
0,0,0,0,0,9,9,9,9,9,9,9,9,9,9,0,11,11,11,11,11,11,11,0,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,5,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,4,4,4,4,4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,
5,5,5,0,0,0),
(5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,0,0,27,6,6,23,16,16,16,16,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,8,8,6,6,6,27,27,27,8,8,8,
8,8,8,16,16,16,16,16,16,16,16,6,6,6,6,6),
(6,6,6,27,27,6,6,6,6,6,6,6,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,6,6,6,6,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,6,6,6,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,
2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,1,0,0,1,0,0,1,1,0,
0,1,1,1,1,0,1,1,1,1,1,1,1,1,2,2,2,2,0,2,0,2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,2,2,2,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,1,1,
0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,24,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,24,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,24,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24,
2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,24,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,24,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,24,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,24,2,2,2,2,2,2,1,2,0,0,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9),
(6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,27,27,27,27,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,27,27,27,27,27,27,27,
27,6,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,6,27,27,23,23,23,23,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,6,6,6,6,0,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0),
(6,6,6,6,6,6,6,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,6,6,6,6,6,6,6,0,6,6,0,6,6,
6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,11,11,11,11,11,11,11,
11,11,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,6,6,6,6,6,6,6,0,0,0,0,0,9,
9,9,9,9,9,9,9,9,9,0,0,0,0,23,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,5,5,0,5,0,0,5,
0,5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,0,5,0,5,0,0,0,0,0,0,5,0,0,0,0,5,0,5,0,5,0,5,5,5,0,
5,5,0,5,0,0,5,0,5,0,5,0,5,0,5,0,5,5,0,5,0,0,5,5,5,5,0,5,5,5,5,5,5,5,0,5,5,5,5,0,5,
5,5,5,0,5,0),
(5,5,5,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,5,5,5,0,5,5,5,
5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,24,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,
0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,0,0,0,0,0,0,0,0,0,0),
(11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,
0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27
),
(27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,0,0,0,0,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,27,27,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,26,26,26,26,26),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,27,27,
27,27,27,27,27,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,27,27,27,27,27,
27,27,27,27,27,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,27,
27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,27,0,0,27,27,27,27,27,27,27,27,27,27,27,27,0,
27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16),
(6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6),
(6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,0,0)
);

// PUCUUnicodeCategoryArrayIndex: 1200 bytes, 29 blocks with 32 items per 1 bytes and 272 indices per 1 bytes
const PUCUUnicodeCategoryArrayIndexBlockBits=5;
      PUCUUnicodeCategoryArrayIndexBlockMask=31;
      PUCUUnicodeCategoryArrayIndexBlockSize=32;
      PUCUUnicodeCategoryArrayIndexBlockCount=29;
      PUCUUnicodeCategoryArrayIndexBlockData:array[0..28,0..31] of byte=(
(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31),
(32,33,34,34,35,36,37,38,39,34,34,34,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,
55,56,57,58,59),
(60,61,62,63,64,64,65,66,67,68,69,70,71,69,72,73,69,69,64,74,64,64,75,76,77,78,79,
80,81,82,69,83),
(84,85,86,87,88,89,69,69,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
90,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,91),
(92,34,34,34,34,34,34,34,34,93,34,34,94,95,96,97,98,99,100,101,102,103,104,105,34,
34,34,34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,106,107,107,107,107,107,107,107,107,
107,107,107,107,107,107,107,107),
(108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,108),
(108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,34,34,109,
110,111,112,34,34,113,114,115,116,117,118),
(119,120,121,122,123,124,125,126,127,128,129,123,34,34,130,123,131,132,133,134,135,
136,137,138,139,140,123,123,141,123,123,123),
(142,143,144,145,146,147,148,123,149,150,123,151,152,153,154,123,123,155,123,123,
123,156,123,123,157,158,123,123,123,123,123,123),
(34,34,34,34,34,34,34,159,160,34,161,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123),
(34,34,34,34,34,34,34,34,162,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123),
(123,123,123,123,123,123,123,123,34,34,34,34,163,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,123),
(123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,123,123),
(123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,34,34,34,34,164,
165,166,167,123,123,123,123,123,123,168,169),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,170,34,34,34,34,34,171,123,123,123,
123,123,123,123,123,123,123),
(172,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,173,174,123,123,123,123,123,123),
(69,175,176,177,178,123,179,123,180,181,182,183,184,185,186,187,69,69,69,69,188,189,
123,123,123,123,123,123,123,123,123,123),
(190,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,34,191,192,123,123,
123,123,123,123,123,123,123,193,194,123,123),
(195,196,197,198,199,123,69,200,69,69,69,69,69,201,202,203,204,205,206,207,123,123,
123,123,123,123,123,123,123,123,123,123),
(34,34,34,34,34,34,34,34,34,34,34,34,34,208,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,209,34,210,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,211,123,123),
(123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,34,34,34,34,212,
123,123,123,123,123,123,123,123,123,123,123),
(213,123,214,215,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,123,123),
(108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,216)
);
      PUCUUnicodeCategoryArrayIndexIndexCount=29;
      PUCUUnicodeCategoryArrayIndexIndexData:array[0..271] of byte=(
0,1,2,3,4,5,5,5,5,6,7,5,5,8,9,10,11,12,13,14,15,16,17,5,18,16,16,19,16,20,21,22,5,
5,5,5,5,5,5,5,5,5,23,24,25,16,16,26,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,27,
16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,28,9,9,
9,9,9,9,9,9,9,9,9,9,9,9,9,28
);


// PUCUUnicodeScriptArray: 35456 bytes, 209 blocks with 128 items per 1 bytes and 8704 indices per 1 bytes
const PUCUUnicodeScriptArrayBlockBits=7;
      PUCUUnicodeScriptArrayBlockMask=127;
      PUCUUnicodeScriptArrayBlockSize=128;
      PUCUUnicodeScriptArrayBlockCount=209;
      PUCUUnicodeScriptArrayBlockData:array[0..208,0..127] of byte=(
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,1,1,1,1,1,35,35,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1),
(41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,3,3,3,3,1,3,3,3,0,0,3,3,3,3,1,3),
(0,0,0,0,3,1,3,1,3,3,3,0,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,55,55,55,55,55,55,55,55,55,55,55,55,55,55,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3),
(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4),
(4,4,4,4,4,41,41,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4),
(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5,0,0,5,5,5,5,5,5,5,0,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,0,1,5,0,0,5,5,5,0,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,0,0,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,6,6,6,6,6,0,0,0,0,0,
0,0,0,0,0,0),
(7,7,7,7,7,1,7,7,7,7,7,7,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,7,1,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,7,7,7,7,7,41,41,41,41,
41,41,41,41,41,41,41,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,41,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,0,8,8,8,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,66,66,66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,
66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,66,0,0,0,0,0),
(82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,
82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,82,0,0,82,82,82,82,82,82,82,
82,82,82,82,82,82,82,82,0,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,95,
95,95,95,95,95,95,95,95,95,0,0,95,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,0,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
41,41,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,1,1,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10),
(11,11,11,11,0,11,11,11,11,11,11,11,11,0,0,11,11,0,0,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,11,11,11,11,11,11,11,11,0,11,11,11,11,11,11,11,0,11,0,0,0,11,11,11,11,
0,0,11,11,11,11,11,11,11,11,11,0,0,11,11,0,0,11,11,11,11,0,0,0,0,0,0,0,0,11,0,0,0,
0,11,11,0,11,11,11,11,11,0,0,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
11,11,11,11,0,0,0,0),
(0,12,12,12,0,12,12,12,12,12,12,0,0,0,0,12,12,0,0,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12,12,12,12,12,12,12,0,12,12,12,12,12,12,12,0,12,12,0,12,12,0,12,12,0,
0,12,0,12,12,12,12,12,0,0,0,0,12,12,0,0,12,12,12,0,0,0,12,0,0,0,0,0,0,0,12,12,12,
12,0,12,0,0,0,0,0,0,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,0,0,0,0,0,0,
0,0,0,0),
(0,13,13,13,0,13,13,13,13,13,13,13,13,13,0,13,13,13,0,13,13,13,13,13,13,13,13,13,
13,13,13,13,13,13,13,13,13,13,13,13,13,0,13,13,13,13,13,13,13,0,13,13,0,13,13,13,
13,13,0,0,13,13,13,13,13,13,13,13,13,13,0,13,13,13,0,13,13,13,0,0,13,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,13,13,13,13,0,0,13,13,13,13,13,13,13,13,13,13,13,13,0,0,0,0,0,0,
0,13,0,0,0,0,0,0),
(0,14,14,14,0,14,14,14,14,14,14,14,14,0,0,14,14,0,0,14,14,14,14,14,14,14,14,14,14,
14,14,14,14,14,14,14,14,14,14,14,14,0,14,14,14,14,14,14,14,0,14,14,0,14,14,14,14,
14,0,0,14,14,14,14,14,14,14,14,14,0,0,14,14,0,0,14,14,14,0,0,0,0,0,0,0,0,14,14,0,
0,0,0,14,14,0,14,14,14,14,14,0,0,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,
14,14,0,0,0,0,0,0,0,0),
(0,0,15,15,0,15,15,15,15,15,15,0,0,0,15,15,15,0,15,15,15,15,0,0,0,15,15,0,15,0,15,
15,0,0,0,15,15,0,0,0,15,15,15,0,0,0,15,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,15,
15,15,15,15,0,0,0,15,15,15,0,15,15,15,15,0,0,15,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,
0),
(16,16,16,16,0,16,16,16,16,16,16,16,16,0,16,16,16,0,16,16,16,16,16,16,16,16,16,16,
16,16,16,16,16,16,16,16,16,16,16,16,16,0,16,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,0,0,0,16,16,16,16,16,16,16,16,0,16,16,16,0,16,16,16,16,0,0,0,0,0,0,0,16,16,
0,16,16,16,0,0,0,0,0,16,16,16,16,0,0,16,16,16,16,16,16,16,16,16,16,0,0,0,0,0,0,0,
0,16,16,16,16,16,16,16,16),
(17,17,17,17,0,17,17,17,17,17,17,17,17,0,17,17,17,0,17,17,17,17,17,17,17,17,17,17,
17,17,17,17,17,17,17,17,17,17,17,17,17,0,17,17,17,17,17,17,17,17,17,17,0,17,17,17,
17,17,0,0,17,17,17,17,17,17,17,17,17,0,17,17,17,0,17,17,17,17,0,0,0,0,0,0,0,17,17,
0,0,0,0,0,0,0,17,0,17,17,17,17,0,0,17,17,17,17,17,17,17,17,17,17,0,17,17,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(0,18,18,18,0,18,18,18,18,18,18,18,18,0,18,18,18,0,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,0,0,18,18,18,18,18,18,18,18,0,18,18,18,0,18,18,18,18,18,18,0,0,0,0,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,0,0,18,18,18,18,18,18,18,18,18,18,18,
18,18,18,18,18,18,18,18,18,18,18,18,18,18,18),
(0,0,19,19,0,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,0,0,0,19,19,19,
19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,0,19,19,19,19,19,19,
19,19,19,0,19,0,0,19,19,19,19,19,19,19,0,0,0,19,0,0,0,0,19,19,19,19,19,19,0,19,0,
19,19,19,19,19,19,19,19,0,0,0,0,0,0,19,19,19,19,19,19,19,19,19,19,0,0,19,19,19,0,
0,0,0,0,0,0,0,0,0,0),
(0,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,0,0,0,0,1,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
20,20,20,20,20,20,20,20,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(0,21,21,0,21,0,0,21,21,0,21,0,0,21,0,0,0,0,0,0,21,21,21,21,0,21,21,21,21,21,21,21,
0,21,21,21,0,21,0,21,0,0,21,21,0,21,21,21,21,21,21,21,21,21,21,21,21,21,0,21,21,21,
0,0,21,21,21,21,21,0,21,0,21,21,21,21,21,21,0,0,21,21,21,21,21,21,21,21,21,21,0,0,
21,21,21,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,0,22,22,22,22,22,22,22,22,22,
22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
0,0,0,0,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22),
(22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,0,22,22,
22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,
22,22,22,22,22,22,22,0,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,0,22,22,22,22,
22,22,22,1,1,1,1,22,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23),
(23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,0,24,0,0,0,0,0,24,0,0,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,24,1,24,24,24,24),
(25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25),
(26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,26,26,26,26,0,0,26,26,
26,26,26,26,26,0,26,0,26,26,26,26,0,0,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26),
(26,26,26,26,26,26,26,26,26,0,26,26,26,26,0,0,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,26,26,26,26,0,0,
26,26,26,26,26,26,26,0,26,0,26,26,26,26,0,0,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,0,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26),
(26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,26,26,26,26,0,0,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,0,0,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,0,0),
(26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,
0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,0,0,27,27,27,27,27,27,0,0),
(28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28),
(29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,
29,29,0,0,0,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,
30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,1,1,1,
30,30,30,30,30,30,30,30,30,30,30,0,0,0,0,0,0,0),
(42,42,42,42,42,42,42,42,42,42,42,42,42,0,42,42,42,42,42,42,42,0,0,0,0,0,0,0,0,0,
0,0,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,1,1,0,0,0,0,0,
0,0,0,0,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,0,0,0,0,0,0,0,
0,0,0,0,0,45,45,45,45,45,45,45,45,45,45,45,45,45,0,45,45,45,0,45,45,0,0,0,0,0,0,0,
0,0,0,0,0),
(31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,
31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,
31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,
31,31,31,31,31,31,31,31,31,31,31,31,31,0,0,31,31,31,31,31,31,31,31,31,31,0,0,0,0,
0,0,31,31,31,31,31,31,31,31,31,31,0,0,0,0,0,0),
(32,32,1,1,32,1,32,32,32,32,32,32,32,32,32,0,32,32,32,32,32,32,32,32,32,32,0,0,0,
0,0,0,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0),
(32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,
28,28,28,28,28,28,28,28,0,0,0,0,0,0,0,0,0,0),
(46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,
46,46,46,46,0,46,46,46,46,46,46,46,46,46,46,46,46,0,0,0,0,46,46,46,46,46,46,46,46,
46,46,46,46,0,0,0,0,46,0,0,0,46,46,46,46,46,46,46,46,46,46,46,46,47,47,47,47,47,47,
47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,0,0,47,47,
47,47,47,0,0,0,0,0,0,0,0,0,0,0),
(56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,0,0,0,0,56,56,56,56,56,56,56,56,
56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,0,0,0,0,0,0,56,56,56,56,56,
56,56,56,56,56,56,0,0,0,56,56,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,
31,31,31,31,31,31,31,31,31,31,31,31,31,31,31),
(54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,
54,0,0,54,54,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,
78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,
78,78,78,78,78,78,78,78,78,78,78,78,78,0,78,78,78,78,78,78,78,78,78,78,78,78,78,78,
78,78,78,78,78,78,78,78,78,78,78,78,78,78,78,0,0,78),
(78,78,78,78,78,78,78,78,78,78,0,0,0,0,0,0,78,78,78,78,78,78,78,78,78,78,0,0,0,0,
0,0,78,78,78,78,78,78,78,78,78,78,78,78,78,78,0,0,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,0,0,0,0,62,62,62,
62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,
62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,0,0,0),
(67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,
67,67,67,67,67,67,67,67,67,67,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,
93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,93,
93,93,93,93,93,93,93,93,0,0,0,0,0,0,0,0,93,93,93,93),
(68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,
68,68,0,0,0,68,68,68,68,68,68,68,68,68,68,68,68,68,68,68,0,0,0,68,68,68,69,69,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,
69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69),
(4,4,4,4,4,4,4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,67,67,67,67,67,67,67,0,0,0,0,0,
0,0,0,41,41,41,1,41,41,41,41,41,41,41,41,41,41,41,41,41,1,41,41,41,41,41,41,41,1,
1,1,1,41,1,1,1,1,1,1,41,1,1,0,41,41,0,0,0,0,0,0),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,3,
3,3,3,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,3,3,3,3,3,2,2,2,2,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,4,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,3,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,0,0,0,0,0,41,41,41,41,41),
(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,0,0,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,3,3,3,0,0,3,
3,3,3,3,3,3,3,0,3,0,3,0,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,0,0),
(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,0,0,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,3,0,3,3,3,3,
3,3,3,3,3,0),
(1,1,1,1,1,1,1,1,1,1,1,1,41,41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,2,0,0,1,1,1,1,1,
1,1,1,1,1,1,2),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,3,1,
1,1,2,2,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,
53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,0,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,
57,57,57,57,57,57,57,57,57,57,57,57,57,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2),
(55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,
55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,
55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,
55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,
55,55,55,55,55,55,55,55,0,0,0,0,0,55,55,55,55,55,55,55),
(24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
24,24,24,24,24,24,24,24,24,24,24,0,24,0,0,0,0,0,24,0,0,58,58,58,58,58,58,58,58,58,
58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,
58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,0,0,0,0,0,0,0,58,58,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,58),
(26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,0,0,0,0,0,0,
0,0,0,26,26,26,26,26,26,26,0,26,26,26,26,26,26,26,0,26,26,26,26,26,26,26,0,26,26,
26,26,26,26,26,0,26,26,26,26,26,26,26,0,26,26,26,26,26,26,26,0,26,26,26,26,26,26,
26,0,26,26,26,26,26,26,26,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,0,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,
1,1,1,1,1,0,0,0,0),
(1,1,1,1,1,36,1,36,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,36,36,36,36,
36,36,36,36,36,41,41,41,41,25,25,1,1,1,1,1,1,1,1,36,36,36,36,1,1,1,1,0,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,
33,33,33,33,33),
(33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,0,0,41,41,1,
1,33,33,33,1,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,1,1,34,34,34),
(0,0,0,0,0,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,
35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,0,0,0,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25),
(25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,35,
35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,0,0,
0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,0,0,0,0,0,0,0,0,0,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34),
(25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,0),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37),
(37,37,37,37,37,37,37,37,37,37,37,37,37,0,0,0,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,
37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,0,0,0,0,0,0,0,0,0,83,83,83,83,83,
83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,
83,83,83,83,83,83,83,83,83,83,83,83,83,83,83,83),
(70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,
70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,
70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,
70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,
70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70),
(70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,
70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4),
(4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2),
(2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,0,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,
2,2,2,2,2,2),
(59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,
59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,
0,0,0,0,0,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,65,
65,65,65,65,65,0,0,0,0,0,0,0,0),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,0,0,0,0,0,0,0,0,71,71,71,71,71,71,
71,71,71,71,71,71,0,0,0,0,0,0,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,0,0),
(72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,
72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,72,1,72,73,73,73,73,73,73,73,
73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,
73,73,0,0,0,0,0,0,0,0,0,0,0,73,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,0,0,0),
(85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,
85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,0,1,85,85,
85,85,85,85,85,85,85,85,0,0,0,0,85,85,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,0),
(77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,
77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,
77,0,0,0,0,0,0,0,0,0,77,77,77,77,77,77,77,77,77,77,77,77,77,77,0,0,77,77,77,77,77,
77,77,77,77,77,0,0,77,77,77,77,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,
23,23,23,23,23,23,23,23,23,23,23,23,23,23,23),
(79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,79,
79,79,79,79,79,79,79,79,79,79,79,79,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,79,79,79,79,79,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,86,0,0,0,0,0,0,0,0,0),
(0,26,26,26,26,26,26,0,0,26,26,26,26,26,26,0,0,26,26,26,26,26,26,0,0,0,0,0,0,0,0,
0,26,26,26,26,26,26,26,0,26,26,26,26,26,26,26,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,3,0,0,0,0,
0,0,0,0,0,0,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27),
(27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,
27,27,27,27,27,27,27,27,27,27,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,86,
86,86,0,0,86,86,86,86,86,86,86,86,86,86,0,0,0,0,0,0),
(25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,0,0,0,0,0,0,0,0,0,0,0,0,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,0,0,0,0,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,25,25,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,0,0,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0),
(2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,5,5,5,5,5,0,0,0,0,0,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,0,6,6,6,6,6,0,6,0,6,6,0,6,6,0,6,6,6,6,6,6,6,6,6,6,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,0,0),
(41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,
1,0,0,0,0,7,7,7,7,7,0,7,7,7,7,7,7,7,7,7,7),
(7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,0,0,1),
(0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,34,34,34,34,34,34,34,34,34,34,1,34,34,34,
34,34,34,34,34,34,34,34,34,34,34,34),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,1,1,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,
25,25,25,25,25,25,25,25,0,0,0,25,25,25,25,25,25,0,0,25,25,25,25,25,25,0,0,25,25,25,
25,25,25,0,0,25,25,25,0,0,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,1,1,
1,1,1,0,0),
(48,48,48,48,48,48,48,48,48,48,48,48,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,0,48,48,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,0,0,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,0,0,0,0,0),
(1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3),
(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,41,0,0),
(74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,74,
74,74,0,0,0,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,
75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,75,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,0,0),
(38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,
38,38,38,38,38,38,38,38,38,0,0,0,0,0,0,0,0,0,0,0,0,39,39,39,39,39,39,39,39,39,39,
39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,0,0,0,0,0,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,
120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,120,0,0,0,0,0),
(49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,
49,49,49,0,49,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
60,60,60,60,60,60,60,60,60,60,60,60,60,0,0,0,0,60,60,60,60,60,60,60,60,60,60,60,60,
60,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0),
(40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,50,
50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,
50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50),
(51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,
51,51,51,0,0,51,51,51,51,51,51,51,51,51,51,0,0,0,0,0,0,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,0,0,0,0,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,136,
136,136,136,136,0,0,0,0),
(106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,
106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,106,0,
0,0,0,0,0,0,0,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,103,
103,103,103,103,103,103,103,103,103,103,103,103,103,103,0,0,0,0,0,0,0,0,0,0,0,103,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110),
(110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,0,0,0,0,0,0,0,0,0,110,110,
110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,110,0,
0,0,0,0,0,0,0,0,0,110,110,110,110,110,110,110,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(52,52,52,52,52,52,0,0,52,0,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,
52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,0,52,
52,0,0,0,52,0,0,52,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,87,
87,0,87,87,87,87,87,87,87,87,87,118,118,118,118,118,118,118,118,118,118,118,118,118,
118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118),
(117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,117,
117,117,117,117,117,117,117,117,117,117,117,0,0,0,0,0,0,0,0,117,117,117,117,117,117,
117,117,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
128,128,128,128,128,0,128,128,0,0,0,0,0,128,128,128,128,128),
(64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,0,0,0,64,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,76,
76,76,76,0,0,0,0,0,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,0,0,0,0,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,0,0,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,
97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97,97),
(61,61,61,61,0,61,61,0,0,0,0,0,61,61,61,61,61,61,61,61,0,61,61,61,0,61,61,61,61,61,
61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,0,0,0,0,61,61,61,
0,0,0,0,61,61,61,61,61,61,61,61,61,0,0,0,0,0,0,0,0,61,61,61,61,61,61,61,61,61,0,0,
0,0,0,0,0,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,88,
88,88,88,88,88,88,88,88),
(116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,
116,116,116,116,116,116,116,116,116,116,116,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,112,
112,112,112,112,112,0,0,0,0,112,112,112,112,112,112,112,112,112,112,112,112,0,0,0,
0,0,0,0,0,0),
(80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,
0,0,0,80,80,80,80,80,80,80,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,89,
89,89,89,89,0,0,89,89,89,89,89,89,89,89,90,90,90,90,90,90,90,90,90,90,90,90,90,90,
90,90,90,90,90,0,0,0,0,0,90,90,90,90,90,90,90,90),
(121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,121,0,0,0,0,
0,0,0,121,121,121,121,0,0,0,0,0,0,0,0,0,0,0,0,121,121,121,121,121,121,121,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,
91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,
91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,91,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0),
(130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
130,130,130,130,130,130,130,130,130,130,0,0,0,0,0,0,0,0,0,0,0,0,0,130,130,130,130,
130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,130,
130,130,130,130,130,0,0,0,0,0,0,0,130,130,130,130,130,130),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
7,7,7,7,7,0),
(94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,
94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,
94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,0,0,0,0,94,
94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,94,
94,94,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,94),
(92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,92,
92,92,92,92,92,92,92,92,92,92,92,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,101,101,101,101,
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,0,
0,0,0,0,0,0,101,101,101,101,101,101,101,101,101,101,0,0,0,0,0,0),
(96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,0,96,
96,96,96,96,96,96,96,96,96,96,96,96,96,0,0,0,0,0,0,0,0,0,0,0,0,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,
111,111,111,111,111,111,111,111,111,111,111,111,111,0,0,0,0,0,0,0,0,0),
(100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,0,0,100,100,100,100,
100,100,100,100,100,100,100,100,100,100,100,100,0,19,19,19,19,19,19,19,19,19,19,19,
19,19,19,19,19,19,19,19,19,0,0,0,0,0,0,0,0,0,0,0),
(109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,0,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,109,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(129,129,129,129,129,129,129,0,129,0,129,129,129,129,0,129,129,129,129,129,129,129,
129,129,129,129,129,129,129,129,0,129,129,129,129,129,129,129,129,129,129,129,0,0,
0,0,0,0,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,
123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,123,0,0,0,
0,0,123,123,123,123,123,123,123,123,123,123,0,0,0,0,0,0),
(107,107,107,107,0,107,107,107,107,107,107,107,107,0,0,107,107,0,0,107,107,107,107,
107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,107,0,107,107,
107,107,107,107,107,0,107,107,0,107,107,107,107,107,0,0,107,107,107,107,107,107,107,
107,107,0,0,107,107,0,0,107,107,107,0,0,107,0,0,0,0,0,0,107,0,0,0,0,0,107,107,107,
107,107,107,107,0,0,107,107,107,107,107,107,107,0,0,0,107,107,107,107,107,0,0,0,0,
0,0,0,0,0,0,0),
(135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,
135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,
135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,
135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,135,
135,135,135,135,135,135,135,0,135,0,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,
124,124,124,124,124,124,124,124,124,124,0,0,0,0,0,0,0,0,124,124,124,124,124,124,124,
124,124,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0),
(122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,122,122,122,0,0,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,122,
122,122,122,122,122,122,122,122,122,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,
114,114,114,114,114,114,114,0,0,0,0,0,0,0,0,0,0,0,114,114,114,114,114,114,114,114,
114,114,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0),
(102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,102,102,
102,102,102,102,102,102,102,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,
126,126,126,126,126,126,0,0,0,126,126,126,126,126,126,126,126,126,126,126,126,126,
126,126,0,0,0,0,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,
125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,125,0,0,0,0,0,0,0,0,0,
0,0,0,125),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,119,
119,119,119,119,119,119,0,0,0,0,0,0,0),
(133,133,133,133,133,133,133,133,133,0,133,133,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,0,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,0,0,0,0,0,0,0,0,0,0,133,133,133,133,133,133,133,133,133,
133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,133,0,
0,0,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134),
(134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,0,0,134,134,134,
134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,134,0,134,
134,134,134,134,134,134,134,134,134,134,134,134,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63),
(63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,0,63,63,63,63,63,0,0,0,0,0,0,0,0,0,0,0),
(63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
63,63,63,63,63,63,63,63,63,63,63,63,63,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81),
(81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,
81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,81,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127),
(127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,
127,127,127,127,127,127,127,127,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84),
(84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,84,
84,84,84,0,0,0,0,0,0,0,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,
115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,0,115,115,115,115,
115,115,115,115,115,115,0,0,0,0,115,115,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,
104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,104,
104,104,104,104,104,104,104,104,0,0,104,104,104,104,104,104,0,0,0,0,0,0,0,0,0,0),
(108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,0,0,0,0,0,0,0,0,0,0,108,108,108,108,108,108,108,108,
108,108,0,108,108,108,108,108,108,108,0,108,108,108,108,108,108,108,108,108,108,108,
108,108,108,108,108,108,108,108,108,108,0,0,0,0,0,108,108,108),
(108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,
99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,
99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,0,0,0,0,0,0,0,0,0,0,0,99,99,99,99,99,
99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,
99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137),
(137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,137,
137,137,137,137,137,137,137,137,137,137,137,0,0,0,0,0,0,0,0,0,0,0,0,0),
(34,33,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0),
(105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,105,
105,105,105,0,0,0,0,0,105,105,105,105,105,105,105,105,105,105,105,105,105,0,0,0),
(105,105,105,105,105,105,105,105,105,0,0,0,0,0,0,0,105,105,105,105,105,105,105,105,
105,105,0,0,105,105,105,105,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,41,41,41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,41,41,41,41,41),
(41,41,41,1,1,41,41,41,41,41,41,41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,41,41,41,41,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,0,0,1,0,0,1,1,0,
0,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,0,1,1,1,1,0,0,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,0,1,1,1,1,1,0,1,0,0,0,1,1,1,1,1,1,1,
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,
131,131,131),
(131,131,131,131,131,131,131,131,131,131,131,131,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,131,
131,131,131,131,0,131,131,131,131,131,131,131,131,131,131,131,131,131,131,131,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(57,57,57,57,57,57,57,0,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,0,0,57,
57,57,57,57,57,57,0,57,57,0,57,57,57,57,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113),
(113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,113,113,113,113,0,0,113,113,113,113,113,113,113,113,113,113,113,113,113,
113,113,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,
132,132,132,132,132,132,132,132,132,132,132,132,132,0,0,0,0,0,132,132,132,132,132,
132,132,132,132,132,0,0,0,0,132,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(7,7,7,7,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,7,7,0,7,0,0,7,
0,7,7,7,7,7,7,7,7,7,7,0,7,7,7,7,0,7,0,7,0,0,0,0,0,0,7,0,0,0,0,7,0,7,0,7,0,7,7,7,0,
7,7,0,7,0,0,7,0,7,0,7,0,7,0,7,0,7,7,0,7,0,0,7,7,7,7,0,7,7,7,7,7,7,7,0,7,7,7,7,0,7,
7,7,7,0,7,0),
(7,7,7,7,7,7,7,7,7,7,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,7,7,7,0,7,7,7,
7,7,0,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(33,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,1,1,1,1,1,1,1,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,
0,0,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,0,0,
0,0,0,0,0,0,0,0,0,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,0,0,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
36,36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1),
(41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41),
(41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,
41,41,41,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
);

// PUCUUnicodeScriptArrayIndex: 1200 bytes, 29 blocks with 32 items per 1 bytes and 272 indices per 1 bytes
const PUCUUnicodeScriptArrayIndexBlockBits=5;
      PUCUUnicodeScriptArrayIndexBlockMask=31;
      PUCUUnicodeScriptArrayIndexBlockSize=32;
      PUCUUnicodeScriptArrayIndexBlockCount=29;
      PUCUUnicodeScriptArrayIndexBlockData:array[0..28,0..31] of byte=(
(0,1,2,2,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29),
(30,31,32,32,33,34,35,36,37,37,37,37,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,
52,2,2,53,54),
(55,56,57,58,59,59,59,60,61,59,59,59,59,59,59,59,62,62,59,59,59,59,63,64,65,66,67,
68,69,70,71,72),
(73,74,75,76,77,78,79,59,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
80,71,71,71,71),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,81),
(82,82,82,82,82,82,82,82,82,83,84,84,85,86,87,88,89,90,91,92,93,94,95,96,32,32,32,
32,32,32,32,32),
(32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32),
(32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,97,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98),
(98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98),
(98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,71,71,99,100,101,102,103,103,
104,105,106,107,108,109),
(110,111,112,113,98,114,115,116,117,118,119,98,120,120,121,98,122,123,124,125,126,
127,128,129,130,131,98,98,132,98,98,98),
(133,134,135,136,137,138,139,98,140,141,98,142,143,144,145,98,98,146,98,98,98,147,
98,98,148,149,98,98,98,98,98,98),
(150,150,150,150,150,150,150,151,152,150,153,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98,98,98,98,98),
(154,154,154,154,154,154,154,154,155,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98,98,98,98),
(98,98,98,98,98,98,98,98,156,156,156,156,157,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98,98,98),
(98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,158,158,158,158,159,160,161,162,
98,98,98,98,98,98,163,164),
(165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,
165,165,165,165,165,165,165,165,165,165,165,165),
(165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,166,165,165,165,165,
165,167,98,98,98,98,98,98,98,98,98,98),
(168,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,169,170,
98,98,98,98,98,98),
(59,171,172,173,174,98,175,98,176,177,178,59,59,179,59,180,181,181,181,181,181,182,
98,98,98,98,98,98,98,98,98,98),
(183,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,184,185,186,98,98,98,98,98,98,98,
98,98,187,188,98,98),
(189,190,191,192,193,98,59,59,59,59,59,59,59,194,195,196,197,198,199,200,98,98,98,
98,98,98,98,98,98,98,98,98),
(71,71,71,71,71,71,71,71,71,71,71,71,71,201,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,71,71,71),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,202,71,203,71,71,71,71,71,71,71,71,71,
71,71,71,71,71,71),
(71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,
71,71,204,98,98),
(98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,71,71,71,71,205,98,98,98,98,98,98,
98,98,98,98,98),
(206,98,207,208,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,98,
98,98,98,98,98,98)
);
      PUCUUnicodeScriptArrayIndexIndexCount=29;
      PUCUUnicodeScriptArrayIndexIndexData:array[0..271] of byte=(
0,1,2,3,4,5,5,5,5,6,7,8,8,9,10,11,12,13,14,15,16,10,17,18,19,10,10,20,10,21,22,23,
5,5,5,5,5,5,5,5,5,5,24,25,26,10,10,27,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,28,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10
);


// PUCUUnicodeUpperCaseDeltaArray: 28160 bytes, 38 blocks with 128 items per 4 bytes and 8704 indices per 4 bytes
const PUCUUnicodeUpperCaseDeltaArrayBlockBits=7;
      PUCUUnicodeUpperCaseDeltaArrayBlockMask=127;
      PUCUUnicodeUpperCaseDeltaArrayBlockSize=128;
      PUCUUnicodeUpperCaseDeltaArrayBlockCount=38;
      PUCUUnicodeUpperCaseDeltaArrayBlockData:array[0..37,0..127] of longint=(
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,743,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,-32,-32,-32,-32,-32,-32,-32,121),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-232,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,-300),
(195,0,0,-1,0,-1,0,0,-1,0,0,0,-1,0,0,0,0,0,-1,0,0,97,0,0,0,-1,163,0,0,0,130,0,0,-1,
0,-1,0,-1,0,0,-1,0,0,0,0,-1,0,0,-1,0,0,0,-1,0,-1,0,0,-1,0,0,0,-1,0,56,0,0,0,0,0,-1,
-2,0,-1,-2,0,-1,-2,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-79,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,-2,0,-1,0,0,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,-1,0,0,10815,10815,
0,-1,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,10783,10780,10782,-210,-206,0,-205,-205,0,-202,
0,-203,42319,0,0,0,-205,42315,0,-207,0,42280,42308,0,-209,-211,42308,10743,42305,
0,0,-211,0,10749,-213,0,0,-214,0,0,0,0,0,0,0,10727,0,0),
(-218,0,0,-218,0,0,0,42282,-218,-69,-217,-217,-71,0,0,0,0,0,-219,0,0,0,0,0,0,0,0,
0,0,42261,42258,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,-1,
0,0,0,130,130,130,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-38,-37,-37,-37,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-31,-32,-32,-32,-32,-32,-32,-32,-32,-32,-64,-63,-63,0,-62,-57,0,0,0,-47,
-54,-8,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-86,-80,7,-116,
0,-96,0,0,-1,0,0,-1,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-80,-80,-80,-80,-80,-80,
-80,-80,-80,-80,-80,-80,-80,-80,-80,-80,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,0,0,0,0,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-15,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48),
(-48,-48,-48,-48,-48,-48,-48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-8,
-8,-8,-8,-8,-8,0,0),
(-6254,-6253,-6244,-6242,-6242,-6243,-6236,-6181,35266,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35332,
0,0,0,3814,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,-59,0,0,0,0,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,
0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,
8,0,8,0,8,0,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,74,74,86,86,86,86,100,
100,128,128,112,112,126,126,0,0),
(8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,
0,0,0,0,0,0,0,0,8,8,0,9,0,0,0,0,0,0,0,0,0,0,-7205,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,
0,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,
0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-28,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-16,-16,-16,-16,-16,
-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16),
(0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-26,
-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,
-26,-26,-26,-26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,0,0,-1,0,0,0,-10795,-10792,0,-1,0,-1,0,-1,0,0,
0,0,0,0,-1,0,0,-1,0,0,0,0,0,0,0,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0),
(-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,
-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,
-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,0,-7264,0,0,0,0,0,-7264,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,0,0,0,-1,0,0,0,0,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-928,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864),
(-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,0,0,0,
0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-64,-64,-64,-64,-64,-64,-64,-64,-64,
-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,
-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-34,-34,-34,
-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,
-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
);

// PUCUUnicodeUpperCaseDeltaArrayIndex: 560 bytes, 9 blocks with 32 items per 1 bytes and 272 indices per 1 bytes
const PUCUUnicodeUpperCaseDeltaArrayIndexBlockBits=5;
      PUCUUnicodeUpperCaseDeltaArrayIndexBlockMask=31;
      PUCUUnicodeUpperCaseDeltaArrayIndexBlockSize=32;
      PUCUUnicodeUpperCaseDeltaArrayIndexBlockCount=9;
      PUCUUnicodeUpperCaseDeltaArrayIndexBlockData:array[0..8,0..31] of byte=(
(0,1,2,3,4,5,6,7,8,9,10,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12),
(12,12,12,12,12,12,12,13,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,14,15,
12,16,17,18,19),
(12,12,20,21,12,12,12,12,12,22,12,12,12,12,12,12,12,12,12,12,12,12,12,12,23,24,25,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,26,27,28,29,12,12,12,12,12,12,30,31,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,32,12),
(12,12,12,12,12,12,12,12,33,34,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,35,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,36,12,12,12,12,12,12,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,37,12,12,12,12,12,12,12,12,
12,12,12,12,12)
);
      PUCUUnicodeUpperCaseDeltaArrayIndexIndexCount=9;
      PUCUUnicodeUpperCaseDeltaArrayIndexIndexData:array[0..271] of byte=(
0,1,2,3,3,3,3,3,3,3,4,3,3,3,3,5,6,7,3,3,3,3,3,3,3,3,3,3,3,3,8,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
);

// PUCUUnicodeLowerCaseDeltaArray: 25088 bytes, 32 blocks with 128 items per 4 bytes and 8704 indices per 4 bytes
const PUCUUnicodeLowerCaseDeltaArrayBlockBits=7;
      PUCUUnicodeLowerCaseDeltaArrayBlockMask=127;
      PUCUUnicodeLowerCaseDeltaArrayBlockSize=128;
      PUCUUnicodeLowerCaseDeltaArrayBlockCount=32;
      PUCUUnicodeLowerCaseDeltaArrayBlockData:array[0..31,0..127] of longint=(
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,0,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,-199,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
-121,1,0,1,0,1,0,0),
(0,210,1,0,1,0,206,1,0,205,205,1,0,0,79,202,203,1,0,205,207,0,211,209,1,0,0,0,211,
213,0,214,1,0,1,0,1,0,218,1,0,218,0,0,1,0,218,1,0,217,217,1,0,1,0,219,1,0,0,0,1,0,
0,0,0,0,0,0,2,1,0,2,1,0,2,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,0,2,1,0,1,0,-97,-56,1,0,1,0,1,0,1,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,-130,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,10795,1,0,-163,10792,0,0,1,0,-195,69,71,1,0,
1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,
0,0,0,0,0,116),
(0,0,0,0,0,0,38,0,37,37,37,0,64,0,63,63,0,32,32,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,0,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,0,0,0,0,-60,0,0,1,0,-7,1,0,0,-130,-130,-130),
(80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,80,32,32,32,32,32,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0),
(1,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,15,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7264,7264,7264,7264,
7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,
7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,7264,
0,7264,0,0,0,0,0,7264,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,38864,
38864,38864,38864,38864,38864,38864,38864,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,-7615,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0),
(0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,0,0,0,
0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,
0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,0,0,0,-8,0,-8,0,-8,0,-8,0,0,0,0,0,0,
0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,
0,0,0,0,0,0,0,0,-8,-8,-8,-8,-8,-8,-8,-8,0,0,0,0,0,0,0,0,-8,-8,-74,-74,-9,0,0,0,0,
0,0,0,0,0,0,0,-86,-86,-86,-86,-9,0,0,0,0,0,0,0,0,0,0,0,-8,-8,-100,-100,0,0,0,0,0,
0,0,0,0,0,0,0,-8,-8,-112,-112,-7,0,0,0,0,0,0,0,0,0,0,0,-128,-128,-126,-126,-9,0,0,
0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-7517,
0,0,0,-8383,-8262,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,16,16,16,16,16,16,16,16,16,16,
16,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,
26,26,26,26,26,26,26,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,-10743,
-3814,-10727,0,0,1,0,1,0,1,0,-10780,-10749,-10783,-10782,0,1,0,0,1,0,0,0,0,0,0,0,
0,-10815,-10815),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,
1,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,
0,1,0,-35332,1,0),
(1,0,1,0,1,0,1,0,0,0,0,1,0,-42280,0,0,1,0,1,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
1,0,1,0,-42308,-42319,-42315,-42305,-42308,0,-42258,-42282,-42261,928,1,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,
40,40,40,40,40,40,40,40,40,40,40,40,40,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,32,32,32,32,32,
32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,
34,34,34,34,34,34,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
);

// PUCUUnicodeLowerCaseDeltaArrayIndex: 560 bytes, 9 blocks with 32 items per 1 bytes and 272 indices per 1 bytes
const PUCUUnicodeLowerCaseDeltaArrayIndexBlockBits=5;
      PUCUUnicodeLowerCaseDeltaArrayIndexBlockMask=31;
      PUCUUnicodeLowerCaseDeltaArrayIndexBlockSize=32;
      PUCUUnicodeLowerCaseDeltaArrayIndexBlockCount=9;
      PUCUUnicodeLowerCaseDeltaArrayIndexBlockData:array[0..8,0..31] of byte=(
(0,1,2,3,4,5,6,7,8,9,10,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,11,5,5,5,5,5,12,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,13,14,15,16),
(5,5,17,18,5,5,5,5,5,19,5,5,5,5,5,5,5,5,5,5,5,5,5,5,20,21,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,22,23,24,25,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,26,5),
(5,5,5,5,5,5,5,5,27,28,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,29,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,30,5,5,5,5,5,5,5,5,5,5,5,5,5,5),
(5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,31,5,5,5,5,5,5,5,5,5,5,5,5,5)
);
      PUCUUnicodeLowerCaseDeltaArrayIndexIndexCount=9;
      PUCUUnicodeLowerCaseDeltaArrayIndexIndexData:array[0..271] of byte=(
0,1,2,3,3,3,3,3,3,3,4,3,3,3,3,5,6,7,3,3,3,3,3,3,3,3,3,3,3,3,8,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
);

// PUCUUnicodeTitleCaseDeltaArray: 28160 bytes, 38 blocks with 128 items per 4 bytes and 8704 indices per 4 bytes
const PUCUUnicodeTitleCaseDeltaArrayBlockBits=7;
      PUCUUnicodeTitleCaseDeltaArrayBlockMask=127;
      PUCUUnicodeTitleCaseDeltaArrayBlockSize=128;
      PUCUUnicodeTitleCaseDeltaArrayBlockCount=38;
      PUCUUnicodeTitleCaseDeltaArrayBlockData:array[0..37,0..127] of longint=(
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,743,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,-32,-32,-32,-32,-32,-32,-32,121),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-232,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,0,-1,0,-1,-300),
(195,0,0,-1,0,-1,0,0,-1,0,0,0,-1,0,0,0,0,0,-1,0,0,97,0,0,0,-1,163,0,0,0,130,0,0,-1,
0,-1,0,-1,0,0,-1,0,0,0,0,-1,0,0,-1,0,0,0,-1,0,-1,0,0,-1,0,0,0,-1,0,56,0,0,0,0,1,0,
-1,1,0,-1,1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-79,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,1,0,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,-1,0,0,10815,10815,
0,-1,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,10783,10780,10782,-210,-206,0,-205,-205,0,-202,
0,-203,42319,0,0,0,-205,42315,0,-207,0,42280,42308,0,-209,-211,42308,10743,42305,
0,0,-211,0,10749,-213,0,0,-214,0,0,0,0,0,0,0,10727,0,0),
(-218,0,0,-218,0,0,0,42282,-218,-69,-217,-217,-71,0,0,0,0,0,-219,0,0,0,0,0,0,0,0,
0,0,42261,42258,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,-1,
0,0,0,130,130,130,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,-38,-37,-37,-37,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-31,-32,-32,-32,-32,-32,-32,-32,-32,-32,-64,-63,-63,0,-62,-57,0,0,0,-47,
-54,-8,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-86,-80,7,-116,
0,-96,0,0,-1,0,0,-1,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-80,-80,-80,-80,-80,-80,
-80,-80,-80,-80,-80,-80,-80,-80,-80,-80,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,0,0,0,0,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,-15,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48),
(-48,-48,-48,-48,-48,-48,-48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-8,
-8,-8,-8,-8,-8,0,0),
(-6254,-6253,-6244,-6242,-6242,-6243,-6236,-6181,35266,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35332,
0,0,0,3814,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,-59,0,0,0,0,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1),
(8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,
0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,
8,0,8,0,8,0,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,74,74,86,86,86,86,100,
100,128,128,112,112,126,126,0,0),
(8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,
0,0,0,0,0,0,0,0,8,8,0,9,0,0,0,0,0,0,0,0,0,0,-7205,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,
0,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,
0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-28,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-16,-16,-16,-16,-16,
-16,-16,-16,-16,-16,-16,-16,-16,-16,-16,-16),
(0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-26,
-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,-26,
-26,-26,-26,-26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,-48,
-48,-48,-48,-48,-48,-48,-48,-48,-48,0,0,-1,0,0,0,-10795,-10792,0,-1,0,-1,0,-1,0,0,
0,0,0,0,-1,0,0,-1,0,0,0,0,0,0,0,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0),
(-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,
-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,
-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,-7264,0,-7264,0,0,0,0,0,-7264,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,0,
-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,-1),
(0,-1,0,-1,0,-1,0,-1,0,0,0,0,-1,0,0,0,0,-1,0,-1,0,0,0,-1,0,-1,0,-1,0,-1,0,-1,0,-1,
0,-1,0,-1,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,-1,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,-928,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864),
(-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,-38864,
-38864,-38864,-38864,-38864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,
-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,-40,0,0,0,
0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-64,-64,-64,-64,-64,-64,-64,-64,-64,
-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,
-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,-64,
0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,-32,
-32,-32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),
(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-34,-34,-34,
-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,
-34,-34,-34,-34,-34,-34,-34,-34,-34,-34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)
);

// PUCUUnicodeTitleCaseDeltaArrayIndex: 560 bytes, 9 blocks with 32 items per 1 bytes and 272 indices per 1 bytes
const PUCUUnicodeTitleCaseDeltaArrayIndexBlockBits=5;
      PUCUUnicodeTitleCaseDeltaArrayIndexBlockMask=31;
      PUCUUnicodeTitleCaseDeltaArrayIndexBlockSize=32;
      PUCUUnicodeTitleCaseDeltaArrayIndexBlockCount=9;
      PUCUUnicodeTitleCaseDeltaArrayIndexBlockData:array[0..8,0..31] of byte=(
(0,1,2,3,4,5,6,7,8,9,10,11,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12),
(12,12,12,12,12,12,12,13,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,14,15,
12,16,17,18,19),
(12,12,20,21,12,12,12,12,12,22,12,12,12,12,12,12,12,12,12,12,12,12,12,12,23,24,25,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,26,27,28,29,12,12,12,12,12,12,30,31,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
12,12,12,32,12),
(12,12,12,12,12,12,12,12,33,34,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,35,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,36,12,12,12,12,12,12,12,12,12,
12,12,12,12,12),
(12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,37,12,12,12,12,12,12,12,12,
12,12,12,12,12)
);
      PUCUUnicodeTitleCaseDeltaArrayIndexIndexCount=9;
      PUCUUnicodeTitleCaseDeltaArrayIndexIndexData:array[0..271] of byte=(
0,1,2,3,3,3,3,3,3,3,4,3,3,3,3,5,6,7,3,3,3,3,3,3,3,3,3,3,3,3,8,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
);

const PUCUucrWORDS=0;
      PUCUucrDIGITS=1;
      PUCUucrWHITESPACES=2;
      PUCUucrLAST=PUCUucrWHITESPACES;

type PPUCUUnicodeCharRange=^TPUCUUnicodeCharRange;
     TPUCUUnicodeCharRange=array[0..1] of longword;

     PPUCUUnicodeCharRanges=^TPUCUUnicodeCharRanges;
     TPUCUUnicodeCharRanges=array[0..0] of TPUCUUnicodeCharRange;

const PUCUUnicodeCharRangeClasses0:array[0..647] of TPUCUUnicodeCharRange=(
(48,57),
(65,90),
(95,95),
(97,122),
(170,170),
(178,179),
(181,181),
(185,186),
(188,190),
(192,214),
(216,246),
(248,705),
(710,721),
(736,740),
(748,748),
(750,750),
(880,884),
(886,887),
(890,893),
(895,895),
(902,902),
(904,906),
(908,908),
(910,929),
(931,1013),
(1015,1153),
(1162,1327),
(1329,1366),
(1369,1369),
(1377,1415),
(1488,1514),
(1520,1522),
(1568,1610),
(1632,1641),
(1646,1647),
(1649,1747),
(1749,1749),
(1765,1766),
(1774,1788),
(1791,1791),
(1808,1808),
(1810,1839),
(1869,1957),
(1969,1969),
(1984,2026),
(2036,2037),
(2042,2042),
(2048,2069),
(2074,2074),
(2084,2084),
(2088,2088),
(2112,2136),
(2208,2228),
(2230,2237),
(2308,2361),
(2365,2365),
(2384,2384),
(2392,2401),
(2406,2415),
(2417,2432),
(2437,2444),
(2447,2448),
(2451,2472),
(2474,2480),
(2482,2482),
(2486,2489),
(2493,2493),
(2510,2510),
(2524,2525),
(2527,2529),
(2534,2545),
(2548,2553),
(2565,2570),
(2575,2576),
(2579,2600),
(2602,2608),
(2610,2611),
(2613,2614),
(2616,2617),
(2649,2652),
(2654,2654),
(2662,2671),
(2674,2676),
(2693,2701),
(2703,2705),
(2707,2728),
(2730,2736),
(2738,2739),
(2741,2745),
(2749,2749),
(2768,2768),
(2784,2785),
(2790,2799),
(2809,2809),
(2821,2828),
(2831,2832),
(2835,2856),
(2858,2864),
(2866,2867),
(2869,2873),
(2877,2877),
(2908,2909),
(2911,2913),
(2918,2927),
(2929,2935),
(2947,2947),
(2949,2954),
(2958,2960),
(2962,2965),
(2969,2970),
(2972,2972),
(2974,2975),
(2979,2980),
(2984,2986),
(2990,3001),
(3024,3024),
(3046,3058),
(3077,3084),
(3086,3088),
(3090,3112),
(3114,3129),
(3133,3133),
(3160,3162),
(3168,3169),
(3174,3183),
(3192,3198),
(3200,3200),
(3205,3212),
(3214,3216),
(3218,3240),
(3242,3251),
(3253,3257),
(3261,3261),
(3294,3294),
(3296,3297),
(3302,3311),
(3313,3314),
(3333,3340),
(3342,3344),
(3346,3386),
(3389,3389),
(3406,3406),
(3412,3414),
(3416,3425),
(3430,3448),
(3450,3455),
(3461,3478),
(3482,3505),
(3507,3515),
(3517,3517),
(3520,3526),
(3558,3567),
(3585,3632),
(3634,3635),
(3648,3654),
(3664,3673),
(3713,3714),
(3716,3716),
(3719,3720),
(3722,3722),
(3725,3725),
(3732,3735),
(3737,3743),
(3745,3747),
(3749,3749),
(3751,3751),
(3754,3755),
(3757,3760),
(3762,3763),
(3773,3773),
(3776,3780),
(3782,3782),
(3792,3801),
(3804,3807),
(3840,3840),
(3872,3891),
(3904,3911),
(3913,3948),
(3976,3980),
(4096,4138),
(4159,4169),
(4176,4181),
(4186,4189),
(4193,4193),
(4197,4198),
(4206,4208),
(4213,4225),
(4238,4238),
(4240,4249),
(4256,4293),
(4295,4295),
(4301,4301),
(4304,4346),
(4348,4680),
(4682,4685),
(4688,4694),
(4696,4696),
(4698,4701),
(4704,4744),
(4746,4749),
(4752,4784),
(4786,4789),
(4792,4798),
(4800,4800),
(4802,4805),
(4808,4822),
(4824,4880),
(4882,4885),
(4888,4954),
(4969,4988),
(4992,5007),
(5024,5109),
(5112,5117),
(5121,5740),
(5743,5759),
(5761,5786),
(5792,5866),
(5870,5880),
(5888,5900),
(5902,5905),
(5920,5937),
(5952,5969),
(5984,5996),
(5998,6000),
(6016,6067),
(6103,6103),
(6108,6108),
(6112,6121),
(6128,6137),
(6160,6169),
(6176,6263),
(6272,6276),
(6279,6312),
(6314,6314),
(6320,6389),
(6400,6430),
(6470,6509),
(6512,6516),
(6528,6571),
(6576,6601),
(6608,6618),
(6656,6678),
(6688,6740),
(6784,6793),
(6800,6809),
(6823,6823),
(6917,6963),
(6981,6987),
(6992,7001),
(7043,7072),
(7086,7141),
(7168,7203),
(7232,7241),
(7245,7293),
(7296,7304),
(7401,7404),
(7406,7409),
(7413,7414),
(7424,7615),
(7680,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8016,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8064,8116),
(8118,8124),
(8126,8126),
(8130,8132),
(8134,8140),
(8144,8147),
(8150,8155),
(8160,8172),
(8178,8180),
(8182,8188),
(8255,8256),
(8276,8276),
(8304,8305),
(8308,8313),
(8319,8329),
(8336,8348),
(8450,8450),
(8455,8455),
(8458,8467),
(8469,8469),
(8473,8477),
(8484,8484),
(8486,8486),
(8488,8488),
(8490,8493),
(8495,8505),
(8508,8511),
(8517,8521),
(8526,8526),
(8528,8585),
(9312,9371),
(9450,9471),
(10102,10131),
(11264,11310),
(11312,11358),
(11360,11492),
(11499,11502),
(11506,11507),
(11517,11517),
(11520,11557),
(11559,11559),
(11565,11565),
(11568,11623),
(11631,11631),
(11648,11670),
(11680,11686),
(11688,11694),
(11696,11702),
(11704,11710),
(11712,11718),
(11720,11726),
(11728,11734),
(11736,11742),
(11823,11823),
(12293,12295),
(12321,12329),
(12337,12341),
(12344,12348),
(12353,12438),
(12445,12447),
(12449,12538),
(12540,12543),
(12549,12589),
(12593,12686),
(12690,12693),
(12704,12730),
(12784,12799),
(12832,12841),
(12872,12879),
(12881,12895),
(12928,12937),
(12977,12991),
(13312,19893),
(19968,40917),
(40960,42124),
(42192,42237),
(42240,42508),
(42512,42539),
(42560,42606),
(42623,42653),
(42656,42735),
(42775,42783),
(42786,42888),
(42891,42926),
(42928,42935),
(42999,43009),
(43011,43013),
(43015,43018),
(43020,43042),
(43056,43061),
(43072,43123),
(43138,43187),
(43216,43225),
(43250,43255),
(43259,43259),
(43261,43261),
(43264,43301),
(43312,43334),
(43360,43388),
(43396,43442),
(43471,43481),
(43488,43492),
(43494,43518),
(43520,43560),
(43584,43586),
(43588,43595),
(43600,43609),
(43616,43638),
(43642,43642),
(43646,43695),
(43697,43697),
(43701,43702),
(43705,43709),
(43712,43712),
(43714,43714),
(43739,43741),
(43744,43754),
(43762,43764),
(43777,43782),
(43785,43790),
(43793,43798),
(43808,43814),
(43816,43822),
(43824,43866),
(43868,43877),
(43888,44002),
(44016,44025),
(44032,55203),
(55216,55238),
(55243,55291),
(63744,64109),
(64112,64217),
(64256,64262),
(64275,64279),
(64285,64285),
(64287,64296),
(64298,64310),
(64312,64316),
(64318,64318),
(64320,64321),
(64323,64324),
(64326,64433),
(64467,64829),
(64848,64911),
(64914,64967),
(65008,65019),
(65075,65076),
(65101,65103),
(65136,65140),
(65142,65276),
(65296,65305),
(65313,65338),
(65343,65343),
(65345,65370),
(65382,65470),
(65474,65479),
(65482,65487),
(65490,65495),
(65498,65500),
(65536,65547),
(65549,65574),
(65576,65594),
(65596,65597),
(65599,65613),
(65616,65629),
(65664,65786),
(65799,65843),
(65856,65912),
(65930,65931),
(66176,66204),
(66208,66256),
(66273,66299),
(66304,66339),
(66352,66378),
(66384,66421),
(66432,66461),
(66464,66499),
(66504,66511),
(66513,66517),
(66560,66717),
(66720,66729),
(66736,66771),
(66776,66811),
(66816,66855),
(66864,66915),
(67072,67382),
(67392,67413),
(67424,67431),
(67584,67589),
(67592,67592),
(67594,67637),
(67639,67640),
(67644,67644),
(67647,67669),
(67672,67702),
(67705,67742),
(67751,67759),
(67808,67826),
(67828,67829),
(67835,67867),
(67872,67897),
(67968,68023),
(68028,68047),
(68050,68096),
(68112,68115),
(68117,68119),
(68121,68147),
(68160,68167),
(68192,68222),
(68224,68255),
(68288,68295),
(68297,68324),
(68331,68335),
(68352,68405),
(68416,68437),
(68440,68466),
(68472,68497),
(68521,68527),
(68608,68680),
(68736,68786),
(68800,68850),
(68858,68863),
(69216,69246),
(69635,69687),
(69714,69743),
(69763,69807),
(69840,69864),
(69872,69881),
(69891,69926),
(69942,69951),
(69968,70002),
(70006,70006),
(70019,70066),
(70081,70084),
(70096,70106),
(70108,70108),
(70113,70132),
(70144,70161),
(70163,70187),
(70272,70278),
(70280,70280),
(70282,70285),
(70287,70301),
(70303,70312),
(70320,70366),
(70384,70393),
(70405,70412),
(70415,70416),
(70419,70440),
(70442,70448),
(70450,70451),
(70453,70457),
(70461,70461),
(70480,70480),
(70493,70497),
(70656,70708),
(70727,70730),
(70736,70745),
(70784,70831),
(70852,70853),
(70855,70855),
(70864,70873),
(71040,71086),
(71128,71131),
(71168,71215),
(71236,71236),
(71248,71257),
(71296,71338),
(71360,71369),
(71424,71449),
(71472,71483),
(71840,71922),
(71935,71935),
(72384,72440),
(72704,72712),
(72714,72750),
(72768,72768),
(72784,72812),
(72818,72847),
(73728,74649),
(74752,74862),
(74880,75075),
(77824,78894),
(82944,83526),
(92160,92728),
(92736,92766),
(92768,92777),
(92880,92909),
(92928,92975),
(92992,92995),
(93008,93017),
(93019,93025),
(93027,93047),
(93053,93071),
(93952,94020),
(94032,94032),
(94099,94111),
(94176,94176),
(94208,100332),
(100352,101106),
(110592,110593),
(113664,113770),
(113776,113788),
(113792,113800),
(113808,113817),
(119648,119665),
(119808,119892),
(119894,119964),
(119966,119967),
(119970,119970),
(119973,119974),
(119977,119980),
(119982,119993),
(119995,119995),
(119997,120003),
(120005,120069),
(120071,120074),
(120077,120084),
(120086,120092),
(120094,120121),
(120123,120126),
(120128,120132),
(120134,120134),
(120138,120144),
(120146,120485),
(120488,120512),
(120514,120538),
(120540,120570),
(120572,120596),
(120598,120628),
(120630,120654),
(120656,120686),
(120688,120712),
(120714,120744),
(120746,120770),
(120772,120779),
(120782,120831),
(124928,125124),
(125127,125135),
(125184,125251),
(125264,125273),
(126464,126467),
(126469,126495),
(126497,126498),
(126500,126500),
(126503,126503),
(126505,126514),
(126516,126519),
(126521,126521),
(126523,126523),
(126530,126530),
(126535,126535),
(126537,126537),
(126539,126539),
(126541,126543),
(126545,126546),
(126548,126548),
(126551,126551),
(126553,126553),
(126555,126555),
(126557,126557),
(126559,126559),
(126561,126562),
(126564,126564),
(126567,126570),
(126572,126578),
(126580,126583),
(126585,126588),
(126590,126590),
(126592,126601),
(126603,126619),
(126625,126627),
(126629,126633),
(126635,126651),
(127232,127244),
(131072,173782),
(173824,177972),
(177984,178205),
(178208,183969),
(194560,195101)
);

const PUCUUnicodeCharRangeClasses1:array[0..53] of TPUCUUnicodeCharRange=(
(48,57),
(1632,1641),
(1776,1785),
(1984,1993),
(2406,2415),
(2534,2543),
(2662,2671),
(2790,2799),
(2918,2927),
(3046,3055),
(3174,3183),
(3302,3311),
(3430,3439),
(3558,3567),
(3664,3673),
(3792,3801),
(3872,3881),
(4160,4169),
(4240,4249),
(6112,6121),
(6160,6169),
(6470,6479),
(6608,6617),
(6784,6793),
(6800,6809),
(6992,7001),
(7088,7097),
(7232,7241),
(7248,7257),
(42528,42537),
(43216,43225),
(43264,43273),
(43472,43481),
(43504,43513),
(43600,43609),
(44016,44025),
(65296,65305),
(66720,66729),
(69734,69743),
(69872,69881),
(69942,69951),
(70096,70105),
(70384,70393),
(70736,70745),
(70864,70873),
(71248,71257),
(71360,71369),
(71472,71481),
(71904,71913),
(72784,72793),
(92768,92777),
(93008,93017),
(120782,120831),
(125264,125273)
);

const PUCUUnicodeCharRangeClasses2:array[0..11] of TPUCUUnicodeCharRange=(
(9,13),
(32,32),
(160,160),
(5760,5760),
(6158,6158),
(8192,8203),
(8232,8233),
(8239,8239),
(8287,8287),
(12288,12288),
(65279,65279),
(65534,65534)
);

const PUCUUnicodeCharRangeClassesData:array[0..2] of pointer=(
@PUCUUnicodeCharRangeClasses0,
@PUCUUnicodeCharRangeClasses1,
@PUCUUnicodeCharRangeClasses2
);

const PUCUUnicodeCharRangeClassesCounts:array[0..2] of longint=(
648,
54,
12
);

const PUCUCountUnicodeCategoryBlocks=29;

const PUCUUnicodeCategoryBlocks0:array[0..637] of TPUCUUnicodeCharRange=(
(888,889),
(896,899),
(907,907),
(909,909),
(930,930),
(1328,1328),
(1367,1368),
(1376,1376),
(1416,1416),
(1419,1420),
(1424,1424),
(1480,1487),
(1515,1519),
(1525,1535),
(1565,1565),
(1806,1806),
(1867,1868),
(1970,1983),
(2043,2047),
(2094,2095),
(2111,2111),
(2140,2141),
(2143,2207),
(2229,2229),
(2238,2259),
(2436,2436),
(2445,2446),
(2449,2450),
(2473,2473),
(2481,2481),
(2483,2485),
(2490,2491),
(2501,2502),
(2505,2506),
(2511,2518),
(2520,2523),
(2526,2526),
(2532,2533),
(2556,2560),
(2564,2564),
(2571,2574),
(2577,2578),
(2601,2601),
(2609,2609),
(2612,2612),
(2615,2615),
(2618,2619),
(2621,2621),
(2627,2630),
(2633,2634),
(2638,2640),
(2642,2648),
(2653,2653),
(2655,2661),
(2678,2688),
(2692,2692),
(2702,2702),
(2706,2706),
(2729,2729),
(2737,2737),
(2740,2740),
(2746,2747),
(2758,2758),
(2762,2762),
(2766,2767),
(2769,2783),
(2788,2789),
(2802,2808),
(2810,2816),
(2820,2820),
(2829,2830),
(2833,2834),
(2857,2857),
(2865,2865),
(2868,2868),
(2874,2875),
(2885,2886),
(2889,2890),
(2894,2901),
(2904,2907),
(2910,2910),
(2916,2917),
(2936,2945),
(2948,2948),
(2955,2957),
(2961,2961),
(2966,2968),
(2971,2971),
(2973,2973),
(2976,2978),
(2981,2983),
(2987,2989),
(3002,3005),
(3011,3013),
(3017,3017),
(3022,3023),
(3025,3030),
(3032,3045),
(3067,3071),
(3076,3076),
(3085,3085),
(3089,3089),
(3113,3113),
(3130,3132),
(3141,3141),
(3145,3145),
(3150,3156),
(3159,3159),
(3163,3167),
(3172,3173),
(3184,3191),
(3204,3204),
(3213,3213),
(3217,3217),
(3241,3241),
(3252,3252),
(3258,3259),
(3269,3269),
(3273,3273),
(3278,3284),
(3287,3293),
(3295,3295),
(3300,3301),
(3312,3312),
(3315,3328),
(3332,3332),
(3341,3341),
(3345,3345),
(3387,3388),
(3397,3397),
(3401,3401),
(3408,3411),
(3428,3429),
(3456,3457),
(3460,3460),
(3479,3481),
(3506,3506),
(3516,3516),
(3518,3519),
(3527,3529),
(3531,3534),
(3541,3541),
(3543,3543),
(3552,3557),
(3568,3569),
(3573,3584),
(3643,3646),
(3676,3712),
(3715,3715),
(3717,3718),
(3721,3721),
(3723,3724),
(3726,3731),
(3736,3736),
(3744,3744),
(3748,3748),
(3750,3750),
(3752,3753),
(3756,3756),
(3770,3770),
(3774,3775),
(3781,3781),
(3783,3783),
(3790,3791),
(3802,3803),
(3808,3839),
(3912,3912),
(3949,3952),
(3992,3992),
(4029,4029),
(4045,4045),
(4059,4095),
(4294,4294),
(4296,4300),
(4302,4303),
(4681,4681),
(4686,4687),
(4695,4695),
(4697,4697),
(4702,4703),
(4745,4745),
(4750,4751),
(4785,4785),
(4790,4791),
(4799,4799),
(4801,4801),
(4806,4807),
(4823,4823),
(4881,4881),
(4886,4887),
(4955,4956),
(4989,4991),
(5018,5023),
(5110,5111),
(5118,5119),
(5789,5791),
(5881,5887),
(5901,5901),
(5909,5919),
(5943,5951),
(5972,5983),
(5997,5997),
(6001,6001),
(6004,6015),
(6110,6111),
(6122,6127),
(6138,6143),
(6159,6159),
(6170,6175),
(6264,6271),
(6315,6319),
(6390,6399),
(6431,6431),
(6444,6447),
(6460,6463),
(6465,6467),
(6510,6511),
(6517,6527),
(6572,6575),
(6602,6607),
(6619,6621),
(6684,6685),
(6751,6751),
(6781,6782),
(6794,6799),
(6810,6815),
(6830,6831),
(6847,6911),
(6988,6991),
(7037,7039),
(7156,7163),
(7224,7226),
(7242,7244),
(7305,7359),
(7368,7375),
(7415,7415),
(7418,7423),
(7670,7674),
(7958,7959),
(7966,7967),
(8006,8007),
(8014,8015),
(8024,8024),
(8026,8026),
(8028,8028),
(8030,8030),
(8062,8063),
(8117,8117),
(8133,8133),
(8148,8149),
(8156,8156),
(8176,8177),
(8181,8181),
(8191,8191),
(8293,8293),
(8306,8307),
(8335,8335),
(8349,8351),
(8383,8399),
(8433,8447),
(8588,8591),
(9215,9215),
(9255,9279),
(9291,9311),
(11124,11125),
(11158,11159),
(11194,11196),
(11209,11209),
(11218,11243),
(11248,11263),
(11311,11311),
(11359,11359),
(11508,11512),
(11558,11558),
(11560,11564),
(11566,11567),
(11624,11630),
(11633,11646),
(11671,11679),
(11687,11687),
(11695,11695),
(11703,11703),
(11711,11711),
(11719,11719),
(11727,11727),
(11735,11735),
(11743,11743),
(11845,11903),
(11930,11930),
(12020,12031),
(12246,12271),
(12284,12287),
(12352,12352),
(12439,12440),
(12544,12548),
(12590,12592),
(12687,12687),
(12731,12735),
(12772,12783),
(12831,12831),
(13055,13055),
(19894,19903),
(40918,40959),
(42125,42127),
(42183,42191),
(42540,42559),
(42744,42751),
(42927,42927),
(42936,42998),
(43052,43055),
(43066,43071),
(43128,43135),
(43206,43213),
(43226,43231),
(43262,43263),
(43348,43358),
(43389,43391),
(43470,43470),
(43482,43485),
(43519,43519),
(43575,43583),
(43598,43599),
(43610,43611),
(43715,43738),
(43767,43776),
(43783,43784),
(43791,43792),
(43799,43807),
(43815,43815),
(43823,43823),
(43878,43887),
(44014,44015),
(44026,44031),
(55204,55215),
(55239,55242),
(55292,55295),
(64110,64111),
(64218,64255),
(64263,64274),
(64280,64284),
(64311,64311),
(64317,64317),
(64319,64319),
(64322,64322),
(64325,64325),
(64450,64466),
(64832,64847),
(64912,64913),
(64968,65007),
(65022,65023),
(65050,65055),
(65107,65107),
(65127,65127),
(65132,65135),
(65141,65141),
(65277,65278),
(65280,65280),
(65471,65473),
(65480,65481),
(65488,65489),
(65496,65497),
(65501,65503),
(65511,65511),
(65519,65528),
(65534,65535),
(65548,65548),
(65575,65575),
(65595,65595),
(65598,65598),
(65614,65615),
(65630,65663),
(65787,65791),
(65795,65798),
(65844,65846),
(65935,65935),
(65948,65951),
(65953,65999),
(66046,66175),
(66205,66207),
(66257,66271),
(66300,66303),
(66340,66351),
(66379,66383),
(66427,66431),
(66462,66462),
(66500,66503),
(66518,66559),
(66718,66719),
(66730,66735),
(66772,66775),
(66812,66815),
(66856,66863),
(66916,66926),
(66928,67071),
(67383,67391),
(67414,67423),
(67432,67583),
(67590,67591),
(67593,67593),
(67638,67638),
(67641,67643),
(67645,67646),
(67670,67670),
(67743,67750),
(67760,67807),
(67827,67827),
(67830,67834),
(67868,67870),
(67898,67902),
(67904,67967),
(68024,68027),
(68048,68049),
(68100,68100),
(68103,68107),
(68116,68116),
(68120,68120),
(68148,68151),
(68155,68158),
(68168,68175),
(68185,68191),
(68256,68287),
(68327,68330),
(68343,68351),
(68406,68408),
(68438,68439),
(68467,68471),
(68498,68504),
(68509,68520),
(68528,68607),
(68681,68735),
(68787,68799),
(68851,68857),
(68864,69215),
(69247,69631),
(69710,69713),
(69744,69758),
(69826,69839),
(69865,69871),
(69882,69887),
(69941,69941),
(69956,69967),
(70007,70015),
(70094,70095),
(70112,70112),
(70133,70143),
(70162,70162),
(70207,70271),
(70279,70279),
(70281,70281),
(70286,70286),
(70302,70302),
(70314,70319),
(70379,70383),
(70394,70399),
(70404,70404),
(70413,70414),
(70417,70418),
(70441,70441),
(70449,70449),
(70452,70452),
(70458,70459),
(70469,70470),
(70473,70474),
(70478,70479),
(70481,70486),
(70488,70492),
(70500,70501),
(70509,70511),
(70517,70655),
(70746,70746),
(70748,70748),
(70750,70783),
(70856,70863),
(70874,71039),
(71094,71095),
(71134,71167),
(71237,71247),
(71258,71263),
(71277,71295),
(71352,71359),
(71370,71423),
(71450,71452),
(71468,71471),
(71488,71839),
(71923,71934),
(71936,72383),
(72441,72703),
(72713,72713),
(72759,72759),
(72774,72783),
(72813,72815),
(72848,72849),
(72872,72872),
(72887,73727),
(74650,74751),
(74863,74863),
(74869,74879),
(75076,77823),
(78895,82943),
(83527,92159),
(92729,92735),
(92767,92767),
(92778,92781),
(92784,92879),
(92910,92911),
(92918,92927),
(92998,93007),
(93018,93018),
(93026,93026),
(93048,93052),
(93072,93951),
(94021,94031),
(94079,94094),
(94112,94175),
(94177,94207),
(100333,100351),
(101107,110591),
(110594,113663),
(113771,113775),
(113789,113791),
(113801,113807),
(113818,113819),
(113828,118783),
(119030,119039),
(119079,119080),
(119273,119295),
(119366,119551),
(119639,119647),
(119666,119807),
(119893,119893),
(119965,119965),
(119968,119969),
(119971,119972),
(119975,119976),
(119981,119981),
(119994,119994),
(119996,119996),
(120004,120004),
(120070,120070),
(120075,120076),
(120085,120085),
(120093,120093),
(120122,120122),
(120127,120127),
(120133,120133),
(120135,120137),
(120145,120145),
(120486,120487),
(120780,120781),
(121484,121498),
(121504,121504),
(121520,122879),
(122887,122887),
(122905,122906),
(122914,122914),
(122917,122917),
(122923,124927),
(125125,125126),
(125143,125183),
(125259,125263),
(125274,125277),
(125280,126463),
(126468,126468),
(126496,126496),
(126499,126499),
(126501,126502),
(126504,126504),
(126515,126515),
(126520,126520),
(126522,126522),
(126524,126529),
(126531,126534),
(126536,126536),
(126538,126538),
(126540,126540),
(126544,126544),
(126547,126547),
(126549,126550),
(126552,126552),
(126554,126554),
(126556,126556),
(126558,126558),
(126560,126560),
(126563,126563),
(126565,126566),
(126571,126571),
(126579,126579),
(126584,126584),
(126589,126589),
(126591,126591),
(126602,126602),
(126620,126624),
(126628,126628),
(126634,126634),
(126652,126703),
(126706,126975),
(127020,127023),
(127124,127135),
(127151,127152),
(127168,127168),
(127184,127184),
(127222,127231),
(127245,127247),
(127279,127279),
(127340,127343),
(127405,127461),
(127491,127503),
(127548,127551),
(127561,127567),
(127570,127743),
(128723,128735),
(128749,128751),
(128759,128767),
(128884,128895),
(128981,129023),
(129036,129039),
(129096,129103),
(129114,129119),
(129160,129167),
(129198,129295),
(129311,129311),
(129320,129327),
(129329,129330),
(129343,129343),
(129356,129359),
(129375,129407),
(129426,129471),
(129473,131071),
(173783,173823),
(177973,177983),
(178206,178207),
(183970,194559),
(195102,917504),
(917506,917535),
(917632,917759),
(918000,983039),
(1048574,1048575),
(1114110,1114111)
);

const PUCUUnicodeCategoryBlocks1:array[0..626] of TPUCUUnicodeCharRange=(
(65,90),
(192,214),
(216,222),
(256,256),
(258,258),
(260,260),
(262,262),
(264,264),
(266,266),
(268,268),
(270,270),
(272,272),
(274,274),
(276,276),
(278,278),
(280,280),
(282,282),
(284,284),
(286,286),
(288,288),
(290,290),
(292,292),
(294,294),
(296,296),
(298,298),
(300,300),
(302,302),
(304,304),
(306,306),
(308,308),
(310,310),
(313,313),
(315,315),
(317,317),
(319,319),
(321,321),
(323,323),
(325,325),
(327,327),
(330,330),
(332,332),
(334,334),
(336,336),
(338,338),
(340,340),
(342,342),
(344,344),
(346,346),
(348,348),
(350,350),
(352,352),
(354,354),
(356,356),
(358,358),
(360,360),
(362,362),
(364,364),
(366,366),
(368,368),
(370,370),
(372,372),
(374,374),
(376,377),
(379,379),
(381,381),
(385,386),
(388,388),
(390,391),
(393,395),
(398,401),
(403,404),
(406,408),
(412,413),
(415,416),
(418,418),
(420,420),
(422,423),
(425,425),
(428,428),
(430,431),
(433,435),
(437,437),
(439,440),
(444,444),
(452,452),
(455,455),
(458,458),
(461,461),
(463,463),
(465,465),
(467,467),
(469,469),
(471,471),
(473,473),
(475,475),
(478,478),
(480,480),
(482,482),
(484,484),
(486,486),
(488,488),
(490,490),
(492,492),
(494,494),
(497,497),
(500,500),
(502,504),
(506,506),
(508,508),
(510,510),
(512,512),
(514,514),
(516,516),
(518,518),
(520,520),
(522,522),
(524,524),
(526,526),
(528,528),
(530,530),
(532,532),
(534,534),
(536,536),
(538,538),
(540,540),
(542,542),
(544,544),
(546,546),
(548,548),
(550,550),
(552,552),
(554,554),
(556,556),
(558,558),
(560,560),
(562,562),
(570,571),
(573,574),
(577,577),
(579,582),
(584,584),
(586,586),
(588,588),
(590,590),
(880,880),
(882,882),
(886,886),
(895,895),
(902,902),
(904,906),
(908,908),
(910,911),
(913,929),
(931,939),
(975,975),
(978,980),
(984,984),
(986,986),
(988,988),
(990,990),
(992,992),
(994,994),
(996,996),
(998,998),
(1000,1000),
(1002,1002),
(1004,1004),
(1006,1006),
(1012,1012),
(1015,1015),
(1017,1018),
(1021,1071),
(1120,1120),
(1122,1122),
(1124,1124),
(1126,1126),
(1128,1128),
(1130,1130),
(1132,1132),
(1134,1134),
(1136,1136),
(1138,1138),
(1140,1140),
(1142,1142),
(1144,1144),
(1146,1146),
(1148,1148),
(1150,1150),
(1152,1152),
(1162,1162),
(1164,1164),
(1166,1166),
(1168,1168),
(1170,1170),
(1172,1172),
(1174,1174),
(1176,1176),
(1178,1178),
(1180,1180),
(1182,1182),
(1184,1184),
(1186,1186),
(1188,1188),
(1190,1190),
(1192,1192),
(1194,1194),
(1196,1196),
(1198,1198),
(1200,1200),
(1202,1202),
(1204,1204),
(1206,1206),
(1208,1208),
(1210,1210),
(1212,1212),
(1214,1214),
(1216,1217),
(1219,1219),
(1221,1221),
(1223,1223),
(1225,1225),
(1227,1227),
(1229,1229),
(1232,1232),
(1234,1234),
(1236,1236),
(1238,1238),
(1240,1240),
(1242,1242),
(1244,1244),
(1246,1246),
(1248,1248),
(1250,1250),
(1252,1252),
(1254,1254),
(1256,1256),
(1258,1258),
(1260,1260),
(1262,1262),
(1264,1264),
(1266,1266),
(1268,1268),
(1270,1270),
(1272,1272),
(1274,1274),
(1276,1276),
(1278,1278),
(1280,1280),
(1282,1282),
(1284,1284),
(1286,1286),
(1288,1288),
(1290,1290),
(1292,1292),
(1294,1294),
(1296,1296),
(1298,1298),
(1300,1300),
(1302,1302),
(1304,1304),
(1306,1306),
(1308,1308),
(1310,1310),
(1312,1312),
(1314,1314),
(1316,1316),
(1318,1318),
(1320,1320),
(1322,1322),
(1324,1324),
(1326,1326),
(1329,1366),
(4256,4293),
(4295,4295),
(4301,4301),
(5024,5109),
(7680,7680),
(7682,7682),
(7684,7684),
(7686,7686),
(7688,7688),
(7690,7690),
(7692,7692),
(7694,7694),
(7696,7696),
(7698,7698),
(7700,7700),
(7702,7702),
(7704,7704),
(7706,7706),
(7708,7708),
(7710,7710),
(7712,7712),
(7714,7714),
(7716,7716),
(7718,7718),
(7720,7720),
(7722,7722),
(7724,7724),
(7726,7726),
(7728,7728),
(7730,7730),
(7732,7732),
(7734,7734),
(7736,7736),
(7738,7738),
(7740,7740),
(7742,7742),
(7744,7744),
(7746,7746),
(7748,7748),
(7750,7750),
(7752,7752),
(7754,7754),
(7756,7756),
(7758,7758),
(7760,7760),
(7762,7762),
(7764,7764),
(7766,7766),
(7768,7768),
(7770,7770),
(7772,7772),
(7774,7774),
(7776,7776),
(7778,7778),
(7780,7780),
(7782,7782),
(7784,7784),
(7786,7786),
(7788,7788),
(7790,7790),
(7792,7792),
(7794,7794),
(7796,7796),
(7798,7798),
(7800,7800),
(7802,7802),
(7804,7804),
(7806,7806),
(7808,7808),
(7810,7810),
(7812,7812),
(7814,7814),
(7816,7816),
(7818,7818),
(7820,7820),
(7822,7822),
(7824,7824),
(7826,7826),
(7828,7828),
(7838,7838),
(7840,7840),
(7842,7842),
(7844,7844),
(7846,7846),
(7848,7848),
(7850,7850),
(7852,7852),
(7854,7854),
(7856,7856),
(7858,7858),
(7860,7860),
(7862,7862),
(7864,7864),
(7866,7866),
(7868,7868),
(7870,7870),
(7872,7872),
(7874,7874),
(7876,7876),
(7878,7878),
(7880,7880),
(7882,7882),
(7884,7884),
(7886,7886),
(7888,7888),
(7890,7890),
(7892,7892),
(7894,7894),
(7896,7896),
(7898,7898),
(7900,7900),
(7902,7902),
(7904,7904),
(7906,7906),
(7908,7908),
(7910,7910),
(7912,7912),
(7914,7914),
(7916,7916),
(7918,7918),
(7920,7920),
(7922,7922),
(7924,7924),
(7926,7926),
(7928,7928),
(7930,7930),
(7932,7932),
(7934,7934),
(7944,7951),
(7960,7965),
(7976,7983),
(7992,7999),
(8008,8013),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8031),
(8040,8047),
(8120,8123),
(8136,8139),
(8152,8155),
(8168,8172),
(8184,8187),
(8450,8450),
(8455,8455),
(8459,8461),
(8464,8466),
(8469,8469),
(8473,8477),
(8484,8484),
(8486,8486),
(8488,8488),
(8490,8493),
(8496,8499),
(8510,8511),
(8517,8517),
(8579,8579),
(11264,11310),
(11360,11360),
(11362,11364),
(11367,11367),
(11369,11369),
(11371,11371),
(11373,11376),
(11378,11378),
(11381,11381),
(11390,11392),
(11394,11394),
(11396,11396),
(11398,11398),
(11400,11400),
(11402,11402),
(11404,11404),
(11406,11406),
(11408,11408),
(11410,11410),
(11412,11412),
(11414,11414),
(11416,11416),
(11418,11418),
(11420,11420),
(11422,11422),
(11424,11424),
(11426,11426),
(11428,11428),
(11430,11430),
(11432,11432),
(11434,11434),
(11436,11436),
(11438,11438),
(11440,11440),
(11442,11442),
(11444,11444),
(11446,11446),
(11448,11448),
(11450,11450),
(11452,11452),
(11454,11454),
(11456,11456),
(11458,11458),
(11460,11460),
(11462,11462),
(11464,11464),
(11466,11466),
(11468,11468),
(11470,11470),
(11472,11472),
(11474,11474),
(11476,11476),
(11478,11478),
(11480,11480),
(11482,11482),
(11484,11484),
(11486,11486),
(11488,11488),
(11490,11490),
(11499,11499),
(11501,11501),
(11506,11506),
(42560,42560),
(42562,42562),
(42564,42564),
(42566,42566),
(42568,42568),
(42570,42570),
(42572,42572),
(42574,42574),
(42576,42576),
(42578,42578),
(42580,42580),
(42582,42582),
(42584,42584),
(42586,42586),
(42588,42588),
(42590,42590),
(42592,42592),
(42594,42594),
(42596,42596),
(42598,42598),
(42600,42600),
(42602,42602),
(42604,42604),
(42624,42624),
(42626,42626),
(42628,42628),
(42630,42630),
(42632,42632),
(42634,42634),
(42636,42636),
(42638,42638),
(42640,42640),
(42642,42642),
(42644,42644),
(42646,42646),
(42648,42648),
(42650,42650),
(42786,42786),
(42788,42788),
(42790,42790),
(42792,42792),
(42794,42794),
(42796,42796),
(42798,42798),
(42802,42802),
(42804,42804),
(42806,42806),
(42808,42808),
(42810,42810),
(42812,42812),
(42814,42814),
(42816,42816),
(42818,42818),
(42820,42820),
(42822,42822),
(42824,42824),
(42826,42826),
(42828,42828),
(42830,42830),
(42832,42832),
(42834,42834),
(42836,42836),
(42838,42838),
(42840,42840),
(42842,42842),
(42844,42844),
(42846,42846),
(42848,42848),
(42850,42850),
(42852,42852),
(42854,42854),
(42856,42856),
(42858,42858),
(42860,42860),
(42862,42862),
(42873,42873),
(42875,42875),
(42877,42878),
(42880,42880),
(42882,42882),
(42884,42884),
(42886,42886),
(42891,42891),
(42893,42893),
(42896,42896),
(42898,42898),
(42902,42902),
(42904,42904),
(42906,42906),
(42908,42908),
(42910,42910),
(42912,42912),
(42914,42914),
(42916,42916),
(42918,42918),
(42920,42920),
(42922,42926),
(42928,42932),
(42934,42934),
(65313,65338),
(66560,66599),
(66736,66771),
(68736,68786),
(71840,71871),
(119808,119833),
(119860,119885),
(119912,119937),
(119964,119964),
(119966,119967),
(119970,119970),
(119973,119974),
(119977,119980),
(119982,119989),
(120016,120041),
(120068,120069),
(120071,120074),
(120077,120084),
(120086,120092),
(120120,120121),
(120123,120126),
(120128,120132),
(120134,120134),
(120138,120144),
(120172,120197),
(120224,120249),
(120276,120301),
(120328,120353),
(120380,120405),
(120432,120457),
(120488,120512),
(120546,120570),
(120604,120628),
(120662,120686),
(120720,120744),
(120778,120778),
(125184,125217)
);

const PUCUUnicodeCategoryBlocks2:array[0..632] of TPUCUUnicodeCharRange=(
(97,122),
(181,181),
(223,246),
(248,255),
(257,257),
(259,259),
(261,261),
(263,263),
(265,265),
(267,267),
(269,269),
(271,271),
(273,273),
(275,275),
(277,277),
(279,279),
(281,281),
(283,283),
(285,285),
(287,287),
(289,289),
(291,291),
(293,293),
(295,295),
(297,297),
(299,299),
(301,301),
(303,303),
(305,305),
(307,307),
(309,309),
(311,312),
(314,314),
(316,316),
(318,318),
(320,320),
(322,322),
(324,324),
(326,326),
(328,329),
(331,331),
(333,333),
(335,335),
(337,337),
(339,339),
(341,341),
(343,343),
(345,345),
(347,347),
(349,349),
(351,351),
(353,353),
(355,355),
(357,357),
(359,359),
(361,361),
(363,363),
(365,365),
(367,367),
(369,369),
(371,371),
(373,373),
(375,375),
(378,378),
(380,380),
(382,384),
(387,387),
(389,389),
(392,392),
(396,397),
(402,402),
(405,405),
(409,411),
(414,414),
(417,417),
(419,419),
(421,421),
(424,424),
(426,427),
(429,429),
(432,432),
(436,436),
(438,438),
(441,442),
(445,447),
(454,454),
(457,457),
(460,460),
(462,462),
(464,464),
(466,466),
(468,468),
(470,470),
(472,472),
(474,474),
(476,477),
(479,479),
(481,481),
(483,483),
(485,485),
(487,487),
(489,489),
(491,491),
(493,493),
(495,496),
(499,499),
(501,501),
(505,505),
(507,507),
(509,509),
(511,511),
(513,513),
(515,515),
(517,517),
(519,519),
(521,521),
(523,523),
(525,525),
(527,527),
(529,529),
(531,531),
(533,533),
(535,535),
(537,537),
(539,539),
(541,541),
(543,543),
(545,545),
(547,547),
(549,549),
(551,551),
(553,553),
(555,555),
(557,557),
(559,559),
(561,561),
(563,569),
(572,572),
(575,576),
(578,578),
(583,583),
(585,585),
(587,587),
(589,589),
(591,659),
(661,687),
(881,881),
(883,883),
(887,887),
(891,893),
(912,912),
(940,974),
(976,977),
(981,983),
(985,985),
(987,987),
(989,989),
(991,991),
(993,993),
(995,995),
(997,997),
(999,999),
(1001,1001),
(1003,1003),
(1005,1005),
(1007,1011),
(1013,1013),
(1016,1016),
(1019,1020),
(1072,1119),
(1121,1121),
(1123,1123),
(1125,1125),
(1127,1127),
(1129,1129),
(1131,1131),
(1133,1133),
(1135,1135),
(1137,1137),
(1139,1139),
(1141,1141),
(1143,1143),
(1145,1145),
(1147,1147),
(1149,1149),
(1151,1151),
(1153,1153),
(1163,1163),
(1165,1165),
(1167,1167),
(1169,1169),
(1171,1171),
(1173,1173),
(1175,1175),
(1177,1177),
(1179,1179),
(1181,1181),
(1183,1183),
(1185,1185),
(1187,1187),
(1189,1189),
(1191,1191),
(1193,1193),
(1195,1195),
(1197,1197),
(1199,1199),
(1201,1201),
(1203,1203),
(1205,1205),
(1207,1207),
(1209,1209),
(1211,1211),
(1213,1213),
(1215,1215),
(1218,1218),
(1220,1220),
(1222,1222),
(1224,1224),
(1226,1226),
(1228,1228),
(1230,1231),
(1233,1233),
(1235,1235),
(1237,1237),
(1239,1239),
(1241,1241),
(1243,1243),
(1245,1245),
(1247,1247),
(1249,1249),
(1251,1251),
(1253,1253),
(1255,1255),
(1257,1257),
(1259,1259),
(1261,1261),
(1263,1263),
(1265,1265),
(1267,1267),
(1269,1269),
(1271,1271),
(1273,1273),
(1275,1275),
(1277,1277),
(1279,1279),
(1281,1281),
(1283,1283),
(1285,1285),
(1287,1287),
(1289,1289),
(1291,1291),
(1293,1293),
(1295,1295),
(1297,1297),
(1299,1299),
(1301,1301),
(1303,1303),
(1305,1305),
(1307,1307),
(1309,1309),
(1311,1311),
(1313,1313),
(1315,1315),
(1317,1317),
(1319,1319),
(1321,1321),
(1323,1323),
(1325,1325),
(1327,1327),
(1377,1415),
(5112,5117),
(7296,7304),
(7424,7467),
(7531,7543),
(7545,7578),
(7681,7681),
(7683,7683),
(7685,7685),
(7687,7687),
(7689,7689),
(7691,7691),
(7693,7693),
(7695,7695),
(7697,7697),
(7699,7699),
(7701,7701),
(7703,7703),
(7705,7705),
(7707,7707),
(7709,7709),
(7711,7711),
(7713,7713),
(7715,7715),
(7717,7717),
(7719,7719),
(7721,7721),
(7723,7723),
(7725,7725),
(7727,7727),
(7729,7729),
(7731,7731),
(7733,7733),
(7735,7735),
(7737,7737),
(7739,7739),
(7741,7741),
(7743,7743),
(7745,7745),
(7747,7747),
(7749,7749),
(7751,7751),
(7753,7753),
(7755,7755),
(7757,7757),
(7759,7759),
(7761,7761),
(7763,7763),
(7765,7765),
(7767,7767),
(7769,7769),
(7771,7771),
(7773,7773),
(7775,7775),
(7777,7777),
(7779,7779),
(7781,7781),
(7783,7783),
(7785,7785),
(7787,7787),
(7789,7789),
(7791,7791),
(7793,7793),
(7795,7795),
(7797,7797),
(7799,7799),
(7801,7801),
(7803,7803),
(7805,7805),
(7807,7807),
(7809,7809),
(7811,7811),
(7813,7813),
(7815,7815),
(7817,7817),
(7819,7819),
(7821,7821),
(7823,7823),
(7825,7825),
(7827,7827),
(7829,7837),
(7839,7839),
(7841,7841),
(7843,7843),
(7845,7845),
(7847,7847),
(7849,7849),
(7851,7851),
(7853,7853),
(7855,7855),
(7857,7857),
(7859,7859),
(7861,7861),
(7863,7863),
(7865,7865),
(7867,7867),
(7869,7869),
(7871,7871),
(7873,7873),
(7875,7875),
(7877,7877),
(7879,7879),
(7881,7881),
(7883,7883),
(7885,7885),
(7887,7887),
(7889,7889),
(7891,7891),
(7893,7893),
(7895,7895),
(7897,7897),
(7899,7899),
(7901,7901),
(7903,7903),
(7905,7905),
(7907,7907),
(7909,7909),
(7911,7911),
(7913,7913),
(7915,7915),
(7917,7917),
(7919,7919),
(7921,7921),
(7923,7923),
(7925,7925),
(7927,7927),
(7929,7929),
(7931,7931),
(7933,7933),
(7935,7943),
(7952,7957),
(7968,7975),
(7984,7991),
(8000,8005),
(8016,8023),
(8032,8039),
(8048,8061),
(8064,8071),
(8080,8087),
(8096,8103),
(8112,8116),
(8118,8119),
(8126,8126),
(8130,8132),
(8134,8135),
(8144,8147),
(8150,8151),
(8160,8167),
(8178,8180),
(8182,8183),
(8458,8458),
(8462,8463),
(8467,8467),
(8495,8495),
(8500,8500),
(8505,8505),
(8508,8509),
(8518,8521),
(8526,8526),
(8580,8580),
(11312,11358),
(11361,11361),
(11365,11366),
(11368,11368),
(11370,11370),
(11372,11372),
(11377,11377),
(11379,11380),
(11382,11387),
(11393,11393),
(11395,11395),
(11397,11397),
(11399,11399),
(11401,11401),
(11403,11403),
(11405,11405),
(11407,11407),
(11409,11409),
(11411,11411),
(11413,11413),
(11415,11415),
(11417,11417),
(11419,11419),
(11421,11421),
(11423,11423),
(11425,11425),
(11427,11427),
(11429,11429),
(11431,11431),
(11433,11433),
(11435,11435),
(11437,11437),
(11439,11439),
(11441,11441),
(11443,11443),
(11445,11445),
(11447,11447),
(11449,11449),
(11451,11451),
(11453,11453),
(11455,11455),
(11457,11457),
(11459,11459),
(11461,11461),
(11463,11463),
(11465,11465),
(11467,11467),
(11469,11469),
(11471,11471),
(11473,11473),
(11475,11475),
(11477,11477),
(11479,11479),
(11481,11481),
(11483,11483),
(11485,11485),
(11487,11487),
(11489,11489),
(11491,11492),
(11500,11500),
(11502,11502),
(11507,11507),
(11520,11557),
(11559,11559),
(11565,11565),
(42561,42561),
(42563,42563),
(42565,42565),
(42567,42567),
(42569,42569),
(42571,42571),
(42573,42573),
(42575,42575),
(42577,42577),
(42579,42579),
(42581,42581),
(42583,42583),
(42585,42585),
(42587,42587),
(42589,42589),
(42591,42591),
(42593,42593),
(42595,42595),
(42597,42597),
(42599,42599),
(42601,42601),
(42603,42603),
(42605,42605),
(42625,42625),
(42627,42627),
(42629,42629),
(42631,42631),
(42633,42633),
(42635,42635),
(42637,42637),
(42639,42639),
(42641,42641),
(42643,42643),
(42645,42645),
(42647,42647),
(42649,42649),
(42651,42651),
(42787,42787),
(42789,42789),
(42791,42791),
(42793,42793),
(42795,42795),
(42797,42797),
(42799,42801),
(42803,42803),
(42805,42805),
(42807,42807),
(42809,42809),
(42811,42811),
(42813,42813),
(42815,42815),
(42817,42817),
(42819,42819),
(42821,42821),
(42823,42823),
(42825,42825),
(42827,42827),
(42829,42829),
(42831,42831),
(42833,42833),
(42835,42835),
(42837,42837),
(42839,42839),
(42841,42841),
(42843,42843),
(42845,42845),
(42847,42847),
(42849,42849),
(42851,42851),
(42853,42853),
(42855,42855),
(42857,42857),
(42859,42859),
(42861,42861),
(42863,42863),
(42865,42872),
(42874,42874),
(42876,42876),
(42879,42879),
(42881,42881),
(42883,42883),
(42885,42885),
(42887,42887),
(42892,42892),
(42894,42894),
(42897,42897),
(42899,42901),
(42903,42903),
(42905,42905),
(42907,42907),
(42909,42909),
(42911,42911),
(42913,42913),
(42915,42915),
(42917,42917),
(42919,42919),
(42921,42921),
(42933,42933),
(42935,42935),
(43002,43002),
(43824,43866),
(43872,43877),
(43888,43967),
(64256,64262),
(64275,64279),
(65345,65370),
(66600,66639),
(66776,66811),
(68800,68850),
(71872,71903),
(119834,119859),
(119886,119892),
(119894,119911),
(119938,119963),
(119990,119993),
(119995,119995),
(119997,120003),
(120005,120015),
(120042,120067),
(120094,120119),
(120146,120171),
(120198,120223),
(120250,120275),
(120302,120327),
(120354,120379),
(120406,120431),
(120458,120485),
(120514,120538),
(120540,120545),
(120572,120596),
(120598,120603),
(120630,120654),
(120656,120661),
(120688,120712),
(120714,120719),
(120746,120770),
(120772,120777),
(120779,120779),
(125218,125251)
);

const PUCUUnicodeCategoryBlocks3:array[0..9] of TPUCUUnicodeCharRange=(
(453,453),
(456,456),
(459,459),
(498,498),
(8072,8079),
(8088,8095),
(8104,8111),
(8124,8124),
(8140,8140),
(8188,8188)
);

const PUCUUnicodeCategoryBlocks4:array[0..56] of TPUCUUnicodeCharRange=(
(688,705),
(710,721),
(736,740),
(748,748),
(750,750),
(884,884),
(890,890),
(1369,1369),
(1600,1600),
(1765,1766),
(2036,2037),
(2042,2042),
(2074,2074),
(2084,2084),
(2088,2088),
(2417,2417),
(3654,3654),
(3782,3782),
(4348,4348),
(6103,6103),
(6211,6211),
(6823,6823),
(7288,7293),
(7468,7530),
(7544,7544),
(7579,7615),
(8305,8305),
(8319,8319),
(8336,8348),
(11388,11389),
(11631,11631),
(11823,11823),
(12293,12293),
(12337,12341),
(12347,12347),
(12445,12446),
(12540,12542),
(40981,40981),
(42232,42237),
(42508,42508),
(42623,42623),
(42652,42653),
(42775,42783),
(42864,42864),
(42888,42888),
(43000,43001),
(43471,43471),
(43494,43494),
(43632,43632),
(43741,43741),
(43763,43764),
(43868,43871),
(65392,65392),
(65438,65439),
(92992,92995),
(94099,94111),
(94176,94176)
);

const PUCUUnicodeCategoryBlocks5:array[0..444] of TPUCUUnicodeCharRange=(
(170,170),
(186,186),
(443,443),
(448,451),
(660,660),
(1488,1514),
(1520,1522),
(1568,1599),
(1601,1610),
(1646,1647),
(1649,1747),
(1749,1749),
(1774,1775),
(1786,1788),
(1791,1791),
(1808,1808),
(1810,1839),
(1869,1957),
(1969,1969),
(1994,2026),
(2048,2069),
(2112,2136),
(2208,2228),
(2230,2237),
(2308,2361),
(2365,2365),
(2384,2384),
(2392,2401),
(2418,2432),
(2437,2444),
(2447,2448),
(2451,2472),
(2474,2480),
(2482,2482),
(2486,2489),
(2493,2493),
(2510,2510),
(2524,2525),
(2527,2529),
(2544,2545),
(2565,2570),
(2575,2576),
(2579,2600),
(2602,2608),
(2610,2611),
(2613,2614),
(2616,2617),
(2649,2652),
(2654,2654),
(2674,2676),
(2693,2701),
(2703,2705),
(2707,2728),
(2730,2736),
(2738,2739),
(2741,2745),
(2749,2749),
(2768,2768),
(2784,2785),
(2809,2809),
(2821,2828),
(2831,2832),
(2835,2856),
(2858,2864),
(2866,2867),
(2869,2873),
(2877,2877),
(2908,2909),
(2911,2913),
(2929,2929),
(2947,2947),
(2949,2954),
(2958,2960),
(2962,2965),
(2969,2970),
(2972,2972),
(2974,2975),
(2979,2980),
(2984,2986),
(2990,3001),
(3024,3024),
(3077,3084),
(3086,3088),
(3090,3112),
(3114,3129),
(3133,3133),
(3160,3162),
(3168,3169),
(3200,3200),
(3205,3212),
(3214,3216),
(3218,3240),
(3242,3251),
(3253,3257),
(3261,3261),
(3294,3294),
(3296,3297),
(3313,3314),
(3333,3340),
(3342,3344),
(3346,3386),
(3389,3389),
(3406,3406),
(3412,3414),
(3423,3425),
(3450,3455),
(3461,3478),
(3482,3505),
(3507,3515),
(3517,3517),
(3520,3526),
(3585,3632),
(3634,3635),
(3648,3653),
(3713,3714),
(3716,3716),
(3719,3720),
(3722,3722),
(3725,3725),
(3732,3735),
(3737,3743),
(3745,3747),
(3749,3749),
(3751,3751),
(3754,3755),
(3757,3760),
(3762,3763),
(3773,3773),
(3776,3780),
(3804,3807),
(3840,3840),
(3904,3911),
(3913,3948),
(3976,3980),
(4096,4138),
(4159,4159),
(4176,4181),
(4186,4189),
(4193,4193),
(4197,4198),
(4206,4208),
(4213,4225),
(4238,4238),
(4304,4346),
(4349,4680),
(4682,4685),
(4688,4694),
(4696,4696),
(4698,4701),
(4704,4744),
(4746,4749),
(4752,4784),
(4786,4789),
(4792,4798),
(4800,4800),
(4802,4805),
(4808,4822),
(4824,4880),
(4882,4885),
(4888,4954),
(4992,5007),
(5121,5740),
(5743,5759),
(5761,5786),
(5792,5866),
(5873,5880),
(5888,5900),
(5902,5905),
(5920,5937),
(5952,5969),
(5984,5996),
(5998,6000),
(6016,6067),
(6108,6108),
(6176,6210),
(6212,6263),
(6272,6276),
(6279,6312),
(6314,6314),
(6320,6389),
(6400,6430),
(6480,6509),
(6512,6516),
(6528,6571),
(6576,6601),
(6656,6678),
(6688,6740),
(6917,6963),
(6981,6987),
(7043,7072),
(7086,7087),
(7098,7141),
(7168,7203),
(7245,7247),
(7258,7287),
(7401,7404),
(7406,7409),
(7413,7414),
(8501,8504),
(11568,11623),
(11648,11670),
(11680,11686),
(11688,11694),
(11696,11702),
(11704,11710),
(11712,11718),
(11720,11726),
(11728,11734),
(11736,11742),
(12294,12294),
(12348,12348),
(12353,12438),
(12447,12447),
(12449,12538),
(12543,12543),
(12549,12589),
(12593,12686),
(12704,12730),
(12784,12799),
(13312,19893),
(19968,40917),
(40960,40980),
(40982,42124),
(42192,42231),
(42240,42507),
(42512,42527),
(42538,42539),
(42606,42606),
(42656,42725),
(42895,42895),
(42999,42999),
(43003,43009),
(43011,43013),
(43015,43018),
(43020,43042),
(43072,43123),
(43138,43187),
(43250,43255),
(43259,43259),
(43261,43261),
(43274,43301),
(43312,43334),
(43360,43388),
(43396,43442),
(43488,43492),
(43495,43503),
(43514,43518),
(43520,43560),
(43584,43586),
(43588,43595),
(43616,43631),
(43633,43638),
(43642,43642),
(43646,43695),
(43697,43697),
(43701,43702),
(43705,43709),
(43712,43712),
(43714,43714),
(43739,43740),
(43744,43754),
(43762,43762),
(43777,43782),
(43785,43790),
(43793,43798),
(43808,43814),
(43816,43822),
(43968,44002),
(44032,55203),
(55216,55238),
(55243,55291),
(63744,64109),
(64112,64217),
(64285,64285),
(64287,64296),
(64298,64310),
(64312,64316),
(64318,64318),
(64320,64321),
(64323,64324),
(64326,64433),
(64467,64829),
(64848,64911),
(64914,64967),
(65008,65019),
(65136,65140),
(65142,65276),
(65382,65391),
(65393,65437),
(65440,65470),
(65474,65479),
(65482,65487),
(65490,65495),
(65498,65500),
(65536,65547),
(65549,65574),
(65576,65594),
(65596,65597),
(65599,65613),
(65616,65629),
(65664,65786),
(66176,66204),
(66208,66256),
(66304,66335),
(66352,66368),
(66370,66377),
(66384,66421),
(66432,66461),
(66464,66499),
(66504,66511),
(66640,66717),
(66816,66855),
(66864,66915),
(67072,67382),
(67392,67413),
(67424,67431),
(67584,67589),
(67592,67592),
(67594,67637),
(67639,67640),
(67644,67644),
(67647,67669),
(67680,67702),
(67712,67742),
(67808,67826),
(67828,67829),
(67840,67861),
(67872,67897),
(67968,68023),
(68030,68031),
(68096,68096),
(68112,68115),
(68117,68119),
(68121,68147),
(68192,68220),
(68224,68252),
(68288,68295),
(68297,68324),
(68352,68405),
(68416,68437),
(68448,68466),
(68480,68497),
(68608,68680),
(69635,69687),
(69763,69807),
(69840,69864),
(69891,69926),
(69968,70002),
(70006,70006),
(70019,70066),
(70081,70084),
(70106,70106),
(70108,70108),
(70144,70161),
(70163,70187),
(70272,70278),
(70280,70280),
(70282,70285),
(70287,70301),
(70303,70312),
(70320,70366),
(70405,70412),
(70415,70416),
(70419,70440),
(70442,70448),
(70450,70451),
(70453,70457),
(70461,70461),
(70480,70480),
(70493,70497),
(70656,70708),
(70727,70730),
(70784,70831),
(70852,70853),
(70855,70855),
(71040,71086),
(71128,71131),
(71168,71215),
(71236,71236),
(71296,71338),
(71424,71449),
(71935,71935),
(72384,72440),
(72704,72712),
(72714,72750),
(72768,72768),
(72818,72847),
(73728,74649),
(74880,75075),
(77824,78894),
(82944,83526),
(92160,92728),
(92736,92766),
(92880,92909),
(92928,92975),
(93027,93047),
(93053,93071),
(93952,94020),
(94032,94032),
(94208,100332),
(100352,101106),
(110592,110593),
(113664,113770),
(113776,113788),
(113792,113800),
(113808,113817),
(124928,125124),
(126464,126467),
(126469,126495),
(126497,126498),
(126500,126500),
(126503,126503),
(126505,126514),
(126516,126519),
(126521,126521),
(126523,126523),
(126530,126530),
(126535,126535),
(126537,126537),
(126539,126539),
(126541,126543),
(126545,126546),
(126548,126548),
(126551,126551),
(126553,126553),
(126555,126555),
(126557,126557),
(126559,126559),
(126561,126562),
(126564,126564),
(126567,126570),
(126572,126578),
(126580,126583),
(126585,126588),
(126590,126590),
(126592,126601),
(126603,126619),
(126625,126627),
(126629,126633),
(126635,126651),
(131072,173782),
(173824,177972),
(177984,178205),
(178208,183969),
(194560,195101)
);

const PUCUUnicodeCategoryBlocks6:array[0..284] of TPUCUUnicodeCharRange=(
(768,879),
(1155,1159),
(1425,1469),
(1471,1471),
(1473,1474),
(1476,1477),
(1479,1479),
(1552,1562),
(1611,1631),
(1648,1648),
(1750,1756),
(1759,1764),
(1767,1768),
(1770,1773),
(1809,1809),
(1840,1866),
(1958,1968),
(2027,2035),
(2070,2073),
(2075,2083),
(2085,2087),
(2089,2093),
(2137,2139),
(2260,2273),
(2275,2306),
(2362,2362),
(2364,2364),
(2369,2376),
(2381,2381),
(2385,2391),
(2402,2403),
(2433,2433),
(2492,2492),
(2497,2500),
(2509,2509),
(2530,2531),
(2561,2562),
(2620,2620),
(2625,2626),
(2631,2632),
(2635,2637),
(2641,2641),
(2672,2673),
(2677,2677),
(2689,2690),
(2748,2748),
(2753,2757),
(2759,2760),
(2765,2765),
(2786,2787),
(2817,2817),
(2876,2876),
(2879,2879),
(2881,2884),
(2893,2893),
(2902,2902),
(2914,2915),
(2946,2946),
(3008,3008),
(3021,3021),
(3072,3072),
(3134,3136),
(3142,3144),
(3146,3149),
(3157,3158),
(3170,3171),
(3201,3201),
(3260,3260),
(3263,3263),
(3270,3270),
(3276,3277),
(3298,3299),
(3329,3329),
(3393,3396),
(3405,3405),
(3426,3427),
(3530,3530),
(3538,3540),
(3542,3542),
(3633,3633),
(3636,3642),
(3655,3662),
(3761,3761),
(3764,3769),
(3771,3772),
(3784,3789),
(3864,3865),
(3893,3893),
(3895,3895),
(3897,3897),
(3953,3966),
(3968,3972),
(3974,3975),
(3981,3991),
(3993,4028),
(4038,4038),
(4141,4144),
(4146,4151),
(4153,4154),
(4157,4158),
(4184,4185),
(4190,4192),
(4209,4212),
(4226,4226),
(4229,4230),
(4237,4237),
(4253,4253),
(4957,4959),
(5906,5908),
(5938,5940),
(5970,5971),
(6002,6003),
(6068,6069),
(6071,6077),
(6086,6086),
(6089,6099),
(6109,6109),
(6155,6157),
(6277,6278),
(6313,6313),
(6432,6434),
(6439,6440),
(6450,6450),
(6457,6459),
(6679,6680),
(6683,6683),
(6742,6742),
(6744,6750),
(6752,6752),
(6754,6754),
(6757,6764),
(6771,6780),
(6783,6783),
(6832,6845),
(6912,6915),
(6964,6964),
(6966,6970),
(6972,6972),
(6978,6978),
(7019,7027),
(7040,7041),
(7074,7077),
(7080,7081),
(7083,7085),
(7142,7142),
(7144,7145),
(7149,7149),
(7151,7153),
(7212,7219),
(7222,7223),
(7376,7378),
(7380,7392),
(7394,7400),
(7405,7405),
(7412,7412),
(7416,7417),
(7616,7669),
(7675,7679),
(8400,8412),
(8417,8417),
(8421,8432),
(11503,11505),
(11647,11647),
(11744,11775),
(12330,12333),
(12441,12442),
(42607,42607),
(42612,42621),
(42654,42655),
(42736,42737),
(43010,43010),
(43014,43014),
(43019,43019),
(43045,43046),
(43204,43205),
(43232,43249),
(43302,43309),
(43335,43345),
(43392,43394),
(43443,43443),
(43446,43449),
(43452,43452),
(43493,43493),
(43561,43566),
(43569,43570),
(43573,43574),
(43587,43587),
(43596,43596),
(43644,43644),
(43696,43696),
(43698,43700),
(43703,43704),
(43710,43711),
(43713,43713),
(43756,43757),
(43766,43766),
(44005,44005),
(44008,44008),
(44013,44013),
(64286,64286),
(65024,65039),
(65056,65071),
(66045,66045),
(66272,66272),
(66422,66426),
(68097,68099),
(68101,68102),
(68108,68111),
(68152,68154),
(68159,68159),
(68325,68326),
(69633,69633),
(69688,69702),
(69759,69761),
(69811,69814),
(69817,69818),
(69888,69890),
(69927,69931),
(69933,69940),
(70003,70003),
(70016,70017),
(70070,70078),
(70090,70092),
(70191,70193),
(70196,70196),
(70198,70199),
(70206,70206),
(70367,70367),
(70371,70378),
(70400,70401),
(70460,70460),
(70464,70464),
(70502,70508),
(70512,70516),
(70712,70719),
(70722,70724),
(70726,70726),
(70835,70840),
(70842,70842),
(70847,70848),
(70850,70851),
(71090,71093),
(71100,71101),
(71103,71104),
(71132,71133),
(71219,71226),
(71229,71229),
(71231,71232),
(71339,71339),
(71341,71341),
(71344,71349),
(71351,71351),
(71453,71455),
(71458,71461),
(71463,71467),
(72752,72758),
(72760,72765),
(72767,72767),
(72850,72871),
(72874,72880),
(72882,72883),
(72885,72886),
(92912,92916),
(92976,92982),
(94095,94098),
(113821,113822),
(119143,119145),
(119163,119170),
(119173,119179),
(119210,119213),
(119362,119364),
(121344,121398),
(121403,121452),
(121461,121461),
(121476,121476),
(121499,121503),
(121505,121519),
(122880,122886),
(122888,122904),
(122907,122913),
(122915,122916),
(122918,122922),
(125136,125142),
(125252,125258),
(917760,917999)
);

const PUCUUnicodeCategoryBlocks7:array[0..4] of TPUCUUnicodeCharRange=(
(1160,1161),
(6846,6846),
(8413,8416),
(8418,8420),
(42608,42610)
);

const PUCUUnicodeCategoryBlocks8:array[0..154] of TPUCUUnicodeCharRange=(
(2307,2307),
(2363,2363),
(2366,2368),
(2377,2380),
(2382,2383),
(2434,2435),
(2494,2496),
(2503,2504),
(2507,2508),
(2519,2519),
(2563,2563),
(2622,2624),
(2691,2691),
(2750,2752),
(2761,2761),
(2763,2764),
(2818,2819),
(2878,2878),
(2880,2880),
(2887,2888),
(2891,2892),
(2903,2903),
(3006,3007),
(3009,3010),
(3014,3016),
(3018,3020),
(3031,3031),
(3073,3075),
(3137,3140),
(3202,3203),
(3262,3262),
(3264,3268),
(3271,3272),
(3274,3275),
(3285,3286),
(3330,3331),
(3390,3392),
(3398,3400),
(3402,3404),
(3415,3415),
(3458,3459),
(3535,3537),
(3544,3551),
(3570,3571),
(3902,3903),
(3967,3967),
(4139,4140),
(4145,4145),
(4152,4152),
(4155,4156),
(4182,4183),
(4194,4196),
(4199,4205),
(4227,4228),
(4231,4236),
(4239,4239),
(4250,4252),
(6070,6070),
(6078,6085),
(6087,6088),
(6435,6438),
(6441,6443),
(6448,6449),
(6451,6456),
(6681,6682),
(6741,6741),
(6743,6743),
(6753,6753),
(6755,6756),
(6765,6770),
(6916,6916),
(6965,6965),
(6971,6971),
(6973,6977),
(6979,6980),
(7042,7042),
(7073,7073),
(7078,7079),
(7082,7082),
(7143,7143),
(7146,7148),
(7150,7150),
(7154,7155),
(7204,7211),
(7220,7221),
(7393,7393),
(7410,7411),
(12334,12335),
(43043,43044),
(43047,43047),
(43136,43137),
(43188,43203),
(43346,43347),
(43395,43395),
(43444,43445),
(43450,43451),
(43453,43456),
(43567,43568),
(43571,43572),
(43597,43597),
(43643,43643),
(43645,43645),
(43755,43755),
(43758,43759),
(43765,43765),
(44003,44004),
(44006,44007),
(44009,44010),
(44012,44012),
(69632,69632),
(69634,69634),
(69762,69762),
(69808,69810),
(69815,69816),
(69932,69932),
(70018,70018),
(70067,70069),
(70079,70080),
(70188,70190),
(70194,70195),
(70197,70197),
(70368,70370),
(70402,70403),
(70462,70463),
(70465,70468),
(70471,70472),
(70475,70477),
(70487,70487),
(70498,70499),
(70709,70711),
(70720,70721),
(70725,70725),
(70832,70834),
(70841,70841),
(70843,70846),
(70849,70849),
(71087,71089),
(71096,71099),
(71102,71102),
(71216,71218),
(71227,71228),
(71230,71230),
(71340,71340),
(71342,71343),
(71350,71350),
(71456,71457),
(71462,71462),
(72751,72751),
(72766,72766),
(72873,72873),
(72881,72881),
(72884,72884),
(94033,94078),
(119141,119142),
(119149,119154)
);

const PUCUUnicodeCategoryBlocks9:array[0..53] of TPUCUUnicodeCharRange=(
(48,57),
(1632,1641),
(1776,1785),
(1984,1993),
(2406,2415),
(2534,2543),
(2662,2671),
(2790,2799),
(2918,2927),
(3046,3055),
(3174,3183),
(3302,3311),
(3430,3439),
(3558,3567),
(3664,3673),
(3792,3801),
(3872,3881),
(4160,4169),
(4240,4249),
(6112,6121),
(6160,6169),
(6470,6479),
(6608,6617),
(6784,6793),
(6800,6809),
(6992,7001),
(7088,7097),
(7232,7241),
(7248,7257),
(42528,42537),
(43216,43225),
(43264,43273),
(43472,43481),
(43504,43513),
(43600,43609),
(44016,44025),
(65296,65305),
(66720,66729),
(69734,69743),
(69872,69881),
(69942,69951),
(70096,70105),
(70384,70393),
(70736,70745),
(70864,70873),
(71248,71257),
(71360,71369),
(71472,71481),
(71904,71913),
(72784,72793),
(92768,92777),
(93008,93017),
(120782,120831),
(125264,125273)
);

const PUCUUnicodeCategoryBlocks10:array[0..11] of TPUCUUnicodeCharRange=(
(5870,5872),
(8544,8578),
(8581,8584),
(12295,12295),
(12321,12329),
(12344,12346),
(42726,42735),
(65856,65908),
(66369,66369),
(66378,66378),
(66513,66517),
(74752,74862)
);

const PUCUUnicodeCategoryBlocks11:array[0..59] of TPUCUUnicodeCharRange=(
(178,179),
(185,185),
(188,190),
(2548,2553),
(2930,2935),
(3056,3058),
(3192,3198),
(3416,3422),
(3440,3448),
(3882,3891),
(4969,4988),
(6128,6137),
(6618,6618),
(8304,8304),
(8308,8313),
(8320,8329),
(8528,8543),
(8585,8585),
(9312,9371),
(9450,9471),
(10102,10131),
(11517,11517),
(12690,12693),
(12832,12841),
(12872,12879),
(12881,12895),
(12928,12937),
(12977,12991),
(43056,43061),
(65799,65843),
(65909,65912),
(65930,65931),
(66273,66299),
(66336,66339),
(67672,67679),
(67705,67711),
(67751,67759),
(67835,67839),
(67862,67867),
(68028,68029),
(68032,68047),
(68050,68095),
(68160,68167),
(68221,68222),
(68253,68255),
(68331,68335),
(68440,68447),
(68472,68479),
(68521,68527),
(68858,68863),
(69216,69246),
(69714,69733),
(70113,70132),
(71482,71483),
(71914,71922),
(72794,72812),
(93019,93025),
(119648,119665),
(125127,125135),
(127232,127244)
);

const PUCUUnicodeCategoryBlocks12:array[0..6] of TPUCUUnicodeCharRange=(
(32,32),
(160,160),
(5760,5760),
(8192,8202),
(8239,8239),
(8287,8287),
(12288,12288)
);

const PUCUUnicodeCategoryBlocks13:array[0..0] of TPUCUUnicodeCharRange=(
(8232,8232)
);

const PUCUUnicodeCategoryBlocks14:array[0..0] of TPUCUUnicodeCharRange=(
(8233,8233)
);

const PUCUUnicodeCategoryBlocks15:array[0..1] of TPUCUUnicodeCharRange=(
(0,31),
(127,159)
);

const PUCUUnicodeCategoryBlocks16:array[0..17] of TPUCUUnicodeCharRange=(
(173,173),
(1536,1541),
(1564,1564),
(1757,1757),
(1807,1807),
(2274,2274),
(6158,6158),
(8203,8207),
(8234,8238),
(8288,8292),
(8294,8303),
(65279,65279),
(65529,65531),
(69821,69821),
(113824,113827),
(119155,119162),
(917505,917505),
(917536,917631)
);

const PUCUUnicodeCategoryBlocks17:array[0..2] of TPUCUUnicodeCharRange=(
(57344,63743),
(983040,1048573),
(1048576,1114109)
);

const PUCUUnicodeCategoryBlocks18:array[0..0] of TPUCUUnicodeCharRange=(
(55296,57343)
);

const PUCUUnicodeCategoryBlocks19:array[0..16] of TPUCUUnicodeCharRange=(
(45,45),
(1418,1418),
(1470,1470),
(5120,5120),
(6150,6150),
(8208,8213),
(11799,11799),
(11802,11802),
(11834,11835),
(11840,11840),
(12316,12316),
(12336,12336),
(12448,12448),
(65073,65074),
(65112,65112),
(65123,65123),
(65293,65293)
);

const PUCUUnicodeCategoryBlocks20:array[0..74] of TPUCUUnicodeCharRange=(
(40,40),
(91,91),
(123,123),
(3898,3898),
(3900,3900),
(5787,5787),
(8218,8218),
(8222,8222),
(8261,8261),
(8317,8317),
(8333,8333),
(8968,8968),
(8970,8970),
(9001,9001),
(10088,10088),
(10090,10090),
(10092,10092),
(10094,10094),
(10096,10096),
(10098,10098),
(10100,10100),
(10181,10181),
(10214,10214),
(10216,10216),
(10218,10218),
(10220,10220),
(10222,10222),
(10627,10627),
(10629,10629),
(10631,10631),
(10633,10633),
(10635,10635),
(10637,10637),
(10639,10639),
(10641,10641),
(10643,10643),
(10645,10645),
(10647,10647),
(10712,10712),
(10714,10714),
(10748,10748),
(11810,11810),
(11812,11812),
(11814,11814),
(11816,11816),
(11842,11842),
(12296,12296),
(12298,12298),
(12300,12300),
(12302,12302),
(12304,12304),
(12308,12308),
(12310,12310),
(12312,12312),
(12314,12314),
(12317,12317),
(64831,64831),
(65047,65047),
(65077,65077),
(65079,65079),
(65081,65081),
(65083,65083),
(65085,65085),
(65087,65087),
(65089,65089),
(65091,65091),
(65095,65095),
(65113,65113),
(65115,65115),
(65117,65117),
(65288,65288),
(65339,65339),
(65371,65371),
(65375,65375),
(65378,65378)
);

const PUCUUnicodeCategoryBlocks21:array[0..71] of TPUCUUnicodeCharRange=(
(41,41),
(93,93),
(125,125),
(3899,3899),
(3901,3901),
(5788,5788),
(8262,8262),
(8318,8318),
(8334,8334),
(8969,8969),
(8971,8971),
(9002,9002),
(10089,10089),
(10091,10091),
(10093,10093),
(10095,10095),
(10097,10097),
(10099,10099),
(10101,10101),
(10182,10182),
(10215,10215),
(10217,10217),
(10219,10219),
(10221,10221),
(10223,10223),
(10628,10628),
(10630,10630),
(10632,10632),
(10634,10634),
(10636,10636),
(10638,10638),
(10640,10640),
(10642,10642),
(10644,10644),
(10646,10646),
(10648,10648),
(10713,10713),
(10715,10715),
(10749,10749),
(11811,11811),
(11813,11813),
(11815,11815),
(11817,11817),
(12297,12297),
(12299,12299),
(12301,12301),
(12303,12303),
(12305,12305),
(12309,12309),
(12311,12311),
(12313,12313),
(12315,12315),
(12318,12319),
(64830,64830),
(65048,65048),
(65078,65078),
(65080,65080),
(65082,65082),
(65084,65084),
(65086,65086),
(65088,65088),
(65090,65090),
(65092,65092),
(65096,65096),
(65114,65114),
(65116,65116),
(65118,65118),
(65289,65289),
(65341,65341),
(65373,65373),
(65376,65376),
(65379,65379)
);

const PUCUUnicodeCategoryBlocks22:array[0..5] of TPUCUUnicodeCharRange=(
(95,95),
(8255,8256),
(8276,8276),
(65075,65076),
(65101,65103),
(65343,65343)
);

const PUCUUnicodeCategoryBlocks23:array[0..164] of TPUCUUnicodeCharRange=(
(33,35),
(37,39),
(42,42),
(44,44),
(46,47),
(58,59),
(63,64),
(92,92),
(161,161),
(167,167),
(182,183),
(191,191),
(894,894),
(903,903),
(1370,1375),
(1417,1417),
(1472,1472),
(1475,1475),
(1478,1478),
(1523,1524),
(1545,1546),
(1548,1549),
(1563,1563),
(1566,1567),
(1642,1645),
(1748,1748),
(1792,1805),
(2039,2041),
(2096,2110),
(2142,2142),
(2404,2405),
(2416,2416),
(2800,2800),
(3572,3572),
(3663,3663),
(3674,3675),
(3844,3858),
(3860,3860),
(3973,3973),
(4048,4052),
(4057,4058),
(4170,4175),
(4347,4347),
(4960,4968),
(5741,5742),
(5867,5869),
(5941,5942),
(6100,6102),
(6104,6106),
(6144,6149),
(6151,6154),
(6468,6469),
(6686,6687),
(6816,6822),
(6824,6829),
(7002,7008),
(7164,7167),
(7227,7231),
(7294,7295),
(7360,7367),
(7379,7379),
(8214,8215),
(8224,8231),
(8240,8248),
(8251,8254),
(8257,8259),
(8263,8273),
(8275,8275),
(8277,8286),
(11513,11516),
(11518,11519),
(11632,11632),
(11776,11777),
(11782,11784),
(11787,11787),
(11790,11798),
(11800,11801),
(11803,11803),
(11806,11807),
(11818,11822),
(11824,11833),
(11836,11839),
(11841,11841),
(11843,11844),
(12289,12291),
(12349,12349),
(12539,12539),
(42238,42239),
(42509,42511),
(42611,42611),
(42622,42622),
(42738,42743),
(43124,43127),
(43214,43215),
(43256,43258),
(43260,43260),
(43310,43311),
(43359,43359),
(43457,43469),
(43486,43487),
(43612,43615),
(43742,43743),
(43760,43761),
(44011,44011),
(65040,65046),
(65049,65049),
(65072,65072),
(65093,65094),
(65097,65100),
(65104,65106),
(65108,65111),
(65119,65121),
(65128,65128),
(65130,65131),
(65281,65283),
(65285,65287),
(65290,65290),
(65292,65292),
(65294,65295),
(65306,65307),
(65311,65312),
(65340,65340),
(65377,65377),
(65380,65381),
(65792,65794),
(66463,66463),
(66512,66512),
(66927,66927),
(67671,67671),
(67871,67871),
(67903,67903),
(68176,68184),
(68223,68223),
(68336,68342),
(68409,68415),
(68505,68508),
(69703,69709),
(69819,69820),
(69822,69825),
(69952,69955),
(70004,70005),
(70085,70089),
(70093,70093),
(70107,70107),
(70109,70111),
(70200,70205),
(70313,70313),
(70731,70735),
(70747,70747),
(70749,70749),
(70854,70854),
(71105,71127),
(71233,71235),
(71264,71276),
(71484,71486),
(72769,72773),
(72816,72817),
(74864,74868),
(92782,92783),
(92917,92917),
(92983,92987),
(92996,92996),
(113823,113823),
(121479,121483),
(125278,125279)
);

const PUCUUnicodeCategoryBlocks24:array[0..63] of TPUCUUnicodeCharRange=(
(43,43),
(60,62),
(124,124),
(126,126),
(172,172),
(177,177),
(215,215),
(247,247),
(1014,1014),
(1542,1544),
(8260,8260),
(8274,8274),
(8314,8316),
(8330,8332),
(8472,8472),
(8512,8516),
(8523,8523),
(8592,8596),
(8602,8603),
(8608,8608),
(8611,8611),
(8614,8614),
(8622,8622),
(8654,8655),
(8658,8658),
(8660,8660),
(8692,8959),
(8992,8993),
(9084,9084),
(9115,9139),
(9180,9185),
(9655,9655),
(9665,9665),
(9720,9727),
(9839,9839),
(10176,10180),
(10183,10213),
(10224,10239),
(10496,10626),
(10649,10711),
(10716,10747),
(10750,11007),
(11056,11076),
(11079,11084),
(64297,64297),
(65122,65122),
(65124,65126),
(65291,65291),
(65308,65310),
(65372,65372),
(65374,65374),
(65506,65506),
(65513,65516),
(120513,120513),
(120539,120539),
(120571,120571),
(120597,120597),
(120629,120629),
(120655,120655),
(120687,120687),
(120713,120713),
(120745,120745),
(120771,120771),
(126704,126705)
);

const PUCUUnicodeCategoryBlocks25:array[0..16] of TPUCUUnicodeCharRange=(
(36,36),
(162,165),
(1423,1423),
(1547,1547),
(2546,2547),
(2555,2555),
(2801,2801),
(3065,3065),
(3647,3647),
(6107,6107),
(8352,8382),
(43064,43064),
(65020,65020),
(65129,65129),
(65284,65284),
(65504,65505),
(65509,65510)
);

const PUCUUnicodeCategoryBlocks26:array[0..28] of TPUCUUnicodeCharRange=(
(94,94),
(96,96),
(168,168),
(175,175),
(180,180),
(184,184),
(706,709),
(722,735),
(741,747),
(749,749),
(751,767),
(885,885),
(900,901),
(8125,8125),
(8127,8129),
(8141,8143),
(8157,8159),
(8173,8175),
(8189,8190),
(12443,12444),
(42752,42774),
(42784,42785),
(42889,42890),
(43867,43867),
(64434,64449),
(65342,65342),
(65344,65344),
(65507,65507),
(127995,127999)
);

const PUCUUnicodeCategoryBlocks27:array[0..173] of TPUCUUnicodeCharRange=(
(166,166),
(169,169),
(174,174),
(176,176),
(1154,1154),
(1421,1422),
(1550,1551),
(1758,1758),
(1769,1769),
(1789,1790),
(2038,2038),
(2554,2554),
(2928,2928),
(3059,3064),
(3066,3066),
(3199,3199),
(3407,3407),
(3449,3449),
(3841,3843),
(3859,3859),
(3861,3863),
(3866,3871),
(3892,3892),
(3894,3894),
(3896,3896),
(4030,4037),
(4039,4044),
(4046,4047),
(4053,4056),
(4254,4255),
(5008,5017),
(6464,6464),
(6622,6655),
(7009,7018),
(7028,7036),
(8448,8449),
(8451,8454),
(8456,8457),
(8468,8468),
(8470,8471),
(8478,8483),
(8485,8485),
(8487,8487),
(8489,8489),
(8494,8494),
(8506,8507),
(8522,8522),
(8524,8525),
(8527,8527),
(8586,8587),
(8597,8601),
(8604,8607),
(8609,8610),
(8612,8613),
(8615,8621),
(8623,8653),
(8656,8657),
(8659,8659),
(8661,8691),
(8960,8967),
(8972,8991),
(8994,9000),
(9003,9083),
(9085,9114),
(9140,9179),
(9186,9214),
(9216,9254),
(9280,9290),
(9372,9449),
(9472,9654),
(9656,9664),
(9666,9719),
(9728,9838),
(9840,10087),
(10132,10175),
(10240,10495),
(11008,11055),
(11077,11078),
(11085,11123),
(11126,11157),
(11160,11193),
(11197,11208),
(11210,11217),
(11244,11247),
(11493,11498),
(11904,11929),
(11931,12019),
(12032,12245),
(12272,12283),
(12292,12292),
(12306,12307),
(12320,12320),
(12342,12343),
(12350,12351),
(12688,12689),
(12694,12703),
(12736,12771),
(12800,12830),
(12842,12871),
(12880,12880),
(12896,12927),
(12938,12976),
(12992,13054),
(13056,13311),
(19904,19967),
(42128,42182),
(43048,43051),
(43062,43063),
(43065,43065),
(43639,43641),
(65021,65021),
(65508,65508),
(65512,65512),
(65517,65518),
(65532,65533),
(65847,65855),
(65913,65929),
(65932,65934),
(65936,65947),
(65952,65952),
(66000,66044),
(67703,67704),
(68296,68296),
(71487,71487),
(92988,92991),
(92997,92997),
(113820,113820),
(118784,119029),
(119040,119078),
(119081,119140),
(119146,119148),
(119171,119172),
(119180,119209),
(119214,119272),
(119296,119361),
(119365,119365),
(119552,119638),
(120832,121343),
(121399,121402),
(121453,121460),
(121462,121475),
(121477,121478),
(126976,127019),
(127024,127123),
(127136,127150),
(127153,127167),
(127169,127183),
(127185,127221),
(127248,127278),
(127280,127339),
(127344,127404),
(127462,127490),
(127504,127547),
(127552,127560),
(127568,127569),
(127744,127994),
(128000,128722),
(128736,128748),
(128752,128758),
(128768,128883),
(128896,128980),
(129024,129035),
(129040,129095),
(129104,129113),
(129120,129159),
(129168,129197),
(129296,129310),
(129312,129319),
(129328,129328),
(129331,129342),
(129344,129355),
(129360,129374),
(129408,129425),
(129472,129472)
);

const PUCUUnicodeCategoryBlocks28:array[0..10] of TPUCUUnicodeCharRange=(
(171,171),
(8216,8216),
(8219,8220),
(8223,8223),
(8249,8249),
(11778,11778),
(11780,11780),
(11785,11785),
(11788,11788),
(11804,11804),
(11808,11808)
);

const PUCUUnicodeCategoryBlocks29:array[0..9] of TPUCUUnicodeCharRange=(
(187,187),
(8217,8217),
(8221,8221),
(8250,8250),
(11779,11779),
(11781,11781),
(11786,11786),
(11789,11789),
(11805,11805),
(11809,11809)
);

const PUCUUnicodeCategoryBlocksData:array[0..29] of pointer=(
@PUCUUnicodeCategoryBlocks0,
@PUCUUnicodeCategoryBlocks1,
@PUCUUnicodeCategoryBlocks2,
@PUCUUnicodeCategoryBlocks3,
@PUCUUnicodeCategoryBlocks4,
@PUCUUnicodeCategoryBlocks5,
@PUCUUnicodeCategoryBlocks6,
@PUCUUnicodeCategoryBlocks7,
@PUCUUnicodeCategoryBlocks8,
@PUCUUnicodeCategoryBlocks9,
@PUCUUnicodeCategoryBlocks10,
@PUCUUnicodeCategoryBlocks11,
@PUCUUnicodeCategoryBlocks12,
@PUCUUnicodeCategoryBlocks13,
@PUCUUnicodeCategoryBlocks14,
@PUCUUnicodeCategoryBlocks15,
@PUCUUnicodeCategoryBlocks16,
@PUCUUnicodeCategoryBlocks17,
@PUCUUnicodeCategoryBlocks18,
@PUCUUnicodeCategoryBlocks19,
@PUCUUnicodeCategoryBlocks20,
@PUCUUnicodeCategoryBlocks21,
@PUCUUnicodeCategoryBlocks22,
@PUCUUnicodeCategoryBlocks23,
@PUCUUnicodeCategoryBlocks24,
@PUCUUnicodeCategoryBlocks25,
@PUCUUnicodeCategoryBlocks26,
@PUCUUnicodeCategoryBlocks27,
@PUCUUnicodeCategoryBlocks28,
@PUCUUnicodeCategoryBlocks29
);

const PUCUUnicodeCategoryBlocksCounts:array[0..29] of longint=(
638,
627,
633,
10,
57,
445,
285,
5,
155,
54,
12,
60,
7,
1,
1,
2,
18,
3,
1,
17,
75,
72,
6,
165,
64,
17,
29,
174,
11,
10
);

const PUCUCountUnicodeIgnoreCaseCategoryBlocks=29;

const PUCUUnicodeIgnoreCaseCategoryBlocks0:array[0..637] of TPUCUUnicodeCharRange=(
(888,889),
(896,899),
(907,907),
(909,909),
(930,930),
(1328,1328),
(1367,1368),
(1376,1376),
(1416,1416),
(1419,1420),
(1424,1424),
(1480,1487),
(1515,1519),
(1525,1535),
(1565,1565),
(1806,1806),
(1867,1868),
(1970,1983),
(2043,2047),
(2094,2095),
(2111,2111),
(2140,2141),
(2143,2207),
(2229,2229),
(2238,2259),
(2436,2436),
(2445,2446),
(2449,2450),
(2473,2473),
(2481,2481),
(2483,2485),
(2490,2491),
(2501,2502),
(2505,2506),
(2511,2518),
(2520,2523),
(2526,2526),
(2532,2533),
(2556,2560),
(2564,2564),
(2571,2574),
(2577,2578),
(2601,2601),
(2609,2609),
(2612,2612),
(2615,2615),
(2618,2619),
(2621,2621),
(2627,2630),
(2633,2634),
(2638,2640),
(2642,2648),
(2653,2653),
(2655,2661),
(2678,2688),
(2692,2692),
(2702,2702),
(2706,2706),
(2729,2729),
(2737,2737),
(2740,2740),
(2746,2747),
(2758,2758),
(2762,2762),
(2766,2767),
(2769,2783),
(2788,2789),
(2802,2808),
(2810,2816),
(2820,2820),
(2829,2830),
(2833,2834),
(2857,2857),
(2865,2865),
(2868,2868),
(2874,2875),
(2885,2886),
(2889,2890),
(2894,2901),
(2904,2907),
(2910,2910),
(2916,2917),
(2936,2945),
(2948,2948),
(2955,2957),
(2961,2961),
(2966,2968),
(2971,2971),
(2973,2973),
(2976,2978),
(2981,2983),
(2987,2989),
(3002,3005),
(3011,3013),
(3017,3017),
(3022,3023),
(3025,3030),
(3032,3045),
(3067,3071),
(3076,3076),
(3085,3085),
(3089,3089),
(3113,3113),
(3130,3132),
(3141,3141),
(3145,3145),
(3150,3156),
(3159,3159),
(3163,3167),
(3172,3173),
(3184,3191),
(3204,3204),
(3213,3213),
(3217,3217),
(3241,3241),
(3252,3252),
(3258,3259),
(3269,3269),
(3273,3273),
(3278,3284),
(3287,3293),
(3295,3295),
(3300,3301),
(3312,3312),
(3315,3328),
(3332,3332),
(3341,3341),
(3345,3345),
(3387,3388),
(3397,3397),
(3401,3401),
(3408,3411),
(3428,3429),
(3456,3457),
(3460,3460),
(3479,3481),
(3506,3506),
(3516,3516),
(3518,3519),
(3527,3529),
(3531,3534),
(3541,3541),
(3543,3543),
(3552,3557),
(3568,3569),
(3573,3584),
(3643,3646),
(3676,3712),
(3715,3715),
(3717,3718),
(3721,3721),
(3723,3724),
(3726,3731),
(3736,3736),
(3744,3744),
(3748,3748),
(3750,3750),
(3752,3753),
(3756,3756),
(3770,3770),
(3774,3775),
(3781,3781),
(3783,3783),
(3790,3791),
(3802,3803),
(3808,3839),
(3912,3912),
(3949,3952),
(3992,3992),
(4029,4029),
(4045,4045),
(4059,4095),
(4294,4294),
(4296,4300),
(4302,4303),
(4681,4681),
(4686,4687),
(4695,4695),
(4697,4697),
(4702,4703),
(4745,4745),
(4750,4751),
(4785,4785),
(4790,4791),
(4799,4799),
(4801,4801),
(4806,4807),
(4823,4823),
(4881,4881),
(4886,4887),
(4955,4956),
(4989,4991),
(5018,5023),
(5110,5111),
(5118,5119),
(5789,5791),
(5881,5887),
(5901,5901),
(5909,5919),
(5943,5951),
(5972,5983),
(5997,5997),
(6001,6001),
(6004,6015),
(6110,6111),
(6122,6127),
(6138,6143),
(6159,6159),
(6170,6175),
(6264,6271),
(6315,6319),
(6390,6399),
(6431,6431),
(6444,6447),
(6460,6463),
(6465,6467),
(6510,6511),
(6517,6527),
(6572,6575),
(6602,6607),
(6619,6621),
(6684,6685),
(6751,6751),
(6781,6782),
(6794,6799),
(6810,6815),
(6830,6831),
(6847,6911),
(6988,6991),
(7037,7039),
(7156,7163),
(7224,7226),
(7242,7244),
(7305,7359),
(7368,7375),
(7415,7415),
(7418,7423),
(7670,7674),
(7958,7959),
(7966,7967),
(8006,8007),
(8014,8015),
(8024,8024),
(8026,8026),
(8028,8028),
(8030,8030),
(8062,8063),
(8117,8117),
(8133,8133),
(8148,8149),
(8156,8156),
(8176,8177),
(8181,8181),
(8191,8191),
(8293,8293),
(8306,8307),
(8335,8335),
(8349,8351),
(8383,8399),
(8433,8447),
(8588,8591),
(9215,9215),
(9255,9279),
(9291,9311),
(11124,11125),
(11158,11159),
(11194,11196),
(11209,11209),
(11218,11243),
(11248,11263),
(11311,11311),
(11359,11359),
(11508,11512),
(11558,11558),
(11560,11564),
(11566,11567),
(11624,11630),
(11633,11646),
(11671,11679),
(11687,11687),
(11695,11695),
(11703,11703),
(11711,11711),
(11719,11719),
(11727,11727),
(11735,11735),
(11743,11743),
(11845,11903),
(11930,11930),
(12020,12031),
(12246,12271),
(12284,12287),
(12352,12352),
(12439,12440),
(12544,12548),
(12590,12592),
(12687,12687),
(12731,12735),
(12772,12783),
(12831,12831),
(13055,13055),
(19894,19903),
(40918,40959),
(42125,42127),
(42183,42191),
(42540,42559),
(42744,42751),
(42927,42927),
(42936,42998),
(43052,43055),
(43066,43071),
(43128,43135),
(43206,43213),
(43226,43231),
(43262,43263),
(43348,43358),
(43389,43391),
(43470,43470),
(43482,43485),
(43519,43519),
(43575,43583),
(43598,43599),
(43610,43611),
(43715,43738),
(43767,43776),
(43783,43784),
(43791,43792),
(43799,43807),
(43815,43815),
(43823,43823),
(43878,43887),
(44014,44015),
(44026,44031),
(55204,55215),
(55239,55242),
(55292,55295),
(64110,64111),
(64218,64255),
(64263,64274),
(64280,64284),
(64311,64311),
(64317,64317),
(64319,64319),
(64322,64322),
(64325,64325),
(64450,64466),
(64832,64847),
(64912,64913),
(64968,65007),
(65022,65023),
(65050,65055),
(65107,65107),
(65127,65127),
(65132,65135),
(65141,65141),
(65277,65278),
(65280,65280),
(65471,65473),
(65480,65481),
(65488,65489),
(65496,65497),
(65501,65503),
(65511,65511),
(65519,65528),
(65534,65535),
(65548,65548),
(65575,65575),
(65595,65595),
(65598,65598),
(65614,65615),
(65630,65663),
(65787,65791),
(65795,65798),
(65844,65846),
(65935,65935),
(65948,65951),
(65953,65999),
(66046,66175),
(66205,66207),
(66257,66271),
(66300,66303),
(66340,66351),
(66379,66383),
(66427,66431),
(66462,66462),
(66500,66503),
(66518,66559),
(66718,66719),
(66730,66735),
(66772,66775),
(66812,66815),
(66856,66863),
(66916,66926),
(66928,67071),
(67383,67391),
(67414,67423),
(67432,67583),
(67590,67591),
(67593,67593),
(67638,67638),
(67641,67643),
(67645,67646),
(67670,67670),
(67743,67750),
(67760,67807),
(67827,67827),
(67830,67834),
(67868,67870),
(67898,67902),
(67904,67967),
(68024,68027),
(68048,68049),
(68100,68100),
(68103,68107),
(68116,68116),
(68120,68120),
(68148,68151),
(68155,68158),
(68168,68175),
(68185,68191),
(68256,68287),
(68327,68330),
(68343,68351),
(68406,68408),
(68438,68439),
(68467,68471),
(68498,68504),
(68509,68520),
(68528,68607),
(68681,68735),
(68787,68799),
(68851,68857),
(68864,69215),
(69247,69631),
(69710,69713),
(69744,69758),
(69826,69839),
(69865,69871),
(69882,69887),
(69941,69941),
(69956,69967),
(70007,70015),
(70094,70095),
(70112,70112),
(70133,70143),
(70162,70162),
(70207,70271),
(70279,70279),
(70281,70281),
(70286,70286),
(70302,70302),
(70314,70319),
(70379,70383),
(70394,70399),
(70404,70404),
(70413,70414),
(70417,70418),
(70441,70441),
(70449,70449),
(70452,70452),
(70458,70459),
(70469,70470),
(70473,70474),
(70478,70479),
(70481,70486),
(70488,70492),
(70500,70501),
(70509,70511),
(70517,70655),
(70746,70746),
(70748,70748),
(70750,70783),
(70856,70863),
(70874,71039),
(71094,71095),
(71134,71167),
(71237,71247),
(71258,71263),
(71277,71295),
(71352,71359),
(71370,71423),
(71450,71452),
(71468,71471),
(71488,71839),
(71923,71934),
(71936,72383),
(72441,72703),
(72713,72713),
(72759,72759),
(72774,72783),
(72813,72815),
(72848,72849),
(72872,72872),
(72887,73727),
(74650,74751),
(74863,74863),
(74869,74879),
(75076,77823),
(78895,82943),
(83527,92159),
(92729,92735),
(92767,92767),
(92778,92781),
(92784,92879),
(92910,92911),
(92918,92927),
(92998,93007),
(93018,93018),
(93026,93026),
(93048,93052),
(93072,93951),
(94021,94031),
(94079,94094),
(94112,94175),
(94177,94207),
(100333,100351),
(101107,110591),
(110594,113663),
(113771,113775),
(113789,113791),
(113801,113807),
(113818,113819),
(113828,118783),
(119030,119039),
(119079,119080),
(119273,119295),
(119366,119551),
(119639,119647),
(119666,119807),
(119893,119893),
(119965,119965),
(119968,119969),
(119971,119972),
(119975,119976),
(119981,119981),
(119994,119994),
(119996,119996),
(120004,120004),
(120070,120070),
(120075,120076),
(120085,120085),
(120093,120093),
(120122,120122),
(120127,120127),
(120133,120133),
(120135,120137),
(120145,120145),
(120486,120487),
(120780,120781),
(121484,121498),
(121504,121504),
(121520,122879),
(122887,122887),
(122905,122906),
(122914,122914),
(122917,122917),
(122923,124927),
(125125,125126),
(125143,125183),
(125259,125263),
(125274,125277),
(125280,126463),
(126468,126468),
(126496,126496),
(126499,126499),
(126501,126502),
(126504,126504),
(126515,126515),
(126520,126520),
(126522,126522),
(126524,126529),
(126531,126534),
(126536,126536),
(126538,126538),
(126540,126540),
(126544,126544),
(126547,126547),
(126549,126550),
(126552,126552),
(126554,126554),
(126556,126556),
(126558,126558),
(126560,126560),
(126563,126563),
(126565,126566),
(126571,126571),
(126579,126579),
(126584,126584),
(126589,126589),
(126591,126591),
(126602,126602),
(126620,126624),
(126628,126628),
(126634,126634),
(126652,126703),
(126706,126975),
(127020,127023),
(127124,127135),
(127151,127152),
(127168,127168),
(127184,127184),
(127222,127231),
(127245,127247),
(127279,127279),
(127340,127343),
(127405,127461),
(127491,127503),
(127548,127551),
(127561,127567),
(127570,127743),
(128723,128735),
(128749,128751),
(128759,128767),
(128884,128895),
(128981,129023),
(129036,129039),
(129096,129103),
(129114,129119),
(129160,129167),
(129198,129295),
(129311,129311),
(129320,129327),
(129329,129330),
(129343,129343),
(129356,129359),
(129375,129407),
(129426,129471),
(129473,131071),
(173783,173823),
(177973,177983),
(178206,178207),
(183970,194559),
(195102,917504),
(917506,917535),
(917632,917759),
(918000,983039),
(1048574,1048575),
(1114110,1114111)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks1:array[0..164] of TPUCUUnicodeCharRange=(
(65,90),
(97,122),
(192,214),
(216,246),
(248,304),
(306,311),
(313,328),
(330,382),
(384,396),
(398,410),
(412,425),
(428,441),
(444,445),
(447,447),
(452,452),
(454,455),
(457,458),
(460,495),
(497,497),
(499,544),
(546,563),
(570,596),
(598,599),
(601,601),
(603,604),
(608,609),
(611,611),
(613,614),
(616,620),
(623,623),
(625,626),
(629,629),
(637,637),
(640,640),
(643,643),
(647,652),
(658,658),
(669,670),
(880,883),
(886,887),
(891,893),
(895,895),
(902,902),
(904,906),
(908,908),
(910,911),
(913,929),
(931,943),
(945,961),
(963,975),
(978,980),
(983,1007),
(1010,1012),
(1015,1019),
(1021,1153),
(1162,1327),
(1329,1366),
(1377,1414),
(4256,4293),
(4295,4295),
(4301,4301),
(5024,5109),
(5112,5117),
(7545,7545),
(7549,7549),
(7680,7829),
(7838,7838),
(7840,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8017,8017),
(8019,8019),
(8021,8021),
(8023,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8112,8113),
(8120,8123),
(8136,8139),
(8144,8145),
(8152,8155),
(8160,8161),
(8165,8165),
(8168,8172),
(8184,8187),
(8450,8450),
(8455,8455),
(8459,8461),
(8464,8466),
(8469,8469),
(8473,8477),
(8484,8484),
(8486,8486),
(8488,8488),
(8490,8493),
(8496,8499),
(8510,8511),
(8517,8517),
(8526,8526),
(8579,8580),
(11264,11310),
(11312,11358),
(11360,11376),
(11378,11379),
(11381,11382),
(11390,11491),
(11499,11502),
(11506,11507),
(11520,11557),
(11559,11559),
(11565,11565),
(42560,42605),
(42624,42651),
(42786,42799),
(42802,42863),
(42873,42887),
(42891,42893),
(42896,42899),
(42902,42926),
(42928,42935),
(43859,43859),
(43888,43967),
(65313,65338),
(65345,65370),
(66560,66639),
(66736,66771),
(66776,66811),
(68736,68786),
(68800,68850),
(71840,71903),
(119808,119833),
(119860,119885),
(119912,119937),
(119964,119964),
(119966,119967),
(119970,119970),
(119973,119974),
(119977,119980),
(119982,119989),
(120016,120041),
(120068,120069),
(120071,120074),
(120077,120084),
(120086,120092),
(120120,120121),
(120123,120126),
(120128,120132),
(120134,120134),
(120138,120144),
(120172,120197),
(120224,120249),
(120276,120301),
(120328,120353),
(120380,120405),
(120432,120457),
(120488,120512),
(120546,120570),
(120604,120628),
(120662,120686),
(120720,120744),
(120778,120778),
(125184,125251)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks2:array[0..127] of TPUCUUnicodeCharRange=(
(65,90),
(97,122),
(181,181),
(192,214),
(216,246),
(248,303),
(305,442),
(444,447),
(452,452),
(454,455),
(457,458),
(460,497),
(499,659),
(661,687),
(880,883),
(886,887),
(891,893),
(895,895),
(902,902),
(904,906),
(908,908),
(910,929),
(931,977),
(981,1011),
(1013,1013),
(1015,1153),
(1162,1327),
(1329,1366),
(1377,1415),
(4256,4293),
(4295,4295),
(4301,4301),
(5024,5109),
(5112,5117),
(7296,7304),
(7424,7467),
(7531,7543),
(7545,7578),
(7680,7837),
(7839,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8016,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8064,8116),
(8118,8124),
(8126,8126),
(8130,8132),
(8134,8140),
(8144,8147),
(8150,8155),
(8160,8172),
(8178,8180),
(8182,8188),
(8458,8458),
(8462,8463),
(8467,8467),
(8495,8495),
(8498,8498),
(8500,8500),
(8505,8505),
(8508,8509),
(8518,8521),
(8526,8526),
(8579,8580),
(11264,11310),
(11312,11358),
(11360,11387),
(11390,11492),
(11499,11502),
(11506,11507),
(11520,11557),
(11559,11559),
(11565,11565),
(42560,42605),
(42624,42651),
(42786,42863),
(42865,42887),
(42891,42894),
(42896,42926),
(42928,42935),
(43002,43002),
(43824,43866),
(43872,43877),
(43888,43967),
(64256,64262),
(64275,64279),
(65313,65338),
(65345,65370),
(66560,66639),
(66736,66771),
(66776,66811),
(68736,68786),
(68800,68850),
(71840,71903),
(119834,119859),
(119886,119892),
(119894,119911),
(119938,119963),
(119990,119993),
(119995,119995),
(119997,120003),
(120005,120015),
(120042,120067),
(120094,120119),
(120146,120171),
(120198,120223),
(120250,120275),
(120302,120327),
(120354,120379),
(120406,120431),
(120458,120485),
(120514,120538),
(120540,120545),
(120572,120596),
(120598,120603),
(120630,120654),
(120656,120661),
(120688,120712),
(120714,120719),
(120746,120770),
(120772,120777),
(120779,120779),
(125184,125251)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks3:array[0..8] of TPUCUUnicodeCharRange=(
(452,460),
(497,499),
(8064,8111),
(8115,8115),
(8124,8124),
(8131,8131),
(8140,8140),
(8179,8179),
(8188,8188)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks4:array[0..56] of TPUCUUnicodeCharRange=(
(688,705),
(710,721),
(736,740),
(748,748),
(750,750),
(884,884),
(890,890),
(1369,1369),
(1600,1600),
(1765,1766),
(2036,2037),
(2042,2042),
(2074,2074),
(2084,2084),
(2088,2088),
(2417,2417),
(3654,3654),
(3782,3782),
(4348,4348),
(6103,6103),
(6211,6211),
(6823,6823),
(7288,7293),
(7468,7530),
(7544,7544),
(7579,7615),
(8305,8305),
(8319,8319),
(8336,8348),
(11388,11389),
(11631,11631),
(11823,11823),
(12293,12293),
(12337,12341),
(12347,12347),
(12445,12446),
(12540,12542),
(40981,40981),
(42232,42237),
(42508,42508),
(42623,42623),
(42652,42653),
(42775,42783),
(42864,42864),
(42888,42888),
(43000,43001),
(43471,43471),
(43494,43494),
(43632,43632),
(43741,43741),
(43763,43764),
(43868,43871),
(65392,65392),
(65438,65439),
(92992,92995),
(94099,94111),
(94176,94176)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks5:array[0..444] of TPUCUUnicodeCharRange=(
(170,170),
(186,186),
(443,443),
(448,451),
(660,660),
(1488,1514),
(1520,1522),
(1568,1599),
(1601,1610),
(1646,1647),
(1649,1747),
(1749,1749),
(1774,1775),
(1786,1788),
(1791,1791),
(1808,1808),
(1810,1839),
(1869,1957),
(1969,1969),
(1994,2026),
(2048,2069),
(2112,2136),
(2208,2228),
(2230,2237),
(2308,2361),
(2365,2365),
(2384,2384),
(2392,2401),
(2418,2432),
(2437,2444),
(2447,2448),
(2451,2472),
(2474,2480),
(2482,2482),
(2486,2489),
(2493,2493),
(2510,2510),
(2524,2525),
(2527,2529),
(2544,2545),
(2565,2570),
(2575,2576),
(2579,2600),
(2602,2608),
(2610,2611),
(2613,2614),
(2616,2617),
(2649,2652),
(2654,2654),
(2674,2676),
(2693,2701),
(2703,2705),
(2707,2728),
(2730,2736),
(2738,2739),
(2741,2745),
(2749,2749),
(2768,2768),
(2784,2785),
(2809,2809),
(2821,2828),
(2831,2832),
(2835,2856),
(2858,2864),
(2866,2867),
(2869,2873),
(2877,2877),
(2908,2909),
(2911,2913),
(2929,2929),
(2947,2947),
(2949,2954),
(2958,2960),
(2962,2965),
(2969,2970),
(2972,2972),
(2974,2975),
(2979,2980),
(2984,2986),
(2990,3001),
(3024,3024),
(3077,3084),
(3086,3088),
(3090,3112),
(3114,3129),
(3133,3133),
(3160,3162),
(3168,3169),
(3200,3200),
(3205,3212),
(3214,3216),
(3218,3240),
(3242,3251),
(3253,3257),
(3261,3261),
(3294,3294),
(3296,3297),
(3313,3314),
(3333,3340),
(3342,3344),
(3346,3386),
(3389,3389),
(3406,3406),
(3412,3414),
(3423,3425),
(3450,3455),
(3461,3478),
(3482,3505),
(3507,3515),
(3517,3517),
(3520,3526),
(3585,3632),
(3634,3635),
(3648,3653),
(3713,3714),
(3716,3716),
(3719,3720),
(3722,3722),
(3725,3725),
(3732,3735),
(3737,3743),
(3745,3747),
(3749,3749),
(3751,3751),
(3754,3755),
(3757,3760),
(3762,3763),
(3773,3773),
(3776,3780),
(3804,3807),
(3840,3840),
(3904,3911),
(3913,3948),
(3976,3980),
(4096,4138),
(4159,4159),
(4176,4181),
(4186,4189),
(4193,4193),
(4197,4198),
(4206,4208),
(4213,4225),
(4238,4238),
(4304,4346),
(4349,4680),
(4682,4685),
(4688,4694),
(4696,4696),
(4698,4701),
(4704,4744),
(4746,4749),
(4752,4784),
(4786,4789),
(4792,4798),
(4800,4800),
(4802,4805),
(4808,4822),
(4824,4880),
(4882,4885),
(4888,4954),
(4992,5007),
(5121,5740),
(5743,5759),
(5761,5786),
(5792,5866),
(5873,5880),
(5888,5900),
(5902,5905),
(5920,5937),
(5952,5969),
(5984,5996),
(5998,6000),
(6016,6067),
(6108,6108),
(6176,6210),
(6212,6263),
(6272,6276),
(6279,6312),
(6314,6314),
(6320,6389),
(6400,6430),
(6480,6509),
(6512,6516),
(6528,6571),
(6576,6601),
(6656,6678),
(6688,6740),
(6917,6963),
(6981,6987),
(7043,7072),
(7086,7087),
(7098,7141),
(7168,7203),
(7245,7247),
(7258,7287),
(7401,7404),
(7406,7409),
(7413,7414),
(8501,8504),
(11568,11623),
(11648,11670),
(11680,11686),
(11688,11694),
(11696,11702),
(11704,11710),
(11712,11718),
(11720,11726),
(11728,11734),
(11736,11742),
(12294,12294),
(12348,12348),
(12353,12438),
(12447,12447),
(12449,12538),
(12543,12543),
(12549,12589),
(12593,12686),
(12704,12730),
(12784,12799),
(13312,19893),
(19968,40917),
(40960,40980),
(40982,42124),
(42192,42231),
(42240,42507),
(42512,42527),
(42538,42539),
(42606,42606),
(42656,42725),
(42895,42895),
(42999,42999),
(43003,43009),
(43011,43013),
(43015,43018),
(43020,43042),
(43072,43123),
(43138,43187),
(43250,43255),
(43259,43259),
(43261,43261),
(43274,43301),
(43312,43334),
(43360,43388),
(43396,43442),
(43488,43492),
(43495,43503),
(43514,43518),
(43520,43560),
(43584,43586),
(43588,43595),
(43616,43631),
(43633,43638),
(43642,43642),
(43646,43695),
(43697,43697),
(43701,43702),
(43705,43709),
(43712,43712),
(43714,43714),
(43739,43740),
(43744,43754),
(43762,43762),
(43777,43782),
(43785,43790),
(43793,43798),
(43808,43814),
(43816,43822),
(43968,44002),
(44032,55203),
(55216,55238),
(55243,55291),
(63744,64109),
(64112,64217),
(64285,64285),
(64287,64296),
(64298,64310),
(64312,64316),
(64318,64318),
(64320,64321),
(64323,64324),
(64326,64433),
(64467,64829),
(64848,64911),
(64914,64967),
(65008,65019),
(65136,65140),
(65142,65276),
(65382,65391),
(65393,65437),
(65440,65470),
(65474,65479),
(65482,65487),
(65490,65495),
(65498,65500),
(65536,65547),
(65549,65574),
(65576,65594),
(65596,65597),
(65599,65613),
(65616,65629),
(65664,65786),
(66176,66204),
(66208,66256),
(66304,66335),
(66352,66368),
(66370,66377),
(66384,66421),
(66432,66461),
(66464,66499),
(66504,66511),
(66640,66717),
(66816,66855),
(66864,66915),
(67072,67382),
(67392,67413),
(67424,67431),
(67584,67589),
(67592,67592),
(67594,67637),
(67639,67640),
(67644,67644),
(67647,67669),
(67680,67702),
(67712,67742),
(67808,67826),
(67828,67829),
(67840,67861),
(67872,67897),
(67968,68023),
(68030,68031),
(68096,68096),
(68112,68115),
(68117,68119),
(68121,68147),
(68192,68220),
(68224,68252),
(68288,68295),
(68297,68324),
(68352,68405),
(68416,68437),
(68448,68466),
(68480,68497),
(68608,68680),
(69635,69687),
(69763,69807),
(69840,69864),
(69891,69926),
(69968,70002),
(70006,70006),
(70019,70066),
(70081,70084),
(70106,70106),
(70108,70108),
(70144,70161),
(70163,70187),
(70272,70278),
(70280,70280),
(70282,70285),
(70287,70301),
(70303,70312),
(70320,70366),
(70405,70412),
(70415,70416),
(70419,70440),
(70442,70448),
(70450,70451),
(70453,70457),
(70461,70461),
(70480,70480),
(70493,70497),
(70656,70708),
(70727,70730),
(70784,70831),
(70852,70853),
(70855,70855),
(71040,71086),
(71128,71131),
(71168,71215),
(71236,71236),
(71296,71338),
(71424,71449),
(71935,71935),
(72384,72440),
(72704,72712),
(72714,72750),
(72768,72768),
(72818,72847),
(73728,74649),
(74880,75075),
(77824,78894),
(82944,83526),
(92160,92728),
(92736,92766),
(92880,92909),
(92928,92975),
(93027,93047),
(93053,93071),
(93952,94020),
(94032,94032),
(94208,100332),
(100352,101106),
(110592,110593),
(113664,113770),
(113776,113788),
(113792,113800),
(113808,113817),
(124928,125124),
(126464,126467),
(126469,126495),
(126497,126498),
(126500,126500),
(126503,126503),
(126505,126514),
(126516,126519),
(126521,126521),
(126523,126523),
(126530,126530),
(126535,126535),
(126537,126537),
(126539,126539),
(126541,126543),
(126545,126546),
(126548,126548),
(126551,126551),
(126553,126553),
(126555,126555),
(126557,126557),
(126559,126559),
(126561,126562),
(126564,126564),
(126567,126570),
(126572,126578),
(126580,126583),
(126585,126588),
(126590,126590),
(126592,126601),
(126603,126619),
(126625,126627),
(126629,126633),
(126635,126651),
(131072,173782),
(173824,177972),
(177984,178205),
(178208,183969),
(194560,195101)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks6:array[0..285] of TPUCUUnicodeCharRange=(
(768,879),
(921,921),
(1155,1159),
(1425,1469),
(1471,1471),
(1473,1474),
(1476,1477),
(1479,1479),
(1552,1562),
(1611,1631),
(1648,1648),
(1750,1756),
(1759,1764),
(1767,1768),
(1770,1773),
(1809,1809),
(1840,1866),
(1958,1968),
(2027,2035),
(2070,2073),
(2075,2083),
(2085,2087),
(2089,2093),
(2137,2139),
(2260,2273),
(2275,2306),
(2362,2362),
(2364,2364),
(2369,2376),
(2381,2381),
(2385,2391),
(2402,2403),
(2433,2433),
(2492,2492),
(2497,2500),
(2509,2509),
(2530,2531),
(2561,2562),
(2620,2620),
(2625,2626),
(2631,2632),
(2635,2637),
(2641,2641),
(2672,2673),
(2677,2677),
(2689,2690),
(2748,2748),
(2753,2757),
(2759,2760),
(2765,2765),
(2786,2787),
(2817,2817),
(2876,2876),
(2879,2879),
(2881,2884),
(2893,2893),
(2902,2902),
(2914,2915),
(2946,2946),
(3008,3008),
(3021,3021),
(3072,3072),
(3134,3136),
(3142,3144),
(3146,3149),
(3157,3158),
(3170,3171),
(3201,3201),
(3260,3260),
(3263,3263),
(3270,3270),
(3276,3277),
(3298,3299),
(3329,3329),
(3393,3396),
(3405,3405),
(3426,3427),
(3530,3530),
(3538,3540),
(3542,3542),
(3633,3633),
(3636,3642),
(3655,3662),
(3761,3761),
(3764,3769),
(3771,3772),
(3784,3789),
(3864,3865),
(3893,3893),
(3895,3895),
(3897,3897),
(3953,3966),
(3968,3972),
(3974,3975),
(3981,3991),
(3993,4028),
(4038,4038),
(4141,4144),
(4146,4151),
(4153,4154),
(4157,4158),
(4184,4185),
(4190,4192),
(4209,4212),
(4226,4226),
(4229,4230),
(4237,4237),
(4253,4253),
(4957,4959),
(5906,5908),
(5938,5940),
(5970,5971),
(6002,6003),
(6068,6069),
(6071,6077),
(6086,6086),
(6089,6099),
(6109,6109),
(6155,6157),
(6277,6278),
(6313,6313),
(6432,6434),
(6439,6440),
(6450,6450),
(6457,6459),
(6679,6680),
(6683,6683),
(6742,6742),
(6744,6750),
(6752,6752),
(6754,6754),
(6757,6764),
(6771,6780),
(6783,6783),
(6832,6845),
(6912,6915),
(6964,6964),
(6966,6970),
(6972,6972),
(6978,6978),
(7019,7027),
(7040,7041),
(7074,7077),
(7080,7081),
(7083,7085),
(7142,7142),
(7144,7145),
(7149,7149),
(7151,7153),
(7212,7219),
(7222,7223),
(7376,7378),
(7380,7392),
(7394,7400),
(7405,7405),
(7412,7412),
(7416,7417),
(7616,7669),
(7675,7679),
(8400,8412),
(8417,8417),
(8421,8432),
(11503,11505),
(11647,11647),
(11744,11775),
(12330,12333),
(12441,12442),
(42607,42607),
(42612,42621),
(42654,42655),
(42736,42737),
(43010,43010),
(43014,43014),
(43019,43019),
(43045,43046),
(43204,43205),
(43232,43249),
(43302,43309),
(43335,43345),
(43392,43394),
(43443,43443),
(43446,43449),
(43452,43452),
(43493,43493),
(43561,43566),
(43569,43570),
(43573,43574),
(43587,43587),
(43596,43596),
(43644,43644),
(43696,43696),
(43698,43700),
(43703,43704),
(43710,43711),
(43713,43713),
(43756,43757),
(43766,43766),
(44005,44005),
(44008,44008),
(44013,44013),
(64286,64286),
(65024,65039),
(65056,65071),
(66045,66045),
(66272,66272),
(66422,66426),
(68097,68099),
(68101,68102),
(68108,68111),
(68152,68154),
(68159,68159),
(68325,68326),
(69633,69633),
(69688,69702),
(69759,69761),
(69811,69814),
(69817,69818),
(69888,69890),
(69927,69931),
(69933,69940),
(70003,70003),
(70016,70017),
(70070,70078),
(70090,70092),
(70191,70193),
(70196,70196),
(70198,70199),
(70206,70206),
(70367,70367),
(70371,70378),
(70400,70401),
(70460,70460),
(70464,70464),
(70502,70508),
(70512,70516),
(70712,70719),
(70722,70724),
(70726,70726),
(70835,70840),
(70842,70842),
(70847,70848),
(70850,70851),
(71090,71093),
(71100,71101),
(71103,71104),
(71132,71133),
(71219,71226),
(71229,71229),
(71231,71232),
(71339,71339),
(71341,71341),
(71344,71349),
(71351,71351),
(71453,71455),
(71458,71461),
(71463,71467),
(72752,72758),
(72760,72765),
(72767,72767),
(72850,72871),
(72874,72880),
(72882,72883),
(72885,72886),
(92912,92916),
(92976,92982),
(94095,94098),
(113821,113822),
(119143,119145),
(119163,119170),
(119173,119179),
(119210,119213),
(119362,119364),
(121344,121398),
(121403,121452),
(121461,121461),
(121476,121476),
(121499,121503),
(121505,121519),
(122880,122886),
(122888,122904),
(122907,122913),
(122915,122916),
(122918,122922),
(125136,125142),
(125252,125258),
(917760,917999)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks7:array[0..4] of TPUCUUnicodeCharRange=(
(1160,1161),
(6846,6846),
(8413,8416),
(8418,8420),
(42608,42610)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks8:array[0..154] of TPUCUUnicodeCharRange=(
(2307,2307),
(2363,2363),
(2366,2368),
(2377,2380),
(2382,2383),
(2434,2435),
(2494,2496),
(2503,2504),
(2507,2508),
(2519,2519),
(2563,2563),
(2622,2624),
(2691,2691),
(2750,2752),
(2761,2761),
(2763,2764),
(2818,2819),
(2878,2878),
(2880,2880),
(2887,2888),
(2891,2892),
(2903,2903),
(3006,3007),
(3009,3010),
(3014,3016),
(3018,3020),
(3031,3031),
(3073,3075),
(3137,3140),
(3202,3203),
(3262,3262),
(3264,3268),
(3271,3272),
(3274,3275),
(3285,3286),
(3330,3331),
(3390,3392),
(3398,3400),
(3402,3404),
(3415,3415),
(3458,3459),
(3535,3537),
(3544,3551),
(3570,3571),
(3902,3903),
(3967,3967),
(4139,4140),
(4145,4145),
(4152,4152),
(4155,4156),
(4182,4183),
(4194,4196),
(4199,4205),
(4227,4228),
(4231,4236),
(4239,4239),
(4250,4252),
(6070,6070),
(6078,6085),
(6087,6088),
(6435,6438),
(6441,6443),
(6448,6449),
(6451,6456),
(6681,6682),
(6741,6741),
(6743,6743),
(6753,6753),
(6755,6756),
(6765,6770),
(6916,6916),
(6965,6965),
(6971,6971),
(6973,6977),
(6979,6980),
(7042,7042),
(7073,7073),
(7078,7079),
(7082,7082),
(7143,7143),
(7146,7148),
(7150,7150),
(7154,7155),
(7204,7211),
(7220,7221),
(7393,7393),
(7410,7411),
(12334,12335),
(43043,43044),
(43047,43047),
(43136,43137),
(43188,43203),
(43346,43347),
(43395,43395),
(43444,43445),
(43450,43451),
(43453,43456),
(43567,43568),
(43571,43572),
(43597,43597),
(43643,43643),
(43645,43645),
(43755,43755),
(43758,43759),
(43765,43765),
(44003,44004),
(44006,44007),
(44009,44010),
(44012,44012),
(69632,69632),
(69634,69634),
(69762,69762),
(69808,69810),
(69815,69816),
(69932,69932),
(70018,70018),
(70067,70069),
(70079,70080),
(70188,70190),
(70194,70195),
(70197,70197),
(70368,70370),
(70402,70403),
(70462,70463),
(70465,70468),
(70471,70472),
(70475,70477),
(70487,70487),
(70498,70499),
(70709,70711),
(70720,70721),
(70725,70725),
(70832,70834),
(70841,70841),
(70843,70846),
(70849,70849),
(71087,71089),
(71096,71099),
(71102,71102),
(71216,71218),
(71227,71228),
(71230,71230),
(71340,71340),
(71342,71343),
(71350,71350),
(71456,71457),
(71462,71462),
(72751,72751),
(72766,72766),
(72873,72873),
(72881,72881),
(72884,72884),
(94033,94078),
(119141,119142),
(119149,119154)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks9:array[0..53] of TPUCUUnicodeCharRange=(
(48,57),
(1632,1641),
(1776,1785),
(1984,1993),
(2406,2415),
(2534,2543),
(2662,2671),
(2790,2799),
(2918,2927),
(3046,3055),
(3174,3183),
(3302,3311),
(3430,3439),
(3558,3567),
(3664,3673),
(3792,3801),
(3872,3881),
(4160,4169),
(4240,4249),
(6112,6121),
(6160,6169),
(6470,6479),
(6608,6617),
(6784,6793),
(6800,6809),
(6992,7001),
(7088,7097),
(7232,7241),
(7248,7257),
(42528,42537),
(43216,43225),
(43264,43273),
(43472,43481),
(43504,43513),
(43600,43609),
(44016,44025),
(65296,65305),
(66720,66729),
(69734,69743),
(69872,69881),
(69942,69951),
(70096,70105),
(70384,70393),
(70736,70745),
(70864,70873),
(71248,71257),
(71360,71369),
(71472,71481),
(71904,71913),
(72784,72793),
(92768,92777),
(93008,93017),
(120782,120831),
(125264,125273)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks10:array[0..11] of TPUCUUnicodeCharRange=(
(5870,5872),
(8544,8578),
(8581,8584),
(12295,12295),
(12321,12329),
(12344,12346),
(42726,42735),
(65856,65908),
(66369,66369),
(66378,66378),
(66513,66517),
(74752,74862)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks11:array[0..59] of TPUCUUnicodeCharRange=(
(178,179),
(185,185),
(188,190),
(2548,2553),
(2930,2935),
(3056,3058),
(3192,3198),
(3416,3422),
(3440,3448),
(3882,3891),
(4969,4988),
(6128,6137),
(6618,6618),
(8304,8304),
(8308,8313),
(8320,8329),
(8528,8543),
(8585,8585),
(9312,9371),
(9450,9471),
(10102,10131),
(11517,11517),
(12690,12693),
(12832,12841),
(12872,12879),
(12881,12895),
(12928,12937),
(12977,12991),
(43056,43061),
(65799,65843),
(65909,65912),
(65930,65931),
(66273,66299),
(66336,66339),
(67672,67679),
(67705,67711),
(67751,67759),
(67835,67839),
(67862,67867),
(68028,68029),
(68032,68047),
(68050,68095),
(68160,68167),
(68221,68222),
(68253,68255),
(68331,68335),
(68440,68447),
(68472,68479),
(68521,68527),
(68858,68863),
(69216,69246),
(69714,69733),
(70113,70132),
(71482,71483),
(71914,71922),
(72794,72812),
(93019,93025),
(119648,119665),
(125127,125135),
(127232,127244)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks12:array[0..6] of TPUCUUnicodeCharRange=(
(32,32),
(160,160),
(5760,5760),
(8192,8202),
(8239,8239),
(8287,8287),
(12288,12288)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks13:array[0..0] of TPUCUUnicodeCharRange=(
(8232,8232)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks14:array[0..0] of TPUCUUnicodeCharRange=(
(8233,8233)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks15:array[0..1] of TPUCUUnicodeCharRange=(
(0,31),
(127,159)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks16:array[0..17] of TPUCUUnicodeCharRange=(
(173,173),
(1536,1541),
(1564,1564),
(1757,1757),
(1807,1807),
(2274,2274),
(6158,6158),
(8203,8207),
(8234,8238),
(8288,8292),
(8294,8303),
(65279,65279),
(65529,65531),
(69821,69821),
(113824,113827),
(119155,119162),
(917505,917505),
(917536,917631)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks17:array[0..2] of TPUCUUnicodeCharRange=(
(57344,63743),
(983040,1048573),
(1048576,1114109)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks18:array[0..0] of TPUCUUnicodeCharRange=(
(55296,57343)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks19:array[0..16] of TPUCUUnicodeCharRange=(
(45,45),
(1418,1418),
(1470,1470),
(5120,5120),
(6150,6150),
(8208,8213),
(11799,11799),
(11802,11802),
(11834,11835),
(11840,11840),
(12316,12316),
(12336,12336),
(12448,12448),
(65073,65074),
(65112,65112),
(65123,65123),
(65293,65293)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks20:array[0..74] of TPUCUUnicodeCharRange=(
(40,40),
(91,91),
(123,123),
(3898,3898),
(3900,3900),
(5787,5787),
(8218,8218),
(8222,8222),
(8261,8261),
(8317,8317),
(8333,8333),
(8968,8968),
(8970,8970),
(9001,9001),
(10088,10088),
(10090,10090),
(10092,10092),
(10094,10094),
(10096,10096),
(10098,10098),
(10100,10100),
(10181,10181),
(10214,10214),
(10216,10216),
(10218,10218),
(10220,10220),
(10222,10222),
(10627,10627),
(10629,10629),
(10631,10631),
(10633,10633),
(10635,10635),
(10637,10637),
(10639,10639),
(10641,10641),
(10643,10643),
(10645,10645),
(10647,10647),
(10712,10712),
(10714,10714),
(10748,10748),
(11810,11810),
(11812,11812),
(11814,11814),
(11816,11816),
(11842,11842),
(12296,12296),
(12298,12298),
(12300,12300),
(12302,12302),
(12304,12304),
(12308,12308),
(12310,12310),
(12312,12312),
(12314,12314),
(12317,12317),
(64831,64831),
(65047,65047),
(65077,65077),
(65079,65079),
(65081,65081),
(65083,65083),
(65085,65085),
(65087,65087),
(65089,65089),
(65091,65091),
(65095,65095),
(65113,65113),
(65115,65115),
(65117,65117),
(65288,65288),
(65339,65339),
(65371,65371),
(65375,65375),
(65378,65378)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks21:array[0..71] of TPUCUUnicodeCharRange=(
(41,41),
(93,93),
(125,125),
(3899,3899),
(3901,3901),
(5788,5788),
(8262,8262),
(8318,8318),
(8334,8334),
(8969,8969),
(8971,8971),
(9002,9002),
(10089,10089),
(10091,10091),
(10093,10093),
(10095,10095),
(10097,10097),
(10099,10099),
(10101,10101),
(10182,10182),
(10215,10215),
(10217,10217),
(10219,10219),
(10221,10221),
(10223,10223),
(10628,10628),
(10630,10630),
(10632,10632),
(10634,10634),
(10636,10636),
(10638,10638),
(10640,10640),
(10642,10642),
(10644,10644),
(10646,10646),
(10648,10648),
(10713,10713),
(10715,10715),
(10749,10749),
(11811,11811),
(11813,11813),
(11815,11815),
(11817,11817),
(12297,12297),
(12299,12299),
(12301,12301),
(12303,12303),
(12305,12305),
(12309,12309),
(12311,12311),
(12313,12313),
(12315,12315),
(12318,12319),
(64830,64830),
(65048,65048),
(65078,65078),
(65080,65080),
(65082,65082),
(65084,65084),
(65086,65086),
(65088,65088),
(65090,65090),
(65092,65092),
(65096,65096),
(65114,65114),
(65116,65116),
(65118,65118),
(65289,65289),
(65341,65341),
(65373,65373),
(65376,65376),
(65379,65379)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks22:array[0..5] of TPUCUUnicodeCharRange=(
(95,95),
(8255,8256),
(8276,8276),
(65075,65076),
(65101,65103),
(65343,65343)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks23:array[0..164] of TPUCUUnicodeCharRange=(
(33,35),
(37,39),
(42,42),
(44,44),
(46,47),
(58,59),
(63,64),
(92,92),
(161,161),
(167,167),
(182,183),
(191,191),
(894,894),
(903,903),
(1370,1375),
(1417,1417),
(1472,1472),
(1475,1475),
(1478,1478),
(1523,1524),
(1545,1546),
(1548,1549),
(1563,1563),
(1566,1567),
(1642,1645),
(1748,1748),
(1792,1805),
(2039,2041),
(2096,2110),
(2142,2142),
(2404,2405),
(2416,2416),
(2800,2800),
(3572,3572),
(3663,3663),
(3674,3675),
(3844,3858),
(3860,3860),
(3973,3973),
(4048,4052),
(4057,4058),
(4170,4175),
(4347,4347),
(4960,4968),
(5741,5742),
(5867,5869),
(5941,5942),
(6100,6102),
(6104,6106),
(6144,6149),
(6151,6154),
(6468,6469),
(6686,6687),
(6816,6822),
(6824,6829),
(7002,7008),
(7164,7167),
(7227,7231),
(7294,7295),
(7360,7367),
(7379,7379),
(8214,8215),
(8224,8231),
(8240,8248),
(8251,8254),
(8257,8259),
(8263,8273),
(8275,8275),
(8277,8286),
(11513,11516),
(11518,11519),
(11632,11632),
(11776,11777),
(11782,11784),
(11787,11787),
(11790,11798),
(11800,11801),
(11803,11803),
(11806,11807),
(11818,11822),
(11824,11833),
(11836,11839),
(11841,11841),
(11843,11844),
(12289,12291),
(12349,12349),
(12539,12539),
(42238,42239),
(42509,42511),
(42611,42611),
(42622,42622),
(42738,42743),
(43124,43127),
(43214,43215),
(43256,43258),
(43260,43260),
(43310,43311),
(43359,43359),
(43457,43469),
(43486,43487),
(43612,43615),
(43742,43743),
(43760,43761),
(44011,44011),
(65040,65046),
(65049,65049),
(65072,65072),
(65093,65094),
(65097,65100),
(65104,65106),
(65108,65111),
(65119,65121),
(65128,65128),
(65130,65131),
(65281,65283),
(65285,65287),
(65290,65290),
(65292,65292),
(65294,65295),
(65306,65307),
(65311,65312),
(65340,65340),
(65377,65377),
(65380,65381),
(65792,65794),
(66463,66463),
(66512,66512),
(66927,66927),
(67671,67671),
(67871,67871),
(67903,67903),
(68176,68184),
(68223,68223),
(68336,68342),
(68409,68415),
(68505,68508),
(69703,69709),
(69819,69820),
(69822,69825),
(69952,69955),
(70004,70005),
(70085,70089),
(70093,70093),
(70107,70107),
(70109,70111),
(70200,70205),
(70313,70313),
(70731,70735),
(70747,70747),
(70749,70749),
(70854,70854),
(71105,71127),
(71233,71235),
(71264,71276),
(71484,71486),
(72769,72773),
(72816,72817),
(74864,74868),
(92782,92783),
(92917,92917),
(92983,92987),
(92996,92996),
(113823,113823),
(121479,121483),
(125278,125279)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks24:array[0..63] of TPUCUUnicodeCharRange=(
(43,43),
(60,62),
(124,124),
(126,126),
(172,172),
(177,177),
(215,215),
(247,247),
(1014,1014),
(1542,1544),
(8260,8260),
(8274,8274),
(8314,8316),
(8330,8332),
(8472,8472),
(8512,8516),
(8523,8523),
(8592,8596),
(8602,8603),
(8608,8608),
(8611,8611),
(8614,8614),
(8622,8622),
(8654,8655),
(8658,8658),
(8660,8660),
(8692,8959),
(8992,8993),
(9084,9084),
(9115,9139),
(9180,9185),
(9655,9655),
(9665,9665),
(9720,9727),
(9839,9839),
(10176,10180),
(10183,10213),
(10224,10239),
(10496,10626),
(10649,10711),
(10716,10747),
(10750,11007),
(11056,11076),
(11079,11084),
(64297,64297),
(65122,65122),
(65124,65126),
(65291,65291),
(65308,65310),
(65372,65372),
(65374,65374),
(65506,65506),
(65513,65516),
(120513,120513),
(120539,120539),
(120571,120571),
(120597,120597),
(120629,120629),
(120655,120655),
(120687,120687),
(120713,120713),
(120745,120745),
(120771,120771),
(126704,126705)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks25:array[0..16] of TPUCUUnicodeCharRange=(
(36,36),
(162,165),
(1423,1423),
(1547,1547),
(2546,2547),
(2555,2555),
(2801,2801),
(3065,3065),
(3647,3647),
(6107,6107),
(8352,8382),
(43064,43064),
(65020,65020),
(65129,65129),
(65284,65284),
(65504,65505),
(65509,65510)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks26:array[0..28] of TPUCUUnicodeCharRange=(
(94,94),
(96,96),
(168,168),
(175,175),
(180,180),
(184,184),
(706,709),
(722,735),
(741,747),
(749,749),
(751,767),
(885,885),
(900,901),
(8125,8125),
(8127,8129),
(8141,8143),
(8157,8159),
(8173,8175),
(8189,8190),
(12443,12444),
(42752,42774),
(42784,42785),
(42889,42890),
(43867,43867),
(64434,64449),
(65342,65342),
(65344,65344),
(65507,65507),
(127995,127999)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks27:array[0..173] of TPUCUUnicodeCharRange=(
(166,166),
(169,169),
(174,174),
(176,176),
(1154,1154),
(1421,1422),
(1550,1551),
(1758,1758),
(1769,1769),
(1789,1790),
(2038,2038),
(2554,2554),
(2928,2928),
(3059,3064),
(3066,3066),
(3199,3199),
(3407,3407),
(3449,3449),
(3841,3843),
(3859,3859),
(3861,3863),
(3866,3871),
(3892,3892),
(3894,3894),
(3896,3896),
(4030,4037),
(4039,4044),
(4046,4047),
(4053,4056),
(4254,4255),
(5008,5017),
(6464,6464),
(6622,6655),
(7009,7018),
(7028,7036),
(8448,8449),
(8451,8454),
(8456,8457),
(8468,8468),
(8470,8471),
(8478,8483),
(8485,8485),
(8487,8487),
(8489,8489),
(8494,8494),
(8506,8507),
(8522,8522),
(8524,8525),
(8527,8527),
(8586,8587),
(8597,8601),
(8604,8607),
(8609,8610),
(8612,8613),
(8615,8621),
(8623,8653),
(8656,8657),
(8659,8659),
(8661,8691),
(8960,8967),
(8972,8991),
(8994,9000),
(9003,9083),
(9085,9114),
(9140,9179),
(9186,9214),
(9216,9254),
(9280,9290),
(9372,9449),
(9472,9654),
(9656,9664),
(9666,9719),
(9728,9838),
(9840,10087),
(10132,10175),
(10240,10495),
(11008,11055),
(11077,11078),
(11085,11123),
(11126,11157),
(11160,11193),
(11197,11208),
(11210,11217),
(11244,11247),
(11493,11498),
(11904,11929),
(11931,12019),
(12032,12245),
(12272,12283),
(12292,12292),
(12306,12307),
(12320,12320),
(12342,12343),
(12350,12351),
(12688,12689),
(12694,12703),
(12736,12771),
(12800,12830),
(12842,12871),
(12880,12880),
(12896,12927),
(12938,12976),
(12992,13054),
(13056,13311),
(19904,19967),
(42128,42182),
(43048,43051),
(43062,43063),
(43065,43065),
(43639,43641),
(65021,65021),
(65508,65508),
(65512,65512),
(65517,65518),
(65532,65533),
(65847,65855),
(65913,65929),
(65932,65934),
(65936,65947),
(65952,65952),
(66000,66044),
(67703,67704),
(68296,68296),
(71487,71487),
(92988,92991),
(92997,92997),
(113820,113820),
(118784,119029),
(119040,119078),
(119081,119140),
(119146,119148),
(119171,119172),
(119180,119209),
(119214,119272),
(119296,119361),
(119365,119365),
(119552,119638),
(120832,121343),
(121399,121402),
(121453,121460),
(121462,121475),
(121477,121478),
(126976,127019),
(127024,127123),
(127136,127150),
(127153,127167),
(127169,127183),
(127185,127221),
(127248,127278),
(127280,127339),
(127344,127404),
(127462,127490),
(127504,127547),
(127552,127560),
(127568,127569),
(127744,127994),
(128000,128722),
(128736,128748),
(128752,128758),
(128768,128883),
(128896,128980),
(129024,129035),
(129040,129095),
(129104,129113),
(129120,129159),
(129168,129197),
(129296,129310),
(129312,129319),
(129328,129328),
(129331,129342),
(129344,129355),
(129360,129374),
(129408,129425),
(129472,129472)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks28:array[0..10] of TPUCUUnicodeCharRange=(
(171,171),
(8216,8216),
(8219,8220),
(8223,8223),
(8249,8249),
(11778,11778),
(11780,11780),
(11785,11785),
(11788,11788),
(11804,11804),
(11808,11808)
);

const PUCUUnicodeIgnoreCaseCategoryBlocks29:array[0..9] of TPUCUUnicodeCharRange=(
(187,187),
(8217,8217),
(8221,8221),
(8250,8250),
(11779,11779),
(11781,11781),
(11786,11786),
(11789,11789),
(11805,11805),
(11809,11809)
);

const PUCUUnicodeIgnoreCaseCategoryBlocksData:array[0..29] of pointer=(
@PUCUUnicodeIgnoreCaseCategoryBlocks0,
@PUCUUnicodeIgnoreCaseCategoryBlocks1,
@PUCUUnicodeIgnoreCaseCategoryBlocks2,
@PUCUUnicodeIgnoreCaseCategoryBlocks3,
@PUCUUnicodeIgnoreCaseCategoryBlocks4,
@PUCUUnicodeIgnoreCaseCategoryBlocks5,
@PUCUUnicodeIgnoreCaseCategoryBlocks6,
@PUCUUnicodeIgnoreCaseCategoryBlocks7,
@PUCUUnicodeIgnoreCaseCategoryBlocks8,
@PUCUUnicodeIgnoreCaseCategoryBlocks9,
@PUCUUnicodeIgnoreCaseCategoryBlocks10,
@PUCUUnicodeIgnoreCaseCategoryBlocks11,
@PUCUUnicodeIgnoreCaseCategoryBlocks12,
@PUCUUnicodeIgnoreCaseCategoryBlocks13,
@PUCUUnicodeIgnoreCaseCategoryBlocks14,
@PUCUUnicodeIgnoreCaseCategoryBlocks15,
@PUCUUnicodeIgnoreCaseCategoryBlocks16,
@PUCUUnicodeIgnoreCaseCategoryBlocks17,
@PUCUUnicodeIgnoreCaseCategoryBlocks18,
@PUCUUnicodeIgnoreCaseCategoryBlocks19,
@PUCUUnicodeIgnoreCaseCategoryBlocks20,
@PUCUUnicodeIgnoreCaseCategoryBlocks21,
@PUCUUnicodeIgnoreCaseCategoryBlocks22,
@PUCUUnicodeIgnoreCaseCategoryBlocks23,
@PUCUUnicodeIgnoreCaseCategoryBlocks24,
@PUCUUnicodeIgnoreCaseCategoryBlocks25,
@PUCUUnicodeIgnoreCaseCategoryBlocks26,
@PUCUUnicodeIgnoreCaseCategoryBlocks27,
@PUCUUnicodeIgnoreCaseCategoryBlocks28,
@PUCUUnicodeIgnoreCaseCategoryBlocks29
);

const PUCUUnicodeIgnoreCaseCategoryBlocksCounts:array[0..29] of longint=(
638,
165,
128,
9,
57,
445,
286,
5,
155,
54,
12,
60,
7,
1,
1,
2,
18,
3,
1,
17,
75,
72,
6,
165,
64,
17,
29,
174,
11,
10
);

const PUCUCountUnicodeScriptBlocks=137;

const PUCUUnicodeScriptBlocks0:array[0..635] of TPUCUUnicodeCharRange=(
(888,889),
(896,899),
(907,907),
(909,909),
(930,930),
(1328,1328),
(1367,1368),
(1376,1376),
(1416,1416),
(1419,1420),
(1424,1424),
(1480,1487),
(1515,1519),
(1525,1535),
(1565,1565),
(1806,1806),
(1867,1868),
(1970,1983),
(2043,2047),
(2094,2095),
(2111,2111),
(2140,2141),
(2143,2207),
(2229,2229),
(2238,2259),
(2436,2436),
(2445,2446),
(2449,2450),
(2473,2473),
(2481,2481),
(2483,2485),
(2490,2491),
(2501,2502),
(2505,2506),
(2511,2518),
(2520,2523),
(2526,2526),
(2532,2533),
(2556,2560),
(2564,2564),
(2571,2574),
(2577,2578),
(2601,2601),
(2609,2609),
(2612,2612),
(2615,2615),
(2618,2619),
(2621,2621),
(2627,2630),
(2633,2634),
(2638,2640),
(2642,2648),
(2653,2653),
(2655,2661),
(2678,2688),
(2692,2692),
(2702,2702),
(2706,2706),
(2729,2729),
(2737,2737),
(2740,2740),
(2746,2747),
(2758,2758),
(2762,2762),
(2766,2767),
(2769,2783),
(2788,2789),
(2802,2808),
(2810,2816),
(2820,2820),
(2829,2830),
(2833,2834),
(2857,2857),
(2865,2865),
(2868,2868),
(2874,2875),
(2885,2886),
(2889,2890),
(2894,2901),
(2904,2907),
(2910,2910),
(2916,2917),
(2936,2945),
(2948,2948),
(2955,2957),
(2961,2961),
(2966,2968),
(2971,2971),
(2973,2973),
(2976,2978),
(2981,2983),
(2987,2989),
(3002,3005),
(3011,3013),
(3017,3017),
(3022,3023),
(3025,3030),
(3032,3045),
(3067,3071),
(3076,3076),
(3085,3085),
(3089,3089),
(3113,3113),
(3130,3132),
(3141,3141),
(3145,3145),
(3150,3156),
(3159,3159),
(3163,3167),
(3172,3173),
(3184,3191),
(3204,3204),
(3213,3213),
(3217,3217),
(3241,3241),
(3252,3252),
(3258,3259),
(3269,3269),
(3273,3273),
(3278,3284),
(3287,3293),
(3295,3295),
(3300,3301),
(3312,3312),
(3315,3328),
(3332,3332),
(3341,3341),
(3345,3345),
(3387,3388),
(3397,3397),
(3401,3401),
(3408,3411),
(3428,3429),
(3456,3457),
(3460,3460),
(3479,3481),
(3506,3506),
(3516,3516),
(3518,3519),
(3527,3529),
(3531,3534),
(3541,3541),
(3543,3543),
(3552,3557),
(3568,3569),
(3573,3584),
(3643,3646),
(3676,3712),
(3715,3715),
(3717,3718),
(3721,3721),
(3723,3724),
(3726,3731),
(3736,3736),
(3744,3744),
(3748,3748),
(3750,3750),
(3752,3753),
(3756,3756),
(3770,3770),
(3774,3775),
(3781,3781),
(3783,3783),
(3790,3791),
(3802,3803),
(3808,3839),
(3912,3912),
(3949,3952),
(3992,3992),
(4029,4029),
(4045,4045),
(4059,4095),
(4294,4294),
(4296,4300),
(4302,4303),
(4681,4681),
(4686,4687),
(4695,4695),
(4697,4697),
(4702,4703),
(4745,4745),
(4750,4751),
(4785,4785),
(4790,4791),
(4799,4799),
(4801,4801),
(4806,4807),
(4823,4823),
(4881,4881),
(4886,4887),
(4955,4956),
(4989,4991),
(5018,5023),
(5110,5111),
(5118,5119),
(5789,5791),
(5881,5887),
(5901,5901),
(5909,5919),
(5943,5951),
(5972,5983),
(5997,5997),
(6001,6001),
(6004,6015),
(6110,6111),
(6122,6127),
(6138,6143),
(6159,6159),
(6170,6175),
(6264,6271),
(6315,6319),
(6390,6399),
(6431,6431),
(6444,6447),
(6460,6463),
(6465,6467),
(6510,6511),
(6517,6527),
(6572,6575),
(6602,6607),
(6619,6621),
(6684,6685),
(6751,6751),
(6781,6782),
(6794,6799),
(6810,6815),
(6830,6831),
(6847,6911),
(6988,6991),
(7037,7039),
(7156,7163),
(7224,7226),
(7242,7244),
(7305,7359),
(7368,7375),
(7415,7415),
(7418,7423),
(7670,7674),
(7958,7959),
(7966,7967),
(8006,8007),
(8014,8015),
(8024,8024),
(8026,8026),
(8028,8028),
(8030,8030),
(8062,8063),
(8117,8117),
(8133,8133),
(8148,8149),
(8156,8156),
(8176,8177),
(8181,8181),
(8191,8191),
(8293,8293),
(8306,8307),
(8335,8335),
(8349,8351),
(8383,8399),
(8433,8447),
(8588,8591),
(9215,9215),
(9255,9279),
(9291,9311),
(11124,11125),
(11158,11159),
(11194,11196),
(11209,11209),
(11218,11243),
(11248,11263),
(11311,11311),
(11359,11359),
(11508,11512),
(11558,11558),
(11560,11564),
(11566,11567),
(11624,11630),
(11633,11646),
(11671,11679),
(11687,11687),
(11695,11695),
(11703,11703),
(11711,11711),
(11719,11719),
(11727,11727),
(11735,11735),
(11743,11743),
(11845,11903),
(11930,11930),
(12020,12031),
(12246,12271),
(12284,12287),
(12352,12352),
(12439,12440),
(12544,12548),
(12590,12592),
(12687,12687),
(12731,12735),
(12772,12783),
(12831,12831),
(13055,13055),
(19894,19903),
(40918,40959),
(42125,42127),
(42183,42191),
(42540,42559),
(42744,42751),
(42927,42927),
(42936,42998),
(43052,43055),
(43066,43071),
(43128,43135),
(43206,43213),
(43226,43231),
(43262,43263),
(43348,43358),
(43389,43391),
(43470,43470),
(43482,43485),
(43519,43519),
(43575,43583),
(43598,43599),
(43610,43611),
(43715,43738),
(43767,43776),
(43783,43784),
(43791,43792),
(43799,43807),
(43815,43815),
(43823,43823),
(43878,43887),
(44014,44015),
(44026,44031),
(55204,55215),
(55239,55242),
(55292,63743),
(64110,64111),
(64218,64255),
(64263,64274),
(64280,64284),
(64311,64311),
(64317,64317),
(64319,64319),
(64322,64322),
(64325,64325),
(64450,64466),
(64832,64847),
(64912,64913),
(64968,65007),
(65022,65023),
(65050,65055),
(65107,65107),
(65127,65127),
(65132,65135),
(65141,65141),
(65277,65278),
(65280,65280),
(65471,65473),
(65480,65481),
(65488,65489),
(65496,65497),
(65501,65503),
(65511,65511),
(65519,65528),
(65534,65535),
(65548,65548),
(65575,65575),
(65595,65595),
(65598,65598),
(65614,65615),
(65630,65663),
(65787,65791),
(65795,65798),
(65844,65846),
(65935,65935),
(65948,65951),
(65953,65999),
(66046,66175),
(66205,66207),
(66257,66271),
(66300,66303),
(66340,66351),
(66379,66383),
(66427,66431),
(66462,66462),
(66500,66503),
(66518,66559),
(66718,66719),
(66730,66735),
(66772,66775),
(66812,66815),
(66856,66863),
(66916,66926),
(66928,67071),
(67383,67391),
(67414,67423),
(67432,67583),
(67590,67591),
(67593,67593),
(67638,67638),
(67641,67643),
(67645,67646),
(67670,67670),
(67743,67750),
(67760,67807),
(67827,67827),
(67830,67834),
(67868,67870),
(67898,67902),
(67904,67967),
(68024,68027),
(68048,68049),
(68100,68100),
(68103,68107),
(68116,68116),
(68120,68120),
(68148,68151),
(68155,68158),
(68168,68175),
(68185,68191),
(68256,68287),
(68327,68330),
(68343,68351),
(68406,68408),
(68438,68439),
(68467,68471),
(68498,68504),
(68509,68520),
(68528,68607),
(68681,68735),
(68787,68799),
(68851,68857),
(68864,69215),
(69247,69631),
(69710,69713),
(69744,69758),
(69826,69839),
(69865,69871),
(69882,69887),
(69941,69941),
(69956,69967),
(70007,70015),
(70094,70095),
(70112,70112),
(70133,70143),
(70162,70162),
(70207,70271),
(70279,70279),
(70281,70281),
(70286,70286),
(70302,70302),
(70314,70319),
(70379,70383),
(70394,70399),
(70404,70404),
(70413,70414),
(70417,70418),
(70441,70441),
(70449,70449),
(70452,70452),
(70458,70459),
(70469,70470),
(70473,70474),
(70478,70479),
(70481,70486),
(70488,70492),
(70500,70501),
(70509,70511),
(70517,70655),
(70746,70746),
(70748,70748),
(70750,70783),
(70856,70863),
(70874,71039),
(71094,71095),
(71134,71167),
(71237,71247),
(71258,71263),
(71277,71295),
(71352,71359),
(71370,71423),
(71450,71452),
(71468,71471),
(71488,71839),
(71923,71934),
(71936,72383),
(72441,72703),
(72713,72713),
(72759,72759),
(72774,72783),
(72813,72815),
(72848,72849),
(72872,72872),
(72887,73727),
(74650,74751),
(74863,74863),
(74869,74879),
(75076,77823),
(78895,82943),
(83527,92159),
(92729,92735),
(92767,92767),
(92778,92781),
(92784,92879),
(92910,92911),
(92918,92927),
(92998,93007),
(93018,93018),
(93026,93026),
(93048,93052),
(93072,93951),
(94021,94031),
(94079,94094),
(94112,94175),
(94177,94207),
(100333,100351),
(101107,110591),
(110594,113663),
(113771,113775),
(113789,113791),
(113801,113807),
(113818,113819),
(113828,118783),
(119030,119039),
(119079,119080),
(119273,119295),
(119366,119551),
(119639,119647),
(119666,119807),
(119893,119893),
(119965,119965),
(119968,119969),
(119971,119972),
(119975,119976),
(119981,119981),
(119994,119994),
(119996,119996),
(120004,120004),
(120070,120070),
(120075,120076),
(120085,120085),
(120093,120093),
(120122,120122),
(120127,120127),
(120133,120133),
(120135,120137),
(120145,120145),
(120486,120487),
(120780,120781),
(121484,121498),
(121504,121504),
(121520,122879),
(122887,122887),
(122905,122906),
(122914,122914),
(122917,122917),
(122923,124927),
(125125,125126),
(125143,125183),
(125259,125263),
(125274,125277),
(125280,126463),
(126468,126468),
(126496,126496),
(126499,126499),
(126501,126502),
(126504,126504),
(126515,126515),
(126520,126520),
(126522,126522),
(126524,126529),
(126531,126534),
(126536,126536),
(126538,126538),
(126540,126540),
(126544,126544),
(126547,126547),
(126549,126550),
(126552,126552),
(126554,126554),
(126556,126556),
(126558,126558),
(126560,126560),
(126563,126563),
(126565,126566),
(126571,126571),
(126579,126579),
(126584,126584),
(126589,126589),
(126591,126591),
(126602,126602),
(126620,126624),
(126628,126628),
(126634,126634),
(126652,126703),
(126706,126975),
(127020,127023),
(127124,127135),
(127151,127152),
(127168,127168),
(127184,127184),
(127222,127231),
(127245,127247),
(127279,127279),
(127340,127343),
(127405,127461),
(127491,127503),
(127548,127551),
(127561,127567),
(127570,127743),
(128723,128735),
(128749,128751),
(128759,128767),
(128884,128895),
(128981,129023),
(129036,129039),
(129096,129103),
(129114,129119),
(129160,129167),
(129198,129295),
(129311,129311),
(129320,129327),
(129329,129330),
(129343,129343),
(129356,129359),
(129375,129407),
(129426,129471),
(129473,131071),
(173783,173823),
(177973,177983),
(178206,178207),
(183970,194559),
(195102,917504),
(917506,917535),
(917632,917759),
(918000,1114111)
);

const PUCUUnicodeScriptBlocks1:array[0..164] of TPUCUUnicodeCharRange=(
(0,64),
(91,96),
(123,169),
(171,185),
(187,191),
(215,215),
(247,247),
(697,735),
(741,745),
(748,767),
(884,884),
(894,894),
(901,901),
(903,903),
(1417,1417),
(1541,1541),
(1548,1548),
(1563,1564),
(1567,1567),
(1600,1600),
(1757,1757),
(2274,2274),
(2404,2405),
(3647,3647),
(4053,4056),
(4347,4347),
(5867,5869),
(5941,5942),
(6146,6147),
(6149,6149),
(7379,7379),
(7393,7393),
(7401,7404),
(7406,7411),
(7413,7414),
(8192,8203),
(8206,8292),
(8294,8304),
(8308,8318),
(8320,8334),
(8352,8382),
(8448,8485),
(8487,8489),
(8492,8497),
(8499,8525),
(8527,8543),
(8585,8587),
(8592,9214),
(9216,9254),
(9280,9290),
(9312,10239),
(10496,11123),
(11126,11157),
(11160,11193),
(11197,11208),
(11210,11217),
(11244,11247),
(11776,11844),
(12272,12283),
(12288,12292),
(12294,12294),
(12296,12320),
(12336,12343),
(12348,12351),
(12443,12444),
(12448,12448),
(12539,12540),
(12688,12703),
(12736,12771),
(12832,12895),
(12927,13007),
(13144,13311),
(19904,19967),
(42752,42785),
(42888,42890),
(43056,43065),
(43310,43310),
(43471,43471),
(43867,43867),
(64830,64831),
(65040,65049),
(65072,65106),
(65108,65126),
(65128,65131),
(65279,65279),
(65281,65312),
(65339,65344),
(65371,65381),
(65392,65392),
(65438,65439),
(65504,65510),
(65512,65518),
(65529,65533),
(65792,65794),
(65799,65843),
(65847,65855),
(65936,65947),
(66000,66044),
(66273,66299),
(113824,113827),
(118784,119029),
(119040,119078),
(119081,119142),
(119146,119162),
(119171,119172),
(119180,119209),
(119214,119272),
(119552,119638),
(119648,119665),
(119808,119892),
(119894,119964),
(119966,119967),
(119970,119970),
(119973,119974),
(119977,119980),
(119982,119993),
(119995,119995),
(119997,120003),
(120005,120069),
(120071,120074),
(120077,120084),
(120086,120092),
(120094,120121),
(120123,120126),
(120128,120132),
(120134,120134),
(120138,120144),
(120146,120485),
(120488,120779),
(120782,120831),
(126976,127019),
(127024,127123),
(127136,127150),
(127153,127167),
(127169,127183),
(127185,127221),
(127232,127244),
(127248,127278),
(127280,127339),
(127344,127404),
(127462,127487),
(127489,127490),
(127504,127547),
(127552,127560),
(127568,127569),
(127744,128722),
(128736,128748),
(128752,128758),
(128768,128883),
(128896,128980),
(129024,129035),
(129040,129095),
(129104,129113),
(129120,129159),
(129168,129197),
(129296,129310),
(129312,129319),
(129328,129328),
(129331,129342),
(129344,129355),
(129360,129374),
(129408,129425),
(129472,129472),
(917505,917505),
(917536,917631)
);

const PUCUUnicodeScriptBlocks2:array[0..30] of TPUCUUnicodeCharRange=(
(65,90),
(97,122),
(170,170),
(186,186),
(192,214),
(216,246),
(248,696),
(736,740),
(7424,7461),
(7468,7516),
(7522,7525),
(7531,7543),
(7545,7614),
(7680,7935),
(8305,8305),
(8319,8319),
(8336,8348),
(8490,8491),
(8498,8498),
(8526,8526),
(8544,8584),
(11360,11391),
(42786,42887),
(42891,42926),
(42928,42935),
(42999,43007),
(43824,43866),
(43868,43876),
(64256,64262),
(65313,65338),
(65345,65370)
);

const PUCUUnicodeScriptBlocks3:array[0..35] of TPUCUUnicodeCharRange=(
(880,883),
(885,887),
(890,893),
(895,895),
(900,900),
(902,902),
(904,906),
(908,908),
(910,929),
(931,993),
(1008,1023),
(7462,7466),
(7517,7521),
(7526,7530),
(7615,7615),
(7936,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8016,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8064,8116),
(8118,8132),
(8134,8147),
(8150,8155),
(8157,8175),
(8178,8180),
(8182,8190),
(8486,8486),
(43877,43877),
(65856,65934),
(65952,65952),
(119296,119365)
);

const PUCUUnicodeScriptBlocks4:array[0..7] of TPUCUUnicodeCharRange=(
(1024,1156),
(1159,1327),
(7296,7304),
(7467,7467),
(7544,7544),
(11744,11775),
(42560,42655),
(65070,65071)
);

const PUCUUnicodeScriptBlocks5:array[0..5] of TPUCUUnicodeCharRange=(
(1329,1366),
(1369,1375),
(1377,1415),
(1418,1418),
(1421,1423),
(64275,64279)
);

const PUCUUnicodeScriptBlocks6:array[0..8] of TPUCUUnicodeCharRange=(
(1425,1479),
(1488,1514),
(1520,1524),
(64285,64310),
(64312,64316),
(64318,64318),
(64320,64321),
(64323,64324),
(64326,64335)
);

const PUCUUnicodeScriptBlocks7:array[0..55] of TPUCUUnicodeCharRange=(
(1536,1540),
(1542,1547),
(1549,1562),
(1566,1566),
(1568,1599),
(1601,1610),
(1622,1647),
(1649,1756),
(1758,1791),
(1872,1919),
(2208,2228),
(2230,2237),
(2260,2273),
(2275,2303),
(64336,64449),
(64467,64829),
(64848,64911),
(64914,64967),
(65008,65021),
(65136,65140),
(65142,65276),
(69216,69246),
(126464,126467),
(126469,126495),
(126497,126498),
(126500,126500),
(126503,126503),
(126505,126514),
(126516,126519),
(126521,126521),
(126523,126523),
(126530,126530),
(126535,126535),
(126537,126537),
(126539,126539),
(126541,126543),
(126545,126546),
(126548,126548),
(126551,126551),
(126553,126553),
(126555,126555),
(126557,126557),
(126559,126559),
(126561,126562),
(126564,126564),
(126567,126570),
(126572,126578),
(126580,126583),
(126585,126588),
(126590,126590),
(126592,126601),
(126603,126619),
(126625,126627),
(126629,126633),
(126635,126651),
(126704,126705)
);

const PUCUUnicodeScriptBlocks8:array[0..2] of TPUCUUnicodeCharRange=(
(1792,1805),
(1807,1866),
(1869,1871)
);

const PUCUUnicodeScriptBlocks9:array[0..0] of TPUCUUnicodeCharRange=(
(1920,1969)
);

const PUCUUnicodeScriptBlocks10:array[0..3] of TPUCUUnicodeCharRange=(
(2304,2384),
(2387,2403),
(2406,2431),
(43232,43261)
);

const PUCUUnicodeScriptBlocks11:array[0..13] of TPUCUUnicodeCharRange=(
(2432,2435),
(2437,2444),
(2447,2448),
(2451,2472),
(2474,2480),
(2482,2482),
(2486,2489),
(2492,2500),
(2503,2504),
(2507,2510),
(2519,2519),
(2524,2525),
(2527,2531),
(2534,2555)
);

const PUCUUnicodeScriptBlocks12:array[0..15] of TPUCUUnicodeCharRange=(
(2561,2563),
(2565,2570),
(2575,2576),
(2579,2600),
(2602,2608),
(2610,2611),
(2613,2614),
(2616,2617),
(2620,2620),
(2622,2626),
(2631,2632),
(2635,2637),
(2641,2641),
(2649,2652),
(2654,2654),
(2662,2677)
);

const PUCUUnicodeScriptBlocks13:array[0..13] of TPUCUUnicodeCharRange=(
(2689,2691),
(2693,2701),
(2703,2705),
(2707,2728),
(2730,2736),
(2738,2739),
(2741,2745),
(2748,2757),
(2759,2761),
(2763,2765),
(2768,2768),
(2784,2787),
(2790,2801),
(2809,2809)
);

const PUCUUnicodeScriptBlocks14:array[0..13] of TPUCUUnicodeCharRange=(
(2817,2819),
(2821,2828),
(2831,2832),
(2835,2856),
(2858,2864),
(2866,2867),
(2869,2873),
(2876,2884),
(2887,2888),
(2891,2893),
(2902,2903),
(2908,2909),
(2911,2915),
(2918,2935)
);

const PUCUUnicodeScriptBlocks15:array[0..15] of TPUCUUnicodeCharRange=(
(2946,2947),
(2949,2954),
(2958,2960),
(2962,2965),
(2969,2970),
(2972,2972),
(2974,2975),
(2979,2980),
(2984,2986),
(2990,3001),
(3006,3010),
(3014,3016),
(3018,3021),
(3024,3024),
(3031,3031),
(3046,3066)
);

const PUCUUnicodeScriptBlocks16:array[0..12] of TPUCUUnicodeCharRange=(
(3072,3075),
(3077,3084),
(3086,3088),
(3090,3112),
(3114,3129),
(3133,3140),
(3142,3144),
(3146,3149),
(3157,3158),
(3160,3162),
(3168,3171),
(3174,3183),
(3192,3199)
);

const PUCUUnicodeScriptBlocks17:array[0..13] of TPUCUUnicodeCharRange=(
(3200,3203),
(3205,3212),
(3214,3216),
(3218,3240),
(3242,3251),
(3253,3257),
(3260,3268),
(3270,3272),
(3274,3277),
(3285,3286),
(3294,3294),
(3296,3299),
(3302,3311),
(3313,3314)
);

const PUCUUnicodeScriptBlocks18:array[0..8] of TPUCUUnicodeCharRange=(
(3329,3331),
(3333,3340),
(3342,3344),
(3346,3386),
(3389,3396),
(3398,3400),
(3402,3407),
(3412,3427),
(3430,3455)
);

const PUCUUnicodeScriptBlocks19:array[0..12] of TPUCUUnicodeCharRange=(
(3458,3459),
(3461,3478),
(3482,3505),
(3507,3515),
(3517,3517),
(3520,3526),
(3530,3530),
(3535,3540),
(3542,3542),
(3544,3551),
(3558,3567),
(3570,3572),
(70113,70132)
);

const PUCUUnicodeScriptBlocks20:array[0..1] of TPUCUUnicodeCharRange=(
(3585,3642),
(3648,3675)
);

const PUCUUnicodeScriptBlocks21:array[0..17] of TPUCUUnicodeCharRange=(
(3713,3714),
(3716,3716),
(3719,3720),
(3722,3722),
(3725,3725),
(3732,3735),
(3737,3743),
(3745,3747),
(3749,3749),
(3751,3751),
(3754,3755),
(3757,3769),
(3771,3773),
(3776,3780),
(3782,3782),
(3784,3789),
(3792,3801),
(3804,3807)
);

const PUCUUnicodeScriptBlocks22:array[0..6] of TPUCUUnicodeCharRange=(
(3840,3911),
(3913,3948),
(3953,3991),
(3993,4028),
(4030,4044),
(4046,4052),
(4057,4058)
);

const PUCUUnicodeScriptBlocks23:array[0..2] of TPUCUUnicodeCharRange=(
(4096,4255),
(43488,43518),
(43616,43647)
);

const PUCUUnicodeScriptBlocks24:array[0..7] of TPUCUUnicodeCharRange=(
(4256,4293),
(4295,4295),
(4301,4301),
(4304,4346),
(4348,4351),
(11520,11557),
(11559,11559),
(11565,11565)
);

const PUCUUnicodeScriptBlocks25:array[0..13] of TPUCUUnicodeCharRange=(
(4352,4607),
(12334,12335),
(12593,12686),
(12800,12830),
(12896,12926),
(43360,43388),
(44032,55203),
(55216,55238),
(55243,55291),
(65440,65470),
(65474,65479),
(65482,65487),
(65490,65495),
(65498,65500)
);

const PUCUUnicodeScriptBlocks26:array[0..31] of TPUCUUnicodeCharRange=(
(4608,4680),
(4682,4685),
(4688,4694),
(4696,4696),
(4698,4701),
(4704,4744),
(4746,4749),
(4752,4784),
(4786,4789),
(4792,4798),
(4800,4800),
(4802,4805),
(4808,4822),
(4824,4880),
(4882,4885),
(4888,4954),
(4957,4988),
(4992,5017),
(11648,11670),
(11680,11686),
(11688,11694),
(11696,11702),
(11704,11710),
(11712,11718),
(11720,11726),
(11728,11734),
(11736,11742),
(43777,43782),
(43785,43790),
(43793,43798),
(43808,43814),
(43816,43822)
);

const PUCUUnicodeScriptBlocks27:array[0..2] of TPUCUUnicodeCharRange=(
(5024,5109),
(5112,5117),
(43888,43967)
);

const PUCUUnicodeScriptBlocks28:array[0..1] of TPUCUUnicodeCharRange=(
(5120,5759),
(6320,6389)
);

const PUCUUnicodeScriptBlocks29:array[0..0] of TPUCUUnicodeCharRange=(
(5760,5788)
);

const PUCUUnicodeScriptBlocks30:array[0..1] of TPUCUUnicodeCharRange=(
(5792,5866),
(5870,5880)
);

const PUCUUnicodeScriptBlocks31:array[0..3] of TPUCUUnicodeCharRange=(
(6016,6109),
(6112,6121),
(6128,6137),
(6624,6655)
);

const PUCUUnicodeScriptBlocks32:array[0..6] of TPUCUUnicodeCharRange=(
(6144,6145),
(6148,6148),
(6150,6158),
(6160,6169),
(6176,6263),
(6272,6314),
(71264,71276)
);

const PUCUUnicodeScriptBlocks33:array[0..3] of TPUCUUnicodeCharRange=(
(12353,12438),
(12445,12447),
(110593,110593),
(127488,127488)
);

const PUCUUnicodeScriptBlocks34:array[0..7] of TPUCUUnicodeCharRange=(
(12449,12538),
(12541,12543),
(12784,12799),
(13008,13054),
(13056,13143),
(65382,65391),
(65393,65437),
(110592,110592)
);

const PUCUUnicodeScriptBlocks35:array[0..2] of TPUCUUnicodeCharRange=(
(746,747),
(12549,12589),
(12704,12730)
);

const PUCUUnicodeScriptBlocks36:array[0..15] of TPUCUUnicodeCharRange=(
(11904,11929),
(11931,12019),
(12032,12245),
(12293,12293),
(12295,12295),
(12321,12329),
(12344,12347),
(13312,19893),
(19968,40917),
(63744,64109),
(64112,64217),
(131072,173782),
(173824,177972),
(177984,178205),
(178208,183969),
(194560,195101)
);

const PUCUUnicodeScriptBlocks37:array[0..1] of TPUCUUnicodeCharRange=(
(40960,42124),
(42128,42182)
);

const PUCUUnicodeScriptBlocks38:array[0..0] of TPUCUUnicodeCharRange=(
(66304,66339)
);

const PUCUUnicodeScriptBlocks39:array[0..0] of TPUCUUnicodeCharRange=(
(66352,66378)
);

const PUCUUnicodeScriptBlocks40:array[0..0] of TPUCUUnicodeCharRange=(
(66560,66639)
);

const PUCUUnicodeScriptBlocks41:array[0..26] of TPUCUUnicodeCharRange=(
(768,879),
(1157,1158),
(1611,1621),
(1648,1648),
(2385,2386),
(6832,6846),
(7376,7378),
(7380,7392),
(7394,7400),
(7405,7405),
(7412,7412),
(7416,7417),
(7616,7669),
(7675,7679),
(8204,8205),
(8400,8432),
(12330,12333),
(12441,12442),
(65024,65039),
(65056,65069),
(66045,66045),
(66272,66272),
(119143,119145),
(119163,119170),
(119173,119179),
(119210,119213),
(917760,917999)
);

const PUCUUnicodeScriptBlocks42:array[0..1] of TPUCUUnicodeCharRange=(
(5888,5900),
(5902,5908)
);

const PUCUUnicodeScriptBlocks43:array[0..0] of TPUCUUnicodeCharRange=(
(5920,5940)
);

const PUCUUnicodeScriptBlocks44:array[0..0] of TPUCUUnicodeCharRange=(
(5952,5971)
);

const PUCUUnicodeScriptBlocks45:array[0..2] of TPUCUUnicodeCharRange=(
(5984,5996),
(5998,6000),
(6002,6003)
);

const PUCUUnicodeScriptBlocks46:array[0..4] of TPUCUUnicodeCharRange=(
(6400,6430),
(6432,6443),
(6448,6459),
(6464,6464),
(6468,6479)
);

const PUCUUnicodeScriptBlocks47:array[0..1] of TPUCUUnicodeCharRange=(
(6480,6509),
(6512,6516)
);

const PUCUUnicodeScriptBlocks48:array[0..6] of TPUCUUnicodeCharRange=(
(65536,65547),
(65549,65574),
(65576,65594),
(65596,65597),
(65599,65613),
(65616,65629),
(65664,65786)
);

const PUCUUnicodeScriptBlocks49:array[0..1] of TPUCUUnicodeCharRange=(
(66432,66461),
(66463,66463)
);

const PUCUUnicodeScriptBlocks50:array[0..0] of TPUCUUnicodeCharRange=(
(66640,66687)
);

const PUCUUnicodeScriptBlocks51:array[0..1] of TPUCUUnicodeCharRange=(
(66688,66717),
(66720,66729)
);

const PUCUUnicodeScriptBlocks52:array[0..5] of TPUCUUnicodeCharRange=(
(67584,67589),
(67592,67592),
(67594,67637),
(67639,67640),
(67644,67644),
(67647,67647)
);

const PUCUUnicodeScriptBlocks53:array[0..0] of TPUCUUnicodeCharRange=(
(10240,10495)
);

const PUCUUnicodeScriptBlocks54:array[0..1] of TPUCUUnicodeCharRange=(
(6656,6683),
(6686,6687)
);

const PUCUUnicodeScriptBlocks55:array[0..2] of TPUCUUnicodeCharRange=(
(994,1007),
(11392,11507),
(11513,11519)
);

const PUCUUnicodeScriptBlocks56:array[0..3] of TPUCUUnicodeCharRange=(
(6528,6571),
(6576,6601),
(6608,6618),
(6622,6623)
);

const PUCUUnicodeScriptBlocks57:array[0..6] of TPUCUUnicodeCharRange=(
(11264,11310),
(11312,11358),
(122880,122886),
(122888,122904),
(122907,122913),
(122915,122916),
(122918,122922)
);

const PUCUUnicodeScriptBlocks58:array[0..2] of TPUCUUnicodeCharRange=(
(11568,11623),
(11631,11632),
(11647,11647)
);

const PUCUUnicodeScriptBlocks59:array[0..0] of TPUCUUnicodeCharRange=(
(43008,43051)
);

const PUCUUnicodeScriptBlocks60:array[0..1] of TPUCUUnicodeCharRange=(
(66464,66499),
(66504,66517)
);

const PUCUUnicodeScriptBlocks61:array[0..7] of TPUCUUnicodeCharRange=(
(68096,68099),
(68101,68102),
(68108,68115),
(68117,68119),
(68121,68147),
(68152,68154),
(68159,68167),
(68176,68184)
);

const PUCUUnicodeScriptBlocks62:array[0..1] of TPUCUUnicodeCharRange=(
(6912,6987),
(6992,7036)
);

const PUCUUnicodeScriptBlocks63:array[0..3] of TPUCUUnicodeCharRange=(
(73728,74649),
(74752,74862),
(74864,74868),
(74880,75075)
);

const PUCUUnicodeScriptBlocks64:array[0..1] of TPUCUUnicodeCharRange=(
(67840,67867),
(67871,67871)
);

const PUCUUnicodeScriptBlocks65:array[0..0] of TPUCUUnicodeCharRange=(
(43072,43127)
);

const PUCUUnicodeScriptBlocks66:array[0..0] of TPUCUUnicodeCharRange=(
(1984,2042)
);

const PUCUUnicodeScriptBlocks67:array[0..1] of TPUCUUnicodeCharRange=(
(7040,7103),
(7360,7367)
);

const PUCUUnicodeScriptBlocks68:array[0..2] of TPUCUUnicodeCharRange=(
(7168,7223),
(7227,7241),
(7245,7247)
);

const PUCUUnicodeScriptBlocks69:array[0..0] of TPUCUUnicodeCharRange=(
(7248,7295)
);

const PUCUUnicodeScriptBlocks70:array[0..0] of TPUCUUnicodeCharRange=(
(42240,42539)
);

const PUCUUnicodeScriptBlocks71:array[0..1] of TPUCUUnicodeCharRange=(
(43136,43205),
(43214,43225)
);

const PUCUUnicodeScriptBlocks72:array[0..1] of TPUCUUnicodeCharRange=(
(43264,43309),
(43311,43311)
);

const PUCUUnicodeScriptBlocks73:array[0..1] of TPUCUUnicodeCharRange=(
(43312,43347),
(43359,43359)
);

const PUCUUnicodeScriptBlocks74:array[0..0] of TPUCUUnicodeCharRange=(
(66176,66204)
);

const PUCUUnicodeScriptBlocks75:array[0..0] of TPUCUUnicodeCharRange=(
(66208,66256)
);

const PUCUUnicodeScriptBlocks76:array[0..1] of TPUCUUnicodeCharRange=(
(67872,67897),
(67903,67903)
);

const PUCUUnicodeScriptBlocks77:array[0..3] of TPUCUUnicodeCharRange=(
(43520,43574),
(43584,43597),
(43600,43609),
(43612,43615)
);

const PUCUUnicodeScriptBlocks78:array[0..4] of TPUCUUnicodeCharRange=(
(6688,6750),
(6752,6780),
(6783,6793),
(6800,6809),
(6816,6829)
);

const PUCUUnicodeScriptBlocks79:array[0..1] of TPUCUUnicodeCharRange=(
(43648,43714),
(43739,43743)
);

const PUCUUnicodeScriptBlocks80:array[0..1] of TPUCUUnicodeCharRange=(
(68352,68405),
(68409,68415)
);

const PUCUUnicodeScriptBlocks81:array[0..0] of TPUCUUnicodeCharRange=(
(77824,78894)
);

const PUCUUnicodeScriptBlocks82:array[0..1] of TPUCUUnicodeCharRange=(
(2048,2093),
(2096,2110)
);

const PUCUUnicodeScriptBlocks83:array[0..0] of TPUCUUnicodeCharRange=(
(42192,42239)
);

const PUCUUnicodeScriptBlocks84:array[0..1] of TPUCUUnicodeCharRange=(
(42656,42743),
(92160,92728)
);

const PUCUUnicodeScriptBlocks85:array[0..2] of TPUCUUnicodeCharRange=(
(43392,43469),
(43472,43481),
(43486,43487)
);

const PUCUUnicodeScriptBlocks86:array[0..2] of TPUCUUnicodeCharRange=(
(43744,43766),
(43968,44013),
(44016,44025)
);

const PUCUUnicodeScriptBlocks87:array[0..1] of TPUCUUnicodeCharRange=(
(67648,67669),
(67671,67679)
);

const PUCUUnicodeScriptBlocks88:array[0..0] of TPUCUUnicodeCharRange=(
(68192,68223)
);

const PUCUUnicodeScriptBlocks89:array[0..1] of TPUCUUnicodeCharRange=(
(68416,68437),
(68440,68447)
);

const PUCUUnicodeScriptBlocks90:array[0..1] of TPUCUUnicodeCharRange=(
(68448,68466),
(68472,68479)
);

const PUCUUnicodeScriptBlocks91:array[0..0] of TPUCUUnicodeCharRange=(
(68608,68680)
);

const PUCUUnicodeScriptBlocks92:array[0..0] of TPUCUUnicodeCharRange=(
(69760,69825)
);

const PUCUUnicodeScriptBlocks93:array[0..1] of TPUCUUnicodeCharRange=(
(7104,7155),
(7164,7167)
);

const PUCUUnicodeScriptBlocks94:array[0..2] of TPUCUUnicodeCharRange=(
(69632,69709),
(69714,69743),
(69759,69759)
);

const PUCUUnicodeScriptBlocks95:array[0..1] of TPUCUUnicodeCharRange=(
(2112,2139),
(2142,2142)
);

const PUCUUnicodeScriptBlocks96:array[0..1] of TPUCUUnicodeCharRange=(
(69888,69940),
(69942,69955)
);

const PUCUUnicodeScriptBlocks97:array[0..2] of TPUCUUnicodeCharRange=(
(68000,68023),
(68028,68047),
(68050,68095)
);

const PUCUUnicodeScriptBlocks98:array[0..0] of TPUCUUnicodeCharRange=(
(67968,67999)
);

const PUCUUnicodeScriptBlocks99:array[0..2] of TPUCUUnicodeCharRange=(
(93952,94020),
(94032,94078),
(94095,94111)
);

const PUCUUnicodeScriptBlocks100:array[0..1] of TPUCUUnicodeCharRange=(
(70016,70093),
(70096,70111)
);

const PUCUUnicodeScriptBlocks101:array[0..1] of TPUCUUnicodeCharRange=(
(69840,69864),
(69872,69881)
);

const PUCUUnicodeScriptBlocks102:array[0..1] of TPUCUUnicodeCharRange=(
(71296,71351),
(71360,71369)
);

const PUCUUnicodeScriptBlocks103:array[0..1] of TPUCUUnicodeCharRange=(
(66864,66915),
(66927,66927)
);

const PUCUUnicodeScriptBlocks104:array[0..1] of TPUCUUnicodeCharRange=(
(92880,92909),
(92912,92917)
);

const PUCUUnicodeScriptBlocks105:array[0..4] of TPUCUUnicodeCharRange=(
(113664,113770),
(113776,113788),
(113792,113800),
(113808,113817),
(113820,113823)
);

const PUCUUnicodeScriptBlocks106:array[0..0] of TPUCUUnicodeCharRange=(
(66816,66855)
);

const PUCUUnicodeScriptBlocks107:array[0..14] of TPUCUUnicodeCharRange=(
(70400,70403),
(70405,70412),
(70415,70416),
(70419,70440),
(70442,70448),
(70450,70451),
(70453,70457),
(70460,70468),
(70471,70472),
(70475,70477),
(70480,70480),
(70487,70487),
(70493,70499),
(70502,70508),
(70512,70516)
);

const PUCUUnicodeScriptBlocks108:array[0..4] of TPUCUUnicodeCharRange=(
(92928,92997),
(93008,93017),
(93019,93025),
(93027,93047),
(93053,93071)
);

const PUCUUnicodeScriptBlocks109:array[0..1] of TPUCUUnicodeCharRange=(
(70144,70161),
(70163,70206)
);

const PUCUUnicodeScriptBlocks110:array[0..2] of TPUCUUnicodeCharRange=(
(67072,67382),
(67392,67413),
(67424,67431)
);

const PUCUUnicodeScriptBlocks111:array[0..0] of TPUCUUnicodeCharRange=(
(69968,70006)
);

const PUCUUnicodeScriptBlocks112:array[0..1] of TPUCUUnicodeCharRange=(
(68288,68326),
(68331,68342)
);

const PUCUUnicodeScriptBlocks113:array[0..1] of TPUCUUnicodeCharRange=(
(124928,125124),
(125127,125142)
);

const PUCUUnicodeScriptBlocks114:array[0..1] of TPUCUUnicodeCharRange=(
(71168,71236),
(71248,71257)
);

const PUCUUnicodeScriptBlocks115:array[0..2] of TPUCUUnicodeCharRange=(
(92736,92766),
(92768,92777),
(92782,92783)
);

const PUCUUnicodeScriptBlocks116:array[0..0] of TPUCUUnicodeCharRange=(
(68224,68255)
);

const PUCUUnicodeScriptBlocks117:array[0..1] of TPUCUUnicodeCharRange=(
(67712,67742),
(67751,67759)
);

const PUCUUnicodeScriptBlocks118:array[0..0] of TPUCUUnicodeCharRange=(
(67680,67711)
);

const PUCUUnicodeScriptBlocks119:array[0..0] of TPUCUUnicodeCharRange=(
(72384,72440)
);

const PUCUUnicodeScriptBlocks120:array[0..0] of TPUCUUnicodeCharRange=(
(66384,66426)
);

const PUCUUnicodeScriptBlocks121:array[0..2] of TPUCUUnicodeCharRange=(
(68480,68497),
(68505,68508),
(68521,68527)
);

const PUCUUnicodeScriptBlocks122:array[0..1] of TPUCUUnicodeCharRange=(
(71040,71093),
(71096,71133)
);

const PUCUUnicodeScriptBlocks123:array[0..1] of TPUCUUnicodeCharRange=(
(70320,70378),
(70384,70393)
);

const PUCUUnicodeScriptBlocks124:array[0..1] of TPUCUUnicodeCharRange=(
(70784,70855),
(70864,70873)
);

const PUCUUnicodeScriptBlocks125:array[0..1] of TPUCUUnicodeCharRange=(
(71840,71922),
(71935,71935)
);

const PUCUUnicodeScriptBlocks126:array[0..2] of TPUCUUnicodeCharRange=(
(71424,71449),
(71453,71467),
(71472,71487)
);

const PUCUUnicodeScriptBlocks127:array[0..0] of TPUCUUnicodeCharRange=(
(82944,83526)
);

const PUCUUnicodeScriptBlocks128:array[0..2] of TPUCUUnicodeCharRange=(
(67808,67826),
(67828,67829),
(67835,67839)
);

const PUCUUnicodeScriptBlocks129:array[0..4] of TPUCUUnicodeCharRange=(
(70272,70278),
(70280,70280),
(70282,70285),
(70287,70301),
(70303,70313)
);

const PUCUUnicodeScriptBlocks130:array[0..2] of TPUCUUnicodeCharRange=(
(68736,68786),
(68800,68850),
(68858,68863)
);

const PUCUUnicodeScriptBlocks131:array[0..2] of TPUCUUnicodeCharRange=(
(120832,121483),
(121499,121503),
(121505,121519)
);

const PUCUUnicodeScriptBlocks132:array[0..2] of TPUCUUnicodeCharRange=(
(125184,125258),
(125264,125273),
(125278,125279)
);

const PUCUUnicodeScriptBlocks133:array[0..3] of TPUCUUnicodeCharRange=(
(72704,72712),
(72714,72758),
(72760,72773),
(72784,72812)
);

const PUCUUnicodeScriptBlocks134:array[0..2] of TPUCUUnicodeCharRange=(
(72816,72847),
(72850,72871),
(72873,72886)
);

const PUCUUnicodeScriptBlocks135:array[0..2] of TPUCUUnicodeCharRange=(
(70656,70745),
(70747,70747),
(70749,70749)
);

const PUCUUnicodeScriptBlocks136:array[0..1] of TPUCUUnicodeCharRange=(
(66736,66771),
(66776,66811)
);

const PUCUUnicodeScriptBlocks137:array[0..2] of TPUCUUnicodeCharRange=(
(94176,94176),
(94208,100332),
(100352,101106)
);

const PUCUUnicodeScriptBlocksData:array[0..137] of pointer=(
@PUCUUnicodeScriptBlocks0,
@PUCUUnicodeScriptBlocks1,
@PUCUUnicodeScriptBlocks2,
@PUCUUnicodeScriptBlocks3,
@PUCUUnicodeScriptBlocks4,
@PUCUUnicodeScriptBlocks5,
@PUCUUnicodeScriptBlocks6,
@PUCUUnicodeScriptBlocks7,
@PUCUUnicodeScriptBlocks8,
@PUCUUnicodeScriptBlocks9,
@PUCUUnicodeScriptBlocks10,
@PUCUUnicodeScriptBlocks11,
@PUCUUnicodeScriptBlocks12,
@PUCUUnicodeScriptBlocks13,
@PUCUUnicodeScriptBlocks14,
@PUCUUnicodeScriptBlocks15,
@PUCUUnicodeScriptBlocks16,
@PUCUUnicodeScriptBlocks17,
@PUCUUnicodeScriptBlocks18,
@PUCUUnicodeScriptBlocks19,
@PUCUUnicodeScriptBlocks20,
@PUCUUnicodeScriptBlocks21,
@PUCUUnicodeScriptBlocks22,
@PUCUUnicodeScriptBlocks23,
@PUCUUnicodeScriptBlocks24,
@PUCUUnicodeScriptBlocks25,
@PUCUUnicodeScriptBlocks26,
@PUCUUnicodeScriptBlocks27,
@PUCUUnicodeScriptBlocks28,
@PUCUUnicodeScriptBlocks29,
@PUCUUnicodeScriptBlocks30,
@PUCUUnicodeScriptBlocks31,
@PUCUUnicodeScriptBlocks32,
@PUCUUnicodeScriptBlocks33,
@PUCUUnicodeScriptBlocks34,
@PUCUUnicodeScriptBlocks35,
@PUCUUnicodeScriptBlocks36,
@PUCUUnicodeScriptBlocks37,
@PUCUUnicodeScriptBlocks38,
@PUCUUnicodeScriptBlocks39,
@PUCUUnicodeScriptBlocks40,
@PUCUUnicodeScriptBlocks41,
@PUCUUnicodeScriptBlocks42,
@PUCUUnicodeScriptBlocks43,
@PUCUUnicodeScriptBlocks44,
@PUCUUnicodeScriptBlocks45,
@PUCUUnicodeScriptBlocks46,
@PUCUUnicodeScriptBlocks47,
@PUCUUnicodeScriptBlocks48,
@PUCUUnicodeScriptBlocks49,
@PUCUUnicodeScriptBlocks50,
@PUCUUnicodeScriptBlocks51,
@PUCUUnicodeScriptBlocks52,
@PUCUUnicodeScriptBlocks53,
@PUCUUnicodeScriptBlocks54,
@PUCUUnicodeScriptBlocks55,
@PUCUUnicodeScriptBlocks56,
@PUCUUnicodeScriptBlocks57,
@PUCUUnicodeScriptBlocks58,
@PUCUUnicodeScriptBlocks59,
@PUCUUnicodeScriptBlocks60,
@PUCUUnicodeScriptBlocks61,
@PUCUUnicodeScriptBlocks62,
@PUCUUnicodeScriptBlocks63,
@PUCUUnicodeScriptBlocks64,
@PUCUUnicodeScriptBlocks65,
@PUCUUnicodeScriptBlocks66,
@PUCUUnicodeScriptBlocks67,
@PUCUUnicodeScriptBlocks68,
@PUCUUnicodeScriptBlocks69,
@PUCUUnicodeScriptBlocks70,
@PUCUUnicodeScriptBlocks71,
@PUCUUnicodeScriptBlocks72,
@PUCUUnicodeScriptBlocks73,
@PUCUUnicodeScriptBlocks74,
@PUCUUnicodeScriptBlocks75,
@PUCUUnicodeScriptBlocks76,
@PUCUUnicodeScriptBlocks77,
@PUCUUnicodeScriptBlocks78,
@PUCUUnicodeScriptBlocks79,
@PUCUUnicodeScriptBlocks80,
@PUCUUnicodeScriptBlocks81,
@PUCUUnicodeScriptBlocks82,
@PUCUUnicodeScriptBlocks83,
@PUCUUnicodeScriptBlocks84,
@PUCUUnicodeScriptBlocks85,
@PUCUUnicodeScriptBlocks86,
@PUCUUnicodeScriptBlocks87,
@PUCUUnicodeScriptBlocks88,
@PUCUUnicodeScriptBlocks89,
@PUCUUnicodeScriptBlocks90,
@PUCUUnicodeScriptBlocks91,
@PUCUUnicodeScriptBlocks92,
@PUCUUnicodeScriptBlocks93,
@PUCUUnicodeScriptBlocks94,
@PUCUUnicodeScriptBlocks95,
@PUCUUnicodeScriptBlocks96,
@PUCUUnicodeScriptBlocks97,
@PUCUUnicodeScriptBlocks98,
@PUCUUnicodeScriptBlocks99,
@PUCUUnicodeScriptBlocks100,
@PUCUUnicodeScriptBlocks101,
@PUCUUnicodeScriptBlocks102,
@PUCUUnicodeScriptBlocks103,
@PUCUUnicodeScriptBlocks104,
@PUCUUnicodeScriptBlocks105,
@PUCUUnicodeScriptBlocks106,
@PUCUUnicodeScriptBlocks107,
@PUCUUnicodeScriptBlocks108,
@PUCUUnicodeScriptBlocks109,
@PUCUUnicodeScriptBlocks110,
@PUCUUnicodeScriptBlocks111,
@PUCUUnicodeScriptBlocks112,
@PUCUUnicodeScriptBlocks113,
@PUCUUnicodeScriptBlocks114,
@PUCUUnicodeScriptBlocks115,
@PUCUUnicodeScriptBlocks116,
@PUCUUnicodeScriptBlocks117,
@PUCUUnicodeScriptBlocks118,
@PUCUUnicodeScriptBlocks119,
@PUCUUnicodeScriptBlocks120,
@PUCUUnicodeScriptBlocks121,
@PUCUUnicodeScriptBlocks122,
@PUCUUnicodeScriptBlocks123,
@PUCUUnicodeScriptBlocks124,
@PUCUUnicodeScriptBlocks125,
@PUCUUnicodeScriptBlocks126,
@PUCUUnicodeScriptBlocks127,
@PUCUUnicodeScriptBlocks128,
@PUCUUnicodeScriptBlocks129,
@PUCUUnicodeScriptBlocks130,
@PUCUUnicodeScriptBlocks131,
@PUCUUnicodeScriptBlocks132,
@PUCUUnicodeScriptBlocks133,
@PUCUUnicodeScriptBlocks134,
@PUCUUnicodeScriptBlocks135,
@PUCUUnicodeScriptBlocks136,
@PUCUUnicodeScriptBlocks137
);

const PUCUUnicodeScriptBlocksCounts:array[0..137] of longint=(
636,
165,
31,
36,
8,
6,
9,
56,
3,
1,
4,
14,
16,
14,
14,
16,
13,
14,
9,
13,
2,
18,
7,
3,
8,
14,
32,
3,
2,
1,
2,
4,
7,
4,
8,
3,
16,
2,
1,
1,
1,
27,
2,
1,
1,
3,
5,
2,
7,
2,
1,
2,
6,
1,
2,
3,
4,
7,
3,
1,
2,
8,
2,
4,
2,
1,
1,
2,
3,
1,
1,
2,
2,
2,
1,
1,
2,
4,
5,
2,
2,
1,
2,
1,
2,
3,
3,
2,
1,
2,
2,
1,
1,
2,
3,
2,
2,
3,
1,
3,
2,
2,
2,
2,
2,
5,
1,
15,
5,
2,
3,
1,
2,
2,
2,
3,
1,
2,
1,
1,
1,
3,
2,
2,
2,
2,
3,
1,
3,
5,
3,
3,
3,
4,
3,
3,
2,
3
);

const PUCUCountUnicodeIgnoreCaseScriptBlocks=137;

const PUCUUnicodeIgnoreCaseScriptBlocks0:array[0..635] of TPUCUUnicodeCharRange=(
(888,889),
(896,899),
(907,907),
(909,909),
(930,930),
(1328,1328),
(1367,1368),
(1376,1376),
(1416,1416),
(1419,1420),
(1424,1424),
(1480,1487),
(1515,1519),
(1525,1535),
(1565,1565),
(1806,1806),
(1867,1868),
(1970,1983),
(2043,2047),
(2094,2095),
(2111,2111),
(2140,2141),
(2143,2207),
(2229,2229),
(2238,2259),
(2436,2436),
(2445,2446),
(2449,2450),
(2473,2473),
(2481,2481),
(2483,2485),
(2490,2491),
(2501,2502),
(2505,2506),
(2511,2518),
(2520,2523),
(2526,2526),
(2532,2533),
(2556,2560),
(2564,2564),
(2571,2574),
(2577,2578),
(2601,2601),
(2609,2609),
(2612,2612),
(2615,2615),
(2618,2619),
(2621,2621),
(2627,2630),
(2633,2634),
(2638,2640),
(2642,2648),
(2653,2653),
(2655,2661),
(2678,2688),
(2692,2692),
(2702,2702),
(2706,2706),
(2729,2729),
(2737,2737),
(2740,2740),
(2746,2747),
(2758,2758),
(2762,2762),
(2766,2767),
(2769,2783),
(2788,2789),
(2802,2808),
(2810,2816),
(2820,2820),
(2829,2830),
(2833,2834),
(2857,2857),
(2865,2865),
(2868,2868),
(2874,2875),
(2885,2886),
(2889,2890),
(2894,2901),
(2904,2907),
(2910,2910),
(2916,2917),
(2936,2945),
(2948,2948),
(2955,2957),
(2961,2961),
(2966,2968),
(2971,2971),
(2973,2973),
(2976,2978),
(2981,2983),
(2987,2989),
(3002,3005),
(3011,3013),
(3017,3017),
(3022,3023),
(3025,3030),
(3032,3045),
(3067,3071),
(3076,3076),
(3085,3085),
(3089,3089),
(3113,3113),
(3130,3132),
(3141,3141),
(3145,3145),
(3150,3156),
(3159,3159),
(3163,3167),
(3172,3173),
(3184,3191),
(3204,3204),
(3213,3213),
(3217,3217),
(3241,3241),
(3252,3252),
(3258,3259),
(3269,3269),
(3273,3273),
(3278,3284),
(3287,3293),
(3295,3295),
(3300,3301),
(3312,3312),
(3315,3328),
(3332,3332),
(3341,3341),
(3345,3345),
(3387,3388),
(3397,3397),
(3401,3401),
(3408,3411),
(3428,3429),
(3456,3457),
(3460,3460),
(3479,3481),
(3506,3506),
(3516,3516),
(3518,3519),
(3527,3529),
(3531,3534),
(3541,3541),
(3543,3543),
(3552,3557),
(3568,3569),
(3573,3584),
(3643,3646),
(3676,3712),
(3715,3715),
(3717,3718),
(3721,3721),
(3723,3724),
(3726,3731),
(3736,3736),
(3744,3744),
(3748,3748),
(3750,3750),
(3752,3753),
(3756,3756),
(3770,3770),
(3774,3775),
(3781,3781),
(3783,3783),
(3790,3791),
(3802,3803),
(3808,3839),
(3912,3912),
(3949,3952),
(3992,3992),
(4029,4029),
(4045,4045),
(4059,4095),
(4294,4294),
(4296,4300),
(4302,4303),
(4681,4681),
(4686,4687),
(4695,4695),
(4697,4697),
(4702,4703),
(4745,4745),
(4750,4751),
(4785,4785),
(4790,4791),
(4799,4799),
(4801,4801),
(4806,4807),
(4823,4823),
(4881,4881),
(4886,4887),
(4955,4956),
(4989,4991),
(5018,5023),
(5110,5111),
(5118,5119),
(5789,5791),
(5881,5887),
(5901,5901),
(5909,5919),
(5943,5951),
(5972,5983),
(5997,5997),
(6001,6001),
(6004,6015),
(6110,6111),
(6122,6127),
(6138,6143),
(6159,6159),
(6170,6175),
(6264,6271),
(6315,6319),
(6390,6399),
(6431,6431),
(6444,6447),
(6460,6463),
(6465,6467),
(6510,6511),
(6517,6527),
(6572,6575),
(6602,6607),
(6619,6621),
(6684,6685),
(6751,6751),
(6781,6782),
(6794,6799),
(6810,6815),
(6830,6831),
(6847,6911),
(6988,6991),
(7037,7039),
(7156,7163),
(7224,7226),
(7242,7244),
(7305,7359),
(7368,7375),
(7415,7415),
(7418,7423),
(7670,7674),
(7958,7959),
(7966,7967),
(8006,8007),
(8014,8015),
(8024,8024),
(8026,8026),
(8028,8028),
(8030,8030),
(8062,8063),
(8117,8117),
(8133,8133),
(8148,8149),
(8156,8156),
(8176,8177),
(8181,8181),
(8191,8191),
(8293,8293),
(8306,8307),
(8335,8335),
(8349,8351),
(8383,8399),
(8433,8447),
(8588,8591),
(9215,9215),
(9255,9279),
(9291,9311),
(11124,11125),
(11158,11159),
(11194,11196),
(11209,11209),
(11218,11243),
(11248,11263),
(11311,11311),
(11359,11359),
(11508,11512),
(11558,11558),
(11560,11564),
(11566,11567),
(11624,11630),
(11633,11646),
(11671,11679),
(11687,11687),
(11695,11695),
(11703,11703),
(11711,11711),
(11719,11719),
(11727,11727),
(11735,11735),
(11743,11743),
(11845,11903),
(11930,11930),
(12020,12031),
(12246,12271),
(12284,12287),
(12352,12352),
(12439,12440),
(12544,12548),
(12590,12592),
(12687,12687),
(12731,12735),
(12772,12783),
(12831,12831),
(13055,13055),
(19894,19903),
(40918,40959),
(42125,42127),
(42183,42191),
(42540,42559),
(42744,42751),
(42927,42927),
(42936,42998),
(43052,43055),
(43066,43071),
(43128,43135),
(43206,43213),
(43226,43231),
(43262,43263),
(43348,43358),
(43389,43391),
(43470,43470),
(43482,43485),
(43519,43519),
(43575,43583),
(43598,43599),
(43610,43611),
(43715,43738),
(43767,43776),
(43783,43784),
(43791,43792),
(43799,43807),
(43815,43815),
(43823,43823),
(43878,43887),
(44014,44015),
(44026,44031),
(55204,55215),
(55239,55242),
(55292,63743),
(64110,64111),
(64218,64255),
(64263,64274),
(64280,64284),
(64311,64311),
(64317,64317),
(64319,64319),
(64322,64322),
(64325,64325),
(64450,64466),
(64832,64847),
(64912,64913),
(64968,65007),
(65022,65023),
(65050,65055),
(65107,65107),
(65127,65127),
(65132,65135),
(65141,65141),
(65277,65278),
(65280,65280),
(65471,65473),
(65480,65481),
(65488,65489),
(65496,65497),
(65501,65503),
(65511,65511),
(65519,65528),
(65534,65535),
(65548,65548),
(65575,65575),
(65595,65595),
(65598,65598),
(65614,65615),
(65630,65663),
(65787,65791),
(65795,65798),
(65844,65846),
(65935,65935),
(65948,65951),
(65953,65999),
(66046,66175),
(66205,66207),
(66257,66271),
(66300,66303),
(66340,66351),
(66379,66383),
(66427,66431),
(66462,66462),
(66500,66503),
(66518,66559),
(66718,66719),
(66730,66735),
(66772,66775),
(66812,66815),
(66856,66863),
(66916,66926),
(66928,67071),
(67383,67391),
(67414,67423),
(67432,67583),
(67590,67591),
(67593,67593),
(67638,67638),
(67641,67643),
(67645,67646),
(67670,67670),
(67743,67750),
(67760,67807),
(67827,67827),
(67830,67834),
(67868,67870),
(67898,67902),
(67904,67967),
(68024,68027),
(68048,68049),
(68100,68100),
(68103,68107),
(68116,68116),
(68120,68120),
(68148,68151),
(68155,68158),
(68168,68175),
(68185,68191),
(68256,68287),
(68327,68330),
(68343,68351),
(68406,68408),
(68438,68439),
(68467,68471),
(68498,68504),
(68509,68520),
(68528,68607),
(68681,68735),
(68787,68799),
(68851,68857),
(68864,69215),
(69247,69631),
(69710,69713),
(69744,69758),
(69826,69839),
(69865,69871),
(69882,69887),
(69941,69941),
(69956,69967),
(70007,70015),
(70094,70095),
(70112,70112),
(70133,70143),
(70162,70162),
(70207,70271),
(70279,70279),
(70281,70281),
(70286,70286),
(70302,70302),
(70314,70319),
(70379,70383),
(70394,70399),
(70404,70404),
(70413,70414),
(70417,70418),
(70441,70441),
(70449,70449),
(70452,70452),
(70458,70459),
(70469,70470),
(70473,70474),
(70478,70479),
(70481,70486),
(70488,70492),
(70500,70501),
(70509,70511),
(70517,70655),
(70746,70746),
(70748,70748),
(70750,70783),
(70856,70863),
(70874,71039),
(71094,71095),
(71134,71167),
(71237,71247),
(71258,71263),
(71277,71295),
(71352,71359),
(71370,71423),
(71450,71452),
(71468,71471),
(71488,71839),
(71923,71934),
(71936,72383),
(72441,72703),
(72713,72713),
(72759,72759),
(72774,72783),
(72813,72815),
(72848,72849),
(72872,72872),
(72887,73727),
(74650,74751),
(74863,74863),
(74869,74879),
(75076,77823),
(78895,82943),
(83527,92159),
(92729,92735),
(92767,92767),
(92778,92781),
(92784,92879),
(92910,92911),
(92918,92927),
(92998,93007),
(93018,93018),
(93026,93026),
(93048,93052),
(93072,93951),
(94021,94031),
(94079,94094),
(94112,94175),
(94177,94207),
(100333,100351),
(101107,110591),
(110594,113663),
(113771,113775),
(113789,113791),
(113801,113807),
(113818,113819),
(113828,118783),
(119030,119039),
(119079,119080),
(119273,119295),
(119366,119551),
(119639,119647),
(119666,119807),
(119893,119893),
(119965,119965),
(119968,119969),
(119971,119972),
(119975,119976),
(119981,119981),
(119994,119994),
(119996,119996),
(120004,120004),
(120070,120070),
(120075,120076),
(120085,120085),
(120093,120093),
(120122,120122),
(120127,120127),
(120133,120133),
(120135,120137),
(120145,120145),
(120486,120487),
(120780,120781),
(121484,121498),
(121504,121504),
(121520,122879),
(122887,122887),
(122905,122906),
(122914,122914),
(122917,122917),
(122923,124927),
(125125,125126),
(125143,125183),
(125259,125263),
(125274,125277),
(125280,126463),
(126468,126468),
(126496,126496),
(126499,126499),
(126501,126502),
(126504,126504),
(126515,126515),
(126520,126520),
(126522,126522),
(126524,126529),
(126531,126534),
(126536,126536),
(126538,126538),
(126540,126540),
(126544,126544),
(126547,126547),
(126549,126550),
(126552,126552),
(126554,126554),
(126556,126556),
(126558,126558),
(126560,126560),
(126563,126563),
(126565,126566),
(126571,126571),
(126579,126579),
(126584,126584),
(126589,126589),
(126591,126591),
(126602,126602),
(126620,126624),
(126628,126628),
(126634,126634),
(126652,126703),
(126706,126975),
(127020,127023),
(127124,127135),
(127151,127152),
(127168,127168),
(127184,127184),
(127222,127231),
(127245,127247),
(127279,127279),
(127340,127343),
(127405,127461),
(127491,127503),
(127548,127551),
(127561,127567),
(127570,127743),
(128723,128735),
(128749,128751),
(128759,128767),
(128884,128895),
(128981,129023),
(129036,129039),
(129096,129103),
(129114,129119),
(129160,129167),
(129198,129295),
(129311,129311),
(129320,129327),
(129329,129330),
(129343,129343),
(129356,129359),
(129375,129407),
(129426,129471),
(129473,131071),
(173783,173823),
(177973,177983),
(178206,178207),
(183970,194559),
(195102,917504),
(917506,917535),
(917632,917759),
(918000,1114111)
);

const PUCUUnicodeIgnoreCaseScriptBlocks1:array[0..165] of TPUCUUnicodeCharRange=(
(0,64),
(91,96),
(123,169),
(171,185),
(187,191),
(215,215),
(247,247),
(697,735),
(741,745),
(748,767),
(884,884),
(894,894),
(901,901),
(903,903),
(924,924),
(1417,1417),
(1541,1541),
(1548,1548),
(1563,1564),
(1567,1567),
(1600,1600),
(1757,1757),
(2274,2274),
(2404,2405),
(3647,3647),
(4053,4056),
(4347,4347),
(5867,5869),
(5941,5942),
(6146,6147),
(6149,6149),
(7379,7379),
(7393,7393),
(7401,7404),
(7406,7411),
(7413,7414),
(8192,8203),
(8206,8292),
(8294,8304),
(8308,8318),
(8320,8334),
(8352,8382),
(8448,8485),
(8487,8489),
(8492,8497),
(8499,8525),
(8527,8543),
(8585,8587),
(8592,9214),
(9216,9254),
(9280,9290),
(9312,10239),
(10496,11123),
(11126,11157),
(11160,11193),
(11197,11208),
(11210,11217),
(11244,11247),
(11776,11844),
(12272,12283),
(12288,12292),
(12294,12294),
(12296,12320),
(12336,12343),
(12348,12351),
(12443,12444),
(12448,12448),
(12539,12540),
(12688,12703),
(12736,12771),
(12832,12895),
(12927,13007),
(13144,13311),
(19904,19967),
(42752,42785),
(42888,42890),
(43056,43065),
(43310,43310),
(43471,43471),
(43867,43867),
(64830,64831),
(65040,65049),
(65072,65106),
(65108,65126),
(65128,65131),
(65279,65279),
(65281,65312),
(65339,65344),
(65371,65381),
(65392,65392),
(65438,65439),
(65504,65510),
(65512,65518),
(65529,65533),
(65792,65794),
(65799,65843),
(65847,65855),
(65936,65947),
(66000,66044),
(66273,66299),
(113824,113827),
(118784,119029),
(119040,119078),
(119081,119142),
(119146,119162),
(119171,119172),
(119180,119209),
(119214,119272),
(119552,119638),
(119648,119665),
(119808,119892),
(119894,119964),
(119966,119967),
(119970,119970),
(119973,119974),
(119977,119980),
(119982,119993),
(119995,119995),
(119997,120003),
(120005,120069),
(120071,120074),
(120077,120084),
(120086,120092),
(120094,120121),
(120123,120126),
(120128,120132),
(120134,120134),
(120138,120144),
(120146,120485),
(120488,120779),
(120782,120831),
(126976,127019),
(127024,127123),
(127136,127150),
(127153,127167),
(127169,127183),
(127185,127221),
(127232,127244),
(127248,127278),
(127280,127339),
(127344,127404),
(127462,127487),
(127489,127490),
(127504,127547),
(127552,127560),
(127568,127569),
(127744,128722),
(128736,128748),
(128752,128758),
(128768,128883),
(128896,128980),
(129024,129035),
(129040,129095),
(129104,129113),
(129120,129159),
(129168,129197),
(129296,129310),
(129312,129319),
(129328,129328),
(129331,129342),
(129344,129355),
(129360,129374),
(129408,129425),
(129472,129472),
(917505,917505),
(917536,917631)
);

const PUCUUnicodeIgnoreCaseScriptBlocks2:array[0..30] of TPUCUUnicodeCharRange=(
(65,90),
(97,122),
(170,170),
(186,186),
(192,214),
(216,246),
(248,696),
(736,740),
(7424,7461),
(7468,7516),
(7522,7525),
(7531,7543),
(7545,7614),
(7680,7935),
(8305,8305),
(8319,8319),
(8336,8348),
(8490,8491),
(8498,8498),
(8526,8526),
(8544,8584),
(11360,11391),
(42786,42887),
(42891,42926),
(42928,42935),
(42999,43007),
(43824,43866),
(43868,43876),
(64256,64262),
(65313,65338),
(65345,65370)
);

const PUCUUnicodeIgnoreCaseScriptBlocks3:array[0..35] of TPUCUUnicodeCharRange=(
(880,883),
(885,887),
(890,893),
(895,895),
(900,900),
(902,902),
(904,906),
(908,908),
(910,929),
(931,993),
(1008,1023),
(7462,7466),
(7517,7521),
(7526,7530),
(7615,7615),
(7936,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8016,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8064,8116),
(8118,8132),
(8134,8147),
(8150,8155),
(8157,8175),
(8178,8180),
(8182,8190),
(8486,8486),
(43877,43877),
(65856,65934),
(65952,65952),
(119296,119365)
);

const PUCUUnicodeIgnoreCaseScriptBlocks4:array[0..7] of TPUCUUnicodeCharRange=(
(1024,1156),
(1159,1327),
(7296,7304),
(7467,7467),
(7544,7544),
(11744,11775),
(42560,42655),
(65070,65071)
);

const PUCUUnicodeIgnoreCaseScriptBlocks5:array[0..5] of TPUCUUnicodeCharRange=(
(1329,1366),
(1369,1375),
(1377,1415),
(1418,1418),
(1421,1423),
(64275,64279)
);

const PUCUUnicodeIgnoreCaseScriptBlocks6:array[0..8] of TPUCUUnicodeCharRange=(
(1425,1479),
(1488,1514),
(1520,1524),
(64285,64310),
(64312,64316),
(64318,64318),
(64320,64321),
(64323,64324),
(64326,64335)
);

const PUCUUnicodeIgnoreCaseScriptBlocks7:array[0..55] of TPUCUUnicodeCharRange=(
(1536,1540),
(1542,1547),
(1549,1562),
(1566,1566),
(1568,1599),
(1601,1610),
(1622,1647),
(1649,1756),
(1758,1791),
(1872,1919),
(2208,2228),
(2230,2237),
(2260,2273),
(2275,2303),
(64336,64449),
(64467,64829),
(64848,64911),
(64914,64967),
(65008,65021),
(65136,65140),
(65142,65276),
(69216,69246),
(126464,126467),
(126469,126495),
(126497,126498),
(126500,126500),
(126503,126503),
(126505,126514),
(126516,126519),
(126521,126521),
(126523,126523),
(126530,126530),
(126535,126535),
(126537,126537),
(126539,126539),
(126541,126543),
(126545,126546),
(126548,126548),
(126551,126551),
(126553,126553),
(126555,126555),
(126557,126557),
(126559,126559),
(126561,126562),
(126564,126564),
(126567,126570),
(126572,126578),
(126580,126583),
(126585,126588),
(126590,126590),
(126592,126601),
(126603,126619),
(126625,126627),
(126629,126633),
(126635,126651),
(126704,126705)
);

const PUCUUnicodeIgnoreCaseScriptBlocks8:array[0..2] of TPUCUUnicodeCharRange=(
(1792,1805),
(1807,1866),
(1869,1871)
);

const PUCUUnicodeIgnoreCaseScriptBlocks9:array[0..0] of TPUCUUnicodeCharRange=(
(1920,1969)
);

const PUCUUnicodeIgnoreCaseScriptBlocks10:array[0..3] of TPUCUUnicodeCharRange=(
(2304,2384),
(2387,2403),
(2406,2431),
(43232,43261)
);

const PUCUUnicodeIgnoreCaseScriptBlocks11:array[0..13] of TPUCUUnicodeCharRange=(
(2432,2435),
(2437,2444),
(2447,2448),
(2451,2472),
(2474,2480),
(2482,2482),
(2486,2489),
(2492,2500),
(2503,2504),
(2507,2510),
(2519,2519),
(2524,2525),
(2527,2531),
(2534,2555)
);

const PUCUUnicodeIgnoreCaseScriptBlocks12:array[0..15] of TPUCUUnicodeCharRange=(
(2561,2563),
(2565,2570),
(2575,2576),
(2579,2600),
(2602,2608),
(2610,2611),
(2613,2614),
(2616,2617),
(2620,2620),
(2622,2626),
(2631,2632),
(2635,2637),
(2641,2641),
(2649,2652),
(2654,2654),
(2662,2677)
);

const PUCUUnicodeIgnoreCaseScriptBlocks13:array[0..13] of TPUCUUnicodeCharRange=(
(2689,2691),
(2693,2701),
(2703,2705),
(2707,2728),
(2730,2736),
(2738,2739),
(2741,2745),
(2748,2757),
(2759,2761),
(2763,2765),
(2768,2768),
(2784,2787),
(2790,2801),
(2809,2809)
);

const PUCUUnicodeIgnoreCaseScriptBlocks14:array[0..13] of TPUCUUnicodeCharRange=(
(2817,2819),
(2821,2828),
(2831,2832),
(2835,2856),
(2858,2864),
(2866,2867),
(2869,2873),
(2876,2884),
(2887,2888),
(2891,2893),
(2902,2903),
(2908,2909),
(2911,2915),
(2918,2935)
);

const PUCUUnicodeIgnoreCaseScriptBlocks15:array[0..15] of TPUCUUnicodeCharRange=(
(2946,2947),
(2949,2954),
(2958,2960),
(2962,2965),
(2969,2970),
(2972,2972),
(2974,2975),
(2979,2980),
(2984,2986),
(2990,3001),
(3006,3010),
(3014,3016),
(3018,3021),
(3024,3024),
(3031,3031),
(3046,3066)
);

const PUCUUnicodeIgnoreCaseScriptBlocks16:array[0..12] of TPUCUUnicodeCharRange=(
(3072,3075),
(3077,3084),
(3086,3088),
(3090,3112),
(3114,3129),
(3133,3140),
(3142,3144),
(3146,3149),
(3157,3158),
(3160,3162),
(3168,3171),
(3174,3183),
(3192,3199)
);

const PUCUUnicodeIgnoreCaseScriptBlocks17:array[0..13] of TPUCUUnicodeCharRange=(
(3200,3203),
(3205,3212),
(3214,3216),
(3218,3240),
(3242,3251),
(3253,3257),
(3260,3268),
(3270,3272),
(3274,3277),
(3285,3286),
(3294,3294),
(3296,3299),
(3302,3311),
(3313,3314)
);

const PUCUUnicodeIgnoreCaseScriptBlocks18:array[0..8] of TPUCUUnicodeCharRange=(
(3329,3331),
(3333,3340),
(3342,3344),
(3346,3386),
(3389,3396),
(3398,3400),
(3402,3407),
(3412,3427),
(3430,3455)
);

const PUCUUnicodeIgnoreCaseScriptBlocks19:array[0..12] of TPUCUUnicodeCharRange=(
(3458,3459),
(3461,3478),
(3482,3505),
(3507,3515),
(3517,3517),
(3520,3526),
(3530,3530),
(3535,3540),
(3542,3542),
(3544,3551),
(3558,3567),
(3570,3572),
(70113,70132)
);

const PUCUUnicodeIgnoreCaseScriptBlocks20:array[0..1] of TPUCUUnicodeCharRange=(
(3585,3642),
(3648,3675)
);

const PUCUUnicodeIgnoreCaseScriptBlocks21:array[0..17] of TPUCUUnicodeCharRange=(
(3713,3714),
(3716,3716),
(3719,3720),
(3722,3722),
(3725,3725),
(3732,3735),
(3737,3743),
(3745,3747),
(3749,3749),
(3751,3751),
(3754,3755),
(3757,3769),
(3771,3773),
(3776,3780),
(3782,3782),
(3784,3789),
(3792,3801),
(3804,3807)
);

const PUCUUnicodeIgnoreCaseScriptBlocks22:array[0..6] of TPUCUUnicodeCharRange=(
(3840,3911),
(3913,3948),
(3953,3991),
(3993,4028),
(4030,4044),
(4046,4052),
(4057,4058)
);

const PUCUUnicodeIgnoreCaseScriptBlocks23:array[0..2] of TPUCUUnicodeCharRange=(
(4096,4255),
(43488,43518),
(43616,43647)
);

const PUCUUnicodeIgnoreCaseScriptBlocks24:array[0..7] of TPUCUUnicodeCharRange=(
(4256,4293),
(4295,4295),
(4301,4301),
(4304,4346),
(4348,4351),
(11520,11557),
(11559,11559),
(11565,11565)
);

const PUCUUnicodeIgnoreCaseScriptBlocks25:array[0..13] of TPUCUUnicodeCharRange=(
(4352,4607),
(12334,12335),
(12593,12686),
(12800,12830),
(12896,12926),
(43360,43388),
(44032,55203),
(55216,55238),
(55243,55291),
(65440,65470),
(65474,65479),
(65482,65487),
(65490,65495),
(65498,65500)
);

const PUCUUnicodeIgnoreCaseScriptBlocks26:array[0..31] of TPUCUUnicodeCharRange=(
(4608,4680),
(4682,4685),
(4688,4694),
(4696,4696),
(4698,4701),
(4704,4744),
(4746,4749),
(4752,4784),
(4786,4789),
(4792,4798),
(4800,4800),
(4802,4805),
(4808,4822),
(4824,4880),
(4882,4885),
(4888,4954),
(4957,4988),
(4992,5017),
(11648,11670),
(11680,11686),
(11688,11694),
(11696,11702),
(11704,11710),
(11712,11718),
(11720,11726),
(11728,11734),
(11736,11742),
(43777,43782),
(43785,43790),
(43793,43798),
(43808,43814),
(43816,43822)
);

const PUCUUnicodeIgnoreCaseScriptBlocks27:array[0..2] of TPUCUUnicodeCharRange=(
(5024,5109),
(5112,5117),
(43888,43967)
);

const PUCUUnicodeIgnoreCaseScriptBlocks28:array[0..1] of TPUCUUnicodeCharRange=(
(5120,5759),
(6320,6389)
);

const PUCUUnicodeIgnoreCaseScriptBlocks29:array[0..0] of TPUCUUnicodeCharRange=(
(5760,5788)
);

const PUCUUnicodeIgnoreCaseScriptBlocks30:array[0..1] of TPUCUUnicodeCharRange=(
(5792,5866),
(5870,5880)
);

const PUCUUnicodeIgnoreCaseScriptBlocks31:array[0..3] of TPUCUUnicodeCharRange=(
(6016,6109),
(6112,6121),
(6128,6137),
(6624,6655)
);

const PUCUUnicodeIgnoreCaseScriptBlocks32:array[0..6] of TPUCUUnicodeCharRange=(
(6144,6145),
(6148,6148),
(6150,6158),
(6160,6169),
(6176,6263),
(6272,6314),
(71264,71276)
);

const PUCUUnicodeIgnoreCaseScriptBlocks33:array[0..3] of TPUCUUnicodeCharRange=(
(12353,12438),
(12445,12447),
(110593,110593),
(127488,127488)
);

const PUCUUnicodeIgnoreCaseScriptBlocks34:array[0..7] of TPUCUUnicodeCharRange=(
(12449,12538),
(12541,12543),
(12784,12799),
(13008,13054),
(13056,13143),
(65382,65391),
(65393,65437),
(110592,110592)
);

const PUCUUnicodeIgnoreCaseScriptBlocks35:array[0..2] of TPUCUUnicodeCharRange=(
(746,747),
(12549,12589),
(12704,12730)
);

const PUCUUnicodeIgnoreCaseScriptBlocks36:array[0..15] of TPUCUUnicodeCharRange=(
(11904,11929),
(11931,12019),
(12032,12245),
(12293,12293),
(12295,12295),
(12321,12329),
(12344,12347),
(13312,19893),
(19968,40917),
(63744,64109),
(64112,64217),
(131072,173782),
(173824,177972),
(177984,178205),
(178208,183969),
(194560,195101)
);

const PUCUUnicodeIgnoreCaseScriptBlocks37:array[0..1] of TPUCUUnicodeCharRange=(
(40960,42124),
(42128,42182)
);

const PUCUUnicodeIgnoreCaseScriptBlocks38:array[0..0] of TPUCUUnicodeCharRange=(
(66304,66339)
);

const PUCUUnicodeIgnoreCaseScriptBlocks39:array[0..0] of TPUCUUnicodeCharRange=(
(66352,66378)
);

const PUCUUnicodeIgnoreCaseScriptBlocks40:array[0..0] of TPUCUUnicodeCharRange=(
(66560,66639)
);

const PUCUUnicodeIgnoreCaseScriptBlocks41:array[0..27] of TPUCUUnicodeCharRange=(
(768,879),
(921,921),
(1157,1158),
(1611,1621),
(1648,1648),
(2385,2386),
(6832,6846),
(7376,7378),
(7380,7392),
(7394,7400),
(7405,7405),
(7412,7412),
(7416,7417),
(7616,7669),
(7675,7679),
(8204,8205),
(8400,8432),
(12330,12333),
(12441,12442),
(65024,65039),
(65056,65069),
(66045,66045),
(66272,66272),
(119143,119145),
(119163,119170),
(119173,119179),
(119210,119213),
(917760,917999)
);

const PUCUUnicodeIgnoreCaseScriptBlocks42:array[0..1] of TPUCUUnicodeCharRange=(
(5888,5900),
(5902,5908)
);

const PUCUUnicodeIgnoreCaseScriptBlocks43:array[0..0] of TPUCUUnicodeCharRange=(
(5920,5940)
);

const PUCUUnicodeIgnoreCaseScriptBlocks44:array[0..0] of TPUCUUnicodeCharRange=(
(5952,5971)
);

const PUCUUnicodeIgnoreCaseScriptBlocks45:array[0..2] of TPUCUUnicodeCharRange=(
(5984,5996),
(5998,6000),
(6002,6003)
);

const PUCUUnicodeIgnoreCaseScriptBlocks46:array[0..4] of TPUCUUnicodeCharRange=(
(6400,6430),
(6432,6443),
(6448,6459),
(6464,6464),
(6468,6479)
);

const PUCUUnicodeIgnoreCaseScriptBlocks47:array[0..1] of TPUCUUnicodeCharRange=(
(6480,6509),
(6512,6516)
);

const PUCUUnicodeIgnoreCaseScriptBlocks48:array[0..6] of TPUCUUnicodeCharRange=(
(65536,65547),
(65549,65574),
(65576,65594),
(65596,65597),
(65599,65613),
(65616,65629),
(65664,65786)
);

const PUCUUnicodeIgnoreCaseScriptBlocks49:array[0..1] of TPUCUUnicodeCharRange=(
(66432,66461),
(66463,66463)
);

const PUCUUnicodeIgnoreCaseScriptBlocks50:array[0..0] of TPUCUUnicodeCharRange=(
(66640,66687)
);

const PUCUUnicodeIgnoreCaseScriptBlocks51:array[0..1] of TPUCUUnicodeCharRange=(
(66688,66717),
(66720,66729)
);

const PUCUUnicodeIgnoreCaseScriptBlocks52:array[0..5] of TPUCUUnicodeCharRange=(
(67584,67589),
(67592,67592),
(67594,67637),
(67639,67640),
(67644,67644),
(67647,67647)
);

const PUCUUnicodeIgnoreCaseScriptBlocks53:array[0..0] of TPUCUUnicodeCharRange=(
(10240,10495)
);

const PUCUUnicodeIgnoreCaseScriptBlocks54:array[0..1] of TPUCUUnicodeCharRange=(
(6656,6683),
(6686,6687)
);

const PUCUUnicodeIgnoreCaseScriptBlocks55:array[0..2] of TPUCUUnicodeCharRange=(
(994,1007),
(11392,11507),
(11513,11519)
);

const PUCUUnicodeIgnoreCaseScriptBlocks56:array[0..3] of TPUCUUnicodeCharRange=(
(6528,6571),
(6576,6601),
(6608,6618),
(6622,6623)
);

const PUCUUnicodeIgnoreCaseScriptBlocks57:array[0..6] of TPUCUUnicodeCharRange=(
(11264,11310),
(11312,11358),
(122880,122886),
(122888,122904),
(122907,122913),
(122915,122916),
(122918,122922)
);

const PUCUUnicodeIgnoreCaseScriptBlocks58:array[0..2] of TPUCUUnicodeCharRange=(
(11568,11623),
(11631,11632),
(11647,11647)
);

const PUCUUnicodeIgnoreCaseScriptBlocks59:array[0..0] of TPUCUUnicodeCharRange=(
(43008,43051)
);

const PUCUUnicodeIgnoreCaseScriptBlocks60:array[0..1] of TPUCUUnicodeCharRange=(
(66464,66499),
(66504,66517)
);

const PUCUUnicodeIgnoreCaseScriptBlocks61:array[0..7] of TPUCUUnicodeCharRange=(
(68096,68099),
(68101,68102),
(68108,68115),
(68117,68119),
(68121,68147),
(68152,68154),
(68159,68167),
(68176,68184)
);

const PUCUUnicodeIgnoreCaseScriptBlocks62:array[0..1] of TPUCUUnicodeCharRange=(
(6912,6987),
(6992,7036)
);

const PUCUUnicodeIgnoreCaseScriptBlocks63:array[0..3] of TPUCUUnicodeCharRange=(
(73728,74649),
(74752,74862),
(74864,74868),
(74880,75075)
);

const PUCUUnicodeIgnoreCaseScriptBlocks64:array[0..1] of TPUCUUnicodeCharRange=(
(67840,67867),
(67871,67871)
);

const PUCUUnicodeIgnoreCaseScriptBlocks65:array[0..0] of TPUCUUnicodeCharRange=(
(43072,43127)
);

const PUCUUnicodeIgnoreCaseScriptBlocks66:array[0..0] of TPUCUUnicodeCharRange=(
(1984,2042)
);

const PUCUUnicodeIgnoreCaseScriptBlocks67:array[0..1] of TPUCUUnicodeCharRange=(
(7040,7103),
(7360,7367)
);

const PUCUUnicodeIgnoreCaseScriptBlocks68:array[0..2] of TPUCUUnicodeCharRange=(
(7168,7223),
(7227,7241),
(7245,7247)
);

const PUCUUnicodeIgnoreCaseScriptBlocks69:array[0..0] of TPUCUUnicodeCharRange=(
(7248,7295)
);

const PUCUUnicodeIgnoreCaseScriptBlocks70:array[0..0] of TPUCUUnicodeCharRange=(
(42240,42539)
);

const PUCUUnicodeIgnoreCaseScriptBlocks71:array[0..1] of TPUCUUnicodeCharRange=(
(43136,43205),
(43214,43225)
);

const PUCUUnicodeIgnoreCaseScriptBlocks72:array[0..1] of TPUCUUnicodeCharRange=(
(43264,43309),
(43311,43311)
);

const PUCUUnicodeIgnoreCaseScriptBlocks73:array[0..1] of TPUCUUnicodeCharRange=(
(43312,43347),
(43359,43359)
);

const PUCUUnicodeIgnoreCaseScriptBlocks74:array[0..0] of TPUCUUnicodeCharRange=(
(66176,66204)
);

const PUCUUnicodeIgnoreCaseScriptBlocks75:array[0..0] of TPUCUUnicodeCharRange=(
(66208,66256)
);

const PUCUUnicodeIgnoreCaseScriptBlocks76:array[0..1] of TPUCUUnicodeCharRange=(
(67872,67897),
(67903,67903)
);

const PUCUUnicodeIgnoreCaseScriptBlocks77:array[0..3] of TPUCUUnicodeCharRange=(
(43520,43574),
(43584,43597),
(43600,43609),
(43612,43615)
);

const PUCUUnicodeIgnoreCaseScriptBlocks78:array[0..4] of TPUCUUnicodeCharRange=(
(6688,6750),
(6752,6780),
(6783,6793),
(6800,6809),
(6816,6829)
);

const PUCUUnicodeIgnoreCaseScriptBlocks79:array[0..1] of TPUCUUnicodeCharRange=(
(43648,43714),
(43739,43743)
);

const PUCUUnicodeIgnoreCaseScriptBlocks80:array[0..1] of TPUCUUnicodeCharRange=(
(68352,68405),
(68409,68415)
);

const PUCUUnicodeIgnoreCaseScriptBlocks81:array[0..0] of TPUCUUnicodeCharRange=(
(77824,78894)
);

const PUCUUnicodeIgnoreCaseScriptBlocks82:array[0..1] of TPUCUUnicodeCharRange=(
(2048,2093),
(2096,2110)
);

const PUCUUnicodeIgnoreCaseScriptBlocks83:array[0..0] of TPUCUUnicodeCharRange=(
(42192,42239)
);

const PUCUUnicodeIgnoreCaseScriptBlocks84:array[0..1] of TPUCUUnicodeCharRange=(
(42656,42743),
(92160,92728)
);

const PUCUUnicodeIgnoreCaseScriptBlocks85:array[0..2] of TPUCUUnicodeCharRange=(
(43392,43469),
(43472,43481),
(43486,43487)
);

const PUCUUnicodeIgnoreCaseScriptBlocks86:array[0..2] of TPUCUUnicodeCharRange=(
(43744,43766),
(43968,44013),
(44016,44025)
);

const PUCUUnicodeIgnoreCaseScriptBlocks87:array[0..1] of TPUCUUnicodeCharRange=(
(67648,67669),
(67671,67679)
);

const PUCUUnicodeIgnoreCaseScriptBlocks88:array[0..0] of TPUCUUnicodeCharRange=(
(68192,68223)
);

const PUCUUnicodeIgnoreCaseScriptBlocks89:array[0..1] of TPUCUUnicodeCharRange=(
(68416,68437),
(68440,68447)
);

const PUCUUnicodeIgnoreCaseScriptBlocks90:array[0..1] of TPUCUUnicodeCharRange=(
(68448,68466),
(68472,68479)
);

const PUCUUnicodeIgnoreCaseScriptBlocks91:array[0..0] of TPUCUUnicodeCharRange=(
(68608,68680)
);

const PUCUUnicodeIgnoreCaseScriptBlocks92:array[0..0] of TPUCUUnicodeCharRange=(
(69760,69825)
);

const PUCUUnicodeIgnoreCaseScriptBlocks93:array[0..1] of TPUCUUnicodeCharRange=(
(7104,7155),
(7164,7167)
);

const PUCUUnicodeIgnoreCaseScriptBlocks94:array[0..2] of TPUCUUnicodeCharRange=(
(69632,69709),
(69714,69743),
(69759,69759)
);

const PUCUUnicodeIgnoreCaseScriptBlocks95:array[0..1] of TPUCUUnicodeCharRange=(
(2112,2139),
(2142,2142)
);

const PUCUUnicodeIgnoreCaseScriptBlocks96:array[0..1] of TPUCUUnicodeCharRange=(
(69888,69940),
(69942,69955)
);

const PUCUUnicodeIgnoreCaseScriptBlocks97:array[0..2] of TPUCUUnicodeCharRange=(
(68000,68023),
(68028,68047),
(68050,68095)
);

const PUCUUnicodeIgnoreCaseScriptBlocks98:array[0..0] of TPUCUUnicodeCharRange=(
(67968,67999)
);

const PUCUUnicodeIgnoreCaseScriptBlocks99:array[0..2] of TPUCUUnicodeCharRange=(
(93952,94020),
(94032,94078),
(94095,94111)
);

const PUCUUnicodeIgnoreCaseScriptBlocks100:array[0..1] of TPUCUUnicodeCharRange=(
(70016,70093),
(70096,70111)
);

const PUCUUnicodeIgnoreCaseScriptBlocks101:array[0..1] of TPUCUUnicodeCharRange=(
(69840,69864),
(69872,69881)
);

const PUCUUnicodeIgnoreCaseScriptBlocks102:array[0..1] of TPUCUUnicodeCharRange=(
(71296,71351),
(71360,71369)
);

const PUCUUnicodeIgnoreCaseScriptBlocks103:array[0..1] of TPUCUUnicodeCharRange=(
(66864,66915),
(66927,66927)
);

const PUCUUnicodeIgnoreCaseScriptBlocks104:array[0..1] of TPUCUUnicodeCharRange=(
(92880,92909),
(92912,92917)
);

const PUCUUnicodeIgnoreCaseScriptBlocks105:array[0..4] of TPUCUUnicodeCharRange=(
(113664,113770),
(113776,113788),
(113792,113800),
(113808,113817),
(113820,113823)
);

const PUCUUnicodeIgnoreCaseScriptBlocks106:array[0..0] of TPUCUUnicodeCharRange=(
(66816,66855)
);

const PUCUUnicodeIgnoreCaseScriptBlocks107:array[0..14] of TPUCUUnicodeCharRange=(
(70400,70403),
(70405,70412),
(70415,70416),
(70419,70440),
(70442,70448),
(70450,70451),
(70453,70457),
(70460,70468),
(70471,70472),
(70475,70477),
(70480,70480),
(70487,70487),
(70493,70499),
(70502,70508),
(70512,70516)
);

const PUCUUnicodeIgnoreCaseScriptBlocks108:array[0..4] of TPUCUUnicodeCharRange=(
(92928,92997),
(93008,93017),
(93019,93025),
(93027,93047),
(93053,93071)
);

const PUCUUnicodeIgnoreCaseScriptBlocks109:array[0..1] of TPUCUUnicodeCharRange=(
(70144,70161),
(70163,70206)
);

const PUCUUnicodeIgnoreCaseScriptBlocks110:array[0..2] of TPUCUUnicodeCharRange=(
(67072,67382),
(67392,67413),
(67424,67431)
);

const PUCUUnicodeIgnoreCaseScriptBlocks111:array[0..0] of TPUCUUnicodeCharRange=(
(69968,70006)
);

const PUCUUnicodeIgnoreCaseScriptBlocks112:array[0..1] of TPUCUUnicodeCharRange=(
(68288,68326),
(68331,68342)
);

const PUCUUnicodeIgnoreCaseScriptBlocks113:array[0..1] of TPUCUUnicodeCharRange=(
(124928,125124),
(125127,125142)
);

const PUCUUnicodeIgnoreCaseScriptBlocks114:array[0..1] of TPUCUUnicodeCharRange=(
(71168,71236),
(71248,71257)
);

const PUCUUnicodeIgnoreCaseScriptBlocks115:array[0..2] of TPUCUUnicodeCharRange=(
(92736,92766),
(92768,92777),
(92782,92783)
);

const PUCUUnicodeIgnoreCaseScriptBlocks116:array[0..0] of TPUCUUnicodeCharRange=(
(68224,68255)
);

const PUCUUnicodeIgnoreCaseScriptBlocks117:array[0..1] of TPUCUUnicodeCharRange=(
(67712,67742),
(67751,67759)
);

const PUCUUnicodeIgnoreCaseScriptBlocks118:array[0..0] of TPUCUUnicodeCharRange=(
(67680,67711)
);

const PUCUUnicodeIgnoreCaseScriptBlocks119:array[0..0] of TPUCUUnicodeCharRange=(
(72384,72440)
);

const PUCUUnicodeIgnoreCaseScriptBlocks120:array[0..0] of TPUCUUnicodeCharRange=(
(66384,66426)
);

const PUCUUnicodeIgnoreCaseScriptBlocks121:array[0..2] of TPUCUUnicodeCharRange=(
(68480,68497),
(68505,68508),
(68521,68527)
);

const PUCUUnicodeIgnoreCaseScriptBlocks122:array[0..1] of TPUCUUnicodeCharRange=(
(71040,71093),
(71096,71133)
);

const PUCUUnicodeIgnoreCaseScriptBlocks123:array[0..1] of TPUCUUnicodeCharRange=(
(70320,70378),
(70384,70393)
);

const PUCUUnicodeIgnoreCaseScriptBlocks124:array[0..1] of TPUCUUnicodeCharRange=(
(70784,70855),
(70864,70873)
);

const PUCUUnicodeIgnoreCaseScriptBlocks125:array[0..1] of TPUCUUnicodeCharRange=(
(71840,71922),
(71935,71935)
);

const PUCUUnicodeIgnoreCaseScriptBlocks126:array[0..2] of TPUCUUnicodeCharRange=(
(71424,71449),
(71453,71467),
(71472,71487)
);

const PUCUUnicodeIgnoreCaseScriptBlocks127:array[0..0] of TPUCUUnicodeCharRange=(
(82944,83526)
);

const PUCUUnicodeIgnoreCaseScriptBlocks128:array[0..2] of TPUCUUnicodeCharRange=(
(67808,67826),
(67828,67829),
(67835,67839)
);

const PUCUUnicodeIgnoreCaseScriptBlocks129:array[0..4] of TPUCUUnicodeCharRange=(
(70272,70278),
(70280,70280),
(70282,70285),
(70287,70301),
(70303,70313)
);

const PUCUUnicodeIgnoreCaseScriptBlocks130:array[0..2] of TPUCUUnicodeCharRange=(
(68736,68786),
(68800,68850),
(68858,68863)
);

const PUCUUnicodeIgnoreCaseScriptBlocks131:array[0..2] of TPUCUUnicodeCharRange=(
(120832,121483),
(121499,121503),
(121505,121519)
);

const PUCUUnicodeIgnoreCaseScriptBlocks132:array[0..2] of TPUCUUnicodeCharRange=(
(125184,125258),
(125264,125273),
(125278,125279)
);

const PUCUUnicodeIgnoreCaseScriptBlocks133:array[0..3] of TPUCUUnicodeCharRange=(
(72704,72712),
(72714,72758),
(72760,72773),
(72784,72812)
);

const PUCUUnicodeIgnoreCaseScriptBlocks134:array[0..2] of TPUCUUnicodeCharRange=(
(72816,72847),
(72850,72871),
(72873,72886)
);

const PUCUUnicodeIgnoreCaseScriptBlocks135:array[0..2] of TPUCUUnicodeCharRange=(
(70656,70745),
(70747,70747),
(70749,70749)
);

const PUCUUnicodeIgnoreCaseScriptBlocks136:array[0..1] of TPUCUUnicodeCharRange=(
(66736,66771),
(66776,66811)
);

const PUCUUnicodeIgnoreCaseScriptBlocks137:array[0..2] of TPUCUUnicodeCharRange=(
(94176,94176),
(94208,100332),
(100352,101106)
);

const PUCUUnicodeIgnoreCaseScriptBlocksData:array[0..137] of pointer=(
@PUCUUnicodeIgnoreCaseScriptBlocks0,
@PUCUUnicodeIgnoreCaseScriptBlocks1,
@PUCUUnicodeIgnoreCaseScriptBlocks2,
@PUCUUnicodeIgnoreCaseScriptBlocks3,
@PUCUUnicodeIgnoreCaseScriptBlocks4,
@PUCUUnicodeIgnoreCaseScriptBlocks5,
@PUCUUnicodeIgnoreCaseScriptBlocks6,
@PUCUUnicodeIgnoreCaseScriptBlocks7,
@PUCUUnicodeIgnoreCaseScriptBlocks8,
@PUCUUnicodeIgnoreCaseScriptBlocks9,
@PUCUUnicodeIgnoreCaseScriptBlocks10,
@PUCUUnicodeIgnoreCaseScriptBlocks11,
@PUCUUnicodeIgnoreCaseScriptBlocks12,
@PUCUUnicodeIgnoreCaseScriptBlocks13,
@PUCUUnicodeIgnoreCaseScriptBlocks14,
@PUCUUnicodeIgnoreCaseScriptBlocks15,
@PUCUUnicodeIgnoreCaseScriptBlocks16,
@PUCUUnicodeIgnoreCaseScriptBlocks17,
@PUCUUnicodeIgnoreCaseScriptBlocks18,
@PUCUUnicodeIgnoreCaseScriptBlocks19,
@PUCUUnicodeIgnoreCaseScriptBlocks20,
@PUCUUnicodeIgnoreCaseScriptBlocks21,
@PUCUUnicodeIgnoreCaseScriptBlocks22,
@PUCUUnicodeIgnoreCaseScriptBlocks23,
@PUCUUnicodeIgnoreCaseScriptBlocks24,
@PUCUUnicodeIgnoreCaseScriptBlocks25,
@PUCUUnicodeIgnoreCaseScriptBlocks26,
@PUCUUnicodeIgnoreCaseScriptBlocks27,
@PUCUUnicodeIgnoreCaseScriptBlocks28,
@PUCUUnicodeIgnoreCaseScriptBlocks29,
@PUCUUnicodeIgnoreCaseScriptBlocks30,
@PUCUUnicodeIgnoreCaseScriptBlocks31,
@PUCUUnicodeIgnoreCaseScriptBlocks32,
@PUCUUnicodeIgnoreCaseScriptBlocks33,
@PUCUUnicodeIgnoreCaseScriptBlocks34,
@PUCUUnicodeIgnoreCaseScriptBlocks35,
@PUCUUnicodeIgnoreCaseScriptBlocks36,
@PUCUUnicodeIgnoreCaseScriptBlocks37,
@PUCUUnicodeIgnoreCaseScriptBlocks38,
@PUCUUnicodeIgnoreCaseScriptBlocks39,
@PUCUUnicodeIgnoreCaseScriptBlocks40,
@PUCUUnicodeIgnoreCaseScriptBlocks41,
@PUCUUnicodeIgnoreCaseScriptBlocks42,
@PUCUUnicodeIgnoreCaseScriptBlocks43,
@PUCUUnicodeIgnoreCaseScriptBlocks44,
@PUCUUnicodeIgnoreCaseScriptBlocks45,
@PUCUUnicodeIgnoreCaseScriptBlocks46,
@PUCUUnicodeIgnoreCaseScriptBlocks47,
@PUCUUnicodeIgnoreCaseScriptBlocks48,
@PUCUUnicodeIgnoreCaseScriptBlocks49,
@PUCUUnicodeIgnoreCaseScriptBlocks50,
@PUCUUnicodeIgnoreCaseScriptBlocks51,
@PUCUUnicodeIgnoreCaseScriptBlocks52,
@PUCUUnicodeIgnoreCaseScriptBlocks53,
@PUCUUnicodeIgnoreCaseScriptBlocks54,
@PUCUUnicodeIgnoreCaseScriptBlocks55,
@PUCUUnicodeIgnoreCaseScriptBlocks56,
@PUCUUnicodeIgnoreCaseScriptBlocks57,
@PUCUUnicodeIgnoreCaseScriptBlocks58,
@PUCUUnicodeIgnoreCaseScriptBlocks59,
@PUCUUnicodeIgnoreCaseScriptBlocks60,
@PUCUUnicodeIgnoreCaseScriptBlocks61,
@PUCUUnicodeIgnoreCaseScriptBlocks62,
@PUCUUnicodeIgnoreCaseScriptBlocks63,
@PUCUUnicodeIgnoreCaseScriptBlocks64,
@PUCUUnicodeIgnoreCaseScriptBlocks65,
@PUCUUnicodeIgnoreCaseScriptBlocks66,
@PUCUUnicodeIgnoreCaseScriptBlocks67,
@PUCUUnicodeIgnoreCaseScriptBlocks68,
@PUCUUnicodeIgnoreCaseScriptBlocks69,
@PUCUUnicodeIgnoreCaseScriptBlocks70,
@PUCUUnicodeIgnoreCaseScriptBlocks71,
@PUCUUnicodeIgnoreCaseScriptBlocks72,
@PUCUUnicodeIgnoreCaseScriptBlocks73,
@PUCUUnicodeIgnoreCaseScriptBlocks74,
@PUCUUnicodeIgnoreCaseScriptBlocks75,
@PUCUUnicodeIgnoreCaseScriptBlocks76,
@PUCUUnicodeIgnoreCaseScriptBlocks77,
@PUCUUnicodeIgnoreCaseScriptBlocks78,
@PUCUUnicodeIgnoreCaseScriptBlocks79,
@PUCUUnicodeIgnoreCaseScriptBlocks80,
@PUCUUnicodeIgnoreCaseScriptBlocks81,
@PUCUUnicodeIgnoreCaseScriptBlocks82,
@PUCUUnicodeIgnoreCaseScriptBlocks83,
@PUCUUnicodeIgnoreCaseScriptBlocks84,
@PUCUUnicodeIgnoreCaseScriptBlocks85,
@PUCUUnicodeIgnoreCaseScriptBlocks86,
@PUCUUnicodeIgnoreCaseScriptBlocks87,
@PUCUUnicodeIgnoreCaseScriptBlocks88,
@PUCUUnicodeIgnoreCaseScriptBlocks89,
@PUCUUnicodeIgnoreCaseScriptBlocks90,
@PUCUUnicodeIgnoreCaseScriptBlocks91,
@PUCUUnicodeIgnoreCaseScriptBlocks92,
@PUCUUnicodeIgnoreCaseScriptBlocks93,
@PUCUUnicodeIgnoreCaseScriptBlocks94,
@PUCUUnicodeIgnoreCaseScriptBlocks95,
@PUCUUnicodeIgnoreCaseScriptBlocks96,
@PUCUUnicodeIgnoreCaseScriptBlocks97,
@PUCUUnicodeIgnoreCaseScriptBlocks98,
@PUCUUnicodeIgnoreCaseScriptBlocks99,
@PUCUUnicodeIgnoreCaseScriptBlocks100,
@PUCUUnicodeIgnoreCaseScriptBlocks101,
@PUCUUnicodeIgnoreCaseScriptBlocks102,
@PUCUUnicodeIgnoreCaseScriptBlocks103,
@PUCUUnicodeIgnoreCaseScriptBlocks104,
@PUCUUnicodeIgnoreCaseScriptBlocks105,
@PUCUUnicodeIgnoreCaseScriptBlocks106,
@PUCUUnicodeIgnoreCaseScriptBlocks107,
@PUCUUnicodeIgnoreCaseScriptBlocks108,
@PUCUUnicodeIgnoreCaseScriptBlocks109,
@PUCUUnicodeIgnoreCaseScriptBlocks110,
@PUCUUnicodeIgnoreCaseScriptBlocks111,
@PUCUUnicodeIgnoreCaseScriptBlocks112,
@PUCUUnicodeIgnoreCaseScriptBlocks113,
@PUCUUnicodeIgnoreCaseScriptBlocks114,
@PUCUUnicodeIgnoreCaseScriptBlocks115,
@PUCUUnicodeIgnoreCaseScriptBlocks116,
@PUCUUnicodeIgnoreCaseScriptBlocks117,
@PUCUUnicodeIgnoreCaseScriptBlocks118,
@PUCUUnicodeIgnoreCaseScriptBlocks119,
@PUCUUnicodeIgnoreCaseScriptBlocks120,
@PUCUUnicodeIgnoreCaseScriptBlocks121,
@PUCUUnicodeIgnoreCaseScriptBlocks122,
@PUCUUnicodeIgnoreCaseScriptBlocks123,
@PUCUUnicodeIgnoreCaseScriptBlocks124,
@PUCUUnicodeIgnoreCaseScriptBlocks125,
@PUCUUnicodeIgnoreCaseScriptBlocks126,
@PUCUUnicodeIgnoreCaseScriptBlocks127,
@PUCUUnicodeIgnoreCaseScriptBlocks128,
@PUCUUnicodeIgnoreCaseScriptBlocks129,
@PUCUUnicodeIgnoreCaseScriptBlocks130,
@PUCUUnicodeIgnoreCaseScriptBlocks131,
@PUCUUnicodeIgnoreCaseScriptBlocks132,
@PUCUUnicodeIgnoreCaseScriptBlocks133,
@PUCUUnicodeIgnoreCaseScriptBlocks134,
@PUCUUnicodeIgnoreCaseScriptBlocks135,
@PUCUUnicodeIgnoreCaseScriptBlocks136,
@PUCUUnicodeIgnoreCaseScriptBlocks137
);

const PUCUUnicodeIgnoreCaseScriptBlocksCounts:array[0..137] of longint=(
636,
166,
31,
36,
8,
6,
9,
56,
3,
1,
4,
14,
16,
14,
14,
16,
13,
14,
9,
13,
2,
18,
7,
3,
8,
14,
32,
3,
2,
1,
2,
4,
7,
4,
8,
3,
16,
2,
1,
1,
1,
28,
2,
1,
1,
3,
5,
2,
7,
2,
1,
2,
6,
1,
2,
3,
4,
7,
3,
1,
2,
8,
2,
4,
2,
1,
1,
2,
3,
1,
1,
2,
2,
2,
1,
1,
2,
4,
5,
2,
2,
1,
2,
1,
2,
3,
3,
2,
1,
2,
2,
1,
1,
2,
3,
2,
2,
3,
1,
3,
2,
2,
2,
2,
2,
5,
1,
15,
5,
2,
3,
1,
2,
2,
2,
3,
1,
2,
1,
1,
1,
3,
2,
2,
2,
2,
3,
1,
3,
5,
3,
3,
3,
4,
3,
3,
2,
3
);

const PUCUCountUnicodeBlockBlocks=272;

const PUCUUnicodeBlockBlocks0:array[0..0] of TPUCUUnicodeCharRange=(
(0,127)
);

const PUCUUnicodeBlockBlocks1:array[0..0] of TPUCUUnicodeCharRange=(
(128,255)
);

const PUCUUnicodeBlockBlocks2:array[0..0] of TPUCUUnicodeCharRange=(
(256,383)
);

const PUCUUnicodeBlockBlocks3:array[0..0] of TPUCUUnicodeCharRange=(
(384,591)
);

const PUCUUnicodeBlockBlocks4:array[0..0] of TPUCUUnicodeCharRange=(
(592,687)
);

const PUCUUnicodeBlockBlocks5:array[0..0] of TPUCUUnicodeCharRange=(
(688,767)
);

const PUCUUnicodeBlockBlocks6:array[0..0] of TPUCUUnicodeCharRange=(
(768,879)
);

const PUCUUnicodeBlockBlocks7:array[0..0] of TPUCUUnicodeCharRange=(
(880,1023)
);

const PUCUUnicodeBlockBlocks8:array[0..0] of TPUCUUnicodeCharRange=(
(1024,1279)
);

const PUCUUnicodeBlockBlocks9:array[0..0] of TPUCUUnicodeCharRange=(
(1280,1327)
);

const PUCUUnicodeBlockBlocks10:array[0..0] of TPUCUUnicodeCharRange=(
(1328,1423)
);

const PUCUUnicodeBlockBlocks11:array[0..0] of TPUCUUnicodeCharRange=(
(1424,1535)
);

const PUCUUnicodeBlockBlocks12:array[0..0] of TPUCUUnicodeCharRange=(
(1536,1791)
);

const PUCUUnicodeBlockBlocks13:array[0..0] of TPUCUUnicodeCharRange=(
(1792,1871)
);

const PUCUUnicodeBlockBlocks14:array[0..0] of TPUCUUnicodeCharRange=(
(1872,1919)
);

const PUCUUnicodeBlockBlocks15:array[0..0] of TPUCUUnicodeCharRange=(
(1920,1983)
);

const PUCUUnicodeBlockBlocks16:array[0..0] of TPUCUUnicodeCharRange=(
(1984,2047)
);

const PUCUUnicodeBlockBlocks17:array[0..0] of TPUCUUnicodeCharRange=(
(2048,2111)
);

const PUCUUnicodeBlockBlocks18:array[0..0] of TPUCUUnicodeCharRange=(
(2112,2143)
);

const PUCUUnicodeBlockBlocks19:array[0..0] of TPUCUUnicodeCharRange=(
(2208,2303)
);

const PUCUUnicodeBlockBlocks20:array[0..0] of TPUCUUnicodeCharRange=(
(2304,2431)
);

const PUCUUnicodeBlockBlocks21:array[0..0] of TPUCUUnicodeCharRange=(
(2432,2559)
);

const PUCUUnicodeBlockBlocks22:array[0..0] of TPUCUUnicodeCharRange=(
(2560,2687)
);

const PUCUUnicodeBlockBlocks23:array[0..0] of TPUCUUnicodeCharRange=(
(2688,2815)
);

const PUCUUnicodeBlockBlocks24:array[0..0] of TPUCUUnicodeCharRange=(
(2816,2943)
);

const PUCUUnicodeBlockBlocks25:array[0..0] of TPUCUUnicodeCharRange=(
(2944,3071)
);

const PUCUUnicodeBlockBlocks26:array[0..0] of TPUCUUnicodeCharRange=(
(3072,3199)
);

const PUCUUnicodeBlockBlocks27:array[0..0] of TPUCUUnicodeCharRange=(
(3200,3327)
);

const PUCUUnicodeBlockBlocks28:array[0..0] of TPUCUUnicodeCharRange=(
(3328,3455)
);

const PUCUUnicodeBlockBlocks29:array[0..0] of TPUCUUnicodeCharRange=(
(3456,3583)
);

const PUCUUnicodeBlockBlocks30:array[0..0] of TPUCUUnicodeCharRange=(
(3584,3711)
);

const PUCUUnicodeBlockBlocks31:array[0..0] of TPUCUUnicodeCharRange=(
(3712,3839)
);

const PUCUUnicodeBlockBlocks32:array[0..0] of TPUCUUnicodeCharRange=(
(3840,4095)
);

const PUCUUnicodeBlockBlocks33:array[0..0] of TPUCUUnicodeCharRange=(
(4096,4255)
);

const PUCUUnicodeBlockBlocks34:array[0..0] of TPUCUUnicodeCharRange=(
(4256,4351)
);

const PUCUUnicodeBlockBlocks35:array[0..0] of TPUCUUnicodeCharRange=(
(4352,4607)
);

const PUCUUnicodeBlockBlocks36:array[0..0] of TPUCUUnicodeCharRange=(
(4608,4991)
);

const PUCUUnicodeBlockBlocks37:array[0..0] of TPUCUUnicodeCharRange=(
(4992,5023)
);

const PUCUUnicodeBlockBlocks38:array[0..0] of TPUCUUnicodeCharRange=(
(5024,5119)
);

const PUCUUnicodeBlockBlocks39:array[0..0] of TPUCUUnicodeCharRange=(
(5120,5759)
);

const PUCUUnicodeBlockBlocks40:array[0..0] of TPUCUUnicodeCharRange=(
(5760,5791)
);

const PUCUUnicodeBlockBlocks41:array[0..0] of TPUCUUnicodeCharRange=(
(5792,5887)
);

const PUCUUnicodeBlockBlocks42:array[0..0] of TPUCUUnicodeCharRange=(
(5888,5919)
);

const PUCUUnicodeBlockBlocks43:array[0..0] of TPUCUUnicodeCharRange=(
(5920,5951)
);

const PUCUUnicodeBlockBlocks44:array[0..0] of TPUCUUnicodeCharRange=(
(5952,5983)
);

const PUCUUnicodeBlockBlocks45:array[0..0] of TPUCUUnicodeCharRange=(
(5984,6015)
);

const PUCUUnicodeBlockBlocks46:array[0..0] of TPUCUUnicodeCharRange=(
(6016,6143)
);

const PUCUUnicodeBlockBlocks47:array[0..0] of TPUCUUnicodeCharRange=(
(6144,6319)
);

const PUCUUnicodeBlockBlocks48:array[0..0] of TPUCUUnicodeCharRange=(
(6320,6399)
);

const PUCUUnicodeBlockBlocks49:array[0..0] of TPUCUUnicodeCharRange=(
(6400,6479)
);

const PUCUUnicodeBlockBlocks50:array[0..0] of TPUCUUnicodeCharRange=(
(6480,6527)
);

const PUCUUnicodeBlockBlocks51:array[0..0] of TPUCUUnicodeCharRange=(
(6528,6623)
);

const PUCUUnicodeBlockBlocks52:array[0..0] of TPUCUUnicodeCharRange=(
(6624,6655)
);

const PUCUUnicodeBlockBlocks53:array[0..0] of TPUCUUnicodeCharRange=(
(6656,6687)
);

const PUCUUnicodeBlockBlocks54:array[0..0] of TPUCUUnicodeCharRange=(
(6688,6831)
);

const PUCUUnicodeBlockBlocks55:array[0..0] of TPUCUUnicodeCharRange=(
(6832,6911)
);

const PUCUUnicodeBlockBlocks56:array[0..0] of TPUCUUnicodeCharRange=(
(6912,7039)
);

const PUCUUnicodeBlockBlocks57:array[0..0] of TPUCUUnicodeCharRange=(
(7040,7103)
);

const PUCUUnicodeBlockBlocks58:array[0..0] of TPUCUUnicodeCharRange=(
(7104,7167)
);

const PUCUUnicodeBlockBlocks59:array[0..0] of TPUCUUnicodeCharRange=(
(7168,7247)
);

const PUCUUnicodeBlockBlocks60:array[0..0] of TPUCUUnicodeCharRange=(
(7248,7295)
);

const PUCUUnicodeBlockBlocks61:array[0..0] of TPUCUUnicodeCharRange=(
(7296,7311)
);

const PUCUUnicodeBlockBlocks62:array[0..0] of TPUCUUnicodeCharRange=(
(7360,7375)
);

const PUCUUnicodeBlockBlocks63:array[0..0] of TPUCUUnicodeCharRange=(
(7376,7423)
);

const PUCUUnicodeBlockBlocks64:array[0..0] of TPUCUUnicodeCharRange=(
(7424,7551)
);

const PUCUUnicodeBlockBlocks65:array[0..0] of TPUCUUnicodeCharRange=(
(7552,7615)
);

const PUCUUnicodeBlockBlocks66:array[0..0] of TPUCUUnicodeCharRange=(
(7616,7679)
);

const PUCUUnicodeBlockBlocks67:array[0..0] of TPUCUUnicodeCharRange=(
(7680,7935)
);

const PUCUUnicodeBlockBlocks68:array[0..0] of TPUCUUnicodeCharRange=(
(7936,8191)
);

const PUCUUnicodeBlockBlocks69:array[0..0] of TPUCUUnicodeCharRange=(
(8192,8303)
);

const PUCUUnicodeBlockBlocks70:array[0..0] of TPUCUUnicodeCharRange=(
(8304,8351)
);

const PUCUUnicodeBlockBlocks71:array[0..0] of TPUCUUnicodeCharRange=(
(8352,8399)
);

const PUCUUnicodeBlockBlocks72:array[0..0] of TPUCUUnicodeCharRange=(
(8400,8447)
);

const PUCUUnicodeBlockBlocks73:array[0..0] of TPUCUUnicodeCharRange=(
(8448,8527)
);

const PUCUUnicodeBlockBlocks74:array[0..0] of TPUCUUnicodeCharRange=(
(8528,8591)
);

const PUCUUnicodeBlockBlocks75:array[0..0] of TPUCUUnicodeCharRange=(
(8592,8703)
);

const PUCUUnicodeBlockBlocks76:array[0..0] of TPUCUUnicodeCharRange=(
(8704,8959)
);

const PUCUUnicodeBlockBlocks77:array[0..0] of TPUCUUnicodeCharRange=(
(8960,9215)
);

const PUCUUnicodeBlockBlocks78:array[0..0] of TPUCUUnicodeCharRange=(
(9216,9279)
);

const PUCUUnicodeBlockBlocks79:array[0..0] of TPUCUUnicodeCharRange=(
(9280,9311)
);

const PUCUUnicodeBlockBlocks80:array[0..0] of TPUCUUnicodeCharRange=(
(9312,9471)
);

const PUCUUnicodeBlockBlocks81:array[0..0] of TPUCUUnicodeCharRange=(
(9472,9599)
);

const PUCUUnicodeBlockBlocks82:array[0..0] of TPUCUUnicodeCharRange=(
(9600,9631)
);

const PUCUUnicodeBlockBlocks83:array[0..0] of TPUCUUnicodeCharRange=(
(9632,9727)
);

const PUCUUnicodeBlockBlocks84:array[0..0] of TPUCUUnicodeCharRange=(
(9728,9983)
);

const PUCUUnicodeBlockBlocks85:array[0..0] of TPUCUUnicodeCharRange=(
(9984,10175)
);

const PUCUUnicodeBlockBlocks86:array[0..0] of TPUCUUnicodeCharRange=(
(10176,10223)
);

const PUCUUnicodeBlockBlocks87:array[0..0] of TPUCUUnicodeCharRange=(
(10224,10239)
);

const PUCUUnicodeBlockBlocks88:array[0..0] of TPUCUUnicodeCharRange=(
(10240,10495)
);

const PUCUUnicodeBlockBlocks89:array[0..0] of TPUCUUnicodeCharRange=(
(10496,10623)
);

const PUCUUnicodeBlockBlocks90:array[0..0] of TPUCUUnicodeCharRange=(
(10624,10751)
);

const PUCUUnicodeBlockBlocks91:array[0..0] of TPUCUUnicodeCharRange=(
(10752,11007)
);

const PUCUUnicodeBlockBlocks92:array[0..0] of TPUCUUnicodeCharRange=(
(11008,11263)
);

const PUCUUnicodeBlockBlocks93:array[0..0] of TPUCUUnicodeCharRange=(
(11264,11359)
);

const PUCUUnicodeBlockBlocks94:array[0..0] of TPUCUUnicodeCharRange=(
(11360,11391)
);

const PUCUUnicodeBlockBlocks95:array[0..0] of TPUCUUnicodeCharRange=(
(11392,11519)
);

const PUCUUnicodeBlockBlocks96:array[0..0] of TPUCUUnicodeCharRange=(
(11520,11567)
);

const PUCUUnicodeBlockBlocks97:array[0..0] of TPUCUUnicodeCharRange=(
(11568,11647)
);

const PUCUUnicodeBlockBlocks98:array[0..0] of TPUCUUnicodeCharRange=(
(11648,11743)
);

const PUCUUnicodeBlockBlocks99:array[0..0] of TPUCUUnicodeCharRange=(
(11744,11775)
);

const PUCUUnicodeBlockBlocks100:array[0..0] of TPUCUUnicodeCharRange=(
(11776,11903)
);

const PUCUUnicodeBlockBlocks101:array[0..0] of TPUCUUnicodeCharRange=(
(11904,12031)
);

const PUCUUnicodeBlockBlocks102:array[0..0] of TPUCUUnicodeCharRange=(
(12032,12255)
);

const PUCUUnicodeBlockBlocks103:array[0..0] of TPUCUUnicodeCharRange=(
(12272,12287)
);

const PUCUUnicodeBlockBlocks104:array[0..0] of TPUCUUnicodeCharRange=(
(12288,12351)
);

const PUCUUnicodeBlockBlocks105:array[0..0] of TPUCUUnicodeCharRange=(
(12352,12447)
);

const PUCUUnicodeBlockBlocks106:array[0..0] of TPUCUUnicodeCharRange=(
(12448,12543)
);

const PUCUUnicodeBlockBlocks107:array[0..0] of TPUCUUnicodeCharRange=(
(12544,12591)
);

const PUCUUnicodeBlockBlocks108:array[0..0] of TPUCUUnicodeCharRange=(
(12592,12687)
);

const PUCUUnicodeBlockBlocks109:array[0..0] of TPUCUUnicodeCharRange=(
(12688,12703)
);

const PUCUUnicodeBlockBlocks110:array[0..0] of TPUCUUnicodeCharRange=(
(12704,12735)
);

const PUCUUnicodeBlockBlocks111:array[0..0] of TPUCUUnicodeCharRange=(
(12736,12783)
);

const PUCUUnicodeBlockBlocks112:array[0..0] of TPUCUUnicodeCharRange=(
(12784,12799)
);

const PUCUUnicodeBlockBlocks113:array[0..0] of TPUCUUnicodeCharRange=(
(12800,13055)
);

const PUCUUnicodeBlockBlocks114:array[0..0] of TPUCUUnicodeCharRange=(
(13056,13311)
);

const PUCUUnicodeBlockBlocks115:array[0..0] of TPUCUUnicodeCharRange=(
(13312,19903)
);

const PUCUUnicodeBlockBlocks116:array[0..0] of TPUCUUnicodeCharRange=(
(19904,19967)
);

const PUCUUnicodeBlockBlocks117:array[0..0] of TPUCUUnicodeCharRange=(
(19968,40959)
);

const PUCUUnicodeBlockBlocks118:array[0..0] of TPUCUUnicodeCharRange=(
(40960,42127)
);

const PUCUUnicodeBlockBlocks119:array[0..0] of TPUCUUnicodeCharRange=(
(42128,42191)
);

const PUCUUnicodeBlockBlocks120:array[0..0] of TPUCUUnicodeCharRange=(
(42192,42239)
);

const PUCUUnicodeBlockBlocks121:array[0..0] of TPUCUUnicodeCharRange=(
(42240,42559)
);

const PUCUUnicodeBlockBlocks122:array[0..0] of TPUCUUnicodeCharRange=(
(42560,42655)
);

const PUCUUnicodeBlockBlocks123:array[0..0] of TPUCUUnicodeCharRange=(
(42656,42751)
);

const PUCUUnicodeBlockBlocks124:array[0..0] of TPUCUUnicodeCharRange=(
(42752,42783)
);

const PUCUUnicodeBlockBlocks125:array[0..0] of TPUCUUnicodeCharRange=(
(42784,43007)
);

const PUCUUnicodeBlockBlocks126:array[0..0] of TPUCUUnicodeCharRange=(
(43008,43055)
);

const PUCUUnicodeBlockBlocks127:array[0..0] of TPUCUUnicodeCharRange=(
(43056,43071)
);

const PUCUUnicodeBlockBlocks128:array[0..0] of TPUCUUnicodeCharRange=(
(43072,43135)
);

const PUCUUnicodeBlockBlocks129:array[0..0] of TPUCUUnicodeCharRange=(
(43136,43231)
);

const PUCUUnicodeBlockBlocks130:array[0..0] of TPUCUUnicodeCharRange=(
(43232,43263)
);

const PUCUUnicodeBlockBlocks131:array[0..0] of TPUCUUnicodeCharRange=(
(43264,43311)
);

const PUCUUnicodeBlockBlocks132:array[0..0] of TPUCUUnicodeCharRange=(
(43312,43359)
);

const PUCUUnicodeBlockBlocks133:array[0..0] of TPUCUUnicodeCharRange=(
(43360,43391)
);

const PUCUUnicodeBlockBlocks134:array[0..0] of TPUCUUnicodeCharRange=(
(43392,43487)
);

const PUCUUnicodeBlockBlocks135:array[0..0] of TPUCUUnicodeCharRange=(
(43488,43519)
);

const PUCUUnicodeBlockBlocks136:array[0..0] of TPUCUUnicodeCharRange=(
(43520,43615)
);

const PUCUUnicodeBlockBlocks137:array[0..0] of TPUCUUnicodeCharRange=(
(43616,43647)
);

const PUCUUnicodeBlockBlocks138:array[0..0] of TPUCUUnicodeCharRange=(
(43648,43743)
);

const PUCUUnicodeBlockBlocks139:array[0..0] of TPUCUUnicodeCharRange=(
(43744,43775)
);

const PUCUUnicodeBlockBlocks140:array[0..0] of TPUCUUnicodeCharRange=(
(43776,43823)
);

const PUCUUnicodeBlockBlocks141:array[0..0] of TPUCUUnicodeCharRange=(
(43824,43887)
);

const PUCUUnicodeBlockBlocks142:array[0..0] of TPUCUUnicodeCharRange=(
(43888,43967)
);

const PUCUUnicodeBlockBlocks143:array[0..0] of TPUCUUnicodeCharRange=(
(43968,44031)
);

const PUCUUnicodeBlockBlocks144:array[0..0] of TPUCUUnicodeCharRange=(
(44032,55215)
);

const PUCUUnicodeBlockBlocks145:array[0..0] of TPUCUUnicodeCharRange=(
(55216,55295)
);

const PUCUUnicodeBlockBlocks146:array[0..0] of TPUCUUnicodeCharRange=(
(55296,56191)
);

const PUCUUnicodeBlockBlocks147:array[0..0] of TPUCUUnicodeCharRange=(
(56192,56319)
);

const PUCUUnicodeBlockBlocks148:array[0..0] of TPUCUUnicodeCharRange=(
(56320,57343)
);

const PUCUUnicodeBlockBlocks149:array[0..0] of TPUCUUnicodeCharRange=(
(57344,63743)
);

const PUCUUnicodeBlockBlocks150:array[0..0] of TPUCUUnicodeCharRange=(
(63744,64255)
);

const PUCUUnicodeBlockBlocks151:array[0..0] of TPUCUUnicodeCharRange=(
(64256,64335)
);

const PUCUUnicodeBlockBlocks152:array[0..0] of TPUCUUnicodeCharRange=(
(64336,65023)
);

const PUCUUnicodeBlockBlocks153:array[0..0] of TPUCUUnicodeCharRange=(
(65024,65039)
);

const PUCUUnicodeBlockBlocks154:array[0..0] of TPUCUUnicodeCharRange=(
(65040,65055)
);

const PUCUUnicodeBlockBlocks155:array[0..0] of TPUCUUnicodeCharRange=(
(65056,65071)
);

const PUCUUnicodeBlockBlocks156:array[0..0] of TPUCUUnicodeCharRange=(
(65072,65103)
);

const PUCUUnicodeBlockBlocks157:array[0..0] of TPUCUUnicodeCharRange=(
(65104,65135)
);

const PUCUUnicodeBlockBlocks158:array[0..0] of TPUCUUnicodeCharRange=(
(65136,65279)
);

const PUCUUnicodeBlockBlocks159:array[0..0] of TPUCUUnicodeCharRange=(
(65280,65519)
);

const PUCUUnicodeBlockBlocks160:array[0..0] of TPUCUUnicodeCharRange=(
(65520,65535)
);

const PUCUUnicodeBlockBlocks161:array[0..0] of TPUCUUnicodeCharRange=(
(65536,65663)
);

const PUCUUnicodeBlockBlocks162:array[0..0] of TPUCUUnicodeCharRange=(
(65664,65791)
);

const PUCUUnicodeBlockBlocks163:array[0..0] of TPUCUUnicodeCharRange=(
(65792,65855)
);

const PUCUUnicodeBlockBlocks164:array[0..0] of TPUCUUnicodeCharRange=(
(65856,65935)
);

const PUCUUnicodeBlockBlocks165:array[0..0] of TPUCUUnicodeCharRange=(
(65936,65999)
);

const PUCUUnicodeBlockBlocks166:array[0..0] of TPUCUUnicodeCharRange=(
(66000,66047)
);

const PUCUUnicodeBlockBlocks167:array[0..0] of TPUCUUnicodeCharRange=(
(66176,66207)
);

const PUCUUnicodeBlockBlocks168:array[0..0] of TPUCUUnicodeCharRange=(
(66208,66271)
);

const PUCUUnicodeBlockBlocks169:array[0..0] of TPUCUUnicodeCharRange=(
(66272,66303)
);

const PUCUUnicodeBlockBlocks170:array[0..0] of TPUCUUnicodeCharRange=(
(66304,66351)
);

const PUCUUnicodeBlockBlocks171:array[0..0] of TPUCUUnicodeCharRange=(
(66352,66383)
);

const PUCUUnicodeBlockBlocks172:array[0..0] of TPUCUUnicodeCharRange=(
(66384,66431)
);

const PUCUUnicodeBlockBlocks173:array[0..0] of TPUCUUnicodeCharRange=(
(66432,66463)
);

const PUCUUnicodeBlockBlocks174:array[0..0] of TPUCUUnicodeCharRange=(
(66464,66527)
);

const PUCUUnicodeBlockBlocks175:array[0..0] of TPUCUUnicodeCharRange=(
(66560,66639)
);

const PUCUUnicodeBlockBlocks176:array[0..0] of TPUCUUnicodeCharRange=(
(66640,66687)
);

const PUCUUnicodeBlockBlocks177:array[0..0] of TPUCUUnicodeCharRange=(
(66688,66735)
);

const PUCUUnicodeBlockBlocks178:array[0..0] of TPUCUUnicodeCharRange=(
(66736,66815)
);

const PUCUUnicodeBlockBlocks179:array[0..0] of TPUCUUnicodeCharRange=(
(66816,66863)
);

const PUCUUnicodeBlockBlocks180:array[0..0] of TPUCUUnicodeCharRange=(
(66864,66927)
);

const PUCUUnicodeBlockBlocks181:array[0..0] of TPUCUUnicodeCharRange=(
(67072,67455)
);

const PUCUUnicodeBlockBlocks182:array[0..0] of TPUCUUnicodeCharRange=(
(67584,67647)
);

const PUCUUnicodeBlockBlocks183:array[0..0] of TPUCUUnicodeCharRange=(
(67648,67679)
);

const PUCUUnicodeBlockBlocks184:array[0..0] of TPUCUUnicodeCharRange=(
(67680,67711)
);

const PUCUUnicodeBlockBlocks185:array[0..0] of TPUCUUnicodeCharRange=(
(67712,67759)
);

const PUCUUnicodeBlockBlocks186:array[0..0] of TPUCUUnicodeCharRange=(
(67808,67839)
);

const PUCUUnicodeBlockBlocks187:array[0..0] of TPUCUUnicodeCharRange=(
(67840,67871)
);

const PUCUUnicodeBlockBlocks188:array[0..0] of TPUCUUnicodeCharRange=(
(67872,67903)
);

const PUCUUnicodeBlockBlocks189:array[0..0] of TPUCUUnicodeCharRange=(
(67968,67999)
);

const PUCUUnicodeBlockBlocks190:array[0..0] of TPUCUUnicodeCharRange=(
(68000,68095)
);

const PUCUUnicodeBlockBlocks191:array[0..0] of TPUCUUnicodeCharRange=(
(68096,68191)
);

const PUCUUnicodeBlockBlocks192:array[0..0] of TPUCUUnicodeCharRange=(
(68192,68223)
);

const PUCUUnicodeBlockBlocks193:array[0..0] of TPUCUUnicodeCharRange=(
(68224,68255)
);

const PUCUUnicodeBlockBlocks194:array[0..0] of TPUCUUnicodeCharRange=(
(68288,68351)
);

const PUCUUnicodeBlockBlocks195:array[0..0] of TPUCUUnicodeCharRange=(
(68352,68415)
);

const PUCUUnicodeBlockBlocks196:array[0..0] of TPUCUUnicodeCharRange=(
(68416,68447)
);

const PUCUUnicodeBlockBlocks197:array[0..0] of TPUCUUnicodeCharRange=(
(68448,68479)
);

const PUCUUnicodeBlockBlocks198:array[0..0] of TPUCUUnicodeCharRange=(
(68480,68527)
);

const PUCUUnicodeBlockBlocks199:array[0..0] of TPUCUUnicodeCharRange=(
(68608,68687)
);

const PUCUUnicodeBlockBlocks200:array[0..0] of TPUCUUnicodeCharRange=(
(68736,68863)
);

const PUCUUnicodeBlockBlocks201:array[0..0] of TPUCUUnicodeCharRange=(
(69216,69247)
);

const PUCUUnicodeBlockBlocks202:array[0..0] of TPUCUUnicodeCharRange=(
(69632,69759)
);

const PUCUUnicodeBlockBlocks203:array[0..0] of TPUCUUnicodeCharRange=(
(69760,69839)
);

const PUCUUnicodeBlockBlocks204:array[0..0] of TPUCUUnicodeCharRange=(
(69840,69887)
);

const PUCUUnicodeBlockBlocks205:array[0..0] of TPUCUUnicodeCharRange=(
(69888,69967)
);

const PUCUUnicodeBlockBlocks206:array[0..0] of TPUCUUnicodeCharRange=(
(69968,70015)
);

const PUCUUnicodeBlockBlocks207:array[0..0] of TPUCUUnicodeCharRange=(
(70016,70111)
);

const PUCUUnicodeBlockBlocks208:array[0..0] of TPUCUUnicodeCharRange=(
(70112,70143)
);

const PUCUUnicodeBlockBlocks209:array[0..0] of TPUCUUnicodeCharRange=(
(70144,70223)
);

const PUCUUnicodeBlockBlocks210:array[0..0] of TPUCUUnicodeCharRange=(
(70272,70319)
);

const PUCUUnicodeBlockBlocks211:array[0..0] of TPUCUUnicodeCharRange=(
(70320,70399)
);

const PUCUUnicodeBlockBlocks212:array[0..0] of TPUCUUnicodeCharRange=(
(70400,70527)
);

const PUCUUnicodeBlockBlocks213:array[0..0] of TPUCUUnicodeCharRange=(
(70656,70783)
);

const PUCUUnicodeBlockBlocks214:array[0..0] of TPUCUUnicodeCharRange=(
(70784,70879)
);

const PUCUUnicodeBlockBlocks215:array[0..0] of TPUCUUnicodeCharRange=(
(71040,71167)
);

const PUCUUnicodeBlockBlocks216:array[0..0] of TPUCUUnicodeCharRange=(
(71168,71263)
);

const PUCUUnicodeBlockBlocks217:array[0..0] of TPUCUUnicodeCharRange=(
(71264,71295)
);

const PUCUUnicodeBlockBlocks218:array[0..0] of TPUCUUnicodeCharRange=(
(71296,71375)
);

const PUCUUnicodeBlockBlocks219:array[0..0] of TPUCUUnicodeCharRange=(
(71424,71487)
);

const PUCUUnicodeBlockBlocks220:array[0..0] of TPUCUUnicodeCharRange=(
(71840,71935)
);

const PUCUUnicodeBlockBlocks221:array[0..0] of TPUCUUnicodeCharRange=(
(72384,72447)
);

const PUCUUnicodeBlockBlocks222:array[0..0] of TPUCUUnicodeCharRange=(
(72704,72815)
);

const PUCUUnicodeBlockBlocks223:array[0..0] of TPUCUUnicodeCharRange=(
(72816,72895)
);

const PUCUUnicodeBlockBlocks224:array[0..0] of TPUCUUnicodeCharRange=(
(73728,74751)
);

const PUCUUnicodeBlockBlocks225:array[0..0] of TPUCUUnicodeCharRange=(
(74752,74879)
);

const PUCUUnicodeBlockBlocks226:array[0..0] of TPUCUUnicodeCharRange=(
(74880,75087)
);

const PUCUUnicodeBlockBlocks227:array[0..0] of TPUCUUnicodeCharRange=(
(77824,78895)
);

const PUCUUnicodeBlockBlocks228:array[0..0] of TPUCUUnicodeCharRange=(
(82944,83583)
);

const PUCUUnicodeBlockBlocks229:array[0..0] of TPUCUUnicodeCharRange=(
(92160,92735)
);

const PUCUUnicodeBlockBlocks230:array[0..0] of TPUCUUnicodeCharRange=(
(92736,92783)
);

const PUCUUnicodeBlockBlocks231:array[0..0] of TPUCUUnicodeCharRange=(
(92880,92927)
);

const PUCUUnicodeBlockBlocks232:array[0..0] of TPUCUUnicodeCharRange=(
(92928,93071)
);

const PUCUUnicodeBlockBlocks233:array[0..0] of TPUCUUnicodeCharRange=(
(93952,94111)
);

const PUCUUnicodeBlockBlocks234:array[0..0] of TPUCUUnicodeCharRange=(
(94176,94207)
);

const PUCUUnicodeBlockBlocks235:array[0..0] of TPUCUUnicodeCharRange=(
(94208,100351)
);

const PUCUUnicodeBlockBlocks236:array[0..0] of TPUCUUnicodeCharRange=(
(100352,101119)
);

const PUCUUnicodeBlockBlocks237:array[0..0] of TPUCUUnicodeCharRange=(
(110592,110847)
);

const PUCUUnicodeBlockBlocks238:array[0..0] of TPUCUUnicodeCharRange=(
(113664,113823)
);

const PUCUUnicodeBlockBlocks239:array[0..0] of TPUCUUnicodeCharRange=(
(113824,113839)
);

const PUCUUnicodeBlockBlocks240:array[0..0] of TPUCUUnicodeCharRange=(
(118784,119039)
);

const PUCUUnicodeBlockBlocks241:array[0..0] of TPUCUUnicodeCharRange=(
(119040,119295)
);

const PUCUUnicodeBlockBlocks242:array[0..0] of TPUCUUnicodeCharRange=(
(119296,119375)
);

const PUCUUnicodeBlockBlocks243:array[0..0] of TPUCUUnicodeCharRange=(
(119552,119647)
);

const PUCUUnicodeBlockBlocks244:array[0..0] of TPUCUUnicodeCharRange=(
(119648,119679)
);

const PUCUUnicodeBlockBlocks245:array[0..0] of TPUCUUnicodeCharRange=(
(119808,120831)
);

const PUCUUnicodeBlockBlocks246:array[0..0] of TPUCUUnicodeCharRange=(
(120832,121519)
);

const PUCUUnicodeBlockBlocks247:array[0..0] of TPUCUUnicodeCharRange=(
(122880,122927)
);

const PUCUUnicodeBlockBlocks248:array[0..0] of TPUCUUnicodeCharRange=(
(124928,125151)
);

const PUCUUnicodeBlockBlocks249:array[0..0] of TPUCUUnicodeCharRange=(
(125184,125279)
);

const PUCUUnicodeBlockBlocks250:array[0..0] of TPUCUUnicodeCharRange=(
(126464,126719)
);

const PUCUUnicodeBlockBlocks251:array[0..0] of TPUCUUnicodeCharRange=(
(126976,127023)
);

const PUCUUnicodeBlockBlocks252:array[0..0] of TPUCUUnicodeCharRange=(
(127024,127135)
);

const PUCUUnicodeBlockBlocks253:array[0..0] of TPUCUUnicodeCharRange=(
(127136,127231)
);

const PUCUUnicodeBlockBlocks254:array[0..0] of TPUCUUnicodeCharRange=(
(127232,127487)
);

const PUCUUnicodeBlockBlocks255:array[0..0] of TPUCUUnicodeCharRange=(
(127488,127743)
);

const PUCUUnicodeBlockBlocks256:array[0..0] of TPUCUUnicodeCharRange=(
(127744,128511)
);

const PUCUUnicodeBlockBlocks257:array[0..0] of TPUCUUnicodeCharRange=(
(128512,128591)
);

const PUCUUnicodeBlockBlocks258:array[0..0] of TPUCUUnicodeCharRange=(
(128592,128639)
);

const PUCUUnicodeBlockBlocks259:array[0..0] of TPUCUUnicodeCharRange=(
(128640,128767)
);

const PUCUUnicodeBlockBlocks260:array[0..0] of TPUCUUnicodeCharRange=(
(128768,128895)
);

const PUCUUnicodeBlockBlocks261:array[0..0] of TPUCUUnicodeCharRange=(
(128896,129023)
);

const PUCUUnicodeBlockBlocks262:array[0..0] of TPUCUUnicodeCharRange=(
(129024,129279)
);

const PUCUUnicodeBlockBlocks263:array[0..0] of TPUCUUnicodeCharRange=(
(129280,129535)
);

const PUCUUnicodeBlockBlocks264:array[0..0] of TPUCUUnicodeCharRange=(
(131072,173791)
);

const PUCUUnicodeBlockBlocks265:array[0..0] of TPUCUUnicodeCharRange=(
(173824,177983)
);

const PUCUUnicodeBlockBlocks266:array[0..0] of TPUCUUnicodeCharRange=(
(177984,178207)
);

const PUCUUnicodeBlockBlocks267:array[0..0] of TPUCUUnicodeCharRange=(
(178208,183983)
);

const PUCUUnicodeBlockBlocks268:array[0..0] of TPUCUUnicodeCharRange=(
(194560,195103)
);

const PUCUUnicodeBlockBlocks269:array[0..0] of TPUCUUnicodeCharRange=(
(917504,917631)
);

const PUCUUnicodeBlockBlocks270:array[0..0] of TPUCUUnicodeCharRange=(
(917760,917999)
);

const PUCUUnicodeBlockBlocks271:array[0..0] of TPUCUUnicodeCharRange=(
(983040,1048575)
);

const PUCUUnicodeBlockBlocks272:array[0..0] of TPUCUUnicodeCharRange=(
(1048576,1114111)
);

const PUCUUnicodeBlockBlocksData:array[0..272] of pointer=(
@PUCUUnicodeBlockBlocks0,
@PUCUUnicodeBlockBlocks1,
@PUCUUnicodeBlockBlocks2,
@PUCUUnicodeBlockBlocks3,
@PUCUUnicodeBlockBlocks4,
@PUCUUnicodeBlockBlocks5,
@PUCUUnicodeBlockBlocks6,
@PUCUUnicodeBlockBlocks7,
@PUCUUnicodeBlockBlocks8,
@PUCUUnicodeBlockBlocks9,
@PUCUUnicodeBlockBlocks10,
@PUCUUnicodeBlockBlocks11,
@PUCUUnicodeBlockBlocks12,
@PUCUUnicodeBlockBlocks13,
@PUCUUnicodeBlockBlocks14,
@PUCUUnicodeBlockBlocks15,
@PUCUUnicodeBlockBlocks16,
@PUCUUnicodeBlockBlocks17,
@PUCUUnicodeBlockBlocks18,
@PUCUUnicodeBlockBlocks19,
@PUCUUnicodeBlockBlocks20,
@PUCUUnicodeBlockBlocks21,
@PUCUUnicodeBlockBlocks22,
@PUCUUnicodeBlockBlocks23,
@PUCUUnicodeBlockBlocks24,
@PUCUUnicodeBlockBlocks25,
@PUCUUnicodeBlockBlocks26,
@PUCUUnicodeBlockBlocks27,
@PUCUUnicodeBlockBlocks28,
@PUCUUnicodeBlockBlocks29,
@PUCUUnicodeBlockBlocks30,
@PUCUUnicodeBlockBlocks31,
@PUCUUnicodeBlockBlocks32,
@PUCUUnicodeBlockBlocks33,
@PUCUUnicodeBlockBlocks34,
@PUCUUnicodeBlockBlocks35,
@PUCUUnicodeBlockBlocks36,
@PUCUUnicodeBlockBlocks37,
@PUCUUnicodeBlockBlocks38,
@PUCUUnicodeBlockBlocks39,
@PUCUUnicodeBlockBlocks40,
@PUCUUnicodeBlockBlocks41,
@PUCUUnicodeBlockBlocks42,
@PUCUUnicodeBlockBlocks43,
@PUCUUnicodeBlockBlocks44,
@PUCUUnicodeBlockBlocks45,
@PUCUUnicodeBlockBlocks46,
@PUCUUnicodeBlockBlocks47,
@PUCUUnicodeBlockBlocks48,
@PUCUUnicodeBlockBlocks49,
@PUCUUnicodeBlockBlocks50,
@PUCUUnicodeBlockBlocks51,
@PUCUUnicodeBlockBlocks52,
@PUCUUnicodeBlockBlocks53,
@PUCUUnicodeBlockBlocks54,
@PUCUUnicodeBlockBlocks55,
@PUCUUnicodeBlockBlocks56,
@PUCUUnicodeBlockBlocks57,
@PUCUUnicodeBlockBlocks58,
@PUCUUnicodeBlockBlocks59,
@PUCUUnicodeBlockBlocks60,
@PUCUUnicodeBlockBlocks61,
@PUCUUnicodeBlockBlocks62,
@PUCUUnicodeBlockBlocks63,
@PUCUUnicodeBlockBlocks64,
@PUCUUnicodeBlockBlocks65,
@PUCUUnicodeBlockBlocks66,
@PUCUUnicodeBlockBlocks67,
@PUCUUnicodeBlockBlocks68,
@PUCUUnicodeBlockBlocks69,
@PUCUUnicodeBlockBlocks70,
@PUCUUnicodeBlockBlocks71,
@PUCUUnicodeBlockBlocks72,
@PUCUUnicodeBlockBlocks73,
@PUCUUnicodeBlockBlocks74,
@PUCUUnicodeBlockBlocks75,
@PUCUUnicodeBlockBlocks76,
@PUCUUnicodeBlockBlocks77,
@PUCUUnicodeBlockBlocks78,
@PUCUUnicodeBlockBlocks79,
@PUCUUnicodeBlockBlocks80,
@PUCUUnicodeBlockBlocks81,
@PUCUUnicodeBlockBlocks82,
@PUCUUnicodeBlockBlocks83,
@PUCUUnicodeBlockBlocks84,
@PUCUUnicodeBlockBlocks85,
@PUCUUnicodeBlockBlocks86,
@PUCUUnicodeBlockBlocks87,
@PUCUUnicodeBlockBlocks88,
@PUCUUnicodeBlockBlocks89,
@PUCUUnicodeBlockBlocks90,
@PUCUUnicodeBlockBlocks91,
@PUCUUnicodeBlockBlocks92,
@PUCUUnicodeBlockBlocks93,
@PUCUUnicodeBlockBlocks94,
@PUCUUnicodeBlockBlocks95,
@PUCUUnicodeBlockBlocks96,
@PUCUUnicodeBlockBlocks97,
@PUCUUnicodeBlockBlocks98,
@PUCUUnicodeBlockBlocks99,
@PUCUUnicodeBlockBlocks100,
@PUCUUnicodeBlockBlocks101,
@PUCUUnicodeBlockBlocks102,
@PUCUUnicodeBlockBlocks103,
@PUCUUnicodeBlockBlocks104,
@PUCUUnicodeBlockBlocks105,
@PUCUUnicodeBlockBlocks106,
@PUCUUnicodeBlockBlocks107,
@PUCUUnicodeBlockBlocks108,
@PUCUUnicodeBlockBlocks109,
@PUCUUnicodeBlockBlocks110,
@PUCUUnicodeBlockBlocks111,
@PUCUUnicodeBlockBlocks112,
@PUCUUnicodeBlockBlocks113,
@PUCUUnicodeBlockBlocks114,
@PUCUUnicodeBlockBlocks115,
@PUCUUnicodeBlockBlocks116,
@PUCUUnicodeBlockBlocks117,
@PUCUUnicodeBlockBlocks118,
@PUCUUnicodeBlockBlocks119,
@PUCUUnicodeBlockBlocks120,
@PUCUUnicodeBlockBlocks121,
@PUCUUnicodeBlockBlocks122,
@PUCUUnicodeBlockBlocks123,
@PUCUUnicodeBlockBlocks124,
@PUCUUnicodeBlockBlocks125,
@PUCUUnicodeBlockBlocks126,
@PUCUUnicodeBlockBlocks127,
@PUCUUnicodeBlockBlocks128,
@PUCUUnicodeBlockBlocks129,
@PUCUUnicodeBlockBlocks130,
@PUCUUnicodeBlockBlocks131,
@PUCUUnicodeBlockBlocks132,
@PUCUUnicodeBlockBlocks133,
@PUCUUnicodeBlockBlocks134,
@PUCUUnicodeBlockBlocks135,
@PUCUUnicodeBlockBlocks136,
@PUCUUnicodeBlockBlocks137,
@PUCUUnicodeBlockBlocks138,
@PUCUUnicodeBlockBlocks139,
@PUCUUnicodeBlockBlocks140,
@PUCUUnicodeBlockBlocks141,
@PUCUUnicodeBlockBlocks142,
@PUCUUnicodeBlockBlocks143,
@PUCUUnicodeBlockBlocks144,
@PUCUUnicodeBlockBlocks145,
@PUCUUnicodeBlockBlocks146,
@PUCUUnicodeBlockBlocks147,
@PUCUUnicodeBlockBlocks148,
@PUCUUnicodeBlockBlocks149,
@PUCUUnicodeBlockBlocks150,
@PUCUUnicodeBlockBlocks151,
@PUCUUnicodeBlockBlocks152,
@PUCUUnicodeBlockBlocks153,
@PUCUUnicodeBlockBlocks154,
@PUCUUnicodeBlockBlocks155,
@PUCUUnicodeBlockBlocks156,
@PUCUUnicodeBlockBlocks157,
@PUCUUnicodeBlockBlocks158,
@PUCUUnicodeBlockBlocks159,
@PUCUUnicodeBlockBlocks160,
@PUCUUnicodeBlockBlocks161,
@PUCUUnicodeBlockBlocks162,
@PUCUUnicodeBlockBlocks163,
@PUCUUnicodeBlockBlocks164,
@PUCUUnicodeBlockBlocks165,
@PUCUUnicodeBlockBlocks166,
@PUCUUnicodeBlockBlocks167,
@PUCUUnicodeBlockBlocks168,
@PUCUUnicodeBlockBlocks169,
@PUCUUnicodeBlockBlocks170,
@PUCUUnicodeBlockBlocks171,
@PUCUUnicodeBlockBlocks172,
@PUCUUnicodeBlockBlocks173,
@PUCUUnicodeBlockBlocks174,
@PUCUUnicodeBlockBlocks175,
@PUCUUnicodeBlockBlocks176,
@PUCUUnicodeBlockBlocks177,
@PUCUUnicodeBlockBlocks178,
@PUCUUnicodeBlockBlocks179,
@PUCUUnicodeBlockBlocks180,
@PUCUUnicodeBlockBlocks181,
@PUCUUnicodeBlockBlocks182,
@PUCUUnicodeBlockBlocks183,
@PUCUUnicodeBlockBlocks184,
@PUCUUnicodeBlockBlocks185,
@PUCUUnicodeBlockBlocks186,
@PUCUUnicodeBlockBlocks187,
@PUCUUnicodeBlockBlocks188,
@PUCUUnicodeBlockBlocks189,
@PUCUUnicodeBlockBlocks190,
@PUCUUnicodeBlockBlocks191,
@PUCUUnicodeBlockBlocks192,
@PUCUUnicodeBlockBlocks193,
@PUCUUnicodeBlockBlocks194,
@PUCUUnicodeBlockBlocks195,
@PUCUUnicodeBlockBlocks196,
@PUCUUnicodeBlockBlocks197,
@PUCUUnicodeBlockBlocks198,
@PUCUUnicodeBlockBlocks199,
@PUCUUnicodeBlockBlocks200,
@PUCUUnicodeBlockBlocks201,
@PUCUUnicodeBlockBlocks202,
@PUCUUnicodeBlockBlocks203,
@PUCUUnicodeBlockBlocks204,
@PUCUUnicodeBlockBlocks205,
@PUCUUnicodeBlockBlocks206,
@PUCUUnicodeBlockBlocks207,
@PUCUUnicodeBlockBlocks208,
@PUCUUnicodeBlockBlocks209,
@PUCUUnicodeBlockBlocks210,
@PUCUUnicodeBlockBlocks211,
@PUCUUnicodeBlockBlocks212,
@PUCUUnicodeBlockBlocks213,
@PUCUUnicodeBlockBlocks214,
@PUCUUnicodeBlockBlocks215,
@PUCUUnicodeBlockBlocks216,
@PUCUUnicodeBlockBlocks217,
@PUCUUnicodeBlockBlocks218,
@PUCUUnicodeBlockBlocks219,
@PUCUUnicodeBlockBlocks220,
@PUCUUnicodeBlockBlocks221,
@PUCUUnicodeBlockBlocks222,
@PUCUUnicodeBlockBlocks223,
@PUCUUnicodeBlockBlocks224,
@PUCUUnicodeBlockBlocks225,
@PUCUUnicodeBlockBlocks226,
@PUCUUnicodeBlockBlocks227,
@PUCUUnicodeBlockBlocks228,
@PUCUUnicodeBlockBlocks229,
@PUCUUnicodeBlockBlocks230,
@PUCUUnicodeBlockBlocks231,
@PUCUUnicodeBlockBlocks232,
@PUCUUnicodeBlockBlocks233,
@PUCUUnicodeBlockBlocks234,
@PUCUUnicodeBlockBlocks235,
@PUCUUnicodeBlockBlocks236,
@PUCUUnicodeBlockBlocks237,
@PUCUUnicodeBlockBlocks238,
@PUCUUnicodeBlockBlocks239,
@PUCUUnicodeBlockBlocks240,
@PUCUUnicodeBlockBlocks241,
@PUCUUnicodeBlockBlocks242,
@PUCUUnicodeBlockBlocks243,
@PUCUUnicodeBlockBlocks244,
@PUCUUnicodeBlockBlocks245,
@PUCUUnicodeBlockBlocks246,
@PUCUUnicodeBlockBlocks247,
@PUCUUnicodeBlockBlocks248,
@PUCUUnicodeBlockBlocks249,
@PUCUUnicodeBlockBlocks250,
@PUCUUnicodeBlockBlocks251,
@PUCUUnicodeBlockBlocks252,
@PUCUUnicodeBlockBlocks253,
@PUCUUnicodeBlockBlocks254,
@PUCUUnicodeBlockBlocks255,
@PUCUUnicodeBlockBlocks256,
@PUCUUnicodeBlockBlocks257,
@PUCUUnicodeBlockBlocks258,
@PUCUUnicodeBlockBlocks259,
@PUCUUnicodeBlockBlocks260,
@PUCUUnicodeBlockBlocks261,
@PUCUUnicodeBlockBlocks262,
@PUCUUnicodeBlockBlocks263,
@PUCUUnicodeBlockBlocks264,
@PUCUUnicodeBlockBlocks265,
@PUCUUnicodeBlockBlocks266,
@PUCUUnicodeBlockBlocks267,
@PUCUUnicodeBlockBlocks268,
@PUCUUnicodeBlockBlocks269,
@PUCUUnicodeBlockBlocks270,
@PUCUUnicodeBlockBlocks271,
@PUCUUnicodeBlockBlocks272
);

const PUCUUnicodeBlockBlocksCounts:array[0..272] of longint=(
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1
);

const PUCUCountUnicodeIgnoreCaseBlockBlocks=272;

const PUCUUnicodeIgnoreCaseBlockBlocks0:array[0..0] of TPUCUUnicodeCharRange=(
(0,127)
);

const PUCUUnicodeIgnoreCaseBlockBlocks1:array[0..2] of TPUCUUnicodeCharRange=(
(128,255),
(376,376),
(924,924)
);

const PUCUUnicodeIgnoreCaseBlockBlocks2:array[0..3] of TPUCUUnicodeCharRange=(
(73,73),
(83,83),
(105,105),
(255,383)
);

const PUCUUnicodeIgnoreCaseBlockBlocks3:array[0..16] of TPUCUUnicodeCharRange=(
(384,591),
(595,596),
(598,599),
(601,601),
(603,603),
(608,608),
(611,611),
(616,617),
(623,623),
(626,626),
(629,629),
(640,640),
(643,643),
(648,652),
(658,658),
(11365,11366),
(11390,11391)
);

const PUCUUnicodeIgnoreCaseBlockBlocks4:array[0..20] of TPUCUUnicodeCharRange=(
(385,385),
(390,390),
(393,394),
(399,400),
(403,404),
(406,407),
(412,413),
(415,415),
(422,422),
(425,425),
(430,430),
(433,434),
(439,439),
(580,581),
(592,687),
(11362,11362),
(11364,11364),
(11373,11376),
(42893,42893),
(42922,42926),
(42928,42930)
);

const PUCUUnicodeIgnoreCaseBlockBlocks5:array[0..0] of TPUCUUnicodeCharRange=(
(688,767)
);

const PUCUUnicodeIgnoreCaseBlockBlocks6:array[0..1] of TPUCUUnicodeCharRange=(
(768,879),
(921,921)
);

const PUCUUnicodeIgnoreCaseBlockBlocks7:array[0..0] of TPUCUUnicodeCharRange=(
(880,1023)
);

const PUCUUnicodeIgnoreCaseBlockBlocks8:array[0..0] of TPUCUUnicodeCharRange=(
(1024,1279)
);

const PUCUUnicodeIgnoreCaseBlockBlocks9:array[0..0] of TPUCUUnicodeCharRange=(
(1280,1327)
);

const PUCUUnicodeIgnoreCaseBlockBlocks10:array[0..0] of TPUCUUnicodeCharRange=(
(1328,1423)
);

const PUCUUnicodeIgnoreCaseBlockBlocks11:array[0..0] of TPUCUUnicodeCharRange=(
(1424,1535)
);

const PUCUUnicodeIgnoreCaseBlockBlocks12:array[0..0] of TPUCUUnicodeCharRange=(
(1536,1791)
);

const PUCUUnicodeIgnoreCaseBlockBlocks13:array[0..0] of TPUCUUnicodeCharRange=(
(1792,1871)
);

const PUCUUnicodeIgnoreCaseBlockBlocks14:array[0..0] of TPUCUUnicodeCharRange=(
(1872,1919)
);

const PUCUUnicodeIgnoreCaseBlockBlocks15:array[0..0] of TPUCUUnicodeCharRange=(
(1920,1983)
);

const PUCUUnicodeIgnoreCaseBlockBlocks16:array[0..0] of TPUCUUnicodeCharRange=(
(1984,2047)
);

const PUCUUnicodeIgnoreCaseBlockBlocks17:array[0..0] of TPUCUUnicodeCharRange=(
(2048,2111)
);

const PUCUUnicodeIgnoreCaseBlockBlocks18:array[0..0] of TPUCUUnicodeCharRange=(
(2112,2143)
);

const PUCUUnicodeIgnoreCaseBlockBlocks19:array[0..0] of TPUCUUnicodeCharRange=(
(2208,2303)
);

const PUCUUnicodeIgnoreCaseBlockBlocks20:array[0..0] of TPUCUUnicodeCharRange=(
(2304,2431)
);

const PUCUUnicodeIgnoreCaseBlockBlocks21:array[0..0] of TPUCUUnicodeCharRange=(
(2432,2559)
);

const PUCUUnicodeIgnoreCaseBlockBlocks22:array[0..0] of TPUCUUnicodeCharRange=(
(2560,2687)
);

const PUCUUnicodeIgnoreCaseBlockBlocks23:array[0..0] of TPUCUUnicodeCharRange=(
(2688,2815)
);

const PUCUUnicodeIgnoreCaseBlockBlocks24:array[0..0] of TPUCUUnicodeCharRange=(
(2816,2943)
);

const PUCUUnicodeIgnoreCaseBlockBlocks25:array[0..0] of TPUCUUnicodeCharRange=(
(2944,3071)
);

const PUCUUnicodeIgnoreCaseBlockBlocks26:array[0..0] of TPUCUUnicodeCharRange=(
(3072,3199)
);

const PUCUUnicodeIgnoreCaseBlockBlocks27:array[0..0] of TPUCUUnicodeCharRange=(
(3200,3327)
);

const PUCUUnicodeIgnoreCaseBlockBlocks28:array[0..0] of TPUCUUnicodeCharRange=(
(3328,3455)
);

const PUCUUnicodeIgnoreCaseBlockBlocks29:array[0..0] of TPUCUUnicodeCharRange=(
(3456,3583)
);

const PUCUUnicodeIgnoreCaseBlockBlocks30:array[0..0] of TPUCUUnicodeCharRange=(
(3584,3711)
);

const PUCUUnicodeIgnoreCaseBlockBlocks31:array[0..0] of TPUCUUnicodeCharRange=(
(3712,3839)
);

const PUCUUnicodeIgnoreCaseBlockBlocks32:array[0..0] of TPUCUUnicodeCharRange=(
(3840,4095)
);

const PUCUUnicodeIgnoreCaseBlockBlocks33:array[0..0] of TPUCUUnicodeCharRange=(
(4096,4255)
);

const PUCUUnicodeIgnoreCaseBlockBlocks34:array[0..3] of TPUCUUnicodeCharRange=(
(4256,4351),
(11520,11557),
(11559,11559),
(11565,11565)
);

const PUCUUnicodeIgnoreCaseBlockBlocks35:array[0..0] of TPUCUUnicodeCharRange=(
(4352,4607)
);

const PUCUUnicodeIgnoreCaseBlockBlocks36:array[0..0] of TPUCUUnicodeCharRange=(
(4608,4991)
);

const PUCUUnicodeIgnoreCaseBlockBlocks37:array[0..0] of TPUCUUnicodeCharRange=(
(4992,5023)
);

const PUCUUnicodeIgnoreCaseBlockBlocks38:array[0..1] of TPUCUUnicodeCharRange=(
(5024,5119),
(43888,43967)
);

const PUCUUnicodeIgnoreCaseBlockBlocks39:array[0..0] of TPUCUUnicodeCharRange=(
(5120,5759)
);

const PUCUUnicodeIgnoreCaseBlockBlocks40:array[0..0] of TPUCUUnicodeCharRange=(
(5760,5791)
);

const PUCUUnicodeIgnoreCaseBlockBlocks41:array[0..0] of TPUCUUnicodeCharRange=(
(5792,5887)
);

const PUCUUnicodeIgnoreCaseBlockBlocks42:array[0..0] of TPUCUUnicodeCharRange=(
(5888,5919)
);

const PUCUUnicodeIgnoreCaseBlockBlocks43:array[0..0] of TPUCUUnicodeCharRange=(
(5920,5951)
);

const PUCUUnicodeIgnoreCaseBlockBlocks44:array[0..0] of TPUCUUnicodeCharRange=(
(5952,5983)
);

const PUCUUnicodeIgnoreCaseBlockBlocks45:array[0..0] of TPUCUUnicodeCharRange=(
(5984,6015)
);

const PUCUUnicodeIgnoreCaseBlockBlocks46:array[0..0] of TPUCUUnicodeCharRange=(
(6016,6143)
);

const PUCUUnicodeIgnoreCaseBlockBlocks47:array[0..0] of TPUCUUnicodeCharRange=(
(6144,6319)
);

const PUCUUnicodeIgnoreCaseBlockBlocks48:array[0..0] of TPUCUUnicodeCharRange=(
(6320,6399)
);

const PUCUUnicodeIgnoreCaseBlockBlocks49:array[0..0] of TPUCUUnicodeCharRange=(
(6400,6479)
);

const PUCUUnicodeIgnoreCaseBlockBlocks50:array[0..0] of TPUCUUnicodeCharRange=(
(6480,6527)
);

const PUCUUnicodeIgnoreCaseBlockBlocks51:array[0..0] of TPUCUUnicodeCharRange=(
(6528,6623)
);

const PUCUUnicodeIgnoreCaseBlockBlocks52:array[0..0] of TPUCUUnicodeCharRange=(
(6624,6655)
);

const PUCUUnicodeIgnoreCaseBlockBlocks53:array[0..0] of TPUCUUnicodeCharRange=(
(6656,6687)
);

const PUCUUnicodeIgnoreCaseBlockBlocks54:array[0..0] of TPUCUUnicodeCharRange=(
(6688,6831)
);

const PUCUUnicodeIgnoreCaseBlockBlocks55:array[0..0] of TPUCUUnicodeCharRange=(
(6832,6911)
);

const PUCUUnicodeIgnoreCaseBlockBlocks56:array[0..0] of TPUCUUnicodeCharRange=(
(6912,7039)
);

const PUCUUnicodeIgnoreCaseBlockBlocks57:array[0..0] of TPUCUUnicodeCharRange=(
(7040,7103)
);

const PUCUUnicodeIgnoreCaseBlockBlocks58:array[0..0] of TPUCUUnicodeCharRange=(
(7104,7167)
);

const PUCUUnicodeIgnoreCaseBlockBlocks59:array[0..0] of TPUCUUnicodeCharRange=(
(7168,7247)
);

const PUCUUnicodeIgnoreCaseBlockBlocks60:array[0..0] of TPUCUUnicodeCharRange=(
(7248,7295)
);

const PUCUUnicodeIgnoreCaseBlockBlocks61:array[0..7] of TPUCUUnicodeCharRange=(
(1042,1042),
(1044,1044),
(1054,1054),
(1057,1058),
(1066,1066),
(1122,1122),
(7296,7311),
(42570,42570)
);

const PUCUUnicodeIgnoreCaseBlockBlocks62:array[0..0] of TPUCUUnicodeCharRange=(
(7360,7375)
);

const PUCUUnicodeIgnoreCaseBlockBlocks63:array[0..0] of TPUCUUnicodeCharRange=(
(7376,7423)
);

const PUCUUnicodeIgnoreCaseBlockBlocks64:array[0..2] of TPUCUUnicodeCharRange=(
(7424,7551),
(11363,11363),
(42877,42877)
);

const PUCUUnicodeIgnoreCaseBlockBlocks65:array[0..0] of TPUCUUnicodeCharRange=(
(7552,7615)
);

const PUCUUnicodeIgnoreCaseBlockBlocks66:array[0..0] of TPUCUUnicodeCharRange=(
(7616,7679)
);

const PUCUUnicodeIgnoreCaseBlockBlocks67:array[0..1] of TPUCUUnicodeCharRange=(
(223,223),
(7680,7935)
);

const PUCUUnicodeIgnoreCaseBlockBlocks68:array[0..1] of TPUCUUnicodeCharRange=(
(921,921),
(7936,8191)
);

const PUCUUnicodeIgnoreCaseBlockBlocks69:array[0..0] of TPUCUUnicodeCharRange=(
(8192,8303)
);

const PUCUUnicodeIgnoreCaseBlockBlocks70:array[0..0] of TPUCUUnicodeCharRange=(
(8304,8351)
);

const PUCUUnicodeIgnoreCaseBlockBlocks71:array[0..0] of TPUCUUnicodeCharRange=(
(8352,8399)
);

const PUCUUnicodeIgnoreCaseBlockBlocks72:array[0..0] of TPUCUUnicodeCharRange=(
(8400,8447)
);

const PUCUUnicodeIgnoreCaseBlockBlocks73:array[0..3] of TPUCUUnicodeCharRange=(
(107,107),
(229,229),
(969,969),
(8448,8527)
);

const PUCUUnicodeIgnoreCaseBlockBlocks74:array[0..0] of TPUCUUnicodeCharRange=(
(8528,8591)
);

const PUCUUnicodeIgnoreCaseBlockBlocks75:array[0..0] of TPUCUUnicodeCharRange=(
(8592,8703)
);

const PUCUUnicodeIgnoreCaseBlockBlocks76:array[0..0] of TPUCUUnicodeCharRange=(
(8704,8959)
);

const PUCUUnicodeIgnoreCaseBlockBlocks77:array[0..0] of TPUCUUnicodeCharRange=(
(8960,9215)
);

const PUCUUnicodeIgnoreCaseBlockBlocks78:array[0..0] of TPUCUUnicodeCharRange=(
(9216,9279)
);

const PUCUUnicodeIgnoreCaseBlockBlocks79:array[0..0] of TPUCUUnicodeCharRange=(
(9280,9311)
);

const PUCUUnicodeIgnoreCaseBlockBlocks80:array[0..0] of TPUCUUnicodeCharRange=(
(9312,9471)
);

const PUCUUnicodeIgnoreCaseBlockBlocks81:array[0..0] of TPUCUUnicodeCharRange=(
(9472,9599)
);

const PUCUUnicodeIgnoreCaseBlockBlocks82:array[0..0] of TPUCUUnicodeCharRange=(
(9600,9631)
);

const PUCUUnicodeIgnoreCaseBlockBlocks83:array[0..0] of TPUCUUnicodeCharRange=(
(9632,9727)
);

const PUCUUnicodeIgnoreCaseBlockBlocks84:array[0..0] of TPUCUUnicodeCharRange=(
(9728,9983)
);

const PUCUUnicodeIgnoreCaseBlockBlocks85:array[0..0] of TPUCUUnicodeCharRange=(
(9984,10175)
);

const PUCUUnicodeIgnoreCaseBlockBlocks86:array[0..0] of TPUCUUnicodeCharRange=(
(10176,10223)
);

const PUCUUnicodeIgnoreCaseBlockBlocks87:array[0..0] of TPUCUUnicodeCharRange=(
(10224,10239)
);

const PUCUUnicodeIgnoreCaseBlockBlocks88:array[0..0] of TPUCUUnicodeCharRange=(
(10240,10495)
);

const PUCUUnicodeIgnoreCaseBlockBlocks89:array[0..0] of TPUCUUnicodeCharRange=(
(10496,10623)
);

const PUCUUnicodeIgnoreCaseBlockBlocks90:array[0..0] of TPUCUUnicodeCharRange=(
(10624,10751)
);

const PUCUUnicodeIgnoreCaseBlockBlocks91:array[0..0] of TPUCUUnicodeCharRange=(
(10752,11007)
);

const PUCUUnicodeIgnoreCaseBlockBlocks92:array[0..0] of TPUCUUnicodeCharRange=(
(11008,11263)
);

const PUCUUnicodeIgnoreCaseBlockBlocks93:array[0..0] of TPUCUUnicodeCharRange=(
(11264,11359)
);

const PUCUUnicodeIgnoreCaseBlockBlocks94:array[0..7] of TPUCUUnicodeCharRange=(
(570,570),
(574,576),
(592,594),
(619,619),
(625,625),
(637,637),
(7549,7549),
(11360,11391)
);

const PUCUUnicodeIgnoreCaseBlockBlocks95:array[0..0] of TPUCUUnicodeCharRange=(
(11392,11519)
);

const PUCUUnicodeIgnoreCaseBlockBlocks96:array[0..3] of TPUCUUnicodeCharRange=(
(4256,4293),
(4295,4295),
(4301,4301),
(11520,11567)
);

const PUCUUnicodeIgnoreCaseBlockBlocks97:array[0..0] of TPUCUUnicodeCharRange=(
(11568,11647)
);

const PUCUUnicodeIgnoreCaseBlockBlocks98:array[0..0] of TPUCUUnicodeCharRange=(
(11648,11743)
);

const PUCUUnicodeIgnoreCaseBlockBlocks99:array[0..0] of TPUCUUnicodeCharRange=(
(11744,11775)
);

const PUCUUnicodeIgnoreCaseBlockBlocks100:array[0..0] of TPUCUUnicodeCharRange=(
(11776,11903)
);

const PUCUUnicodeIgnoreCaseBlockBlocks101:array[0..0] of TPUCUUnicodeCharRange=(
(11904,12031)
);

const PUCUUnicodeIgnoreCaseBlockBlocks102:array[0..0] of TPUCUUnicodeCharRange=(
(12032,12255)
);

const PUCUUnicodeIgnoreCaseBlockBlocks103:array[0..0] of TPUCUUnicodeCharRange=(
(12272,12287)
);

const PUCUUnicodeIgnoreCaseBlockBlocks104:array[0..0] of TPUCUUnicodeCharRange=(
(12288,12351)
);

const PUCUUnicodeIgnoreCaseBlockBlocks105:array[0..0] of TPUCUUnicodeCharRange=(
(12352,12447)
);

const PUCUUnicodeIgnoreCaseBlockBlocks106:array[0..0] of TPUCUUnicodeCharRange=(
(12448,12543)
);

const PUCUUnicodeIgnoreCaseBlockBlocks107:array[0..0] of TPUCUUnicodeCharRange=(
(12544,12591)
);

const PUCUUnicodeIgnoreCaseBlockBlocks108:array[0..0] of TPUCUUnicodeCharRange=(
(12592,12687)
);

const PUCUUnicodeIgnoreCaseBlockBlocks109:array[0..0] of TPUCUUnicodeCharRange=(
(12688,12703)
);

const PUCUUnicodeIgnoreCaseBlockBlocks110:array[0..0] of TPUCUUnicodeCharRange=(
(12704,12735)
);

const PUCUUnicodeIgnoreCaseBlockBlocks111:array[0..0] of TPUCUUnicodeCharRange=(
(12736,12783)
);

const PUCUUnicodeIgnoreCaseBlockBlocks112:array[0..0] of TPUCUUnicodeCharRange=(
(12784,12799)
);

const PUCUUnicodeIgnoreCaseBlockBlocks113:array[0..0] of TPUCUUnicodeCharRange=(
(12800,13055)
);

const PUCUUnicodeIgnoreCaseBlockBlocks114:array[0..0] of TPUCUUnicodeCharRange=(
(13056,13311)
);

const PUCUUnicodeIgnoreCaseBlockBlocks115:array[0..0] of TPUCUUnicodeCharRange=(
(13312,19903)
);

const PUCUUnicodeIgnoreCaseBlockBlocks116:array[0..0] of TPUCUUnicodeCharRange=(
(19904,19967)
);

const PUCUUnicodeIgnoreCaseBlockBlocks117:array[0..0] of TPUCUUnicodeCharRange=(
(19968,40959)
);

const PUCUUnicodeIgnoreCaseBlockBlocks118:array[0..0] of TPUCUUnicodeCharRange=(
(40960,42127)
);

const PUCUUnicodeIgnoreCaseBlockBlocks119:array[0..0] of TPUCUUnicodeCharRange=(
(42128,42191)
);

const PUCUUnicodeIgnoreCaseBlockBlocks120:array[0..0] of TPUCUUnicodeCharRange=(
(42192,42239)
);

const PUCUUnicodeIgnoreCaseBlockBlocks121:array[0..0] of TPUCUUnicodeCharRange=(
(42240,42559)
);

const PUCUUnicodeIgnoreCaseBlockBlocks122:array[0..0] of TPUCUUnicodeCharRange=(
(42560,42655)
);

const PUCUUnicodeIgnoreCaseBlockBlocks123:array[0..0] of TPUCUUnicodeCharRange=(
(42656,42751)
);

const PUCUUnicodeIgnoreCaseBlockBlocks124:array[0..0] of TPUCUUnicodeCharRange=(
(42752,42783)
);

const PUCUUnicodeIgnoreCaseBlockBlocks125:array[0..9] of TPUCUUnicodeCharRange=(
(604,604),
(609,609),
(613,614),
(618,618),
(620,620),
(647,647),
(669,670),
(7545,7545),
(42784,43007),
(43859,43859)
);

const PUCUUnicodeIgnoreCaseBlockBlocks126:array[0..0] of TPUCUUnicodeCharRange=(
(43008,43055)
);

const PUCUUnicodeIgnoreCaseBlockBlocks127:array[0..0] of TPUCUUnicodeCharRange=(
(43056,43071)
);

const PUCUUnicodeIgnoreCaseBlockBlocks128:array[0..0] of TPUCUUnicodeCharRange=(
(43072,43135)
);

const PUCUUnicodeIgnoreCaseBlockBlocks129:array[0..0] of TPUCUUnicodeCharRange=(
(43136,43231)
);

const PUCUUnicodeIgnoreCaseBlockBlocks130:array[0..0] of TPUCUUnicodeCharRange=(
(43232,43263)
);

const PUCUUnicodeIgnoreCaseBlockBlocks131:array[0..0] of TPUCUUnicodeCharRange=(
(43264,43311)
);

const PUCUUnicodeIgnoreCaseBlockBlocks132:array[0..0] of TPUCUUnicodeCharRange=(
(43312,43359)
);

const PUCUUnicodeIgnoreCaseBlockBlocks133:array[0..0] of TPUCUUnicodeCharRange=(
(43360,43391)
);

const PUCUUnicodeIgnoreCaseBlockBlocks134:array[0..0] of TPUCUUnicodeCharRange=(
(43392,43487)
);

const PUCUUnicodeIgnoreCaseBlockBlocks135:array[0..0] of TPUCUUnicodeCharRange=(
(43488,43519)
);

const PUCUUnicodeIgnoreCaseBlockBlocks136:array[0..0] of TPUCUUnicodeCharRange=(
(43520,43615)
);

const PUCUUnicodeIgnoreCaseBlockBlocks137:array[0..0] of TPUCUUnicodeCharRange=(
(43616,43647)
);

const PUCUUnicodeIgnoreCaseBlockBlocks138:array[0..0] of TPUCUUnicodeCharRange=(
(43648,43743)
);

const PUCUUnicodeIgnoreCaseBlockBlocks139:array[0..0] of TPUCUUnicodeCharRange=(
(43744,43775)
);

const PUCUUnicodeIgnoreCaseBlockBlocks140:array[0..0] of TPUCUUnicodeCharRange=(
(43776,43823)
);

const PUCUUnicodeIgnoreCaseBlockBlocks141:array[0..1] of TPUCUUnicodeCharRange=(
(42931,42931),
(43824,43887)
);

const PUCUUnicodeIgnoreCaseBlockBlocks142:array[0..1] of TPUCUUnicodeCharRange=(
(5024,5103),
(43888,43967)
);

const PUCUUnicodeIgnoreCaseBlockBlocks143:array[0..0] of TPUCUUnicodeCharRange=(
(43968,44031)
);

const PUCUUnicodeIgnoreCaseBlockBlocks144:array[0..0] of TPUCUUnicodeCharRange=(
(44032,55215)
);

const PUCUUnicodeIgnoreCaseBlockBlocks145:array[0..0] of TPUCUUnicodeCharRange=(
(55216,55295)
);

const PUCUUnicodeIgnoreCaseBlockBlocks146:array[0..0] of TPUCUUnicodeCharRange=(
(55296,56191)
);

const PUCUUnicodeIgnoreCaseBlockBlocks147:array[0..0] of TPUCUUnicodeCharRange=(
(56192,56319)
);

const PUCUUnicodeIgnoreCaseBlockBlocks148:array[0..0] of TPUCUUnicodeCharRange=(
(56320,57343)
);

const PUCUUnicodeIgnoreCaseBlockBlocks149:array[0..0] of TPUCUUnicodeCharRange=(
(57344,63743)
);

const PUCUUnicodeIgnoreCaseBlockBlocks150:array[0..0] of TPUCUUnicodeCharRange=(
(63744,64255)
);

const PUCUUnicodeIgnoreCaseBlockBlocks151:array[0..0] of TPUCUUnicodeCharRange=(
(64256,64335)
);

const PUCUUnicodeIgnoreCaseBlockBlocks152:array[0..0] of TPUCUUnicodeCharRange=(
(64336,65023)
);

const PUCUUnicodeIgnoreCaseBlockBlocks153:array[0..0] of TPUCUUnicodeCharRange=(
(65024,65039)
);

const PUCUUnicodeIgnoreCaseBlockBlocks154:array[0..0] of TPUCUUnicodeCharRange=(
(65040,65055)
);

const PUCUUnicodeIgnoreCaseBlockBlocks155:array[0..0] of TPUCUUnicodeCharRange=(
(65056,65071)
);

const PUCUUnicodeIgnoreCaseBlockBlocks156:array[0..0] of TPUCUUnicodeCharRange=(
(65072,65103)
);

const PUCUUnicodeIgnoreCaseBlockBlocks157:array[0..0] of TPUCUUnicodeCharRange=(
(65104,65135)
);

const PUCUUnicodeIgnoreCaseBlockBlocks158:array[0..0] of TPUCUUnicodeCharRange=(
(65136,65279)
);

const PUCUUnicodeIgnoreCaseBlockBlocks159:array[0..0] of TPUCUUnicodeCharRange=(
(65280,65519)
);

const PUCUUnicodeIgnoreCaseBlockBlocks160:array[0..0] of TPUCUUnicodeCharRange=(
(65520,65535)
);

const PUCUUnicodeIgnoreCaseBlockBlocks161:array[0..0] of TPUCUUnicodeCharRange=(
(65536,65663)
);

const PUCUUnicodeIgnoreCaseBlockBlocks162:array[0..0] of TPUCUUnicodeCharRange=(
(65664,65791)
);

const PUCUUnicodeIgnoreCaseBlockBlocks163:array[0..0] of TPUCUUnicodeCharRange=(
(65792,65855)
);

const PUCUUnicodeIgnoreCaseBlockBlocks164:array[0..0] of TPUCUUnicodeCharRange=(
(65856,65935)
);

const PUCUUnicodeIgnoreCaseBlockBlocks165:array[0..0] of TPUCUUnicodeCharRange=(
(65936,65999)
);

const PUCUUnicodeIgnoreCaseBlockBlocks166:array[0..0] of TPUCUUnicodeCharRange=(
(66000,66047)
);

const PUCUUnicodeIgnoreCaseBlockBlocks167:array[0..0] of TPUCUUnicodeCharRange=(
(66176,66207)
);

const PUCUUnicodeIgnoreCaseBlockBlocks168:array[0..0] of TPUCUUnicodeCharRange=(
(66208,66271)
);

const PUCUUnicodeIgnoreCaseBlockBlocks169:array[0..0] of TPUCUUnicodeCharRange=(
(66272,66303)
);

const PUCUUnicodeIgnoreCaseBlockBlocks170:array[0..0] of TPUCUUnicodeCharRange=(
(66304,66351)
);

const PUCUUnicodeIgnoreCaseBlockBlocks171:array[0..0] of TPUCUUnicodeCharRange=(
(66352,66383)
);

const PUCUUnicodeIgnoreCaseBlockBlocks172:array[0..0] of TPUCUUnicodeCharRange=(
(66384,66431)
);

const PUCUUnicodeIgnoreCaseBlockBlocks173:array[0..0] of TPUCUUnicodeCharRange=(
(66432,66463)
);

const PUCUUnicodeIgnoreCaseBlockBlocks174:array[0..0] of TPUCUUnicodeCharRange=(
(66464,66527)
);

const PUCUUnicodeIgnoreCaseBlockBlocks175:array[0..0] of TPUCUUnicodeCharRange=(
(66560,66639)
);

const PUCUUnicodeIgnoreCaseBlockBlocks176:array[0..0] of TPUCUUnicodeCharRange=(
(66640,66687)
);

const PUCUUnicodeIgnoreCaseBlockBlocks177:array[0..0] of TPUCUUnicodeCharRange=(
(66688,66735)
);

const PUCUUnicodeIgnoreCaseBlockBlocks178:array[0..0] of TPUCUUnicodeCharRange=(
(66736,66815)
);

const PUCUUnicodeIgnoreCaseBlockBlocks179:array[0..0] of TPUCUUnicodeCharRange=(
(66816,66863)
);

const PUCUUnicodeIgnoreCaseBlockBlocks180:array[0..0] of TPUCUUnicodeCharRange=(
(66864,66927)
);

const PUCUUnicodeIgnoreCaseBlockBlocks181:array[0..0] of TPUCUUnicodeCharRange=(
(67072,67455)
);

const PUCUUnicodeIgnoreCaseBlockBlocks182:array[0..0] of TPUCUUnicodeCharRange=(
(67584,67647)
);

const PUCUUnicodeIgnoreCaseBlockBlocks183:array[0..0] of TPUCUUnicodeCharRange=(
(67648,67679)
);

const PUCUUnicodeIgnoreCaseBlockBlocks184:array[0..0] of TPUCUUnicodeCharRange=(
(67680,67711)
);

const PUCUUnicodeIgnoreCaseBlockBlocks185:array[0..0] of TPUCUUnicodeCharRange=(
(67712,67759)
);

const PUCUUnicodeIgnoreCaseBlockBlocks186:array[0..0] of TPUCUUnicodeCharRange=(
(67808,67839)
);

const PUCUUnicodeIgnoreCaseBlockBlocks187:array[0..0] of TPUCUUnicodeCharRange=(
(67840,67871)
);

const PUCUUnicodeIgnoreCaseBlockBlocks188:array[0..0] of TPUCUUnicodeCharRange=(
(67872,67903)
);

const PUCUUnicodeIgnoreCaseBlockBlocks189:array[0..0] of TPUCUUnicodeCharRange=(
(67968,67999)
);

const PUCUUnicodeIgnoreCaseBlockBlocks190:array[0..0] of TPUCUUnicodeCharRange=(
(68000,68095)
);

const PUCUUnicodeIgnoreCaseBlockBlocks191:array[0..0] of TPUCUUnicodeCharRange=(
(68096,68191)
);

const PUCUUnicodeIgnoreCaseBlockBlocks192:array[0..0] of TPUCUUnicodeCharRange=(
(68192,68223)
);

const PUCUUnicodeIgnoreCaseBlockBlocks193:array[0..0] of TPUCUUnicodeCharRange=(
(68224,68255)
);

const PUCUUnicodeIgnoreCaseBlockBlocks194:array[0..0] of TPUCUUnicodeCharRange=(
(68288,68351)
);

const PUCUUnicodeIgnoreCaseBlockBlocks195:array[0..0] of TPUCUUnicodeCharRange=(
(68352,68415)
);

const PUCUUnicodeIgnoreCaseBlockBlocks196:array[0..0] of TPUCUUnicodeCharRange=(
(68416,68447)
);

const PUCUUnicodeIgnoreCaseBlockBlocks197:array[0..0] of TPUCUUnicodeCharRange=(
(68448,68479)
);

const PUCUUnicodeIgnoreCaseBlockBlocks198:array[0..0] of TPUCUUnicodeCharRange=(
(68480,68527)
);

const PUCUUnicodeIgnoreCaseBlockBlocks199:array[0..0] of TPUCUUnicodeCharRange=(
(68608,68687)
);

const PUCUUnicodeIgnoreCaseBlockBlocks200:array[0..0] of TPUCUUnicodeCharRange=(
(68736,68863)
);

const PUCUUnicodeIgnoreCaseBlockBlocks201:array[0..0] of TPUCUUnicodeCharRange=(
(69216,69247)
);

const PUCUUnicodeIgnoreCaseBlockBlocks202:array[0..0] of TPUCUUnicodeCharRange=(
(69632,69759)
);

const PUCUUnicodeIgnoreCaseBlockBlocks203:array[0..0] of TPUCUUnicodeCharRange=(
(69760,69839)
);

const PUCUUnicodeIgnoreCaseBlockBlocks204:array[0..0] of TPUCUUnicodeCharRange=(
(69840,69887)
);

const PUCUUnicodeIgnoreCaseBlockBlocks205:array[0..0] of TPUCUUnicodeCharRange=(
(69888,69967)
);

const PUCUUnicodeIgnoreCaseBlockBlocks206:array[0..0] of TPUCUUnicodeCharRange=(
(69968,70015)
);

const PUCUUnicodeIgnoreCaseBlockBlocks207:array[0..0] of TPUCUUnicodeCharRange=(
(70016,70111)
);

const PUCUUnicodeIgnoreCaseBlockBlocks208:array[0..0] of TPUCUUnicodeCharRange=(
(70112,70143)
);

const PUCUUnicodeIgnoreCaseBlockBlocks209:array[0..0] of TPUCUUnicodeCharRange=(
(70144,70223)
);

const PUCUUnicodeIgnoreCaseBlockBlocks210:array[0..0] of TPUCUUnicodeCharRange=(
(70272,70319)
);

const PUCUUnicodeIgnoreCaseBlockBlocks211:array[0..0] of TPUCUUnicodeCharRange=(
(70320,70399)
);

const PUCUUnicodeIgnoreCaseBlockBlocks212:array[0..0] of TPUCUUnicodeCharRange=(
(70400,70527)
);

const PUCUUnicodeIgnoreCaseBlockBlocks213:array[0..0] of TPUCUUnicodeCharRange=(
(70656,70783)
);

const PUCUUnicodeIgnoreCaseBlockBlocks214:array[0..0] of TPUCUUnicodeCharRange=(
(70784,70879)
);

const PUCUUnicodeIgnoreCaseBlockBlocks215:array[0..0] of TPUCUUnicodeCharRange=(
(71040,71167)
);

const PUCUUnicodeIgnoreCaseBlockBlocks216:array[0..0] of TPUCUUnicodeCharRange=(
(71168,71263)
);

const PUCUUnicodeIgnoreCaseBlockBlocks217:array[0..0] of TPUCUUnicodeCharRange=(
(71264,71295)
);

const PUCUUnicodeIgnoreCaseBlockBlocks218:array[0..0] of TPUCUUnicodeCharRange=(
(71296,71375)
);

const PUCUUnicodeIgnoreCaseBlockBlocks219:array[0..0] of TPUCUUnicodeCharRange=(
(71424,71487)
);

const PUCUUnicodeIgnoreCaseBlockBlocks220:array[0..0] of TPUCUUnicodeCharRange=(
(71840,71935)
);

const PUCUUnicodeIgnoreCaseBlockBlocks221:array[0..0] of TPUCUUnicodeCharRange=(
(72384,72447)
);

const PUCUUnicodeIgnoreCaseBlockBlocks222:array[0..0] of TPUCUUnicodeCharRange=(
(72704,72815)
);

const PUCUUnicodeIgnoreCaseBlockBlocks223:array[0..0] of TPUCUUnicodeCharRange=(
(72816,72895)
);

const PUCUUnicodeIgnoreCaseBlockBlocks224:array[0..0] of TPUCUUnicodeCharRange=(
(73728,74751)
);

const PUCUUnicodeIgnoreCaseBlockBlocks225:array[0..0] of TPUCUUnicodeCharRange=(
(74752,74879)
);

const PUCUUnicodeIgnoreCaseBlockBlocks226:array[0..0] of TPUCUUnicodeCharRange=(
(74880,75087)
);

const PUCUUnicodeIgnoreCaseBlockBlocks227:array[0..0] of TPUCUUnicodeCharRange=(
(77824,78895)
);

const PUCUUnicodeIgnoreCaseBlockBlocks228:array[0..0] of TPUCUUnicodeCharRange=(
(82944,83583)
);

const PUCUUnicodeIgnoreCaseBlockBlocks229:array[0..0] of TPUCUUnicodeCharRange=(
(92160,92735)
);

const PUCUUnicodeIgnoreCaseBlockBlocks230:array[0..0] of TPUCUUnicodeCharRange=(
(92736,92783)
);

const PUCUUnicodeIgnoreCaseBlockBlocks231:array[0..0] of TPUCUUnicodeCharRange=(
(92880,92927)
);

const PUCUUnicodeIgnoreCaseBlockBlocks232:array[0..0] of TPUCUUnicodeCharRange=(
(92928,93071)
);

const PUCUUnicodeIgnoreCaseBlockBlocks233:array[0..0] of TPUCUUnicodeCharRange=(
(93952,94111)
);

const PUCUUnicodeIgnoreCaseBlockBlocks234:array[0..0] of TPUCUUnicodeCharRange=(
(94176,94207)
);

const PUCUUnicodeIgnoreCaseBlockBlocks235:array[0..0] of TPUCUUnicodeCharRange=(
(94208,100351)
);

const PUCUUnicodeIgnoreCaseBlockBlocks236:array[0..0] of TPUCUUnicodeCharRange=(
(100352,101119)
);

const PUCUUnicodeIgnoreCaseBlockBlocks237:array[0..0] of TPUCUUnicodeCharRange=(
(110592,110847)
);

const PUCUUnicodeIgnoreCaseBlockBlocks238:array[0..0] of TPUCUUnicodeCharRange=(
(113664,113823)
);

const PUCUUnicodeIgnoreCaseBlockBlocks239:array[0..0] of TPUCUUnicodeCharRange=(
(113824,113839)
);

const PUCUUnicodeIgnoreCaseBlockBlocks240:array[0..0] of TPUCUUnicodeCharRange=(
(118784,119039)
);

const PUCUUnicodeIgnoreCaseBlockBlocks241:array[0..0] of TPUCUUnicodeCharRange=(
(119040,119295)
);

const PUCUUnicodeIgnoreCaseBlockBlocks242:array[0..0] of TPUCUUnicodeCharRange=(
(119296,119375)
);

const PUCUUnicodeIgnoreCaseBlockBlocks243:array[0..0] of TPUCUUnicodeCharRange=(
(119552,119647)
);

const PUCUUnicodeIgnoreCaseBlockBlocks244:array[0..0] of TPUCUUnicodeCharRange=(
(119648,119679)
);

const PUCUUnicodeIgnoreCaseBlockBlocks245:array[0..0] of TPUCUUnicodeCharRange=(
(119808,120831)
);

const PUCUUnicodeIgnoreCaseBlockBlocks246:array[0..0] of TPUCUUnicodeCharRange=(
(120832,121519)
);

const PUCUUnicodeIgnoreCaseBlockBlocks247:array[0..0] of TPUCUUnicodeCharRange=(
(122880,122927)
);

const PUCUUnicodeIgnoreCaseBlockBlocks248:array[0..0] of TPUCUUnicodeCharRange=(
(124928,125151)
);

const PUCUUnicodeIgnoreCaseBlockBlocks249:array[0..0] of TPUCUUnicodeCharRange=(
(125184,125279)
);

const PUCUUnicodeIgnoreCaseBlockBlocks250:array[0..0] of TPUCUUnicodeCharRange=(
(126464,126719)
);

const PUCUUnicodeIgnoreCaseBlockBlocks251:array[0..0] of TPUCUUnicodeCharRange=(
(126976,127023)
);

const PUCUUnicodeIgnoreCaseBlockBlocks252:array[0..0] of TPUCUUnicodeCharRange=(
(127024,127135)
);

const PUCUUnicodeIgnoreCaseBlockBlocks253:array[0..0] of TPUCUUnicodeCharRange=(
(127136,127231)
);

const PUCUUnicodeIgnoreCaseBlockBlocks254:array[0..0] of TPUCUUnicodeCharRange=(
(127232,127487)
);

const PUCUUnicodeIgnoreCaseBlockBlocks255:array[0..0] of TPUCUUnicodeCharRange=(
(127488,127743)
);

const PUCUUnicodeIgnoreCaseBlockBlocks256:array[0..0] of TPUCUUnicodeCharRange=(
(127744,128511)
);

const PUCUUnicodeIgnoreCaseBlockBlocks257:array[0..0] of TPUCUUnicodeCharRange=(
(128512,128591)
);

const PUCUUnicodeIgnoreCaseBlockBlocks258:array[0..0] of TPUCUUnicodeCharRange=(
(128592,128639)
);

const PUCUUnicodeIgnoreCaseBlockBlocks259:array[0..0] of TPUCUUnicodeCharRange=(
(128640,128767)
);

const PUCUUnicodeIgnoreCaseBlockBlocks260:array[0..0] of TPUCUUnicodeCharRange=(
(128768,128895)
);

const PUCUUnicodeIgnoreCaseBlockBlocks261:array[0..0] of TPUCUUnicodeCharRange=(
(128896,129023)
);

const PUCUUnicodeIgnoreCaseBlockBlocks262:array[0..0] of TPUCUUnicodeCharRange=(
(129024,129279)
);

const PUCUUnicodeIgnoreCaseBlockBlocks263:array[0..0] of TPUCUUnicodeCharRange=(
(129280,129535)
);

const PUCUUnicodeIgnoreCaseBlockBlocks264:array[0..0] of TPUCUUnicodeCharRange=(
(131072,173791)
);

const PUCUUnicodeIgnoreCaseBlockBlocks265:array[0..0] of TPUCUUnicodeCharRange=(
(173824,177983)
);

const PUCUUnicodeIgnoreCaseBlockBlocks266:array[0..0] of TPUCUUnicodeCharRange=(
(177984,178207)
);

const PUCUUnicodeIgnoreCaseBlockBlocks267:array[0..0] of TPUCUUnicodeCharRange=(
(178208,183983)
);

const PUCUUnicodeIgnoreCaseBlockBlocks268:array[0..0] of TPUCUUnicodeCharRange=(
(194560,195103)
);

const PUCUUnicodeIgnoreCaseBlockBlocks269:array[0..0] of TPUCUUnicodeCharRange=(
(917504,917631)
);

const PUCUUnicodeIgnoreCaseBlockBlocks270:array[0..0] of TPUCUUnicodeCharRange=(
(917760,917999)
);

const PUCUUnicodeIgnoreCaseBlockBlocks271:array[0..0] of TPUCUUnicodeCharRange=(
(983040,1048575)
);

const PUCUUnicodeIgnoreCaseBlockBlocks272:array[0..0] of TPUCUUnicodeCharRange=(
(1048576,1114111)
);

const PUCUUnicodeIgnoreCaseBlockBlocksData:array[0..272] of pointer=(
@PUCUUnicodeIgnoreCaseBlockBlocks0,
@PUCUUnicodeIgnoreCaseBlockBlocks1,
@PUCUUnicodeIgnoreCaseBlockBlocks2,
@PUCUUnicodeIgnoreCaseBlockBlocks3,
@PUCUUnicodeIgnoreCaseBlockBlocks4,
@PUCUUnicodeIgnoreCaseBlockBlocks5,
@PUCUUnicodeIgnoreCaseBlockBlocks6,
@PUCUUnicodeIgnoreCaseBlockBlocks7,
@PUCUUnicodeIgnoreCaseBlockBlocks8,
@PUCUUnicodeIgnoreCaseBlockBlocks9,
@PUCUUnicodeIgnoreCaseBlockBlocks10,
@PUCUUnicodeIgnoreCaseBlockBlocks11,
@PUCUUnicodeIgnoreCaseBlockBlocks12,
@PUCUUnicodeIgnoreCaseBlockBlocks13,
@PUCUUnicodeIgnoreCaseBlockBlocks14,
@PUCUUnicodeIgnoreCaseBlockBlocks15,
@PUCUUnicodeIgnoreCaseBlockBlocks16,
@PUCUUnicodeIgnoreCaseBlockBlocks17,
@PUCUUnicodeIgnoreCaseBlockBlocks18,
@PUCUUnicodeIgnoreCaseBlockBlocks19,
@PUCUUnicodeIgnoreCaseBlockBlocks20,
@PUCUUnicodeIgnoreCaseBlockBlocks21,
@PUCUUnicodeIgnoreCaseBlockBlocks22,
@PUCUUnicodeIgnoreCaseBlockBlocks23,
@PUCUUnicodeIgnoreCaseBlockBlocks24,
@PUCUUnicodeIgnoreCaseBlockBlocks25,
@PUCUUnicodeIgnoreCaseBlockBlocks26,
@PUCUUnicodeIgnoreCaseBlockBlocks27,
@PUCUUnicodeIgnoreCaseBlockBlocks28,
@PUCUUnicodeIgnoreCaseBlockBlocks29,
@PUCUUnicodeIgnoreCaseBlockBlocks30,
@PUCUUnicodeIgnoreCaseBlockBlocks31,
@PUCUUnicodeIgnoreCaseBlockBlocks32,
@PUCUUnicodeIgnoreCaseBlockBlocks33,
@PUCUUnicodeIgnoreCaseBlockBlocks34,
@PUCUUnicodeIgnoreCaseBlockBlocks35,
@PUCUUnicodeIgnoreCaseBlockBlocks36,
@PUCUUnicodeIgnoreCaseBlockBlocks37,
@PUCUUnicodeIgnoreCaseBlockBlocks38,
@PUCUUnicodeIgnoreCaseBlockBlocks39,
@PUCUUnicodeIgnoreCaseBlockBlocks40,
@PUCUUnicodeIgnoreCaseBlockBlocks41,
@PUCUUnicodeIgnoreCaseBlockBlocks42,
@PUCUUnicodeIgnoreCaseBlockBlocks43,
@PUCUUnicodeIgnoreCaseBlockBlocks44,
@PUCUUnicodeIgnoreCaseBlockBlocks45,
@PUCUUnicodeIgnoreCaseBlockBlocks46,
@PUCUUnicodeIgnoreCaseBlockBlocks47,
@PUCUUnicodeIgnoreCaseBlockBlocks48,
@PUCUUnicodeIgnoreCaseBlockBlocks49,
@PUCUUnicodeIgnoreCaseBlockBlocks50,
@PUCUUnicodeIgnoreCaseBlockBlocks51,
@PUCUUnicodeIgnoreCaseBlockBlocks52,
@PUCUUnicodeIgnoreCaseBlockBlocks53,
@PUCUUnicodeIgnoreCaseBlockBlocks54,
@PUCUUnicodeIgnoreCaseBlockBlocks55,
@PUCUUnicodeIgnoreCaseBlockBlocks56,
@PUCUUnicodeIgnoreCaseBlockBlocks57,
@PUCUUnicodeIgnoreCaseBlockBlocks58,
@PUCUUnicodeIgnoreCaseBlockBlocks59,
@PUCUUnicodeIgnoreCaseBlockBlocks60,
@PUCUUnicodeIgnoreCaseBlockBlocks61,
@PUCUUnicodeIgnoreCaseBlockBlocks62,
@PUCUUnicodeIgnoreCaseBlockBlocks63,
@PUCUUnicodeIgnoreCaseBlockBlocks64,
@PUCUUnicodeIgnoreCaseBlockBlocks65,
@PUCUUnicodeIgnoreCaseBlockBlocks66,
@PUCUUnicodeIgnoreCaseBlockBlocks67,
@PUCUUnicodeIgnoreCaseBlockBlocks68,
@PUCUUnicodeIgnoreCaseBlockBlocks69,
@PUCUUnicodeIgnoreCaseBlockBlocks70,
@PUCUUnicodeIgnoreCaseBlockBlocks71,
@PUCUUnicodeIgnoreCaseBlockBlocks72,
@PUCUUnicodeIgnoreCaseBlockBlocks73,
@PUCUUnicodeIgnoreCaseBlockBlocks74,
@PUCUUnicodeIgnoreCaseBlockBlocks75,
@PUCUUnicodeIgnoreCaseBlockBlocks76,
@PUCUUnicodeIgnoreCaseBlockBlocks77,
@PUCUUnicodeIgnoreCaseBlockBlocks78,
@PUCUUnicodeIgnoreCaseBlockBlocks79,
@PUCUUnicodeIgnoreCaseBlockBlocks80,
@PUCUUnicodeIgnoreCaseBlockBlocks81,
@PUCUUnicodeIgnoreCaseBlockBlocks82,
@PUCUUnicodeIgnoreCaseBlockBlocks83,
@PUCUUnicodeIgnoreCaseBlockBlocks84,
@PUCUUnicodeIgnoreCaseBlockBlocks85,
@PUCUUnicodeIgnoreCaseBlockBlocks86,
@PUCUUnicodeIgnoreCaseBlockBlocks87,
@PUCUUnicodeIgnoreCaseBlockBlocks88,
@PUCUUnicodeIgnoreCaseBlockBlocks89,
@PUCUUnicodeIgnoreCaseBlockBlocks90,
@PUCUUnicodeIgnoreCaseBlockBlocks91,
@PUCUUnicodeIgnoreCaseBlockBlocks92,
@PUCUUnicodeIgnoreCaseBlockBlocks93,
@PUCUUnicodeIgnoreCaseBlockBlocks94,
@PUCUUnicodeIgnoreCaseBlockBlocks95,
@PUCUUnicodeIgnoreCaseBlockBlocks96,
@PUCUUnicodeIgnoreCaseBlockBlocks97,
@PUCUUnicodeIgnoreCaseBlockBlocks98,
@PUCUUnicodeIgnoreCaseBlockBlocks99,
@PUCUUnicodeIgnoreCaseBlockBlocks100,
@PUCUUnicodeIgnoreCaseBlockBlocks101,
@PUCUUnicodeIgnoreCaseBlockBlocks102,
@PUCUUnicodeIgnoreCaseBlockBlocks103,
@PUCUUnicodeIgnoreCaseBlockBlocks104,
@PUCUUnicodeIgnoreCaseBlockBlocks105,
@PUCUUnicodeIgnoreCaseBlockBlocks106,
@PUCUUnicodeIgnoreCaseBlockBlocks107,
@PUCUUnicodeIgnoreCaseBlockBlocks108,
@PUCUUnicodeIgnoreCaseBlockBlocks109,
@PUCUUnicodeIgnoreCaseBlockBlocks110,
@PUCUUnicodeIgnoreCaseBlockBlocks111,
@PUCUUnicodeIgnoreCaseBlockBlocks112,
@PUCUUnicodeIgnoreCaseBlockBlocks113,
@PUCUUnicodeIgnoreCaseBlockBlocks114,
@PUCUUnicodeIgnoreCaseBlockBlocks115,
@PUCUUnicodeIgnoreCaseBlockBlocks116,
@PUCUUnicodeIgnoreCaseBlockBlocks117,
@PUCUUnicodeIgnoreCaseBlockBlocks118,
@PUCUUnicodeIgnoreCaseBlockBlocks119,
@PUCUUnicodeIgnoreCaseBlockBlocks120,
@PUCUUnicodeIgnoreCaseBlockBlocks121,
@PUCUUnicodeIgnoreCaseBlockBlocks122,
@PUCUUnicodeIgnoreCaseBlockBlocks123,
@PUCUUnicodeIgnoreCaseBlockBlocks124,
@PUCUUnicodeIgnoreCaseBlockBlocks125,
@PUCUUnicodeIgnoreCaseBlockBlocks126,
@PUCUUnicodeIgnoreCaseBlockBlocks127,
@PUCUUnicodeIgnoreCaseBlockBlocks128,
@PUCUUnicodeIgnoreCaseBlockBlocks129,
@PUCUUnicodeIgnoreCaseBlockBlocks130,
@PUCUUnicodeIgnoreCaseBlockBlocks131,
@PUCUUnicodeIgnoreCaseBlockBlocks132,
@PUCUUnicodeIgnoreCaseBlockBlocks133,
@PUCUUnicodeIgnoreCaseBlockBlocks134,
@PUCUUnicodeIgnoreCaseBlockBlocks135,
@PUCUUnicodeIgnoreCaseBlockBlocks136,
@PUCUUnicodeIgnoreCaseBlockBlocks137,
@PUCUUnicodeIgnoreCaseBlockBlocks138,
@PUCUUnicodeIgnoreCaseBlockBlocks139,
@PUCUUnicodeIgnoreCaseBlockBlocks140,
@PUCUUnicodeIgnoreCaseBlockBlocks141,
@PUCUUnicodeIgnoreCaseBlockBlocks142,
@PUCUUnicodeIgnoreCaseBlockBlocks143,
@PUCUUnicodeIgnoreCaseBlockBlocks144,
@PUCUUnicodeIgnoreCaseBlockBlocks145,
@PUCUUnicodeIgnoreCaseBlockBlocks146,
@PUCUUnicodeIgnoreCaseBlockBlocks147,
@PUCUUnicodeIgnoreCaseBlockBlocks148,
@PUCUUnicodeIgnoreCaseBlockBlocks149,
@PUCUUnicodeIgnoreCaseBlockBlocks150,
@PUCUUnicodeIgnoreCaseBlockBlocks151,
@PUCUUnicodeIgnoreCaseBlockBlocks152,
@PUCUUnicodeIgnoreCaseBlockBlocks153,
@PUCUUnicodeIgnoreCaseBlockBlocks154,
@PUCUUnicodeIgnoreCaseBlockBlocks155,
@PUCUUnicodeIgnoreCaseBlockBlocks156,
@PUCUUnicodeIgnoreCaseBlockBlocks157,
@PUCUUnicodeIgnoreCaseBlockBlocks158,
@PUCUUnicodeIgnoreCaseBlockBlocks159,
@PUCUUnicodeIgnoreCaseBlockBlocks160,
@PUCUUnicodeIgnoreCaseBlockBlocks161,
@PUCUUnicodeIgnoreCaseBlockBlocks162,
@PUCUUnicodeIgnoreCaseBlockBlocks163,
@PUCUUnicodeIgnoreCaseBlockBlocks164,
@PUCUUnicodeIgnoreCaseBlockBlocks165,
@PUCUUnicodeIgnoreCaseBlockBlocks166,
@PUCUUnicodeIgnoreCaseBlockBlocks167,
@PUCUUnicodeIgnoreCaseBlockBlocks168,
@PUCUUnicodeIgnoreCaseBlockBlocks169,
@PUCUUnicodeIgnoreCaseBlockBlocks170,
@PUCUUnicodeIgnoreCaseBlockBlocks171,
@PUCUUnicodeIgnoreCaseBlockBlocks172,
@PUCUUnicodeIgnoreCaseBlockBlocks173,
@PUCUUnicodeIgnoreCaseBlockBlocks174,
@PUCUUnicodeIgnoreCaseBlockBlocks175,
@PUCUUnicodeIgnoreCaseBlockBlocks176,
@PUCUUnicodeIgnoreCaseBlockBlocks177,
@PUCUUnicodeIgnoreCaseBlockBlocks178,
@PUCUUnicodeIgnoreCaseBlockBlocks179,
@PUCUUnicodeIgnoreCaseBlockBlocks180,
@PUCUUnicodeIgnoreCaseBlockBlocks181,
@PUCUUnicodeIgnoreCaseBlockBlocks182,
@PUCUUnicodeIgnoreCaseBlockBlocks183,
@PUCUUnicodeIgnoreCaseBlockBlocks184,
@PUCUUnicodeIgnoreCaseBlockBlocks185,
@PUCUUnicodeIgnoreCaseBlockBlocks186,
@PUCUUnicodeIgnoreCaseBlockBlocks187,
@PUCUUnicodeIgnoreCaseBlockBlocks188,
@PUCUUnicodeIgnoreCaseBlockBlocks189,
@PUCUUnicodeIgnoreCaseBlockBlocks190,
@PUCUUnicodeIgnoreCaseBlockBlocks191,
@PUCUUnicodeIgnoreCaseBlockBlocks192,
@PUCUUnicodeIgnoreCaseBlockBlocks193,
@PUCUUnicodeIgnoreCaseBlockBlocks194,
@PUCUUnicodeIgnoreCaseBlockBlocks195,
@PUCUUnicodeIgnoreCaseBlockBlocks196,
@PUCUUnicodeIgnoreCaseBlockBlocks197,
@PUCUUnicodeIgnoreCaseBlockBlocks198,
@PUCUUnicodeIgnoreCaseBlockBlocks199,
@PUCUUnicodeIgnoreCaseBlockBlocks200,
@PUCUUnicodeIgnoreCaseBlockBlocks201,
@PUCUUnicodeIgnoreCaseBlockBlocks202,
@PUCUUnicodeIgnoreCaseBlockBlocks203,
@PUCUUnicodeIgnoreCaseBlockBlocks204,
@PUCUUnicodeIgnoreCaseBlockBlocks205,
@PUCUUnicodeIgnoreCaseBlockBlocks206,
@PUCUUnicodeIgnoreCaseBlockBlocks207,
@PUCUUnicodeIgnoreCaseBlockBlocks208,
@PUCUUnicodeIgnoreCaseBlockBlocks209,
@PUCUUnicodeIgnoreCaseBlockBlocks210,
@PUCUUnicodeIgnoreCaseBlockBlocks211,
@PUCUUnicodeIgnoreCaseBlockBlocks212,
@PUCUUnicodeIgnoreCaseBlockBlocks213,
@PUCUUnicodeIgnoreCaseBlockBlocks214,
@PUCUUnicodeIgnoreCaseBlockBlocks215,
@PUCUUnicodeIgnoreCaseBlockBlocks216,
@PUCUUnicodeIgnoreCaseBlockBlocks217,
@PUCUUnicodeIgnoreCaseBlockBlocks218,
@PUCUUnicodeIgnoreCaseBlockBlocks219,
@PUCUUnicodeIgnoreCaseBlockBlocks220,
@PUCUUnicodeIgnoreCaseBlockBlocks221,
@PUCUUnicodeIgnoreCaseBlockBlocks222,
@PUCUUnicodeIgnoreCaseBlockBlocks223,
@PUCUUnicodeIgnoreCaseBlockBlocks224,
@PUCUUnicodeIgnoreCaseBlockBlocks225,
@PUCUUnicodeIgnoreCaseBlockBlocks226,
@PUCUUnicodeIgnoreCaseBlockBlocks227,
@PUCUUnicodeIgnoreCaseBlockBlocks228,
@PUCUUnicodeIgnoreCaseBlockBlocks229,
@PUCUUnicodeIgnoreCaseBlockBlocks230,
@PUCUUnicodeIgnoreCaseBlockBlocks231,
@PUCUUnicodeIgnoreCaseBlockBlocks232,
@PUCUUnicodeIgnoreCaseBlockBlocks233,
@PUCUUnicodeIgnoreCaseBlockBlocks234,
@PUCUUnicodeIgnoreCaseBlockBlocks235,
@PUCUUnicodeIgnoreCaseBlockBlocks236,
@PUCUUnicodeIgnoreCaseBlockBlocks237,
@PUCUUnicodeIgnoreCaseBlockBlocks238,
@PUCUUnicodeIgnoreCaseBlockBlocks239,
@PUCUUnicodeIgnoreCaseBlockBlocks240,
@PUCUUnicodeIgnoreCaseBlockBlocks241,
@PUCUUnicodeIgnoreCaseBlockBlocks242,
@PUCUUnicodeIgnoreCaseBlockBlocks243,
@PUCUUnicodeIgnoreCaseBlockBlocks244,
@PUCUUnicodeIgnoreCaseBlockBlocks245,
@PUCUUnicodeIgnoreCaseBlockBlocks246,
@PUCUUnicodeIgnoreCaseBlockBlocks247,
@PUCUUnicodeIgnoreCaseBlockBlocks248,
@PUCUUnicodeIgnoreCaseBlockBlocks249,
@PUCUUnicodeIgnoreCaseBlockBlocks250,
@PUCUUnicodeIgnoreCaseBlockBlocks251,
@PUCUUnicodeIgnoreCaseBlockBlocks252,
@PUCUUnicodeIgnoreCaseBlockBlocks253,
@PUCUUnicodeIgnoreCaseBlockBlocks254,
@PUCUUnicodeIgnoreCaseBlockBlocks255,
@PUCUUnicodeIgnoreCaseBlockBlocks256,
@PUCUUnicodeIgnoreCaseBlockBlocks257,
@PUCUUnicodeIgnoreCaseBlockBlocks258,
@PUCUUnicodeIgnoreCaseBlockBlocks259,
@PUCUUnicodeIgnoreCaseBlockBlocks260,
@PUCUUnicodeIgnoreCaseBlockBlocks261,
@PUCUUnicodeIgnoreCaseBlockBlocks262,
@PUCUUnicodeIgnoreCaseBlockBlocks263,
@PUCUUnicodeIgnoreCaseBlockBlocks264,
@PUCUUnicodeIgnoreCaseBlockBlocks265,
@PUCUUnicodeIgnoreCaseBlockBlocks266,
@PUCUUnicodeIgnoreCaseBlockBlocks267,
@PUCUUnicodeIgnoreCaseBlockBlocks268,
@PUCUUnicodeIgnoreCaseBlockBlocks269,
@PUCUUnicodeIgnoreCaseBlockBlocks270,
@PUCUUnicodeIgnoreCaseBlockBlocks271,
@PUCUUnicodeIgnoreCaseBlockBlocks272
);

const PUCUUnicodeIgnoreCaseBlockBlocksCounts:array[0..272] of longint=(
1,
3,
4,
17,
21,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
4,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
8,
1,
1,
3,
1,
1,
2,
2,
1,
1,
1,
1,
4,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
8,
1,
4,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
10,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1
);

const PUCUCountUnicodeAdditionalBlocks=3;

const PUCUUnicodeAdditionalBlocks0:array[0..161] of TPUCUUnicodeCharRange=(
(45,59),
(65,91),
(95,123),
(183,184),
(192,306),
(308,319),
(321,452),
(461,497),
(500,502),
(506,536),
(592,681),
(699,706),
(720,722),
(768,838),
(864,866),
(902,983),
(986,1012),
(1025,1159),
(1168,1221),
(1223,1225),
(1227,1229),
(1232,1260),
(1262,1270),
(1272,1274),
(1329,1367),
(1369,1370),
(1377,1415),
(1425,1477),
(1488,1515),
(1520,1523),
(1569,1595),
(1600,1619),
(1632,1642),
(1648,1720),
(1722,1774),
(1776,1786),
(2305,2362),
(2364,2382),
(2385,2389),
(2392,2404),
(2406,2416),
(2433,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2492,2501),
(2503,2505),
(2507,2510),
(2519,2520),
(2524,2532),
(2534,2546),
(2562,2563),
(2565,2571),
(2575,2577),
(2579,2618),
(2620,2627),
(2631,2633),
(2635,2638),
(2649,2655),
(2662,2677),
(2689,2746),
(2748,2766),
(2784,2785),
(2790,2800),
(2817,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2876,2884),
(2887,2889),
(2891,2894),
(2902,2904),
(2908,2914),
(2918,2928),
(2946,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3006,3011),
(3014,3022),
(3031,3032),
(3047,3056),
(3073,3130),
(3134,3150),
(3157,3159),
(3168,3170),
(3174,3184),
(3202,3258),
(3262,3278),
(3285,3287),
(3294,3298),
(3302,3312),
(3330,3386),
(3390,3396),
(3398,3406),
(3415,3416),
(3424,3426),
(3430,3440),
(3585,3643),
(3648,3674),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3774),
(3776,3790),
(3792,3802),
(3864,3866),
(3872,3882),
(3893,3898),
(3902,3946),
(3953,3980),
(3984,4014),
(4017,4026),
(4256,4294),
(4304,4343),
(4352,4371),
(4412,4417),
(4428,4433),
(4436,4438),
(4441,4442),
(4447,4458),
(4461,4463),
(4466,4470),
(4510,4511),
(4520,4521),
(4523,4524),
(4526,4528),
(4535,4547),
(4587,4588),
(4592,4593),
(4601,4602),
(7680,7836),
(7840,7930),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8127),
(8130,8141),
(8144,8148),
(8150,8156),
(8160,8173),
(8178,8189),
(8400,8413),
(8417,8418),
(8486,8487),
(8490,8492),
(8494,8495),
(8576,8579),
(12293,12296),
(12321,12342),
(12353,12437),
(12441,12443),
(12445,12447),
(12449,12543),
(12549,12589),
(19968,40870),
(44032,55204)
);

const PUCUUnicodeAdditionalBlocks1:array[0..19] of TPUCUUnicodeCharRange=(
(48,58),
(1632,1642),
(1776,1786),
(2406,2416),
(2534,2544),
(2662,2672),
(2790,2800),
(2918,2928),
(3047,3056),
(3174,3184),
(3302,3312),
(3430,3440),
(3664,3674),
(3792,3802),
(3872,3882),
(4160,4170),
(4969,4978),
(6112,6122),
(6160,6170),
(65296,65306)
);

const PUCUUnicodeAdditionalBlocks2:array[0..116] of TPUCUUnicodeCharRange=(
(58,59),
(65,91),
(95,123),
(192,306),
(308,319),
(321,452),
(461,497),
(500,502),
(506,536),
(592,681),
(699,706),
(902,983),
(986,1012),
(1025,1154),
(1168,1221),
(1223,1225),
(1227,1229),
(1232,1260),
(1262,1270),
(1272,1274),
(1329,1367),
(1369,1370),
(1377,1415),
(1488,1515),
(1520,1523),
(1569,1595),
(1601,1611),
(1649,1720),
(1722,1750),
(1765,1767),
(2309,2362),
(2365,2366),
(2392,2402),
(2437,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2524,2530),
(2544,2546),
(2565,2571),
(2575,2577),
(2579,2618),
(2649,2655),
(2674,2677),
(2693,2746),
(2749,2750),
(2784,2785),
(2821,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2877,2878),
(2908,2914),
(2949,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3077,3130),
(3168,3170),
(3205,3258),
(3294,3298),
(3333,3386),
(3424,3426),
(3585,3636),
(3648,3654),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3764),
(3773,3774),
(3776,3781),
(3904,3946),
(4256,4294),
(4304,4343),
(4352,4371),
(4412,4417),
(4428,4433),
(4436,4438),
(4441,4442),
(4447,4458),
(4461,4463),
(4466,4470),
(4510,4511),
(4520,4521),
(4523,4524),
(4526,4528),
(4535,4547),
(4587,4588),
(4592,4593),
(4601,4602),
(7680,7836),
(7840,7930),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8127),
(8130,8141),
(8144,8148),
(8150,8156),
(8160,8173),
(8178,8189),
(8486,8487),
(8490,8492),
(8494,8495),
(8576,8579),
(12295,12296),
(12321,12330),
(12353,12437),
(12449,12539),
(12549,12589),
(19968,40870),
(44032,55204)
);

const PUCUUnicodeAdditionalBlocks3:array[0..238] of TPUCUUnicodeCharRange=(
(36,37),
(43,44),
(48,58),
(60,63),
(65,91),
(94,127),
(162,564),
(592,686),
(688,751),
(768,848),
(864,880),
(884,886),
(890,891),
(900,1015),
(1024,1270),
(1272,1274),
(1280,1296),
(1329,1367),
(1369,1370),
(1377,1416),
(1425,1477),
(1488,1515),
(1520,1523),
(1569,1595),
(1600,1622),
(1632,1642),
(1646,1774),
(1776,1791),
(1808,1837),
(1840,1867),
(1920,1970),
(2305,2362),
(2364,2382),
(2384,2389),
(2392,2404),
(2406,2416),
(2433,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2492,2501),
(2503,2505),
(2507,2510),
(2519,2520),
(2524,2532),
(2534,2555),
(2562,2563),
(2565,2571),
(2575,2577),
(2579,2618),
(2620,2627),
(2631,2633),
(2635,2638),
(2649,2655),
(2662,2677),
(2689,2746),
(2748,2766),
(2768,2769),
(2784,2785),
(2790,2800),
(2817,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2876,2884),
(2887,2889),
(2891,2894),
(2902,2904),
(2908,2914),
(2918,2929),
(2946,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3006,3011),
(3014,3022),
(3031,3032),
(3047,3059),
(3073,3130),
(3134,3150),
(3157,3159),
(3168,3170),
(3174,3184),
(3202,3258),
(3262,3278),
(3285,3287),
(3294,3298),
(3302,3312),
(3330,3386),
(3390,3396),
(3398,3406),
(3415,3416),
(3424,3426),
(3430,3440),
(3458,3479),
(3482,3518),
(3520,3527),
(3530,3531),
(3535,3552),
(3570,3572),
(3585,3643),
(3647,3674),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3774),
(3776,3790),
(3792,3802),
(3804,3806),
(3840,3844),
(3859,3898),
(3902,3947),
(3953,3980),
(3984,4045),
(4047,4048),
(4096,4147),
(4150,4154),
(4160,4170),
(4176,4186),
(4256,4294),
(4304,4345),
(4352,4442),
(4447,4515),
(4520,4602),
(4608,4686),
(4688,4702),
(4704,4750),
(4752,4790),
(4792,4806),
(4808,4886),
(4888,4955),
(4969,4989),
(5024,5109),
(5121,5741),
(5743,5751),
(5761,5787),
(5792,5867),
(5870,5873),
(5888,5909),
(5920,5941),
(5952,5972),
(5984,6004),
(6016,6100),
(6103,6104),
(6107,6109),
(6112,6122),
(6155,6158),
(6160,6170),
(6176,6264),
(6272,6314),
(7680,7836),
(7840,7930),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8148),
(8150,8176),
(8178,8191),
(8260,8261),
(8274,8275),
(8304,8306),
(8308,8317),
(8319,8333),
(8352,8370),
(8400,8427),
(8448,8507),
(8509,8524),
(8531,8580),
(8592,9001),
(9003,9140),
(9143,9167),
(9216,9255),
(9280,9291),
(9312,9748),
(9750,9854),
(9856,9866),
(9985,9994),
(9996,10067),
(10070,10079),
(10081,10088),
(10102,10133),
(10136,10175),
(10192,10214),
(10224,10627),
(10649,10712),
(10716,10748),
(10750,11008),
(11904,12020),
(12032,12246),
(12272,12284),
(12292,12296),
(12306,12308),
(12320,12439),
(12441,12544),
(12549,12589),
(12593,12728),
(12784,12829),
(12832,12868),
(12881,12924),
(12927,13004),
(13008,13175),
(13179,13278),
(13280,19894),
(19968,40870),
(40960,42125),
(42128,42183),
(44032,55204),
(63744,64046),
(64048,64107),
(64256,64263),
(64275,64280),
(64285,64434),
(64467,64830),
(64848,64912),
(64914,64968),
(65008,65021),
(65024,65040),
(65056,65060),
(65122,65127),
(65129,65130),
(65136,65277),
(65284,65285),
(65291,65292),
(65296,65306),
(65308,65311),
(65313,65339),
(65342,65375),
(65382,65471),
(65474,65480),
(65482,65488),
(65490,65496),
(65498,65501),
(65504,65519),
(65532,65534)
);

const PUCUUnicodeAdditionalBlocksData:array[0..3] of pointer=(
@PUCUUnicodeAdditionalBlocks0,
@PUCUUnicodeAdditionalBlocks1,
@PUCUUnicodeAdditionalBlocks2,
@PUCUUnicodeAdditionalBlocks3
);

const PUCUUnicodeAdditionalBlocksCounts:array[0..3] of longint=(
162,
20,
117,
239
);

const PUCUCountUnicodeIgnoreCaseAdditionalBlocks=3;

const PUCUUnicodeIgnoreCaseAdditionalBlocks0:array[0..167] of TPUCUUnicodeCharRange=(
(45,59),
(65,91),
(95,123),
(183,184),
(192,452),
(454,454),
(461,497),
(499,503),
(506,537),
(544,544),
(573,573),
(579,581),
(592,681),
(699,706),
(720,722),
(768,838),
(864,866),
(895,895),
(902,983),
(986,1012),
(1017,1017),
(1024,1159),
(1168,1275),
(1329,1367),
(1369,1370),
(1377,1415),
(1425,1477),
(1488,1515),
(1520,1523),
(1569,1595),
(1600,1619),
(1632,1642),
(1648,1720),
(1722,1774),
(1776,1786),
(2305,2362),
(2364,2382),
(2385,2389),
(2392,2404),
(2406,2416),
(2433,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2492,2501),
(2503,2505),
(2507,2510),
(2519,2520),
(2524,2532),
(2534,2546),
(2562,2563),
(2565,2571),
(2575,2577),
(2579,2618),
(2620,2627),
(2631,2633),
(2635,2638),
(2649,2655),
(2662,2677),
(2689,2746),
(2748,2766),
(2784,2785),
(2790,2800),
(2817,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2876,2884),
(2887,2889),
(2891,2894),
(2902,2904),
(2908,2914),
(2918,2928),
(2946,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3006,3011),
(3014,3022),
(3031,3032),
(3047,3056),
(3073,3130),
(3134,3150),
(3157,3159),
(3168,3170),
(3174,3184),
(3202,3258),
(3262,3278),
(3285,3287),
(3294,3298),
(3302,3312),
(3330,3386),
(3390,3396),
(3398,3406),
(3415,3416),
(3424,3426),
(3430,3440),
(3585,3643),
(3648,3674),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3774),
(3776,3790),
(3792,3802),
(3864,3866),
(3872,3882),
(3893,3898),
(3902,3946),
(3953,3980),
(3984,4014),
(4017,4026),
(4256,4294),
(4304,4343),
(4352,4371),
(4412,4417),
(4428,4433),
(4436,4438),
(4441,4442),
(4447,4458),
(4461,4463),
(4466,4470),
(4510,4511),
(4520,4521),
(4523,4524),
(4526,4528),
(4535,4547),
(4587,4588),
(4592,4593),
(4601,4602),
(7680,7836),
(7840,7931),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8127),
(8130,8141),
(8144,8148),
(8150,8156),
(8160,8173),
(8178,8189),
(8400,8413),
(8417,8418),
(8486,8487),
(8490,8492),
(8494,8495),
(8576,8580),
(11362,11362),
(11364,11364),
(11373,11376),
(11520,11557),
(12293,12296),
(12321,12342),
(12353,12437),
(12441,12443),
(12445,12447),
(12449,12543),
(12549,12589),
(19968,40870),
(42893,42893),
(42922,42926),
(42928,42930),
(44032,55204)
);

const PUCUUnicodeIgnoreCaseAdditionalBlocks1:array[0..19] of TPUCUUnicodeCharRange=(
(48,58),
(1632,1642),
(1776,1786),
(2406,2416),
(2534,2544),
(2662,2672),
(2790,2800),
(2918,2928),
(3047,3056),
(3174,3184),
(3302,3312),
(3430,3440),
(3664,3674),
(3792,3802),
(3872,3882),
(4160,4170),
(4969,4978),
(6112,6122),
(6160,6170),
(65296,65306)
);

const PUCUUnicodeIgnoreCaseAdditionalBlocks2:array[0..122] of TPUCUUnicodeCharRange=(
(58,59),
(65,91),
(95,123),
(192,452),
(454,454),
(461,497),
(499,503),
(506,537),
(544,544),
(573,573),
(579,581),
(592,681),
(699,706),
(895,895),
(902,983),
(986,1012),
(1017,1017),
(1024,1154),
(1168,1275),
(1329,1367),
(1369,1370),
(1377,1415),
(1488,1515),
(1520,1523),
(1569,1595),
(1601,1611),
(1649,1720),
(1722,1750),
(1765,1767),
(2309,2362),
(2365,2366),
(2392,2402),
(2437,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2524,2530),
(2544,2546),
(2565,2571),
(2575,2577),
(2579,2618),
(2649,2655),
(2674,2677),
(2693,2746),
(2749,2750),
(2784,2785),
(2821,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2877,2878),
(2908,2914),
(2949,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3077,3130),
(3168,3170),
(3205,3258),
(3294,3298),
(3333,3386),
(3424,3426),
(3585,3636),
(3648,3654),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3764),
(3773,3774),
(3776,3781),
(3904,3946),
(4256,4294),
(4304,4343),
(4352,4371),
(4412,4417),
(4428,4433),
(4436,4438),
(4441,4442),
(4447,4458),
(4461,4463),
(4466,4470),
(4510,4511),
(4520,4521),
(4523,4524),
(4526,4528),
(4535,4547),
(4587,4588),
(4592,4593),
(4601,4602),
(7680,7836),
(7840,7931),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8127),
(8130,8141),
(8144,8148),
(8150,8156),
(8160,8173),
(8178,8189),
(8486,8487),
(8490,8492),
(8494,8495),
(8576,8580),
(11362,11362),
(11364,11364),
(11373,11376),
(11520,11557),
(12295,12296),
(12321,12330),
(12353,12437),
(12449,12539),
(12549,12589),
(19968,40870),
(42893,42893),
(42922,42926),
(42928,42930),
(44032,55204)
);

const PUCUUnicodeIgnoreCaseAdditionalBlocks3:array[0..251] of TPUCUUnicodeCharRange=(
(36,37),
(43,44),
(48,58),
(60,63),
(65,91),
(94,127),
(162,564),
(573,573),
(579,581),
(592,686),
(688,751),
(768,848),
(864,881),
(884,887),
(890,891),
(895,895),
(900,1017),
(1021,1021),
(1024,1275),
(1280,1297),
(1329,1367),
(1369,1370),
(1377,1416),
(1425,1477),
(1488,1515),
(1520,1523),
(1569,1595),
(1600,1622),
(1632,1642),
(1646,1774),
(1776,1791),
(1808,1837),
(1840,1867),
(1920,1970),
(2305,2362),
(2364,2382),
(2384,2389),
(2392,2404),
(2406,2416),
(2433,2445),
(2447,2449),
(2451,2483),
(2486,2490),
(2492,2501),
(2503,2505),
(2507,2510),
(2519,2520),
(2524,2532),
(2534,2555),
(2562,2563),
(2565,2571),
(2575,2577),
(2579,2618),
(2620,2627),
(2631,2633),
(2635,2638),
(2649,2655),
(2662,2677),
(2689,2746),
(2748,2766),
(2768,2769),
(2784,2785),
(2790,2800),
(2817,2829),
(2831,2833),
(2835,2868),
(2870,2874),
(2876,2884),
(2887,2889),
(2891,2894),
(2902,2904),
(2908,2914),
(2918,2929),
(2946,2955),
(2958,2966),
(2969,2976),
(2979,2981),
(2984,2987),
(2990,3002),
(3006,3011),
(3014,3022),
(3031,3032),
(3047,3059),
(3073,3130),
(3134,3150),
(3157,3159),
(3168,3170),
(3174,3184),
(3202,3258),
(3262,3278),
(3285,3287),
(3294,3298),
(3302,3312),
(3330,3386),
(3390,3396),
(3398,3406),
(3415,3416),
(3424,3426),
(3430,3440),
(3458,3479),
(3482,3518),
(3520,3527),
(3530,3531),
(3535,3552),
(3570,3572),
(3585,3643),
(3647,3674),
(3713,3717),
(3719,3723),
(3725,3726),
(3732,3752),
(3754,3774),
(3776,3790),
(3792,3802),
(3804,3806),
(3840,3844),
(3859,3898),
(3902,3947),
(3953,3980),
(3984,4045),
(4047,4048),
(4096,4147),
(4150,4154),
(4160,4170),
(4176,4186),
(4256,4294),
(4304,4345),
(4352,4442),
(4447,4515),
(4520,4602),
(4608,4686),
(4688,4702),
(4704,4750),
(4752,4790),
(4792,4806),
(4808,4886),
(4888,4955),
(4969,4989),
(5024,5109),
(5112,5117),
(5121,5741),
(5743,5751),
(5761,5787),
(5792,5867),
(5870,5873),
(5888,5909),
(5920,5941),
(5952,5972),
(5984,6004),
(6016,6100),
(6103,6104),
(6107,6109),
(6112,6122),
(6155,6158),
(6160,6170),
(6176,6264),
(6272,6314),
(7680,7836),
(7840,7931),
(7936,7958),
(7960,7966),
(7968,8006),
(8008,8014),
(8016,8062),
(8064,8148),
(8150,8176),
(8178,8191),
(8260,8261),
(8274,8275),
(8304,8306),
(8308,8317),
(8319,8333),
(8352,8370),
(8400,8427),
(8448,8507),
(8509,8524),
(8526,8526),
(8531,8580),
(8592,9001),
(9003,9140),
(9143,9167),
(9216,9255),
(9280,9291),
(9312,9748),
(9750,9854),
(9856,9866),
(9985,9994),
(9996,10067),
(10070,10079),
(10081,10088),
(10102,10133),
(10136,10175),
(10192,10214),
(10224,10627),
(10649,10712),
(10716,10748),
(10750,11008),
(11362,11362),
(11364,11364),
(11373,11376),
(11520,11557),
(11904,12020),
(12032,12246),
(12272,12284),
(12292,12296),
(12306,12308),
(12320,12439),
(12441,12544),
(12549,12589),
(12593,12728),
(12784,12829),
(12832,12868),
(12881,12924),
(12927,13004),
(13008,13175),
(13179,13278),
(13280,19894),
(19968,40870),
(40960,42125),
(42128,42183),
(42893,42893),
(42922,42926),
(42928,42930),
(43888,43967),
(44032,55204),
(63744,64046),
(64048,64107),
(64256,64263),
(64275,64280),
(64285,64434),
(64467,64830),
(64848,64912),
(64914,64968),
(65008,65021),
(65024,65040),
(65056,65060),
(65122,65127),
(65129,65130),
(65136,65277),
(65284,65285),
(65291,65292),
(65296,65306),
(65308,65311),
(65313,65339),
(65342,65375),
(65382,65471),
(65474,65480),
(65482,65488),
(65490,65496),
(65498,65501),
(65504,65519),
(65532,65534)
);

const PUCUUnicodeIgnoreCaseAdditionalBlocksData:array[0..3] of pointer=(
@PUCUUnicodeIgnoreCaseAdditionalBlocks0,
@PUCUUnicodeIgnoreCaseAdditionalBlocks1,
@PUCUUnicodeIgnoreCaseAdditionalBlocks2,
@PUCUUnicodeIgnoreCaseAdditionalBlocks3
);

const PUCUUnicodeIgnoreCaseAdditionalBlocksCounts:array[0..3] of longint=(
168,
20,
123,
252
);

const PUCULowerUpperCaseUnicodeCharClassSize=126;

      PUCULowerUpperCaseUnicodeCharClass:array[0..125,0..1] of longword=(
(65,90),
(97,122),
(181,181),
(192,214),
(216,222),
(224,246),
(248,311),
(313,328),
(330,396),
(398,410),
(412,425),
(428,441),
(444,445),
(447,447),
(452,495),
(497,544),
(546,563),
(570,596),
(598,599),
(601,601),
(603,604),
(608,609),
(611,611),
(613,614),
(616,620),
(623,623),
(625,626),
(629,629),
(637,637),
(640,640),
(643,643),
(647,652),
(658,658),
(669,670),
(837,837),
(880,883),
(886,887),
(891,893),
(895,895),
(902,902),
(904,906),
(908,908),
(910,911),
(913,929),
(931,943),
(945,977),
(981,1013),
(1015,1019),
(1021,1153),
(1162,1327),
(1329,1366),
(1377,1414),
(4256,4293),
(4295,4295),
(4301,4301),
(5024,5109),
(5112,5117),
(7296,7304),
(7545,7545),
(7549,7549),
(7680,7829),
(7835,7835),
(7838,7838),
(7840,7957),
(7960,7965),
(7968,8005),
(8008,8013),
(8017,8017),
(8019,8019),
(8021,8021),
(8023,8023),
(8025,8025),
(8027,8027),
(8029,8029),
(8031,8061),
(8064,8113),
(8115,8115),
(8120,8124),
(8126,8126),
(8131,8131),
(8136,8140),
(8144,8145),
(8152,8155),
(8160,8161),
(8165,8165),
(8168,8172),
(8179,8179),
(8184,8188),
(8486,8486),
(8490,8491),
(8498,8498),
(8526,8526),
(8544,8575),
(8579,8580),
(9398,9449),
(11264,11310),
(11312,11358),
(11360,11376),
(11378,11379),
(11381,11382),
(11390,11491),
(11499,11502),
(11506,11507),
(11520,11557),
(11559,11559),
(11565,11565),
(42560,42605),
(42624,42651),
(42786,42799),
(42802,42863),
(42873,42887),
(42891,42893),
(42896,42899),
(42902,42926),
(42928,42935),
(43859,43859),
(43888,43967),
(65313,65338),
(65345,65370),
(66560,66639),
(66736,66771),
(66776,66811),
(68736,68786),
(68800,68850),
(71840,71903),
(125184,125251)
);

const PUCUUnicodeClassHashMapSeedSize=297;
      PUCUUnicodeClassHashMapValueSize=297;
      PUCUUnicodeClassHashMapSize=297;

      PUCUUnicodeClassHashMapSeedBits=16;

      PUCUUnicodeClassHashMapSeeds:array[0..296] of smallint=(
-297,
3,
-295,
0,
1,
0,
0,
-292,
-289,
0,
-286,
0,
0,
-285,
-283,
-282,
0,
0,
-281,
1,
-280,
-279,
-278,
0,
-275,
-273,
0,
-272,
0,
1,
0,
2,
-269,
0,
2,
-265,
0,
-262,
1,
0,
0,
0,
0,
-260,
0,
-257,
1,
1,
-256,
-255,
-254,
1,
1,
-251,
-247,
0,
-246,
1,
-245,
-243,
-241,
-236,
0,
-235,
0,
1,
-234,
0,
1,
0,
0,
-233,
0,
0,
0,
0,
0,
1,
-232,
0,
-231,
-229,
0,
1,
-228,
1,
0,
1,
5,
1,
-227,
0,
0,
-224,
1,
1,
4,
1,
-223,
-218,
-216,
2,
5,
1,
0,
1,
-212,
1,
-211,
0,
1,
2,
1,
-210,
0,
-205,
1,
3,
-204,
1,
-203,
1,
-197,
-181,
-177,
2,
3,
-176,
0,
-165,
-164,
1,
-163,
0,
0,
-162,
-161,
13,
1,
0,
-156,
0,
-154,
0,
1,
-152,
0,
0,
-150,
1,
0,
-143,
0,
-136,
0,
0,
9,
0,
1,
-134,
0,
0,
0,
-131,
-129,
3,
2,
3,
2,
-127,
0,
0,
-126,
2,
-125,
-123,
-122,
0,
0,
-121,
0,
-120,
8,
0,
-117,
0,
0,
-116,
-114,
0,
0,
0,
5,
0,
0,
0,
3,
0,
-113,
0,
-112,
2,
-109,
1,
2,
0,
-106,
-105,
-104,
0,
0,
6,
0,
0,
-101,
-98,
-95,
1,
-90,
1,
11,
0,
0,
0,
0,
3,
0,
0,
1,
-88,
-86,
1,
-85,
0,
-82,
-81,
1,
-79,
-75,
7,
-70,
0,
29,
0,
-69,
-66,
3,
-65,
-60,
-57,
0,
-56,
-52,
-48,
-47,
-45,
0,
0,
1,
-42,
0,
-35,
-33,
0,
0,
0,
0,
0,
0,
-31,
-29,
0,
0,
-27,
5,
-18,
0,
0,
4,
1,
-17,
0,
0,
-16,
0,
-15,
4,
0,
-13,
3,
-12,
0,
-9,
0,
-7,
0,
-1
);

      PUCUUnicodeClassHashMapKeys:array[0..296] of TPUCURawByteString=(
'IsConnectorPunctuation',
'Me',
'InSpace_Separator',
'InLm',
'IsModifierLetter',
'CurrencySymbol',
'Pi',
'InSurrogate',
'Po',
'Currency_Symbol',
'InNumber',
'InPunctuation',
'Ps',
'Sc',
'IsLine_Separator',
'InOther_Number',
'OtherPunctuation',
'Cc',
'IsConnector_Punctuation',
'InDashPunctuation',
'IsLineSeparator',
'InTitlecase_Letter',
'InOther_Symbol',
'Sm',
'InOtherSymbol',
'So',
'IsTitlecase_Letter',
'InSk',
'Cf',
'IsSurrogate',
'OtherLetter',
'InZs',
'IsInitial_Punctuation',
'IsOpenPunctuation',
'IsFinal_Punctuation',
'InSc',
'Control',
'InNonSpacingMark',
'InMath_Symbol',
'IsM',
'IsL',
'Cs',
'InOther_Punctuation',
'OpenPunctuation',
'IsModifier_Letter',
'IsLetterNumber',
'InNd',
'Letter_Number',
'IsUppercase_Letter',
'IsSpacingCombiningMark',
'IsEnclosingMark',
'InZl',
'InInitial_Punctuation',
'Other_Symbol',
'Other',
'InS',
'InClosePunctuation',
'InTitlecaseLetter',
'IsZ',
'InP',
'MathSymbol',
'InCurrency_Symbol',
'LowercaseLetter',
'IsSeperator',
'IsDashPunctuation',
'InNo',
'IsParagraphSeparator',
'IsFinalPunctuation',
'InOtherNumber',
'InZp',
'IsNd',
'IsControl',
'InSpacing_Combining_Mark',
'DecimalDigitNumber',
'InN',
'InLine_Separator',
'InOtherLetter',
'Final_Punctuation',
'InM',
'IsMath_Symbol',
'InC',
'InParagraph_Separator',
'IsSymbol',
'Modifier_Symbol',
'InSo',
'InSm',
'Connector_Punctuation',
'OtherSymbol',
'IsNo',
'IsCurrency_Symbol',
'IsLo',
'IsNl',
'IsLm',
'ClosePunctuation',
'InOpenPunctuation',
'InClose_Punctuation',
'InOtherPunctuation',
'IsSk',
'InLowercase_Letter',
'Lo',
'IsClosePunctuation',
'IsNumber',
'IsOther_Punctuation',
'IsOther_Symbol',
'IsSc',
'InUppercase_Letter',
'InParagraphSeparator',
'Punctuation',
'IsDash_Punctuation',
'OtherNumber',
'IsOther_Letter',
'Non_Spacing_Mark',
'InFinal_Punctuation',
'IsPunctuation',
'Sk',
'IsFormat',
'InLo',
'InOpen_Punctuation',
'IsMathSymbol',
'InLl',
'IsPrivateUse',
'EnclosingMark',
'InDecimal_Digit_Number',
'IsOther',
'InLu',
'InMe',
'Initial_Punctuation',
'UppercaseLetter',
'Surrogate',
'Space_Separator',
'InMn',
'IsOpen_Punctuation',
'IsOtherLetter',
'IsLt',
'InLetterNumber',
'IsSpacing_Combining_Mark',
'Other_Punctuation',
'InPrivateUse',
'Decimal_Digit_Number',
'IsPrivate_Use',
'InL',
'IsSm',
'IsTitlecaseLetter',
'IsSo',
'InUnassigned',
'InitialPunctuation',
'IsCurrencySymbol',
'Nd',
'IsModifier_Symbol',
'Lu',
'IsSpaceSeparator',
'Lowercase_Letter',
'ParagraphSeparator',
'InConnectorPunctuation',
'InZ',
'SpaceSeparator',
'IsModifierSymbol',
'IsS',
'Symbol',
'Spacing_Combining_Mark',
'IsOtherSymbol',
'IsParagraph_Separator',
'InPc',
'InCurrencySymbol',
'InLetter_Number',
'InCo',
'Zs',
'InCn',
'InSpacingCombiningMark',
'Zp',
'IsCn',
'IsCo',
'Private_Use',
'Pe',
'Unassigned',
'InPf',
'Lm',
'InMc',
'IsCf',
'InPs',
'Zl',
'IsMe',
'LineSeparator',
'IsMc',
'IsLowercase_Letter',
'Titlecase_Letter',
'InSeperator',
'Uppercase_Letter',
'InEnclosing_Mark',
'Cn',
'IsZp',
'InInitialPunctuation',
'Dash_Punctuation',
'IsZs',
'IsZl',
'InLowercaseLetter',
'InPi',
'Co',
'TitlecaseLetter',
'IsCs',
'ConnectorPunctuation',
'Modifier_Letter',
'InPo',
'IsDecimalDigitNumber',
'InDecimalDigitNumber',
'IsSpace_Separator',
'InMark',
'FinalPunctuation',
'InNl',
'InCs',
'IsOther_Number',
'Mn',
'InConnector_Punctuation',
'InFormat',
'InSpaceSeparator',
'IsInitialPunctuation',
'InPrivate_Use',
'IsP',
'Number',
'Pf',
'InLineSeparator',
'IsLl',
'Open_Punctuation',
'IsN',
'InCc',
'InSymbol',
'Math_Symbol',
'IsMn',
'PrivateUse',
'InCf',
'IsC',
'SpacingCombiningMark',
'ModifierSymbol',
'Seperator',
'IsPs',
'InUppercaseLetter',
'Lt',
'Format',
'IsUnassigned',
'Mc',
'InOther',
'C',
'Mark',
'InLt',
'IsUppercaseLetter',
'DashPunctuation',
'InModifier_Symbol',
'IsDecimal_Digit_Number',
'IsPf',
'NonSpacingMark',
'LetterNumber',
'IsPc',
'Other_Number',
'IsPd',
'IsPe',
'Close_Punctuation',
'InEnclosingMark',
'InFinalPunctuation',
'Ll',
'IsPo',
'IsMark',
'IsPi',
'InDash_Punctuation',
'IsOtherPunctuation',
'IsCc',
'InPd',
'ModifierLetter',
'Paragraph_Separator',
'IsNon_Spacing_Mark',
'Enclosing_Mark',
'IsLetter_Number',
'Nl',
'IsEnclosing_Mark',
'Line_Separator',
'No',
'IsNonSpacingMark',
'InModifier_Letter',
'L',
'M',
'N',
'P',
'S',
'Other_Letter',
'InOther_Letter',
'InModifierLetter',
'IsOtherNumber',
'InMathSymbol',
'InControl',
'Z',
'IsLowercaseLetter',
'InPe',
'Pc',
'InNon_Spacing_Mark',
'IsLu',
'Pd',
'InModifierSymbol',
'IsClose_Punctuation'
);

      PUCUUnicodeClassHashMapValueBits=32;

      PUCUUnicodeClassHashMapValues:array[0..296] of longword=(
4194304,
128,
4096,
16,
16,
33554432,
268435456,
262144,
8388608,
33554432,
3584,
821559296,
1048576,
33554432,
8192,
2048,
8388608,
32768,
4194304,
524288,
8192,
8,
134217728,
16777216,
134217728,
134217728,
8,
67108864,
65536,
262144,
32,
4096,
268435456,
1048576,
536870912,
33554432,
32768,
64,
16777216,
448,
62,
262144,
8388608,
1048576,
16,
1024,
512,
1024,
2,
256,
128,
8192,
268435456,
134217728,
491521,
251658240,
2097152,
8,
28672,
821559296,
16777216,
33554432,
4,
28672,
524288,
2048,
16384,
536870912,
2048,
16384,
512,
32768,
256,
512,
3584,
8192,
32,
536870912,
448,
16777216,
491521,
16384,
251658240,
67108864,
134217728,
16777216,
4194304,
134217728,
2048,
33554432,
32,
1024,
16,
2097152,
1048576,
2097152,
8388608,
67108864,
4,
32,
2097152,
3584,
8388608,
134217728,
33554432,
2,
16384,
821559296,
524288,
2048,
32,
64,
536870912,
821559296,
67108864,
32768,
32,
1048576,
16777216,
4,
131072,
128,
512,
491521,
2,
128,
268435456,
2,
262144,
4096,
64,
1048576,
32,
8,
1024,
256,
8388608,
131072,
512,
131072,
62,
16777216,
8,
134217728,
1,
268435456,
33554432,
512,
67108864,
2,
4096,
4,
16384,
4194304,
28672,
4096,
67108864,
251658240,
251658240,
256,
134217728,
16384,
4194304,
33554432,
1024,
131072,
4096,
1,
256,
16384,
1,
131072,
131072,
2097152,
1,
536870912,
16,
256,
65536,
1048576,
8192,
128,
8192,
256,
4,
8,
28672,
2,
128,
1,
16384,
268435456,
524288,
4096,
8192,
4,
268435456,
131072,
8,
262144,
4194304,
16,
8388608,
512,
512,
4096,
448,
536870912,
1024,
262144,
2048,
64,
4194304,
32768,
4096,
268435456,
131072,
821559296,
3584,
536870912,
8192,
4,
1048576,
3584,
32768,
251658240,
16777216,
64,
131072,
65536,
491521,
256,
67108864,
28672,
1048576,
2,
8,
32768,
1,
256,
491521,
491521,
448,
8,
2,
524288,
67108864,
512,
536870912,
64,
1024,
4194304,
2048,
524288,
2097152,
2097152,
128,
536870912,
4,
8388608,
448,
268435456,
524288,
8388608,
32768,
524288,
16,
16384,
64,
128,
1024,
1024,
128,
8192,
2048,
64,
16,
62,
448,
3584,
821559296,
251658240,
32,
32,
16,
2048,
16777216,
32768,
28672,
4,
2097152,
4194304,
64,
2,
524288,
67108864,
2097152
);

const PUCUUnicodeScriptHashMapSeedSize=513;
      PUCUUnicodeScriptHashMapValueSize=513;
      PUCUUnicodeScriptHashMapSize=513;

      PUCUUnicodeScriptHashMapSeedBits=16;

      PUCUUnicodeScriptHashMapSeeds:array[0..512] of smallint=(
2,
-510,
-509,
1,
-506,
-500,
-499,
1,
-497,
-489,
0,
-484,
1,
0,
-480,
0,
-477,
1,
-476,
0,
0,
-475,
0,
-474,
-473,
0,
-472,
-468,
0,
0,
-465,
-461,
1,
6,
2,
0,
0,
0,
0,
6,
-454,
-453,
1,
2,
0,
1,
0,
-451,
0,
0,
0,
0,
2,
0,
0,
1,
1,
3,
-450,
-449,
0,
0,
-448,
0,
0,
0,
0,
-445,
-444,
-439,
-435,
0,
-428,
0,
0,
1,
0,
1,
-426,
0,
0,
0,
0,
-421,
0,
0,
0,
0,
-416,
1,
2,
0,
-415,
3,
-414,
0,
0,
2,
-413,
0,
0,
0,
-412,
-410,
-408,
1,
1,
5,
-407,
2,
0,
1,
-404,
-402,
4,
1,
-401,
-398,
0,
-397,
0,
0,
0,
1,
0,
0,
-396,
-392,
-390,
0,
0,
-389,
0,
-385,
0,
-384,
1,
3,
0,
0,
-383,
0,
0,
0,
-382,
-380,
-379,
0,
0,
0,
2,
-378,
-371,
-368,
-367,
0,
0,
1,
3,
-364,
3,
2,
0,
-361,
0,
0,
0,
0,
0,
0,
0,
1,
0,
-359,
0,
-352,
-346,
0,
1,
1,
0,
-344,
-339,
0,
3,
-334,
-331,
-329,
-326,
0,
-324,
4,
1,
1,
1,
-323,
-322,
-320,
6,
-316,
-315,
6,
1,
0,
-313,
-312,
-311,
0,
-300,
0,
2,
-296,
1,
-294,
-292,
-291,
1,
0,
-289,
-288,
-284,
0,
10,
0,
1,
-279,
-275,
-272,
0,
0,
3,
0,
0,
-268,
0,
0,
3,
0,
1,
0,
1,
2,
-267,
4,
-266,
-264,
1,
2,
0,
0,
-261,
-260,
0,
-257,
-253,
9,
-252,
-250,
-247,
-238,
-234,
0,
-230,
-228,
0,
0,
0,
0,
-227,
0,
2,
0,
0,
-226,
-221,
0,
0,
-215,
-213,
-209,
0,
1,
-204,
-203,
-201,
0,
1,
-200,
0,
-199,
0,
0,
-195,
-194,
0,
-191,
0,
0,
0,
0,
-183,
2,
0,
1,
-182,
-173,
-167,
-164,
0,
-163,
0,
0,
-160,
11,
2,
7,
0,
31,
9,
-156,
0,
2,
0,
-154,
-152,
0,
-149,
-146,
1,
5,
2,
2,
0,
0,
0,
-145,
8,
-144,
-143,
0,
0,
-142,
0,
1,
0,
1,
1,
0,
0,
-138,
2,
0,
-135,
-133,
1,
-128,
-126,
1,
6,
0,
1,
-122,
5,
3,
4,
0,
0,
1,
0,
1,
8,
0,
1,
-119,
-114,
1,
0,
1,
3,
3,
1,
0,
3,
1,
12,
0,
2,
1,
0,
-110,
-109,
-107,
1,
-106,
0,
-104,
1,
-102,
1,
3,
4,
5,
9,
-98,
0,
-97,
2,
-96,
0,
-93,
0,
0,
-91,
9,
1,
1,
8,
1,
0,
0,
0,
-88,
1,
1,
0,
-86,
0,
0,
-85,
-83,
0,
0,
-81,
2,
-67,
4,
0,
0,
0,
0,
-66,
3,
4,
-64,
-63,
0,
0,
-59,
-58,
0,
3,
0,
-57,
-53,
-50,
0,
-49,
1,
2,
5,
-48,
0,
-47,
0,
0,
5,
3,
0,
-46,
7,
-45,
-44,
1,
-43,
0,
0,
-42,
38,
-41,
18,
-40,
-37,
-35,
-32,
-26,
-24,
0,
-22,
-20,
0,
6,
0,
-16,
0,
9,
-15,
0,
0,
-14,
0,
0,
-13,
0,
0,
0,
-11,
-10,
0,
-5,
2,
-3,
0,
-2
);

      PUCUUnicodeScriptHashMapKeys:array[0..512] of TPUCURawByteString=(
'IsPauCinHau',
'Ogham',
'IsTaiViet',
'InAnatolian_Hieroglyphs',
'InLatin',
'IsBuhid',
'IsPhoenician',
'InSyloti_Nagri',
'Lisu',
'IsSundanese',
'Lycian',
'Pau_Cin_Hau',
'IsMende_Kikakui',
'InSignWriting',
'InNabataean',
'Tagbanwa',
'OldItalic',
'InTagbanwa',
'InOlChiki',
'InTirhuta',
'InLycian',
'Myanmar',
'IsTai_Le',
'Elbasan',
'InMeroitic_Hieroglyphs',
'InChakma',
'IsCanadian_Aboriginal',
'IsBrahmi',
'IsCarian',
'InKharoshthi',
'Tagalog',
'InInscriptional_Parthian',
'Kaithi',
'Latin',
'InMeetei_Mayek',
'IsOldSouthArabian',
'InLinear_A',
'IsSharada',
'Bamum',
'Mro',
'InLinear_B',
'IsJavanese',
'Newa',
'Pahawh_Hmong',
'Mahajani',
'IsGrantha',
'Buhid',
'Bhaiksuki',
'IsManichaean',
'InTaiLe',
'Vai',
'IsTamil',
'IsTelugu',
'IsNew_Tai_Lue',
'InBopomofo',
'IsLydian',
'IsRunic',
'IsInscriptionalPahlavi',
'IsShavian',
'MeroiticHieroglyphs',
'IsMahajani',
'InEthiopic',
'InShavian',
'MendeKikakui',
'InThai',
'Cyrillic',
'IsOld_Persian',
'InPhagsPa',
'InTai_Tham',
'InTaiTham',
'InTelugu',
'InYi',
'Duployan',
'IsRejang',
'Egyptian_Hieroglyphs',
'InCherokee',
'IsSora_Sompeng',
'IsMongolian',
'IsTibetan',
'IsMro',
'Old_Hungarian',
'IsMeroiticCursive',
'TaiLe',
'IsOldPersian',
'InMahajani',
'IsBamum',
'IsTakri',
'IsHanunoo',
'InOld_North_Arabian',
'InHatran',
'InKhmer',
'IsElbasan',
'InArabic',
'IsPau_Cin_Hau',
'InDeseret',
'IsMalayalam',
'Saurashtra',
'IsBraille',
'KayahLi',
'OldPermic',
'Yi',
'Linear_A',
'IsAnatolianHieroglyphs',
'Balinese',
'InOldHungarian',
'Tai_Viet',
'InPahawh_Hmong',
'InMyanmar',
'IsLatin',
'InCham',
'Hangul',
'InBuginese',
'OldHungarian',
'InRunic',
'IsAnatolian_Hieroglyphs',
'Palmyrene',
'InKannada',
'InWarangCiti',
'Tifinagh',
'IsCommon',
'IsKayahLi',
'Deseret',
'InSinhala',
'InCypriot',
'Glagolitic',
'IsBassaVah',
'IsMeroiticHieroglyphs',
'Greek',
'Gothic',
'OldSouthArabian',
'IsTangut',
'InLimbu',
'IsSignWriting',
'IsOld_Hungarian',
'IsOld_North_Arabian',
'Katakana',
'Gujarati',
'Ugaritic',
'IsGurmukhi',
'Imperial_Aramaic',
'InInscriptionalParthian',
'Hatran',
'IsPalmyrene',
'InTakri',
'Tai_Tham',
'Lydian',
'IsCham',
'InBuhid',
'IsMendeKikakui',
'InHangul',
'InOgham',
'InUgaritic',
'IsBalinese',
'IsKhmer',
'Meetei_Mayek',
'Kayah_Li',
'InPsalter_Pahlavi',
'IsPsalterPahlavi',
'SignWriting',
'Khmer',
'Warang_Citi',
'InBengali',
'Carian',
'InSoraSompeng',
'IsCoptic',
'IsHiragana',
'InJavanese',
'Tamil',
'InOldPersian',
'IsKannada',
'IsInherited',
'IsInscriptional_Parthian',
'Kannada',
'InCanadian_Aboriginal',
'IsSiddham',
'Rejang',
'Gurmukhi',
'InOsmanya',
'Mongolian',
'IsMeroitic_Cursive',
'Khojki',
'Chakma',
'InKayahLi',
'InEgyptianHieroglyphs',
'IsThai',
'IsBopomofo',
'IsTai_Viet',
'IsLinear_A',
'IsHatran',
'InOl_Chiki',
'InPhoenician',
'InLisu',
'Meroitic_Hieroglyphs',
'InOld_Italic',
'Hebrew',
'InBraille',
'InKatakana',
'PsalterPahlavi',
'InMeeteiMayek',
'IsCyrillic',
'IsYi',
'IsOld_Italic',
'InLepcha',
'IsModi',
'Mende_Kikakui',
'InLinearB',
'InKaithi',
'InGeorgian',
'InNewa',
'InSharada',
'InLydian',
'InBassa_Vah',
'Devanagari',
'Osage',
'IsKayah_Li',
'InInscriptional_Pahlavi',
'IsDuployan',
'IsUgaritic',
'OldPersian',
'InCaucasianAlbanian',
'IsBatak',
'InTifinagh',
'InTamil',
'InPsalterPahlavi',
'InSiddham',
'InMandaic',
'Syloti_Nagri',
'IsSoraSompeng',
'IsGothic',
'Modi',
'InBrahmi',
'Khudawadi',
'Old_Italic',
'InNew_Tai_Lue',
'SylotiNagri',
'InOld_Persian',
'Common',
'IsEgyptianHieroglyphs',
'IsGujarati',
'Psalter_Pahlavi',
'Sharada',
'Anatolian_Hieroglyphs',
'IsBuginese',
'InSylotiNagri',
'IsInscriptional_Pahlavi',
'Samaritan',
'Old_Permic',
'IsChakma',
'Cham',
'IsLisu',
'Meroitic_Cursive',
'InVai',
'Telugu',
'New_Tai_Lue',
'Miao',
'IsSyriac',
'IsLycian',
'IsOldNorthArabian',
'InThaana',
'IsArmenian',
'InHanunoo',
'IsCanadianAboriginal',
'IsPahawhHmong',
'IsLepcha',
'IsKaithi',
'InMalayalam',
'IsNewa',
'PahawhHmong',
'IsMiao',
'IsCypriot',
'Hanunoo',
'TaiTham',
'Adlam',
'InHebrew',
'IsAdlam',
'Takri',
'Nko',
'IsWarang_Citi',
'Ethiopic',
'IsHan',
'IsTaiTham',
'Inherited',
'Cypriot',
'IsOgham',
'InBatak',
'IsOld_Turkic',
'IsMeroitic_Hieroglyphs',
'Siddham',
'IsEthiopic',
'IsImperial_Aramaic',
'InHan',
'IsThaana',
'Osmanya',
'IsLinearA',
'Lao',
'InSamaritan',
'InTibetan',
'InNewTaiLue',
'InLinearA',
'IsTifinagh',
'IsCherokee',
'InMarchen',
'InGlagolitic',
'Ol_Chiki',
'Old_Turkic',
'InGrantha',
'Cherokee',
'IsEgyptian_Hieroglyphs',
'Old_North_Arabian',
'Multani',
'IsDevanagari',
'InModi',
'InTai_Viet',
'Hiragana',
'Old_South_Arabian',
'Limbu',
'IsMarchen',
'Marchen',
'Nabataean',
'InSundanese',
'InAhom',
'InKhojki',
'InBalinese',
'IsHebrew',
'Braille',
'Tibetan',
'NewTaiLue',
'IsOl_Chiki',
'InPau_Cin_Hau',
'InManichaean',
'IsBengali',
'InOriya',
'InSyriac',
'LinearA',
'InTagalog',
'IsDeseret',
'Malayalam',
'InOldTurkic',
'LinearB',
'IsOld_South_Arabian',
'Ahom',
'MeeteiMayek',
'IsKhojki',
'IsOldItalic',
'Shavian',
'IsSylotiNagri',
'IsAvestan',
'InOldPermic',
'IsMeetei_Mayek',
'Tirhuta',
'IsTai_Tham',
'IsOlChiki',
'IsSaurashtra',
'IsTagbanwa',
'InKayah_Li',
'InMende_Kikakui',
'Manichaean',
'InDevanagari',
'IsTaiLe',
'IsOldHungarian',
'Javanese',
'InPahawhHmong',
'InTai_Le',
'IsWarangCiti',
'InNko',
'IsNko',
'InPhags_Pa',
'InCarian',
'Thai',
'IsKhudawadi',
'EgyptianHieroglyphs',
'OldTurkic',
'InOldNorthArabian',
'InElbasan',
'IsLimbu',
'InscriptionalParthian',
'Grantha',
'InMeroiticCursive',
'SoraSompeng',
'OlChiki',
'InTangut',
'Lepcha',
'Armenian',
'Han',
'InCanadianAboriginal',
'InCommon',
'InGurmukhi',
'IsAhom',
'InEgyptian_Hieroglyphs',
'InRejang',
'Sora_Sompeng',
'Inscriptional_Pahlavi',
'IsNewTaiLue',
'PauCinHau',
'InOldItalic',
'Canadian_Aboriginal',
'IsGlagolitic',
'InImperial_Aramaic',
'InMeroiticHieroglyphs',
'InMiao',
'InMongolian',
'InImperialAramaic',
'IsImperialAramaic',
'IsBassa_Vah',
'IsTirhuta',
'IsKharoshthi',
'MeroiticCursive',
'Tangut',
'InLao',
'ImperialAramaic',
'InBhaiksuki',
'Mandaic',
'InHiragana',
'IsInscriptionalParthian',
'InAnatolianHieroglyphs',
'InPalmyrene',
'IsMandaic',
'Phags_Pa',
'IsOsage',
'InInscriptionalPahlavi',
'AnatolianHieroglyphs',
'IsSamaritan',
'Avestan',
'InGreek',
'InMro',
'InAdlam',
'CanadianAboriginal',
'Georgian',
'InGothic',
'BassaVah',
'Batak',
'IsHangul',
'Inscriptional_Parthian',
'InWarang_Citi',
'Runic',
'InOldSouthArabian',
'IsPsalter_Pahlavi',
'IsKatakana',
'TaiViet',
'InAvestan',
'InPauCinHau',
'IsArabic',
'IsMultani',
'Sinhala',
'InOsage',
'InGujarati',
'InSaurashtra',
'Brahmi',
'IsSinhala',
'InKhudawadi',
'IsOldTurkic',
'InBamum',
'CaucasianAlbanian',
'InMendeKikakui',
'IsCuneiform',
'Arabic',
'InOld_South_Arabian',
'InSora_Sompeng',
'InCoptic',
'IsPhags_Pa',
'Sundanese',
'Syriac',
'IsPahawh_Hmong',
'IsCaucasian_Albanian',
'IsOld_Permic',
'InCaucasian_Albanian',
'Caucasian_Albanian',
'InCyrillic',
'Phoenician',
'InCuneiform',
'IsGreek',
'InMultani',
'Bopomofo',
'IsBhaiksuki',
'InOld_Hungarian',
'InscriptionalPahlavi',
'Coptic',
'IsNabataean',
'Bassa_Vah',
'IsOsmanya',
'OldNorthArabian',
'IsSyloti_Nagri',
'Kharoshthi',
'Old_Persian',
'IsCaucasianAlbanian',
'IsTagalog',
'IsPhagsPa',
'InOld_Turkic',
'IsOldPermic',
'InBassaVah',
'Linear_B',
'InInherited',
'InArmenian',
'Cuneiform',
'IsLinearB',
'InDuployan',
'Thaana',
'Tai_Le',
'PhagsPa',
'Buginese',
'IsVai',
'WarangCiti',
'Bengali',
'IsLao',
'IsLinear_B',
'IsMeeteiMayek',
'Oriya',
'IsMyanmar',
'InTaiViet',
'IsGeorgian',
'InMeroitic_Cursive',
'IsOriya',
'InOld_Permic'
);

      PUCUUnicodeScriptHashMapValueBits=8;

      PUCUUnicodeScriptHashMapValues:array[0..512] of byte=(
119,
29,
79,
127,
2,
44,
64,
59,
83,
67,
74,
119,
113,
131,
117,
45,
38,
45,
69,
124,
74,
23,
47,
106,
98,
96,
28,
94,
75,
61,
42,
89,
92,
2,
86,
88,
110,
100,
84,
115,
48,
85,
135,
108,
111,
107,
44,
133,
112,
47,
70,
15,
16,
56,
35,
76,
30,
90,
50,
98,
111,
26,
50,
113,
20,
4,
60,
65,
78,
78,
16,
37,
105,
73,
81,
27,
101,
32,
22,
115,
130,
97,
47,
60,
111,
84,
102,
43,
116,
128,
31,
106,
7,
119,
40,
18,
71,
53,
72,
120,
37,
110,
127,
62,
130,
79,
108,
23,
2,
77,
25,
54,
130,
30,
127,
118,
17,
125,
58,
1,
72,
40,
19,
52,
57,
104,
98,
3,
39,
88,
137,
46,
131,
130,
116,
34,
13,
49,
12,
87,
89,
128,
118,
102,
78,
76,
77,
44,
113,
25,
29,
49,
62,
31,
86,
72,
121,
121,
131,
31,
125,
11,
75,
101,
55,
33,
85,
15,
60,
17,
41,
89,
17,
28,
122,
73,
12,
51,
32,
97,
109,
96,
72,
81,
20,
35,
79,
110,
128,
69,
64,
83,
98,
38,
6,
53,
34,
121,
86,
4,
37,
38,
68,
114,
113,
48,
92,
24,
135,
100,
76,
104,
10,
136,
72,
90,
105,
49,
60,
103,
93,
58,
15,
121,
122,
95,
59,
101,
39,
114,
94,
123,
38,
56,
59,
60,
1,
81,
13,
121,
100,
127,
54,
59,
90,
82,
120,
96,
77,
83,
97,
70,
16,
56,
99,
8,
74,
116,
9,
5,
43,
28,
108,
68,
92,
18,
135,
108,
99,
52,
43,
78,
132,
6,
132,
102,
66,
125,
26,
36,
78,
41,
52,
29,
93,
91,
98,
122,
26,
87,
36,
9,
51,
110,
21,
82,
22,
56,
110,
58,
27,
134,
57,
69,
91,
107,
27,
81,
116,
129,
10,
114,
79,
33,
88,
46,
134,
134,
117,
67,
126,
109,
62,
6,
53,
22,
56,
69,
119,
112,
11,
14,
8,
110,
42,
40,
18,
91,
48,
88,
126,
86,
109,
38,
50,
59,
80,
120,
86,
124,
78,
69,
71,
45,
72,
113,
112,
10,
47,
130,
85,
108,
47,
125,
66,
66,
65,
75,
20,
123,
81,
91,
116,
106,
46,
89,
107,
97,
101,
69,
137,
68,
5,
36,
28,
1,
12,
126,
81,
73,
101,
90,
56,
119,
38,
28,
57,
87,
98,
99,
32,
87,
87,
104,
124,
61,
97,
137,
21,
87,
133,
95,
33,
89,
127,
118,
95,
65,
136,
90,
127,
82,
80,
3,
115,
132,
28,
24,
39,
104,
93,
25,
89,
125,
30,
88,
121,
34,
79,
80,
119,
7,
129,
19,
136,
13,
71,
94,
19,
123,
91,
84,
103,
113,
63,
7,
88,
101,
55,
65,
67,
8,
108,
103,
120,
103,
103,
4,
64,
63,
3,
129,
35,
133,
130,
90,
55,
117,
104,
51,
116,
59,
61,
60,
103,
42,
65,
91,
120,
104,
48,
41,
5,
63,
48,
105,
9,
47,
65,
54,
70,
125,
11,
21,
48,
86,
14,
23,
79,
24,
97,
14,
120
);

const PUCUUnicodeBlockHashMapSeedSize=1338;
      PUCUUnicodeBlockHashMapValueSize=1338;
      PUCUUnicodeBlockHashMapSize=1338;

      PUCUUnicodeBlockHashMapSeedBits=16;

      PUCUUnicodeBlockHashMapSeeds:array[0..1337] of smallint=(
-1338,
0,
0,
1,
0,
-1336,
-1334,
-1327,
0,
0,
-1325,
0,
-1323,
4,
4,
-1319,
1,
1,
1,
1,
1,
1,
-1318,
1,
1,
1,
-1312,
-1311,
2,
1,
-1309,
0,
-1307,
2,
1,
0,
1,
0,
-1302,
3,
-1301,
2,
0,
-1300,
-1298,
2,
0,
-1296,
-1293,
0,
-1291,
0,
2,
-1290,
-1286,
0,
0,
-1284,
-1283,
-1277,
0,
0,
0,
0,
0,
1,
0,
2,
0,
0,
-1276,
1,
3,
1,
-1275,
0,
0,
1,
4,
-1272,
0,
0,
0,
-1270,
-1266,
-1265,
-1264,
0,
-1255,
1,
1,
0,
-1252,
-1248,
-1245,
-1242,
2,
0,
1,
0,
1,
1,
-1241,
-1235,
0,
0,
-1230,
0,
-1229,
-1227,
2,
-1225,
-1224,
2,
4,
-1220,
-1217,
0,
-1216,
1,
-1213,
-1208,
1,
0,
6,
3,
0,
-1205,
-1204,
-1202,
-1201,
0,
-1200,
-1199,
0,
-1198,
2,
4,
-1197,
2,
0,
-1192,
-1189,
0,
1,
0,
0,
4,
0,
-1187,
2,
0,
-1185,
0,
3,
0,
0,
0,
0,
-1184,
-1181,
1,
1,
2,
0,
-1178,
-1176,
-1175,
0,
-1174,
-1173,
-1172,
0,
-1169,
-1162,
-1147,
-1146,
0,
-1145,
0,
4,
-1141,
0,
-1140,
-1136,
-1134,
-1133,
0,
-1132,
-1131,
0,
-1130,
3,
-1127,
1,
-1126,
0,
0,
-1122,
0,
0,
-1121,
1,
-1113,
-1108,
0,
-1106,
0,
1,
-1101,
-1099,
-1098,
0,
0,
0,
0,
0,
0,
0,
-1097,
-1096,
1,
1,
-1095,
-1088,
-1087,
0,
-1086,
-1083,
1,
1,
-1081,
0,
-1078,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1077,
0,
-1076,
0,
0,
-1075,
-1072,
0,
1,
0,
-1071,
-1062,
-1059,
0,
-1058,
0,
2,
1,
-1054,
1,
1,
0,
-1052,
-1051,
-1041,
2,
-1037,
-1036,
-1033,
0,
-1031,
0,
0,
2,
0,
-1030,
-1029,
0,
-1028,
1,
8,
0,
0,
2,
-1023,
-1022,
0,
0,
0,
-1019,
0,
0,
1,
-1016,
3,
0,
1,
0,
0,
-1015,
0,
1,
0,
-1014,
-1011,
-1009,
0,
1,
1,
0,
0,
2,
1,
0,
-1003,
-1000,
0,
0,
2,
3,
0,
0,
0,
-999,
0,
4,
2,
0,
-993,
-992,
-991,
2,
-986,
0,
8,
-979,
1,
0,
-976,
-975,
2,
2,
1,
1,
0,
0,
-972,
1,
-971,
1,
0,
0,
2,
2,
1,
1,
-967,
-965,
0,
-964,
0,
1,
-959,
2,
-956,
0,
-954,
5,
1,
0,
0,
0,
2,
4,
-950,
1,
0,
0,
0,
-949,
0,
6,
-946,
1,
0,
3,
0,
1,
1,
0,
-937,
0,
-935,
0,
-933,
-926,
-923,
0,
4,
-921,
0,
-920,
-919,
0,
-918,
0,
0,
-915,
-912,
3,
-910,
0,
0,
0,
0,
-905,
-903,
1,
6,
-902,
-900,
0,
9,
0,
0,
-892,
-890,
0,
0,
7,
-885,
0,
-884,
-883,
-879,
-876,
-875,
3,
0,
0,
4,
3,
0,
2,
0,
-871,
-870,
0,
-869,
0,
0,
0,
0,
1,
2,
1,
-867,
1,
-864,
1,
3,
-861,
0,
4,
1,
-858,
0,
-856,
-854,
-850,
8,
1,
0,
4,
0,
-846,
0,
0,
0,
0,
0,
0,
-838,
2,
0,
0,
-836,
-834,
-833,
2,
-832,
-831,
1,
3,
-828,
1,
3,
-827,
-825,
-819,
0,
1,
11,
-816,
0,
-813,
0,
-810,
8,
-808,
-804,
0,
0,
-801,
-789,
1,
1,
1,
0,
-787,
-785,
1,
1,
0,
0,
-781,
6,
-780,
-779,
-777,
-774,
0,
0,
0,
-770,
5,
-768,
1,
1,
0,
2,
-767,
-762,
0,
-761,
0,
0,
-760,
0,
-754,
0,
-748,
-746,
0,
-744,
-742,
-737,
0,
-736,
-735,
0,
0,
0,
0,
3,
3,
2,
6,
1,
0,
0,
0,
-732,
-731,
3,
0,
-723,
0,
-722,
-721,
0,
0,
0,
0,
1,
-720,
-718,
1,
-717,
0,
-716,
-713,
0,
-711,
-710,
0,
1,
14,
-709,
1,
2,
13,
2,
-708,
0,
-700,
0,
0,
0,
1,
-699,
-691,
0,
0,
1,
0,
0,
0,
-689,
0,
1,
-687,
-685,
-683,
0,
0,
0,
0,
3,
0,
1,
0,
0,
0,
-682,
0,
0,
0,
0,
-681,
2,
2,
-680,
-679,
0,
0,
0,
-677,
-672,
-666,
0,
0,
0,
-660,
-656,
1,
0,
0,
-655,
0,
0,
-652,
0,
0,
1,
-651,
-645,
2,
0,
-643,
0,
-637,
-631,
0,
1,
0,
-630,
0,
0,
-626,
-624,
-623,
0,
-619,
0,
0,
2,
-616,
0,
0,
1,
0,
0,
0,
-607,
0,
0,
0,
0,
0,
0,
1,
-606,
-604,
0,
2,
0,
1,
-601,
0,
0,
3,
1,
-600,
1,
2,
1,
-597,
-596,
-589,
3,
7,
1,
0,
2,
-586,
0,
0,
-585,
0,
1,
0,
0,
-584,
-583,
0,
-580,
0,
0,
0,
0,
-576,
4,
-575,
0,
-570,
-568,
3,
2,
-566,
0,
-564,
0,
0,
5,
-561,
0,
0,
2,
-560,
0,
-559,
-557,
0,
-550,
-547,
5,
3,
-546,
-544,
-542,
1,
1,
-541,
0,
0,
-540,
0,
-539,
1,
0,
0,
1,
0,
1,
1,
0,
2,
0,
-536,
-532,
-531,
-529,
0,
0,
-528,
-525,
0,
0,
-524,
0,
-514,
1,
2,
2,
0,
3,
-513,
0,
0,
1,
0,
1,
-512,
-508,
1,
0,
3,
1,
-503,
-500,
0,
-498,
-496,
-493,
0,
-487,
-485,
0,
-483,
0,
0,
0,
0,
-482,
-479,
0,
-476,
-472,
-471,
0,
-469,
0,
-467,
-461,
0,
-460,
-458,
-457,
-452,
7,
4,
0,
0,
0,
2,
2,
0,
0,
0,
-451,
0,
1,
0,
5,
1,
0,
1,
0,
0,
1,
0,
3,
-447,
-446,
1,
6,
1,
-444,
-442,
-440,
-438,
-437,
-434,
2,
3,
2,
0,
0,
-427,
7,
-417,
2,
2,
0,
0,
-416,
-413,
-409,
0,
0,
-408,
-407,
0,
0,
-399,
0,
1,
2,
-397,
0,
-392,
1,
0,
0,
1,
0,
0,
0,
0,
0,
0,
2,
0,
0,
12,
-390,
-389,
3,
19,
0,
2,
4,
-386,
0,
-385,
-384,
2,
2,
0,
0,
-374,
-372,
-368,
0,
0,
0,
1,
-367,
0,
-361,
-360,
0,
-359,
1,
1,
-356,
0,
0,
0,
0,
0,
0,
0,
1,
-353,
0,
0,
0,
0,
8,
1,
-352,
2,
3,
-351,
1,
-348,
0,
-347,
-346,
-345,
-342,
-339,
0,
-338,
0,
1,
5,
0,
0,
0,
8,
6,
0,
0,
-337,
0,
0,
-335,
-332,
-326,
0,
2,
-325,
-322,
0,
2,
-321,
0,
-319,
0,
-318,
3,
-316,
5,
2,
3,
3,
0,
-313,
-309,
-302,
3,
5,
1,
0,
0,
-301,
-300,
0,
-298,
-295,
0,
1,
0,
0,
7,
-291,
6,
-289,
2,
-285,
0,
0,
0,
-284,
-283,
6,
-282,
0,
-280,
-278,
-270,
4,
1,
0,
-269,
0,
0,
-267,
0,
-265,
0,
0,
4,
2,
-264,
-263,
0,
3,
0,
0,
-260,
0,
0,
-259,
0,
2,
0,
3,
-256,
0,
0,
0,
0,
0,
0,
-253,
0,
0,
0,
3,
1,
-247,
-246,
-244,
2,
-241,
-233,
0,
0,
0,
-232,
-227,
-220,
2,
7,
2,
-219,
-212,
8,
0,
0,
0,
-211,
-210,
2,
-207,
-206,
0,
-204,
0,
0,
-203,
1,
0,
0,
0,
-202,
-199,
0,
14,
0,
0,
8,
3,
-196,
-194,
-193,
0,
0,
1,
-190,
0,
-188,
0,
-185,
-182,
4,
6,
-180,
0,
0,
2,
1,
-178,
0,
-177,
-176,
-174,
0,
-172,
-164,
-163,
-157,
0,
0,
6,
-155,
1,
2,
-154,
-153,
11,
0,
0,
21,
-152,
1,
5,
0,
-148,
11,
-146,
5,
-145,
3,
1,
1,
-139,
0,
6,
9,
11,
-138,
3,
0,
0,
-136,
-130,
-129,
0,
-124,
-123,
0,
1,
2,
4,
0,
-121,
-120,
1,
2,
0,
-113,
1,
-110,
-106,
-102,
-99,
0,
-98,
-94,
-93,
7,
5,
-85,
-83,
-82,
14,
1,
0,
-80,
3,
0,
0,
0,
0,
8,
1,
0,
15,
-72,
-71,
-70,
5,
16,
-69,
-66,
-57,
0,
-56,
0,
4,
-52,
9,
3,
-51,
-48,
-47,
2,
1,
0,
-43,
-42,
0,
0,
-41,
-40,
0,
0,
1,
0,
1,
-39,
4,
1,
-38,
0,
13,
-37,
2,
0,
0,
-35,
0,
2,
2,
-32,
0,
0,
0,
-31,
16,
15,
2,
0,
1,
0,
0,
-26,
0,
-23,
0,
0,
0,
0,
-19,
-16,
0,
-15,
0,
-14,
12,
-10,
0,
0,
0,
1,
3,
-9,
2,
-6,
2,
0,
0,
2,
-4,
0,
-1,
0,
0
);

      PUCUUnicodeBlockHashMapKeys:array[0..1337] of TPUCURawByteString=(
'IsWarang_Citi',
'IsCopticEpactNumbers',
'IsSiddham',
'InTags',
'IsSpacingModifierLetters',
'InCJK_Compatibility_Ideographs_Supplement',
'InHalfwidth_and_Fullwidth_Forms',
'IsCarian',
'InMiscellaneous_Mathematical_Symbols-B',
'InBuhid',
'InCJK_Symbols_and_Punctuation',
'IsOldHungarian',
'InMiscellaneousSymbolsandPictographs',
'IsLimbu',
'IsCJKCompatibilityIdeographsSupplement',
'InMiscellaneous_Symbols',
'GeorgianSupplement',
'OldNorthArabian',
'LinearA',
'Kannada',
'EnclosedIdeographicSupplement',
'IsCurrencySymbols',
'Combining_Diacritical_Marks_Supplement',
'Old_Persian',
'IsMyanmar',
'IsMathematicalOperators',
'InInscriptionalPahlavi',
'IsNKo',
'InGreek_and_Coptic',
'CJKCompatibility',
'InCherokee',
'InSyloti_Nagri',
'IsGreekExtended',
'IsModifier_Tone_Letters',
'InOldSouthArabian',
'IsTagbanwa',
'InTaiViet',
'CurrencySymbols',
'Sora_Sompeng',
'InOldHungarian',
'IsBopomofoExtended',
'IsPhags-pa',
'InHebrew',
'Old_Italic',
'Gurmukhi',
'InCJK_Radicals_Supplement',
'IsSupplementary_Private_Use_Area-B',
'Hebrew',
'IsCombining_Diacritical_Marks_Extended',
'Greek_and_Coptic',
'Hangul_Jamo_Extended-B',
'Hangul_Jamo_Extended-A',
'Enclosed_Alphanumerics',
'InSora_Sompeng',
'IsOldItalic',
'Rumi_Numeral_Symbols',
'CJKRadicalsSupplement',
'IsOpticalCharacterRecognition',
'IsHatran',
'InHighPrivateUseSurrogates',
'LetterlikeSymbols',
'Cyrillic_Extended-A',
'Bamum_Supplement',
'IsSupplemental_Symbols_and_Pictographs',
'IsEnclosedAlphanumerics',
'Lepcha',
'IsSupplemental_Arrows-B',
'CJK_Unified_Ideographs_Extension_D',
'IsPhoneticExtensions',
'Supplemental_Mathematical_Operators',
'IsCherokee_Supplement',
'SpacingModifierLetters',
'IsEgyptianHieroglyphs',
'Inscriptional_Pahlavi',
'InNabataean',
'InSamaritan',
'Phags-pa',
'Syriac',
'IsSylotiNagri',
'InCJKUnifiedIdeographs',
'OlChiki',
'Miscellaneous_Symbols_and_Pictographs',
'IsMeroiticHieroglyphs',
'IsEthiopicExtended-A',
'IsMyanmarExtended-B',
'InCyrillic',
'IsPhaistos_Disc',
'IsEthiopic_Extended',
'InCJK_Strokes',
'IsYiRadicals',
'InCJKCompatibilityIdeographs',
'InSinhalaArchaicNumbers',
'Geometric_Shapes_Extended',
'InArabic_Extended-A',
'BoxDrawing',
'InOrnamentalDingbats',
'Adlam',
'MathematicalAlphanumericSymbols',
'InEthiopic_Supplement',
'Variation_Selectors_Supplement',
'InUnified_Canadian_Aboriginal_Syllabics',
'InOld_Turkic',
'IsOldPersian',
'ByzantineMusicalSymbols',
'InThai',
'InHiragana',
'InLatinExtendedAdditional',
'InCounting_Rod_Numerals',
'BopomofoExtended',
'InTai_Xuan_Jing_Symbols',
'YiSyllables',
'Low_Surrogates',
'Cyrillic_Extended-C',
'InMyanmar',
'CountingRodNumerals',
'SuttonSignWriting',
'OldPersian',
'KayahLi',
'Limbu',
'InCyrillicExtended-C',
'InArabic_Mathematical_Alphabetic_Symbols',
'InSupplementalArrows-C',
'InLowSurrogates',
'IsKana_Supplement',
'IsModi',
'InBengali',
'CyrillicExtended-C',
'Sundanese_Supplement',
'InLinear_B_Ideograms',
'IsMro',
'InEthiopicExtended-A',
'IsAdlam',
'Georgian',
'InMyanmar_Extended-A',
'IsOldSouthArabian',
'InKannada',
'IsHangul_Compatibility_Jamo',
'CJKUnifiedIdeographsExtensionD',
'IsTransport_and_Map_Symbols',
'IsArrows',
'CJKUnifiedIdeographsExtensionB',
'Elbasan',
'Number_Forms',
'InGeorgianSupplement',
'InBatak',
'IsMongolian_Supplement',
'Glagolitic_Supplement',
'InSupplemental_Symbols_and_Pictographs',
'CJKCompatibilityIdeographsSupplement',
'InLatin_Extended-B',
'InLatin_Extended-E',
'InArabic_Presentation_Forms-A',
'IsKharoshthi',
'InSundaneseSupplement',
'IsCombining_Diacritical_Marks_for_Symbols',
'GeneralPunctuation',
'IsLydian',
'BraillePatterns',
'InLycian',
'EnclosedAlphanumerics',
'InMeetei_Mayek_Extensions',
'IsMahjongTiles',
'IsGlagoliticSupplement',
'InCombiningDiacriticalMarksExtended',
'IsCombiningMarksforSymbols',
'CombiningDiacriticalMarksExtended',
'VedicExtensions',
'Ideographic_Symbols_and_Punctuation',
'Javanese',
'Mende_Kikakui',
'InLatin-1Supplement',
'InGreekExtended',
'IsSupplemental_Punctuation',
'InCombiningDiacriticalMarksforSymbols',
'InCyrillic_Extended-B',
'Gujarati',
'PahawhHmong',
'Musical_Symbols',
'InTakri',
'IsSyriac',
'IsAlphabeticPresentationForms',
'InSupplementaryPrivateUseArea-B',
'InLatinExtended-D',
'InLatinExtended-E',
'Palmyrene',
'IsUnified_Canadian_Aboriginal_Syllabics_Extended',
'InEgyptianHieroglyphs',
'Linear_A',
'TaiViet',
'InKatakanaPhoneticExtensions',
'InKhojki',
'InLetterlike_Symbols',
'IsMusicalSymbols',
'IsEgyptian_Hieroglyphs',
'Hangul_Jamo',
'InModifierToneLetters',
'CommonIndicNumberForms',
'InSupplementary_Private_Use_Area-A',
'Vedic_Extensions',
'InKangxiRadicals',
'Ethiopic_Supplement',
'IsVerticalForms',
'InEthiopic',
'IsAhom',
'IsCyrillicExtended-B',
'IsBopomofo_Extended',
'AncientGreekMusicalNotation',
'IsIPAExtensions',
'GlagoliticSupplement',
'IsSaurashtra',
'PhoneticExtensionsSupplement',
'IsMathematical_Operators',
'Ancient_Greek_Musical_Notation',
'Tifinagh',
'Mongolian_Supplement',
'IsInscriptionalPahlavi',
'IsModifierToneLetters',
'InPhags-pa',
'InCJK_Unified_Ideographs_Extension_A',
'InCJK_Unified_Ideographs_Extension_E',
'Old_South_Arabian',
'Block_Elements',
'IsPhonetic_Extensions',
'InCombining_Marks_for_Symbols',
'Alphabetic_Presentation_Forms',
'IsCherokeeSupplement',
'IsCuneiform_Numbers_and_Punctuation',
'Variation_Selectors',
'Brahmi',
'IsOl_Chiki',
'IsMiscellaneousSymbolsandArrows',
'IsVedicExtensions',
'Supplemental_Arrows-A',
'IsAegean_Numbers',
'IsYijingHexagramSymbols',
'Newa',
'MeeteiMayek',
'InLinearA',
'IsCombiningDiacriticalMarksforSymbols',
'IsKanaSupplement',
'Supplemental_Arrows-B',
'SupplementaryPrivateUseArea-B',
'IsSundanese_Supplement',
'IsCyrillicExtended-A',
'InUnified_Canadian_Aboriginal_Syllabics_Extended',
'IsHangul_Syllables',
'IsCyrillicExtended-C',
'IsGeometric_Shapes',
'Combining_Diacritical_Marks_for_Symbols',
'InPsalter_Pahlavi',
'ArabicMathematicalAlphabeticSymbols',
'MeroiticCursive',
'InCombining_Half_Marks',
'IsOsage',
'IsGreek_and_Coptic',
'Miscellaneous_Symbols_and_Arrows',
'IsKangxiRadicals',
'IsTaiViet',
'InYiSyllables',
'InPhoenician',
'IsTangutComponents',
'KhmerSymbols',
'InMeetei_Mayek',
'Hangul_Syllables',
'InMende_Kikakui',
'InMeroitic_Hieroglyphs',
'CJK_Compatibility_Ideographs_Supplement',
'Unified_Canadian_Aboriginal_Syllabics_Extended',
'Ethiopic_Extended-A',
'IsEthiopic_Supplement',
'SylotiNagri',
'InOpticalCharacterRecognition',
'Batak',
'InLydian',
'IsBatak',
'IsHighPrivateUseSurrogates',
'IsSupplemental_Arrows-A',
'IsOgham',
'CJKUnifiedIdeographsExtensionA',
'IsOld_Hungarian',
'EnclosedAlphanumericSupplement',
'DevanagariExtended',
'IsRejang',
'IsMeeteiMayek',
'InUnifiedCanadianAboriginalSyllabics',
'IsVertical_Forms',
'InWarang_Citi',
'IsAlchemical_Symbols',
'Ugaritic',
'InPauCinHau',
'ControlPictures',
'InCyrillicExtended-A',
'Tai_Tham',
'Runic',
'InDominoTiles',
'Khojki',
'IsTagalog',
'Ideographic_Description_Characters',
'InPhoneticExtensions',
'Arabic_Mathematical_Alphabetic_Symbols',
'IsOld_North_Arabian',
'Yi_Radicals',
'IsLetterlike_Symbols',
'IsKhmerSymbols',
'InMahjong_Tiles',
'InArmenian',
'Buhid',
'InTaiTham',
'LatinExtended-A',
'InSylotiNagri',
'IsLatinExtended-A',
'IsAnatolian_Hieroglyphs',
'InSupplemental_Mathematical_Operators',
'IsBassa_Vah',
'InArabic_Supplement',
'IsCJKUnifiedIdeographsExtensionC',
'InOld_Hungarian',
'IsCJKUnifiedIdeographsExtensionA',
'Vai',
'IsCombining_Diacritical_Marks_Supplement',
'IsCJKUnifiedIdeographsExtensionE',
'InArrows',
'IsCombiningHalfMarks',
'InEthiopic_Extended',
'InOldItalic',
'InModifier_Tone_Letters',
'IsBassaVah',
'IsSutton_SignWriting',
'IsTibetan',
'InNewTaiLue',
'IsByzantine_Musical_Symbols',
'Playing_Cards',
'IsCyrillic_Extended-A',
'InGreekandCoptic',
'IsEnclosed_Alphanumeric_Supplement',
'IsMathematical_Alphanumeric_Symbols',
'InCyrillic_Supplement',
'IsMeroiticCursive',
'Sutton_SignWriting',
'IsCJK_Compatibility_Ideographs',
'InHangul_Syllables',
'HangulJamo',
'InMiscellaneous_Symbols_and_Arrows',
'IsMarchen',
'IsOldTurkic',
'InPlayingCards',
'IdeographicSymbolsandPunctuation',
'ArabicExtended-A',
'InSmallFormVariants',
'InVariation_Selectors',
'IsPrivate_Use_Area',
'IsLow_Surrogates',
'InOld_North_Arabian',
'IsSpecials',
'BassaVah',
'InCJKUnifiedIdeographsExtensionD',
'IsEnclosedAlphanumericSupplement',
'VariationSelectors',
'InCJKUnifiedIdeographsExtensionC',
'InCJKUnifiedIdeographsExtensionA',
'Sundanese',
'IsGujarati',
'IsLatin_Extended-C',
'IsUnifiedCanadianAboriginalSyllabicsExtended',
'Combining_Half_Marks',
'InSupplementalMathematicalOperators',
'InPrivate_Use_Area',
'IsUnifiedCanadianAboriginalSyllabics',
'IsLatin_Extended-E',
'InMarchen',
'Kayah_Li',
'MendeKikakui',
'IsControl_Pictures',
'IsPlayingCards',
'InByzantineMusicalSymbols',
'IsKatakana',
'IsMyanmarExtended-A',
'NKo',
'InTifinagh',
'Mro',
'InTaiXuanJingSymbols',
'Control_Pictures',
'MyanmarExtended-A',
'IsArabic_Presentation_Forms-B',
'Coptic_Epact_Numbers',
'Tagalog',
'InLatin_Extended-A',
'InDevanagari',
'IsArmenian',
'IsCJK_Strokes',
'InModi',
'PlayingCards',
'Manichaean',
'InGlagolitic_Supplement',
'IsHangul_Jamo',
'Grantha',
'Tibetan',
'IsCJK_Radicals_Supplement',
'IsAncientSymbols',
'IsBamum_Supplement',
'Lao',
'InEthiopic_Extended-A',
'IsAncientGreekMusicalNotation',
'IsDomino_Tiles',
'IsMeeteiMayekExtensions',
'Linear_B_Ideograms',
'IsCyrillicSupplement',
'Byzantine_Musical_Symbols',
'Linear_B_Syllabary',
'InCombiningHalfMarks',
'IsPsalterPahlavi',
'InSpacingModifierLetters',
'InKatakana_Phonetic_Extensions',
'IsMyanmar_Extended-B',
'Meroitic_Hieroglyphs',
'Supplementary_Private_Use_Area-B',
'IsLatin_Extended-B',
'IsNabataean',
'Letterlike_Symbols',
'Cypriot_Syllabary',
'IsEnclosed_Ideographic_Supplement',
'HangulCompatibilityJamo',
'InOld_Permic',
'InscriptionalParthian',
'InLinearBIdeograms',
'IsRumi_Numeral_Symbols',
'IsMahajani',
'InBopomofoExtended',
'MiscellaneousMathematicalSymbols-B',
'InArabic',
'InArabicExtended-A',
'IsPhonetic_Extensions_Supplement',
'InHigh_Private_Use_Surrogates',
'IsAegeanNumbers',
'InAncientGreekNumbers',
'Katakana',
'Khudawadi',
'MiscellaneousMathematicalSymbols-A',
'Mandaic',
'IsMiscellaneous_Technical',
'IsTai_Xuan_Jing_Symbols',
'IsCJKStrokes',
'Myanmar',
'IsSupplementalArrows-A',
'InLinear_A',
'IsDeseret',
'CombiningDiacriticalMarks',
'InMiscellaneous_Technical',
'IsPauCinHau',
'IsPlaying_Cards',
'InMusicalSymbols',
'InGeometricShapesExtended',
'InElbasan',
'InAncientSymbols',
'InJavanese',
'Enclosed_Alphanumeric_Supplement',
'IsOld_South_Arabian',
'InMeeteiMayekExtensions',
'InSiddham',
'KanaSupplement',
'InCaucasian_Albanian',
'InHighSurrogates',
'Bopomofo_Extended',
'InTelugu',
'InTransport_and_Map_Symbols',
'MusicalSymbols',
'IsGlagolitic',
'InByzantine_Musical_Symbols',
'IsCham',
'InTangut',
'IsCypriotSyllabary',
'IsEthiopicExtended',
'InCherokee_Supplement',
'Kangxi_Radicals',
'InLepcha',
'Balinese',
'InYi_Syllables',
'InSutton_SignWriting',
'IsManichaean',
'IsGreek_Extended',
'Kana_Supplement',
'GeometricShapesExtended',
'IsWarangCiti',
'Combining_Diacritical_Marks_Extended',
'OldTurkic',
'IsGeometricShapesExtended',
'IsImperial_Aramaic',
'IsLatin_Extended_Additional',
'InHangulSyllables',
'InKayahLi',
'InPlaying_Cards',
'LatinExtendedAdditional',
'IsGurmukhi',
'IsLatinExtendedAdditional',
'IsTirhuta',
'InOrnamental_Dingbats',
'IsIdeographicDescriptionCharacters',
'InTransportandMapSymbols',
'Malayalam',
'IsTelugu',
'IsMiscellaneous_Mathematical_Symbols-B',
'Telugu',
'InInscriptionalParthian',
'InCopticEpactNumbers',
'ImperialAramaic',
'IsLinearA',
'InCJK_Compatibility_Forms',
'IsHalfwidthandFullwidthForms',
'IsCombiningDiacriticalMarksSupplement',
'InKana_Supplement',
'IsGreekandCoptic',
'InOl_Chiki',
'CJKStrokes',
'IsPalmyrene',
'InYi_Radicals',
'Arrows',
'IsGlagolitic_Supplement',
'InMiscellaneousSymbolsandArrows',
'IsOld_Italic',
'IsHigh_Private_Use_Surrogates',
'IsTai_Tham',
'InEnclosed_Ideographic_Supplement',
'Alchemical_Symbols',
'IsMyanmar_Extended-A',
'IsMongolian',
'InPhaistos_Disc',
'InGreek_Extended',
'InAlphabetic_Presentation_Forms',
'Shavian',
'IsGeometric_Shapes_Extended',
'IsBamumSupplement',
'Greek_Extended',
'IsCaucasianAlbanian',
'IsDevanagari_Extended',
'IsKanbun',
'Cyrillic',
'InOldPersian',
'InMalayalam',
'InCJKCompatibilityIdeographsSupplement',
'IsTifinagh',
'InNumberForms',
'Coptic',
'ShorthandFormatControls',
'InLow_Surrogates',
'IsCJKCompatibilityIdeographs',
'InLatinExtended-A',
'InLatinExtended-B',
'MiscellaneousTechnical',
'IsEmoticons',
'MiscellaneousSymbolsandArrows',
'IsLatinExtended-D',
'InYijing_Hexagram_Symbols',
'IsSupplementalMathematicalOperators',
'IsOld_Persian',
'InVariationSelectors',
'IsIdeographicSymbolsandPunctuation',
'EthiopicSupplement',
'IsSinhalaArchaicNumbers',
'IsCJK_Symbols_and_Punctuation',
'IsMandaic',
'InDomino_Tiles',
'IsArabicPresentationForms-B',
'OldItalic',
'InGlagoliticSupplement',
'InArabicPresentationForms-A',
'InCombiningDiacriticalMarksSupplement',
'InOlChiki',
'InPahawh_Hmong',
'InLetterlikeSymbols',
'IsKayahLi',
'IsTamil',
'Deseret',
'IsLinear_B_Ideograms',
'SupplementalMathematicalOperators',
'Emoticons',
'InYijingHexagramSymbols',
'IsDingbats',
'IsMeetei_Mayek_Extensions',
'InMongolian',
'InEnclosedAlphanumerics',
'IsHangulSyllables',
'InIPA_Extensions',
'NewTaiLue',
'IsBopomofo',
'Modifier_Tone_Letters',
'DominoTiles',
'IsBoxDrawing',
'PsalterPahlavi',
'IsBalinese',
'EthiopicExtended-A',
'Osage',
'InCombining_Diacritical_Marks_Extended',
'IsBengali',
'InNewa',
'Bamum',
'LinearBSyllabary',
'IsPrivateUseArea',
'InMiscellaneous_Symbols_and_Pictographs',
'InRumiNumeralSymbols',
'InLatin_Extended-C',
'InLatin_Extended-D',
'InBraillePatterns',
'InAegean_Numbers',
'InVertical_Forms',
'MiscellaneousSymbols',
'IsMiscellaneousSymbolsandPictographs',
'IsIdeographic_Symbols_and_Punctuation',
'IsCyrillic',
'WarangCiti',
'IsSpacing_Modifier_Letters',
'Tai_Viet',
'Meetei_Mayek_Extensions',
'IsLatin-1Supplement',
'IsTai_Le',
'InEnclosedAlphanumericSupplement',
'Nabataean',
'IsHangulJamoExtended-A',
'Specials',
'Modi',
'GeometricShapes',
'IsCombining_Marks_for_Symbols',
'InSupplementary_Private_Use_Area-B',
'MahjongTiles',
'InCombining_Diacritical_Marks_Supplement',
'Khmer',
'InHangulCompatibilityJamo',
'OrnamentalDingbats',
'IsIPA_Extensions',
'InAncient_Symbols',
'Phoenician',
'HangulJamoExtended-B',
'InGlagolitic',
'IsGeorgian_Supplement',
'CJK_Compatibility',
'InBamum_Supplement',
'Domino_Tiles',
'InOptical_Character_Recognition',
'YijingHexagramSymbols',
'IsAncient_Greek_Musical_Notation',
'SundaneseSupplement',
'Tangut_Components',
'IsShorthand_Format_Controls',
'HangulJamoExtended-A',
'InCombining_Diacritical_Marks_for_Symbols',
'InKhmer_Symbols',
'IsLao',
'IsSmall_Form_Variants',
'InTagbanwa',
'InAnatolian_Hieroglyphs',
'IsLepcha',
'InEnclosed_CJK_Letters_and_Months',
'InPahawhHmong',
'SupplementalArrows-B',
'SupplementalArrows-C',
'IsArabic_Supplement',
'InSmall_Form_Variants',
'InYiRadicals',
'MiscellaneousSymbolsandPictographs',
'InRumi_Numeral_Symbols',
'Bhaiksuki',
'HighSurrogates',
'IsEarlyDynasticCuneiform',
'Latin_Extended-D',
'Latin_Extended-E',
'TransportandMapSymbols',
'IsOrnamentalDingbats',
'InKhmerSymbols',
'Latin_Extended-A',
'Latin_Extended-B',
'Latin_Extended-C',
'Saurashtra',
'InMiscellaneousTechnical',
'InArabicMathematicalAlphabeticSymbols',
'CJKUnifiedIdeographsExtensionC',
'InIdeographicDescriptionCharacters',
'IsEnclosedCJKLettersandMonths',
'IsMiscellaneousSymbols',
'InInscriptional_Pahlavi',
'IsBrahmi',
'Oriya',
'IsCuneiformNumbersandPunctuation',
'InCommon_Indic_Number_Forms',
'MongolianSupplement',
'Ethiopic_Extended',
'IsCJKRadicalsSupplement',
'IsGeometricShapes',
'InSundanese',
'IsKhmer',
'IsAncient_Greek_Numbers',
'InCJK_Compatibility',
'InSuperscriptsandSubscripts',
'IsCypriot_Syllabary',
'MeeteiMayekExtensions',
'InMeroitic_Cursive',
'InMathematical_Alphanumeric_Symbols',
'IsLatin_Extended-A',
'IsAncientGreekNumbers',
'InLatin-1_Supplement',
'Optical_Character_Recognition',
'InMendeKikakui',
'IsEthiopic_Extended-A',
'CJK_Strokes',
'Braille_Patterns',
'InKayah_Li',
'Tangut',
'IsSuttonSignWriting',
'Phonetic_Extensions',
'IsCJKCompatibilityForms',
'InBraille_Patterns',
'Sinhala',
'InCoptic',
'InCuneiform_Numbers_and_Punctuation',
'IsCounting_Rod_Numerals',
'Devanagari',
'Armenian',
'InChakma',
'IPAExtensions',
'InAncient_Greek_Musical_Notation',
'Arabic_Presentation_Forms-A',
'Thaana',
'InSinhala',
'InKhmer',
'CJK_Compatibility_Ideographs',
'InNew_Tai_Lue',
'InShorthandFormatControls',
'Dingbats',
'IsMende_Kikakui',
'PhoneticExtensions',
'IsGrantha',
'IsLinear_B_Syllabary',
'IsMiscellaneous_Symbols_and_Pictographs',
'IsKatakana_Phonetic_Extensions',
'InMiscellaneous_Mathematical_Symbols-A',
'InPhonetic_Extensions_Supplement',
'Cyrillic_Supplement',
'IsAlphabetic_Presentation_Forms',
'IsKangxi_Radicals',
'IsSinhala',
'EarlyDynasticCuneiform',
'IsLatinExtended-B',
'IsDevanagariExtended',
'InControlPictures',
'IsNewTaiLue',
'Mongolian',
'TaiTham',
'IsMeroitic_Cursive',
'Old_Hungarian',
'IsInscriptional_Parthian',
'IsCommonIndicNumberForms',
'InBassaVah',
'InAdlam',
'IsGeorgian',
'IsEnclosed_CJK_Letters_and_Months',
'PrivateUseArea',
'IsTangut',
'SoraSompeng',
'IsEthiopicSupplement',
'CJK_Unified_Ideographs',
'InBamum',
'InSupplementalSymbolsandPictographs',
'IsSuperscriptsandSubscripts',
'InCountingRodNumerals',
'IsHiragana',
'Miao',
'InCommonIndicNumberForms',
'IsBraillePatterns',
'InGeorgian_Supplement',
'InCyrillic_Extended-C',
'InOldTurkic',
'IsGeneralPunctuation',
'MeroiticHieroglyphs',
'HangulSyllables',
'Combining_Marks_for_Symbols',
'IsSyloti_Nagri',
'IsKaithi',
'InTai_Viet',
'IsGeorgianSupplement',
'InMathematicalOperators',
'InMyanmarExtended-B',
'IsCombining_Diacritical_Marks',
'InMyanmarExtended-A',
'InBopomofo',
'Lisu',
'InMiao',
'InWarangCiti',
'InTirhuta',
'IsLisu',
'InTibetan',
'IsSuperscripts_and_Subscripts',
'EthiopicExtended',
'IsCombiningDiacriticalMarksExtended',
'Psalter_Pahlavi',
'InCoptic_Epact_Numbers',
'TaiLe',
'InSuperscripts_and_Subscripts',
'InSupplementalPunctuation',
'IsSupplemental_Mathematical_Operators',
'RumiNumeralSymbols',
'Warang_Citi',
'InVariation_Selectors_Supplement',
'IsNewa',
'Ancient_Symbols',
'InVariationSelectorsSupplement',
'Hatran',
'HalfwidthandFullwidthForms',
'Cyrillic_Extended-B',
'InMusical_Symbols',
'CJK_Compatibility_Forms',
'IsEthiopic',
'Meetei_Mayek',
'InHangulJamo',
'InShavian',
'InArabicPresentationForms-B',
'Cuneiform',
'IsInscriptional_Pahlavi',
'IsEnclosedIdeographicSupplement',
'InOldNorthArabian',
'InIdeographicSymbolsandPunctuation',
'IsImperialAramaic',
'IsKhudawadi',
'IsSupplementary_Private_Use_Area-A',
'IsInscriptionalParthian',
'InLatin_Extended_Additional',
'AncientGreekNumbers',
'Mathematical_Alphanumeric_Symbols',
'IsDominoTiles',
'HighPrivateUseSurrogates',
'IsAlchemicalSymbols',
'CombiningDiacriticalMarksSupplement',
'TaiXuanJingSymbols',
'InEthiopicSupplement',
'InAlchemical_Symbols',
'InPrivateUseArea',
'InMeroiticHieroglyphs',
'Cham',
'IsLetterlikeSymbols',
'InBlockElements',
'Avestan',
'InCuneiform',
'CopticEpactNumbers',
'IsCJK_Compatibility_Forms',
'InBopomofo_Extended',
'IsLatin_Extended-D',
'InSpacing_Modifier_Letters',
'IsLycian',
'IsPhoneticExtensionsSupplement',
'InCarian',
'IsHangulJamo',
'InHangulJamoExtended-A',
'IsBraille_Patterns',
'CJKCompatibilityIdeographs',
'IsAncient_Symbols',
'IsCJKUnifiedIdeographsExtensionB',
'NumberForms',
'YiRadicals',
'Kanbun',
'InHangul_Compatibility_Jamo',
'InSupplementalArrows-A',
'InOld_Persian',
'InVedicExtensions',
'InEnclosed_Alphanumerics',
'InCuneiformNumbersandPunctuation',
'IsSupplemental_Arrows-C',
'Myanmar_Extended-B',
'InOsage',
'IsCommon_Indic_Number_Forms',
'IsCJKCompatibility',
'Old_Turkic',
'Bengali',
'IsHangulCompatibilityJamo',
'IsMiscellaneous_Symbols_and_Arrows',
'IsOriya',
'AncientSymbols',
'Bopomofo',
'ModifierToneLetters',
'AnatolianHieroglyphs',
'Egyptian_Hieroglyphs',
'IsPahawhHmong',
'InPalmyrene',
'EnclosedCJKLettersandMonths',
'Counting_Rod_Numerals',
'Glagolitic',
'IsKhmer_Symbols',
'InKharoshthi',
'IsOldNorthArabian',
'Tags',
'InMro',
'Old_North_Arabian',
'Unified_Canadian_Aboriginal_Syllabics',
'InOldPermic',
'IsArabicExtended-A',
'InAvestan',
'Ethiopic',
'Ogham',
'CypriotSyllabary',
'CyrillicExtended-A',
'IsLinearBSyllabary',
'IsSamaritan',
'InSinhala_Archaic_Numbers',
'IsBuhid',
'Lydian',
'Supplemental_Punctuation',
'Kaithi',
'Sharada',
'Phonetic_Extensions_Supplement',
'InPhonetic_Extensions',
'IsPhoenician',
'IsUgaritic',
'InUgaritic',
'OldHungarian',
'IsCJK_Unified_Ideographs_Extension_A',
'Meroitic_Cursive',
'CombiningDiacriticalMarksforSymbols',
'IsCJK_Unified_Ideographs_Extension_B',
'IsCurrency_Symbols',
'GreekExtended',
'InMahjongTiles',
'Mahjong_Tiles',
'InCham',
'InCJKSymbolsandPunctuation',
'InHangulJamoExtended-B',
'IsYi_Syllables',
'InCurrency_Symbols',
'InOgham',
'InscriptionalPahlavi',
'InMathematical_Operators',
'Ol_Chiki',
'CJKUnifiedIdeographsExtensionE',
'SupplementaryPrivateUseArea-A',
'IsNew_Tai_Lue',
'InKanbun',
'VariationSelectorsSupplement',
'InGeometricShapes',
'InAncientGreekMusicalNotation',
'IsEnclosed_Alphanumerics',
'InCombining_Diacritical_Marks',
'InTamil',
'SupplementalPunctuation',
'IsCyrillic_Supplement',
'IsRumiNumeralSymbols',
'InEthiopicExtended',
'IsSupplementalSymbolsandPictographs',
'Combining_Diacritical_Marks',
'IsCherokee',
'InOld_South_Arabian',
'OldSouthArabian',
'InCaucasianAlbanian',
'IsOldPermic',
'InVedic_Extensions',
'Duployan',
'Tirhuta',
'IsMiscellaneous_Symbols',
'KangxiRadicals',
'Latin_Extended_Additional',
'Vertical_Forms',
'Shorthand_Format_Controls',
'InCJKCompatibility',
'InHalfwidthandFullwidthForms',
'Miscellaneous_Mathematical_Symbols-B',
'IsArabic_Extended-A',
'InUnifiedCanadianAboriginalSyllabicsExtended',
'IsElbasan',
'InNKo',
'InEarlyDynasticCuneiform',
'SinhalaArchaicNumbers',
'SuperscriptsandSubscripts',
'IsYi_Radicals',
'UnifiedCanadianAboriginalSyllabics',
'Small_Form_Variants',
'InSupplementalArrows-B',
'InArabicSupplement',
'Osmanya',
'InSupplemental_Arrows-B',
'InPhaistosDisc',
'CyrillicExtended-B',
'IsThai',
'IsKatakanaPhoneticExtensions',
'InTaiLe',
'InVai',
'InGurmukhi',
'Myanmar_Extended-A',
'Supplemental_Arrows-C',
'Caucasian_Albanian',
'InDuployan',
'IsSupplementaryPrivateUseArea-A',
'IsKayah_Li',
'InGeometric_Shapes_Extended',
'IsSupplementaryPrivateUseArea-B',
'InAlchemicalSymbols',
'Carian',
'IsBlockElements',
'InDevanagari_Extended',
'IsShavian',
'InLisu',
'IsKhojki',
'IsTangut_Components',
'Cherokee_Supplement',
'IsTakri',
'InBassa_Vah',
'CombiningHalfMarks',
'Sinhala_Archaic_Numbers',
'InLimbu',
'IsYijing_Hexagram_Symbols',
'IsDevanagari',
'IsNumber_Forms',
'CyrillicSupplement',
'IsVariation_Selectors',
'IsHalfwidth_and_Fullwidth_Forms',
'SmallFormVariants',
'IsSharada',
'BlockElements',
'InVerticalForms',
'IsCJK_Compatibility',
'InLinear_B_Syllabary',
'InSaurashtra',
'InMyanmar_Extended-B',
'InKatakana',
'Miscellaneous_Mathematical_Symbols-A',
'Pahawh_Hmong',
'IsHighSurrogates',
'InMandaic',
'IsLowSurrogates',
'IsMahjong_Tiles',
'Bassa_Vah',
'Common_Indic_Number_Forms',
'IsTaiLe',
'InImperial_Aramaic',
'InSupplemental_Arrows-A',
'InBamumSupplement',
'InGeneralPunctuation',
'Thai',
'Lycian',
'InControl_Pictures',
'Superscripts_and_Subscripts',
'IsMeroitic_Hieroglyphs',
'IsTaiXuanJingSymbols',
'IsCJK_Compatibility_Ideographs_Supplement',
'InLatinExtended-C',
'IsHangul_Jamo_Extended-A',
'IsVariation_Selectors_Supplement',
'IsMusical_Symbols',
'IsHangul_Jamo_Extended-B',
'IsLinearBIdeograms',
'IsGeneral_Punctuation',
'IsMeetei_Mayek',
'IsCJKUnifiedIdeographsExtensionD',
'VerticalForms',
'IsPahawh_Hmong',
'IsCJKSymbolsandPunctuation',
'IsNumberForms',
'InKaithi',
'InMongolianSupplement',
'InBoxDrawing',
'InAnatolianHieroglyphs',
'InCJK_Unified_Ideographs',
'Supplementary_Private_Use_Area-A',
'IsThaana',
'Pau_Cin_Hau',
'IsOsmanya',
'IsCJK_Unified_Ideographs',
'OldPermic',
'InPau_Cin_Hau',
'LatinExtended-E',
'LatinExtended-D',
'LatinExtended-C',
'InGeneral_Punctuation',
'InCJK_Compatibility_Ideographs',
'InBhaiksuki',
'IsMiscellaneousTechnical',
'Buginese',
'IsVariationSelectorsSupplement',
'UnifiedCanadianAboriginalSyllabicsExtended',
'IsTaiTham',
'Arabic',
'IsCombining_Half_Marks',
'High_Private_Use_Surrogates',
'IsMendeKikakui',
'IsBuginese',
'Old_Permic',
'IsBlock_Elements',
'Arabic_Supplement',
'InCJKRadicalsSupplement',
'IPA_Extensions',
'Multani',
'InIdeographic_Description_Characters',
'InAhom',
'IsCyrillic_Extended-B',
'IsCyrillic_Extended-C',
'InInscriptional_Parthian',
'Halfwidth_and_Fullwidth_Forms',
'Mathematical_Operators',
'InMeroiticCursive',
'Tagbanwa',
'IsVedic_Extensions',
'InAegeanNumbers',
'CJK_Symbols_and_Punctuation',
'CJKUnifiedIdeographs',
'InCherokeeSupplement',
'Ahom',
'InCyrillicExtended-B',
'InMahajani',
'InCyrillicSupplement',
'Arabic_Extended-A',
'IsArabicPresentationForms-A',
'Syloti_Nagri',
'IsRunic',
'OpticalCharacterRecognition',
'InTai_Le',
'InBrahmi',
'CJKSymbolsandPunctuation',
'InKhudawadi',
'PhaistosDisc',
'InGujarati',
'Cherokee',
'IsChakma',
'IsKannada',
'InArabic_Presentation_Forms-B',
'IsMiao',
'Latin-1_Supplement',
'AlphabeticPresentationForms',
'IsLatin-1_Supplement',
'IdeographicDescriptionCharacters',
'Spacing_Modifier_Letters',
'InHangul_Jamo',
'IsOld_Permic',
'Cuneiform_Numbers_and_Punctuation',
'Geometric_Shapes',
'InAncient_Greek_Numbers',
'IsAnatolianHieroglyphs',
'IsBamum',
'ArabicPresentationForms-B',
'InHatran',
'ArabicPresentationForms-A',
'CaucasianAlbanian',
'IsSupplementalArrows-B',
'InOriya',
'IsByzantineMusicalSymbols',
'ArabicSupplement',
'Chakma',
'Tai_Le',
'IsMathematicalAlphanumericSymbols',
'IsOptical_Character_Recognition',
'IsPsalter_Pahlavi',
'IsBox_Drawing',
'IsOlChiki',
'InEgyptian_Hieroglyphs',
'IsMultani',
'IsMongolianSupplement',
'IsCountingRodNumerals',
'IsPau_Cin_Hau',
'MyanmarExtended-B',
'Enclosed_CJK_Letters_and_Months',
'IsGothic',
'Box_Drawing',
'Inscriptional_Parthian',
'BamumSupplement',
'InSuttonSignWriting',
'LinearBIdeograms',
'InCJK_Unified_Ideographs_Extension_D',
'IsTai_Viet',
'InSyriac',
'MathematicalOperators',
'IsSundaneseSupplement',
'CJK_Unified_Ideographs_Extension_E',
'InCJK_Unified_Ideographs_Extension_B',
'CJK_Unified_Ideographs_Extension_C',
'InEarly_Dynastic_Cuneiform',
'CJK_Unified_Ideographs_Extension_A',
'IsDuployan',
'Imperial_Aramaic',
'EgyptianHieroglyphs',
'InBalinese',
'IsArabic_Mathematical_Alphabetic_Symbols',
'InBlock_Elements',
'IsSoraSompeng',
'InSoraSompeng',
'IsCoptic',
'IsHangulJamoExtended-B',
'IsBhaiksuki',
'InSundanese_Supplement',
'InHanunoo',
'InMiscellaneousMathematicalSymbols-A',
'IsMiscellaneous_Mathematical_Symbols-A',
'Georgian_Supplement',
'InEnclosedCJKLettersandMonths',
'InSupplementaryPrivateUseArea-A',
'InRunic',
'IsCJKUnifiedIdeographs',
'GreekandCoptic',
'InGrantha',
'InMiscellaneousMathematicalSymbols-B',
'IsOrnamental_Dingbats',
'IsTransportandMapSymbols',
'InEmoticons',
'IsSmallFormVariants',
'InLao',
'IsVariationSelectors',
'Gothic',
'CombiningMarksforSymbols',
'InGeorgian',
'IsCaucasian_Albanian',
'IsShorthandFormatControls',
'IsUnified_Canadian_Aboriginal_Syllabics',
'InMultani',
'AlchemicalSymbols',
'InGeometric_Shapes',
'InKangxi_Radicals',
'InTagalog',
'InDeseret',
'Katakana_Phonetic_Extensions',
'Yijing_Hexagram_Symbols',
'IsCuneiform',
'InBuginese',
'InGothic',
'InCJKUnifiedIdeographsExtensionE',
'Khmer_Symbols',
'InPsalterPahlavi',
'InCypriotSyllabary',
'InOld_Italic',
'Ornamental_Dingbats',
'InEnclosed_Alphanumeric_Supplement',
'InCJKUnifiedIdeographsExtensionB',
'IsIdeographic_Description_Characters',
'Enclosed_Ideographic_Supplement',
'IsCJK_Unified_Ideographs_Extension_C',
'AegeanNumbers',
'IsCJK_Unified_Ideographs_Extension_E',
'IsArabicMathematicalAlphabeticSymbols',
'IsCJK_Unified_Ideographs_Extension_D',
'CherokeeSupplement',
'IsHigh_Surrogates',
'Takri',
'InPhoneticExtensionsSupplement',
'InCyrillic_Extended-A',
'SupplementalArrows-A',
'InTangut_Components',
'IsCoptic_Epact_Numbers',
'Hangul_Compatibility_Jamo',
'IsControlPictures',
'Ancient_Greek_Numbers',
'Hiragana',
'CJK_Radicals_Supplement',
'InCJK_Unified_Ideographs_Extension_C',
'IsArabic_Presentation_Forms-A',
'Kharoshthi',
'InNumber_Forms',
'CuneiformNumbersandPunctuation',
'KatakanaPhoneticExtensions',
'IsHebrew',
'InImperialAramaic',
'InCombiningMarksforSymbols',
'General_Punctuation',
'Arabic_Presentation_Forms-B',
'Miscellaneous_Technical',
'IsArabicSupplement',
'InHangul_Jamo_Extended-A',
'InHangul_Jamo_Extended-B',
'Early_Dynastic_Cuneiform',
'IsSundanese',
'InRejang',
'IsTags',
'InCJKCompatibilityForms',
'InDingbats',
'Mahajani',
'IsSupplementalPunctuation',
'InBox_Drawing',
'InAlphabeticPresentationForms',
'IsEarly_Dynastic_Cuneiform',
'TangutComponents',
'IsPhaistosDisc',
'IsSora_Sompeng',
'PauCinHau',
'Currency_Symbols',
'CJKCompatibilityForms',
'Rejang',
'IsYiSyllables',
'Marchen',
'InTangutComponents',
'Siddham',
'InSupplemental_Punctuation',
'InMathematicalAlphanumericSymbols',
'InManichaean',
'InMeeteiMayek',
'Devanagari_Extended',
'LowSurrogates',
'InMongolian_Supplement',
'InSharada',
'IsOld_Turkic',
'Phaistos_Disc',
'IsMiscellaneousMathematicalSymbols-B',
'IsMiscellaneousMathematicalSymbols-A',
'IsAvestan',
'InSpecials',
'InDevanagariExtended',
'IsHanunoo',
'SupplementalSymbolsandPictographs',
'InHigh_Surrogates',
'InCurrencySymbols',
'InCypriot_Syllabary',
'Miscellaneous_Symbols',
'IsLatinExtended-E',
'IsLatinExtended-C',
'IsSupplementalArrows-C',
'InEnclosedIdeographicSupplement',
'Tamil',
'IsJavanese',
'IsMalayalam',
'InThaana',
'InIPAExtensions',
'Yi_Syllables',
'IsVai',
'InLinearBSyllabary',
'Tai_Xuan_Jing_Symbols',
'InCombiningDiacriticalMarks',
'Anatolian_Hieroglyphs',
'New_Tai_Lue',
'IsCombiningDiacriticalMarks',
'CJK_Unified_Ideographs_Extension_B',
'Aegean_Numbers',
'IsArabic',
'InShorthand_Format_Controls',
'LatinExtended-B',
'InKanaSupplement',
'Private_Use_Area',
'InIdeographic_Symbols_and_Punctuation',
'Hanunoo',
'Transport_and_Map_Symbols',
'IsSinhala_Archaic_Numbers',
'InMiscellaneousSymbols',
'InOsmanya',
'InSupplemental_Arrows-C',
'Samaritan',
'InCJKStrokes',
'Supplemental_Symbols_and_Pictographs',
'High_Surrogates',
'InTai_Tham',
'IsLinear_A',
'Latin-1Supplement'
);

      PUCUUnicodeBlockHashMapValueBits=16;

      PUCUUnicodeBlockHashMapValues:array[0..1337] of word=(
220,
169,
215,
269,
5,
268,
159,
168,
90,
44,
104,
200,
256,
49,
268,
84,
96,
193,
181,
27,
255,
71,
66,
174,
33,
76,
197,
16,
7,
114,
38,
126,
68,
124,
192,
45,
138,
71,
204,
200,
110,
128,
11,
170,
22,
101,
272,
11,
55,
7,
145,
133,
80,
204,
170,
201,
101,
79,
186,
147,
73,
99,
229,
263,
80,
59,
89,
266,
64,
91,
142,
5,
227,
197,
185,
17,
128,
13,
126,
117,
60,
256,
189,
140,
135,
8,
166,
98,
111,
119,
150,
208,
261,
19,
81,
258,
249,
245,
37,
270,
39,
199,
174,
240,
30,
105,
67,
244,
110,
243,
118,
148,
61,
33,
244,
246,
174,
131,
49,
61,
250,
262,
148,
237,
216,
21,
61,
62,
162,
230,
140,
249,
34,
137,
192,
27,
108,
266,
259,
75,
264,
179,
74,
96,
58,
217,
247,
263,
268,
3,
141,
152,
191,
62,
72,
69,
188,
88,
167,
80,
139,
251,
247,
55,
72,
55,
63,
234,
134,
248,
1,
68,
100,
72,
122,
23,
232,
241,
218,
13,
151,
272,
125,
141,
184,
48,
227,
181,
138,
112,
209,
73,
241,
227,
35,
124,
127,
271,
63,
102,
37,
154,
36,
219,
122,
110,
242,
4,
247,
129,
65,
76,
242,
97,
217,
197,
124,
128,
115,
267,
192,
82,
64,
72,
151,
142,
225,
153,
202,
60,
92,
63,
87,
163,
116,
213,
143,
181,
72,
237,
89,
272,
62,
99,
48,
144,
61,
83,
72,
198,
250,
190,
155,
178,
7,
92,
102,
138,
118,
187,
236,
52,
143,
144,
248,
189,
268,
48,
140,
37,
126,
79,
58,
188,
58,
147,
87,
40,
115,
200,
254,
130,
132,
143,
39,
154,
220,
260,
173,
221,
78,
99,
54,
41,
252,
209,
42,
103,
64,
250,
193,
119,
73,
52,
251,
10,
44,
54,
2,
126,
2,
228,
91,
231,
14,
265,
200,
115,
121,
66,
267,
75,
155,
98,
170,
124,
231,
246,
32,
51,
240,
253,
99,
7,
254,
245,
9,
190,
246,
150,
144,
35,
92,
223,
199,
253,
234,
19,
157,
153,
149,
148,
193,
160,
231,
266,
254,
153,
265,
115,
57,
23,
94,
48,
155,
91,
149,
39,
141,
223,
131,
248,
78,
253,
240,
106,
137,
16,
97,
230,
243,
78,
137,
158,
169,
42,
2,
20,
10,
111,
216,
253,
194,
247,
35,
212,
32,
101,
165,
229,
31,
140,
242,
252,
139,
162,
9,
240,
161,
155,
198,
5,
112,
135,
189,
272,
3,
185,
73,
182,
255,
108,
172,
196,
162,
201,
206,
110,
90,
12,
19,
65,
147,
163,
164,
106,
211,
86,
18,
77,
243,
111,
33,
87,
181,
175,
6,
77,
221,
253,
241,
261,
179,
165,
134,
254,
192,
139,
215,
237,
180,
146,
110,
26,
259,
241,
93,
240,
136,
235,
182,
98,
142,
102,
59,
56,
118,
246,
194,
68,
237,
261,
220,
55,
199,
261,
183,
67,
144,
131,
253,
67,
22,
67,
214,
258,
103,
259,
28,
26,
90,
26,
196,
169,
183,
181,
156,
159,
66,
237,
7,
60,
111,
184,
119,
75,
247,
92,
170,
147,
54,
255,
260,
137,
47,
166,
68,
151,
176,
261,
229,
68,
180,
130,
109,
8,
174,
28,
268,
97,
74,
95,
239,
148,
150,
2,
3,
77,
257,
92,
125,
116,
91,
174,
153,
234,
37,
208,
104,
18,
252,
158,
170,
247,
152,
66,
60,
232,
73,
131,
25,
175,
162,
91,
257,
116,
85,
139,
47,
80,
144,
4,
51,
107,
124,
252,
81,
198,
56,
140,
178,
55,
21,
213,
123,
161,
149,
256,
201,
94,
125,
88,
163,
154,
84,
256,
234,
8,
220,
5,
138,
139,
1,
50,
254,
185,
133,
160,
216,
83,
72,
272,
251,
66,
46,
108,
258,
4,
165,
187,
145,
93,
96,
114,
229,
252,
79,
116,
242,
62,
236,
239,
133,
72,
52,
31,
157,
45,
228,
59,
113,
232,
89,
262,
14,
157,
119,
256,
201,
222,
146,
226,
125,
141,
259,
258,
52,
2,
3,
94,
129,
77,
250,
265,
103,
113,
84,
197,
202,
24,
225,
127,
217,
98,
101,
83,
57,
46,
164,
114,
70,
182,
139,
190,
245,
2,
164,
1,
79,
248,
140,
111,
88,
131,
235,
246,
64,
156,
88,
29,
95,
225,
244,
20,
10,
205,
4,
242,
152,
15,
29,
46,
150,
51,
239,
85,
248,
64,
212,
161,
256,
112,
86,
65,
9,
151,
102,
29,
226,
3,
130,
78,
51,
47,
54,
190,
200,
196,
127,
231,
249,
34,
113,
149,
235,
204,
37,
117,
123,
263,
70,
244,
105,
233,
127,
88,
96,
61,
199,
69,
189,
144,
72,
126,
203,
138,
96,
76,
135,
6,
137,
107,
120,
233,
220,
214,
120,
32,
70,
98,
55,
198,
169,
50,
70,
100,
91,
201,
220,
270,
213,
165,
270,
186,
159,
122,
241,
156,
36,
143,
35,
176,
158,
224,
197,
255,
193,
234,
183,
211,
271,
196,
67,
164,
245,
252,
147,
260,
66,
243,
37,
260,
149,
189,
136,
73,
82,
195,
224,
169,
156,
110,
125,
5,
167,
65,
168,
35,
133,
88,
150,
165,
264,
74,
119,
109,
108,
87,
174,
63,
80,
225,
262,
135,
178,
127,
114,
199,
21,
108,
92,
24,
165,
107,
124,
228,
227,
232,
184,
113,
244,
93,
52,
191,
193,
269,
230,
193,
39,
172,
19,
195,
36,
40,
182,
99,
161,
17,
208,
44,
188,
100,
203,
207,
65,
64,
187,
173,
173,
200,
115,
190,
72,
264,
71,
68,
251,
251,
136,
104,
145,
118,
71,
40,
197,
76,
60,
267,
271,
51,
109,
270,
83,
242,
80,
6,
25,
100,
9,
201,
98,
263,
6,
38,
192,
192,
180,
172,
63,
238,
214,
84,
102,
67,
154,
239,
114,
159,
90,
19,
48,
179,
16,
226,
208,
70,
119,
39,
157,
89,
14,
177,
89,
166,
122,
30,
112,
50,
121,
22,
137,
262,
180,
238,
271,
131,
261,
272,
260,
168,
82,
130,
176,
120,
209,
236,
142,
218,
231,
155,
208,
49,
116,
20,
74,
9,
153,
159,
157,
207,
82,
154,
114,
161,
129,
135,
106,
86,
232,
146,
18,
148,
251,
231,
127,
50,
183,
87,
229,
69,
30,
167,
78,
70,
189,
243,
268,
94,
133,
270,
241,
145,
162,
69,
143,
266,
154,
232,
104,
74,
203,
217,
81,
228,
117,
271,
15,
221,
177,
117,
172,
221,
141,
125,
94,
69,
150,
222,
77,
53,
270,
48,
54,
12,
155,
147,
248,
53,
172,
82,
14,
101,
4,
210,
103,
219,
122,
61,
196,
159,
76,
190,
45,
63,
163,
104,
117,
142,
219,
122,
206,
9,
19,
152,
126,
41,
79,
50,
202,
104,
211,
166,
23,
38,
205,
27,
158,
233,
1,
151,
1,
103,
5,
35,
172,
225,
83,
164,
228,
123,
158,
186,
152,
180,
89,
24,
240,
14,
205,
50,
245,
79,
198,
81,
60,
227,
210,
217,
244,
221,
135,
113,
171,
81,
196,
229,
246,
162,
266,
138,
13,
76,
62,
267,
264,
265,
226,
115,
238,
183,
227,
56,
250,
82,
204,
204,
95,
145,
222,
62,
43,
86,
86,
96,
113,
271,
41,
117,
7,
212,
90,
258,
259,
257,
157,
31,
153,
171,
72,
34,
180,
239,
39,
210,
260,
83,
102,
42,
175,
112,
116,
224,
53,
171,
267,
52,
198,
182,
170,
258,
254,
264,
103,
255,
265,
163,
267,
250,
266,
142,
146,
218,
65,
99,
87,
236,
169,
108,
78,
164,
105,
101,
265,
152,
191,
74,
225,
112,
11,
183,
72,
69,
158,
77,
14,
133,
145,
226,
57,
132,
269,
156,
85,
206,
100,
81,
151,
226,
236,
166,
204,
221,
71,
156,
132,
118,
223,
236,
215,
100,
245,
194,
143,
130,
148,
217,
207,
199,
166,
90,
86,
195,
160,
130,
43,
263,
146,
71,
182,
84,
141,
94,
262,
255,
25,
134,
28,
15,
4,
118,
121,
161,
243,
6,
228,
51,
6,
264,
163,
12,
239,
3,
237,
149,
234,
43,
259,
208,
84,
177,
262,
17,
111,
263,
146,
54,
181,
1
);

const PUCUUnicodeAdditionalBlockHashMapSeedSize=24;
      PUCUUnicodeAdditionalBlockHashMapValueSize=24;
      PUCUUnicodeAdditionalBlockHashMapSize=24;

      PUCUUnicodeAdditionalBlockHashMapSeedBits=8;

      PUCUUnicodeAdditionalBlockHashMapSeeds:array[0..23] of shortint=(
-24,
0,
2,
0,
-21,
0,
0,
2,
-12,
1,
0,
1,
0,
-9,
1,
0,
0,
2,
-5,
-3,
3,
1,
4,
0
);

      PUCUUnicodeAdditionalBlockHashMapKeys:array[0..23] of TPUCURawByteString=(
'xmlC',
'xmlI',
'IsxmlC',
'InxmlC',
'_xmlC',
'IsxmlI',
'IsxmlD',
'xmlW',
'In_xmlW',
'_xmlD',
'Is_xmlC',
'_xmlI',
'In_xmlC',
'Is_xmlD',
'InxmlD',
'In_xmlI',
'IsxmlW',
'In_xmlD',
'_xmlW',
'Is_xmlW',
'InxmlI',
'InxmlW',
'Is_xmlI',
'xmlD'
);

      PUCUUnicodeAdditionalBlockHashMapValueBits=8;

      PUCUUnicodeAdditionalBlockHashMapValues:array[0..23] of byte=(
0,
2,
0,
0,
0,
2,
1,
3,
3,
1,
0,
2,
0,
1,
1,
2,
3,
1,
3,
3,
2,
3,
2,
1
);

const PUCUUnicodeClassLowerCaseHashMapSeedSize=297;
      PUCUUnicodeClassLowerCaseHashMapValueSize=297;
      PUCUUnicodeClassLowerCaseHashMapSize=297;

      PUCUUnicodeClassLowerCaseHashMapSeedBits=16;

      PUCUUnicodeClassLowerCaseHashMapSeeds:array[0..296] of smallint=(
0,
0,
1,
0,
0,
-297,
0,
-293,
-291,
-287,
1,
0,
0,
-286,
1,
0,
0,
-283,
0,
0,
-280,
0,
0,
0,
-272,
1,
0,
1,
-271,
1,
1,
-268,
0,
1,
-266,
0,
0,
1,
1,
3,
-262,
-259,
0,
0,
0,
-257,
0,
1,
1,
3,
-251,
0,
-248,
1,
-244,
0,
-234,
0,
0,
0,
-231,
2,
-227,
1,
0,
-224,
1,
-222,
2,
0,
1,
3,
-221,
1,
0,
-218,
3,
4,
0,
-213,
1,
-212,
0,
-211,
-210,
0,
1,
0,
0,
-204,
-203,
-189,
1,
-186,
-185,
1,
0,
3,
-184,
9,
0,
-181,
-178,
0,
-176,
1,
1,
-175,
-171,
-169,
1,
2,
0,
0,
-166,
0,
-165,
0,
4,
-164,
0,
2,
-162,
-158,
-156,
0,
0,
0,
1,
-147,
0,
0,
0,
0,
0,
0,
4,
0,
0,
-146,
0,
-145,
-144,
0,
4,
1,
0,
0,
-139,
0,
0,
1,
-137,
-132,
-130,
0,
-128,
0,
0,
1,
-126,
7,
0,
1,
1,
0,
0,
-124,
1,
-123,
0,
0,
-122,
5,
-118,
0,
-116,
1,
-115,
0,
0,
4,
0,
-112,
-107,
0,
-105,
-104,
-101,
2,
0,
-100,
-97,
0,
-96,
0,
-94,
-87,
0,
0,
-83,
-78,
5,
1,
0,
2,
1,
13,
0,
1,
-76,
-73,
2,
0,
0,
1,
-72,
2,
4,
-63,
1,
-61,
-60,
4,
1,
7,
0,
-58,
1,
6,
8,
2,
-57,
-56,
-54,
-48,
5,
0,
-44,
-40,
-36,
6,
2,
-35,
0,
0,
-30,
1,
-29,
13,
-24,
0,
4,
0,
2,
0,
2,
0,
11,
5,
0,
0,
-23,
-22,
4,
0,
8,
3,
0,
0,
-19,
0,
-16,
0,
-13,
0,
0,
0,
0,
-11,
0,
0,
0,
2,
-9,
19,
-6,
0,
0,
-2,
7,
0,
0,
7,
2,
-1,
10
);

      PUCUUnicodeClassLowerCaseHashMapKeys:array[0..296] of TPUCURawByteString=(
'islowercase_letter',
'inlowercase_letter',
'innumber',
'inp',
'inclosepunctuation',
'istitlecase_letter',
'inpo',
'so',
'inother_number',
'intitlecaseletter',
'ismodifier_symbol',
'currency_symbol',
'currencysymbol',
'uppercaseletter',
'isnon_spacing_mark',
'othernumber',
'iscurrency_symbol',
'unassigned',
'isnl',
'inmark',
'openpunctuation',
'inseperator',
'isnd',
'isopenpunctuation',
'insymbol',
'inmodifier_symbol',
'line_separator',
'isz',
'isco',
'pc',
'enclosing_mark',
'ininitial_punctuation',
'isnonspacingmark',
'isletter_number',
'pf',
'pe',
'ismathsymbol',
'isother',
'ismark',
'iscf',
'isdash_punctuation',
'inzs',
'isnumber',
'format',
'isother_number',
'initialpunctuation',
'inother_punctuation',
'inenclosingmark',
'isenclosingmark',
'ispc',
'inparagraph_separator',
'titlecase_letter',
'incurrency_symbol',
'po',
'inlm',
'innd',
'symbol',
'inletter_number',
'inpunctuation',
'decimaldigitnumber',
'co',
'inother',
'inzp',
'dashpunctuation',
'indecimal_digit_number',
'inc',
'space_separator',
'inletternumber',
'issm',
'intitlecase_letter',
'issc',
'isenclosing_mark',
'inso',
'inconnectorpunctuation',
'inl',
'ispd',
'isno',
'cs',
'punctuation',
'othersymbol',
'ps',
'nonspacingmark',
'isline_separator',
'inps',
'isinitial_punctuation',
'isother_symbol',
'ispi',
'informat',
'inz',
'issymbol',
'ispunctuation',
'zl',
'ispf',
'isparagraphseparator',
'zs',
'iszp',
'inprivateuse',
'inspace_separator',
'other',
'iszs',
'inothersymbol',
'inpe',
'inpf',
'isothersymbol',
'surrogate',
'uppercase_letter',
'modifier_letter',
'ismath_symbol',
'spacingcombiningmark',
'modifier_symbol',
'isunassigned',
'isother_letter',
'incs',
'isspacingcombiningmark',
'isopen_punctuation',
'dash_punctuation',
'ismodifiersymbol',
'seperator',
'modifiersymbol',
'issurrogate',
'inmodifierletter',
'infinal_punctuation',
'decimal_digit_number',
'inprivate_use',
'inco',
'inll',
'inspacing_combining_mark',
'inother_symbol',
'inopenpunctuation',
'isuppercaseletter',
'insurrogate',
'inlu',
'isspacing_combining_mark',
'incf',
'infinalpunctuation',
'indashpunctuation',
'inlt',
'initial_punctuation',
'isconnector_punctuation',
'inspacingcombiningmark',
'pd',
'ismodifier_letter',
'inparagraphseparator',
'inmn',
'finalpunctuation',
'private_use',
'iscurrencysymbol',
'inotherpunctuation',
'indash_punctuation',
'iscn',
'modifierletter',
'other_punctuation',
'ismc',
'incc',
'inlowercaseletter',
'inclose_punctuation',
'isme',
'isso',
'titlecaseletter',
'paragraph_separator',
'isparagraph_separator',
'isspace_separator',
'otherpunctuation',
'issk',
'otherletter',
'close_punctuation',
's',
'inmathsymbol',
'mathsymbol',
'other_letter',
'inn',
'inothernumber',
'inlo',
'iszl',
'inm',
'inpd',
'islt',
'zp',
'istitlecaseletter',
'isdecimaldigitnumber',
'inpi',
'letter_number',
'c',
'math_symbol',
'incurrencysymbol',
'privateuse',
'nd',
'insk',
'lt',
'insm',
'inspaceseparator',
'isother_punctuation',
'iscc',
'isinitialpunctuation',
'nl',
'ininitialpunctuation',
'm',
'ismn',
'iscs',
'islm',
'isc',
'isps',
'lu',
'mn',
'final_punctuation',
'isn',
'iscontrol',
'isl',
'inlineseparator',
'me',
'lowercaseletter',
'incn',
'inopen_punctuation',
'spaceseparator',
'isseperator',
'spacing_combining_mark',
'iss',
'isfinal_punctuation',
'lo',
'isp',
'islo',
'll',
'isprivate_use',
'non_spacing_mark',
'ispe',
'ins',
'islu',
'lowercase_letter',
'isothernumber',
'inuppercase_letter',
'isconnectorpunctuation',
'isspaceseparator',
'open_punctuation',
'isotherletter',
'ispo',
'cn',
'inmodifier_letter',
'letternumber',
'lineseparator',
'inmath_symbol',
'isprivateuse',
'isotherpunctuation',
'isll',
'l',
'innl',
'closepunctuation',
'other_symbol',
'n',
'inotherletter',
'inme',
'p',
'inmc',
'inzl',
'isletternumber',
'incontrol',
'isformat',
'sc',
'inpc',
'indecimaldigitnumber',
'pi',
'sk',
'z',
'sm',
'enclosingmark',
'connectorpunctuation',
'innonspacingmark',
'isdecimal_digit_number',
'innon_spacing_mark',
'other_number',
'cf',
'ism',
'inuppercaseletter',
'cc',
'inother_letter',
'inno',
'number',
'insc',
'inunassigned',
'mc',
'islineseparator',
'isclose_punctuation',
'control',
'connector_punctuation',
'paragraphseparator',
'inmodifiersymbol',
'inenclosing_mark',
'mark',
'islowercaseletter',
'isfinalpunctuation',
'inline_separator',
'isuppercase_letter',
'lm',
'no',
'isclosepunctuation',
'inconnector_punctuation',
'isdashpunctuation',
'ismodifierletter'
);

      PUCUUnicodeClassLowerCaseHashMapValueBits=32;

      PUCUUnicodeClassLowerCaseHashMapValues:array[0..296] of longword=(
4,
4,
3584,
821559296,
2097152,
8,
8388608,
134217728,
2048,
8,
67108864,
33554432,
33554432,
2,
64,
2048,
33554432,
1,
1024,
448,
1048576,
28672,
512,
1048576,
251658240,
67108864,
8192,
28672,
131072,
4194304,
128,
268435456,
64,
1024,
536870912,
2097152,
16777216,
491521,
448,
65536,
524288,
4096,
3584,
32768,
2048,
268435456,
8388608,
128,
128,
4194304,
16384,
8,
33554432,
8388608,
16,
512,
251658240,
1024,
821559296,
512,
131072,
491521,
16384,
524288,
512,
491521,
4096,
1024,
16777216,
8,
33554432,
128,
134217728,
4194304,
62,
524288,
2048,
262144,
821559296,
134217728,
1048576,
64,
8192,
1048576,
268435456,
134217728,
268435456,
32768,
28672,
251658240,
821559296,
8192,
536870912,
16384,
4096,
16384,
131072,
4096,
491521,
4096,
134217728,
2097152,
536870912,
134217728,
262144,
2,
16,
16777216,
256,
67108864,
1,
32,
262144,
256,
1048576,
524288,
67108864,
28672,
67108864,
262144,
16,
536870912,
512,
131072,
131072,
4,
256,
134217728,
1048576,
2,
262144,
2,
256,
65536,
536870912,
524288,
8,
268435456,
4194304,
256,
524288,
16,
16384,
64,
536870912,
131072,
33554432,
8388608,
524288,
1,
16,
8388608,
256,
32768,
4,
2097152,
128,
134217728,
8,
16384,
16384,
4096,
8388608,
67108864,
32,
2097152,
251658240,
16777216,
16777216,
32,
3584,
2048,
32,
8192,
448,
524288,
8,
16384,
8,
512,
268435456,
1024,
491521,
16777216,
33554432,
131072,
512,
67108864,
8,
16777216,
4096,
8388608,
32768,
268435456,
1024,
268435456,
448,
64,
262144,
16,
491521,
1048576,
2,
64,
536870912,
3584,
32768,
62,
8192,
128,
4,
1,
1048576,
4096,
28672,
256,
251658240,
536870912,
32,
821559296,
32,
4,
131072,
64,
2097152,
251658240,
2,
4,
2048,
2,
4194304,
4096,
1048576,
32,
8388608,
1,
16,
1024,
8192,
16777216,
131072,
8388608,
4,
62,
1024,
2097152,
134217728,
3584,
32,
128,
821559296,
256,
8192,
1024,
32768,
32768,
33554432,
4194304,
512,
268435456,
67108864,
28672,
16777216,
128,
4194304,
64,
512,
64,
2048,
65536,
448,
2,
32768,
32,
2048,
3584,
33554432,
1,
256,
8192,
2097152,
32768,
4194304,
16384,
67108864,
128,
448,
4,
536870912,
8192,
2,
16,
2048,
2097152,
4194304,
524288,
16
);

const PUCUUnicodeScriptLowerCaseHashMapSeedSize=513;
      PUCUUnicodeScriptLowerCaseHashMapValueSize=513;
      PUCUUnicodeScriptLowerCaseHashMapSize=513;

      PUCUUnicodeScriptLowerCaseHashMapSeedBits=16;

      PUCUUnicodeScriptLowerCaseHashMapSeeds:array[0..512] of smallint=(
-513,
0,
-511,
1,
0,
1,
2,
-510,
0,
0,
0,
0,
1,
1,
0,
0,
0,
-505,
-504,
1,
1,
1,
0,
0,
-503,
0,
0,
-501,
-498,
0,
0,
0,
2,
0,
1,
0,
0,
0,
0,
-497,
1,
-495,
-494,
-493,
-487,
-485,
-481,
0,
0,
-478,
-475,
-474,
-473,
1,
1,
4,
0,
-468,
1,
0,
1,
-466,
-461,
0,
1,
0,
4,
0,
-456,
0,
3,
0,
0,
-455,
1,
-454,
-451,
1,
-445,
4,
0,
0,
-442,
-441,
7,
-439,
0,
-436,
-435,
2,
0,
8,
2,
0,
0,
0,
2,
-434,
-431,
-430,
0,
3,
-429,
0,
-427,
-426,
0,
0,
-425,
0,
1,
1,
-424,
-423,
0,
0,
1,
-422,
-421,
1,
0,
0,
0,
1,
-417,
2,
-415,
-410,
1,
-407,
-404,
-399,
4,
-396,
-393,
0,
-390,
0,
-384,
1,
0,
-381,
0,
0,
2,
-377,
-374,
0,
-370,
1,
-368,
1,
-365,
-361,
0,
-356,
0,
2,
-354,
-353,
-352,
0,
-351,
2,
-350,
-346,
-345,
1,
-343,
-342,
0,
0,
0,
-338,
0,
0,
-337,
-335,
-334,
-331,
0,
1,
-329,
-325,
1,
0,
0,
-321,
0,
-319,
0,
6,
3,
4,
-317,
-309,
-307,
1,
0,
2,
2,
-305,
0,
1,
0,
5,
-302,
0,
-299,
-297,
4,
0,
0,
0,
1,
0,
-295,
0,
-292,
-290,
0,
-289,
0,
0,
1,
-288,
-285,
-283,
-282,
0,
-280,
1,
-279,
-278,
-277,
-274,
-273,
-272,
-268,
2,
-265,
-263,
0,
0,
4,
0,
0,
0,
0,
0,
-262,
3,
0,
-261,
-257,
0,
1,
-255,
4,
1,
-253,
-250,
2,
0,
-247,
0,
4,
1,
0,
2,
-244,
0,
0,
1,
0,
-241,
3,
-236,
2,
-233,
0,
4,
-232,
-226,
-225,
7,
-216,
-209,
0,
0,
-207,
-204,
0,
-198,
1,
2,
2,
0,
-197,
-196,
0,
1,
7,
1,
-195,
-192,
3,
-189,
-188,
0,
-187,
0,
1,
-180,
-175,
0,
-174,
0,
0,
1,
-172,
-170,
1,
0,
6,
0,
5,
0,
-168,
0,
0,
2,
-167,
-165,
0,
6,
0,
-163,
0,
-162,
2,
0,
0,
0,
1,
3,
0,
0,
0,
1,
-153,
0,
0,
1,
0,
-152,
0,
0,
0,
2,
0,
0,
0,
-145,
0,
-144,
-143,
-141,
0,
-140,
0,
0,
-139,
1,
-137,
-136,
0,
-133,
-132,
-129,
-127,
0,
-126,
3,
-123,
-122,
-121,
0,
-117,
0,
0,
-109,
0,
0,
0,
3,
1,
-106,
0,
0,
-105,
-102,
0,
-98,
1,
-96,
-94,
2,
3,
0,
-92,
-90,
-89,
0,
5,
0,
0,
0,
0,
4,
0,
-87,
0,
8,
-85,
7,
0,
6,
2,
-82,
4,
-80,
2,
0,
1,
0,
1,
1,
-79,
-74,
0,
-72,
-70,
2,
7,
-67,
0,
5,
0,
-66,
-65,
0,
5,
-62,
-59,
0,
1,
6,
1,
-58,
-56,
1,
0,
0,
0,
-53,
-48,
-47,
0,
0,
-42,
2,
0,
0,
-41,
-40,
13,
0,
-36,
-34,
-33,
-32,
1,
3,
0,
9,
4,
-31,
-30,
1,
1,
-29,
3,
4,
-23,
-21,
0,
-20,
4,
0,
-12,
-11,
0,
2,
1,
0,
-8,
2,
-7,
0,
-5,
-4,
0
);

      PUCUUnicodeScriptLowerCaseHashMapKeys:array[0..512] of TPUCURawByteString=(
'issiddham',
'imperial_aramaic',
'meetei_mayek',
'inegyptian_hieroglyphs',
'inpahawhhmong',
'inpsalterpahlavi',
'intangut',
'vai',
'phagspa',
'inbhaiksuki',
'inethiopic',
'isosmanya',
'tangut',
'isbhaiksuki',
'gothic',
'georgian',
'intamil',
'bassavah',
'innewtailue',
'isanatolian_hieroglyphs',
'lydian',
'ishan',
'isphagspa',
'iscarian',
'inphags_pa',
'istibetan',
'isdevanagari',
'ugaritic',
'cuneiform',
'malayalam',
'old_italic',
'ismro',
'tamil',
'inchakma',
'old_north_arabian',
'intirhuta',
'isoldpermic',
'old_turkic',
'isold_south_arabian',
'ismandaic',
'isoldsoutharabian',
'isethiopic',
'khudawadi',
'ingeorgian',
'inwarang_citi',
'hatran',
'incoptic',
'insignwriting',
'incommon',
'insyloti_nagri',
'isphoenician',
'inphagspa',
'issyriac',
'isrunic',
'isoldnortharabian',
'islinear_b',
'chakma',
'ishanunoo',
'inoldturkic',
'ischam',
'inmarchen',
'caucasian_albanian',
'mro',
'iskannada',
'inkhmer',
'mongolian',
'isdeseret',
'osmanya',
'istai_tham',
'latin',
'incanadianaboriginal',
'isavestan',
'isolchiki',
'isold_north_arabian',
'incham',
'inimperial_aramaic',
'ismeroitic_hieroglyphs',
'islatin',
'inlimbu',
'olditalic',
'modi',
'mahajani',
'istangut',
'hebrew',
'isbopomofo',
'istifinagh',
'inhiragana',
'bamum',
'inrunic',
'intai_tham',
'incaucasian_albanian',
'inkaithi',
'inshavian',
'inmeroitichieroglyphs',
'inarmenian',
'islisu',
'tagbanwa',
'ispsalterpahlavi',
'inscriptional_pahlavi',
'isbamum',
'inbuhid',
'isoldhungarian',
'iskatakana',
'balinese',
'inlinearb',
'inlineara',
'lineara',
'inbalinese',
'isnewtailue',
'ishangul',
'islinearb',
'issora_sompeng',
'isold_hungarian',
'devanagari',
'incherokee',
'ingothic',
'iskaithi',
'paucinhau',
'siddham',
'isbengali',
'avestan',
'inherited',
'inmeeteimayek',
'insaurashtra',
'iscoptic',
'islydian',
'hiragana',
'meroiticcursive',
'inbrahmi',
'isinscriptional_pahlavi',
'iscypriot',
'sharada',
'mende_kikakui',
'isogham',
'isnewa',
'iscommon',
'ininscriptionalparthian',
'kayahli',
'inscriptionalpahlavi',
'meroitic_cursive',
'isjavanese',
'isthaana',
'inoldnortharabian',
'iscanadian_aboriginal',
'istelugu',
'insora_sompeng',
'oldhungarian',
'inold_south_arabian',
'khmer',
'psalterpahlavi',
'inol_chiki',
'grantha',
'incyrillic',
'inanatolianhieroglyphs',
'ininscriptionalpahlavi',
'ispau_cin_hau',
'nko',
'signwriting',
'isgreek',
'ishatran',
'insylotinagri',
'incuneiform',
'isnew_tai_lue',
'hanunoo',
'issharada',
'oldpersian',
'oldnortharabian',
'sylotinagri',
'brahmi',
'inbraille',
'hangul',
'meroitichieroglyphs',
'newtailue',
'phags_pa',
'inlao',
'bopomofo',
'new_tai_lue',
'inahom',
'linearb',
'inbassa_vah',
'syloti_nagri',
'islimbu',
'isbalinese',
'isbraille',
'innabataean',
'inkharoshthi',
'ismeroitic_cursive',
'isnko',
'intai_viet',
'inmeetei_mayek',
'iscaucasianalbanian',
'sinhala',
'elbasan',
'inhangul',
'innew_tai_lue',
'isimperialaramaic',
'inhebrew',
'imperialaramaic',
'gurmukhi',
'phoenician',
'ininherited',
'ispahawhhmong',
'isglagolitic',
'istai_le',
'isgothic',
'inmeroitic_cursive',
'tibetan',
'intagbanwa',
'ispahawh_hmong',
'inlinear_b',
'inavestan',
'psalter_pahlavi',
'inlinear_a',
'inmultani',
'inolchiki',
'bassa_vah',
'lepcha',
'bengali',
'inoldpermic',
'inwarangciti',
'coptic',
'ismeetei_mayek',
'batak',
'intifinagh',
'katakana',
'isarabic',
'ininscriptional_parthian',
'ismodi',
'ischakma',
'inpau_cin_hau',
'islineara',
'khojki',
'inmandaic',
'isadlam',
'inkayahli',
'myanmar',
'intai_le',
'kaithi',
'ingujarati',
'inmendekikakui',
'oldturkic',
'istai_viet',
'tirhuta',
'warangciti',
'armenian',
'braille',
'inthai',
'insharada',
'canadian_aboriginal',
'islepcha',
'buhid',
'old_persian',
'ingrantha',
'glagolitic',
'canadianaboriginal',
'inegyptianhieroglyphs',
'inmro',
'telugu',
'limbu',
'gujarati',
'iskhojki',
'adlam',
'ismarchen',
'palmyrene',
'inhanunoo',
'incarian',
'ishebrew',
'inmahajani',
'inold_permic',
'istaitham',
'oriya',
'inkannada',
'inoldsoutharabian',
'issaurashtra',
'ispalmyrene',
'nabataean',
'inyi',
'inlisu',
'isgurmukhi',
'meeteimayek',
'inmeroitic_hieroglyphs',
'isyi',
'inold_north_arabian',
'oldpermic',
'han',
'taiviet',
'ismende_kikakui',
'inscriptional_parthian',
'istaiviet',
'ismendekikakui',
'inmyanmar',
'isgeorgian',
'saurashtra',
'deseret',
'iswarang_citi',
'oldsoutharabian',
'islao',
'ahom',
'ismeeteimayek',
'intelugu',
'carian',
'inmalayalam',
'caucasianalbanian',
'runic',
'lisu',
'taile',
'javanese',
'tifinagh',
'intaiviet',
'marchen',
'inold_hungarian',
'bhaiksuki',
'kayah_li',
'intakri',
'inbamum',
'inlycian',
'inold_turkic',
'inpsalter_pahlavi',
'inold_italic',
'pahawhhmong',
'ethiopic',
'inthaana',
'ogham',
'ismahajani',
'inhan',
'tai_viet',
'injavanese',
'insyriac',
'isoldturkic',
'inadlam',
'ingurmukhi',
'iskhudawadi',
'inlepcha',
'isold_persian',
'ischerokee',
'pau_cin_hau',
'innewa',
'insamaritan',
'iskhmer',
'iskayahli',
'ismeroitichieroglyphs',
'isold_turkic',
'isarmenian',
'lao',
'intibetan',
'miao',
'isinscriptionalparthian',
'incanadian_aboriginal',
'inbatak',
'tagalog',
'common',
'lycian',
'insundanese',
'warang_citi',
'samaritan',
'inoldhungarian',
'duployan',
'isinscriptional_parthian',
'taitham',
'sora_sompeng',
'ingreek',
'thaana',
'isanatolianhieroglyphs',
'ismongolian',
'takri',
'issamaritan',
'iskharoshthi',
'istamil',
'pahawh_hmong',
'isegyptian_hieroglyphs',
'shavian',
'ispsalter_pahlavi',
'inbengali',
'ismeroiticcursive',
'inoldpersian',
'old_hungarian',
'isoriya',
'inscriptionalparthian',
'egyptian_hieroglyphs',
'inkhudawadi',
'inimperialaramaic',
'buginese',
'old_permic',
'yi',
'kharoshthi',
'isinscriptionalpahlavi',
'insinhala',
'induployan',
'istagalog',
'cypriot',
'sorasompeng',
'isgujarati',
'inugaritic',
'inarabic',
'intagalog',
'rejang',
'inmiao',
'indevanagari',
'multani',
'newa',
'isphags_pa',
'inolditalic',
'old_south_arabian',
'istagbanwa',
'isinherited',
'invai',
'istakri',
'isugaritic',
'isshavian',
'inkatakana',
'inosmanya',
'iselbasan',
'inkayah_li',
'insiddham',
'iscanadianaboriginal',
'isold_italic',
'isold_permic',
'isbuhid',
'cham',
'inogham',
'linear_a',
'linear_b',
'inphoenician',
'ishiragana',
'isbatak',
'inosage',
'isimperial_aramaic',
'osage',
'inmodi',
'inold_persian',
'incaucasianalbanian',
'ol_chiki',
'iscuneiform',
'inanatolian_hieroglyphs',
'intaile',
'indeseret',
'issignwriting',
'mendekikakui',
'iscaucasian_albanian',
'isnabataean',
'inpahawh_hmong',
'isthai',
'iscyrillic',
'isbassa_vah',
'inmongolian',
'meroitic_hieroglyphs',
'isolditalic',
'inrejang',
'ismultani',
'ismalayalam',
'ispaucinhau',
'iskayah_li',
'cherokee',
'sundanese',
'ismiao',
'isosage',
'tai_tham',
'isgrantha',
'inmeroiticcursive',
'ininscriptional_pahlavi',
'isrejang',
'istirhuta',
'mandaic',
'isegyptianhieroglyphs',
'inbuginese',
'innko',
'isoldpersian',
'thai',
'anatolianhieroglyphs',
'isol_chiki',
'inmende_kikakui',
'inmanichaean',
'issinhala',
'inlydian',
'inpalmyrene',
'isvai',
'inelbasan',
'olchiki',
'islinear_a',
'inoriya',
'isbassavah',
'insorasompeng',
'isahom',
'tai_le',
'inpaucinhau',
'inbopomofo',
'egyptianhieroglyphs',
'issorasompeng',
'issylotinagri',
'syriac',
'issyloti_nagri',
'arabic',
'isbrahmi',
'intaitham',
'greek',
'isbuginese',
'inbassavah',
'inglagolitic',
'isduployan',
'inkhojki',
'inhatran',
'ismyanmar',
'kannada',
'iswarangciti',
'inlatin',
'manichaean',
'islycian',
'istaile',
'incypriot',
'anatolian_hieroglyphs',
'ismanichaean',
'issundanese',
'cyrillic'
);

      PUCUUnicodeScriptLowerCaseHashMapValueBits=8;

      PUCUUnicodeScriptLowerCaseHashMapValues:array[0..512] of byte=(
122,
87,
86,
81,
108,
121,
137,
70,
65,
133,
26,
51,
137,
133,
39,
24,
15,
104,
56,
127,
76,
36,
65,
75,
65,
22,
10,
49,
63,
18,
38,
115,
15,
96,
116,
124,
120,
91,
88,
95,
88,
26,
123,
24,
125,
128,
55,
131,
1,
59,
64,
65,
8,
30,
116,
48,
96,
43,
91,
77,
134,
103,
115,
17,
31,
32,
40,
51,
78,
2,
28,
80,
69,
116,
77,
87,
98,
2,
46,
38,
114,
111,
137,
6,
35,
58,
33,
84,
30,
78,
103,
92,
50,
98,
5,
83,
45,
121,
90,
84,
44,
130,
34,
62,
48,
110,
110,
62,
56,
25,
48,
101,
130,
10,
27,
39,
92,
119,
122,
11,
80,
41,
86,
71,
55,
76,
33,
97,
94,
90,
52,
100,
113,
29,
135,
1,
89,
72,
90,
97,
85,
9,
116,
28,
16,
101,
130,
88,
31,
121,
69,
107,
4,
127,
90,
119,
66,
131,
3,
128,
59,
63,
56,
43,
100,
60,
116,
59,
94,
53,
25,
98,
56,
65,
21,
35,
56,
126,
48,
104,
59,
46,
62,
53,
117,
61,
97,
66,
79,
86,
103,
19,
106,
25,
56,
87,
6,
87,
12,
64,
41,
108,
57,
47,
39,
97,
22,
45,
108,
48,
80,
121,
110,
129,
69,
104,
68,
11,
120,
125,
55,
86,
93,
58,
34,
7,
89,
114,
96,
119,
110,
109,
95,
132,
72,
23,
47,
92,
13,
113,
91,
79,
124,
125,
5,
53,
20,
100,
28,
68,
44,
60,
107,
57,
28,
81,
115,
16,
46,
13,
109,
132,
134,
118,
43,
75,
6,
111,
120,
78,
14,
17,
88,
71,
118,
117,
37,
83,
12,
86,
98,
37,
116,
120,
36,
79,
113,
89,
79,
113,
23,
24,
71,
40,
125,
88,
21,
126,
86,
16,
75,
18,
103,
30,
83,
47,
85,
58,
79,
134,
130,
133,
72,
102,
84,
74,
91,
121,
38,
108,
26,
9,
29,
111,
36,
79,
85,
8,
91,
132,
12,
123,
68,
60,
27,
119,
135,
82,
31,
72,
98,
91,
5,
21,
22,
99,
89,
28,
93,
42,
1,
74,
67,
125,
82,
130,
105,
89,
78,
101,
3,
9,
127,
32,
102,
82,
61,
15,
108,
81,
50,
121,
11,
97,
60,
130,
14,
89,
81,
123,
87,
54,
120,
37,
61,
90,
19,
105,
42,
52,
101,
13,
49,
7,
42,
73,
99,
10,
129,
135,
65,
38,
88,
45,
41,
70,
102,
49,
50,
34,
51,
106,
72,
122,
28,
38,
120,
44,
77,
29,
110,
48,
64,
33,
93,
136,
87,
136,
114,
60,
103,
69,
63,
127,
47,
40,
131,
113,
103,
117,
108,
20,
4,
104,
32,
98,
38,
73,
129,
18,
119,
72,
27,
67,
99,
136,
78,
107,
97,
90,
73,
124,
95,
81,
54,
66,
60,
20,
127,
69,
113,
112,
19,
76,
118,
70,
106,
69,
110,
14,
104,
101,
126,
47,
119,
35,
81,
101,
59,
8,
59,
7,
94,
78,
3,
54,
104,
57,
105,
109,
128,
23,
17,
125,
2,
112,
74,
47,
52,
127,
112,
67,
4
);

const PUCUUnicodeBlockLowerCaseHashMapSeedSize=1338;
      PUCUUnicodeBlockLowerCaseHashMapValueSize=1338;
      PUCUUnicodeBlockLowerCaseHashMapSize=1338;

      PUCUUnicodeBlockLowerCaseHashMapSeedBits=16;

      PUCUUnicodeBlockLowerCaseHashMapSeeds:array[0..1337] of smallint=(
3,
-1337,
1,
0,
-1336,
3,
0,
0,
0,
0,
0,
-1328,
0,
0,
0,
-1323,
0,
0,
0,
0,
0,
0,
-1320,
2,
0,
-1318,
0,
1,
0,
-1312,
0,
-1300,
0,
0,
-1296,
1,
-1295,
1,
0,
-1293,
-1290,
-1289,
0,
0,
3,
-1288,
-1285,
-1284,
-1279,
-1277,
1,
-1276,
1,
1,
-1275,
-1271,
-1269,
0,
0,
-1268,
0,
1,
-1267,
0,
-1263,
0,
0,
0,
-1257,
-1256,
-1252,
0,
-1249,
-1243,
1,
-1242,
1,
-1241,
0,
-1240,
0,
0,
0,
1,
0,
0,
0,
-1233,
-1232,
1,
1,
-1231,
1,
0,
0,
-1229,
1,
-1227,
-1222,
-1220,
0,
1,
-1219,
0,
0,
-1217,
1,
0,
-1214,
0,
-1213,
-1209,
2,
2,
3,
0,
0,
0,
-1208,
0,
5,
-1207,
3,
1,
2,
0,
-1206,
-1203,
1,
3,
-1199,
-1196,
-1195,
1,
-1193,
0,
0,
0,
-1187,
0,
3,
-1186,
0,
-1185,
1,
0,
-1182,
-1180,
-1178,
-1177,
0,
0,
-1175,
0,
0,
0,
-1174,
-1170,
1,
-1164,
1,
1,
-1162,
1,
-1161,
-1159,
-1154,
-1153,
0,
0,
-1151,
0,
-1141,
2,
-1135,
0,
0,
2,
0,
-1134,
-1131,
0,
-1128,
2,
0,
0,
0,
-1127,
0,
0,
-1124,
-1123,
-1121,
0,
0,
2,
0,
-1117,
2,
-1116,
1,
5,
0,
0,
0,
-1105,
0,
0,
-1103,
2,
-1100,
2,
0,
0,
3,
2,
-1098,
-1094,
-1093,
2,
-1091,
0,
0,
0,
0,
0,
-1090,
-1087,
1,
-1083,
3,
1,
-1081,
-1080,
0,
0,
-1079,
0,
-1078,
0,
1,
0,
1,
0,
0,
1,
-1073,
-1072,
1,
1,
0,
0,
0,
0,
2,
0,
-1070,
-1068,
0,
0,
3,
-1062,
-1060,
1,
0,
0,
0,
-1054,
0,
-1051,
-1047,
-1046,
-1045,
0,
0,
-1044,
0,
1,
-1037,
1,
3,
0,
6,
0,
0,
0,
-1036,
0,
0,
0,
1,
1,
-1029,
0,
0,
-1027,
-1025,
-1023,
1,
-1015,
0,
1,
-1014,
0,
-1013,
-1011,
0,
0,
0,
2,
-1009,
-1006,
-1005,
-1003,
-1002,
-1001,
-994,
-991,
-984,
0,
-983,
0,
-982,
-979,
0,
1,
-978,
2,
1,
-977,
0,
0,
-966,
0,
1,
1,
-964,
-962,
2,
0,
1,
-960,
-959,
1,
-952,
-951,
-949,
-948,
-942,
2,
0,
3,
-941,
0,
-936,
0,
0,
0,
0,
1,
2,
1,
1,
2,
-935,
-934,
1,
-933,
-929,
1,
1,
-926,
-919,
0,
-916,
2,
-913,
-912,
0,
2,
-911,
0,
1,
1,
0,
2,
0,
0,
0,
1,
-910,
0,
0,
-908,
-906,
2,
-892,
0,
0,
1,
-891,
-883,
1,
0,
2,
-881,
0,
1,
0,
2,
0,
5,
-878,
-876,
0,
-874,
-872,
1,
0,
0,
0,
-871,
-869,
0,
5,
-864,
-863,
0,
-862,
-855,
0,
0,
0,
0,
-854,
0,
-851,
-849,
0,
2,
0,
0,
0,
2,
-847,
1,
1,
-845,
0,
-841,
1,
0,
-837,
1,
1,
0,
5,
0,
2,
-836,
-829,
0,
1,
0,
-828,
0,
-824,
1,
-821,
-816,
-812,
0,
-810,
5,
1,
-809,
1,
-808,
2,
1,
-804,
0,
0,
0,
0,
3,
-802,
3,
0,
-801,
6,
1,
1,
-799,
-798,
3,
0,
-796,
0,
-795,
0,
-793,
0,
-791,
2,
-789,
1,
0,
0,
-788,
1,
0,
0,
0,
0,
0,
5,
-785,
0,
1,
-776,
0,
0,
1,
0,
1,
0,
0,
0,
-771,
-770,
-765,
0,
4,
-764,
3,
0,
0,
0,
0,
0,
-763,
0,
0,
1,
-762,
0,
-760,
0,
0,
1,
0,
2,
3,
1,
-755,
2,
-754,
-752,
-749,
3,
-748,
1,
0,
0,
1,
-747,
3,
0,
-746,
0,
-744,
-742,
4,
0,
4,
-739,
-737,
-726,
-722,
0,
0,
2,
2,
0,
-720,
0,
1,
1,
-710,
-705,
0,
0,
0,
1,
0,
-703,
-702,
-698,
0,
-697,
0,
0,
-692,
-690,
-689,
-686,
-685,
-684,
-680,
2,
-675,
0,
0,
0,
0,
0,
0,
1,
0,
-672,
0,
1,
-671,
-669,
2,
-668,
-665,
-664,
0,
3,
-663,
-660,
2,
0,
1,
0,
2,
0,
0,
0,
0,
8,
0,
-658,
3,
0,
0,
-655,
0,
0,
-653,
1,
3,
-651,
2,
-647,
-644,
-641,
-637,
0,
1,
0,
0,
-636,
-634,
0,
0,
-632,
0,
-630,
-623,
2,
0,
1,
0,
0,
1,
11,
0,
-618,
-617,
2,
-616,
1,
-613,
2,
3,
0,
1,
0,
-609,
2,
1,
2,
-608,
1,
0,
-607,
2,
0,
-606,
-604,
0,
1,
0,
0,
-602,
3,
-598,
-597,
1,
0,
0,
-596,
-591,
-589,
0,
-588,
6,
3,
2,
0,
0,
1,
-585,
-584,
3,
0,
4,
-583,
1,
0,
0,
0,
-578,
2,
1,
0,
0,
-575,
0,
0,
0,
-570,
0,
-569,
3,
2,
0,
-568,
0,
2,
0,
3,
0,
1,
0,
2,
-567,
0,
-565,
0,
-564,
1,
1,
2,
0,
0,
-563,
-562,
-561,
-560,
-559,
-557,
-555,
-551,
0,
0,
0,
0,
-546,
5,
0,
0,
-544,
-543,
1,
0,
0,
1,
1,
0,
0,
0,
-534,
0,
-533,
5,
-532,
0,
3,
-531,
0,
1,
-530,
-528,
-523,
2,
-519,
0,
2,
3,
-514,
0,
-512,
1,
-509,
0,
-505,
6,
2,
-502,
6,
1,
1,
2,
-496,
3,
-485,
0,
18,
-475,
0,
-473,
-472,
0,
3,
0,
-469,
-468,
-467,
0,
0,
2,
-465,
-462,
0,
0,
3,
-459,
-454,
0,
13,
4,
8,
6,
4,
0,
0,
0,
0,
-453,
1,
3,
-450,
0,
4,
0,
0,
-439,
0,
0,
0,
1,
-437,
0,
-434,
-431,
-422,
-421,
-420,
0,
-418,
-415,
0,
6,
5,
7,
2,
9,
1,
0,
-412,
-410,
-408,
-407,
-398,
-396,
0,
0,
0,
-394,
0,
0,
4,
0,
1,
-392,
-388,
0,
0,
8,
4,
10,
-386,
0,
-385,
-382,
0,
0,
-376,
0,
1,
0,
4,
-373,
-367,
0,
2,
-366,
0,
3,
0,
0,
-361,
0,
-360,
5,
0,
0,
0,
-356,
1,
0,
-354,
-351,
1,
0,
1,
-350,
-344,
0,
-343,
-341,
7,
0,
0,
-335,
0,
-334,
0,
-333,
0,
-330,
-324,
0,
-320,
0,
16,
1,
0,
0,
-319,
1,
1,
-318,
-313,
0,
0,
-312,
0,
0,
-311,
0,
0,
-310,
16,
0,
1,
-309,
21,
1,
1,
-308,
1,
7,
-306,
0,
1,
0,
0,
0,
-304,
0,
0,
0,
0,
-300,
5,
0,
0,
1,
-299,
-298,
1,
-296,
0,
-294,
3,
-293,
1,
2,
0,
-291,
0,
-290,
10,
4,
0,
-289,
-286,
-281,
-279,
0,
0,
-278,
-277,
-275,
-274,
0,
0,
0,
-273,
0,
1,
0,
-270,
-268,
-264,
-258,
-255,
-254,
-252,
0,
0,
1,
-251,
-250,
3,
1,
1,
0,
-243,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-238,
0,
6,
-231,
-222,
0,
2,
2,
-221,
-212,
3,
1,
1,
-211,
0,
4,
0,
0,
-210,
0,
0,
5,
0,
2,
0,
-209,
3,
0,
11,
-207,
1,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
4,
0,
0,
0,
0,
0,
-201,
0,
25,
0,
-197,
1,
0,
-196,
0,
-195,
-187,
-186,
-184,
12,
0,
-183,
-182,
0,
-177,
-170,
1,
-169,
0,
0,
0,
6,
-167,
-158,
-156,
-155,
-151,
0,
0,
1,
2,
9,
0,
-150,
0,
0,
-148,
-143,
0,
-141,
-137,
0,
1,
3,
1,
0,
-136,
-134,
0,
2,
-133,
0,
8,
-132,
0,
5,
-128,
-124,
0,
-120,
0,
0,
4,
0,
-118,
-117,
-113,
-109,
0,
-105,
-104,
1,
0,
-101,
0,
7,
1,
-94,
-93,
0,
-92,
1,
-90,
-89,
0,
9,
8,
0,
-84,
-83,
-81,
0,
0,
5,
0,
-78,
-76,
0,
0,
-75,
5,
2,
3,
1,
0,
2,
0,
-74,
1,
0,
-70,
0,
0,
0,
-68,
0,
2,
0,
0,
-66,
0,
0,
0,
0,
-64,
2,
0,
-60,
1,
0,
18,
12,
2,
-59,
-55,
2,
0,
5,
-53,
0,
0,
4,
3,
0,
0,
7,
-50,
0,
-47,
12,
1,
0,
0,
0,
1,
-45,
2,
6,
0,
-44,
3,
-41,
-39,
1,
0,
7,
0,
5,
6,
0,
0,
0,
5,
-37,
11,
-33,
0,
0,
2,
0,
-29,
-28,
-26,
0,
-25,
13,
0,
-24,
2,
0,
-13,
-12,
13,
18,
0,
27,
1,
1,
7,
2,
1,
2,
-9,
-7,
2,
0,
-6,
4,
0,
0,
1,
0,
1,
-1
);

      PUCUUnicodeBlockLowerCaseHashMapKeys:array[0..1337] of TPUCURawByteString=(
'isnko',
'inyi_syllables',
'ismeroitichieroglyphs',
'inlao',
'cjksymbolsandpunctuation',
'iscountingrodnumerals',
'intagalog',
'inmusicalsymbols',
'isenclosed_ideographic_supplement',
'iscjk_radicals_supplement',
'adlam',
'issaurashtra',
'gujarati',
'meroitic_cursive',
'saurashtra',
'inmahjong_tiles',
'isdingbats',
'indeseret',
'arabicpresentationforms-a',
'insinhalaarchaicnumbers',
'inmongolian',
'arabicpresentationforms-b',
'ischerokeesupplement',
'inlydian',
'inlinearbideograms',
'invariationselectorssupplement',
'inimperialaramaic',
'isarabicpresentationforms-b',
'ismiscellaneoustechnical',
'isbox_drawing',
'intai_tham',
'iscombiningdiacriticalmarkssupplement',
'isyijinghexagramsymbols',
'ishighsurrogates',
'iskhmersymbols',
'inhangulsyllables',
'isthai',
'issorasompeng',
'inlatin_extended-c',
'incaucasian_albanian',
'inplayingcards',
'thai',
'ispsalter_pahlavi',
'iskatakana',
'iscypriot_syllabary',
'ingreek_extended',
'greekextended',
'insupplementalarrows-b',
'incyrillicextended-b',
'isjavanese',
'cjkcompatibilityideographs',
'incounting_rod_numerals',
'inhangulcompatibilityjamo',
'insupplementalmathematicaloperators',
'inosmanya',
'isyisyllables',
'inmeetei_mayek_extensions',
'buhid',
'isancientgreeknumbers',
'incombininghalfmarks',
'islatinextendedadditional',
'cjkradicalssupplement',
'inmyanmar',
'arabic_mathematical_alphabetic_symbols',
'palmyrene',
'ismeeteimayek',
'iskatakanaphoneticextensions',
'supplemental_mathematical_operators',
'incjk_unified_ideographs',
'inancientgreekmusicalnotation',
'balinese',
'invertical_forms',
'isgreek_extended',
'early_dynastic_cuneiform',
'inancient_greek_musical_notation',
'ismeetei_mayek',
'vedicextensions',
'phoneticextensions',
'old_north_arabian',
'inenclosed_alphanumeric_supplement',
'inlatin_extended_additional',
'miscellaneoussymbolsandpictographs',
'ishangul_jamo_extended-b',
'isbatak',
'sundanesesupplement',
'inmiscellaneoussymbols',
'ismiscellaneoussymbolsandarrows',
'incombining_marks_for_symbols',
'isbuhid',
'istamil',
'inmathematicaloperators',
'ancient_greek_musical_notation',
'inunified_canadian_aboriginal_syllabics_extended',
'caucasianalbanian',
'indevanagari',
'incommon_indic_number_forms',
'mandaic',
'istagbanwa',
'cypriotsyllabary',
'isgeometric_shapes_extended',
'gurmukhi',
'deseret',
'batak',
'kharoshthi',
'inadlam',
'issyriac',
'miao',
'istaile',
'enclosedcjklettersandmonths',
'ispaucinhau',
'cuneiformnumbersandpunctuation',
'islatin_extended-c',
'issupplemental_arrows-a',
'brahmi',
'invedic_extensions',
'ishalfwidthandfullwidthforms',
'issupplemental_arrows-b',
'issupplemental_arrows-c',
'inprivate_use_area',
'iscjk_unified_ideographs',
'inmandaic',
'supplementaryprivateusearea-b',
'issuperscripts_and_subscripts',
'cjk_compatibility_ideographs',
'inboxdrawing',
'intirhuta',
'mahjongtiles',
'incjk_strokes',
'ishangul_jamo',
'inpsalter_pahlavi',
'tai_le',
'lycian',
'isanatolianhieroglyphs',
'isplaying_cards',
'inarabicextended-a',
'pahawh_hmong',
'isnewa',
'linear_b_ideograms',
'inaegean_numbers',
'highsurrogates',
'hatran',
'mathematicalalphanumericsymbols',
'braillepatterns',
'combining_diacritical_marks_for_symbols',
'enclosedalphanumericsupplement',
'inshorthandformatcontrols',
'inmiscellaneous_mathematical_symbols-a',
'isnabataean',
'istransport_and_map_symbols',
'pau_cin_hau',
'combiningdiacriticalmarksforsymbols',
'hangul_compatibility_jamo',
'isdevanagariextended',
'latinextendedadditional',
'incjk_compatibility',
'ipa_extensions',
'inimperial_aramaic',
'inideographicsymbolsandpunctuation',
'iscjk_compatibility_ideographs',
'isgothic',
'isimperialaramaic',
'oldhungarian',
'incombining_diacritical_marks_supplement',
'inbrahmi',
'islatinextended-e',
'islatinextended-d',
'incjk_compatibility_ideographs',
'inphags-pa',
'ugaritic',
'inphaistos_disc',
'islatinextended-c',
'intelugu',
'inmeroitic_cursive',
'latin-1_supplement',
'isarrows',
'hanguljamo',
'incypriot_syllabary',
'arabic_extended-a',
'iskangxiradicals',
'iscuneiformnumbersandpunctuation',
'isornamental_dingbats',
'inunifiedcanadianaboriginalsyllabicsextended',
'inblock_elements',
'rejang',
'insundanese',
'supplementalarrows-c',
'supplementalarrows-b',
'kaithi',
'incurrency_symbols',
'isold_north_arabian',
'inhanunoo',
'isancientsymbols',
'newa',
'inmanichaean',
'insinhala_archaic_numbers',
'telugu',
'sutton_signwriting',
'cjkcompatibilityideographssupplement',
'miscellaneous_symbols',
'inmiscellaneous_symbols_and_pictographs',
'braille_patterns',
'sharada',
'inmiscellaneous_mathematical_symbols-b',
'isletterlike_symbols',
'inphaistosdisc',
'inenclosed_ideographic_supplement',
'iskhmer',
'intransport_and_map_symbols',
'combining_diacritical_marks_supplement',
'isol_chiki',
'supplemental_arrows-a',
'cjkunifiedideographsextensionb',
'islepcha',
'istaitham',
'counting_rod_numerals',
'halfwidthandfullwidthforms',
'sundanese_supplement',
'intamil',
'insupplementalarrows-a',
'isadlam',
'cjkunifiedideographsextensiona',
'isaegean_numbers',
'mongolian_supplement',
'iskayah_li',
'myanmar',
'istangut_components',
'inkatakana',
'incypriotsyllabary',
'inarabicpresentationforms-b',
'inglagolitic_supplement',
'insupplementaryprivateusearea-a',
'inarabicpresentationforms-a',
'intifinagh',
'unified_canadian_aboriginal_syllabics_extended',
'isprivateusearea',
'inhatran',
'incombining_diacritical_marks_extended',
'isgeorgian',
'opticalcharacterrecognition',
'isideographic_symbols_and_punctuation',
'isgeorgiansupplement',
'inmeeteimayek',
'isbopomofoextended',
'ornamental_dingbats',
'ismeroitic_hieroglyphs',
'vai',
'enclosed_alphanumerics',
'sinhala',
'insiddham',
'isideographicsymbolsandpunctuation',
'iscjk_compatibility_ideographs_supplement',
'ismiscellaneoussymbolsandpictographs',
'insuttonsignwriting',
'latin-1supplement',
'ispsalterpahlavi',
'istelugu',
'isbopomofo_extended',
'yisyllables',
'incuneiform',
'islatin_extended-e',
'isgeneralpunctuation',
'phoneticextensionssupplement',
'manichaean',
'islao',
'cherokee_supplement',
'inrunic',
'latinextended-b',
'cjkstrokes',
'insupplementalsymbolsandpictographs',
'inenclosedideographicsupplement',
'isold_italic',
'isvariationselectors',
'mongolian',
'isogham',
'bamumsupplement',
'intai_xuan_jing_symbols',
'ismathematical_alphanumeric_symbols',
'incombiningmarksforsymbols',
'isyijing_hexagram_symbols',
'ishigh_private_use_surrogates',
'inphoneticextensions',
'isethiopic_supplement',
'cyrillicextended-b',
'cyrillicextended-c',
'combiningdiacriticalmarks',
'isenclosed_alphanumerics',
'incjkunifiedideographs',
'incarian',
'inbassa_vah',
'istangutcomponents',
'ethiopic_extended-a',
'islinear_b_syllabary',
'isgeometricshapes',
'insyloti_nagri',
'supplemental_punctuation',
'isold_hungarian',
'lepcha',
'islatin_extended-b',
'islatin_extended-a',
'islatin_extended-d',
'inarrows',
'isoldpermic',
'inmarchen',
'isnew_tai_lue',
'inmongolian_supplement',
'katakana_phonetic_extensions',
'hangul_jamo',
'insupplementalarrows-c',
'ishebrew',
'inmiscellaneoussymbolsandarrows',
'incuneiformnumbersandpunctuation',
'isosage',
'cyrillicextended-a',
'lowsurrogates',
'inmodifiertoneletters',
'issinhalaarchaicnumbers',
'inoriya',
'isarabicextended-a',
'issupplementary_private_use_area-b',
'inglagolitic',
'intaile',
'yi_radicals',
'ideographicsymbolsandpunctuation',
'myanmar_extended-b',
'isdevanagari_extended',
'modifier_tone_letters',
'inearly_dynastic_cuneiform',
'syloti_nagri',
'iscyrillic',
'inyijing_hexagram_symbols',
'inmiscellaneous_symbols_and_arrows',
'inyi_radicals',
'myanmar_extended-a',
'kayahli',
'issylotinagri',
'isyi_radicals',
'isbamumsupplement',
'arabic_supplement',
'isverticalforms',
'isglagoliticsupplement',
'oldpermic',
'islineara',
'lineara',
'arrows',
'meeteimayek',
'georgian',
'innewtailue',
'issupplementalmathematicaloperators',
'ismongolian_supplement',
'iscypriotsyllabary',
'ishanguljamoextended-a',
'cuneiform_numbers_and_punctuation',
'commonindicnumberforms',
'incyrillic_extended-a',
'issupplemental_symbols_and_pictographs',
'incyrillic_extended-b',
'musicalsymbols',
'inlatin-1supplement',
'transportandmapsymbols',
'playing_cards',
'innewa',
'isethiopic',
'shorthand_format_controls',
'incjkunifiedideographsextensiona',
'islinearbideograms',
'inmyanmar_extended-b',
'ininscriptional_pahlavi',
'ingeorgian',
'tai_tham',
'innumber_forms',
'istakri',
'inmiscellaneoustechnical',
'combininghalfmarks',
'ishanguljamo',
'inmodifier_tone_letters',
'inkangxiradicals',
'isarabic_mathematical_alphabetic_symbols',
'inoldpermic',
'oldturkic',
'ismyanmarextended-a',
'nko',
'cjkcompatibilityforms',
'inverticalforms',
'inolditalic',
'inthaana',
'insupplemental_arrows-c',
'boxdrawing',
'inscriptionalpahlavi',
'iskhmer_symbols',
'isrejang',
'ishangul_syllables',
'incaucasianalbanian',
'hanguljamoextended-a',
'meroitic_hieroglyphs',
'iscombining_diacritical_marks_supplement',
'tangut',
'iswarangciti',
'inphonetic_extensions_supplement',
'iscyrillicextended-c',
'cherokee',
'inarabic_presentation_forms-a',
'inarabicsupplement',
'innabataean',
'currencysymbols',
'incyrillic',
'isemoticons',
'inwarang_citi',
'inethiopic_extended-a',
'mongoliansupplement',
'intaitham',
'ismahajani',
'tai_xuan_jing_symbols',
'geometricshapes',
'inethiopic',
'istibetan',
'intangutcomponents',
'linear_a',
'issinhala',
'tamil',
'islycian',
'inmeeteimayekextensions',
'new_tai_lue',
'old_turkic',
'byzantine_musical_symbols',
'inphoneticextensionssupplement',
'numberforms',
'ishangulsyllables',
'isenclosed_alphanumeric_supplement',
'mahajani',
'vertical_forms',
'inkhojki',
'incombining_half_marks',
'isoldpersian',
'inideographicdescriptioncharacters',
'ismendekikakui',
'ispahawhhmong',
'invariationselectors',
'inmahjongtiles',
'glagolitic_supplement',
'inold_north_arabian',
'iskanbun',
'isold_south_arabian',
'incjksymbolsandpunctuation',
'inmende_kikakui',
'suttonsignwriting',
'incyrillicextended-a',
'ingurmukhi',
'insyriac',
'intagbanwa',
'inoldturkic',
'issupplementaryprivateusearea-a',
'ininscriptional_parthian',
'inkatakanaphoneticextensions',
'ismiscellaneous_technical',
'inhangul_jamo_extended-a',
'isinscriptionalpahlavi',
'cyrillic',
'indingbats',
'inhanguljamoextended-b',
'ol_chiki',
'tangut_components',
'ideographic_description_characters',
'inhighprivateusesurrogates',
'khudawadi',
'ingeneral_punctuation',
'ismeeteimayekextensions',
'isegyptian_hieroglyphs',
'isyiradicals',
'linearbsyllabary',
'incjkcompatibility',
'inkharoshthi',
'isold_turkic',
'isbyzantine_musical_symbols',
'isphoenician',
'inenclosed_alphanumerics',
'intransportandmapsymbols',
'bopomofo',
'cjk_symbols_and_punctuation',
'ingeometric_shapes_extended',
'isvertical_forms',
'isrunic',
'musical_symbols',
'inelbasan',
'inenclosedalphanumerics',
'intai_viet',
'incommonindicnumberforms',
'issupplementalarrows-b',
'enclosed_cjk_letters_and_months',
'iscommon_indic_number_forms',
'lao',
'latin_extended-e',
'inlatinextended-a',
'isvariation_selectors',
'latin_extended-b',
'iscontrol_pictures',
'ethiopicsupplement',
'isethiopic_extended-a',
'cham',
'isplayingcards',
'kangxi_radicals',
'ipaextensions',
'issora_sompeng',
'isspacingmodifierletters',
'insupplementary_private_use_area-b',
'khojki',
'inkhmersymbols',
'iscombining_marks_for_symbols',
'hiragana',
'yijing_hexagram_symbols',
'incontrolpictures',
'inornamentaldingbats',
'inarabic_mathematical_alphabetic_symbols',
'inbyzantine_musical_symbols',
'katakanaphoneticextensions',
'indomino_tiles',
'incjk_radicals_supplement',
'greekandcoptic',
'inbatak',
'cuneiform',
'inyiradicals',
'intaiviet',
'miscellaneousmathematicalsymbols-a',
'supplementaryprivateusearea-a',
'iskhojki',
'aegeannumbers',
'sorasompeng',
'isblock_elements',
'egyptianhieroglyphs',
'inbamum',
'inlatinextended-e',
'spacing_modifier_letters',
'inlatinextended-c',
'osmanya',
'incjk_compatibility_forms',
'iscjkunifiedideographsextensione',
'iscjkunifiedideographsextensiond',
'meroiticcursive',
'inmeetei_mayek',
'copticepactnumbers',
'isunified_canadian_aboriginal_syllabics',
'takri',
'kannada',
'miscellaneoussymbols',
'ingrantha',
'istangut',
'alphabetic_presentation_forms',
'ishatran',
'ismandaic',
'devanagariextended',
'inlycian',
'supplementalmathematicaloperators',
'iscjkunifiedideographsextensiona',
'iscjkunifiedideographsextensionb',
'innew_tai_lue',
'ismiao',
'ismro',
'isthaana',
'isarabic_supplement',
'inemoticons',
'ingeorgian_supplement',
'geometric_shapes',
'ishighprivateusesurrogates',
'inmahajani',
'ingujarati',
'miscellaneousmathematicalsymbols-b',
'kayah_li',
'hangul_jamo_extended-b',
'enclosedalphanumerics',
'islatin-1supplement',
'ismahjongtiles',
'istransportandmapsymbols',
'inlowsurrogates',
'countingrodnumerals',
'inrejang',
'islinear_a',
'isphonetic_extensions_supplement',
'incyrillicsupplement',
'indevanagariextended',
'intai_le',
'inwarangciti',
'georgiansupplement',
'isarabic_extended-a',
'inplaying_cards',
'inlatinextendedadditional',
'mathematical_alphanumeric_symbols',
'isold_permic',
'ininscriptionalparthian',
'cyrillic_extended-a',
'isprivate_use_area',
'psalterpahlavi',
'tifinagh',
'unified_canadian_aboriginal_syllabics',
'intakri',
'miscellaneous_symbols_and_arrows',
'induployan',
'inenclosed_cjk_letters_and_months',
'isbyzantinemusicalsymbols',
'isgeorgian_supplement',
'inblockelements',
'inbalinese',
'isolditalic',
'ismeetei_mayek_extensions',
'number_forms',
'inmusical_symbols',
'issupplemental_mathematical_operators',
'arabicmathematicalalphabeticsymbols',
'isboxdrawing',
'rumi_numeral_symbols',
'intags',
'cjk_compatibility',
'supplementary_private_use_area-b',
'inanatolianhieroglyphs',
'iscjk_unified_ideographs_extension_e',
'iskatakana_phonetic_extensions',
'ismanichaean',
'isancient_greek_numbers',
'insupplementary_private_use_area-a',
'inbuginese',
'iscyrillic_extended-c',
'ingreekandcoptic',
'isbuginese',
'ethiopicextended-a',
'isbassa_vah',
'transport_and_map_symbols',
'isenclosedalphanumericsupplement',
'ancient_symbols',
'ispau_cin_hau',
'ingeometricshapes',
'inmultani',
'iscounting_rod_numerals',
'supplementalarrows-a',
'runic',
'ideographicdescriptioncharacters',
'isarabicmathematicalalphabeticsymbols',
'inthai',
'bopomofo_extended',
'issyloti_nagri',
'isimperial_aramaic',
'inancientsymbols',
'inold_hungarian',
'isbrahmi',
'isbopomofo',
'inmyanmar_extended-a',
'iscyrillicextended-a',
'isbalinese',
'inarabic_extended-a',
'incuneiform_numbers_and_punctuation',
'bassa_vah',
'combining_diacritical_marks',
'isnumberforms',
'iscyrillicextended-b',
'isgeometricshapesextended',
'incyrillic_supplement',
'incyrillic_extended-c',
'iskharoshthi',
'issuperscriptsandsubscripts',
'marchen',
'inmiscellaneoussymbolsandpictographs',
'iscoptic_epact_numbers',
'coptic_epact_numbers',
'iscombininghalfmarks',
'iscjk_unified_ideographs_extension_b',
'cjk_unified_ideographs_extension_e',
'kana_supplement',
'cjk_unified_ideographs_extension_a',
'inhanguljamoextended-a',
'inhigh_private_use_surrogates',
'isglagolitic',
'cjk_unified_ideographs_extension_b',
'issuttonsignwriting',
'islinearbsyllabary',
'insupplementalpunctuation',
'supplemental_symbols_and_pictographs',
'iscjkunifiedideographs',
'box_drawing',
'ismiscellaneous_symbols_and_arrows',
'incjkcompatibilityideographs',
'khmersymbols',
'incjkcompatibilityforms',
'devanagari_extended',
'miscellaneous_symbols_and_pictographs',
'ogham',
'inold_persian',
'inspecials',
'isdomino_tiles',
'armenian',
'ininscriptionalpahlavi',
'bamum',
'inscriptionalparthian',
'isspacing_modifier_letters',
'isblockelements',
'cjkunifiedideographs',
'siddham',
'katakana',
'inbraillepatterns',
'old_south_arabian',
'inarabic_supplement',
'playingcards',
'meetei_mayek',
'meroitichieroglyphs',
'inbassavah',
'inlimbu',
'ismodi',
'inhigh_surrogates',
'inethiopicextended-a',
'inbengali',
'isunified_canadian_aboriginal_syllabics_extended',
'isosmanya',
'inavestan',
'iscjkunifiedideographsextensionc',
'sora_sompeng',
'incurrencysymbols',
'unifiedcanadianaboriginalsyllabicsextended',
'meetei_mayek_extensions',
'islatin-1_supplement',
'variation_selectors',
'insutton_signwriting',
'isoldhungarian',
'isbamum',
'inegyptianhieroglyphs',
'issundanesesupplement',
'iscjk_strokes',
'ingreekextended',
'high_surrogates',
'issundanese',
'iscjkcompatibilityforms',
'ismiscellaneous_symbols',
'iscyrillic_extended-a',
'invariation_selectors_supplement',
'ischerokee_supplement',
'tags',
'inoldnortharabian',
'arabic_presentation_forms-a',
'phoenician',
'ingreek_and_coptic',
'yiradicals',
'isvedic_extensions',
'isbamum_supplement',
'inkangxi_radicals',
'egyptian_hieroglyphs',
'incjkcompatibilityideographssupplement',
'supplementary_private_use_area-a',
'earlydynasticcuneiform',
'inkhmer_symbols',
'innumberforms',
'avestan',
'islimbu',
'devanagari',
'variation_selectors_supplement',
'istaixuanjingsymbols',
'small_form_variants',
'isphaistos_disc',
'cyrillic_extended-b',
'high_private_use_surrogates',
'vedic_extensions',
'chakma',
'inscriptional_parthian',
'ismusical_symbols',
'caucasian_albanian',
'intibetan',
'iscjkcompatibilityideographs',
'mendekikakui',
'latin_extended_additional',
'inglagoliticsupplement',
'cjk_compatibility_ideographs_supplement',
'issiddham',
'inlatinextended-d',
'cjk_radicals_supplement',
'hangulcompatibilityjamo',
'insorasompeng',
'isletterlikesymbols',
'isgujarati',
'iskaithi',
'sinhala_archaic_numbers',
'inoptical_character_recognition',
'incherokee',
'latin_extended-d',
'combiningdiacriticalmarksextended',
'enclosed_ideographic_supplement',
'iscjk_unified_ideographs_extension_c',
'iscjkcompatibilityideographssupplement',
'latin_extended-a',
'inlow_surrogates',
'latin_extended-c',
'isancient_symbols',
'pahawhhmong',
'tirhuta',
'injavanese',
'newtailue',
'hangulsyllables',
'imperial_aramaic',
'mathematical_operators',
'mro',
'isshorthandformatcontrols',
'bamum_supplement',
'incjk_symbols_and_punctuation',
'issmall_form_variants',
'ismusicalsymbols',
'isdeseret',
'istifinagh',
'isshorthand_format_controls',
'isahom',
'cyrillic_supplement',
'inpaucinhau',
'cyrillic_extended-c',
'inlatin_extended-b',
'nabataean',
'isruminumeralsymbols',
'isvariationselectorssupplement',
'islowsurrogates',
'ingeometric_shapes',
'inmiscellaneousmathematicalsymbols-b',
'inethiopicextended',
'ismodifiertoneletters',
'miscellaneoustechnical',
'inmiscellaneousmathematicalsymbols-a',
'isbraille_patterns',
'shavian',
'issutton_signwriting',
'inenclosedalphanumericsupplement',
'khmer',
'inornamental_dingbats',
'block_elements',
'inipaextensions',
'inmyanmarextended-a',
'incjk_unified_ideographs_extension_b',
'incjk_unified_ideographs_extension_a',
'ispahawh_hmong',
'isgeneral_punctuation',
'alchemicalsymbols',
'incjk_unified_ideographs_extension_e',
'incjkstrokes',
'oldsoutharabian',
'isgurmukhi',
'inalphabeticpresentationforms',
'iscombiningmarksforsymbols',
'inoldsoutharabian',
'inmeroitichieroglyphs',
'inmathematical_alphanumeric_symbols',
'isrumi_numeral_symbols',
'incopticepactnumbers',
'highprivateusesurrogates',
'controlpictures',
'inbamumsupplement',
'arabic',
'cypriot_syllabary',
'cherokeesupplement',
'cjkunifiedideographsextensionc',
'warang_citi',
'paucinhau',
'iscaucasian_albanian',
'inethiopic_supplement',
'isideographicdescriptioncharacters',
'tagalog',
'inbyzantinemusicalsymbols',
'isyi_syllables',
'tibetan',
'iskanasupplement',
'inaegeannumbers',
'iswarang_citi',
'isarabicsupplement',
'ismende_kikakui',
'isenclosedalphanumerics',
'ismyanmar_extended-b',
'insundanese_supplement',
'smallformvariants',
'inmiao',
'iscontrolpictures',
'ismyanmar_extended-a',
'shorthandformatcontrols',
'isarabic',
'intangut_components',
'isgreekandcoptic',
'isold_persian',
'isvai',
'isalchemicalsymbols',
'inancient_symbols',
'inancient_greek_numbers',
'iscjkstrokes',
'isglagolitic_supplement',
'isopticalcharacterrecognition',
'inhangul_jamo_extended-b',
'insylotinagri',
'iscombiningdiacriticalmarksextended',
'isspecials',
'ishigh_surrogates',
'cjk_unified_ideographs_extension_c',
'ismiscellaneous_symbols_and_pictographs',
'inyisyllables',
'issinhala_archaic_numbers',
'iscombining_diacritical_marks_for_symbols',
'inshorthand_format_controls',
'alphabeticpresentationforms',
'inalphabetic_presentation_forms',
'inlatinextended-b',
'oriya',
'indevanagari_extended',
'incombiningdiacriticalmarks',
'ismiscellaneousmathematicalsymbols-a',
'inbhaiksuki',
'insuperscripts_and_subscripts',
'iscombining_diacritical_marks_extended',
'general_punctuation',
'incham',
'inlinear_b_ideograms',
'letterlike_symbols',
'geometric_shapes_extended',
'istai_le',
'inhighsurrogates',
'inmathematical_operators',
'tagbanwa',
'bopomofoextended',
'isnumber_forms',
'iskhudawadi',
'cjk_unified_ideographs_extension_d',
'isgreek_and_coptic',
'invedicextensions',
'isugaritic',
'isdominotiles',
'combiningdiacriticalmarkssupplement',
'ingeneralpunctuation',
'taiviet',
'inold_italic',
'isearlydynasticcuneiform',
'miscellaneous_mathematical_symbols-a',
'iscjksymbolsandpunctuation',
'arabicextended-a',
'kanasupplement',
'incjk_unified_ideographs_extension_c',
'isenclosedcjklettersandmonths',
'inarabic_presentation_forms-b',
'ishiragana',
'incjk_unified_ideographs_extension_d',
'miscellaneous_mathematical_symbols-b',
'isvedicextensions',
'private_use_area',
'isunifiedcanadianaboriginalsyllabics',
'geometricshapesextended',
'ingeorgiansupplement',
'currency_symbols',
'inold_permic',
'ismyanmarextended-b',
'sylotinagri',
'inhalfwidth_and_fullwidth_forms',
'inlinear_a',
'incoptic_epact_numbers',
'enclosedideographicsupplement',
'generalpunctuation',
'inanatolian_hieroglyphs',
'iscurrencysymbols',
'ishanunoo',
'unifiedcanadianaboriginalsyllabics',
'ismeroiticcursive',
'istai_xuan_jing_symbols',
'isethiopic_extended',
'ismiscellaneousmathematicalsymbols-b',
'variationselectorssupplement',
'iscjk_unified_ideographs_extension_a',
'incjkunifiedideographsextensione',
'incjkunifiedideographsextensionb',
'iscjk_unified_ideographs_extension_d',
'inoldpersian',
'malayalam',
'thaana',
'issundanese_supplement',
'combining_marks_for_symbols',
'insupplementaryprivateusearea-b',
'inkhmer',
'inethiopicsupplement',
'old_italic',
'common_indic_number_forms',
'inphonetic_extensions',
'intangut',
'inkhudawadi',
'insupplemental_arrows-a',
'islisu',
'oldnortharabian',
'inscriptional_pahlavi',
'isoptical_character_recognition',
'isearly_dynastic_cuneiform',
'isoldturkic',
'ischakma',
'ancientsymbols',
'isphoneticextensionssupplement',
'ancientgreeknumbers',
'inhiragana',
'privateusearea',
'isethiopicextended',
'ethiopic',
'isphonetic_extensions',
'islow_surrogates',
'cyrillicsupplement',
'duployan',
'isgreekextended',
'letterlikesymbols',
'anatolian_hieroglyphs',
'phaistos_disc',
'inlatin_extended-e',
'insinhala',
'hanunoo',
'ishangulcompatibilityjamo',
'iscjk_symbols_and_punctuation',
'indominotiles',
'bengali',
'ingeometricshapesextended',
'dingbats',
'ismiscellaneous_mathematical_symbols-a',
'meeteimayekextensions',
'issupplementaryprivateusearea-b',
'ruminumeralsymbols',
'low_surrogates',
'coptic',
'tangutcomponents',
'modi',
'samaritan',
'isphaistosdisc',
'bhaiksuki',
'ahom',
'isancient_greek_musical_notation',
'iscuneiform_numbers_and_punctuation',
'inogham',
'inahom',
'iskannada',
'incyrillicextended-c',
'inhangul_compatibility_jamo',
'inmiscellaneous_symbols',
'isvariation_selectors_supplement',
'superscriptsandsubscripts',
'iscopticepactnumbers',
'ethiopic_extended',
'greek_and_coptic',
'incoptic',
'supplemental_arrows-c',
'supplemental_arrows-b',
'ismyanmar',
'control_pictures',
'inearlydynasticcuneiform',
'inolchiki',
'old_hungarian',
'gothic',
'inbraille_patterns',
'issupplementalpunctuation',
'issmallformvariants',
'insmallformvariants',
'inkayah_li',
'inspacingmodifierletters',
'phags-pa',
'inmodi',
'inkana_supplement',
'multani',
'incountingrodnumerals',
'incjk_compatibility_ideographs_supplement',
'isegyptianhieroglyphs',
'isethiopicextended-a',
'inalchemicalsymbols',
'ismeroitic_cursive',
'inkanasupplement',
'isanatolian_hieroglyphs',
'intaixuanjingsymbols',
'variationselectors',
'iscarian',
'issamaritan',
'inkanbun',
'glagoliticsupplement',
'inold_south_arabian',
'isenclosed_cjk_letters_and_months',
'lydian',
'inlepcha',
'glagolitic',
'isbassavah',
'inlinear_b_syllabary',
'isoriya',
'iscombining_diacritical_marks',
'iscombiningdiacriticalmarks',
'ismalayalam',
'dominotiles',
'innko',
'inbamum_supplement',
'hebrew',
'georgian_supplement',
'enclosed_alphanumeric_supplement',
'insupplemental_mathematical_operators',
'isipaextensions',
'insundanesesupplement',
'incombining_diacritical_marks',
'inpsalterpahlavi',
'arabic_presentation_forms-b',
'insharada',
'isarmenian',
'isgrantha',
'ethiopic_supplement',
'cjkcompatibility',
'insamaritan',
'inmeroitic_hieroglyphs',
'elbasan',
'inbopomofo_extended',
'psalter_pahlavi',
'insaurashtra',
'inpau_cin_hau',
'warangciti',
'insuperscriptsandsubscripts',
'isduployan',
'osage',
'iscommonindicnumberforms',
'inethiopic_extended',
'isnewtailue',
'inarabicmathematicalalphabeticsymbols',
'insupplemental_arrows-b',
'ismathematicaloperators',
'iscjkradicalssupplement',
'grantha',
'iscombiningdiacriticalmarksforsymbols',
'ismongoliansupplement',
'ismathematicalalphanumericsymbols',
'islinear_b_ideograms',
'ishangul_compatibility_jamo',
'isethiopicsupplement',
'inarmenian',
'inkaithi',
'domino_tiles',
'phonetic_extensions',
'ismathematical_operators',
'inpahawh_hmong',
'incjkradicalssupplement',
'old_permic',
'inphoenician',
'inkayahli',
'iscjk_compatibility_forms',
'combining_half_marks',
'inunifiedcanadianaboriginalsyllabics',
'isideographic_description_characters',
'ishanguljamoextended-b',
'isenclosedideographicsupplement',
'miscellaneous_technical',
'byzantinemusicalsymbols',
'iscurrency_symbols',
'supplementalsymbolsandpictographs',
'incjkunifiedideographsextensiond',
'inlatin-1_supplement',
'ancient_greek_numbers',
'latinextended-c',
'incombiningdiacriticalmarksforsymbols',
'incjkunifiedideographsextensionc',
'linearbideograms',
'isolchiki',
'islatin_extended_additional',
'limbu',
'iscuneiform',
'isbengali',
'inipa_extensions',
'latinextended-a',
'inruminumeralsymbols',
'latinextended-d',
'latinextended-e',
'inopticalcharacterrecognition',
'iskayahli',
'alchemical_symbols',
'emoticons',
'isancientgreekmusicalnotation',
'isavestan',
'ishalfwidth_and_fullwidth_forms',
'lisu',
'khmer_symbols',
'islatinextended-b',
'istai_viet',
'ischerokee',
'isinscriptional_parthian',
'iselbasan',
'syriac',
'isgeometric_shapes',
'ismiscellaneoussymbols',
'incontrol_pictures',
'istirhuta',
'islatinextended-a',
'spacingmodifierletters',
'sundanese',
'myanmarextended-a',
'istai_tham',
'inlisu',
'hanguljamoextended-b',
'insupplemental_symbols_and_pictographs',
'myanmarextended-b',
'iskana_supplement',
'optical_character_recognition',
'old_persian',
'isalphabeticpresentationforms',
'hangul_syllables',
'ancientgreekmusicalnotation',
'inbuhid',
'ishangul_jamo_extended-a',
'inpalmyrene',
'inyijinghexagramsymbols',
'istags',
'isipa_extensions',
'isarabic_presentation_forms-a',
'isarabic_presentation_forms-b',
'inrumi_numeral_symbols',
'inletterlike_symbols',
'javanese',
'mende_kikakui',
'iscyrillic_supplement',
'phaistosdisc',
'taitham',
'insupplemental_punctuation',
'modifiertoneletters',
'inol_chiki',
'blockelements',
'verticalforms',
'yi_syllables',
'isinscriptionalparthian',
'inlatin_extended-a',
'ispalmyrene',
'incombiningdiacriticalmarksextended',
'inunified_canadian_aboriginal_syllabics',
'inugaritic',
'issharada',
'isoldsoutharabian',
'iscyrillic_extended-b',
'taixuanjingsymbols',
'ismultani',
'isaegeannumbers',
'olditalic',
'inkatakana_phonetic_extensions',
'bassavah',
'anatolianhieroglyphs',
'arabicsupplement',
'yijinghexagramsymbols',
'inchakma',
'ismiscellaneous_mathematical_symbols-b',
'isdevanagari',
'inalchemical_symbols',
'inegyptian_hieroglyphs',
'isshavian',
'supplementalpunctuation',
'inmathematicalalphanumericsymbols',
'ethiopicextended',
'phonetic_extensions_supplement',
'halfwidth_and_fullwidth_forms',
'hangul_jamo_extended-a',
'ismodifier_tone_letters',
'iscyrillicsupplement',
'cjk_unified_ideographs',
'combiningmarksforsymbols',
'oldpersian',
'kangxiradicals',
'isbraillepatterns',
'imperialaramaic',
'taile',
'inkannada',
'inbopomofo',
'sinhalaarchaicnumbers',
'ornamentaldingbats',
'isinscriptional_pahlavi',
'isornamentaldingbats',
'kanbun',
'linear_b_syllabary',
'iscjk_compatibility',
'isarabicpresentationforms-a',
'incombiningdiacriticalmarkssupplement',
'inlineara',
'tai_viet',
'inbopomofoextended',
'ischam',
'miscellaneoussymbolsandarrows',
'inenclosedcjklettersandmonths',
'isalphabetic_presentation_forms',
'invai',
'inspacing_modifier_letters',
'inideographic_symbols_and_punctuation',
'inosage',
'iscoptic',
'inhangul_syllables',
'isbhaiksuki',
'istaiviet',
'inpahawhhmong',
'isphoneticextensions',
'inprivateusearea',
'inmeroiticcursive',
'inmiscellaneous_technical',
'mathematicaloperators',
'inhanguljamo',
'islydian',
'inoldhungarian',
'issupplementalarrows-a',
'issupplemental_punctuation',
'incherokeesupplement',
'inlinearbsyllabary',
'issupplementalarrows-c',
'inmalayalam',
'cjk_compatibility_forms',
'isphags-pa',
'inhangul_jamo',
'insora_sompeng',
'incherokee_supplement',
'istagalog',
'iscombining_half_marks',
'issupplementary_private_use_area-a',
'incombining_diacritical_marks_for_symbols',
'isalchemical_symbols',
'isoldnortharabian',
'ingothic',
'superscripts_and_subscripts',
'iskangxi_radicals',
'inmro',
'inmongoliansupplement',
'inshavian',
'specials',
'ismahjong_tiles',
'invariation_selectors',
'aegean_numbers',
'cjk_strokes',
'mahjong_tiles',
'inancientgreeknumbers',
'buginese',
'cjkunifiedideographsextensiond',
'cjkunifiedideographsextensione',
'inhalfwidthandfullwidthforms',
'inhebrew',
'inmendekikakui',
'combining_diacritical_marks_extended',
'inarabic',
'isunifiedcanadianaboriginalsyllabicsextended',
'iscaucasianalbanian',
'insmall_form_variants',
'ismongolian',
'ideographic_symbols_and_punctuation',
'greek_extended',
'issupplementalsymbolsandpictographs',
'inold_turkic',
'carian',
'olchiki',
'inmyanmarextended-b',
'inlatin_extended-d',
'inideographic_description_characters',
'inletterlikesymbols',
'inbox_drawing',
'ismarchen',
'iscjkcompatibility'
);

      PUCUUnicodeBlockLowerCaseHashMapValueBits=16;

      PUCUUnicodeBlockLowerCaseHashMapValues:array[0..1337] of word=(
16,
118,
189,
31,
104,
244,
42,
241,
255,
101,
249,
129,
23,
190,
129,
251,
85,
175,
152,
208,
47,
158,
142,
188,
162,
270,
183,
158,
77,
81,
54,
66,
116,
146,
52,
144,
30,
204,
94,
180,
253,
30,
198,
106,
182,
68,
68,
89,
122,
134,
150,
244,
108,
91,
177,
118,
139,
44,
164,
155,
67,
101,
33,
250,
184,
143,
112,
91,
117,
242,
56,
154,
68,
226,
242,
143,
63,
64,
193,
254,
67,
256,
145,
58,
62,
84,
92,
72,
44,
25,
76,
242,
48,
180,
20,
127,
18,
45,
182,
261,
22,
175,
58,
191,
249,
13,
233,
50,
113,
221,
225,
94,
87,
202,
63,
159,
89,
262,
149,
117,
18,
272,
70,
150,
81,
214,
251,
111,
35,
198,
50,
167,
228,
253,
19,
232,
213,
162,
163,
146,
186,
245,
88,
72,
254,
239,
86,
185,
259,
221,
72,
108,
130,
67,
114,
4,
183,
234,
150,
171,
183,
200,
66,
202,
141,
125,
150,
128,
173,
166,
94,
26,
190,
1,
75,
35,
182,
19,
102,
225,
258,
48,
82,
132,
57,
262,
89,
203,
71,
193,
43,
165,
213,
194,
208,
26,
246,
268,
84,
256,
88,
207,
90,
73,
166,
255,
46,
259,
66,
60,
87,
264,
59,
54,
244,
159,
62,
25,
87,
249,
115,
163,
217,
131,
33,
236,
106,
182,
158,
247,
271,
152,
97,
48,
149,
186,
55,
34,
79,
234,
96,
143,
110,
258,
189,
121,
80,
29,
215,
234,
268,
256,
246,
1,
198,
26,
110,
118,
224,
141,
69,
65,
194,
31,
142,
41,
3,
111,
263,
255,
170,
153,
47,
40,
229,
243,
245,
72,
116,
147,
64,
37,
122,
61,
6,
80,
117,
168,
231,
236,
140,
161,
83,
126,
100,
200,
59,
3,
2,
125,
75,
172,
223,
51,
217,
112,
35,
262,
11,
92,
225,
178,
99,
148,
124,
208,
24,
19,
272,
93,
50,
119,
234,
135,
130,
124,
226,
126,
8,
116,
92,
119,
137,
131,
126,
119,
229,
14,
154,
247,
172,
181,
181,
75,
143,
34,
51,
91,
217,
182,
133,
225,
127,
99,
263,
122,
241,
1,
259,
253,
213,
36,
239,
115,
162,
135,
197,
34,
54,
74,
218,
77,
155,
35,
124,
102,
250,
172,
199,
137,
16,
156,
154,
170,
15,
262,
81,
197,
52,
132,
144,
180,
133,
189,
66,
235,
220,
65,
61,
38,
152,
14,
185,
71,
8,
257,
220,
140,
217,
54,
206,
243,
83,
36,
32,
236,
181,
29,
25,
167,
139,
51,
199,
240,
65,
74,
144,
254,
206,
154,
209,
155,
174,
103,
248,
232,
153,
251,
247,
193,
109,
192,
104,
248,
246,
99,
22,
13,
45,
199,
271,
196,
112,
77,
133,
197,
8,
85,
145,
60,
236,
103,
147,
211,
69,
139,
227,
119,
161,
114,
191,
199,
240,
187,
80,
259,
107,
104,
261,
154,
41,
241,
179,
80,
138,
127,
89,
113,
127,
31,
141,
2,
153,
3,
78,
37,
140,
136,
253,
102,
4,
204,
5,
272,
209,
52,
72,
105,
116,
78,
258,
250,
240,
112,
252,
101,
7,
58,
224,
119,
138,
86,
271,
209,
163,
204,
82,
227,
123,
141,
5,
94,
177,
156,
267,
266,
190,
143,
169,
39,
218,
27,
84,
212,
235,
151,
186,
18,
130,
167,
91,
115,
264,
51,
233,
230,
15,
14,
257,
96,
83,
147,
206,
23,
90,
131,
145,
80,
1,
251,
259,
148,
244,
132,
181,
65,
9,
130,
50,
220,
96,
19,
253,
67,
245,
172,
196,
99,
149,
198,
97,
39,
218,
92,
238,
113,
240,
96,
82,
56,
170,
139,
74,
241,
91,
250,
81,
201,
269,
114,
272,
228,
267,
112,
194,
164,
271,
53,
61,
7,
53,
140,
231,
259,
254,
165,
221,
83,
210,
244,
87,
41,
103,
250,
30,
110,
126,
183,
165,
200,
202,
107,
137,
99,
56,
19,
225,
231,
6,
74,
122,
261,
9,
61,
191,
70,
223,
256,
169,
169,
155,
264,
267,
237,
115,
133,
147,
93,
264,
246,
161,
100,
263,
117,
81,
92,
150,
52,
156,
130,
256,
40,
174,
160,
252,
10,
197,
123,
196,
5,
82,
117,
215,
106,
88,
192,
14,
253,
143,
189,
231,
49,
216,
146,
140,
21,
48,
177,
195,
265,
204,
71,
48,
139,
1,
153,
246,
200,
123,
227,
62,
111,
68,
146,
57,
156,
84,
99,
270,
142,
269,
193,
152,
187,
7,
119,
63,
229,
102,
227,
268,
271,
226,
52,
74,
195,
49,
20,
270,
243,
157,
166,
122,
147,
63,
205,
196,
241,
180,
32,
150,
248,
67,
247,
268,
215,
125,
101,
108,
204,
73,
23,
203,
208,
79,
38,
125,
55,
255,
265,
268,
2,
148,
94,
165,
232,
214,
134,
51,
144,
183,
76,
230,
239,
229,
104,
157,
241,
175,
97,
239,
219,
9,
221,
61,
3,
185,
201,
270,
148,
83,
90,
98,
124,
77,
86,
88,
176,
246,
254,
46,
258,
82,
4,
137,
264,
115,
232,
69,
260,
267,
111,
192,
22,
151,
72,
192,
189,
245,
201,
169,
147,
78,
229,
12,
182,
142,
265,
220,
221,
180,
37,
103,
42,
240,
118,
32,
237,
163,
220,
14,
248,
80,
135,
62,
157,
233,
78,
137,
239,
12,
236,
7,
174,
121,
260,
165,
164,
111,
247,
79,
145,
126,
55,
160,
146,
265,
256,
118,
208,
72,
239,
151,
151,
3,
24,
130,
6,
86,
222,
70,
55,
69,
136,
162,
73,
261,
50,
146,
76,
45,
110,
74,
211,
266,
7,
63,
173,
252,
66,
69,
138,
170,
226,
86,
104,
19,
237,
265,
113,
158,
105,
266,
90,
63,
149,
39,
261,
96,
71,
172,
135,
126,
159,
181,
169,
255,
69,
228,
71,
43,
39,
190,
243,
98,
90,
270,
115,
267,
264,
266,
174,
28,
15,
62,
72,
272,
46,
37,
170,
127,
64,
235,
211,
87,
120,
193,
197,
79,
226,
199,
205,
165,
65,
164,
105,
149,
98,
36,
64,
148,
9,
238,
68,
73,
228,
166,
141,
29,
43,
108,
104,
252,
21,
261,
85,
86,
139,
272,
201,
148,
95,
236,
216,
17,
166,
222,
219,
242,
225,
40,
219,
27,
61,
108,
84,
270,
70,
169,
98,
7,
95,
262,
89,
33,
78,
226,
60,
200,
171,
88,
100,
157,
157,
131,
5,
128,
216,
237,
210,
244,
268,
227,
140,
260,
190,
237,
228,
243,
153,
168,
17,
109,
247,
192,
113,
188,
59,
93,
231,
161,
24,
6,
6,
28,
252,
16,
229,
11,
96,
254,
91,
4,
62,
6,
198,
158,
207,
10,
212,
37,
114,
17,
189,
179,
110,
198,
129,
221,
220,
70,
238,
178,
127,
98,
51,
250,
89,
76,
101,
212,
72,
217,
245,
162,
108,
37,
10,
203,
252,
64,
76,
232,
101,
172,
187,
131,
156,
155,
39,
103,
145,
255,
77,
240,
71,
263,
266,
1,
164,
94,
72,
265,
162,
60,
67,
49,
224,
21,
4,
2,
201,
125,
141,
79,
131,
260,
257,
242,
195,
159,
120,
52,
3,
138,
38,
196,
179,
13,
83,
84,
78,
214,
2,
5,
57,
137,
54,
120,
145,
263,
135,
237,
79,
174,
151,
144,
242,
44,
133,
184,
116,
269,
4,
152,
158,
201,
73,
134,
248,
9,
166,
54,
100,
124,
60,
82,
154,
118,
196,
2,
184,
55,
39,
173,
207,
192,
122,
243,
210,
163,
170,
112,
231,
228,
14,
116,
205,
90,
20,
260,
227,
176,
100,
245,
98,
65,
159,
133,
124,
9,
117,
72,
174,
102,
88,
183,
50,
27,
107,
208,
258,
197,
258,
109,
161,
114,
152,
66,
181,
138,
110,
136,
92,
113,
151,
121,
5,
234,
178,
95,
144,
222,
138,
232,
64,
149,
190,
77,
76,
35,
188,
200,
87,
100,
142,
161,
262,
28,
156,
128,
35,
204,
142,
42,
155,
271,
72,
260,
193,
171,
70,
102,
230,
217,
176,
160,
251,
153,
163,
111,
251,
164,
53,
266,
267,
159,
11,
248,
55,
12,
48,
180,
157,
47,
234,
68,
263,
199,
168,
60,
135,
125,
103,
73,
81,
223,
114
);

const PUCUUnicodeAdditionalBlockLowerCaseHashMapSeedSize=24;
      PUCUUnicodeAdditionalBlockLowerCaseHashMapValueSize=24;
      PUCUUnicodeAdditionalBlockLowerCaseHashMapSize=24;

      PUCUUnicodeAdditionalBlockLowerCaseHashMapSeedBits=8;

      PUCUUnicodeAdditionalBlockLowerCaseHashMapSeeds:array[0..23] of shortint=(
0,
1,
-23,
0,
0,
1,
1,
-21,
-17,
-15,
-13,
-12,
2,
-10,
0,
-9,
-7,
-5,
-3,
1,
-1,
0,
6,
0
);

      PUCUUnicodeAdditionalBlockLowerCaseHashMapKeys:array[0..23] of TPUCURawByteString=(
'isxmld',
'_xmld',
'is_xmlw',
'inxmli',
'in_xmlc',
'is_xmli',
'_xmli',
'isxmlc',
'xmlc',
'in_xmlw',
'inxmlc',
'in_xmli',
'inxmlw',
'inxmld',
'isxmli',
'in_xmld',
'xmld',
'xmli',
'is_xmlc',
'_xmlw',
'isxmlw',
'is_xmld',
'_xmlc',
'xmlw'
);

      PUCUUnicodeAdditionalBlockLowerCaseHashMapValueBits=8;

      PUCUUnicodeAdditionalBlockLowerCaseHashMapValues:array[0..23] of byte=(
1,
1,
3,
2,
0,
2,
2,
0,
0,
3,
0,
2,
3,
1,
2,
1,
1,
2,
0,
3,
3,
1,
0,
3
);


                                                       //0 1 2 3 4 5 6 7 8 9 a b c d e f
const PUCUUTF8CharSteps:array[TPUCURawByteChar] of byte=(1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 0
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 1
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 2
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 3
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 4
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 5
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 6
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 7
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 8
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // 9
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // a
                                                         1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,  // b
                                                         1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,  // c
                                                         2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,  // d
                                                         3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,  // e
                                                         4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1); // f
                                                       //0 1 2 3 4 5 6 7 8 9 a b c d e f

const PUCUUTF8DFACharClasses:array[TPUCURawByteChar] of byte=(
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
9,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
8,
8,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
10,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
4,
3,
3,
11,
6,
6,
6,
5,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8);

const PUCUUTF8DFATransitions:array[byte] of byte=(
0,
16,
32,
48,
80,
128,
112,
16,
16,
16,
64,
96,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
0,
16,
16,
16,
16,
16,
0,
16,
0,
16,
16,
16,
16,
16,
16,
16,
32,
16,
16,
16,
16,
16,
32,
16,
32,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
32,
16,
16,
16,
16,
16,
16,
16,
16,
16,
32,
16,
16,
16,
16,
16,
16,
16,
32,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
48,
16,
48,
16,
16,
16,
16,
16,
16,
16,
48,
16,
16,
16,
16,
16,
48,
16,
48,
16,
16,
16,
16,
16,
16,
16,
48,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16);
type PPUCUCharSetCodePage=^TPUCUCharSetCodePage;
     TPUCUCharSetCodePage=array[0..255] of longword;
     PPUCUCharSetSubSubCodePages=^TPUCUCharSetSubSubCodePages;
     TPUCUCharSetSubSubCodePages=array[0..15] of PPUCUCharSetCodePage;
     PPUCUCharSetSubCodePages=^TPUCUCharSetSubCodePages;
     TPUCUCharSetSubCodePages=array[0..15] of PPUCUCharSetSubSubCodePages;
     PPUCUCharSetCodePages=^TPUCUCharSetCodePages;
     TPUCUCharSetCodePages=array[0..255] of PPUCUCharSetSubCodePages;
     PPUCUCharSetSubSubCodePageNames=^TPUCUCharSetSubSubCodePageNames;
     TPUCUCharSetSubSubCodePageNames=array[0..15] of ansistring;
     PPUCUCharSetSubCodePageNames=^TPUCUCharSetSubCodePageNames;
     TPUCUCharSetSubCodePageNames=array[0..15] of PPUCUCharSetSubSubCodePageNames;
     PPUCUCharSetCodePageNames=^TPUCUCharSetCodePageNames;
     TPUCUCharSetCodePageNames=array[0..255] of PPUCUCharSetSubCodePageNames;
const PUCUCharSetCodePage37:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$0000005e,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005b,$0000005d,$000000af,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage437:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$000000ec,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000f2,$000000fb,$000000f9,
$000000ff,$000000d6,$000000dc,$000000a2,$000000a3,$000000a5,$000020a7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$00002310,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage500:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage708:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00002502,$00002524,$000000e9,$000000e2,$00002561,$000000e0,$00002562,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$00002556,$00002555,$00002563,
$00002551,$00002557,$0000255d,$000000f4,$0000255c,$0000255b,$000000fb,$000000f9,
$00002510,$00002514,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000f8c1,$00002534,$0000252c,$0000251c,$000000a4,$00002500,$0000253c,$0000255e,
$0000255f,$0000255a,$00002554,$00002569,$0000060c,$00002566,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002560,$00002550,$0000256c,$00002567,$00002568,
$00002564,$00002565,$00002559,$0000061b,$00002558,$00002552,$00002553,$0000061f,
$0000256b,$00000621,$00000622,$00000623,$00000624,$00000625,$00000626,$00000627,
$00000628,$00000629,$0000062a,$0000062b,$0000062c,$0000062d,$0000062e,$0000062f,
$00000630,$00000631,$00000632,$00000633,$00000634,$00000635,$00000636,$00000637,
$00000638,$00000639,$0000063a,$00002588,$00002584,$0000258c,$00002590,$00002580,
$00000640,$00000641,$00000642,$00000643,$00000644,$00000645,$00000646,$00000647,
$00000648,$00000649,$0000064a,$0000064b,$0000064c,$0000064d,$0000064e,$0000064f,
$00000650,$00000651,$00000652,$0000f8c2,$0000f8c3,$0000f8c4,$0000f8c5,$0000f8c6,
$0000f8c7,$0000256a,$00002518,$0000250c,$000000b5,$000000a3,$000025a0,$000000a0);
const PUCUCharSetCodePage720:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$000000e9,$000000e2,$00000084,$000000e0,$00000086,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$0000008d,$0000008e,$0000008f,
$00000090,$00000651,$00000652,$000000f4,$000000a4,$00000640,$000000fb,$000000f9,
$00000621,$00000622,$00000623,$00000624,$000000a3,$00000625,$00000626,$00000627,
$00000628,$00000629,$0000062a,$0000062b,$0000062c,$0000062d,$0000062e,$0000062f,
$00000630,$00000631,$00000632,$00000633,$00000634,$00000635,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$00000636,$00000637,$00000638,$00000639,$0000063a,$00000641,$000000b5,$00000642,
$00000643,$00000644,$00000645,$00000646,$00000647,$00000648,$00000649,$0000064a,
$00002261,$0000064b,$0000064c,$0000064d,$0000064e,$0000064f,$00000650,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage737:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000391,$00000392,$00000393,$00000394,$00000395,$00000396,$00000397,$00000398,
$00000399,$0000039a,$0000039b,$0000039c,$0000039d,$0000039e,$0000039f,$000003a0,
$000003a1,$000003a3,$000003a4,$000003a5,$000003a6,$000003a7,$000003a8,$000003a9,
$000003b1,$000003b2,$000003b3,$000003b4,$000003b5,$000003b6,$000003b7,$000003b8,
$000003b9,$000003ba,$000003bb,$000003bc,$000003bd,$000003be,$000003bf,$000003c0,
$000003c1,$000003c3,$000003c2,$000003c4,$000003c5,$000003c6,$000003c7,$000003c8,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003c9,$000003ac,$000003ad,$000003ae,$000003ca,$000003af,$000003cc,$000003cd,
$000003cb,$000003ce,$00000386,$00000388,$00000389,$0000038a,$0000038c,$0000038e,
$0000038f,$000000b1,$00002265,$00002264,$000003aa,$000003ab,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage775:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000106,$000000fc,$000000e9,$00000101,$000000e4,$00000123,$000000e5,$00000107,
$00000142,$00000113,$00000156,$00000157,$0000012b,$00000179,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$0000014d,$000000f6,$00000122,$000000a2,$0000015a,
$0000015b,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$000000d7,$000000a4,
$00000100,$0000012a,$000000f3,$0000017b,$0000017c,$0000017a,$0000201d,$000000a6,
$000000a9,$000000ae,$000000ac,$000000bd,$000000bc,$00000141,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00000104,$0000010c,$00000118,
$00000116,$00002563,$00002551,$00002557,$0000255d,$0000012e,$00000160,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$00000172,$0000016a,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$0000017d,
$00000105,$0000010d,$00000119,$00000117,$0000012f,$00000161,$00000173,$0000016b,
$0000017e,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000000d3,$000000df,$0000014c,$00000143,$000000f5,$000000d5,$000000b5,$00000144,
$00000136,$00000137,$0000013b,$0000013c,$00000146,$00000112,$00000145,$00002019,
$000000ad,$000000b1,$0000201c,$000000be,$000000b6,$000000a7,$000000f7,$0000201e,
$000000b0,$00002219,$000000b7,$000000b9,$000000b3,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage850:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$000000ec,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000f2,$000000fb,$000000f9,
$000000ff,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$000000d7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$000000ae,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$000000c1,$000000c2,$000000c0,
$000000a9,$00002563,$00002551,$00002557,$0000255d,$000000a2,$000000a5,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$000000e3,$000000c3,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000000a4,
$000000f0,$000000d0,$000000ca,$000000cb,$000000c8,$00000131,$000000cd,$000000ce,
$000000cf,$00002518,$0000250c,$00002588,$00002584,$000000a6,$000000cc,$00002580,
$000000d3,$000000df,$000000d4,$000000d2,$000000f5,$000000d5,$000000b5,$000000fe,
$000000de,$000000da,$000000db,$000000d9,$000000fd,$000000dd,$000000af,$000000b4,
$000000ad,$000000b1,$00002017,$000000be,$000000b6,$000000a7,$000000f7,$000000b8,
$000000b0,$000000a8,$000000b7,$000000b9,$000000b3,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage852:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$0000016f,$00000107,$000000e7,
$00000142,$000000eb,$00000150,$00000151,$000000ee,$00000179,$000000c4,$00000106,
$000000c9,$00000139,$0000013a,$000000f4,$000000f6,$0000013d,$0000013e,$0000015a,
$0000015b,$000000d6,$000000dc,$00000164,$00000165,$00000141,$000000d7,$0000010d,
$000000e1,$000000ed,$000000f3,$000000fa,$00000104,$00000105,$0000017d,$0000017e,
$00000118,$00000119,$000000ac,$0000017a,$0000010c,$0000015f,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$000000c1,$000000c2,$0000011a,
$0000015e,$00002563,$00002551,$00002557,$0000255d,$0000017b,$0000017c,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$00000102,$00000103,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000000a4,
$00000111,$00000110,$0000010e,$000000cb,$0000010f,$00000147,$000000cd,$000000ce,
$0000011b,$00002518,$0000250c,$00002588,$00002584,$00000162,$0000016e,$00002580,
$000000d3,$000000df,$000000d4,$00000143,$00000144,$00000148,$00000160,$00000161,
$00000154,$000000da,$00000155,$00000170,$000000fd,$000000dd,$00000163,$000000b4,
$000000ad,$000002dd,$000002db,$000002c7,$000002d8,$000000a7,$000000f7,$000000b8,
$000000b0,$000000a8,$000002d9,$00000171,$00000158,$00000159,$000025a0,$000000a0);
const PUCUCharSetCodePage855:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000452,$00000402,$00000453,$00000403,$00000451,$00000401,$00000454,$00000404,
$00000455,$00000405,$00000456,$00000406,$00000457,$00000407,$00000458,$00000408,
$00000459,$00000409,$0000045a,$0000040a,$0000045b,$0000040b,$0000045c,$0000040c,
$0000045e,$0000040e,$0000045f,$0000040f,$0000044e,$0000042e,$0000044a,$0000042a,
$00000430,$00000410,$00000431,$00000411,$00000446,$00000426,$00000434,$00000414,
$00000435,$00000415,$00000444,$00000424,$00000433,$00000413,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00000445,$00000425,$00000438,
$00000418,$00002563,$00002551,$00002557,$0000255d,$00000439,$00000419,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000043a,$0000041a,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000000a4,
$0000043b,$0000041b,$0000043c,$0000041c,$0000043d,$0000041d,$0000043e,$0000041e,
$0000043f,$00002518,$0000250c,$00002588,$00002584,$0000041f,$0000044f,$00002580,
$0000042f,$00000440,$00000420,$00000441,$00000421,$00000442,$00000422,$00000443,
$00000423,$00000436,$00000416,$00000432,$00000412,$0000044c,$0000042c,$00002116,
$000000ad,$0000044b,$0000042b,$00000437,$00000417,$00000448,$00000428,$0000044d,
$0000042d,$00000449,$00000429,$00000447,$00000427,$000000a7,$000025a0,$000000a0);
const PUCUCharSetCodePage857:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$00000131,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000f2,$000000fb,$000000f9,
$00000130,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$0000015e,$0000015f,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$0000011e,$0000011f,
$000000bf,$000000ae,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$000000c1,$000000c2,$000000c0,
$000000a9,$00002563,$00002551,$00002557,$0000255d,$000000a2,$000000a5,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$000000e3,$000000c3,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000000a4,
$000000ba,$000000aa,$000000ca,$000000cb,$000000c8,$0000f8bb,$000000cd,$000000ce,
$000000cf,$00002518,$0000250c,$00002588,$00002584,$000000a6,$000000cc,$00002580,
$000000d3,$000000df,$000000d4,$000000d2,$000000f5,$000000d5,$000000b5,$0000f8bc,
$000000d7,$000000da,$000000db,$000000d9,$000000ec,$000000ff,$000000af,$000000b4,
$000000ad,$000000b1,$0000f8bd,$000000be,$000000b6,$000000a7,$000000f7,$000000b8,
$000000b0,$000000a8,$000000b7,$000000b9,$000000b3,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage858:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$000000ec,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000f2,$000000fb,$000000f9,
$000000ff,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$000000d7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$000000ae,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$000000c1,$000000c2,$000000c0,
$000000a9,$00002563,$00002551,$00002557,$0000255d,$000000a2,$000000a5,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$000000e3,$000000c3,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000000a4,
$000000f0,$000000d0,$000000ca,$000000cb,$000000c8,$000020ac,$000000cd,$000000ce,
$000000cf,$00002518,$0000250c,$00002588,$00002584,$000000a6,$000000cc,$00002580,
$000000d3,$000000df,$000000d4,$000000d2,$000000f5,$000000d5,$000000b5,$000000fe,
$000000de,$000000da,$000000db,$000000d9,$000000fd,$000000dd,$000000af,$000000b4,
$000000ad,$000000b1,$00002017,$000000be,$000000b6,$000000a7,$000000f7,$000000b8,
$000000b0,$000000a8,$000000b7,$000000b9,$000000b3,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage860:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e3,$000000e0,$000000c1,$000000e7,
$000000ea,$000000ca,$000000e8,$000000cd,$000000d4,$000000ec,$000000c3,$000000c2,
$000000c9,$000000c0,$000000c8,$000000f4,$000000f5,$000000f2,$000000da,$000000f9,
$000000cc,$000000d5,$000000dc,$000000a2,$000000a3,$000000d9,$000020a7,$000000d3,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$000000d2,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage861:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000d0,$000000f0,$000000de,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000fe,$000000fb,$000000dd,
$000000fd,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$000020a7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000c1,$000000cd,$000000d3,$000000da,
$000000bf,$00002310,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage862:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,$000005d7,
$000005d8,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000005ea,$000000a2,$000000a3,$000000a5,$000020a7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$00002310,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage863:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000c2,$000000e0,$000000b6,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$00002017,$000000c0,$000000a7,
$000000c9,$000000c8,$000000ca,$000000f4,$000000cb,$000000cf,$000000fb,$000000f9,
$000000a4,$000000d4,$000000dc,$000000a2,$000000a3,$000000d9,$000000db,$00000192,
$000000a6,$000000b4,$000000f3,$000000fa,$000000a8,$000000b8,$000000b3,$000000af,
$000000ce,$00002310,$000000ac,$000000bd,$000000bc,$000000be,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage864:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000b0,$000000b7,$00002219,$0000221a,$00002592,$00002500,$00002502,$0000253c,
$00002524,$0000252c,$0000251c,$00002534,$00002510,$0000250c,$00002514,$00002518,
$000003b2,$0000221e,$000003c6,$000000b1,$000000bd,$000000bc,$00002248,$000000ab,
$000000bb,$0000fef7,$0000fef8,$0000009b,$0000009c,$0000fefb,$0000fefc,$0000009f,
$000000a0,$000000ad,$0000fe82,$000000a3,$000000a4,$0000fe84,$0000f8be,$0000f8bf,
$0000fe8e,$0000fe8f,$0000fe95,$0000fe99,$0000060c,$0000fe9d,$0000fea1,$0000fea5,
$00000660,$00000661,$00000662,$00000663,$00000664,$00000665,$00000666,$00000667,
$00000668,$00000669,$0000fed1,$0000061b,$0000feb1,$0000feb5,$0000feb9,$0000061f,
$000000a2,$0000fe80,$0000fe81,$0000fe83,$0000fe85,$0000feca,$0000fe8b,$0000fe8d,
$0000fe91,$0000fe93,$0000fe97,$0000fe9b,$0000fe9f,$0000fea3,$0000fea7,$0000fea9,
$0000feab,$0000fead,$0000feaf,$0000feb3,$0000feb7,$0000febb,$0000febf,$0000fec1,
$0000fec5,$0000fecb,$0000fecf,$000000a6,$000000ac,$000000f7,$000000d7,$0000fec9,
$00000640,$0000fed3,$0000fed7,$0000fedb,$0000fedf,$0000fee3,$0000fee7,$0000feeb,
$0000feed,$0000feef,$0000fef3,$0000febd,$0000fecc,$0000fece,$0000fecd,$0000fee1,
$0000fe7d,$00000651,$0000fee5,$0000fee9,$0000feec,$0000fef0,$0000fef2,$0000fed0,
$0000fed5,$0000fef5,$0000fef6,$0000fedd,$0000fed9,$0000fef1,$000025a0,$0000f8c0);
const PUCUCharSetCodePage865:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c7,$000000fc,$000000e9,$000000e2,$000000e4,$000000e0,$000000e5,$000000e7,
$000000ea,$000000eb,$000000e8,$000000ef,$000000ee,$000000ec,$000000c4,$000000c5,
$000000c9,$000000e6,$000000c6,$000000f4,$000000f6,$000000f2,$000000fb,$000000f9,
$000000ff,$000000d6,$000000dc,$000000f8,$000000a3,$000000d8,$000020a7,$00000192,
$000000e1,$000000ed,$000000f3,$000000fa,$000000f1,$000000d1,$000000aa,$000000ba,
$000000bf,$00002310,$000000ac,$000000bd,$000000bc,$000000a1,$000000ab,$000000a4,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$000003b1,$000000df,$00000393,$000003c0,$000003a3,$000003c3,$000000b5,$000003c4,
$000003a6,$00000398,$000003a9,$000003b4,$0000221e,$000003c6,$000003b5,$00002229,
$00002261,$000000b1,$00002265,$00002264,$00002320,$00002321,$000000f7,$00002248,
$000000b0,$00002219,$000000b7,$0000221a,$0000207f,$000000b2,$000025a0,$000000a0);
const PUCUCharSetCodePage866:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000410,$00000411,$00000412,$00000413,$00000414,$00000415,$00000416,$00000417,
$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,$0000041f,
$00000420,$00000421,$00000422,$00000423,$00000424,$00000425,$00000426,$00000427,
$00000428,$00000429,$0000042a,$0000042b,$0000042c,$0000042d,$0000042e,$0000042f,
$00000430,$00000431,$00000432,$00000433,$00000434,$00000435,$00000436,$00000437,
$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$00002591,$00002592,$00002593,$00002502,$00002524,$00002561,$00002562,$00002556,
$00002555,$00002563,$00002551,$00002557,$0000255d,$0000255c,$0000255b,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$0000255e,$0000255f,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$00002567,
$00002568,$00002564,$00002565,$00002559,$00002558,$00002552,$00002553,$0000256b,
$0000256a,$00002518,$0000250c,$00002588,$00002584,$0000258c,$00002590,$00002580,
$00000440,$00000441,$00000442,$00000443,$00000444,$00000445,$00000446,$00000447,
$00000448,$00000449,$0000044a,$0000044b,$0000044c,$0000044d,$0000044e,$0000044f,
$00000401,$00000451,$00000404,$00000454,$00000407,$00000457,$0000040e,$0000045e,
$000000b0,$00002219,$000000b7,$0000221a,$00002116,$000000a4,$000025a0,$000000a0);
const PUCUCharSetCodePage869:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000386,$00000087,
$000000b7,$000000ac,$000000a6,$00002018,$00002019,$00000388,$00002015,$00000389,
$0000038a,$000003aa,$0000038c,$00000093,$00000094,$0000038e,$000003ab,$000000a9,
$0000038f,$000000b2,$000000b3,$000003ac,$000000a3,$000003ad,$000003ae,$000003af,
$000003ca,$00000390,$000003cc,$000003cd,$00000391,$00000392,$00000393,$00000394,
$00000395,$00000396,$00000397,$000000bd,$00000398,$00000399,$000000ab,$000000bb,
$00002591,$00002592,$00002593,$00002502,$00002524,$0000039a,$0000039b,$0000039c,
$0000039d,$00002563,$00002551,$00002557,$0000255d,$0000039e,$0000039f,$00002510,
$00002514,$00002534,$0000252c,$0000251c,$00002500,$0000253c,$000003a0,$000003a1,
$0000255a,$00002554,$00002569,$00002566,$00002560,$00002550,$0000256c,$000003a3,
$000003a4,$000003a5,$000003a6,$000003a7,$000003a8,$000003a9,$000003b1,$000003b2,
$000003b3,$00002518,$0000250c,$00002588,$00002584,$000003b4,$000003b5,$00002580,
$000003b6,$000003b7,$000003b8,$000003b9,$000003ba,$000003bb,$000003bc,$000003bd,
$000003be,$000003bf,$000003c0,$000003c1,$000003c3,$000003c2,$000003c4,$00000384,
$000000ad,$000000b1,$000003c5,$000003c6,$000003c7,$000000a7,$000003c8,$00000385,
$000000b0,$000000a8,$000003c9,$000003cb,$000003b0,$000003ce,$000025a0,$000000a0);
const PUCUCharSetCodePage870:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$00000163,$000000e1,$00000103,$0000010d,
$000000e7,$00000107,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$00000119,$000000eb,$0000016f,$000000ed,$000000ee,$0000013e,
$0000013a,$000000df,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000002dd,$000000c1,$00000102,$0000010c,
$000000c7,$00000106,$0000007c,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000002c7,$000000c9,$00000118,$000000cb,$0000016e,$000000cd,$000000ce,$0000013d,
$00000139,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000002d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000015b,$00000148,$00000111,$000000fd,$00000159,$0000015f,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$00000142,$00000144,$00000161,$000000b8,$000002db,$000000a4,
$00000105,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000015a,$00000147,$00000110,$000000dd,$00000158,$0000015e,
$000002d9,$00000104,$0000017c,$00000162,$0000017b,$000000a7,$0000017e,$0000017a,
$0000017d,$00000179,$00000141,$00000143,$00000160,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$00000155,$000000f3,$00000151,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000011a,$00000171,$000000fc,$00000165,$000000fa,$0000011b,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$0000010f,$000000d4,$000000d6,$00000154,$000000d3,$00000150,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000010e,$00000170,$000000dc,$00000164,$000000da,$0000009f);
const PUCUCharSetCodePage874:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$00000082,$00000083,$00000084,$00002026,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000e01,$00000e02,$00000e03,$00000e04,$00000e05,$00000e06,$00000e07,
$00000e08,$00000e09,$00000e0a,$00000e0b,$00000e0c,$00000e0d,$00000e0e,$00000e0f,
$00000e10,$00000e11,$00000e12,$00000e13,$00000e14,$00000e15,$00000e16,$00000e17,
$00000e18,$00000e19,$00000e1a,$00000e1b,$00000e1c,$00000e1d,$00000e1e,$00000e1f,
$00000e20,$00000e21,$00000e22,$00000e23,$00000e24,$00000e25,$00000e26,$00000e27,
$00000e28,$00000e29,$00000e2a,$00000e2b,$00000e2c,$00000e2d,$00000e2e,$00000e2f,
$00000e30,$00000e31,$00000e32,$00000e33,$00000e34,$00000e35,$00000e36,$00000e37,
$00000e38,$00000e39,$00000e3a,$0000f8c1,$0000f8c2,$0000f8c3,$0000f8c4,$00000e3f,
$00000e40,$00000e41,$00000e42,$00000e43,$00000e44,$00000e45,$00000e46,$00000e47,
$00000e48,$00000e49,$00000e4a,$00000e4b,$00000e4c,$00000e4d,$00000e4e,$00000e4f,
$00000e50,$00000e51,$00000e52,$00000e53,$00000e54,$00000e55,$00000e56,$00000e57,
$00000e58,$00000e59,$00000e5a,$00000e5b,$0000f8c5,$0000f8c6,$0000f8c7,$0000f8c8);
const PUCUCharSetCodePage875:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$00000391,$00000392,$00000393,$00000394,$00000395,$00000396,$00000397,
$00000398,$00000399,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000039a,$0000039b,$0000039c,$0000039d,$0000039e,$0000039f,$000003a0,
$000003a1,$000003a3,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000003a4,$000003a5,$000003a6,$000003a7,$000003a8,$000003a9,
$000003aa,$000003ab,$0000007c,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000a8,$00000386,$00000388,$00000389,$000000a0,$0000038a,$0000038c,$0000038e,
$0000038f,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$00000385,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000003b1,$000003b2,$000003b3,$000003b4,$000003b5,$000003b6,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000003b7,$000003b8,$000003b9,$000003ba,$000003bb,$000003bc,
$000000b4,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000003bd,$000003be,$000003bf,$000003c0,$000003c1,$000003c3,
$000000a3,$000003ac,$000003ad,$000003ae,$000003ca,$000003af,$000003cc,$000003cd,
$000003cb,$000003ce,$000003c2,$000003c4,$000003c5,$000003c6,$000003c7,$000003c8,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000003c9,$00000390,$000003b0,$00002018,$00002015,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b1,$000000bd,$0000001a,$00000387,$00002019,$000000a6,
$0000005c,$0000001a,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000a7,$0000001a,$0000001a,$000000ab,$000000ac,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000a9,$0000001a,$0000001a,$000000bb,$0000009f);
const PUCUCharSetCodePage1026:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$0000007b,$000000f1,$000000c7,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000011e,$00000130,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$0000005b,$000000d1,$0000015f,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000131,$0000003a,$000000d6,$0000015e,$00000027,$0000003d,$000000dc,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$0000007d,$00000060,$000000a6,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$000000f6,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$0000005d,$00000024,$00000040,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e7,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$0000007e,$000000f2,$000000f3,$000000f5,
$0000011f,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000005c,$000000f9,$000000fa,$000000ff,
$000000fc,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$00000023,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$00000022,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1047:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$0000000a,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$0000005b,$000000de,$000000ae,
$000000ac,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000dd,$000000a8,$000000af,$0000005d,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1140:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$0000005e,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005b,$0000005d,$000000af,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1141:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$0000007b,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000c4,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$0000007e,$000000dc,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$0000005b,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$000000a7,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$000000df,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$00000040,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e4,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000a6,$000000f2,$000000f3,$000000f5,
$000000fc,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007d,$000000f9,$000000fa,$000000ff,
$000000d6,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$0000005c,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$0000005d,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1142:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$0000007d,
$000000e7,$000000f1,$00000023,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000020ac,$000000c5,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$00000024,
$000000c7,$000000d1,$000000f8,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000a6,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$000000c6,$000000d8,$00000027,$0000003d,$00000022,
$00000040,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$0000007b,$000000b8,$0000005b,$0000005d,
$000000b5,$000000fc,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e6,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$000000e5,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007e,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1143:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$0000007b,$000000e0,$000000e1,$000000e3,$0000007d,
$000000e7,$000000f1,$000000a7,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$00000060,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000020ac,$000000c5,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$00000023,$000000c0,$000000c1,$000000c3,$00000024,
$000000c7,$000000d1,$000000f6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$0000005c,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000e9,$0000003a,$000000c4,$000000d6,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$0000005d,
$000000b5,$000000fc,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$0000005b,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e4,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000a6,$000000f2,$000000f3,$000000f5,
$000000e5,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007e,$000000f9,$000000fa,$000000ff,
$000000c9,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$00000040,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1144:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$0000007b,$000000e1,$000000e3,$000000e5,
$0000005c,$000000f1,$000000b0,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000005d,$000000ea,$000000eb,$0000007d,$000000ed,$000000ee,$000000ef,
$0000007e,$000000df,$000000e9,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f2,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000f9,$0000003a,$000000a3,$000000a7,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$0000005b,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$000000ec,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$00000023,$000000a5,$000000b7,$000000a9,$00000040,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e0,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000a6,$000000f3,$000000f5,
$000000e8,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$00000060,$000000fa,$000000ff,
$000000e7,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1145:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000a6,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$00000023,$000000f1,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$000000d1,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$000000a8,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005e,$00000021,$000000af,$0000007e,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1146:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$00000024,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$000000a3,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$000000af,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$0000005b,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005e,$0000005d,$0000007e,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1147:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$00000040,$000000e1,$000000e3,$000000e5,
$0000005c,$000000f1,$000000b0,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000007b,$000000ea,$000000eb,$0000007d,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000a7,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f9,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000b5,$0000003a,$000000a3,$000000e0,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$0000005b,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$00000060,$000000a8,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$00000023,$000000a5,$000000b7,$000000a9,$0000005d,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$0000007e,$000000b4,$000000d7,
$000000e9,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$000000e8,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000a6,$000000fa,$000000ff,
$000000e7,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1148:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000020ac,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1149:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000de,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000c6,$00000024,$0000002a,$00000029,$0000003b,$000000d6,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000f0,$0000003a,$00000023,$000000d0,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$00000060,$000000fd,$0000007b,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$0000007d,$000000b8,$0000005d,$000020ac,
$000000b5,$000000f6,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$00000040,$000000dd,$0000005b,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$0000005c,$000000d7,
$000000fe,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$0000007e,$000000f2,$000000f3,$000000f5,
$000000e6,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$000000b4,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$0000005e,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage1250:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000083,$0000201e,$00002026,$00002020,$00002021,
$00000088,$00002030,$00000160,$00002039,$0000015a,$00000164,$0000017d,$00000179,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$00000098,$00002122,$00000161,$0000203a,$0000015b,$00000165,$0000017e,$0000017a,
$000000a0,$000002c7,$000002d8,$00000141,$000000a4,$00000104,$000000a6,$000000a7,
$000000a8,$000000a9,$0000015e,$000000ab,$000000ac,$000000ad,$000000ae,$0000017b,
$000000b0,$000000b1,$000002db,$00000142,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$00000105,$0000015f,$000000bb,$0000013d,$000002dd,$0000013e,$0000017c,
$00000154,$000000c1,$000000c2,$00000102,$000000c4,$00000139,$00000106,$000000c7,
$0000010c,$000000c9,$00000118,$000000cb,$0000011a,$000000cd,$000000ce,$0000010e,
$00000110,$00000143,$00000147,$000000d3,$000000d4,$00000150,$000000d6,$000000d7,
$00000158,$0000016e,$000000da,$00000170,$000000dc,$000000dd,$00000162,$000000df,
$00000155,$000000e1,$000000e2,$00000103,$000000e4,$0000013a,$00000107,$000000e7,
$0000010d,$000000e9,$00000119,$000000eb,$0000011b,$000000ed,$000000ee,$0000010f,
$00000111,$00000144,$00000148,$000000f3,$000000f4,$00000151,$000000f6,$000000f7,
$00000159,$0000016f,$000000fa,$00000171,$000000fc,$000000fd,$00000163,$000002d9);
const PUCUCharSetCodePage1251:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000402,$00000403,$0000201a,$00000453,$0000201e,$00002026,$00002020,$00002021,
$000020ac,$00002030,$00000409,$00002039,$0000040a,$0000040c,$0000040b,$0000040f,
$00000452,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$00000098,$00002122,$00000459,$0000203a,$0000045a,$0000045c,$0000045b,$0000045f,
$000000a0,$0000040e,$0000045e,$00000408,$000000a4,$00000490,$000000a6,$000000a7,
$00000401,$000000a9,$00000404,$000000ab,$000000ac,$000000ad,$000000ae,$00000407,
$000000b0,$000000b1,$00000406,$00000456,$00000491,$000000b5,$000000b6,$000000b7,
$00000451,$00002116,$00000454,$000000bb,$00000458,$00000405,$00000455,$00000457,
$00000410,$00000411,$00000412,$00000413,$00000414,$00000415,$00000416,$00000417,
$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,$0000041f,
$00000420,$00000421,$00000422,$00000423,$00000424,$00000425,$00000426,$00000427,
$00000428,$00000429,$0000042a,$0000042b,$0000042c,$0000042d,$0000042e,$0000042f,
$00000430,$00000431,$00000432,$00000433,$00000434,$00000435,$00000436,$00000437,
$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$00000440,$00000441,$00000442,$00000443,$00000444,$00000445,$00000446,$00000447,
$00000448,$00000449,$0000044a,$0000044b,$0000044c,$0000044d,$0000044e,$0000044f);
const PUCUCharSetCodePage1252:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$000002c6,$00002030,$00000160,$00002039,$00000152,$0000008d,$0000017d,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$000002dc,$00002122,$00000161,$0000203a,$00000153,$0000009d,$0000017e,$00000178,
$000000a0,$000000a1,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000ba,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000000c0,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$000000d0,$000000d1,$000000d2,$000000d3,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$000000dd,$000000de,$000000df,
$000000e0,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$000000f0,$000000f1,$000000f2,$000000f3,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$000000fd,$000000fe,$000000ff);
const PUCUCharSetCodePage1253:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$00000088,$00002030,$0000008a,$00002039,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$00000098,$00002122,$0000009a,$0000203a,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000385,$00000386,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$0000f8f9,$000000ab,$000000ac,$000000ad,$000000ae,$00002015,
$000000b0,$000000b1,$000000b2,$000000b3,$00000384,$000000b5,$000000b6,$000000b7,
$00000388,$00000389,$0000038a,$000000bb,$0000038c,$000000bd,$0000038e,$0000038f,
$00000390,$00000391,$00000392,$00000393,$00000394,$00000395,$00000396,$00000397,
$00000398,$00000399,$0000039a,$0000039b,$0000039c,$0000039d,$0000039e,$0000039f,
$000003a0,$000003a1,$0000f8fa,$000003a3,$000003a4,$000003a5,$000003a6,$000003a7,
$000003a8,$000003a9,$000003aa,$000003ab,$000003ac,$000003ad,$000003ae,$000003af,
$000003b0,$000003b1,$000003b2,$000003b3,$000003b4,$000003b5,$000003b6,$000003b7,
$000003b8,$000003b9,$000003ba,$000003bb,$000003bc,$000003bd,$000003be,$000003bf,
$000003c0,$000003c1,$000003c2,$000003c3,$000003c4,$000003c5,$000003c6,$000003c7,
$000003c8,$000003c9,$000003ca,$000003cb,$000003cc,$000003cd,$000003ce,$0000f8fb);
const PUCUCharSetCodePage1254:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$000002c6,$00002030,$00000160,$00002039,$00000152,$0000008d,$0000008e,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$000002dc,$00002122,$00000161,$0000203a,$00000153,$0000009d,$0000009e,$00000178,
$000000a0,$000000a1,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000ba,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000000c0,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$0000011e,$000000d1,$000000d2,$000000d3,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$00000130,$0000015e,$000000df,
$000000e0,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$0000011f,$000000f1,$000000f2,$000000f3,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$00000131,$0000015f,$000000ff);
const PUCUCharSetCodePage1255:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$000002c6,$00002030,$0000008a,$00002039,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$000002dc,$00002122,$0000009a,$0000203a,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$000000a1,$000000a2,$000000a3,$000020aa,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000d7,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000f7,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000005b0,$000005b1,$000005b2,$000005b3,$000005b4,$000005b5,$000005b6,$000005b7,
$000005b8,$000005b9,$000005ba,$000005bb,$000005bc,$000005bd,$000005be,$000005bf,
$000005c0,$000005c1,$000005c2,$000005c3,$000005f0,$000005f1,$000005f2,$000005f3,
$000005f4,$0000f88d,$0000f88e,$0000f88f,$0000f890,$0000f891,$0000f892,$0000f893,
$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,$000005d7,
$000005d8,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000005ea,$0000f894,$0000f895,$0000200e,$0000200f,$0000f896);
const PUCUCharSetCodePage1256:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$0000067e,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$000002c6,$00002030,$00000679,$00002039,$00000152,$00000686,$00000698,$00000688,
$000006af,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$000006a9,$00002122,$00000691,$0000203a,$00000153,$0000200c,$0000200d,$000006ba,
$000000a0,$0000060c,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000006be,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$0000061b,$000000bb,$000000bc,$000000bd,$000000be,$0000061f,
$000006c1,$00000621,$00000622,$00000623,$00000624,$00000625,$00000626,$00000627,
$00000628,$00000629,$0000062a,$0000062b,$0000062c,$0000062d,$0000062e,$0000062f,
$00000630,$00000631,$00000632,$00000633,$00000634,$00000635,$00000636,$000000d7,
$00000637,$00000638,$00000639,$0000063a,$00000640,$00000641,$00000642,$00000643,
$000000e0,$00000644,$000000e2,$00000645,$00000646,$00000647,$00000648,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$00000649,$0000064a,$000000ee,$000000ef,
$0000064b,$0000064c,$0000064d,$0000064e,$000000f4,$0000064f,$00000650,$000000f7,
$00000651,$000000f9,$00000652,$000000fb,$000000fc,$0000200e,$0000200f,$000006d2);
const PUCUCharSetCodePage1257:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000083,$0000201e,$00002026,$00002020,$00002021,
$00000088,$00002030,$0000008a,$00002039,$0000008c,$000000a8,$000002c7,$000000b8,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$00000098,$00002122,$0000009a,$0000203a,$0000009c,$000000af,$000002db,$0000009f,
$000000a0,$0000f8fc,$000000a2,$000000a3,$000000a4,$0000f8fd,$000000a6,$000000a7,
$000000d8,$000000a9,$00000156,$000000ab,$000000ac,$000000ad,$000000ae,$000000c6,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000f8,$000000b9,$00000157,$000000bb,$000000bc,$000000bd,$000000be,$000000e6,
$00000104,$0000012e,$00000100,$00000106,$000000c4,$000000c5,$00000118,$00000112,
$0000010c,$000000c9,$00000179,$00000116,$00000122,$00000136,$0000012a,$0000013b,
$00000160,$00000143,$00000145,$000000d3,$0000014c,$000000d5,$000000d6,$000000d7,
$00000172,$00000141,$0000015a,$0000016a,$000000dc,$0000017b,$0000017d,$000000df,
$00000105,$0000012f,$00000101,$00000107,$000000e4,$000000e5,$00000119,$00000113,
$0000010d,$000000e9,$0000017a,$00000117,$00000123,$00000137,$0000012b,$0000013c,
$00000161,$00000144,$00000146,$000000f3,$0000014d,$000000f5,$000000f6,$000000f7,
$00000173,$00000142,$0000015b,$0000016b,$000000fc,$0000017c,$0000017e,$000002d9);
const PUCUCharSetCodePage1258:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000020ac,$00000081,$0000201a,$00000192,$0000201e,$00002026,$00002020,$00002021,
$000002c6,$00002030,$0000008a,$00002039,$00000152,$0000008d,$0000008e,$0000008f,
$00000090,$00002018,$00002019,$0000201c,$0000201d,$00002022,$00002013,$00002014,
$000002dc,$00002122,$0000009a,$0000203a,$00000153,$0000009d,$0000009e,$00000178,
$000000a0,$000000a1,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000ba,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000000c0,$000000c1,$000000c2,$00000102,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$00000300,$000000cd,$000000ce,$000000cf,
$00000110,$000000d1,$00000309,$000000d3,$000000d4,$000001a0,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$000001af,$00000303,$000000df,
$000000e0,$000000e1,$000000e2,$00000103,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$00000301,$000000ed,$000000ee,$000000ef,
$00000111,$000000f1,$00000323,$000000f3,$000000f4,$000001a1,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$000001b0,$000020ab,$000000ff);
const PUCUCharSetCodePage10000:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$00002020,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$000000a9,$00002122,$000000b4,$000000a8,$00002260,$000000c6,$000000d8,
$0000221e,$000000b1,$00002264,$00002265,$000000a5,$000000b5,$00002202,$00002211,
$0000220f,$000003c0,$0000222b,$000000aa,$000000ba,$00002126,$000000e6,$000000f8,
$000000bf,$000000a1,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$000000c0,$000000c3,$000000d5,$00000152,$00000153,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$000000ff,$00000178,$00002044,$000020ac,$00002039,$0000203a,$0000fb01,$0000fb02,
$00002021,$000000b7,$0000201a,$0000201e,$00002030,$000000c2,$000000ca,$000000c1,
$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,$000000cc,$000000d3,$000000d4,
$0000f8ff,$000000d2,$000000da,$000000db,$000000d9,$00000131,$000002c6,$000002dc,
$000000af,$000002d8,$000002d9,$000002da,$000000b8,$000002dd,$000002db,$000002c7);
const PUCUCharSetCodePage10004:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000a0,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000006ba,$000000ab,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$00002026,$000000ee,$000000ef,$000000f1,$000000f3,
$000000bb,$000000f4,$000000f6,$000000f7,$000000fa,$000000f9,$000000fb,$000000fc,
$0000f827,$0000f828,$0000f829,$0000f82a,$0000f82b,$0000066a,$0000f82c,$0000f82d,
$0000f82e,$0000f82f,$0000f830,$0000f831,$0000060c,$0000f832,$0000f833,$0000f834,
$00000660,$00000661,$00000662,$00000663,$00000664,$00000665,$00000666,$00000667,
$00000668,$00000669,$0000f835,$0000061b,$0000f836,$0000f837,$0000f838,$0000061f,
$0000066d,$00000621,$00000622,$00000623,$00000624,$00000625,$00000626,$00000627,
$00000628,$00000629,$0000062a,$0000062b,$0000062c,$0000062d,$0000062e,$0000062f,
$00000630,$00000631,$00000632,$00000633,$00000634,$00000635,$00000636,$00000637,
$00000638,$00000639,$0000063a,$0000f839,$0000f83a,$0000f83b,$0000f83c,$0000f83d,
$00000640,$00000641,$00000642,$00000643,$00000644,$00000645,$00000646,$00000647,
$00000648,$00000649,$0000064a,$0000064b,$0000064c,$0000064d,$0000064e,$0000064f,
$00000650,$00000651,$00000652,$0000067e,$00000679,$00000686,$000006d5,$000006a4,
$000006af,$00000688,$00000691,$0000f83e,$0000f83f,$0000f840,$00000698,$000006d2);
const PUCUCharSetCodePage10005:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$0000f7fc,$0000f7fd,$0000f7fe,$0000f7ff,$000000a4,$0000f800,$000020aa,$0000f801,
$0000f802,$0000f803,$0000f804,$0000f805,$0000f806,$0000f807,$0000f808,$0000f809,
$0000f80a,$0000f80b,$0000f80c,$0000f80d,$0000f80e,$0000f80f,$0000f810,$0000f811,
$0000f812,$0000f813,$0000f814,$0000f815,$0000f816,$0000f817,$0000f818,$0000f819,
$0000f81a,$0000201e,$0000f81b,$0000f81c,$0000f81d,$000005bd,$000005bc,$0000f81e,
$0000f81f,$00002026,$000000a0,$000005b8,$000005b7,$000005b5,$000005b6,$000005b4,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$0000f820,$0000f821,
$000005be,$000005b0,$000005b2,$000005b1,$000005bb,$000005c1,$000005b8,$000005b3,
$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,$000005d7,
$000005d8,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000005ea,$0000f822,$0000f823,$0000f824,$0000f825,$0000f826);
const PUCUCharSetCodePage10006:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000b9,$000000b2,$000000c9,$000000b3,$000000d6,$000000dc,$00000385,
$000000e0,$000000e2,$000000e4,$00000384,$000000a8,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000a3,$00002122,$000000ee,$000000ef,$00002022,$000000bd,
$00002030,$000000f4,$000000f6,$000000a6,$000000ad,$000000f9,$000000fb,$000000fc,
$00002020,$00000393,$00000394,$00000398,$0000039b,$0000039e,$000003a0,$000000df,
$000000ae,$000000a9,$000003a3,$000003aa,$000000a7,$00002260,$000000b0,$00000387,
$00000391,$000000b1,$00002264,$00002265,$000000a5,$00000392,$00000395,$00000396,
$00000397,$00000399,$0000039a,$0000039c,$000003a6,$000003ab,$000003a8,$000003a9,
$000003ac,$0000039d,$000000ac,$0000039f,$000003a1,$00002248,$000003a4,$000000ab,
$000000bb,$00002026,$000000a0,$000003a5,$000003a7,$00000386,$00000388,$00000153,
$00002013,$00002015,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$00000389,
$0000038a,$0000038c,$0000038e,$000003ad,$000003ae,$000003af,$000003cc,$0000038f,
$000003cd,$000003b1,$000003b2,$000003c8,$000003b4,$000003b5,$000003c6,$000003b3,
$000003b7,$000003b9,$000003be,$000003ba,$000003bb,$000003bc,$000003bd,$000003bf,
$000003c0,$000003ce,$000003c1,$000003c3,$000003c4,$000003b8,$000003c9,$000003c2,
$000003c7,$000003c5,$000003b6,$000003ca,$000003cb,$00000390,$000003b0,$0000f8a0);
const PUCUCharSetCodePage10007:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000410,$00000411,$00000412,$00000413,$00000414,$00000415,$00000416,$00000417,
$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,$0000041f,
$00000420,$00000421,$00000422,$00000423,$00000424,$00000425,$00000426,$00000427,
$00000428,$00000429,$0000042a,$0000042b,$0000042c,$0000042d,$0000042e,$0000042f,
$00002020,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$00000406,
$000000ae,$000000a9,$00002122,$00000402,$00000452,$00002260,$00000403,$00000453,
$0000221e,$000000b1,$00002264,$00002265,$00000456,$000000b5,$00002202,$00000408,
$00000404,$00000454,$00000407,$00000457,$00000409,$00000459,$0000040a,$0000045a,
$00000458,$00000405,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$0000040b,$0000045b,$0000040c,$0000045c,$00000455,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$0000201e,
$0000040e,$0000045e,$0000040f,$0000045f,$00002116,$00000401,$00000451,$0000044f,
$00000430,$00000431,$00000432,$00000433,$00000434,$00000435,$00000436,$00000437,
$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$00000440,$00000441,$00000442,$00000443,$00000444,$00000445,$00000446,$00000447,
$00000448,$00000449,$0000044a,$0000044b,$0000044c,$0000044d,$0000044e,$000000a4);
const PUCUCharSetCodePage10010:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$00002020,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$000000a9,$00002122,$000000b4,$000000a8,$00002260,$00000102,$0000015e,
$0000221e,$000000b1,$00002264,$00002265,$000000a5,$000000b5,$00002202,$00002211,
$0000220f,$000003c0,$0000222b,$000000aa,$000000ba,$00002126,$00000103,$0000015f,
$000000bf,$000000a1,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$000000c0,$000000c3,$000000d5,$00000152,$00000153,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$000000ff,$00000178,$00002044,$000000a4,$00002039,$0000203a,$00000162,$00000163,
$00002021,$000000b7,$0000201a,$0000201e,$00002030,$000000c2,$000000ca,$000000c1,
$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,$000000cc,$000000d3,$000000d4,
$0000f8ff,$000000d2,$000000da,$000000db,$000000d9,$00000131,$000002c6,$000002dc,
$000000af,$000002d8,$000002d9,$000002da,$000000b8,$000002dd,$000002db,$000002c7);
const PUCUCharSetCodePage10017:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000410,$00000411,$00000412,$00000413,$00000414,$00000415,$00000416,$00000417,
$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,$0000041f,
$00000420,$00000421,$00000422,$00000423,$00000424,$00000425,$00000426,$00000427,
$00000428,$00000429,$0000042a,$0000042b,$0000042c,$0000042d,$0000042e,$0000042f,
$00002020,$000000b0,$00000490,$000000a3,$000000a7,$00002022,$000000b6,$00000406,
$000000ae,$000000a9,$00002122,$00000402,$00000452,$00002260,$00000403,$00000453,
$0000221e,$000000b1,$00002264,$00002265,$00000456,$000000b5,$00000491,$00000408,
$00000404,$00000454,$00000407,$00000457,$00000409,$00000459,$0000040a,$0000045a,
$00000458,$00000405,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$0000040b,$0000045b,$0000040c,$0000045c,$00000455,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$0000201e,
$0000040e,$0000045e,$0000040f,$0000045f,$00002116,$00000401,$00000451,$0000044f,
$00000430,$00000431,$00000432,$00000433,$00000434,$00000435,$00000436,$00000437,
$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$00000440,$00000441,$00000442,$00000443,$00000444,$00000445,$00000446,$00000447,
$00000448,$00000449,$0000044a,$0000044b,$0000044c,$0000044d,$0000044e,$000000a4);
const PUCUCharSetCodePage10021:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$00000000,
$000000ab,$000000bb,$00002026,$00000e48,$00000e49,$00000e4a,$00000e4b,$00000e4c,
$00000e48,$00000e49,$00000e4a,$00000e4b,$00000e4c,$0000201c,$0000201d,$00000e4d,
$00000000,$00002022,$00000e31,$00000e47,$00000e34,$00000e35,$00000e36,$00000e37,
$00000e48,$00000e49,$00000e4a,$00000e4b,$00000e4c,$00002018,$00002019,$00000000,
$000000a0,$00000e01,$00000e02,$00000e03,$00000e04,$00000e05,$00000e06,$00000e07,
$00000e08,$00000e09,$00000e0a,$00000e0b,$00000e0c,$00000e0d,$00000e0e,$00000e0f,
$00000e10,$00000e11,$00000e12,$00000e13,$00000e14,$00000e15,$00000e16,$00000e17,
$00000e18,$00000e19,$00000e1a,$00000e1b,$00000e1c,$00000e1d,$00000e1e,$00000e1f,
$00000e20,$00000e21,$00000e22,$00000e23,$00000e24,$00000e25,$00000e26,$00000e27,
$00000e28,$00000e29,$00000e2a,$00000e2b,$00000e2c,$00000e2d,$00000e2e,$00000e2f,
$00000e30,$00000e31,$00000e32,$00000e33,$00000e34,$00000e35,$00000e36,$00000e37,
$00000e38,$00000e39,$00000e3a,$0000feff,$0000200b,$00002013,$00002014,$00000e3f,
$00000e40,$00000e41,$00000e42,$00000e43,$00000e44,$00000e45,$00000e46,$00000e47,
$00000e48,$00000e49,$00000e4a,$00000e4b,$00000e4c,$00000e4d,$00002122,$00000e4f,
$00000e50,$00000e51,$00000e52,$00000e53,$00000e54,$00000e55,$00000e56,$00000e57,
$00000e58,$00000e59,$000000ae,$000000a9,$00000000,$00000000,$00000000,$00000000);
const PUCUCharSetCodePage10029:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$00000100,$00000101,$000000c9,$00000104,$000000d6,$000000dc,$000000e1,
$00000105,$0000010c,$000000e4,$0000010d,$00000106,$00000107,$000000e9,$00000179,
$0000017a,$0000010e,$000000ed,$0000010f,$00000112,$00000113,$00000116,$000000f3,
$00000117,$000000f4,$000000f6,$000000f5,$000000fa,$0000011a,$0000011b,$000000fc,
$00002020,$000000b0,$00000118,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$000000a9,$00002122,$00000119,$000000a8,$00002260,$00000123,$0000012e,
$0000012f,$0000012a,$00002264,$00002265,$0000012b,$00000136,$00002202,$00002211,
$00000142,$0000013b,$0000013c,$0000013d,$0000013e,$00000139,$0000013a,$00000145,
$00000146,$00000143,$000000ac,$0000221a,$00000144,$00000147,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$00000148,$00000150,$000000d5,$00000151,$0000014c,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$0000014d,$00000154,$00000155,$00000158,$00002039,$0000203a,$00000159,$00000156,
$00000157,$00000160,$0000201a,$0000201e,$00000161,$0000015a,$0000015b,$000000c1,
$00000164,$00000165,$000000cd,$0000017d,$0000017e,$0000016a,$000000d3,$000000d4,
$0000016b,$0000016e,$000000da,$0000016f,$00000170,$00000171,$00000172,$00000173,
$000000dd,$000000fd,$00000137,$0000017b,$00000141,$0000017c,$00000122,$000002c7);
const PUCUCharSetCodePage10079:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$000000dd,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$000000a9,$00002122,$000000b4,$000000a8,$00002260,$000000c6,$000000d8,
$0000221e,$000000b1,$00002264,$00002265,$000000a5,$000000b5,$00002202,$00002211,
$0000220f,$000003c0,$0000222b,$000000aa,$000000ba,$00002126,$000000e6,$000000f8,
$000000bf,$000000a1,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$000000c0,$000000c3,$000000d5,$00000152,$00000153,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$000000ff,$00000178,$00002044,$000000a4,$000000d0,$000000f0,$000000de,$000000fe,
$000000fd,$000000b7,$0000201a,$0000201e,$00002030,$000000c2,$000000ca,$000000c1,
$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,$000000cc,$000000d3,$000000d4,
$0000f8ff,$000000d2,$000000da,$000000db,$000000d9,$00000131,$000002c6,$000002dc,
$000000af,$000002d8,$000002d9,$000002da,$000000b8,$000002dd,$000002db,$000002c7);
const PUCUCharSetCodePage10081:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$00002020,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$000000a9,$00002122,$000000b4,$000000a8,$00002260,$000000c6,$000000d8,
$0000221e,$000000b1,$00002264,$00002265,$000000a5,$000000b5,$00002202,$00002211,
$0000220f,$000003c0,$0000222b,$000000aa,$000000ba,$00002126,$000000e6,$000000f8,
$000000bf,$000000a1,$000000ac,$0000221a,$00000192,$00002248,$00002206,$000000ab,
$000000bb,$00002026,$000000a0,$000000c0,$000000c3,$000000d5,$00000152,$00000153,
$00002013,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$000000ff,$00000178,$0000011e,$0000011f,$00000130,$00000131,$0000015e,$0000015f,
$00002021,$000000b7,$0000201a,$0000201e,$00002030,$000000c2,$000000ca,$000000c1,
$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,$000000cc,$000000d3,$000000d4,
$0000f8ff,$000000d2,$000000da,$000000db,$000000d9,$0000f8a0,$000002c6,$000002dc,
$000000af,$000002d8,$000002d9,$000002da,$000000b8,$000002dd,$000002db,$000002c7);
const PUCUCharSetCodePage10082:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$000000c4,$000000c5,$000000c7,$000000c9,$000000d1,$000000d6,$000000dc,$000000e1,
$000000e0,$000000e2,$000000e4,$000000e3,$000000e5,$000000e7,$000000e9,$000000e8,
$000000ea,$000000eb,$000000ed,$000000ec,$000000ee,$000000ef,$000000f1,$000000f3,
$000000f2,$000000f4,$000000f6,$000000f5,$000000fa,$000000f9,$000000fb,$000000fc,
$00002020,$000000b0,$000000a2,$000000a3,$000000a7,$00002022,$000000b6,$000000df,
$000000ae,$00000160,$00002122,$000000b4,$000000a8,$00002260,$0000017d,$000000d8,
$0000221e,$000000b1,$00002264,$00002265,$00002206,$000000b5,$00002202,$00002211,
$0000220f,$00000161,$0000222b,$000000aa,$000000ba,$00002126,$0000017e,$000000f8,
$000000bf,$000000a1,$000000ac,$0000221a,$00000192,$00002248,$00000106,$000000ab,
$0000010c,$00002026,$000000a0,$000000c0,$000000c3,$000000d5,$00000152,$00000153,
$00000110,$00002014,$0000201c,$0000201d,$00002018,$00002019,$000000f7,$000025ca,
$0000f8ff,$000000a9,$00002044,$000000a4,$00002039,$0000203a,$000000c6,$000000bb,
$00002013,$000000b7,$0000201a,$0000201e,$00002030,$000000c2,$00000107,$000000c1,
$0000010d,$000000c8,$000000cd,$000000ce,$000000cf,$000000cc,$000000d3,$000000d4,
$00000111,$000000d2,$000000da,$000000db,$000000d9,$00000131,$000002c6,$000002dc,
$000000af,$000003c0,$000000cb,$000002da,$000000b8,$000000ca,$000000e6,$000002c7);
const PUCUCharSetCodePage20105:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$000000a4,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000203e,$00002207,
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$000000a4,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000203e,$00002207);
const PUCUCharSetCodePage20106:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$000000a7,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c4,$000000d6,$000000dc,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e4,$000000f6,$000000fc,$000000df,$0000007f,
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$000000a7,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c4,$000000d6,$000000dc,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e4,$000000f6,$000000fc,$000000df,$0000007f);
const PUCUCharSetCodePage20107:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$000000a4,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$000000c9,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c4,$000000d6,$000000c5,$000000dc,$0000005f,
$000000e9,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e4,$000000f6,$000000e5,$000000fc,$0000007f,
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$000000a4,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$000000c9,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c4,$000000d6,$000000c5,$000000dc,$0000005f,
$000000e9,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e4,$000000f6,$000000e5,$000000fc,$0000007f);
const PUCUCharSetCodePage20108:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$000000a7,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c6,$000000d8,$000000c5,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e6,$000000f8,$000000e5,$0000007c,$0000007f,
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$000000a7,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$000000c6,$000000d8,$000000c5,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$000000e6,$000000f8,$000000e5,$0000007c,$0000007f);
const PUCUCharSetCodePage20127:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f);
const PUCUCharSetCodePage20269:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$000000a4,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000f8f6,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$00000000,$00000000,
$000000a0,$000000a1,$000000a2,$000000a3,$00000024,$000000a5,$00000023,$000000a7,
$000000a4,$00002018,$0000201c,$000000ab,$00002190,$00002191,$00002192,$00002193,
$000000b0,$000000b1,$000000b2,$000000b3,$000000d7,$000000b5,$000000b6,$000000b7,
$000000f7,$00002019,$0000201d,$000000bb,$000000bc,$000000bd,$0000f8f7,$000000bf,
$00000000,$00000060,$000000b4,$0000005e,$0000007e,$000000af,$00000306,$0000f8f8,
$00000308,$00000000,$0000030a,$00000327,$00000332,$0000030b,$00000328,$0000030c,
$00002015,$000000b9,$000000ae,$000000a9,$00002122,$00002669,$0000f8f9,$0000f8fa,
$0000f8fb,$0000f8fc,$00000000,$00000000,$0000215b,$0000215c,$0000215d,$0000215e,
$00002126,$000000c6,$000000d0,$0000f8fd,$00000126,$00000000,$00000132,$0000013f,
$00000141,$000000d8,$00000152,$000000ba,$000000de,$00000166,$0000014a,$00000149,
$00000138,$000000e6,$00000111,$000000f0,$00000127,$00000131,$00000133,$00000140,
$00000142,$000000f8,$00000153,$000000df,$000000fe,$00000167,$0000f8fe,$0000f8ff);
const PUCUCharSetCodePage20273:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$0000007b,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000c4,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$0000007e,$000000dc,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$0000005b,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$000000a7,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$000000df,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$00000040,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e4,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000a6,$000000f2,$000000f3,$000000f5,
$000000fc,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007d,$000000f9,$000000fa,$000000ff,
$000000d6,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$0000005c,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$0000005d,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20277:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$0000007d,
$000000e7,$000000f1,$00000023,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000a4,$000000c5,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$00000024,
$000000c7,$000000d1,$000000f8,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000a6,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$000000c6,$000000d8,$00000027,$0000003d,$00000022,
$00000040,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$0000007b,$000000b8,$0000005b,$0000005d,
$000000b5,$000000fc,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e6,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$000000e5,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007e,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20278:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$0000007b,$000000e0,$000000e1,$000000e3,$0000007d,
$000000e7,$000000f1,$000000a7,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$00000060,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000a4,$000000c5,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$00000023,$000000c0,$000000c1,$000000c3,$00000024,
$000000c7,$000000d1,$000000f6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$0000005c,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000e9,$0000003a,$000000c4,$000000d6,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$0000005d,
$000000b5,$000000fc,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$0000005b,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e4,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000a6,$000000f2,$000000f3,$000000f5,
$000000e5,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$0000007e,$000000f9,$000000fa,$000000ff,
$000000c9,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$00000040,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20280:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$0000007b,$000000e1,$000000e3,$000000e5,
$0000005c,$000000f1,$000000b0,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000005d,$000000ea,$000000eb,$0000007d,$000000ed,$000000ee,$000000ef,
$0000007e,$000000df,$000000e9,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f2,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000f9,$0000003a,$000000a3,$000000a7,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$0000005b,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$000000ec,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$00000023,$000000a5,$000000b7,$000000a9,$00000040,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$000000b4,$000000d7,
$000000e0,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000a6,$000000f3,$000000f5,
$000000e8,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$00000060,$000000fa,$000000ff,
$000000e7,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20284:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000a6,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$00000023,$000000f1,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$000000d1,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$000000a8,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005e,$00000021,$000000af,$0000007e,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20285:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$00000024,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$000000a3,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$000000b5,$000000af,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$0000005b,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005e,$0000005d,$0000007e,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20290:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$0000ff61,$0000ff62,$0000ff63,$0000ff64,$0000ff65,$0000ff66,$0000ff67,
$0000ff68,$0000ff69,$000000a3,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$0000ff6a,$0000ff6b,$0000ff6c,$0000ff6d,$0000ff6e,$0000ff6f,$0000001a,
$0000ff70,$0000001a,$00000021,$000000a5,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,
$00000067,$00000068,$0000001a,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000005b,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$0000005d,$0000ff71,$0000ff72,$0000ff73,$0000ff74,$0000ff75,$0000ff76,$0000ff77,
$0000ff78,$0000ff79,$0000ff7a,$00000071,$0000ff7b,$0000ff7c,$0000ff7d,$0000ff7e,
$0000ff7f,$0000ff80,$0000ff81,$0000ff82,$0000ff83,$0000ff84,$0000ff85,$0000ff86,
$0000ff87,$0000ff88,$0000ff89,$00000072,$0000001a,$0000ff8a,$0000ff8b,$0000ff8c,
$0000007e,$0000203e,$0000ff8d,$0000ff8e,$0000ff8f,$0000ff90,$0000ff91,$0000ff92,
$0000ff93,$0000ff94,$0000ff95,$00000073,$0000ff96,$0000ff97,$0000ff98,$0000ff99,
$0000005e,$000000a2,$0000005c,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000ff9a,$0000ff9b,$0000ff9c,$0000ff9d,$0000ff9e,$0000ff9f,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$00000024,$0000001a,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000009f);
const PUCUCharSetCodePage20297:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$00000040,$000000e1,$000000e3,$000000e5,
$0000005c,$000000f1,$000000b0,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000007b,$000000ea,$000000eb,$0000007d,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000a7,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000f9,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000b5,$0000003a,$000000a3,$000000e0,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$0000005b,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$000000b8,$000000c6,$000000a4,
$00000060,$000000a8,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$000000dd,$000000de,$000000ae,
$000000a2,$00000023,$000000a5,$000000b7,$000000a9,$0000005d,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$0000007e,$000000b4,$000000d7,
$000000e9,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$000000e8,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000a6,$000000fa,$000000ff,
$000000e7,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20420:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$0000fe7c,$0000fe7d,$00000640,$0000f8fc,$0000fe80,$0000fe81,
$0000fe82,$0000fe83,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$0000fe84,$0000fe85,$0000001a,$0000001a,$0000fe8b,$0000fe8d,$0000fe8e,
$0000fe8f,$0000fe91,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$0000fe93,$0000fe95,$0000fe97,$0000fe99,$0000fe9b,$0000fe9d,
$0000fe9f,$0000fea1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000fea3,$0000fea5,$0000fea7,$0000fea9,$0000feab,$0000fead,$0000feaf,$0000f8f6,
$0000feb3,$0000060c,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$0000f8f5,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000feb7,$0000f8f4,$0000febb,$0000f8f7,$0000febf,$0000fec3,
$0000fec7,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000fec9,$0000feca,$0000fecb,$0000fecc,$0000fecd,$0000fece,
$0000fecf,$000000f7,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000fed0,$0000fed1,$0000fed3,$0000fed5,$0000fed7,$0000fed9,
$0000fedb,$0000fedd,$0000fef5,$0000fef6,$0000fef7,$0000fef8,$0000001a,$0000001a,
$0000fefb,$0000fefc,$0000fedf,$0000fee1,$0000fee3,$0000fee5,$0000fee7,$0000fee9,
$0000061b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$0000feeb,$0000001a,$0000feec,$0000001a,$0000feed,
$0000061f,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000feef,$0000fef0,$0000fef1,$0000fef2,$0000fef3,$00000660,
$000000d7,$00002007,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$00000661,$00000662,$0000001a,$00000663,$00000664,$00000665,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000001a,$00000666,$00000667,$00000668,$00000669,$0000009f);
const PUCUCharSetCodePage20423:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$00000391,$00000392,$00000393,$00000394,$00000395,$00000396,$00000397,
$00000398,$00000399,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$0000039a,$0000039b,$0000039c,$0000039d,$0000039e,$0000039f,$000003a0,
$000003a1,$000003a3,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000003a4,$000003a5,$000003a6,$000003a7,$000003a8,$000003a9,
$0000001a,$0000001a,$0000007c,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000001a,$00000386,$00000388,$00000389,$000000a0,$0000038a,$0000038c,$0000038e,
$0000038f,$00000060,$0000003a,$000000a3,$000000a7,$00000027,$0000003d,$00000022,
$000000c4,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000003b1,$000003b2,$000003b3,$000003b4,$000003b5,$000003b6,
$000000d6,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000003b7,$000003b8,$000003b9,$000003ba,$000003bb,$000003bc,
$000000dc,$000000a8,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000003bd,$000003be,$000003bf,$000003c0,$000003c1,$000003c3,
$0000001a,$000003ac,$000003ad,$000003ae,$000003ca,$000003af,$000003cc,$000003cd,
$000003cb,$000003ce,$000003c2,$000003c4,$000003c5,$000003c6,$000003c7,$000003c8,
$000000b8,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000003c9,$000000e2,$000000e0,$000000e4,$000000ea,
$000000b4,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b1,$000000e9,$000000e8,$000000eb,$000000ee,$000000ef,
$000000b0,$0000001a,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000bd,$000000f6,$000000f4,$000000fb,$000000f9,$000000fc,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000ff,$000000e7,$000000c7,$0000001a,$0000001a,$0000009f);
const PUCUCharSetCodePage20424:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,
$000005d7,$000005d8,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000001a,$000005ea,$0000001a,$0000001a,$000000a0,$0000001a,$0000001a,$0000001a,
$00002017,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$0000001a,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$0000001a,$0000001a,$0000001a,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000001a,$0000001a,$0000001a,$000000b8,$0000001a,$000000a4,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$000000ae,
$0000005e,$000000a3,$000000a5,$00002022,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$0000005b,$0000005d,$0000203e,$000000a8,$000000b4,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$0000001a,$0000001a,$0000001a,$0000001a,$0000009f);
const PUCUCharSetCodePage20833:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$0000001a,$0000ffa0,$0000ffa1,$0000ffa2,$0000ffa3,$0000ffa4,$0000ffa5,
$0000ffa6,$0000ffa7,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$0000001a,$0000ffa8,$0000ffa9,$0000ffaa,$0000ffab,$0000ffac,$0000ffad,
$0000ffae,$0000ffaf,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$0000ffb0,$0000ffb1,$0000ffb2,$0000ffb3,$0000ffb4,$0000ffb5,
$0000ffb6,$0000ffb7,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000005b,$0000001a,$0000ffb8,$0000ffb9,$0000ffba,$0000ffbb,$0000ffbc,$0000ffbd,
$0000ffbe,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$0000005d,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000ffc2,$0000ffc3,$0000ffc4,$0000ffc5,$0000ffc6,$0000ffc7,
$0000001a,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000ffca,$0000ffcb,$0000ffcc,$0000ffcd,$0000ffce,$0000ffcf,
$0000203e,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000ffd2,$0000ffd3,$0000ffd4,$0000ffd5,$0000ffd6,$0000ffd7,
$0000005e,$0000001a,$0000005c,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$0000001a,$0000001a,$0000ffda,$0000ffdb,$0000ffdc,$0000001a,$0000001a,$0000001a,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$000020a9,$0000001a,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000001a,$0000001a,$0000001a,$0000001a,$0000001a,$0000009f);
const PUCUCharSetCodePage20838:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$00000e01,$00000e02,$00000e03,$00000e04,$00000e05,$00000e06,
$00000e07,$0000005b,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$00000e48,$00000e08,$00000e09,$00000e0a,$00000e0b,$00000e0c,$00000e0d,
$00000e0e,$0000005d,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$00000e0f,$00000e10,$00000e11,$00000e12,$00000e13,$00000e14,
$00000e15,$0000005e,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$00000e3f,$00000e4e,$00000e16,$00000e17,$00000e18,$00000e19,$00000e1a,$00000e1b,
$00000e1c,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$00000e4f,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$00000e1d,$00000e1e,$00000e1f,$00000e20,$00000e21,$00000e22,
$00000e5a,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$00000e23,$00000e24,$00000e25,$00000e26,$00000e27,$00000e28,
$00000e5b,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$00000e29,$00000e2a,$00000e2b,$00000e2c,$00000e2d,$00000e2e,
$00000e50,$00000e51,$00000e52,$00000e53,$00000e54,$00000e55,$00000e56,$00000e57,
$00000e58,$00000e59,$00000e2f,$00000e30,$00000e31,$00000e32,$00000e33,$00000e34,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$00000e49,$00000e35,$00000e36,$00000e37,$00000e38,$00000e39,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$00000e3a,$00000e40,$00000e41,$00000e42,$00000e43,$00000e44,
$0000005c,$00000e4a,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$00000e45,$00000e46,$00000e47,$00000e48,$00000e49,$00000e4a,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$00000e4b,$00000e4c,$00000e4d,$00000e4b,$00000e4c,$0000009f);
const PUCUCharSetCodePage20866:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00002500,$00002502,$0000250c,$00002510,$00002514,$00002518,$0000251c,$00002524,
$0000252c,$00002534,$0000253c,$00002580,$00002584,$00002588,$0000258c,$00002590,
$00002591,$00002592,$00002593,$00002320,$000025a0,$00002219,$0000221a,$00002248,
$00002264,$00002265,$000000a0,$00002321,$000000b0,$000000b2,$000000b7,$000000f7,
$00002550,$00002551,$00002552,$00000451,$00002553,$00002554,$00002555,$00002556,
$00002557,$00002558,$00002559,$0000255a,$0000255b,$0000255c,$0000255d,$0000255e,
$0000255f,$00002560,$00002561,$00000401,$00002562,$00002563,$00002564,$00002565,
$00002566,$00002567,$00002568,$00002569,$0000256a,$0000256b,$0000256c,$000000a9,
$0000044e,$00000430,$00000431,$00000446,$00000434,$00000435,$00000444,$00000433,
$00000445,$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,
$0000043f,$0000044f,$00000440,$00000441,$00000442,$00000443,$00000436,$00000432,
$0000044c,$0000044b,$00000437,$00000448,$0000044d,$00000449,$00000447,$0000044a,
$0000042e,$00000410,$00000411,$00000426,$00000414,$00000415,$00000424,$00000413,
$00000425,$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,
$0000041f,$0000042f,$00000420,$00000421,$00000422,$00000423,$00000416,$00000412,
$0000042c,$0000042b,$00000417,$00000428,$0000042d,$00000429,$00000427,$0000042a);
const PUCUCharSetCodePage20871:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000de,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$000000c6,$00000024,$0000002a,$00000029,$0000003b,$000000d6,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$000000a6,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$000000f0,$0000003a,$00000023,$000000d0,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$00000060,$000000fd,$0000007b,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$0000007d,$000000b8,$0000005d,$000000a4,
$000000b5,$000000f6,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$00000040,$000000dd,$0000005b,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$000000bc,
$000000bd,$000000be,$000000ac,$0000007c,$000000af,$000000a8,$0000005c,$000000d7,
$000000fe,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$0000007e,$000000f2,$000000f3,$000000f5,
$000000e6,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$000000b4,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$0000005e,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20880:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$00000452,$00000453,$00000451,$00000454,$00000455,$00000456,
$00000457,$00000458,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$00000459,$0000045a,$0000045b,$0000045c,$0000045e,$0000045f,$0000042a,
$00002116,$00000402,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$00000403,$00000401,$00000404,$00000405,$00000406,$00000407,
$00000408,$00000409,$0000007c,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000040a,$0000040b,$0000040c,$000000ad,$0000040e,$0000040f,$0000044e,$00000430,
$00000431,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$00000446,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$00000434,$00000435,$00000444,$00000433,$00000445,$00000438,
$00000439,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$0000044f,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$00000440,$00000441,$00000442,$00000443,$00000436,$00000432,
$0000044c,$0000044b,$00000437,$00000448,$0000044d,$00000449,$00000447,$0000044a,
$0000042e,$00000410,$00000411,$00000426,$00000414,$00000415,$00000424,$00000413,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$00000425,$00000418,$00000419,$0000041a,$0000041b,$0000041c,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000041d,$0000041e,$0000041f,$0000042f,$00000420,$00000421,
$0000005c,$000000a4,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$00000422,$00000423,$00000416,$00000412,$0000042c,$0000042b,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$00000417,$00000428,$0000042d,$00000429,$00000427,$0000009f);
const PUCUCharSetCodePage20905:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$0000001a,$0000010b,
$0000007b,$000000f1,$000000c7,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$0000011e,$00000130,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$0000001a,$0000010a,
$0000005b,$000000d1,$0000015f,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000001a,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000131,$0000003a,$000000d6,$0000015e,$00000027,$0000003d,$000000dc,
$000002d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$00000127,$00000109,$0000015d,$0000016d,$0000001a,$0000007c,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$00000125,$0000011d,$00000135,$000000b8,$0000001a,$000000a4,
$000000b5,$000000f6,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$00000126,$00000108,$0000015c,$0000016c,$0000001a,$00000040,
$000002d9,$000000a3,$0000017c,$0000007d,$0000017b,$000000a7,$0000005d,$000000b7,
$000000bd,$00000024,$00000124,$0000011c,$00000134,$000000a8,$000000b4,$000000d7,
$000000e7,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$0000007e,$000000f2,$000000f3,$00000121,
$0000011f,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$00000060,$000000fb,$0000005c,$000000f9,$000000fa,$0000001a,
$000000fc,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$00000023,$000000d2,$000000d3,$00000120,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$00000022,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage20924:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$0000000a,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$000000e2,$000000e4,$000000e0,$000000e1,$000000e3,$000000e5,
$000000e7,$000000f1,$000000dd,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$000000e9,$000000ea,$000000eb,$000000e8,$000000ed,$000000ee,$000000ef,
$000000ec,$000000df,$00000021,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$000000c2,$000000c4,$000000c0,$000000c1,$000000c3,$000000c5,
$000000c7,$000000d1,$00000160,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$000000f8,$000000c9,$000000ca,$000000cb,$000000c8,$000000cd,$000000ce,$000000cf,
$000000cc,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$000000d8,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$000000ab,$000000bb,$000000f0,$000000fd,$000000fe,$000000b1,
$000000b0,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$000000aa,$000000ba,$000000e6,$0000017e,$000000c6,$000020ac,
$000000b5,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$000000a1,$000000bf,$000000d0,$0000005b,$000000de,$000000ae,
$000000a2,$000000a3,$000000a5,$000000b7,$000000a9,$000000a7,$000000b6,$00000152,
$00000153,$00000178,$000000ac,$00000161,$000000af,$0000005d,$0000017d,$000000d7,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$000000ad,$000000f4,$000000f6,$000000f2,$000000f3,$000000f5,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$000000b9,$000000fb,$000000fc,$000000f9,$000000fa,$000000ff,
$0000005c,$000000f7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$000000b2,$000000d4,$000000d6,$000000d2,$000000d3,$000000d5,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$000000b3,$000000db,$000000dc,$000000d9,$000000da,$0000009f);
const PUCUCharSetCodePage21025:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$0000009c,$00000009,$00000086,$0000007f,
$00000097,$0000008d,$0000008e,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$0000009d,$00000085,$00000008,$00000087,
$00000018,$00000019,$00000092,$0000008f,$0000001c,$0000001d,$0000001e,$0000001f,
$00000080,$00000081,$00000082,$00000083,$00000084,$0000000a,$00000017,$0000001b,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$00000005,$00000006,$00000007,
$00000090,$00000091,$00000016,$00000093,$00000094,$00000095,$00000096,$00000004,
$00000098,$00000099,$0000009a,$0000009b,$00000014,$00000015,$0000009e,$0000001a,
$00000020,$000000a0,$00000452,$00000453,$00000451,$00000454,$00000455,$00000456,
$00000457,$00000458,$0000005b,$0000002e,$0000003c,$00000028,$0000002b,$00000021,
$00000026,$00000459,$0000045a,$0000045b,$0000045c,$0000045e,$0000045f,$0000042a,
$00002116,$00000402,$0000005d,$00000024,$0000002a,$00000029,$0000003b,$0000005e,
$0000002d,$0000002f,$00000403,$00000401,$00000404,$00000405,$00000406,$00000407,
$00000408,$00000409,$0000007c,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000040a,$0000040b,$0000040c,$000000ad,$0000040e,$0000040f,$0000044e,$00000430,
$00000431,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000003d,$00000022,
$00000446,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$00000434,$00000435,$00000444,$00000433,$00000445,$00000438,
$00000439,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$0000044f,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$00000440,$00000441,$00000442,$00000443,$00000436,$00000432,
$0000044c,$0000044b,$00000437,$00000448,$0000044d,$00000449,$00000447,$0000044a,
$0000042e,$00000410,$00000411,$00000426,$00000414,$00000415,$00000424,$00000413,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$00000425,$00000418,$00000419,$0000041a,$0000041b,$0000041c,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$00000051,$00000052,$0000041d,$0000041e,$0000041f,$0000042f,$00000420,$00000421,
$0000005c,$000000a7,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$00000059,$0000005a,$00000422,$00000423,$00000416,$00000412,$0000042c,$0000042b,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$00000417,$00000428,$0000042d,$00000429,$00000427,$0000009f);
const PUCUCharSetCodePage21027:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$0000f8c4,$0000f8c5,$0000f8c6,$0000f8c7,$0000f8c8,$0000f8c9,$0000f8ca,$0000f8cb,
$0000f8cc,$0000f8cd,$0000f8ce,$0000f8cf,$0000f8d0,$0000f8d1,$0000f8d2,$0000f8d3,
$0000f8d4,$0000f8d5,$0000f8d6,$0000f8d7,$0000f8d8,$0000f8d9,$0000f8da,$0000f8db,
$0000f8dc,$0000f8dd,$0000f8de,$0000f8df,$0000f8e0,$0000f8e1,$00000000,$0000f8e2,
$00000020,$00000000,$0000ff61,$0000ff62,$0000ff63,$0000ff64,$0000ff65,$0000ff66,
$0000ff67,$0000ff68,$000000a2,$0000002e,$0000003c,$00000028,$0000002b,$0000007c,
$00000026,$0000ff69,$0000ff6a,$0000ff6b,$0000ff6c,$0000ff6d,$0000ff6e,$0000ff6f,
$0000ff70,$0000ff71,$00000021,$00000024,$0000002a,$00000029,$0000003b,$000000ac,
$0000002d,$0000002f,$0000ff72,$0000ff73,$0000ff74,$0000ff75,$0000ff76,$0000ff77,
$0000f8e3,$0000ff79,$00000000,$0000002c,$00000025,$0000005f,$0000003e,$0000003f,
$0000ff7a,$0000ff7b,$0000ff7c,$0000ff7d,$0000ff7e,$0000ff7f,$0000ff80,$0000ff81,
$0000ff82,$00000060,$0000003a,$00000023,$00000040,$00000027,$0000f8e4,$00000022,
$00000000,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000ff83,$0000ff84,$0000ff85,$0000ff86,$0000008e,$0000ff88,
$00000000,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,$00000070,
$00000071,$00000072,$0000ff89,$0000ff8a,$0000ff8b,$0000ff8c,$0000ff8d,$0000ff8e,
$000000af,$0000007e,$00000073,$00000074,$00000075,$00000076,$00000077,$00000078,
$00000079,$0000007a,$0000ff8f,$0000ff90,$0000ff91,$0000005b,$0000ff92,$0000ff93,
$0000005e,$000000a3,$000000a5,$0000ff94,$0000ff95,$0000ff96,$0000ff97,$0000ff98,
$0000ff99,$0000ff9a,$0000ff9b,$0000ff9c,$0000ff9d,$0000005d,$0000ff9e,$0000ff9f,
$0000007b,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$0000f8e5,$0000f8e6,$0000f8e7,$0000f8e8,$0000f8e9,$0000f8ea,$00000000,$00000000,
$0000007d,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,$00000050,
$0000f8eb,$0000f8ec,$0000f8ed,$0000f8ee,$0000f8ef,$0000f8f0,$00000000,$0000f8f1,
$0000005c,$00000000,$00000053,$00000054,$00000055,$00000056,$00000057,$00000058,
$0000f8f2,$0000f8f3,$0000f8f4,$0000f8f5,$0000f8f6,$0000f8f7,$00000000,$00000000,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$0000f8f8,$0000f8f9,$0000f8fa,$0000f8fb,$0000f8fc,$0000f8fd,$0000f8fe,$0000f8ff);
const PUCUCharSetCodePage21866:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00002500,$00002502,$0000250c,$00002510,$00002514,$00002518,$0000251c,$00002524,
$0000252c,$00002534,$0000253c,$00002580,$00002584,$00002588,$0000258c,$00002590,
$00002591,$00002592,$00002593,$00002320,$000025a0,$00002219,$0000221a,$00002248,
$00002264,$00002265,$000000a0,$00002321,$000000b0,$000000b2,$000000b7,$000000f7,
$00002550,$00002551,$00002552,$00000451,$00000454,$00002554,$00000456,$00000457,
$00002557,$00002558,$00002559,$0000255a,$0000255b,$00000491,$0000045e,$0000255e,
$0000255f,$00002560,$00002561,$00000401,$00000404,$00002563,$00000406,$00000407,
$00002566,$00002567,$00002568,$00002569,$0000256a,$00000490,$0000040e,$000000a9,
$0000044e,$00000430,$00000431,$00000446,$00000434,$00000435,$00000444,$00000433,
$00000445,$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,
$0000043f,$0000044f,$00000440,$00000441,$00000442,$00000443,$00000436,$00000432,
$0000044c,$0000044b,$00000437,$00000448,$0000044d,$00000449,$00000447,$0000044a,
$0000042e,$00000410,$00000411,$00000426,$00000414,$00000415,$00000424,$00000413,
$00000425,$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,
$0000041f,$0000042f,$00000420,$00000421,$00000422,$00000423,$00000416,$00000412,
$0000042c,$0000042b,$00000417,$00000428,$0000042d,$00000429,$00000427,$0000042a);
const PUCUCharSetCodePage28591:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$000000a1,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000ba,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000000c0,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$000000d0,$000000d1,$000000d2,$000000d3,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$000000dd,$000000de,$000000df,
$000000e0,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$000000f0,$000000f1,$000000f2,$000000f3,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$000000fd,$000000fe,$000000ff);
const PUCUCharSetCodePage28592:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000104,$000002d8,$00000141,$000000a4,$0000013d,$0000015a,$000000a7,
$000000a8,$00000160,$0000015e,$00000164,$00000179,$000000ad,$0000017d,$0000017b,
$000000b0,$00000105,$000002db,$00000142,$000000b4,$0000013e,$0000015b,$000002c7,
$000000b8,$00000161,$0000015f,$00000165,$0000017a,$000002dd,$0000017e,$0000017c,
$00000154,$000000c1,$000000c2,$00000102,$000000c4,$00000139,$00000106,$000000c7,
$0000010c,$000000c9,$00000118,$000000cb,$0000011a,$000000cd,$000000ce,$0000010e,
$00000110,$00000143,$00000147,$000000d3,$000000d4,$00000150,$000000d6,$000000d7,
$00000158,$0000016e,$000000da,$00000170,$000000dc,$000000dd,$00000162,$000000df,
$00000155,$000000e1,$000000e2,$00000103,$000000e4,$0000013a,$00000107,$000000e7,
$0000010d,$000000e9,$00000119,$000000eb,$0000011b,$000000ed,$000000ee,$0000010f,
$00000111,$00000144,$00000148,$000000f3,$000000f4,$00000151,$000000f6,$000000f7,
$00000159,$0000016f,$000000fa,$00000171,$000000fc,$000000fd,$00000163,$000002d9);
const PUCUCharSetCodePage28593:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000126,$000002d8,$000000a3,$000000a4,$0000f7f5,$00000124,$000000a7,
$000000a8,$00000130,$0000015e,$0000011e,$00000134,$000000ad,$0000f7f6,$0000017b,
$000000b0,$00000127,$000000b2,$000000b3,$000000b4,$000000b5,$00000125,$000000b7,
$000000b8,$00000131,$0000015f,$0000011f,$00000135,$000000bd,$0000f7f7,$0000017c,
$000000c0,$000000c1,$000000c2,$0000f7f8,$000000c4,$0000010a,$00000108,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$0000f7f9,$000000d1,$000000d2,$000000d3,$000000d4,$00000120,$000000d6,$000000d7,
$0000011c,$000000d9,$000000da,$000000db,$000000dc,$0000016c,$0000015c,$000000df,
$000000e0,$000000e1,$000000e2,$0000f7fa,$000000e4,$0000010b,$00000109,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$0000f7fb,$000000f1,$000000f2,$000000f3,$000000f4,$00000121,$000000f6,$000000f7,
$0000011d,$000000f9,$000000fa,$000000fb,$000000fc,$0000016d,$0000015d,$000002d9);
const PUCUCharSetCodePage28594:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000104,$00000138,$00000156,$000000a4,$00000128,$0000013b,$000000a7,
$000000a8,$00000160,$00000112,$00000122,$00000166,$000000ad,$0000017d,$000000af,
$000000b0,$00000105,$000002db,$00000157,$000000b4,$00000129,$0000013c,$000002c7,
$000000b8,$00000161,$00000113,$00000123,$00000167,$0000014a,$0000017e,$0000014b,
$00000100,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$0000012e,
$0000010c,$000000c9,$00000118,$000000cb,$00000116,$000000cd,$000000ce,$0000012a,
$00000110,$00000145,$0000014c,$00000136,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$00000172,$000000da,$000000db,$000000dc,$00000168,$0000016a,$000000df,
$00000101,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$0000012f,
$0000010d,$000000e9,$00000119,$000000eb,$00000117,$000000ed,$000000ee,$0000012b,
$00000111,$00000146,$0000014d,$00000137,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$00000173,$000000fa,$000000fb,$000000fc,$00000169,$0000016b,$000002d9);
const PUCUCharSetCodePage28595:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$00000401,$00000402,$00000403,$00000404,$00000405,$00000406,$00000407,
$00000408,$00000409,$0000040a,$0000040b,$0000040c,$000000ad,$0000040e,$0000040f,
$00000410,$00000411,$00000412,$00000413,$00000414,$00000415,$00000416,$00000417,
$00000418,$00000419,$0000041a,$0000041b,$0000041c,$0000041d,$0000041e,$0000041f,
$00000420,$00000421,$00000422,$00000423,$00000424,$00000425,$00000426,$00000427,
$00000428,$00000429,$0000042a,$0000042b,$0000042c,$0000042d,$0000042e,$0000042f,
$00000430,$00000431,$00000432,$00000433,$00000434,$00000435,$00000436,$00000437,
$00000438,$00000439,$0000043a,$0000043b,$0000043c,$0000043d,$0000043e,$0000043f,
$00000440,$00000441,$00000442,$00000443,$00000444,$00000445,$00000446,$00000447,
$00000448,$00000449,$0000044a,$0000044b,$0000044c,$0000044d,$0000044e,$0000044f,
$00002116,$00000451,$00000452,$00000453,$00000454,$00000455,$00000456,$00000457,
$00000458,$00000459,$0000045a,$0000045b,$0000045c,$000000a7,$0000045e,$0000045f);
const PUCUCharSetCodePage28596:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$0000f7c8,$0000f7c9,$0000f7ca,$000000a4,$0000f7cb,$0000f7cc,$0000f7cd,
$0000f7ce,$0000f7cf,$0000f7d0,$0000f7d1,$0000060c,$000000ad,$0000f7d2,$0000f7d3,
$0000f7d4,$0000f7d5,$0000f7d6,$0000f7d7,$0000f7d8,$0000f7d9,$0000f7da,$0000f7db,
$0000f7dc,$0000f7dd,$0000f7de,$0000061b,$0000f7df,$0000f7e0,$0000f7e1,$0000061f,
$0000f7e2,$00000621,$00000622,$00000623,$00000624,$00000625,$00000626,$00000627,
$00000628,$00000629,$0000062a,$0000062b,$0000062c,$0000062d,$0000062e,$0000062f,
$00000630,$00000631,$00000632,$00000633,$00000634,$00000635,$00000636,$00000637,
$00000638,$00000639,$0000063a,$0000f7e3,$0000f7e4,$0000f7e5,$0000f7e6,$0000f7e7,
$00000640,$00000641,$00000642,$00000643,$00000644,$00000645,$00000646,$00000647,
$00000648,$00000649,$0000064a,$0000064b,$0000064c,$0000064d,$0000064e,$0000064f,
$00000650,$00000651,$00000652,$0000f7e8,$0000f7e9,$0000f7ea,$0000f7eb,$0000f7ec,
$0000f7ed,$0000f7ee,$0000f7ef,$0000f7f0,$0000f7f1,$0000f7f2,$0000f7f3,$0000f7f4);
const PUCUCharSetCodePage28597:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$000002bd,$000002bc,$000000a3,$0000f7c2,$0000f7c3,$000000a6,$000000a7,
$000000a8,$000000a9,$0000f7c4,$000000ab,$000000ac,$000000ad,$0000f7c5,$00002015,
$000000b0,$000000b1,$000000b2,$000000b3,$00000384,$00000385,$00000386,$000000b7,
$00000388,$00000389,$0000038a,$000000bb,$0000038c,$000000bd,$0000038e,$0000038f,
$00000390,$00000391,$00000392,$00000393,$00000394,$00000395,$00000396,$00000397,
$00000398,$00000399,$0000039a,$0000039b,$0000039c,$0000039d,$0000039e,$0000039f,
$000003a0,$000003a1,$0000f7c6,$000003a3,$000003a4,$000003a5,$000003a6,$000003a7,
$000003a8,$000003a9,$000003aa,$000003ab,$000003ac,$000003ad,$000003ae,$000003af,
$000003b0,$000003b1,$000003b2,$000003b3,$000003b4,$000003b5,$000003b6,$000003b7,
$000003b8,$000003b9,$000003ba,$000003bb,$000003bc,$000003bd,$000003be,$000003bf,
$000003c0,$000003c1,$000003c2,$000003c3,$000003c4,$000003c5,$000003c6,$000003c7,
$000003c8,$000003c9,$000003ca,$000003cb,$000003cc,$000003cd,$000003ce,$0000f7c7);
const PUCUCharSetCodePage28598:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$0000f79c,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000d7,$000000ab,$000000ac,$000000ad,$000000ae,$0000203e,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000f7,$000000bb,$000000bc,$000000bd,$000000be,$0000f79d,
$0000f79e,$0000f79f,$0000f7a0,$0000f7a1,$0000f7a2,$0000f7a3,$0000f7a4,$0000f7a5,
$0000f7a6,$0000f7a7,$0000f7a8,$0000f7a9,$0000f7aa,$0000f7ab,$0000f7ac,$0000f7ad,
$0000f7ae,$0000f7af,$0000f7b0,$0000f7b1,$0000f7b2,$0000f7b3,$0000f7b4,$0000f7b5,
$0000f7b6,$0000f7b7,$0000f7b8,$0000f7b9,$0000f7ba,$0000f7bb,$0000f7bc,$00002017,
$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,$000005d7,
$000005d8,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000005ea,$0000f7bd,$0000f7be,$0000f7bf,$0000f7c0,$0000f7c1);
const PUCUCharSetCodePage28599:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$000000a1,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000ba,$000000bb,$000000bc,$000000bd,$000000be,$000000bf,
$000000c0,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$0000011e,$000000d1,$000000d2,$000000d3,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$00000130,$0000015e,$000000df,
$000000e0,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$0000011f,$000000f1,$000000f2,$000000f3,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$00000131,$0000015f,$000000ff);
const PUCUCharSetCodePage28603:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$0000201d,$000000a2,$000000a3,$000000a4,$0000201e,$000000a6,$000000a7,
$000000d8,$000000a9,$00000156,$000000ab,$000000ac,$000000ad,$000000ae,$000000c6,
$000000b0,$000000b1,$000000b2,$000000b3,$0000201c,$000000b5,$000000b6,$000000b7,
$000000f8,$000000b9,$00000157,$000000bb,$000000bc,$000000bd,$000000be,$000000e6,
$00000104,$0000012e,$00000100,$00000106,$000000c4,$000000c5,$00000118,$00000112,
$0000010c,$000000c9,$00000179,$00000116,$00000122,$00000136,$0000012a,$0000013b,
$00000160,$00000143,$00000145,$000000d3,$0000014c,$000000d5,$000000d6,$000000d7,
$00000172,$00000141,$0000015a,$0000016a,$000000dc,$0000017b,$0000017d,$000000df,
$00000105,$0000012f,$00000101,$00000107,$000000e4,$000000e5,$00000119,$00000113,
$0000010d,$000000e9,$0000017a,$00000117,$00000123,$00000137,$0000012b,$0000013c,
$00000161,$00000144,$00000146,$000000f3,$0000014d,$000000f5,$000000f6,$000000f7,
$00000173,$00000142,$0000015b,$0000016b,$000000fc,$0000017c,$0000017e,$00002019);
const PUCUCharSetCodePage28605:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$000000a1,$000000a2,$000000a3,$000020ac,$000000a5,$00000160,$000000a7,
$00000161,$000000a9,$000000aa,$000000ab,$000000ac,$000000ad,$000000ae,$000000af,
$000000b0,$000000b1,$000000b2,$000000b3,$0000017d,$000000b5,$000000b6,$000000b7,
$0000017e,$000000b9,$000000ba,$000000bb,$00000152,$00000153,$00000178,$000000bf,
$000000c0,$000000c1,$000000c2,$000000c3,$000000c4,$000000c5,$000000c6,$000000c7,
$000000c8,$000000c9,$000000ca,$000000cb,$000000cc,$000000cd,$000000ce,$000000cf,
$000000d0,$000000d1,$000000d2,$000000d3,$000000d4,$000000d5,$000000d6,$000000d7,
$000000d8,$000000d9,$000000da,$000000db,$000000dc,$000000dd,$000000de,$000000df,
$000000e0,$000000e1,$000000e2,$000000e3,$000000e4,$000000e5,$000000e6,$000000e7,
$000000e8,$000000e9,$000000ea,$000000eb,$000000ec,$000000ed,$000000ee,$000000ef,
$000000f0,$000000f1,$000000f2,$000000f3,$000000f4,$000000f5,$000000f6,$000000f7,
$000000f8,$000000f9,$000000fa,$000000fb,$000000fc,$000000fd,$000000fe,$000000ff);
const PUCUCharSetCodePage38598:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$000000a0,$0000f79c,$000000a2,$000000a3,$000000a4,$000000a5,$000000a6,$000000a7,
$000000a8,$000000a9,$000000d7,$000000ab,$000000ac,$000000ad,$000000ae,$0000203e,
$000000b0,$000000b1,$000000b2,$000000b3,$000000b4,$000000b5,$000000b6,$000000b7,
$000000b8,$000000b9,$000000f7,$000000bb,$000000bc,$000000bd,$000000be,$0000f79d,
$0000f79e,$0000f79f,$0000f7a0,$0000f7a1,$0000f7a2,$0000f7a3,$0000f7a4,$0000f7a5,
$0000f7a6,$0000f7a7,$0000f7a8,$0000f7a9,$0000f7aa,$0000f7ab,$0000f7ac,$0000f7ad,
$0000f7ae,$0000f7af,$0000f7b0,$0000f7b1,$0000f7b2,$0000f7b3,$0000f7b4,$0000f7b5,
$0000f7b6,$0000f7b7,$0000f7b8,$0000f7b9,$0000f7ba,$0000f7bb,$0000f7bc,$00002017,
$000005d0,$000005d1,$000005d2,$000005d3,$000005d4,$000005d5,$000005d6,$000005d7,
$000005d8,$000005d9,$000005da,$000005db,$000005dc,$000005dd,$000005de,$000005df,
$000005e0,$000005e1,$000005e2,$000005e3,$000005e4,$000005e5,$000005e6,$000005e7,
$000005e8,$000005e9,$000005ea,$0000f7bd,$0000f7be,$0000f7bf,$0000f7c0,$0000f7c1);
const PUCUCharSetCodePage57002:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000901,$00000902,$00000903,$00000905,$00000906,$00000907,$00000908,
$00000909,$0000090a,$0000090b,$0000090e,$0000090f,$00000910,$0000090d,$00000912,
$00000913,$00000914,$00000911,$00000915,$00000916,$00000917,$00000918,$00000919,
$0000091a,$0000091b,$0000091c,$0000091d,$0000091e,$0000091f,$00000920,$00000921,
$00000922,$00000923,$00000924,$00000925,$00000926,$00000927,$00000928,$00000929,
$0000092a,$0000092b,$0000092c,$0000092d,$0000092e,$0000092f,$0000095f,$00000930,
$00000931,$00000932,$00000933,$00000934,$00000935,$00000936,$00000937,$00000938,
$00000939,$0000003f,$0000093e,$0000093f,$00000940,$00000941,$00000942,$00000943,
$00000946,$00000947,$00000948,$00000945,$0000094a,$0000094b,$0000094c,$00000949,
$0000094d,$0000200d,$00000964,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000966,$00000967,$00000968,$00000969,$0000096a,$0000096b,$0000096c,
$0000096d,$0000096e,$0000096f,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57003:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000981,$00000982,$00000983,$00000985,$00000986,$00000987,$00000988,
$00000989,$0000098a,$0000098b,$0000098f,$0000098f,$00000990,$00000990,$00000993,
$00000993,$00000994,$00000994,$00000995,$00000996,$00000997,$00000998,$00000999,
$0000099a,$0000099b,$0000099c,$0000099d,$0000099e,$0000099f,$000009a0,$000009a1,
$000009a2,$000009a3,$000009a4,$000009a5,$000009a6,$000009a7,$000009a8,$000009a8,
$000009aa,$000009ab,$000009ac,$000009ad,$000009ae,$000009af,$000009df,$000009b0,
$000009b0,$000009b2,$000009b2,$000009b2,$000009ac,$000009b6,$000009b7,$000009b8,
$000009b9,$0000003f,$000009be,$000009bf,$000009c0,$000009c1,$000009c2,$000009c3,
$000009c7,$000009c7,$000009c8,$000009c8,$000009cb,$000009cb,$000009cc,$000009cc,
$000009cd,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$000009e6,$000009e7,$000009e8,$000009e9,$000009ea,$000009eb,$000009ec,
$000009ed,$000009ee,$000009ef,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57004:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$0000003f,$00000b82,$00000b83,$00000b85,$00000b86,$00000b87,$00000b88,
$00000b89,$00000b8a,$0000003f,$00000b8f,$00000b8f,$00000b90,$00000b90,$00000b92,
$00000b93,$00000b94,$00000b94,$00000b95,$00000b95,$00000b95,$00000b95,$00000b99,
$00000b9a,$00000b9a,$00000b9c,$00000b9c,$00000b9e,$00000b9f,$00000b9f,$00000b9f,
$00000b9f,$00000ba3,$00000ba4,$00000ba4,$00000ba4,$00000ba4,$00000ba8,$00000ba9,
$00000baa,$00000baa,$00000baa,$00000baa,$00000bae,$00000baf,$00000baf,$00000bb0,
$00000bb1,$00000bb2,$00000bb3,$00000bb4,$00000bb5,$00000bb7,$00000bb7,$00000bb8,
$00000bb9,$0000003f,$00000bbe,$00000bbf,$00000bc0,$00000bc1,$00000bc2,$0000003f,
$00000bc6,$00000bc7,$00000bc8,$00000bc8,$00000bca,$00000bcb,$00000bcc,$00000bcc,
$00000bcd,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000030,$00000be7,$00000be8,$00000be9,$00000bea,$00000beb,$00000bec,
$00000bed,$00000bee,$00000bef,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57005:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000c01,$00000c02,$00000c03,$00000c05,$00000c06,$00000c07,$00000c08,
$00000c09,$00000c0a,$00000c0b,$00000c0e,$00000c0f,$00000c10,$00000c10,$00000c12,
$00000c13,$00000c14,$00000c14,$00000c15,$00000c16,$00000c17,$00000c18,$00000c19,
$00000c1a,$00000c1b,$00000c1c,$00000c1d,$00000c1e,$00000c1f,$00000c20,$00000c21,
$00000c22,$00000c23,$00000c24,$00000c25,$00000c26,$00000c27,$00000c28,$00000c28,
$00000c2a,$00000c2b,$00000c2c,$00000c2d,$00000c2e,$00000c2f,$00000c2f,$00000c30,
$00000c31,$00000c32,$00000c33,$00000c33,$00000c35,$00000c36,$00000c37,$00000c38,
$00000c39,$0000003f,$00000c3e,$00000c3f,$00000c40,$00000c41,$00000c42,$00000c43,
$00000c46,$00000c47,$00000c48,$00000c48,$00000c4a,$00000c4b,$00000c4c,$00000c4c,
$00000c4d,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000c66,$00000c67,$00000c68,$00000c69,$00000c6a,$00000c6b,$00000c6c,
$00000c6d,$00000c6e,$00000c6f,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57006:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000981,$00000982,$00000983,$00000985,$00000986,$00000987,$00000988,
$00000989,$0000098a,$0000098b,$0000098f,$0000098f,$00000990,$00000990,$00000993,
$00000993,$00000994,$00000994,$00000995,$00000996,$00000997,$00000998,$00000999,
$0000099a,$0000099b,$0000099c,$0000099d,$0000099e,$0000099f,$000009a0,$000009a1,
$000009a2,$000009a3,$000009a4,$000009a5,$000009a6,$000009a7,$000009a8,$000009a8,
$000009aa,$000009ab,$000009ac,$000009ad,$000009ae,$000009af,$000009df,$000009b0,
$000009b0,$000009b2,$000009b2,$000009b2,$000009ac,$000009b6,$000009b7,$000009b8,
$000009b9,$0000003f,$000009be,$000009bf,$000009c0,$000009c1,$000009c2,$000009c3,
$000009c7,$000009c7,$000009c8,$000009c8,$000009cb,$000009cb,$000009cc,$000009cc,
$000009cd,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$000009e6,$000009e7,$000009e8,$000009e9,$000009ea,$000009eb,$000009ec,
$000009ed,$000009ee,$000009ef,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57007:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000b01,$00000b02,$00000b03,$00000b05,$00000b06,$00000b07,$00000b08,
$00000b09,$00000b0a,$00000b0b,$00000b0f,$00000b0f,$00000b10,$00000b10,$00000b10,
$00000b13,$00000b14,$00000b14,$00000b15,$00000b16,$00000b17,$00000b18,$00000b19,
$00000b1a,$00000b1b,$00000b1c,$00000b1d,$00000b1e,$00000b1f,$00000b20,$00000b21,
$00000b22,$00000b23,$00000b24,$00000b25,$00000b26,$00000b27,$00000b28,$00000b28,
$00000b2a,$00000b2b,$00000b2c,$00000b2d,$00000b2e,$00000b2f,$00000b5f,$00000b30,
$00000b30,$00000b32,$00000b33,$00000b33,$00000b2c,$00000b36,$00000b37,$00000b38,
$00000b39,$0000003f,$00000b3e,$00000b3f,$00000b40,$00000b41,$00000b42,$00000b43,
$00000b47,$00000b47,$00000b48,$00000b48,$00000b4b,$00000b4b,$00000b4c,$00000b4c,
$00000b4d,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000b66,$00000b67,$00000b68,$00000b69,$00000b6a,$00000b6b,$00000b6c,
$00000b6d,$00000b6e,$00000b6f,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57008:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$0000003f,$00000c82,$00000c83,$00000c85,$00000c86,$00000c87,$00000c88,
$00000c89,$00000c8a,$00000c8b,$00000c8e,$00000c8f,$00000c90,$00000c90,$00000c92,
$00000c93,$00000c94,$00000c94,$00000c95,$00000c96,$00000c97,$00000c98,$00000c99,
$00000c9a,$00000c9b,$00000c9c,$00000c9d,$00000c9e,$00000c9f,$00000ca0,$00000ca1,
$00000ca2,$00000ca3,$00000ca4,$00000ca5,$00000ca6,$00000ca7,$00000ca8,$00000ca8,
$00000caa,$00000cab,$00000cac,$00000cad,$00000cae,$00000caf,$00000caf,$00000cb0,
$00000cb1,$00000cb2,$00000cb3,$00000cb3,$00000cb5,$00000cb6,$00000cb7,$00000cb8,
$00000cb9,$0000003f,$00000cbe,$00000cbf,$00000cc0,$00000cc1,$00000cc2,$00000cc3,
$00000cc6,$00000cc7,$00000cc8,$00000cc8,$00000cca,$00000ccb,$00000ccc,$00000ccc,
$00000ccd,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000ce6,$00000ce7,$00000ce8,$00000ce9,$00000cea,$00000ceb,$00000cec,
$00000ced,$00000cee,$00000cef,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57009:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$0000003f,$00000d02,$00000d03,$00000d05,$00000d06,$00000d07,$00000d08,
$00000d09,$00000d0a,$00000d0b,$00000d0e,$00000d0f,$00000d10,$00000d10,$00000d12,
$00000d13,$00000d14,$00000d14,$00000d15,$00000d16,$00000d17,$00000d18,$00000d19,
$00000d1a,$00000d1b,$00000d1c,$00000d1d,$00000d1e,$00000d1f,$00000d20,$00000d21,
$00000d22,$00000d23,$00000d24,$00000d25,$00000d26,$00000d27,$00000d28,$00000d28,
$00000d2a,$00000d2b,$00000d2c,$00000d2d,$00000d2e,$00000d2f,$00000d2f,$00000d30,
$00000d31,$00000d32,$00000d33,$00000d34,$00000d35,$00000d36,$00000d37,$00000d38,
$00000d39,$0000003f,$00000d3e,$00000d3f,$00000d40,$00000d41,$00000d42,$00000d43,
$00000d46,$00000d47,$00000d48,$00000d48,$00000d4a,$00000d4b,$00000d4c,$00000d4c,
$00000d4d,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000d66,$00000d67,$00000d68,$00000d69,$00000d6a,$00000d6b,$00000d6c,
$00000d6d,$00000d6e,$00000d6f,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57010:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$00000a81,$00000a82,$00000a83,$00000a85,$00000a86,$00000a87,$00000a88,
$00000a89,$00000a8a,$00000a8b,$00000a8f,$00000a8f,$00000a90,$00000a8d,$00000a8d,
$00000a93,$00000a94,$00000a91,$00000a95,$00000a96,$00000a97,$00000a98,$00000a99,
$00000a9a,$00000a9b,$00000a9c,$00000a9d,$00000a9e,$00000a9f,$00000aa0,$00000aa1,
$00000aa2,$00000aa3,$00000aa4,$00000aa5,$00000aa6,$00000aa7,$00000aa8,$00000aa8,
$00000aaa,$00000aab,$00000aac,$00000aad,$00000aae,$00000aaf,$00000aaf,$00000ab0,
$00000ab0,$00000ab2,$00000ab3,$00000ab3,$00000ab5,$00000ab6,$00000ab7,$00000ab8,
$00000ab9,$0000003f,$00000abe,$00000abf,$00000ac0,$00000ac1,$00000ac2,$00000ac3,
$00000ac7,$00000ac7,$00000ac8,$00000ac5,$00000acb,$00000acb,$00000acc,$00000ac9,
$00000acd,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000ae6,$00000ae7,$00000ae8,$00000ae9,$00000aea,$00000aeb,$00000aec,
$00000aed,$00000aee,$00000aef,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetCodePage57011:TPUCUCharSetCodePage=(
$00000000,$00000001,$00000002,$00000003,$00000004,$00000005,$00000006,$00000007,
$00000008,$00000009,$0000000a,$0000000b,$0000000c,$0000000d,$0000000e,$0000000f,
$00000010,$00000011,$00000012,$00000013,$00000014,$00000015,$00000016,$00000017,
$00000018,$00000019,$0000001a,$0000001b,$0000001c,$0000001d,$0000001e,$0000001f,
$00000020,$00000021,$00000022,$00000023,$00000024,$00000025,$00000026,$00000027,
$00000028,$00000029,$0000002a,$0000002b,$0000002c,$0000002d,$0000002e,$0000002f,
$00000030,$00000031,$00000032,$00000033,$00000034,$00000035,$00000036,$00000037,
$00000038,$00000039,$0000003a,$0000003b,$0000003c,$0000003d,$0000003e,$0000003f,
$00000040,$00000041,$00000042,$00000043,$00000044,$00000045,$00000046,$00000047,
$00000048,$00000049,$0000004a,$0000004b,$0000004c,$0000004d,$0000004e,$0000004f,
$00000050,$00000051,$00000052,$00000053,$00000054,$00000055,$00000056,$00000057,
$00000058,$00000059,$0000005a,$0000005b,$0000005c,$0000005d,$0000005e,$0000005f,
$00000060,$00000061,$00000062,$00000063,$00000064,$00000065,$00000066,$00000067,
$00000068,$00000069,$0000006a,$0000006b,$0000006c,$0000006d,$0000006e,$0000006f,
$00000070,$00000071,$00000072,$00000073,$00000074,$00000075,$00000076,$00000077,
$00000078,$00000079,$0000007a,$0000007b,$0000007c,$0000007d,$0000007e,$0000007f,
$00000080,$00000081,$00000082,$00000083,$00000084,$00000085,$00000086,$00000087,
$00000088,$00000089,$0000008a,$0000008b,$0000008c,$0000008d,$0000008e,$0000008f,
$00000090,$00000091,$00000092,$00000093,$00000094,$00000095,$00000096,$00000097,
$00000098,$00000099,$0000009a,$0000009b,$0000009c,$0000009d,$0000009e,$0000009f,
$0000003f,$0000003f,$00000a02,$0000003f,$00000a05,$00000a06,$00000a07,$00000a08,
$00000a09,$00000a0a,$0000003f,$00000a0f,$00000a0f,$00000a10,$00000a10,$00000a10,
$00000a13,$00000a14,$00000a14,$00000a15,$00000a16,$00000a17,$00000a18,$00000a19,
$00000a1a,$00000a1b,$00000a1c,$00000a1d,$00000a1e,$00000a1f,$00000a20,$00000a21,
$00000a22,$00000a23,$00000a24,$00000a25,$00000a26,$00000a27,$00000a28,$00000a28,
$00000a2a,$00000a2b,$00000a2c,$00000a2d,$00000a2e,$00000a2f,$00000a2f,$00000a30,
$00000a30,$00000a32,$00000a33,$00000a33,$00000a35,$00000a36,$00000a36,$00000a38,
$00000a39,$0000003f,$00000a3e,$00000a3f,$00000a40,$00000a41,$00000a42,$0000003f,
$00000a47,$00000a47,$00000a48,$00000a48,$00000a4b,$00000a4b,$00000a4c,$00000a4c,
$00000a4d,$0000200d,$0000002e,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f,
$0000003f,$00000a66,$00000a67,$00000a68,$00000a69,$00000a6a,$00000a6b,$00000a6c,
$00000a6d,$00000a6e,$00000a6f,$0000003f,$0000003f,$0000003f,$0000003f,$0000003f);
const PUCUCharSetSubSubCodePage2:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage37,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage27:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage437,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage31:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage500,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage44:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage708,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage45:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage720,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage46:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage737,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage48:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage775,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage53:TPUCUCharSetSubSubCodePages=(
nil,
nil,
@PUCUCharSetCodePage850,
nil,
@PUCUCharSetCodePage852,
nil,
nil,
@PUCUCharSetCodePage855,
nil,
@PUCUCharSetCodePage857,
@PUCUCharSetCodePage858,
nil,
@PUCUCharSetCodePage860,
@PUCUCharSetCodePage861,
@PUCUCharSetCodePage862,
@PUCUCharSetCodePage863
);
const PUCUCharSetSubSubCodePage54:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage864,
@PUCUCharSetCodePage865,
@PUCUCharSetCodePage866,
nil,
nil,
@PUCUCharSetCodePage869,
@PUCUCharSetCodePage870,
nil,
nil,
nil,
@PUCUCharSetCodePage874,
@PUCUCharSetCodePage875,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage58:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage59:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage64:TPUCUCharSetSubSubCodePages=(
nil,
nil,
@PUCUCharSetCodePage1026,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage65:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage1047,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage71:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage1140,
@PUCUCharSetCodePage1141,
@PUCUCharSetCodePage1142,
@PUCUCharSetCodePage1143,
@PUCUCharSetCodePage1144,
@PUCUCharSetCodePage1145,
@PUCUCharSetCodePage1146,
@PUCUCharSetCodePage1147,
@PUCUCharSetCodePage1148,
@PUCUCharSetCodePage1149,
nil,
nil
);
const PUCUCharSetSubSubCodePage78:TPUCUCharSetSubSubCodePages=(
nil,
nil,
@PUCUCharSetCodePage1250,
@PUCUCharSetCodePage1251,
@PUCUCharSetCodePage1252,
@PUCUCharSetCodePage1253,
@PUCUCharSetCodePage1254,
@PUCUCharSetCodePage1255,
@PUCUCharSetCodePage1256,
@PUCUCharSetCodePage1257,
@PUCUCharSetCodePage1258,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage85:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage625:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage10000,
nil,
nil,
nil,
@PUCUCharSetCodePage10004,
@PUCUCharSetCodePage10005,
@PUCUCharSetCodePage10006,
@PUCUCharSetCodePage10007,
nil,
nil,
@PUCUCharSetCodePage10010,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage626:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage10017,
nil,
nil,
nil,
@PUCUCharSetCodePage10021,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage10029,
nil,
nil
);
const PUCUCharSetSubSubCodePage629:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage10079
);
const PUCUCharSetSubSubCodePage630:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage10081,
@PUCUCharSetCodePage10082,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1250:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1256:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20105,
@PUCUCharSetCodePage20106,
@PUCUCharSetCodePage20107,
@PUCUCharSetCodePage20108,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1257:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20127
);
const PUCUCharSetSubSubCodePage1266:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20269,
nil,
nil
);
const PUCUCharSetSubSubCodePage1267:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage20273,
nil,
nil,
nil,
@PUCUCharSetCodePage20277,
@PUCUCharSetCodePage20278,
nil,
@PUCUCharSetCodePage20280,
nil,
nil,
nil,
@PUCUCharSetCodePage20284,
@PUCUCharSetCodePage20285,
nil,
nil
);
const PUCUCharSetSubSubCodePage1268:TPUCUCharSetSubSubCodePages=(
nil,
nil,
@PUCUCharSetCodePage20290,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20297,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1276:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20420,
nil,
nil,
@PUCUCharSetCodePage20423,
@PUCUCharSetCodePage20424,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1302:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage20833,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20838,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1304:TPUCUCharSetSubSubCodePages=(
nil,
nil,
@PUCUCharSetCodePage20866,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20871,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1305:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage20880,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1306:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20905,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1307:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage20924,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1308:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1309:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1314:TPUCUCharSetSubSubCodePages=(
nil,
@PUCUCharSetCodePage21025,
nil,
@PUCUCharSetCodePage21027,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1366:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage21866,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage1786:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage28591
);
const PUCUCharSetSubSubCodePage1787:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage28592,
@PUCUCharSetCodePage28593,
@PUCUCharSetCodePage28594,
@PUCUCharSetCodePage28595,
@PUCUCharSetCodePage28596,
@PUCUCharSetCodePage28597,
@PUCUCharSetCodePage28598,
@PUCUCharSetCodePage28599,
nil,
nil,
nil,
@PUCUCharSetCodePage28603,
nil,
@PUCUCharSetCodePage28605,
nil,
nil
);
const PUCUCharSetSubSubCodePage2412:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage38598,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3138:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3139:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3246:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3308:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3433:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3437:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage3562:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodePage57002,
@PUCUCharSetCodePage57003,
@PUCUCharSetCodePage57004,
@PUCUCharSetCodePage57005,
@PUCUCharSetCodePage57006,
@PUCUCharSetCodePage57007
);
const PUCUCharSetSubSubCodePage3563:TPUCUCharSetSubSubCodePages=(
@PUCUCharSetCodePage57008,
@PUCUCharSetCodePage57009,
@PUCUCharSetCodePage57010,
@PUCUCharSetCodePage57011,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetSubSubCodePage4062:TPUCUCharSetSubSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage0:TPUCUCharSetSubCodePages=(
nil,
nil,
@PUCUCharSetSubSubCodePage2,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage1:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage27,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage31
);
const PUCUCharSetCodeSubPage2:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage44,
@PUCUCharSetSubSubCodePage45,
@PUCUCharSetSubSubCodePage46,
nil
);
const PUCUCharSetCodeSubPage3:TPUCUCharSetSubCodePages=(
@PUCUCharSetSubSubCodePage48,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage53,
@PUCUCharSetSubSubCodePage54,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage58,
@PUCUCharSetSubSubCodePage59,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage4:TPUCUCharSetSubCodePages=(
@PUCUCharSetSubSubCodePage64,
@PUCUCharSetSubSubCodePage65,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage71,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage78,
nil
);
const PUCUCharSetCodeSubPage5:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage85,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage39:TPUCUCharSetSubCodePages=(
nil,
@PUCUCharSetSubSubCodePage625,
@PUCUCharSetSubSubCodePage626,
nil,
nil,
@PUCUCharSetSubSubCodePage629,
@PUCUCharSetSubSubCodePage630,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage78:TPUCUCharSetSubCodePages=(
nil,
nil,
@PUCUCharSetSubSubCodePage1250,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage1256,
@PUCUCharSetSubSubCodePage1257,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage79:TPUCUCharSetSubCodePages=(
nil,
nil,
@PUCUCharSetSubSubCodePage1266,
@PUCUCharSetSubSubCodePage1267,
@PUCUCharSetSubSubCodePage1268,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage1276,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage81:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage1302,
nil,
@PUCUCharSetSubSubCodePage1304,
@PUCUCharSetSubSubCodePage1305,
@PUCUCharSetSubSubCodePage1306,
@PUCUCharSetSubSubCodePage1307,
@PUCUCharSetSubSubCodePage1308,
@PUCUCharSetSubSubCodePage1309,
nil,
nil
);
const PUCUCharSetCodeSubPage82:TPUCUCharSetSubCodePages=(
nil,
nil,
@PUCUCharSetSubSubCodePage1314,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage85:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage1366,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage111:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage1786,
@PUCUCharSetSubSubCodePage1787,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage150:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage2412,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage196:TPUCUCharSetSubCodePages=(
nil,
nil,
@PUCUCharSetSubSubCodePage3138,
@PUCUCharSetSubSubCodePage3139,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage202:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage3246,
nil
);
const PUCUCharSetCodeSubPage206:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage3308,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage214:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage3433,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage3437,
nil,
nil
);
const PUCUCharSetCodeSubPage222:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage3562,
@PUCUCharSetSubSubCodePage3563,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPage253:TPUCUCharSetSubCodePages=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePage4062,
nil
);
const PUCUCharSetCodePages:TPUCUCharSetCodePages=(
@PUCUCharSetCodeSubPage0,
@PUCUCharSetCodeSubPage1,
@PUCUCharSetCodeSubPage2,
@PUCUCharSetCodeSubPage3,
@PUCUCharSetCodeSubPage4,
@PUCUCharSetCodeSubPage5,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage39,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage78,
@PUCUCharSetCodeSubPage79,
nil,
@PUCUCharSetCodeSubPage81,
@PUCUCharSetCodeSubPage82,
nil,
nil,
@PUCUCharSetCodeSubPage85,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage111,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage150,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage196,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage202,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage206,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage214,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage222,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPage253,
nil,
nil
);
const PUCUCharSetSubSubCodePageNames2:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'37    (IBM EBCDIC - USA/Kanada)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames27:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'437   (OEM - Vereinigte Staaten)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames31:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'500   (IBM EBCDIC - International)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames44:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'708   (Arabisch - ASMO)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames45:TPUCUCharSetSubSubCodePageNames=(
'720   (Arabisch- Transparent ASMO)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames46:TPUCUCharSetSubSubCodePageNames=(
'',
'737   (OEM - Griechisch 437G)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames48:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'775   (OEM - Baltisch)',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames53:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'850   (OEM - Multilingual Lateinisch I)',
'',
'852   (OEM - Lateinisch II)',
'',
'',
'855   (OEM - Kyrillisch)',
'',
'857   (OEM - T'#$FC'rkisch)',
'858   (OEM - Multilingual Lateinisch I + Euro)',
'',
'860   (OEM - Portugiesisch)',
'861   (OEM - Isl'#$E4'ndisch)',
'862   (OEM - Hebr'#$E4'isch)',
'863   (OEM - Franz'#$F6'sch (Kanada))'
);
const PUCUCharSetSubSubCodePageNames54:TPUCUCharSetSubSubCodePageNames=(
'864   (OEM - Arabisch)',
'865   (OEM - Nordisch)',
'866   (OEM - Russisch)',
'',
'',
'869   (OEM - Modernes Griechisch)',
'870   (IBM EBCDIC - Multilingual/ROECE (Lateinisch-2))',
'',
'',
'',
'874   (ANSI/OEM - Thai)',
'875   (IBM EBCDIC - Modernes Griechisch)',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames58:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames59:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames64:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'1026  (IBM EBCDIC - T'#$FC'rkisch (Lateinisch-5))',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames65:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'1047  (IBM EBCDIC - Lateinisch-1/Offenes System)',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames71:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'1140  (IBM EBCDIC - USA/Kanada (37 + Euro))',
'1141  (IBM EBCDIC - Deutschland (20273 + Euro))',
'1142  (IBM EBCDIC - D'#$E4'nemark/Norwegen (20277 + Euro))',
'1143  (IBM EBCDIC - Finnland/Schweden (20278 + Euro))',
'1144  (IBM EBCDIC - Italien (20280 + Euro))',
'1145  (IBM EBCDIC - Lateinamerika/Spanien (20284 + Euro))',
'1146  (IBM EBCDIC - Vereinigtes K'#$F6'nigreich (20285 + Euro))',
'1146  (IBM EBCDIC - ',
'1148  (IBM EBCDIC - International (500 + Euro))',
'1149  (IBM EBCDIC - Isl'#$E4'ndisch (20871 + Euro))',
'',
''
);
const PUCUCharSetSubSubCodePageNames78:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'1250  (ANSI - Osteuropa)',
'1251  (ANSI - Kyrillisch)',
'1252  (ANSI - Lateinisch I)',
'1253  (ANSI - Griechisch)',
'1254  (ANSI - T'#$FC'rkisch)',
'1255  (ANSI - Hebr'#$E4'isch)',
'1256  (ANSI - Arabisch)',
'1257  (ANSI - Baltisch)',
'1258  (ANSI/OEM - Vietnam)',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames85:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames625:TPUCUCharSetSubSubCodePageNames=(
'10000 (MAC - Romanisch)',
'',
'',
'',
'10004 (MAC - Arabisch)',
'10005 (MAC - Hebr'#$E4'isch)',
'10006 (MAC - Griechisch I)',
'10007 (MAC - Kyrillisch)',
'',
'',
'10010 (MAC - Rum'#$E4'nisch)',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames626:TPUCUCharSetSubSubCodePageNames=(
'',
'10017 (MAC - Ukrainisch)',
'',
'',
'',
'10021 (MAC - Thai)',
'',
'',
'',
'',
'',
'',
'',
'10029 (MAC - Lateinisch II)',
'',
''
);
const PUCUCharSetSubSubCodePageNames629:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'10079 (MAC - Isl'#$E4'ndisch)'
);
const PUCUCharSetSubSubCodePageNames630:TPUCUCharSetSubSubCodePageNames=(
'',
'10081 (MAC - T'#$FC'rkisch)',
'10082 (MAC - Kroatisch)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1250:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1256:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'20105 (IA5 IRV Internationales Alphabet Nr. 5)',
'20106 (IA5 Deutsch)',
'20107 (IA5 Swedisch)',
'20108 (IA5 Norwegisch)',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1257:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'20127 (US-ASCII)'
);
const PUCUCharSetSubSubCodePageNames1266:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'20269 (ISO 6937 Akzent ohne Zwischenraum)',
'',
''
);
const PUCUCharSetSubSubCodePageNames1267:TPUCUCharSetSubSubCodePageNames=(
'',
'20273 (IBM EBCDIC - Deutschland)',
'',
'',
'',
'20277 (IBM EBCDIC - D'#$E4'nemark/Norwegen)',
'20278 (IBM EBCDIC - Finnland/Schweden)',
'',
'20280 (IBM EBCDIC - Italien)',
'',
'',
'',
'20284 (IBM EBCDIC - Lateinamerika/Spanien)',
'20285 (IBM EBCDIC - Gro'#$DF'britannien)',
'',
''
);
const PUCUCharSetSubSubCodePageNames1268:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'20290 (IBM EBCDIC - Japanisch (erweitertes Katakana))',
'',
'',
'',
'',
'',
'',
'20297 (IBM EBCDIC - Frankreich)',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1276:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'20420 (IBM EBCDIC - Arabisch)',
'',
'',
'20423 (IBM EBCDIC - Griechisch)',
'20424 (IBM EBCDIC - Hebr'#$E4'isch)',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1302:TPUCUCharSetSubSubCodePageNames=(
'',
'20833 (IBM EBCDIC - erweitertes Koreanisch)',
'',
'',
'',
'',
'20838 (IBM EBCDIC - Thai)',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1304:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'20866 (Russisch - KOI8)',
'',
'',
'',
'',
'20871 (IBM EBCDIC - Isl'#$E4'ndisch)',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1305:TPUCUCharSetSubSubCodePageNames=(
'20880 (IBM EBCDIC - Kyrillisch (Russisch))',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1306:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'20905 (IBM EBCDIC - T'#$FC'rkisch)',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1307:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'20924 (IBM EBCDIC - Lateinisch-1/Offenes System (1047 + Euro))',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1308:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1309:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1314:TPUCUCharSetSubSubCodePageNames=(
'',
'21025 (IBM EBCDIC - Kyrillisch (Serbisch, Bulgarisch))',
'',
'21027 (Ext Alpha Kleinbuchstaben)',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1366:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'21866 (Ukrainisch - KOI8-U)',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames1786:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'28591 (ISO 8859-1 Lateinisch I)'
);
const PUCUCharSetSubSubCodePageNames1787:TPUCUCharSetSubSubCodePageNames=(
'28592 (ISO 8859-2 Osteuropa)',
'28593 (ISO 8859-3 Lateinisch 3)',
'28594 (ISO 8859-4 Baltisch)',
'28595 (ISO 8859-5 Kyrillisch)',
'28596 (ISO 8859-6 Arabisch)',
'28597 (ISO 8859-7 Griechisch)',
'28598 (ISO 8859-8 Hebr'#$E4'isch: Visuelle Sortierung)',
'28599 (ISO 8859-9 Lateinisch 5)',
'',
'',
'',
'28603 (ISO 8859-13 Lateinisch 7)',
'',
'28605 (ISO 8859-15 Lateinisch 9)',
'',
''
);
const PUCUCharSetSubSubCodePageNames2412:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'38598 (ISO 8859-8 Hebr'#$E4'isch: Logische Sortierung)',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3138:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3139:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3246:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3308:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3433:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3437:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames3562:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'57002 (ISCII - Devanagari)',
'57003 (ISCII - Bengali)',
'57004 (ISCII - Tamil)',
'57005 (ISCII - Telugu)',
'57006 (ISCII - Assamisch)',
'57007 (ISCII - Odia (Oriya))'
);
const PUCUCharSetSubSubCodePageNames3563:TPUCUCharSetSubSubCodePageNames=(
'57008 (ISCII - Kannada)',
'57009 (ISCII - Malajalam)',
'57010 (ISCII - Gudscharati)',
'57011 (ISCII - Punjabi (Gurmukhi))',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetSubSubCodePageNames4062:TPUCUCharSetSubSubCodePageNames=(
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
'',
''
);
const PUCUCharSetCodeSubPageNames0:TPUCUCharSetSubCodePageNames=(
nil,
nil,
@PUCUCharSetSubSubCodePageNames2,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames1:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames27,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames31
);
const PUCUCharSetCodeSubPageNames2:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames44,
@PUCUCharSetSubSubCodePageNames45,
@PUCUCharSetSubSubCodePageNames46,
nil
);
const PUCUCharSetCodeSubPageNames3:TPUCUCharSetSubCodePageNames=(
@PUCUCharSetSubSubCodePageNames48,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames53,
@PUCUCharSetSubSubCodePageNames54,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames58,
@PUCUCharSetSubSubCodePageNames59,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames4:TPUCUCharSetSubCodePageNames=(
@PUCUCharSetSubSubCodePageNames64,
@PUCUCharSetSubSubCodePageNames65,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames71,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames78,
nil
);
const PUCUCharSetCodeSubPageNames5:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames85,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames39:TPUCUCharSetSubCodePageNames=(
nil,
@PUCUCharSetSubSubCodePageNames625,
@PUCUCharSetSubSubCodePageNames626,
nil,
nil,
@PUCUCharSetSubSubCodePageNames629,
@PUCUCharSetSubSubCodePageNames630,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames78:TPUCUCharSetSubCodePageNames=(
nil,
nil,
@PUCUCharSetSubSubCodePageNames1250,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames1256,
@PUCUCharSetSubSubCodePageNames1257,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames79:TPUCUCharSetSubCodePageNames=(
nil,
nil,
@PUCUCharSetSubSubCodePageNames1266,
@PUCUCharSetSubSubCodePageNames1267,
@PUCUCharSetSubSubCodePageNames1268,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames1276,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames81:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames1302,
nil,
@PUCUCharSetSubSubCodePageNames1304,
@PUCUCharSetSubSubCodePageNames1305,
@PUCUCharSetSubSubCodePageNames1306,
@PUCUCharSetSubSubCodePageNames1307,
@PUCUCharSetSubSubCodePageNames1308,
@PUCUCharSetSubSubCodePageNames1309,
nil,
nil
);
const PUCUCharSetCodeSubPageNames82:TPUCUCharSetSubCodePageNames=(
nil,
nil,
@PUCUCharSetSubSubCodePageNames1314,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames85:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames1366,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames111:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames1786,
@PUCUCharSetSubSubCodePageNames1787,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames150:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames2412,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames196:TPUCUCharSetSubCodePageNames=(
nil,
nil,
@PUCUCharSetSubSubCodePageNames3138,
@PUCUCharSetSubSubCodePageNames3139,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames202:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames3246,
nil
);
const PUCUCharSetCodeSubPageNames206:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames3308,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames214:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames3433,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames3437,
nil,
nil
);
const PUCUCharSetCodeSubPageNames222:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames3562,
@PUCUCharSetSubSubCodePageNames3563,
nil,
nil,
nil,
nil
);
const PUCUCharSetCodeSubPageNames253:TPUCUCharSetSubCodePageNames=(
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetSubSubCodePageNames4062,
nil
);
const PUCUCharSetCodePageNames:TPUCUCharSetCodePageNames=(
@PUCUCharSetCodeSubPageNames0,
@PUCUCharSetCodeSubPageNames1,
@PUCUCharSetCodeSubPageNames2,
@PUCUCharSetCodeSubPageNames3,
@PUCUCharSetCodeSubPageNames4,
@PUCUCharSetCodeSubPageNames5,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames39,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames78,
@PUCUCharSetCodeSubPageNames79,
nil,
@PUCUCharSetCodeSubPageNames81,
@PUCUCharSetCodeSubPageNames82,
nil,
nil,
@PUCUCharSetCodeSubPageNames85,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames111,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames150,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames196,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames202,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames206,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames214,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames222,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
nil,
@PUCUCharSetCodeSubPageNames253,
nil,
nil
);

function PUCUUnicodeGetCategoryFromTable(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeGetScriptFromTable(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeGetUpperCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeGetLowerCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeGetTitleCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeIsWord(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeIsIDBegin(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeIsIDPart(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeIsWhiteSpace(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeToUpper(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeToLower(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
function PUCUUnicodeToTitle(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}

function PUCUIsUTF8(const s:TPUCURawByteString):boolean;
function PUCUUTF8Validate(const s:TPUCURawByteString):boolean;
function PUCUUTF8Get(const s:TPUCURawByteString):TPUCUInt32;
function PUCUUTF8PtrGet(const s:PPUCURawByteChar;Len:TPUCUInt32):TPUCUInt32;
procedure PUCUUTF8SafeInc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
procedure PUCUUTF8PtrSafeInc(const s:PPUCURawByteChar;var Len,CodeUnit:TPUCUInt32);
procedure PUCUUTF8Inc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
procedure PUCUUTF8PtrInc(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32);
procedure PUCUUTF8Dec(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
procedure PUCUUTF8PtrDec(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32);
procedure PUCUUTF8Delete(var s:TPUCURawByteString;CodeUnit:TPUCUInt32);
function PUCUUTF8Length(const s:TPUCURawByteString):TPUCUInt32;{$ifdef cpu386}assembler; register;{$endif}
function PUCUUTF8PtrLength(const s:TPUCURawByteString;Len:TPUCUInt32):TPUCUInt32;{$ifdef cpu386}assembler; register;{$endif}
function PUCUUTF8LengthEx(const s:TPUCURawByteString):TPUCUInt32;
function PUCUUTF8GetCodePoint(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUInt32;
function PUCUUTF8PtrGetCodePoint(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUInt32;
function PUCUUTF8GetCodeUnit(const s:TPUCURawByteString;CodePoint:TPUCUInt32):TPUCUInt32;
function PUCUUTF8PtrGetCodeUnit(const s:TPUCURawByteString;Len,CodePoint:TPUCUInt32):TPUCUInt32;
function PUCUUTF8CodeUnitGetChar(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8PtrCodeUnitGetChar(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8PtrCodeUnitGetCharFallback(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8CodeUnitGetCharAndInc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8PtrCodeUnitGetCharAndInc(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8CodeUnitGetCharFallback(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8CodeUnitGetCharAndIncFallback(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8PtrCodeUnitGetCharAndIncFallback(const s:PPUCURawByteChar;const Len:TPUCUInt32;var CodeUnit:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8CodePointGetChar(const s:TPUCURawByteString;CodePoint:TPUCUInt32;Fallback:boolean=false):TPUCUUInt32;
function PUCUUTF8GetCharLen(const s:TPUCURawByteString;i:TPUCUInt32):TPUCUUInt32;
function PUCUUTF8Pos(const FindStr,InStr:TPUCURawByteString):TPUCUInt32;
function PUCUUTF8Copy(const Str:TPUCURawByteString;Start,Len:TPUCUInt32):TPUCURawByteString;
function PUCUUTF8UpperCase(const Str:TPUCURawByteString):TPUCURawByteString;
function PUCUUTF8LowerCase(const Str:TPUCURawByteString):TPUCURawByteString;
function PUCUUTF8Trim(const Str:TPUCURawByteString):TPUCURawByteString;
function PUCUUTF8Correct(const Str:TPUCURawByteString):TPUCURawByteString;
function PUCUUTF8FromLatin1(const Str:TPUCURawByteString):TPUCURawByteString;
function PUCUUTF8LevenshteinDistance(const s,t:TPUCURawByteString):TPUCUInt32;
function PUCUUTF8DamerauLevenshteinDistance(const s,t:TPUCURawByteString):TPUCUInt32;
function PUCUStringLength(const s:TPUCURawByteString):TPUCUInt32;

function PUCUUTF16Correct(const Str:TPUCUUTF16String):TPUCUUTF16String;
function PUCUUTF16UpperCase(const Str:TPUCUUTF16String):TPUCUUTF16String;
function PUCUUTF16LowerCase(const Str:TPUCUUTF16String):TPUCUUTF16String;

function PUCUUTF32CharToUTF8(CharValue:TPUCUUTF32Char):TPUCURawByteString;
function PUCUUTF32CharToUTF8Len(CharValue:TPUCUUTF32Char):TPUCUInt32;

function PUCUUTF32ToUTF8(const s:TPUCUUTF32String):TPUCUUTF8String;
function PUCUUTF8ToUTF32(const s:TPUCUUTF8String):TPUCUUTF32String;

function PUCUUTF8ToUTF16(const s:TPUCUUTF8String):TPUCUUTF16STRING;
function PUCUUTF16ToUTF8(const s:TPUCUUTF16STRING):TPUCUUTF8String;

function PUCUUTF16ToUTF32(const Value:TPUCUUTF16String):TPUCUUTF32String;
function PUCUUTF32ToUTF16(const Value:TPUCUUTF32String):TPUCUUTF16String;

function PUCUUTF32CharToUTF16(const Value:TPUCUUTF32Char):TPUCUUTF16String;
function PUCUUTF32CharToUTF16Len(const Value:TPUCUUTF32Char):TPUCUInt32;

function PUCURawDataToUTF8String(const pData;const pDataLength:TPUCUInt32;const pCodePage:TPUCUInt32=-1):TPUCUUTF8String;
function PUCURawDataToUTF16String(const pData;const pDataLength:TPUCUInt32;const pCodePage:TPUCUInt32=-1):TPUCUUTF16String;
function PUCURawDataToUTF32String(const pData;const pDataLength:TPUCUInt32;const pCodePage:TPUCUInt32=-1):TPUCUUTF32String;

function PUCURawByteStringToUTF8String(const pString:TPUCURawByteString;const pCodePage:TPUCUInt32=-1):TPUCUUTF8String;
function PUCURawByteStringToUTF16String(const pString:TPUCURawByteString;const pCodePage:TPUCUInt32=-1):TPUCUUTF16String;
function PUCURawByteStringToUTF32String(const pString:TPUCURawByteString;const pCodePage:TPUCUInt32=-1):TPUCUUTF32String;

function PUCURawStreamToUTF8String(const pStream:TStream;const pCodePage:TPUCUInt32=-1):TPUCUUTF8String;
function PUCURawStreamToUTF16String(const pStream:TStream;const pCodePage:TPUCUInt32=-1):TPUCUUTF16String;
function PUCURawStreamToUTF32String(const pStream:TStream;const pCodePage:TPUCUInt32=-1):TPUCUUTF32String;

implementation

function PUCUUnicodeGetCategoryFromTable(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
var Index:TPUCUUInt32;
begin
 if c<=$10ffff then begin
  Index:=c shr PUCUUnicodeCategoryArrayBlockBits;
  result:=PUCUUnicodeCategoryArrayBlockData[PUCUUnicodeCategoryArrayIndexBlockData[PUCUUnicodeCategoryArrayIndexIndexData[Index shr PUCUUnicodeCategoryArrayIndexBlockBits],Index and PUCUUnicodeCategoryArrayIndexBlockMask],c and PUCUUnicodeCategoryArrayBlockMask];
 end else begin
  result:=0;
 end;
end;

function PUCUUnicodeGetScriptFromTable(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
var Index:TPUCUUInt32;
begin
 if c<=$10ffff then begin
  Index:=c shr PUCUUnicodeScriptArrayBlockBits;
  result:=PUCUUnicodeScriptArrayBlockData[PUCUUnicodeScriptArrayIndexBlockData[PUCUUnicodeScriptArrayIndexIndexData[Index shr PUCUUnicodeScriptArrayIndexBlockBits],Index and PUCUUnicodeScriptArrayIndexBlockMask],c and PUCUUnicodeScriptArrayBlockMask];
 end else begin
  result:=0;
 end;
end;

function PUCUUnicodeGetUpperCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
var Index:TPUCUUInt32;
begin
 if c<=$10ffff then begin
  Index:=c shr PUCUUnicodeUpperCaseDeltaArrayBlockBits;
  result:=PUCUUnicodeUpperCaseDeltaArrayBlockData[PUCUUnicodeUpperCaseDeltaArrayIndexBlockData[PUCUUnicodeUpperCaseDeltaArrayIndexIndexData[Index shr PUCUUnicodeUpperCaseDeltaArrayIndexBlockBits],Index and PUCUUnicodeUpperCaseDeltaArrayIndexBlockMask],c and PUCUUnicodeUpperCaseDeltaArrayBlockMask];
 end else begin
  result:=0;
 end;
end;

function PUCUUnicodeGetLowerCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
var Index:TPUCUUInt32;
begin
 if c<=$10ffff then begin
  Index:=c shr PUCUUnicodeLowerCaseDeltaArrayBlockBits;
  result:=PUCUUnicodeLowerCaseDeltaArrayBlockData[PUCUUnicodeLowerCaseDeltaArrayIndexBlockData[PUCUUnicodeLowerCaseDeltaArrayIndexIndexData[Index shr PUCUUnicodeLowerCaseDeltaArrayIndexBlockBits],Index and PUCUUnicodeLowerCaseDeltaArrayIndexBlockMask],c and PUCUUnicodeLowerCaseDeltaArrayBlockMask];
 end else begin
  result:=0;
 end;
end;

function PUCUUnicodeGetTitleCaseDeltaFromTable(c:TPUCUUInt32):TPUCUInt32; {$ifdef caninline}inline;{$endif}
var Index:TPUCUUInt32;
begin
 if c<=$10ffff then begin
  Index:=c shr PUCUUnicodeTitleCaseDeltaArrayBlockBits;
  result:=PUCUUnicodeTitleCaseDeltaArrayBlockData[PUCUUnicodeTitleCaseDeltaArrayIndexBlockData[PUCUUnicodeTitleCaseDeltaArrayIndexIndexData[Index shr PUCUUnicodeTitleCaseDeltaArrayIndexBlockBits],Index and PUCUUnicodeTitleCaseDeltaArrayIndexBlockMask],c and PUCUUnicodeTitleCaseDeltaArrayBlockMask];
 end else begin
  result:=0;
 end;
end;

function PUCUUnicodeIsWord(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
begin
 result:=(PUCUUnicodeGetCategoryFromTable(c) in [PUCUUnicodeCategoryLu,PUCUUnicodeCategoryLl,PUCUUnicodeCategoryLt,PUCUUnicodeCategoryLm,PUCUUnicodeCategoryLo,PUCUUnicodeCategoryNd,PUCUUnicodeCategoryNl,PUCUUnicodeCategoryNo,PUCUUnicodeCategoryPc]) or (c=ord('_'));
end;

function PUCUUnicodeIsIDBegin(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
begin
 result:=(PUCUUnicodeGetCategoryFromTable(c) in [PUCUUnicodeCategoryLu,PUCUUnicodeCategoryLl,PUCUUnicodeCategoryLt,PUCUUnicodeCategoryLm,PUCUUnicodeCategoryLo,PUCUUnicodeCategoryNl,PUCUUnicodeCategoryNo,PUCUUnicodeCategoryPc]) or (c=ord('_'));
end;

function PUCUUnicodeIsIDPart(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
begin
 result:=(PUCUUnicodeGetCategoryFromTable(c) in [PUCUUnicodeCategoryLu,PUCUUnicodeCategoryLl,PUCUUnicodeCategoryLt,PUCUUnicodeCategoryLm,PUCUUnicodeCategoryLo,PUCUUnicodeCategoryNd,PUCUUnicodeCategoryNl,PUCUUnicodeCategoryNo,PUCUUnicodeCategoryPc]) or (c=ord('_'));
end;

function PUCUUnicodeIsWhiteSpace(c:TPUCUUInt32):boolean; {$ifdef caninline}inline;{$endif}
begin
//result:=UnicodeGetCategoryFromTable(c) in [PUCUUnicodeCategoryZs,PUCUUnicodeCategoryZp,PUCUUnicodeCategoryZl];
 result:=((c>=$0009) and (c<=$000d)) or (c=$0020) or (c=$00a0) or (c=$1680) or (c=$180e) or ((c>=$2000) and (c<=$200b)) or (c=$2028) or (c=$2029) or (c=$202f) or (c=$205f) or (c=$3000) or (c=$feff) or (c=$fffe);
end;

function PUCUUnicodeToUpper(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
begin
 result:=TPUCUUInt32(TPUCUInt32(TPUCUInt32(c)+PUCUUnicodeGetUpperCaseDeltaFromTable(c)));
end;

function PUCUUnicodeToLower(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
begin
 result:=TPUCUUInt32(TPUCUInt32(TPUCUInt32(c)+PUCUUnicodeGetLowerCaseDeltaFromTable(c)));
end;

function PUCUUnicodeToTitle(c:TPUCUUInt32):TPUCUUInt32; {$ifdef caninline}inline;{$endif}
begin
 result:=TPUCUUInt32(TPUCUInt32(TPUCUInt32(c)+PUCUUnicodeGetTitleCaseDeltaFromTable(c)));
end;

function PUCUIsUTF8(const s:TPUCURawByteString):boolean;
var CodeUnit,CodePoints:TPUCUInt32;
    State:TPUCUUInt32;
begin
 State:=ucACCEPT;
 CodePoints:=0;
 for CodeUnit:=1 to length(s) do begin
  State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
  case State of
   ucACCEPT:begin
    inc(CodePoints);
   end;
   ucERROR:begin
    result:=false;
    exit;
   end;
  end;
 end;
 result:=(State=ucACCEPT) and (length(s)<>CodePoints);
end;

function PUCUUTF8Validate(const s:TPUCURawByteString):boolean;
var CodeUnit:TPUCUInt32;
    State:TPUCUUInt32;
begin
 State:=ucACCEPT;
 for CodeUnit:=1 to length(s) do begin
  State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
  if State=ucERROR then begin
   result:=false;
   exit;
  end;
 end;
 result:=State=ucACCEPT;
end;

function PUCUUTF8Get(const s:TPUCURawByteString):TPUCUInt32;
var CodeUnit,CodePoints:TPUCUInt32;
    State:TPUCUUInt32;
begin
 State:=ucACCEPT;
 CodePoints:=0;
 for CodeUnit:=1 to length(s) do begin
  State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
  case State of
   ucACCEPT:begin
    inc(CodePoints);
   end;
   ucERROR:begin
    result:=suNOUTF8;
    exit;
   end;
  end;
 end;
 if State=ucACCEPT then begin
  if length(s)<>CodePoints then begin
   result:=suISUTF8;
  end else begin
   result:=suPOSSIBLEUTF8;
  end;
 end else begin
  result:=suNOUTF8;
 end;
end;

function PUCUUTF8PtrGet(const s:PPUCURawByteChar;Len:TPUCUInt32):TPUCUInt32;
var CodeUnit,CodePoints:TPUCUInt32;
    State:TPUCUUInt32;
begin
 State:=ucACCEPT;
 CodePoints:=0;
 for CodeUnit:=0 to Len-1 do begin
  State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
  case State of
   ucACCEPT:begin
    inc(CodePoints);
   end;
   ucERROR:begin
    result:=suNOUTF8;
    exit;
   end;
  end;
 end;
 if State=ucACCEPT then begin
  if length(s)<>CodePoints then begin
   result:=suISUTF8;
  end else begin
   result:=suPOSSIBLEUTF8;
  end;
 end else begin
  result:=suNOUTF8;
 end;
end;

procedure PUCUUTF8SafeInc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
var Len:TPUCUInt32;
    StartCodeUnit,State:TPUCUUInt32;
begin
 Len:=length(s);
 if CodeUnit>0 then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  while CodeUnit<=Len do begin
   State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
   inc(CodeUnit);
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   CodeUnit:=StartCodeUnit+1;
  end;
 end;
end;

procedure PUCUUTF8PtrSafeInc(const s:PPUCURawByteChar;var Len,CodeUnit:TPUCUInt32);
var StartCodeUnit,State:TPUCUUInt32;
begin
 if CodeUnit>=0 then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  while CodeUnit<Len do begin
   State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
   inc(CodeUnit);
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   CodeUnit:=StartCodeUnit+1;
  end;
 end;
end;

procedure PUCUUTF8Inc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
begin
 if (CodeUnit>0) and (CodeUnit<=length(s)) then begin
  inc(CodeUnit,PUCUUTF8CharSteps[s[CodeUnit]]);
 end;
end;

procedure PUCUUTF8PtrInc(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32);
begin
 if (CodeUnit>=0) and (CodeUnit<Len) then begin
  inc(CodeUnit,PUCUUTF8CharSteps[s[CodeUnit]]);
 end;
end;

procedure PUCUUTF8Dec(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32);
begin
 if (CodeUnit>=1) and (CodeUnit<=(length(s)+1)) then begin
  dec(CodeUnit);
  while CodeUnit>0 do begin
   if s[CodeUnit] in [#$80..#$bf] then begin
    dec(CodeUnit);
   end else begin
    break;
   end;
  end;
 end;
end;

procedure PUCUUTF8PtrDec(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32);
begin
 if (CodeUnit>0) and (CodeUnit<=Len) then begin
  dec(CodeUnit);
  while CodeUnit>=0 do begin
   if s[CodeUnit] in [#$80..#$bf] then begin
    dec(CodeUnit);
   end else begin
    break;
   end;
  end;
 end;
end;

procedure PUCUUTF8Delete(var s:TPUCURawByteString;CodeUnit:TPUCUInt32);
begin
 if (CodeUnit>=1) and (CodeUnit<=length(s)) then begin
  Delete(s,CodeUnit,1);
  while ((CodeUnit>=1) and (CodeUnit<=length(s))) and (s[CodeUnit] in [#$80..#$bf]) do begin
   Delete(s,CodeUnit,1);
  end;
 end;
end;

function PUCUUTF8Length(const s:TPUCURawByteString):TPUCUInt32; {$ifdef cpu386} assembler; register;
asm
 test eax,eax
 jz @End
  push esi
   cld
   mov esi,eax
   mov ecx,dword ptr [esi-4]
   xor edx,edx
   jecxz @LoopEnd
    @Loop:
      lodsb
      shl al,1
      js @IsASCIICharOrUTF8Begin
      jc @IsUTF8Part
      @IsASCIICharOrUTF8Begin:
       inc edx
      @IsUTF8Part:
     dec ecx
    jnz @Loop
   @LoopEnd:
   mov eax,edx
  pop esi
 @End:
end;
{$else}
var CodeUnit:TPUCUInt32;
begin
 result:=0;
 for CodeUnit:=1 to length(s) do begin
  if (TPUCUUInt8(s[CodeUnit]) and $c0)<>$80 then begin
   inc(result);
  end;
 end;
end;
{$endif}

function PUCUUTF8PtrLength(const s:TPUCURawByteString;Len:TPUCUInt32):TPUCUInt32;
{$ifdef cpu386} assembler; register;
asm
 test eax,eax
 jz @End
  push esi
   cld
   mov esi,eax
   mov ecx,edx
   xor edx,edx
   jecxz @LoopEnd
    @Loop:
      lodsb
      shl al,1
      js @IsASCIICharOrUTF8Begin
      jc @IsUTF8Part
      @IsASCIICharOrUTF8Begin:
       inc edx
      @IsUTF8Part:
     dec ecx
    jnz @Loop
   @LoopEnd:
   mov eax,edx
  pop esi
 @End:
end;
{$else}
var CodeUnit:TPUCUInt32;
begin
 result:=0;
 for CodeUnit:=0 to Len-1 do begin
  if (TPUCUUInt8(s[CodeUnit]) and $c0)<>$80 then begin
   inc(result);
  end;
 end;
end;
{$endif}

function PUCUUTF8LengthEx(const s:TPUCURawByteString):TPUCUInt32;
var State:TPUCUUInt32;
    CodeUnit:TPUCUInt32;
begin
 result:=0;
 State:=ucACCEPT;
 for CodeUnit:=1 to length(s) do begin
  State:=PUCUUTF8DFATransitions[State+PUCUUTF8DFACharClasses[s[CodeUnit]]];
  case State of
   ucACCEPT:begin
    inc(result);
   end;
   ucERROR:begin
    result:=0;
    exit;
   end;
  end;
 end;
 if State=ucERROR then begin
  result:=0;
 end;
end;

function PUCUUTF8GetCodePoint(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUInt32;
var CurrentCodeUnit,Len:TPUCUInt32;
begin
 if CodeUnit<1 then begin
  result:=-1;
 end else begin
  result:=0;
  CurrentCodeUnit:=1;
  Len:=length(s);
  while (CurrentCodeUnit<=Len) and (CurrentCodeUnit<>CodeUnit) do begin
   inc(result);
   inc(CurrentCodeUnit,PUCUUTF8CharSteps[s[CurrentCodeUnit]]);
  end;
 end;
end;

function PUCUUTF8PtrGetCodePoint(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUInt32;
var CurrentCodeUnit:TPUCUInt32;
begin
 result:=-1;
 if CodeUnit<0 then begin
  CurrentCodeUnit:=0;
  while (CurrentCodeUnit<Len) and (CurrentCodeUnit<>CodeUnit) do begin
   inc(result);
   inc(CurrentCodeUnit,PUCUUTF8CharSteps[s[CurrentCodeUnit]]);
  end;
 end;
end;

function PUCUUTF8GetCodeUnit(const s:TPUCURawByteString;CodePoint:TPUCUInt32):TPUCUInt32;
var CurrentCodePoint,Len:TPUCUInt32;
begin
 if CodePoint<0 then begin
  result:=0;
 end else begin
  result:=1;
  CurrentCodePoint:=0;
  Len:=length(s);
  while (result<=Len) and (CurrentCodePoint<>CodePoint) do begin
   inc(CurrentCodePoint);
   inc(result,PUCUUTF8CharSteps[s[result]]);
  end;
 end;
end;

function PUCUUTF8PtrGetCodeUnit(const s:TPUCURawByteString;Len,CodePoint:TPUCUInt32):TPUCUInt32;
var CurrentCodePoint:TPUCUInt32;
begin
 result:=-1;
 if CodePoint>=0 then begin
  result:=1;
  CurrentCodePoint:=0;
  Len:=length(s);
  while (result<Len) and (CurrentCodePoint<>CodePoint) do begin
   inc(CurrentCodePoint);
   inc(result,PUCUUTF8CharSteps[s[result]]);
  end;
 end;
end;

function PUCUUTF8CodeUnitGetChar(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUUInt32;
var Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 if (CodeUnit>0) and (CodeUnit<=length(s)) then begin
  State:=ucACCEPT;
  for CodeUnit:=CodeUnit to length(s) do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=$fffd;
  end;
 end;
end;

function PUCUUTF8PtrCodeUnitGetChar(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUUInt32;
var Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 if (CodeUnit>=0) and (CodeUnit<Len) then begin
  State:=ucACCEPT;
  for CodeUnit:=CodeUnit to Len-1 do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=$fffd;
  end;
 end;
end;

function PUCUUTF8PtrCodeUnitGetCharFallback(const s:PPUCURawByteChar;Len,CodeUnit:TPUCUInt32):TPUCUUInt32;
var Value,CharClass,State:TPUCUUInt32;
    StartCodeUnit:TPUCUInt32;
begin
 result:=0;
 if (CodeUnit>=0) and (CodeUnit<Len) then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  for CodeUnit:=CodeUnit to Len-1 do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=TPUCUUInt8(TPUCURawByteChar(s[StartCodeUnit]));
  end;
 end;
end;

function PUCUUTF8CodeUnitGetCharAndInc(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32):TPUCUUInt32;
var Len:TPUCUInt32;
    Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 Len:=length(s);
 if (CodeUnit>0) and (CodeUnit<=Len) then begin
  State:=ucACCEPT;
  while CodeUnit<=Len do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   inc(CodeUnit);
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=$fffd;
  end;
 end;
end;

function PUCUUTF8PtrCodeUnitGetCharAndInc(const s:PPUCURawByteChar;Len:TPUCUInt32;var CodeUnit:TPUCUInt32):TPUCUUInt32;
var Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 if (CodeUnit>=0) and (CodeUnit<Len) then begin
  State:=ucACCEPT;
  while CodeUnit<Len do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   inc(CodeUnit);
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=$fffd;
  end;
 end;
end;

function PUCUUTF8CodeUnitGetCharFallback(const s:TPUCURawByteString;CodeUnit:TPUCUInt32):TPUCUUInt32;
var Len:TPUCUInt32;
    StartCodeUnit,Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 Len:=length(s);
 if (CodeUnit>0) and (CodeUnit<=Len) then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  while CodeUnit<=Len do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   inc(CodeUnit);
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=TPUCUUInt8(TPUCURawByteChar(s[StartCodeUnit]));
  end;
 end;
end;

function PUCUUTF8CodeUnitGetCharAndIncFallback(const s:TPUCURawByteString;var CodeUnit:TPUCUInt32):TPUCUUInt32;
var Len:TPUCUInt32;
    StartCodeUnit,Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 Len:=length(s);
 if (CodeUnit>0) and (CodeUnit<=Len) then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  while CodeUnit<=Len do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   inc(CodeUnit);
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=TPUCUUInt8(TPUCURawByteChar(s[StartCodeUnit]));
   CodeUnit:=StartCodeUnit+1;
  end;
 end;
end;

function PUCUUTF8PtrCodeUnitGetCharAndIncFallback(const s:PPUCURawByteChar;const Len:TPUCUInt32;var CodeUnit:TPUCUInt32):TPUCUUInt32;
var StartCodeUnit,Value,CharClass,State:TPUCUUInt32;
begin
 result:=0;
 if (CodeUnit>=0) and (CodeUnit<Len) then begin
  StartCodeUnit:=CodeUnit;
  State:=ucACCEPT;
  while CodeUnit<Len do begin
   Value:=TPUCUUInt8(TPUCURawByteChar(s[CodeUnit]));
   inc(CodeUnit);
   CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
   if State=ucACCEPT then begin
    result:=Value and ($ff shr CharClass);
   end else begin
    result:=(result shl 6) or (Value and $3f);
   end;
   State:=PUCUUTF8DFATransitions[State+CharClass];
   if State<=ucERROR then begin
    break;
   end;
  end;
  if State<>ucACCEPT then begin
   result:=TPUCUUInt8(TPUCURawByteChar(s[StartCodeUnit]));
   CodeUnit:=StartCodeUnit+1;
  end;
 end;
end;

function PUCUUTF8CodePointGetChar(const s:TPUCURawByteString;CodePoint:TPUCUInt32;Fallback:boolean=false):TPUCUUInt32;
begin
 result:=PUCUUTF8CodeUnitGetChar(s,PUCUUTF8GetCodeUnit(s,CodePoint));
end;

function PUCUUTF8GetCharLen(const s:TPUCURawByteString;i:TPUCUInt32):TPUCUUInt32;
begin
 if (i>0) and (i<=length(s)) then begin
  result:=PUCUUTF8CharSteps[s[i]];
 end else begin
  result:=0;
 end;
end;

function PUCUUTF8Pos(const FindStr,InStr:TPUCURawByteString):TPUCUInt32;
var i,j,l:TPUCUInt32;
    ok:boolean;
begin
 result:=0;
 i:=1;
 while i<=length(InStr) do begin
  l:=i+length(FindStr)-1;
  if l>length(InStr) then begin
   exit;
  end;
  ok:=true;
  for j:=1 to length(FindStr) do begin
   if InStr[i+j-1]<>FindStr[j] then begin
    ok:=false;
    break;
   end;
  end;
  if ok then begin
   result:=i;
   exit;
  end;
  inc(i,PUCUUTF8CharSteps[InStr[i]]);
 end;
end;

function PUCUUTF8Copy(const Str:TPUCURawByteString;Start,Len:TPUCUInt32):TPUCURawByteString;
var CodeUnit:TPUCUInt32;
begin
 result:='';
 CodeUnit:=1;
 while (CodeUnit<=length(Str)) and (Start>0) do begin
  inc(CodeUnit,PUCUUTF8CharSteps[Str[CodeUnit]]);
  dec(Start);
 end;
 if Start=0 then begin
  Start:=CodeUnit;
  while (CodeUnit<=length(Str)) and (Len>0) do begin
   inc(CodeUnit,PUCUUTF8CharSteps[Str[CodeUnit]]);
   dec(Len);
  end;
  if Start<CodeUnit then begin
   result:=copy(Str,Start,CodeUnit-Start);
  end;
 end;
end;

function PUCUUTF8UpperCase(const Str:TPUCURawByteString):TPUCURawByteString;
var CodeUnit,Len,ResultLen:TPUCUInt32;
    StartCodeUnit,Value,CharClass,State,CharValue:TPUCUUInt32;
    Data:PPUCURawByteChar;
begin
 result:='';
 CodeUnit:=1;
 Len:=length(Str);
 if Len>0 then begin
  SetLength(result,Len*{$ifdef PUCUStrictUTF8}4{$else}6{$endif});
  Data:=@result[1];
  ResultLen:=0;
  while CodeUnit<=Len do begin
   StartCodeUnit:=CodeUnit;
   State:=ucACCEPT;
   CharValue:=0;
   while CodeUnit<=Len do begin
    Value:=TPUCUUInt8(TPUCURawByteChar(Str[CodeUnit]));
    inc(CodeUnit);
    CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
    if State=ucACCEPT then begin
     CharValue:=Value and ($ff shr CharClass);
    end else begin
     CharValue:=(CharValue shl 6) or (Value and $3f);
    end;
    State:=PUCUUTF8DFATransitions[State+CharClass];
    if State<=ucERROR then begin
     break;
    end;
   end;
   if State<>ucACCEPT then begin
    CharValue:=TPUCUUInt8(TPUCURawByteChar(Str[StartCodeUnit]));
    CodeUnit:=StartCodeUnit+1;
   end;
   if CharValue<=$10ffff then begin
    Value:=CharValue shr PUCUUnicodeUpperCaseDeltaArrayBlockBits;
    CharValue:=TPUCUUInt32(TPUCUInt32(TPUCUInt32(CharValue)+PUCUUnicodeUpperCaseDeltaArrayBlockData[PUCUUnicodeUpperCaseDeltaArrayIndexBlockData[PUCUUnicodeUpperCaseDeltaArrayIndexIndexData[Value shr PUCUUnicodeUpperCaseDeltaArrayIndexBlockBits],Value and PUCUUnicodeUpperCaseDeltaArrayIndexBlockMask],CharValue and PUCUUnicodeUpperCaseDeltaArrayBlockMask]));
   end;
   if CharValue<=$7f then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8(CharValue));
    inc(ResultLen);
   end else if CharValue<=$7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($c0 or ((CharValue shr 6) and $1f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,2);
{$ifdef PUCUStrictUTF8}
   end else if CharValue<=$d7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$dfff then begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
{$endif}
   end else if CharValue<=$ffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$1fffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f0 or ((CharValue shr 18) and $07)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,4);
{$ifndef PUCUStrictUTF8}
   end else if CharValue<=$3ffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f8 or ((CharValue shr 24) and $03)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,5);
   end else if CharValue<=$7fffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($fc or ((CharValue shr 30) and $01)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 24) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+5]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,6);
{$endif}
   end else begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
   end;
  end;
  SetLength(result,ResultLen);
 end;
end;

function PUCUUTF8LowerCase(const Str:TPUCURawByteString):TPUCURawByteString;
var CodeUnit,Len,ResultLen:TPUCUInt32;
    StartCodeUnit,Value,CharClass,State,CharValue:TPUCUUInt32;
    Data:PPUCURawByteChar;
begin
 result:='';
 CodeUnit:=1;
 Len:=length(Str);
 if Len>0 then begin
  SetLength(result,Len*{$ifdef PUCUStrictUTF8}4{$else}6{$endif});
  Data:=@result[1];
  ResultLen:=0;
  while CodeUnit<=Len do begin
   StartCodeUnit:=CodeUnit;
   State:=ucACCEPT;
   CharValue:=0;
   while CodeUnit<=Len do begin
    Value:=TPUCUUInt8(TPUCURawByteChar(Str[CodeUnit]));
    inc(CodeUnit);
    CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
    if State=ucACCEPT then begin
     CharValue:=Value and ($ff shr CharClass);
    end else begin
     CharValue:=(CharValue shl 6) or (Value and $3f);
    end;
    State:=PUCUUTF8DFATransitions[State+CharClass];
    if State<=ucERROR then begin
     break;
    end;
   end;
   if State<>ucACCEPT then begin
    CharValue:=TPUCUUInt8(TPUCURawByteChar(Str[StartCodeUnit]));
    CodeUnit:=StartCodeUnit+1;
   end;
   if CharValue<=$10ffff then begin
    Value:=CharValue shr PUCUUnicodeLowerCaseDeltaArrayBlockBits;
    CharValue:=TPUCUUInt32(TPUCUInt32(TPUCUInt32(CharValue)+PUCUUnicodeLowerCaseDeltaArrayBlockData[PUCUUnicodeLowerCaseDeltaArrayIndexBlockData[PUCUUnicodeLowerCaseDeltaArrayIndexIndexData[Value shr PUCUUnicodeLowerCaseDeltaArrayIndexBlockBits],Value and PUCUUnicodeLowerCaseDeltaArrayIndexBlockMask],CharValue and PUCUUnicodeLowerCaseDeltaArrayBlockMask]));
   end;
   if CharValue<=$7f then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8(CharValue));
    inc(ResultLen);
   end else if CharValue<=$7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($c0 or ((CharValue shr 6) and $1f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,2);
{$ifdef PUCUStrictUTF8}
   end else if CharValue<=$d7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$dfff then begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
{$endif}
   end else if CharValue<=$ffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$1fffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f0 or ((CharValue shr 18) and $07)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,4);
{$ifndef PUCUStrictUTF8}
   end else if CharValue<=$3ffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f8 or ((CharValue shr 24) and $03)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,5);
   end else if CharValue<=$7fffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($fc or ((CharValue shr 30) and $01)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 24) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+5]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,6);
{$endif}
   end else begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
   end;
  end;
  SetLength(result,ResultLen);
 end;
end;

function PUCUUTF8Trim(const Str:TPUCURawByteString):TPUCURawByteString;
var i,j:TPUCUInt32;
begin
 i:=1;
 while PUCUUnicodeIsWhiteSpace(PUCUUTF8CodeUnitGetChar(Str,i)) do begin
  inc(i,PUCUUTF8CharSteps[Str[i]]);
 end;
 j:=length(Str)+1;
 PUCUUTF8Dec(Str,j);
 while PUCUUnicodeIsWhiteSpace(PUCUUTF8CodeUnitGetChar(Str,j)) do begin
  PUCUUTF8Dec(Str,j);
 end;
 if (j<=length(Str)) and (Str[j]>=#80) then begin
  inc(j,TPUCUInt32(PUCUUTF8GetCharLen(Str,j))-1);
 end;
 if i<=j then begin
  result:=copy(Str,i,(j-i)+1);
 end else begin
  result:='';
 end;
end;

function PUCUUTF8Correct(const Str:TPUCURawByteString):TPUCURawByteString;
var CodeUnit,Len,ResultLen:TPUCUInt32;
    StartCodeUnit,Value,CharClass,State,CharValue:TPUCUUInt32;
    Data:PPUCURawByteChar;
begin
 if (length(Str)=0) or PUCUUTF8Validate(Str) then begin
  result:=Str;
 end else begin
  result:='';
  CodeUnit:=1;
  Len:=length(Str);
  SetLength(result,Len*{$ifdef PUCUStrictUTF8}4{$else}6{$endif});
  Data:=@result[1];
  ResultLen:=0;
  while CodeUnit<=Len do begin
   StartCodeUnit:=CodeUnit;
   State:=ucACCEPT;
   CharValue:=0;
   while CodeUnit<=Len do begin
    Value:=TPUCUUInt8(TPUCURawByteChar(Str[CodeUnit]));
    inc(CodeUnit);
    CharClass:=PUCUUTF8DFACharClasses[TPUCURawByteChar(Value)];
    if State=ucACCEPT then begin
     CharValue:=Value and ($ff shr CharClass);
    end else begin
     CharValue:=(CharValue shl 6) or (Value and $3f);
    end;
    State:=PUCUUTF8DFATransitions[State+CharClass];
    if State<=ucERROR then begin
     break;
    end;
   end;
   if State<>ucACCEPT then begin
    CharValue:=TPUCUUInt8(TPUCURawByteChar(Str[StartCodeUnit]));
    CodeUnit:=StartCodeUnit+1;
   end;
   if CharValue<=$7f then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8(CharValue));
    inc(ResultLen);
   end else if CharValue<=$7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($c0 or ((CharValue shr 6) and $1f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,2);
{$ifdef PUCUStrictUTF8}
   end else if CharValue<=$d7ff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$dfff then begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
{$endif}
   end else if CharValue<=$ffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,3);
   end else if CharValue<=$1fffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f0 or ((CharValue shr 18) and $07)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,4);
{$ifndef PUCUStrictUTF8}
   end else if CharValue<=$3ffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($f8 or ((CharValue shr 24) and $03)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,5);
   end else if CharValue<=$7fffffff then begin
    Data[ResultLen]:=TPUCURawByteChar(TPUCUUInt8($fc or ((CharValue shr 30) and $01)));
    Data[ResultLen+1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 24) and $3f)));
    Data[ResultLen+2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
    Data[ResultLen+3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
    Data[ResultLen+4]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
    Data[ResultLen+5]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
    inc(ResultLen,6);
{$endif}
   end else begin
    Data[ResultLen]:=#$ef; // $fffd
    Data[ResultLen+1]:=#$bf;
    Data[ResultLen+2]:=#$bd;
    inc(ResultLen,3);
   end;
  end;
  SetLength(result,ResultLen);
 end;
end;

function PUCUUTF8FromLatin1(const Str:TPUCURawByteString):TPUCURawByteString;
var CodeUnit:TPUCUInt32;
begin
 if PUCUUTF8Validate(Str) then begin
  result:=Str;
 end else begin
  result:='';
  for CodeUnit:=1 to length(Str) do begin
   result:=result+PUCUUTF32CharToUTF8(TPUCUUInt8(TPUCURawByteChar(Str[CodeUnit])));
  end;
 end;
end;

function PUCUUTF8LevenshteinDistance(const s,t:TPUCURawByteString):TPUCUInt32;
var d:array of array of TPUCUInt32;
    n,m,i,j,ci,cj,oi,oj,Deletion,Insertion,Substitution:TPUCUInt32;
    si,tj:TPUCUUInt32;
begin
 n:=PUCUUTF8LengthEx(s);
 m:=PUCUUTF8LengthEx(t);
 oi:=1;
 oj:=1;
 while ((n>0) and (m>0)) and (PUCUUTF8CodeUnitGetChar(s,oi)=PUCUUTF8CodeUnitGetChar(t,oj)) do begin
  if (oi>0) and (oi<=length(s)) then begin
   inc(oi,PUCUUTF8CharSteps[s[oi]]);
  end else begin
   break;
  end;
  if (oj>0) and (oj<=length(t)) then begin
   inc(oj,PUCUUTF8CharSteps[t[oj]]);
  end else begin
   break;
  end;
  dec(n);
  dec(m);
 end;
 if ((n>0) and (m>0)) and (s[length(s)]=t[length(t)]) then begin
  ci:=length(s)+1;
  cj:=length(t)+1;
  PUCUUTF8Dec(s,ci);
  PUCUUTF8Dec(t,cj);
  while ((n>0) and (m>0)) and (PUCUUTF8CodeUnitGetChar(s,ci)=PUCUUTF8CodeUnitGetChar(t,cj)) do begin
   PUCUUTF8Dec(s,ci);
   PUCUUTF8Dec(t,cj);
   dec(n);
   dec(m);
  end;
 end;
 if n=0 then begin
  result:=m;
 end else if m=0 then begin
  result:=n;
 end else begin
  d:=nil;
  SetLength(d,n+1,m+1);
  for i:=0 to n do begin
   d[i,0]:=i;
  end;
  for j:=0 to m do begin
   d[0,j]:=j;
  end;
  ci:=oi;
  for i:=1 to n do begin
   si:=PUCUUTF8CodeUnitGetCharAndInc(s,ci);
   cj:=oj;
   for j:=1 to m do begin
    tj:=PUCUUTF8CodeUnitGetCharAndInc(t,cj);
    if si<>tj then begin
     Deletion:=d[i-1,j]+1;
     Insertion:=d[i,j-1]+1;
     Substitution:=d[i-1,j-1]+1;
     if Deletion<Insertion then begin
      if Deletion<Substitution then begin
       d[i,j]:=Deletion;
      end else begin
       d[i,j]:=Substitution;
      end;
     end else begin
      if Insertion<Substitution then begin
       d[i,j]:=Insertion;
      end else begin
       d[i,j]:=Substitution;
      end;
     end;
    end else begin
     d[i,j]:=d[i-1,j-1];
    end;
   end;
  end;
  result:=d[n,m];
  SetLength(d,0);
 end;
end;

function PUCUUTF8DamerauLevenshteinDistance(const s,t:TPUCURawByteString):TPUCUInt32;
var d:array of array of TPUCUInt32;
    n,m,i,j,ci,cj,oi,oj,Cost,Deletion,Insertion,Substitution,Transposition,Value:TPUCUInt32;
    si,tj,lsi,ltj:TPUCUUInt32;
begin
 n:=PUCUUTF8LengthEx(s);
 m:=PUCUUTF8LengthEx(t);
 oi:=1;
 oj:=1;
 while ((n>0) and (m>0)) and (PUCUUTF8CodeUnitGetChar(s,oi)=PUCUUTF8CodeUnitGetChar(t,oj)) do begin
  if (oi>0) and (oi<=length(s)) then begin
   inc(oi,PUCUUTF8CharSteps[s[oi]]);
  end else begin
   break;
  end;
  if (oj>0) and (oj<=length(t)) then begin
   inc(oj,PUCUUTF8CharSteps[t[oj]]);
  end else begin
   break;
  end;
  dec(n);
  dec(m);
 end;
 if ((n>0) and (m>0)) and (s[length(s)]=t[length(t)]) then begin
  ci:=length(s)+1;
  cj:=length(t)+1;
  PUCUUTF8Dec(s,ci);
  PUCUUTF8Dec(t,cj);
  while ((n>0) and (m>0)) and (PUCUUTF8CodeUnitGetChar(s,ci)=PUCUUTF8CodeUnitGetChar(t,cj)) do begin
   PUCUUTF8Dec(s,ci);
   PUCUUTF8Dec(t,cj);
   dec(n);
   dec(m);
  end;
 end;
 if n=0 then begin
  result:=m;
 end else if m=0 then begin
  result:=n;
 end else begin
  d:=nil;
  SetLength(d,n+1,m+1);
  for i:=0 to n do begin
   d[i,0]:=i;
  end;
  for j:=0 to m do begin
   d[0,j]:=j;
  end;
  ci:=oi;
  si:=0;
  for i:=1 to n do begin
   lsi:=si;
   si:=PUCUUTF8CodeUnitGetCharAndInc(s,ci);
   cj:=oj;
   tj:=0;
   for j:=1 to m do begin
    ltj:=tj;
    tj:=PUCUUTF8CodeUnitGetCharAndInc(t,cj);
    if si<>tj then begin
     Cost:=1;
    end else begin
     Cost:=0;
    end;
    Deletion:=d[i-1,j]+1;
    Insertion:=d[i,j-1]+1;
    Substitution:=d[i-1,j-1]+Cost;
    if Deletion<Insertion then begin
     if Deletion<Substitution then begin
      Value:=Deletion;
     end else begin
      Value:=Substitution;
     end;
    end else begin
     if Insertion<Substitution then begin
      Value:=Insertion;
     end else begin
      Value:=Substitution;
     end;
    end;
    if ((i>1) and (j>1)) and ((si=ltj) and (lsi=tj)) then begin
     Transposition:=d[i-2,j-2]+Cost;
     if Transposition<Value then begin
      Value:=Transposition;
     end;
    end;
    d[i,j]:=Value;
   end;
  end;
  result:=d[n,m];
  SetLength(d,0);
 end;
end;

function PUCUStringLength(const s:TPUCURawByteString):TPUCUInt32;
begin
 if PUCUIsUTF8(s) then begin
  result:=PUCUUTF8Length(s);
 end else begin
  result:=length(s);
 end;
end;

function PUCUUTF16Correct(const Str:TPUCUUTF16String):TPUCUUTF16String;
var i,j:TPUCUInt32;
    w:TPUCUUTF32Char;
begin
 result:='';
 j:=0;
 i:=1;
 SetLength(result,length(Str)*2);
 while i<=length(Str) do begin
  w:=TPUCUUInt16(TPUCUUTF16Char(Str[i]));
  inc(i);
  if (i<=length(Str)) and ((w and $fc00)=$d800) and ((TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $fc00)=$dc00) then begin
   w:=(TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(w and $3ff)) shl 10) or TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $3ff))+$10000;
   inc(i);
  end;
  if w<=$d7ff then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$dfff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$fffd then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$ffff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$10ffff then begin
   dec(w,$10000);
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w shr 10) or $d800));
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w and $3ff) or $dc00));
  end else begin
   inc(j);
   result[j]:=#$fffd;
  end;
 end;
 SetLength(result,j);
end;

function PUCUUTF16UpperCase(const Str:TPUCUUTF16String):TPUCUUTF16String;
var i,j:TPUCUInt32;
    w:TPUCUUTF32Char;
begin
 result:='';
 j:=0;
 i:=1;
 SetLength(result,length(Str)*2);
 while i<=length(Str) do begin
  w:=TPUCUUInt16(TPUCUUTF16Char(Str[i]));
  inc(i);
  if (i<=length(Str)) and ((w and $fc00)=$d800) and ((TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $fc00)=$dc00) then begin
   w:=(TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(w and $3ff)) shl 10) or TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $3ff))+$10000;
   inc(i);
  end;
  w:=PUCUUnicodeToUpper(w);
  if w<=$d7ff then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$dfff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$fffd then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$ffff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$10ffff then begin
   dec(w,$10000);
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w shr 10) or $d800));
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w and $3ff) or $dc00));
  end else begin
   inc(j);
   result[j]:=#$fffd;
  end;
 end;
 SetLength(result,j);
end;

function PUCUUTF16LowerCase(const Str:TPUCUUTF16String):TPUCUUTF16String;
var i,j:TPUCUInt32;
    w:TPUCUUTF32Char;
begin
 result:='';
 j:=0;
 i:=1;
 SetLength(result,length(Str)*2);
 while i<=length(Str) do begin
  w:=TPUCUUInt16(TPUCUUTF16Char(Str[i]));
  inc(i);
  if (i<=length(Str)) and ((w and $fc00)=$d800) and ((TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $fc00)=$dc00) then begin
   w:=(TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(w and $3ff)) shl 10) or TPUCUUTF32Char(TPUCUUInt16(TPUCUUTF16Char(Str[i])) and $3ff))+$10000;
   inc(i);
  end;
  w:=PUCUUnicodeToLower(w);
  if w<=$d7ff then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$dfff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$fffd then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$ffff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$10ffff then begin
   dec(w,$10000);
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w shr 10) or $d800));
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w and $3ff) or $dc00));
  end else begin
   inc(j);
   result[j]:=#$fffd;
  end;
 end;
 SetLength(result,j);
end;

function PUCUUTF32CharToUTF8(CharValue:TPUCUUTF32Char):TPUCURawByteString;
var Data:array[0..{$ifdef PUCUStrictUTF8}3{$else}5{$endif}] of TPUCURawByteChar;
    ResultLen:TPUCUInt32;
begin
 if CharValue=0 then begin
  result:=#0;
 end else begin
  if CharValue<=$7f then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8(CharValue));
   ResultLen:=1;
  end else if CharValue<=$7ff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($c0 or ((CharValue shr 6) and $1f)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=2;
{$ifdef PUCUStrictUTF8}
  end else if CharValue<=$d7ff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
   Data[2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=3;
  end else if CharValue<=$dfff then begin
   Data[0]:=#$ef; // $fffd
   Data[1]:=#$bf;
   Data[2]:=#$bd;
   ResultLen:=3;
{$endif}
  end else if CharValue<=$ffff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($e0 or ((CharValue shr 12) and $0f)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
   Data[2]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=3;
  end else if CharValue<=$1fffff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($f0 or ((CharValue shr 18) and $07)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
   Data[2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
   Data[3]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=4;
{$ifndef PUCUStrictUTF8}
  end else if CharValue<=$3ffffff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($f8 or ((CharValue shr 24) and $03)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
   Data[2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
   Data[3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
   Data[4]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=5;
  end else if CharValue<=$7fffffff then begin
   Data[0]:=TPUCURawByteChar(TPUCUUInt8($fc or ((CharValue shr 30) and $01)));
   Data[1]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 24) and $3f)));
   Data[2]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 18) and $3f)));
   Data[3]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 12) and $3f)));
   Data[4]:=TPUCURawByteChar(TPUCUUInt8($80 or ((CharValue shr 6) and $3f)));
   Data[5]:=TPUCURawByteChar(TPUCUUInt8($80 or (CharValue and $3f)));
   ResultLen:=6;
{$endif}
  end else begin
   Data[0]:=#$ef; // $fffd
   Data[1]:=#$bf;
   Data[2]:=#$bd;
   ResultLen:=3;
  end;
  SetString(result,PPUCURawByteChar(@Data[0]),ResultLen);
 end;
end;

function PUCUUTF32CharToUTF8Len(CharValue:TPUCUUTF32Char):TPUCUInt32;
begin
 if CharValue<=$7f then begin
  result:=1;
 end else if CharValue<=$7ff then begin
  result:=2;
 end else if CharValue<=$ffff then begin
  result:=3;
 end else if CharValue<=$1fffff then begin
  result:=4;
{$ifndef PUCUStrictUTF8}
 end else if CharValue<=$3ffffff then begin
  result:=5;
 end else if CharValue<=$7fffffff then begin
  result:=6;
{$endif}
 end else begin
  result:=3;
 end;
end;

function PUCUUTF32ToUTF8(const s:TPUCUUTF32String):TPUCUUTF8String;
var i,j:TPUCUInt32;
    u4c:TPUCUUTF32Char;
begin
 result:='';
 j:=0;
 for i:=0 to length(s)-1 do begin
  u4c:=s[i];
  if u4c<=$7f then begin
   inc(j);
  end else if u4c<=$7ff then begin
   inc(j,2);
  end else if u4c<=$ffff then begin
   inc(j,3);
  end else if u4c<=$1fffff then begin
   inc(j,4);
{$ifndef PUCUStrictUTF8}
  end else if u4c<=$3ffffff then begin
   inc(j,5);
  end else if u4c<=$7fffffff then begin
   inc(j,6);
{$endif}
  end else begin
   inc(j,3);
  end;
 end;
 SetLength(result,j);
 j:=1;
 for i:=0 to length(s)-1 do begin
  u4c:=s[i];
  if u4c<=$7f then begin
   result[j]:=AnsiChar(TPUCUUInt8(u4c));
   inc(j);
  end else if u4c<=$7ff then begin
   result[j]:=AnsiChar(TPUCUUInt8($c0 or ((u4c shr 6) and $1f)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,2);
  end else if u4c<=$ffff then begin
   result[j]:=AnsiChar(TPUCUUInt8($e0 or ((u4c shr 12) and $0f)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 6) and $3f)));
   result[j+2]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,3);
  end else if u4c<=$1fffff then begin
   result[j]:=AnsiChar(TPUCUUInt8($f0 or ((u4c shr 18) and $07)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 12) and $3f)));
   result[j+2]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 6) and $3f)));
   result[j+3]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,4);
{$ifndef PUCUStrictUTF8}
  end else if u4c<=$3ffffff then begin
   result[j]:=AnsiChar(TPUCUUInt8($f8 or ((u4c shr 24) and $03)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 18) and $3f)));
   result[j+2]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 12) and $3f)));
   result[j+3]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 6) and $3f)));
   result[j+4]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,5);
  end else if u4c<=$7fffffff then begin
   result[j]:=AnsiChar(TPUCUUInt8($fc or ((u4c shr 30) and $01)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 24) and $3f)));
   result[j+2]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 18) and $3f)));
   result[j+3]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 12) and $3f)));
   result[j+4]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 6) and $3f)));
   result[j+5]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,6);
{$endif}
  end else begin
   u4c:=$fffd;
   result[j]:=AnsiChar(TPUCUUInt8($e0 or ((u4c shr 12) and $0f)));
   result[j+1]:=AnsiChar(TPUCUUInt8($80 or ((u4c shr 6) and $3f)));
   result[j+2]:=AnsiChar(TPUCUUInt8($80 or (u4c and $3f)));
   inc(j,3);
  end;
 end;
end;

function PUCUUTF8ToUTF32(const s:TPUCUUTF8String):TPUCUUTF32String;
var i,j:TPUCUInt32;
    b:TPUCUUInt8;
begin
 j:=0;
 i:=1;
 while i<=length(s) do begin
  b:=TPUCUUInt8(s[i]);
  if (b and $80)=0 then begin
   inc(i);
   inc(j);
  end else if ((i+1)<=length(s)) and ((b and $e0)=$c0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) then begin
   inc(i,2);
   inc(j);
  end else if ((i+2)<=length(s)) and ((b and $f0)=$e0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) then begin
   inc(i,3);
   inc(j);
  end else if ((i+3)<=length(s)) and ((b and $f8)=$f0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) then begin
   inc(i,4);
   inc(j);
{$ifndef PUCUStrictUTF8}
  end else if ((i+4)<=length(s)) and ((b and $fc)=$f8) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) then begin
   inc(i,5);
   inc(j);
  end else if ((i+5)<=length(s)) and ((b and $fe)=$fc) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) and ((TPUCUUInt8(s[i+5]) and $c0)=$80) then begin
   inc(i,6);
   inc(j);
{$endif}   
  end else begin
   inc(i);
   inc(j);
  end;
 end;
 SetLength(result,j);
 if j=0 then begin
  exit;
 end;
 j:=0;
 i:=1;
 while i<=length(s) do begin
  b:=TPUCUUInt8(s[i]);
  if (b and $80)=0 then begin
   result[j]:=b;
   inc(i);
   inc(j);
  end else if ((i+1)<=length(s)) and ((b and $e0)=$c0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) then begin
   result[j]:=((TPUCUUInt8(s[i]) and $1f) shl 6) or (TPUCUUInt8(s[i+1]) and $3f);
   inc(i,2);
   inc(j);
  end else if ((i+2)<=length(s)) and ((b and $f0)=$e0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) then begin
   result[j]:=((TPUCUUInt8(s[i]) and $0f) shl 12) or ((TPUCUUInt8(s[i+1]) and $3f) shl 6) or (TPUCUUInt8(s[i+2]) and $3f);
   inc(i,3);
   inc(j);
  end else if ((i+3)<=length(s)) and ((b and $f8)=$f0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) then begin
   result[j]:=((TPUCUUInt8(s[i]) and $07) shl 18) or ((TPUCUUInt8(s[i+1]) and $3f) shl 12) or ((TPUCUUInt8(s[i+2]) and $3f) shl 6) or (TPUCUUInt8(s[i+3]) and $3f);
   inc(i,4);
   inc(j);
{$ifndef PUCUStrictUTF8}
  end else if ((i+4)<=length(s)) and ((b and $fc)=$f8) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) then begin
   result[j]:=((TPUCUUInt8(s[i]) and $03) shl 24) or ((TPUCUUInt8(s[i+1]) and $3f) shl 18) or ((TPUCUUInt8(s[i+2]) and $3f) shl 12) or ((TPUCUUInt8(s[i+3]) and $3f) shl 6) or (TPUCUUInt8(s[i+4]) and $3f);
   inc(i,5);
   inc(j);
  end else if ((i+5)<=length(s)) and ((b and $fe)=$fc) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) and ((TPUCUUInt8(s[i+5]) and $c0)=$80) then begin
   result[j]:=((TPUCUUInt8(s[i]) and $01) shl 30) or ((TPUCUUInt8(s[i+1]) and $3f) shl 24) or ((TPUCUUInt8(s[i+2]) and $3f) shl 18) or ((TPUCUUInt8(s[i+3]) and $3f) shl 12) or ((TPUCUUInt8(s[i+4]) and $3f) shl 6) or (TPUCUUInt8(s[i+5]) and $3f);
   inc(i,6);
   inc(j);
{$endif}
  end else begin
   result[j]:=$fffd;
   inc(i);
   inc(j);
  end;
 end;
end;

function PUCUUTF8ToUTF16(const s:TPUCUUTF8String):TPUCUUTF16STRING;
var i,j:TPUCUInt32;
    w:TPUCUUInt32;
    b:TPUCUUInt8;
begin
 result:='';
 i:=1;
 j:=0;
 while i<=length(s) do begin
  b:=TPUCUUInt8(s[i]);
  if (b and $80)=0 then begin
   w:=b;
   inc(i);
  end else if ((i+1)<=length(s)) and ((b and $e0)=$c0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $1f) shl 6) or (TPUCUUInt8(s[i+1]) and $3f);
   inc(i,2);
  end else if ((i+2)<=length(s)) and ((b and $f0)=$e0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $0f) shl 12) or ((TPUCUUInt8(s[i+1]) and $3f) shl 6) or (TPUCUUInt8(s[i+2]) and $3f);
   inc(i,3);
  end else if ((i+3)<=length(s)) and ((b and $f8)=$f0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $07) shl 18) or ((TPUCUUInt8(s[i+1]) and $3f) shl 12) or ((TPUCUUInt8(s[i+2]) and $3f) shl 6) or (TPUCUUInt8(s[i+3]) and $3f);
   inc(i,4);
{$ifndef PUCUStrictUTF8}
  end else if ((i+4)<=length(s)) and ((b and $fc)=$f8) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $03) shl 24) or ((TPUCUUInt8(s[i+1]) and $3f) shl 18) or ((TPUCUUInt8(s[i+2]) and $3f) shl 12) or ((TPUCUUInt8(s[i+3]) and $3f) shl 6) or (TPUCUUInt8(s[i+4]) and $3f);
   inc(i,5);
  end else if ((i+5)<=length(s)) and ((b and $fe)=$fc) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) and ((TPUCUUInt8(s[i+5]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $01) shl 30) or ((TPUCUUInt8(s[i+1]) and $3f) shl 24) or ((TPUCUUInt8(s[i+2]) and $3f) shl 18) or ((TPUCUUInt8(s[i+3]) and $3f) shl 12) or ((TPUCUUInt8(s[i+4]) and $3f) shl 6) or (TPUCUUInt8(s[i+5]) and $3f);
   inc(i,6);
{$endif}
  end else begin
   w:=$fffd;
   inc(i);
  end;
  if w<=$d7ff then begin
   inc(j);
  end else if w<=$dfff then begin
   inc(j);
  end else if w<=$fffd then begin
   inc(j);
  end else if w<=$ffff then begin
   inc(j);
  end else if w<=$10ffff then begin
   inc(j,2);
  end else begin
   inc(j);
  end;
 end;
 SetLength(result,j);
 i:=1;
 j:=0;
 while i<=length(s) do begin
  b:=TPUCUUInt8(s[i]);
  if (b and $80)=0 then begin
   w:=b;
   inc(i);
  end else if ((i+1)<=length(s)) and ((b and $e0)=$c0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $1f) shl 6) or (TPUCUUInt8(s[i+1]) and $3f);
   inc(i,2);
  end else if ((i+2)<=length(s)) and ((b and $f0)=$e0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $0f) shl 12) or ((TPUCUUInt8(s[i+1]) and $3f) shl 6) or (TPUCUUInt8(s[i+2]) and $3f);
   inc(i,3);
  end else if ((i+3)<=length(s)) and ((b and $f8)=$f0) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $07) shl 18) or ((TPUCUUInt8(s[i+1]) and $3f) shl 12) or ((TPUCUUInt8(s[i+2]) and $3f) shl 6) or (TPUCUUInt8(s[i+3]) and $3f);
   inc(i,4);
{$ifndef PUCUStrictUTF8}
  end else if ((i+4)<=length(s)) and ((b and $fc)=$f8) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $03) shl 24) or ((TPUCUUInt8(s[i+1]) and $3f) shl 18) or ((TPUCUUInt8(s[i+2]) and $3f) shl 12) or ((TPUCUUInt8(s[i+3]) and $3f) shl 6) or (TPUCUUInt8(s[i+4]) and $3f);
   inc(i,5);
  end else if ((i+5)<=length(s)) and ((b and $fe)=$fc) and ((TPUCUUInt8(s[i+1]) and $c0)=$80) and ((TPUCUUInt8(s[i+2]) and $c0)=$80) and ((TPUCUUInt8(s[i+3]) and $c0)=$80) and ((TPUCUUInt8(s[i+4]) and $c0)=$80) and ((TPUCUUInt8(s[i+5]) and $c0)=$80) then begin
   w:=((TPUCUUInt8(s[i]) and $01) shl 30) or ((TPUCUUInt8(s[i+1]) and $3f) shl 24) or ((TPUCUUInt8(s[i+2]) and $3f) shl 18) or ((TPUCUUInt8(s[i+3]) and $3f) shl 12) or ((TPUCUUInt8(s[i+4]) and $3f) shl 6) or (TPUCUUInt8(s[i+5]) and $3f);
   inc(i,6);
{$endif}
  end else begin
   w:=$fffd;
   inc(i);
  end;
  if w<=$d7ff then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$dfff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$fffd then begin
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16(w));
  end else if w<=$ffff then begin
   inc(j);
   result[j]:=#$fffd;
  end else if w<=$10ffff then begin
   dec(w,$10000);
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w shr 10) or $d800));
   inc(j);
   result[j]:=TPUCUUTF16Char(TPUCUUInt16((w and $3ff) or $dc00));
  end else begin
   inc(j);
   result[j]:=#$fffd;
  end;
 end;
end;

function PUCUUTF16ToUTF8(const s:TPUCUUTF16STRING):TPUCUUTF8String;
var i,j:TPUCUInt32;
    w:TPUCUUInt32;
begin
 result:='';
 j:=0;
 i:=1;
 while i<=length(s) do begin
  w:=TPUCUUInt16(s[i]);
  inc(i);
  if (i<=length(s)) and ((w and $fc00)=$d800) and ((TPUCUUInt16(TPUCUUTF16Char(s[i])) and $fc00)=$dc00) then begin
   w:=(TPUCUUTF32Char(TPUCUUTF32Char(w and $3ff) shl 10) or TPUCUUTF32Char(TPUCUUInt16(s[i]) and $3ff))+$10000;
   inc(i);
  end;
  if w<=$7f then begin
   inc(j);
  end else if w<=$7ff then begin
   inc(j,2);
  end else if w<=$ffff then begin
   inc(j,3);
  end else if w<=$1fffff then begin
   inc(j,4);
{$ifndef PUCUStrictUTF8}
  end else if w<=$3ffffff then begin
   inc(j,5);
  end else if w<=$7fffffff then begin
   inc(j,6);
{$endif}
  end else begin
   inc(j,3);
  end;
 end;
 SetLength(result,j)