unit karten;
{$mode objfpc}
interface
uses sysutils;
type
  TKartenFarbe = longint;
  TKartenWert = longint; //A, 2, 3, 4, 5, 6, 7, 8,  9, 10, J, Q, K
  TKarte = record
    farbe: TKartenFarbe;
    wert : TkartenWert;
  end;
  
  T5Hand = array[1..5] of TKarte;
  T7Hand = array[1..7] of TKarte;
  
  function KarteToStr(k:Tkarte):string;
  
  function sortHand(k:T5Hand):T5Hand;
 // function sortHand(k:T7Hand):T7Hand;
  
  function pokerTexasHand(k:T5Hand): longint;overload;
  function pokerTexasHand(h:T7Hand): longint;overload;
  
implementation

function KarteToStr(k:Tkarte):string;
begin
  result:=inttostr(k.farbe)+':';
  if k.wert=1 then result+='A'
  else if k.wert=11 then result+='J'
  else if k.wert=12 then result+='Q'
  else if k.wert=13 then result+='K'
  else result+=inttostr(k.wert);
end;


function sortHand(k:T5Hand):T5Hand;overload;
var i,j:longint;
    temp:TKarte;
begin
  //Sortieren
  for i:=2 to 5 do 
    for j:=i-1 downto 1 do 
      if (k[j].wert<k[j+1].wert) or 
         ((k[j].wert=k[j+1].wert) and (k[j].farbe<k[j+1].farbe)) then break
      else begin
        temp:=k[j];
        k[j]:=k[j+1];
        k[j+1]:=temp;
      end;
  result:=k;
end;{
function sortHand(k:T7Hand):T7Hand;overload;
var i,j:longint;
    temp:TKarte;
begin
  //Sortieren
  for i:=2 to 7 do 
    for j:=i-1 downto 1 do 
      if (k[j].wert<k[j+1].wert) or 
         ((k[j].wert=k[j+1].wert) and (k[j].farbe<k[j+1].farbe)) then break
      else begin
        temp:=k[j];
        k[j]:=k[j+1];
        k[j+1]:=temp;
      end;
  result:=k;
end;}
function pokerTexasHand(k:T5Hand): longint;
const typeValue:longint=10000000;
  function highCard: longint;
  var temp: t5hand;
      i:longint;
  begin
    temp:=k;
    for i:=1 to 4 do
      if temp[1].wert=1 then temp[1].wert:=14;
    temp:=sortHand(temp);
    result:=temp[1].wert+20*(temp[2].wert+20*(temp[3].wert+20*(temp[4].wert+20*temp[5].wert)));
  end;

var i,p1,p2:longint;
    ok:boolean;
begin
  result:=0;
  k:=sortHand(k);
  
  //Straight/Royal Flush
  if (k[1].farbe=k[2].farbe)and(k[2].farbe=k[3].farbe) and (k[3].farbe=k[4].farbe)and(k[4].farbe=k[5].farbe) then
    if (k[2].wert+1=k[3].wert)and(k[3].wert+1=k[4].wert)  and (k[4].wert+1=k[5].wert) then 
      if (k[1].wert+1=k[2].wert) then exit(8*typeValue+k[5].wert) //straight
      else if (k[1].wert=1)and(k[5].wert=13) then
        exit(8*typeValue+14);//royal

  
  //Vierling
  if (k[1].wert=k[2].wert) and (k[1].wert=k[3].wert) and (k[1].wert=k[4].wert) then 
    exit(7*typeValue+k[1].wert*100+k[5].wert);
  if (k[2].wert=k[3].wert) and (k[2].wert=k[4].wert) and (k[2].wert=k[5].wert) then 
    exit(7*typeValue+k[2].wert*100+k[1].wert);

  //Full House
  if (k[1].wert=k[2].wert) and (k[3].wert=k[4].wert) and (k[3].wert=k[5].wert) then 
    exit(6*typeValue+k[5].wert*100+k[1].wert)
  else if (k[1].wert=k[2].wert) and (k[1].wert=k[3].wert) and (k[4].wert=k[5].wert) then 
    exit(6*typeValue+k[1].wert*100+k[5].wert);

  //Flush
  ok:=true;
  for i:=1 to 4 do
    if k[i].farbe<>k[i+1].farbe then ok:=false;
  if ok then
    exit(5*typeValue+highCard);
  
  //Strae / Straight
  if (k[2].wert+1=k[3].wert)and(k[3].wert+1=k[4].wert)  and (k[4].wert+1=k[5].wert) then 
    if (k[1].wert+1=k[2].wert) then exit(4*typeValue+k[5].wert)
    else if (k[1].wert=1)and(k[5].wert=13) then
      exit(4*typeValue+14);//ass

  //=Keine Ass = 1 beachtung mehr
  for i:=1 to 4 do 
    if k[i].wert=1 then k[i].wert:=14;
  k:=sorthand(k);
      
  //Drilling / Three of a kind
  if (k[1].wert=k[2].wert)and(k[1].wert=k[3].wert) then
     exit(3*typeValue+10000*k[1].wert+ 100*k[5].wert+k[4].wert);
  if (k[2].wert=k[3].wert)and(k[2].wert=k[4].wert) then
     exit(3*typeValue+10000*k[2].wert+100*k[5].wert+k[1].wert);
  if (k[3].wert=k[4].wert)and(k[3].wert=k[5].wert) then
     exit(3*typeValue+10000*k[3].wert+100*k[2].wert+k[1].wert);

     //Two Pair 
  if (k[1].wert=k[2].wert) and (k[3].wert=k[4].wert) then
    exit(2*typeValue+10000*k[3].wert+100*k[1].wert+k[5].wert);
  if (k[1].wert=k[2].wert) and (k[4].wert=k[5].wert) then
    exit(2*typeValue+10000*k[5].wert+100*k[1].wert+k[3].wert);
  if (k[2].wert=k[3].wert) and (k[4].wert=k[5].wert) then
    exit(2*typeValue+10000*k[5].wert+100*k[3].wert+k[1].wert);
  
  //Pair
  if k[1].wert=k[2].wert then
    exit(1*typeValue+8000*k[1].wert+400*k[5].wert+20*k[4].wert+k[3].wert);
  if k[2].wert=k[3].wert then
    exit(1*typeValue+8000*k[2].wert+400*k[5].wert+20*k[4].wert+k[1].wert);
  if k[3].wert=k[4].wert then
    exit(1*typeValue+8000*k[3].wert+400*k[5].wert+20*k[2].wert+k[1].wert);
  if k[4].wert=k[5].wert then
    exit(1*typeValue+8000*k[4].wert+400*k[3].wert+20*k[2].wert+k[1].wert);

  //High Card
  exit(k[1].wert+20*(k[2].wert+20*(k[3].wert+20*(k[4].wert+20*k[5].wert))));
end;


function pokerTexasHand(h:T7Hand): longint;overload;
var i,j,k,p,b:longint;
    temp:t5hand;
begin
  result:=0;
  for i:=1 to 7 do
    for j:=i+1 to 7 do begin
      p:=1;
      for k:=1 to 7 do
        if (k<>i) and (k<>j) then begin
          temp[p]:=h[k];
          p:=p+1;
        end;
      b:=pokerTexasHand(temp);
      if b>result then result:=b;
    end;
end;
end.