unit treelistviewexampleverticalu;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, TreeListView, LCLType, ExtCtrls, Grids;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure tlvClickAtItem(sender: TObject; item: TTreeListItem);
    procedure tlvCustomRecordItemPositioning(sender: TObject; visualColumnIndex: integer; recordItem: TTreeListRecordItem;
      var aposition: TRect);
  private
    { private declarations }
  public
    { public declarations }
    tlv: TTreeListView;
    realRowHeight: Integer;
  end;

var
  Form1: TForm1;

implementation

uses LCLProc;
{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  debugLn('FormCreate IN');
  tlv := TTreeListView.Create(self);
  debugLn('FormCreate TLV 1');

  tlv.Parent:=self;
  tlv.Visible:=true;
  tlv.Align:=alClient;
  tlv.Columns.Clear;
  tlv.VerticalLineMode:=lmNone;
  tlv.OnClickAtItem:=@tlvClickAtItem;
  tlv.Options := tlv.Options + [tlvoDragScrolling];
  realRowHeight := tlv.RowHeight;
  tlv.RowHeight:=tlv.RowHeight*2;
  debugLn('FormCreate TLV 2');
  with tlv.Columns.add do begin DebugLn('2.0a'); text := 'a'; DebugLn('2.0b');Width:=150; DebugLn('2.0c');end;
  debugLn('FormCreate TLV 2a');
  with tlv.Columns.add do text := 'b';
  debugLn('FormCreate TLV 2b');
  with tlv.Columns.add do text := 'c';
  with tlv.Columns.add do text := 'd';
  debugLn('FormCreate TLV 2c.');
  with tlv.Items.Add('foobar2').SubItems do begin
    debugLn('FormCreate TLV 2d');
    with Add('123') do begin
      debugLn('FormCreate TLV 2e');
      RecordItemsText[1] := 'x';
      debugLn('FormCreate TLV 2f');
      RecordItemsText[2] := 'y';
      debugLn('FormCreate TLV 2g');
      RecordItemsText[3] := 'z';
      debugLn('FormCreate TLV 2h');
    end;
    debugLn('FormCreate TLV 2i');
    add('2345');
    add('45665').SubItems.Add('9344');
    add('adda s f long very long text adda s f long very long text adda s f long very long text');
    add('Click here to talk');
  end;
  debugLn('FormCreate TLV 3');
  for i := 1 to 100 do
    with tlv.items.add(inttostr(i)) do begin
      RecordItemsText[1] := 'x';
      RecordItemsText[2] := 'y';
      RecordItemsText[3] := 'z';
    end;



  tlv.OnCustomRecordItemPositioning:=@tlvCustomRecordItemPositioning;
  debugLn('FormCreate TLV 4');
  debugLn('FormCreate OUT');


end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  tlv.Items.InsertObject(0, TTreeListItem.Create(nil,tlv, edit1.text));
  Application.MessageBox('Text', 'Title', MB_ABORTRETRYIGNORE);
  //tlv.Repaint;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  tlv.UpdateScrollSize;
  tlv.UpdateScrollBarPos;
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin

end;

procedure TForm1.tlvClickAtItem(sender: TObject; item: TTreeListItem);
begin
  if item.Text = 'Click here to talk' then Application.MessageBox('Text', 'Title', MB_ABORTRETRYIGNORE);
  if item <> nil then edit1.text:=item.text;
  button1.Caption:=edit1.text;
end;

procedure TForm1.tlvCustomRecordItemPositioning(sender: TObject; visualColumnIndex: integer; recordItem: TTreeListRecordItem;
  var aposition: TRect);
begin
  if visualColumnIndex = 0 then begin
    aposition.Right:=width;
    aposition.Bottom:=aposition.top + realRowHeight;
  end else begin
    aposition.Top:=aposition.top + realRowHeight;
    aposition.Left-=tlv.Columns.Items[0].Width-15*recordItem.Parent.Indent-20;
    aposition.Right-=tlv.Columns.Items[0].Width-15*recordItem.Parent.Indent-20;
  end;
end;

end.

