unit diagramExample;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, ExtCtrls, diagram, RTTIGrids;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ComboBox1: TComboBox;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox1Select(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    diagramView: TDiagramView;
    TIPropertyGrid1: TTIPropertyGrid;
  end; 
var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
   diagramView:=TDiagramView.create(Panel1);
   diagramView.Parent:=Panel1;
   diagramView.Align:=alClient;
   diagramView.SetModel(TDiagramDataListModel.create,true);
   diagramView.Drawer.PointStyle:=psCircle;
   diagramView.Drawer.FillStyle:=fsLastOverFirst; //use nices display
   diagramView.AllowedEditActions:=[eaDeletePoints,eaMovePoints,eaAddPoints];
   TDiagramDataListModel(diagramView.Model).Flags:=[mfEditable];
   TIPropertyGrid1:=TTIPropertyGrid.Create(Panel3);
   TIPropertyGrid1.Parent:=panel3;
   TIPropertyGrid1.align:=alClient;
   TIPropertyGrid1.TIObject:=diagramView;
   ComboBox1.Items.Text:='View'#13#10'Model';

   //give us some data
   Button1.Click;
   Button1.Click;
end;

procedure TForm1.Button1Click(Sender: TObject);
var dlm:TDiagramDataListModel;
    i:longint;
begin
  if not (diagramView.Model is TDiagramDataListModel) then exit;
  dlm:= diagramView.Model as TDiagramDataListModel;
  if StrToInt(edit1.text)>=dlm.dataRows then begin
    dlm.setDataRows(StrToInt(edit1.text)+1);
    ComboBox1.Items.Text:='View'#13#10'Model';
    for i:=1 to dlm.dataRows do ComboBox1.Items.Add('Datalist '+inttostr(i));
  end;
  dlm.lists[StrToInt(edit1.text)].addPoint(StrToFloat(edit2.text),StrToFloat(edit3.text));
  edit2.text:=FloatToStr(StrToFloat(edit2.text)+1);
  edit3.text:=FloatToStr(StrToFloat(edit3.text)+1+StrToInt(edit1.text));
end;

procedure TForm1.Button2Click(Sender: TObject);
var dlm:TDiagramDataListModel;
begin
  if not (diagramView.Model is TDiagramDataListModel) then exit;
  dlm:= diagramView.Model as TDiagramDataListModel;
  if  (StrToInt(edit4.text)>=0) and ( StrToInt(edit4.text)<dlm.dataRows) then dlm.lists[StrToInt(edit4.text)].clear();
end;

procedure TForm1.Button3Click(Sender: TObject);
var nf1: tform1;
begin
  nf1:=TForm1.Create(Application);
  nf1.diagramView.SetModel(diagramView.Model,false);
  nf1.Caption:='clone';
  nf1.Show;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
end;

procedure TForm1.ComboBox1Select(Sender: TObject);
begin
  if ComboBox1.ItemIndex = 0 then TIPropertyGrid1.TIObject:=diagramView
  else if ComboBox1.ItemIndex=1 then TIPropertyGrid1.TIObject:=TDiagramDataListModel(diagramView.Model)
  else TIPropertyGrid1.TIObject:=TDiagramDataListModel(diagramView.Model).lists[ComboBox1.ItemIndex-2];
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
 Edit2.Text:='0';
 Edit3.text:=edit1.text;
end;

initialization
  {$I diagramexample.lrs}

end.

