{**
  This program parses the bbutils_template.pas file and generates the
  bbutils.pas file.@br@br

}

program bbutils_generate;

{$mode objfpc}{$H+}
{$ModeSwitch advancedrecords}

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, sysutils, pastemplate
  {Attention: Bootstraping! This program generates bbutils, but need bbutils to be compiled.
                            If you don't have bbutils, you can use bbutils_template instead
  }
  ,  bbutils, math
//  , bbutils_template
  { you can add units after this };

{$R *.res}

const LineEnding = #13#10;

type
TTrieNode = class
  data: string;
  mandatory: string;
  childCount: integer;
  children: array[char] of TTrieNode;
  procedure add(const key, value: string);
  procedure compress;
  function serialize(): string;
private
//  {$define trietests}
  {$ifdef trietests}class procedure tests;{$endif}
end;

procedure TTrieNode.add(const key, value: string);
begin
  if key = '' then data := value
  else begin
    if children[key[1]] = nil then begin
      inc(childCount);
      children[key[1]] := TTrieNode.Create;
    end;
    children[key[1]].add(strCopyFrom(key, 2), value);
  end;
end;

procedure TTrieNode.compress;
var
  c, child: Char;
begin
  for c := low(children) to high(children) do
    if children[c] <> nil then begin
      child := c;
      children[c].compress;
    end;
  if (childCount = 1) and (data = '') then begin
    mandatory := child + children[child].mandatory;
    data := children[child].data;
    childCount := children[child].childCount;
    children := children[child].children;
  end;
end;

function TTrieNode.serialize: string;
var
  p, flags, oldDelta: Integer;
  serializedMandatory, serchildren: String;
  c, tooBigChild: Char;
  serializedChildren: array[char] of string;
const FLAG_HAS_DATA = 128;
const FLAG_HAS_FIXED_PREFIX = 64;
begin
  serchildren := '';
  serializedMandatory := '';
  if mandatory <> '' then begin
    serializedMandatory := chr(FLAG_HAS_FIXED_PREFIX or length(mandatory));
    serializedMandatory += mandatory;
  end;
  SetLength(result, 1 + 2*childCount );
  result += data;
  oldDelta := length(data);
  if length(Result) > 255 then Abort;
  flags := 0;
  if data <> '' then
    flags := flags or FLAG_HAS_DATA;
  if childCount >= FLAG_HAS_FIXED_PREFIX then abort;

  tooBigChild := #0;
  for c := low(children) to high(children) do begin
    if children[c] = nil then continue;
    serializedChildren[c] := children[c].serialize() ;
    if length(serializedChildren[c]) >= 255 then begin
      if tooBigChild <> #0 then
        abort;
      tooBigChild := c;
    end;
  end;

  result[1] := chr(flags or childCount);
  p := 2;
  for c := low(children) to high(children) do begin
    if children[c] = nil then continue;
    if c = tooBigChild then continue;
    result[p] := c;
    if oldDelta > 255 then
      abort;
    result[p+1] := chr( oldDelta );
    inc(p, 2);
    serchildren := serializedChildren[c];
    oldDelta := length(serchildren);
    result += serchildren;
  end;
  if tooBigChild <> #0 then begin
    result[p] := tooBigChild;
    if oldDelta > 255 then
      abort;
    result[p+1] := chr( oldDelta );
    result += serializedChildren[tooBigChild];
  end;
  result := serializedMandatory + Result;
end;

{$ifdef trietests}
class procedure TTrieNode.tests;
var test: TTrieNode;
begin
  test := TTrieNode.Create;
  test.add('ABC;', '12');
  test.add('ABCDEF;', 'x2');
  test.add('ABCDEG;', 'x3');
  test.add('FOO;', 'new');
  test.compress;
  writeln(test.serialize());
end;
{$endif}

//This generate the strDecodeHTMLEntities function of bbutils.pas

type TEntity=record
  s:string;
  c: int64;
  function getUtf8: string;
end;

{
This table contains all html 5.0 entities and is used to auto generate the strDecodeHTMLEntities.. function.

table generated using
   xidel https://www.w3.org/TR/html5/entities.json -e $'jn:keys($json)!x"(s:\'{.}\';c:{let $cps := $json(.)("codepoints") return ($cps(3)*9999999999999999,0)[1] + ($cps(2)*10000000,0)[1] + $cps(1) }),"'

}

const entities: array[1..2231] of TEntity=(
(s:'&Aacute;';c:193),
(s:'&Aacute';c:193),
(s:'&aacute;';c:225),
(s:'&aacute';c:225),
(s:'&Abreve;';c:258),
(s:'&abreve;';c:259),
(s:'&ac;';c:8766),
(s:'&acd;';c:8767),
(s:'&acE;';c:8190008766),
(s:'&Acirc;';c:194),
(s:'&Acirc';c:194),
(s:'&acirc;';c:226),
(s:'&acirc';c:226),
(s:'&acute;';c:180),
(s:'&acute';c:180),
(s:'&Acy;';c:1040),
(s:'&acy;';c:1072),
(s:'&AElig;';c:198),
(s:'&AElig';c:198),
(s:'&aelig;';c:230),
(s:'&aelig';c:230),
(s:'&af;';c:8289),
(s:'&Afr;';c:120068),
(s:'&afr;';c:120094),
(s:'&Agrave;';c:192),
(s:'&Agrave';c:192),
(s:'&agrave;';c:224),
(s:'&agrave';c:224),
(s:'&alefsym;';c:8501),
(s:'&aleph;';c:8501),
(s:'&Alpha;';c:913),
(s:'&alpha;';c:945),
(s:'&Amacr;';c:256),
(s:'&amacr;';c:257),
(s:'&amalg;';c:10815),
(s:'&AMP;';c:38),
(s:'&AMP';c:38),
(s:'&amp;';c:38),
(s:'&amp';c:38),
(s:'&And;';c:10835),
(s:'&and;';c:8743),
(s:'&andand;';c:10837),
(s:'&andd;';c:10844),
(s:'&andslope;';c:10840),
(s:'&andv;';c:10842),
(s:'&ang;';c:8736),
(s:'&ange;';c:10660),
(s:'&angle;';c:8736),
(s:'&angmsd;';c:8737),
(s:'&angmsdaa;';c:10664),
(s:'&angmsdab;';c:10665),
(s:'&angmsdac;';c:10666),
(s:'&angmsdad;';c:10667),
(s:'&angmsdae;';c:10668),
(s:'&angmsdaf;';c:10669),
(s:'&angmsdag;';c:10670),
(s:'&angmsdah;';c:10671),
(s:'&angrt;';c:8735),
(s:'&angrtvb;';c:8894),
(s:'&angrtvbd;';c:10653),
(s:'&angsph;';c:8738),
(s:'&angst;';c:197),
(s:'&angzarr;';c:9084),
(s:'&Aogon;';c:260),
(s:'&aogon;';c:261),
(s:'&Aopf;';c:120120),
(s:'&aopf;';c:120146),
(s:'&ap;';c:8776),
(s:'&apacir;';c:10863),
(s:'&apE;';c:10864),
(s:'&ape;';c:8778),
(s:'&apid;';c:8779),
(s:'&apos;';c:39),
(s:'&ApplyFunction;';c:8289),
(s:'&approx;';c:8776),
(s:'&approxeq;';c:8778),
(s:'&Aring;';c:197),
(s:'&Aring';c:197),
(s:'&aring;';c:229),
(s:'&aring';c:229),
(s:'&Ascr;';c:119964),
(s:'&ascr;';c:119990),
(s:'&Assign;';c:8788),
(s:'&ast;';c:42),
(s:'&asymp;';c:8776),
(s:'&asympeq;';c:8781),
(s:'&Atilde;';c:195),
(s:'&Atilde';c:195),
(s:'&atilde;';c:227),
(s:'&atilde';c:227),
(s:'&Auml;';c:196),
(s:'&Auml';c:196),
(s:'&auml;';c:228),
(s:'&auml';c:228),
(s:'&awconint;';c:8755),
(s:'&awint;';c:10769),
(s:'&backcong;';c:8780),
(s:'&backepsilon;';c:1014),
(s:'&backprime;';c:8245),
(s:'&backsim;';c:8765),
(s:'&backsimeq;';c:8909),
(s:'&Backslash;';c:8726),
(s:'&Barv;';c:10983),
(s:'&barvee;';c:8893),
(s:'&Barwed;';c:8966),
(s:'&barwed;';c:8965),
(s:'&barwedge;';c:8965),
(s:'&bbrk;';c:9141),
(s:'&bbrktbrk;';c:9142),
(s:'&bcong;';c:8780),
(s:'&Bcy;';c:1041),
(s:'&bcy;';c:1073),
(s:'&bdquo;';c:8222),
(s:'&becaus;';c:8757),
(s:'&Because;';c:8757),
(s:'&because;';c:8757),
(s:'&bemptyv;';c:10672),
(s:'&bepsi;';c:1014),
(s:'&bernou;';c:8492),
(s:'&Bernoullis;';c:8492),
(s:'&Beta;';c:914),
(s:'&beta;';c:946),
(s:'&beth;';c:8502),
(s:'&between;';c:8812),
(s:'&Bfr;';c:120069),
(s:'&bfr;';c:120095),
(s:'&bigcap;';c:8898),
(s:'&bigcirc;';c:9711),
(s:'&bigcup;';c:8899),
(s:'&bigodot;';c:10752),
(s:'&bigoplus;';c:10753),
(s:'&bigotimes;';c:10754),
(s:'&bigsqcup;';c:10758),
(s:'&bigstar;';c:9733),
(s:'&bigtriangledown;';c:9661),
(s:'&bigtriangleup;';c:9651),
(s:'&biguplus;';c:10756),
(s:'&bigvee;';c:8897),
(s:'&bigwedge;';c:8896),
(s:'&bkarow;';c:10509),
(s:'&blacklozenge;';c:10731),
(s:'&blacksquare;';c:9642),
(s:'&blacktriangle;';c:9652),
(s:'&blacktriangledown;';c:9662),
(s:'&blacktriangleleft;';c:9666),
(s:'&blacktriangleright;';c:9656),
(s:'&blank;';c:9251),
(s:'&blk12;';c:9618),
(s:'&blk14;';c:9617),
(s:'&blk34;';c:9619),
(s:'&block;';c:9608),
(s:'&bne;';c:84210000061),
(s:'&bnequiv;';c:84210008801),
(s:'&bNot;';c:10989),
(s:'&bnot;';c:8976),
(s:'&Bopf;';c:120121),
(s:'&bopf;';c:120147),
(s:'&bot;';c:8869),
(s:'&bottom;';c:8869),
(s:'&bowtie;';c:8904),
(s:'&boxbox;';c:10697),
(s:'&boxDL;';c:9559),
(s:'&boxDl;';c:9558),
(s:'&boxdL;';c:9557),
(s:'&boxdl;';c:9488),
(s:'&boxDR;';c:9556),
(s:'&boxDr;';c:9555),
(s:'&boxdR;';c:9554),
(s:'&boxdr;';c:9484),
(s:'&boxH;';c:9552),
(s:'&boxh;';c:9472),
(s:'&boxHD;';c:9574),
(s:'&boxHd;';c:9572),
(s:'&boxhD;';c:9573),
(s:'&boxhd;';c:9516),
(s:'&boxHU;';c:9577),
(s:'&boxHu;';c:9575),
(s:'&boxhU;';c:9576),
(s:'&boxhu;';c:9524),
(s:'&boxminus;';c:8863),
(s:'&boxplus;';c:8862),
(s:'&boxtimes;';c:8864),
(s:'&boxUL;';c:9565),
(s:'&boxUl;';c:9564),
(s:'&boxuL;';c:9563),
(s:'&boxul;';c:9496),
(s:'&boxUR;';c:9562),
(s:'&boxUr;';c:9561),
(s:'&boxuR;';c:9560),
(s:'&boxur;';c:9492),
(s:'&boxV;';c:9553),
(s:'&boxv;';c:9474),
(s:'&boxVH;';c:9580),
(s:'&boxVh;';c:9579),
(s:'&boxvH;';c:9578),
(s:'&boxvh;';c:9532),
(s:'&boxVL;';c:9571),
(s:'&boxVl;';c:9570),
(s:'&boxvL;';c:9569),
(s:'&boxvl;';c:9508),
(s:'&boxVR;';c:9568),
(s:'&boxVr;';c:9567),
(s:'&boxvR;';c:9566),
(s:'&boxvr;';c:9500),
(s:'&bprime;';c:8245),
(s:'&Breve;';c:728),
(s:'&breve;';c:728),
(s:'&brvbar;';c:166),
(s:'&brvbar';c:166),
(s:'&Bscr;';c:8492),
(s:'&bscr;';c:119991),
(s:'&bsemi;';c:8271),
(s:'&bsim;';c:8765),
(s:'&bsime;';c:8909),
(s:'&bsol;';c:92),
(s:'&bsolb;';c:10693),
(s:'&bsolhsub;';c:10184),
(s:'&bull;';c:8226),
(s:'&bullet;';c:8226),
(s:'&bump;';c:8782),
(s:'&bumpE;';c:10926),
(s:'&bumpe;';c:8783),
(s:'&Bumpeq;';c:8782),
(s:'&bumpeq;';c:8783),
(s:'&Cacute;';c:262),
(s:'&cacute;';c:263),
(s:'&Cap;';c:8914),
(s:'&cap;';c:8745),
(s:'&capand;';c:10820),
(s:'&capbrcup;';c:10825),
(s:'&capcap;';c:10827),
(s:'&capcup;';c:10823),
(s:'&capdot;';c:10816),
(s:'&CapitalDifferentialD;';c:8517),
(s:'&caps;';c:650240008745),
(s:'&caret;';c:8257),
(s:'&caron;';c:711),
(s:'&Cayleys;';c:8493),
(s:'&ccaps;';c:10829),
(s:'&Ccaron;';c:268),
(s:'&ccaron;';c:269),
(s:'&Ccedil;';c:199),
(s:'&Ccedil';c:199),
(s:'&ccedil;';c:231),
(s:'&ccedil';c:231),
(s:'&Ccirc;';c:264),
(s:'&ccirc;';c:265),
(s:'&Cconint;';c:8752),
(s:'&ccups;';c:10828),
(s:'&ccupssm;';c:10832),
(s:'&Cdot;';c:266),
(s:'&cdot;';c:267),
(s:'&cedil;';c:184),
(s:'&cedil';c:184),
(s:'&Cedilla;';c:184),
(s:'&cemptyv;';c:10674),
(s:'&cent;';c:162),
(s:'&cent';c:162),
(s:'&CenterDot;';c:183),
(s:'&centerdot;';c:183),
(s:'&Cfr;';c:8493),
(s:'&cfr;';c:120096),
(s:'&CHcy;';c:1063),
(s:'&chcy;';c:1095),
(s:'&check;';c:10003),
(s:'&checkmark;';c:10003),
(s:'&Chi;';c:935),
(s:'&chi;';c:967),
(s:'&cir;';c:9675),
(s:'&circ;';c:710),
(s:'&circeq;';c:8791),
(s:'&circlearrowleft;';c:8634),
(s:'&circlearrowright;';c:8635),
(s:'&circledast;';c:8859),
(s:'&circledcirc;';c:8858),
(s:'&circleddash;';c:8861),
(s:'&CircleDot;';c:8857),
(s:'&circledR;';c:174),
(s:'&circledS;';c:9416),
(s:'&CircleMinus;';c:8854),
(s:'&CirclePlus;';c:8853),
(s:'&CircleTimes;';c:8855),
(s:'&cirE;';c:10691),
(s:'&cire;';c:8791),
(s:'&cirfnint;';c:10768),
(s:'&cirmid;';c:10991),
(s:'&cirscir;';c:10690),
(s:'&ClockwiseContourIntegral;';c:8754),
(s:'&CloseCurlyDoubleQuote;';c:8221),
(s:'&CloseCurlyQuote;';c:8217),
(s:'&clubs;';c:9827),
(s:'&clubsuit;';c:9827),
(s:'&Colon;';c:8759),
(s:'&colon;';c:58),
(s:'&Colone;';c:10868),
(s:'&colone;';c:8788),
(s:'&coloneq;';c:8788),
(s:'&comma;';c:44),
(s:'&commat;';c:64),
(s:'&comp;';c:8705),
(s:'&compfn;';c:8728),
(s:'&complement;';c:8705),
(s:'&complexes;';c:8450),
(s:'&cong;';c:8773),
(s:'&congdot;';c:10861),
(s:'&Congruent;';c:8801),
(s:'&Conint;';c:8751),
(s:'&conint;';c:8750),
(s:'&ContourIntegral;';c:8750),
(s:'&Copf;';c:8450),
(s:'&copf;';c:120148),
(s:'&coprod;';c:8720),
(s:'&Coproduct;';c:8720),
(s:'&COPY;';c:169),
(s:'&COPY';c:169),
(s:'&copy;';c:169),
(s:'&copy';c:169),
(s:'&copysr;';c:8471),
(s:'&CounterClockwiseContourIntegral;';c:8755),
(s:'&crarr;';c:8629),
(s:'&Cross;';c:10799),
(s:'&cross;';c:10007),
(s:'&Cscr;';c:119966),
(s:'&cscr;';c:119992),
(s:'&csub;';c:10959),
(s:'&csube;';c:10961),
(s:'&csup;';c:10960),
(s:'&csupe;';c:10962),
(s:'&ctdot;';c:8943),
(s:'&cudarrl;';c:10552),
(s:'&cudarrr;';c:10549),
(s:'&cuepr;';c:8926),
(s:'&cuesc;';c:8927),
(s:'&cularr;';c:8630),
(s:'&cularrp;';c:10557),
(s:'&Cup;';c:8915),
(s:'&cup;';c:8746),
(s:'&cupbrcap;';c:10824),
(s:'&CupCap;';c:8781),
(s:'&cupcap;';c:10822),
(s:'&cupcup;';c:10826),
(s:'&cupdot;';c:8845),
(s:'&cupor;';c:10821),
(s:'&cups;';c:650240008746),
(s:'&curarr;';c:8631),
(s:'&curarrm;';c:10556),
(s:'&curlyeqprec;';c:8926),
(s:'&curlyeqsucc;';c:8927),
(s:'&curlyvee;';c:8910),
(s:'&curlywedge;';c:8911),
(s:'&curren;';c:164),
(s:'&curren';c:164),
(s:'&curvearrowleft;';c:8630),
(s:'&curvearrowright;';c:8631),
(s:'&cuvee;';c:8910),
(s:'&cuwed;';c:8911),
(s:'&cwconint;';c:8754),
(s:'&cwint;';c:8753),
(s:'&cylcty;';c:9005),
(s:'&Dagger;';c:8225),
(s:'&dagger;';c:8224),
(s:'&daleth;';c:8504),
(s:'&Darr;';c:8609),
(s:'&dArr;';c:8659),
(s:'&darr;';c:8595),
(s:'&dash;';c:8208),
(s:'&Dashv;';c:10980),
(s:'&dashv;';c:8867),
(s:'&dbkarow;';c:10511),
(s:'&dblac;';c:733),
(s:'&Dcaron;';c:270),
(s:'&dcaron;';c:271),
(s:'&Dcy;';c:1044),
(s:'&dcy;';c:1076),
(s:'&DD;';c:8517),
(s:'&dd;';c:8518),
(s:'&ddagger;';c:8225),
(s:'&ddarr;';c:8650),
(s:'&DDotrahd;';c:10513),
(s:'&ddotseq;';c:10871),
(s:'&deg;';c:176),
(s:'&deg';c:176),
(s:'&Del;';c:8711),
(s:'&Delta;';c:916),
(s:'&delta;';c:948),
(s:'&demptyv;';c:10673),
(s:'&dfisht;';c:10623),
(s:'&Dfr;';c:120071),
(s:'&dfr;';c:120097),
(s:'&dHar;';c:10597),
(s:'&dharl;';c:8643),
(s:'&dharr;';c:8642),
(s:'&DiacriticalAcute;';c:180),
(s:'&DiacriticalDot;';c:729),
(s:'&DiacriticalDoubleAcute;';c:733),
(s:'&DiacriticalGrave;';c:96),
(s:'&DiacriticalTilde;';c:732),
(s:'&diam;';c:8900),
(s:'&Diamond;';c:8900),
(s:'&diamond;';c:8900),
(s:'&diamondsuit;';c:9830),
(s:'&diams;';c:9830),
(s:'&die;';c:168),
(s:'&DifferentialD;';c:8518),
(s:'&digamma;';c:989),
(s:'&disin;';c:8946),
(s:'&div;';c:247),
(s:'&divide;';c:247),
(s:'&divide';c:247),
(s:'&divideontimes;';c:8903),
(s:'&divonx;';c:8903),
(s:'&DJcy;';c:1026),
(s:'&djcy;';c:1106),
(s:'&dlcorn;';c:8990),
(s:'&dlcrop;';c:8973),
(s:'&dollar;';c:36),
(s:'&Dopf;';c:120123),
(s:'&dopf;';c:120149),
(s:'&Dot;';c:168),
(s:'&dot;';c:729),
(s:'&DotDot;';c:8412),
(s:'&doteq;';c:8784),
(s:'&doteqdot;';c:8785),
(s:'&DotEqual;';c:8784),
(s:'&dotminus;';c:8760),
(s:'&dotplus;';c:8724),
(s:'&dotsquare;';c:8865),
(s:'&doublebarwedge;';c:8966),
(s:'&DoubleContourIntegral;';c:8751),
(s:'&DoubleDot;';c:168),
(s:'&DoubleDownArrow;';c:8659),
(s:'&DoubleLeftArrow;';c:8656),
(s:'&DoubleLeftRightArrow;';c:8660),
(s:'&DoubleLeftTee;';c:10980),
(s:'&DoubleLongLeftArrow;';c:10232),
(s:'&DoubleLongLeftRightArrow;';c:10234),
(s:'&DoubleLongRightArrow;';c:10233),
(s:'&DoubleRightArrow;';c:8658),
(s:'&DoubleRightTee;';c:8872),
(s:'&DoubleUpArrow;';c:8657),
(s:'&DoubleUpDownArrow;';c:8661),
(s:'&DoubleVerticalBar;';c:8741),
(s:'&DownArrow;';c:8595),
(s:'&Downarrow;';c:8659),
(s:'&downarrow;';c:8595),
(s:'&DownArrowBar;';c:10515),
(s:'&DownArrowUpArrow;';c:8693),
(s:'&DownBreve;';c:785),
(s:'&downdownarrows;';c:8650),
(s:'&downharpoonleft;';c:8643),
(s:'&downharpoonright;';c:8642),
(s:'&DownLeftRightVector;';c:10576),
(s:'&DownLeftTeeVector;';c:10590),
(s:'&DownLeftVector;';c:8637),
(s:'&DownLeftVectorBar;';c:10582),
(s:'&DownRightTeeVector;';c:10591),
(s:'&DownRightVector;';c:8641),
(s:'&DownRightVectorBar;';c:10583),
(s:'&DownTee;';c:8868),
(s:'&DownTeeArrow;';c:8615),
(s:'&drbkarow;';c:10512),
(s:'&drcorn;';c:8991),
(s:'&drcrop;';c:8972),
(s:'&Dscr;';c:119967),
(s:'&dscr;';c:119993),
(s:'&DScy;';c:1029),
(s:'&dscy;';c:1109),
(s:'&dsol;';c:10742),
(s:'&Dstrok;';c:272),
(s:'&dstrok;';c:273),
(s:'&dtdot;';c:8945),
(s:'&dtri;';c:9663),
(s:'&dtrif;';c:9662),
(s:'&duarr;';c:8693),
(s:'&duhar;';c:10607),
(s:'&dwangle;';c:10662),
(s:'&DZcy;';c:1039),
(s:'&dzcy;';c:1119),
(s:'&dzigrarr;';c:10239),
(s:'&Eacute;';c:201),
(s:'&Eacute';c:201),
(s:'&eacute;';c:233),
(s:'&eacute';c:233),
(s:'&easter;';c:10862),
(s:'&Ecaron;';c:282),
(s:'&ecaron;';c:283),
(s:'&ecir;';c:8790),
(s:'&Ecirc;';c:202),
(s:'&Ecirc';c:202),
(s:'&ecirc;';c:234),
(s:'&ecirc';c:234),
(s:'&ecolon;';c:8789),
(s:'&Ecy;';c:1069),
(s:'&ecy;';c:1101),
(s:'&eDDot;';c:10871),
(s:'&Edot;';c:278),
(s:'&eDot;';c:8785),
(s:'&edot;';c:279),
(s:'&ee;';c:8519),
(s:'&efDot;';c:8786),
(s:'&Efr;';c:120072),
(s:'&efr;';c:120098),
(s:'&eg;';c:10906),
(s:'&Egrave;';c:200),
(s:'&Egrave';c:200),
(s:'&egrave;';c:232),
(s:'&egrave';c:232),
(s:'&egs;';c:10902),
(s:'&egsdot;';c:10904),
(s:'&el;';c:10905),
(s:'&Element;';c:8712),
(s:'&elinters;';c:9191),
(s:'&ell;';c:8467),
(s:'&els;';c:10901),
(s:'&elsdot;';c:10903),
(s:'&Emacr;';c:274),
(s:'&emacr;';c:275),
(s:'&empty;';c:8709),
(s:'&emptyset;';c:8709),
(s:'&EmptySmallSquare;';c:9723),
(s:'&emptyv;';c:8709),
(s:'&EmptyVerySmallSquare;';c:9643),
(s:'&emsp;';c:8195),
(s:'&emsp13;';c:8196),
(s:'&emsp14;';c:8197),
(s:'&ENG;';c:330),
(s:'&eng;';c:331),
(s:'&ensp;';c:8194),
(s:'&Eogon;';c:280),
(s:'&eogon;';c:281),
(s:'&Eopf;';c:120124),
(s:'&eopf;';c:120150),
(s:'&epar;';c:8917),
(s:'&eparsl;';c:10723),
(s:'&eplus;';c:10865),
(s:'&epsi;';c:949),
(s:'&Epsilon;';c:917),
(s:'&epsilon;';c:949),
(s:'&epsiv;';c:1013),
(s:'&eqcirc;';c:8790),
(s:'&eqcolon;';c:8789),
(s:'&eqsim;';c:8770),
(s:'&eqslantgtr;';c:10902),
(s:'&eqslantless;';c:10901),
(s:'&Equal;';c:10869),
(s:'&equals;';c:61),
(s:'&EqualTilde;';c:8770),
(s:'&equest;';c:8799),
(s:'&Equilibrium;';c:8652),
(s:'&equiv;';c:8801),
(s:'&equivDD;';c:10872),
(s:'&eqvparsl;';c:10725),
(s:'&erarr;';c:10609),
(s:'&erDot;';c:8787),
(s:'&Escr;';c:8496),
(s:'&escr;';c:8495),
(s:'&esdot;';c:8784),
(s:'&Esim;';c:10867),
(s:'&esim;';c:8770),
(s:'&Eta;';c:919),
(s:'&eta;';c:951),
(s:'&ETH;';c:208),
(s:'&ETH';c:208),
(s:'&eth;';c:240),
(s:'&eth';c:240),
(s:'&Euml;';c:203),
(s:'&Euml';c:203),
(s:'&euml;';c:235),
(s:'&euml';c:235),
(s:'&euro;';c:8364),
(s:'&excl;';c:33),
(s:'&exist;';c:8707),
(s:'&Exists;';c:8707),
(s:'&expectation;';c:8496),
(s:'&ExponentialE;';c:8519),
(s:'&exponentiale;';c:8519),
(s:'&fallingdotseq;';c:8786),
(s:'&Fcy;';c:1060),
(s:'&fcy;';c:1092),
(s:'&female;';c:9792),
(s:'&ffilig;';c:64259),
(s:'&fflig;';c:64256),
(s:'&ffllig;';c:64260),
(s:'&Ffr;';c:120073),
(s:'&ffr;';c:120099),
(s:'&filig;';c:64257),
(s:'&FilledSmallSquare;';c:9724),
(s:'&FilledVerySmallSquare;';c:9642),
(s:'&fjlig;';c:1060000102),
(s:'&flat;';c:9837),
(s:'&fllig;';c:64258),
(s:'&fltns;';c:9649),
(s:'&fnof;';c:402),
(s:'&Fopf;';c:120125),
(s:'&fopf;';c:120151),
(s:'&ForAll;';c:8704),
(s:'&forall;';c:8704),
(s:'&fork;';c:8916),
(s:'&forkv;';c:10969),
(s:'&Fouriertrf;';c:8497),
(s:'&fpartint;';c:10765),
(s:'&frac12;';c:189),
(s:'&frac12';c:189),
(s:'&frac13;';c:8531),
(s:'&frac14;';c:188),
(s:'&frac14';c:188),
(s:'&frac15;';c:8533),
(s:'&frac16;';c:8537),
(s:'&frac18;';c:8539),
(s:'&frac23;';c:8532),
(s:'&frac25;';c:8534),
(s:'&frac34;';c:190),
(s:'&frac34';c:190),
(s:'&frac35;';c:8535),
(s:'&frac38;';c:8540),
(s:'&frac45;';c:8536),
(s:'&frac56;';c:8538),
(s:'&frac58;';c:8541),
(s:'&frac78;';c:8542),
(s:'&frasl;';c:8260),
(s:'&frown;';c:8994),
(s:'&Fscr;';c:8497),
(s:'&fscr;';c:119995),
(s:'&gacute;';c:501),
(s:'&Gamma;';c:915),
(s:'&gamma;';c:947),
(s:'&Gammad;';c:988),
(s:'&gammad;';c:989),
(s:'&gap;';c:10886),
(s:'&Gbreve;';c:286),
(s:'&gbreve;';c:287),
(s:'&Gcedil;';c:290),
(s:'&Gcirc;';c:284),
(s:'&gcirc;';c:285),
(s:'&Gcy;';c:1043),
(s:'&gcy;';c:1075),
(s:'&Gdot;';c:288),
(s:'&gdot;';c:289),
(s:'&gE;';c:8807),
(s:'&ge;';c:8805),
(s:'&gEl;';c:10892),
(s:'&gel;';c:8923),
(s:'&geq;';c:8805),
(s:'&geqq;';c:8807),
(s:'&geqslant;';c:10878),
(s:'&ges;';c:10878),
(s:'&gescc;';c:10921),
(s:'&gesdot;';c:10880),
(s:'&gesdoto;';c:10882),
(s:'&gesdotol;';c:10884),
(s:'&gesl;';c:650240008923),
(s:'&gesles;';c:10900),
(s:'&Gfr;';c:120074),
(s:'&gfr;';c:120100),
(s:'&Gg;';c:8921),
(s:'&gg;';c:8811),
(s:'&ggg;';c:8921),
(s:'&gimel;';c:8503),
(s:'&GJcy;';c:1027),
(s:'&gjcy;';c:1107),
(s:'&gl;';c:8823),
(s:'&gla;';c:10917),
(s:'&glE;';c:10898),
(s:'&glj;';c:10916),
(s:'&gnap;';c:10890),
(s:'&gnapprox;';c:10890),
(s:'&gnE;';c:8809),
(s:'&gne;';c:10888),
(s:'&gneq;';c:10888),
(s:'&gneqq;';c:8809),
(s:'&gnsim;';c:8935),
(s:'&Gopf;';c:120126),
(s:'&gopf;';c:120152),
(s:'&grave;';c:96),
(s:'&GreaterEqual;';c:8805),
(s:'&GreaterEqualLess;';c:8923),
(s:'&GreaterFullEqual;';c:8807),
(s:'&GreaterGreater;';c:10914),
(s:'&GreaterLess;';c:8823),
(s:'&GreaterSlantEqual;';c:10878),
(s:'&GreaterTilde;';c:8819),
(s:'&Gscr;';c:119970),
(s:'&gscr;';c:8458),
(s:'&gsim;';c:8819),
(s:'&gsime;';c:10894),
(s:'&gsiml;';c:10896),
(s:'&GT;';c:62),
(s:'&GT';c:62),
(s:'&Gt;';c:8811),
(s:'&gt;';c:62),
(s:'&gt';c:62),
(s:'&gtcc;';c:10919),
(s:'&gtcir;';c:10874),
(s:'&gtdot;';c:8919),
(s:'&gtlPar;';c:10645),
(s:'&gtquest;';c:10876),
(s:'&gtrapprox;';c:10886),
(s:'&gtrarr;';c:10616),
(s:'&gtrdot;';c:8919),
(s:'&gtreqless;';c:8923),
(s:'&gtreqqless;';c:10892),
(s:'&gtrless;';c:8823),
(s:'&gtrsim;';c:8819),
(s:'&gvertneqq;';c:650240008809),
(s:'&gvnE;';c:650240008809),
(s:'&Hacek;';c:711),
(s:'&hairsp;';c:8202),
(s:'&half;';c:189),
(s:'&hamilt;';c:8459),
(s:'&HARDcy;';c:1066),
(s:'&hardcy;';c:1098),
(s:'&hArr;';c:8660),
(s:'&harr;';c:8596),
(s:'&harrcir;';c:10568),
(s:'&harrw;';c:8621),
(s:'&Hat;';c:94),
(s:'&hbar;';c:8463),
(s:'&Hcirc;';c:292),
(s:'&hcirc;';c:293),
(s:'&hearts;';c:9829),
(s:'&heartsuit;';c:9829),
(s:'&hellip;';c:8230),
(s:'&hercon;';c:8889),
(s:'&Hfr;';c:8460),
(s:'&hfr;';c:120101),
(s:'&HilbertSpace;';c:8459),
(s:'&hksearow;';c:10533),
(s:'&hkswarow;';c:10534),
(s:'&hoarr;';c:8703),
(s:'&homtht;';c:8763),
(s:'&hookleftarrow;';c:8617),
(s:'&hookrightarrow;';c:8618),
(s:'&Hopf;';c:8461),
(s:'&hopf;';c:120153),
(s:'&horbar;';c:8213),
(s:'&HorizontalLine;';c:9472),
(s:'&Hscr;';c:8459),
(s:'&hscr;';c:119997),
(s:'&hslash;';c:8463),
(s:'&Hstrok;';c:294),
(s:'&hstrok;';c:295),
(s:'&HumpDownHump;';c:8782),
(s:'&HumpEqual;';c:8783),
(s:'&hybull;';c:8259),
(s:'&hyphen;';c:8208),
(s:'&Iacute;';c:205),
(s:'&Iacute';c:205),
(s:'&iacute;';c:237),
(s:'&iacute';c:237),
(s:'&ic;';c:8291),
(s:'&Icirc;';c:206),
(s:'&Icirc';c:206),
(s:'&icirc;';c:238),
(s:'&icirc';c:238),
(s:'&Icy;';c:1048),
(s:'&icy;';c:1080),
(s:'&Idot;';c:304),
(s:'&IEcy;';c:1045),
(s:'&iecy;';c:1077),
(s:'&iexcl;';c:161),
(s:'&iexcl';c:161),
(s:'&iff;';c:8660),
(s:'&Ifr;';c:8465),
(s:'&ifr;';c:120102),
(s:'&Igrave;';c:204),
(s:'&Igrave';c:204),
(s:'&igrave;';c:236),
(s:'&igrave';c:236),
(s:'&ii;';c:8520),
(s:'&iiiint;';c:10764),
(s:'&iiint;';c:8749),
(s:'&iinfin;';c:10716),
(s:'&iiota;';c:8489),
(s:'&IJlig;';c:306),
(s:'&ijlig;';c:307),
(s:'&Im;';c:8465),
(s:'&Imacr;';c:298),
(s:'&imacr;';c:299),
(s:'&image;';c:8465),
(s:'&ImaginaryI;';c:8520),
(s:'&imagline;';c:8464),
(s:'&imagpart;';c:8465),
(s:'&imath;';c:305),
(s:'&imof;';c:8887),
(s:'&imped;';c:437),
(s:'&Implies;';c:8658),
(s:'&in;';c:8712),
(s:'&incare;';c:8453),
(s:'&infin;';c:8734),
(s:'&infintie;';c:10717),
(s:'&inodot;';c:305),
(s:'&Int;';c:8748),
(s:'&int;';c:8747),
(s:'&intcal;';c:8890),
(s:'&integers;';c:8484),
(s:'&Integral;';c:8747),
(s:'&intercal;';c:8890),
(s:'&Intersection;';c:8898),
(s:'&intlarhk;';c:10775),
(s:'&intprod;';c:10812),
(s:'&InvisibleComma;';c:8291),
(s:'&InvisibleTimes;';c:8290),
(s:'&IOcy;';c:1025),
(s:'&iocy;';c:1105),
(s:'&Iogon;';c:302),
(s:'&iogon;';c:303),
(s:'&Iopf;';c:120128),
(s:'&iopf;';c:120154),
(s:'&Iota;';c:921),
(s:'&iota;';c:953),
(s:'&iprod;';c:10812),
(s:'&iquest;';c:191),
(s:'&iquest';c:191),
(s:'&Iscr;';c:8464),
(s:'&iscr;';c:119998),
(s:'&isin;';c:8712),
(s:'&isindot;';c:8949),
(s:'&isinE;';c:8953),
(s:'&isins;';c:8948),
(s:'&isinsv;';c:8947),
(s:'&isinv;';c:8712),
(s:'&it;';c:8290),
(s:'&Itilde;';c:296),
(s:'&itilde;';c:297),
(s:'&Iukcy;';c:1030),
(s:'&iukcy;';c:1110),
(s:'&Iuml;';c:207),
(s:'&Iuml';c:207),
(s:'&iuml;';c:239),
(s:'&iuml';c:239),
(s:'&Jcirc;';c:308),
(s:'&jcirc;';c:309),
(s:'&Jcy;';c:1049),
(s:'&jcy;';c:1081),
(s:'&Jfr;';c:120077),
(s:'&jfr;';c:120103),
(s:'&jmath;';c:567),
(s:'&Jopf;';c:120129),
(s:'&jopf;';c:120155),
(s:'&Jscr;';c:119973),
(s:'&jscr;';c:119999),
(s:'&Jsercy;';c:1032),
(s:'&jsercy;';c:1112),
(s:'&Jukcy;';c:1028),
(s:'&jukcy;';c:1108),
(s:'&Kappa;';c:922),
(s:'&kappa;';c:954),
(s:'&kappav;';c:1008),
(s:'&Kcedil;';c:310),
(s:'&kcedil;';c:311),
(s:'&Kcy;';c:1050),
(s:'&kcy;';c:1082),
(s:'&Kfr;';c:120078),
(s:'&kfr;';c:120104),
(s:'&kgreen;';c:312),
(s:'&KHcy;';c:1061),
(s:'&khcy;';c:1093),
(s:'&KJcy;';c:1036),
(s:'&kjcy;';c:1116),
(s:'&Kopf;';c:120130),
(s:'&kopf;';c:120156),
(s:'&Kscr;';c:119974),
(s:'&kscr;';c:120000),
(s:'&lAarr;';c:8666),
(s:'&Lacute;';c:313),
(s:'&lacute;';c:314),
(s:'&laemptyv;';c:10676),
(s:'&lagran;';c:8466),
(s:'&Lambda;';c:923),
(s:'&lambda;';c:955),
(s:'&Lang;';c:10218),
(s:'&lang;';c:10216),
(s:'&langd;';c:10641),
(s:'&langle;';c:10216),
(s:'&lap;';c:10885),
(s:'&Laplacetrf;';c:8466),
(s:'&laquo;';c:171),
(s:'&laquo';c:171),
(s:'&Larr;';c:8606),
(s:'&lArr;';c:8656),
(s:'&larr;';c:8592),
(s:'&larrb;';c:8676),
(s:'&larrbfs;';c:10527),
(s:'&larrfs;';c:10525),
(s:'&larrhk;';c:8617),
(s:'&larrlp;';c:8619),
(s:'&larrpl;';c:10553),
(s:'&larrsim;';c:10611),
(s:'&larrtl;';c:8610),
(s:'&lat;';c:10923),
(s:'&lAtail;';c:10523),
(s:'&latail;';c:10521),
(s:'&late;';c:10925),
(s:'&lates;';c:650240010925),
(s:'&lBarr;';c:10510),
(s:'&lbarr;';c:10508),
(s:'&lbbrk;';c:10098),
(s:'&lbrace;';c:123),
(s:'&lbrack;';c:91),
(s:'&lbrke;';c:10635),
(s:'&lbrksld;';c:10639),
(s:'&lbrkslu;';c:10637),
(s:'&Lcaron;';c:317),
(s:'&lcaron;';c:318),
(s:'&Lcedil;';c:315),
(s:'&lcedil;';c:316),
(s:'&lceil;';c:8968),
(s:'&lcub;';c:123),
(s:'&Lcy;';c:1051),
(s:'&lcy;';c:1083),
(s:'&ldca;';c:10550),
(s:'&ldquo;';c:8220),
(s:'&ldquor;';c:8222),
(s:'&ldrdhar;';c:10599),
(s:'&ldrushar;';c:10571),
(s:'&ldsh;';c:8626),
(s:'&lE;';c:8806),
(s:'&le;';c:8804),
(s:'&LeftAngleBracket;';c:10216),
(s:'&LeftArrow;';c:8592),
(s:'&Leftarrow;';c:8656),
(s:'&leftarrow;';c:8592),
(s:'&LeftArrowBar;';c:8676),
(s:'&LeftArrowRightArrow;';c:8646),
(s:'&leftarrowtail;';c:8610),
(s:'&LeftCeiling;';c:8968),
(s:'&LeftDoubleBracket;';c:10214),
(s:'&LeftDownTeeVector;';c:10593),
(s:'&LeftDownVector;';c:8643),
(s:'&LeftDownVectorBar;';c:10585),
(s:'&LeftFloor;';c:8970),
(s:'&leftharpoondown;';c:8637),
(s:'&leftharpoonup;';c:8636),
(s:'&leftleftarrows;';c:8647),
(s:'&LeftRightArrow;';c:8596),
(s:'&Leftrightarrow;';c:8660),
(s:'&leftrightarrow;';c:8596),
(s:'&leftrightarrows;';c:8646),
(s:'&leftrightharpoons;';c:8651),
(s:'&leftrightsquigarrow;';c:8621),
(s:'&LeftRightVector;';c:10574),
(s:'&LeftTee;';c:8867),
(s:'&LeftTeeArrow;';c:8612),
(s:'&LeftTeeVector;';c:10586),
(s:'&leftthreetimes;';c:8907),
(s:'&LeftTriangle;';c:8882),
(s:'&LeftTriangleBar;';c:10703),
(s:'&LeftTriangleEqual;';c:8884),
(s:'&LeftUpDownVector;';c:10577),
(s:'&LeftUpTeeVector;';c:10592),
(s:'&LeftUpVector;';c:8639),
(s:'&LeftUpVectorBar;';c:10584),
(s:'&LeftVector;';c:8636),
(s:'&LeftVectorBar;';c:10578),
(s:'&lEg;';c:10891),
(s:'&leg;';c:8922),
(s:'&leq;';c:8804),
(s:'&leqq;';c:8806),
(s:'&leqslant;';c:10877),
(s:'&les;';c:10877),
(s:'&lescc;';c:10920),
(s:'&lesdot;';c:10879),
(s:'&lesdoto;';c:10881),
(s:'&lesdotor;';c:10883),
(s:'&lesg;';c:650240008922),
(s:'&lesges;';c:10899),
(s:'&lessapprox;';c:10885),
(s:'&lessdot;';c:8918),
(s:'&lesseqgtr;';c:8922),
(s:'&lesseqqgtr;';c:10891),
(s:'&LessEqualGreater;';c:8922),
(s:'&LessFullEqual;';c:8806),
(s:'&LessGreater;';c:8822),
(s:'&lessgtr;';c:8822),
(s:'&LessLess;';c:10913),
(s:'&lesssim;';c:8818),
(s:'&LessSlantEqual;';c:10877),
(s:'&LessTilde;';c:8818),
(s:'&lfisht;';c:10620),
(s:'&lfloor;';c:8970),
(s:'&Lfr;';c:120079),
(s:'&lfr;';c:120105),
(s:'&lg;';c:8822),
(s:'&lgE;';c:10897),
(s:'&lHar;';c:10594),
(s:'&lhard;';c:8637),
(s:'&lharu;';c:8636),
(s:'&lharul;';c:10602),
(s:'&lhblk;';c:9604),
(s:'&LJcy;';c:1033),
(s:'&ljcy;';c:1113),
(s:'&Ll;';c:8920),
(s:'&ll;';c:8810),
(s:'&llarr;';c:8647),
(s:'&llcorner;';c:8990),
(s:'&Lleftarrow;';c:8666),
(s:'&llhard;';c:10603),
(s:'&lltri;';c:9722),
(s:'&Lmidot;';c:319),
(s:'&lmidot;';c:320),
(s:'&lmoust;';c:9136),
(s:'&lmoustache;';c:9136),
(s:'&lnap;';c:10889),
(s:'&lnapprox;';c:10889),
(s:'&lnE;';c:8808),
(s:'&lne;';c:10887),
(s:'&lneq;';c:10887),
(s:'&lneqq;';c:8808),
(s:'&lnsim;';c:8934),
(s:'&loang;';c:10220),
(s:'&loarr;';c:8701),
(s:'&lobrk;';c:10214),
(s:'&LongLeftArrow;';c:10229),
(s:'&Longleftarrow;';c:10232),
(s:'&longleftarrow;';c:10229),
(s:'&LongLeftRightArrow;';c:10231),
(s:'&Longleftrightarrow;';c:10234),
(s:'&longleftrightarrow;';c:10231),
(s:'&longmapsto;';c:10236),
(s:'&LongRightArrow;';c:10230),
(s:'&Longrightarrow;';c:10233),
(s:'&longrightarrow;';c:10230),
(s:'&looparrowleft;';c:8619),
(s:'&looparrowright;';c:8620),
(s:'&lopar;';c:10629),
(s:'&Lopf;';c:120131),
(s:'&lopf;';c:120157),
(s:'&loplus;';c:10797),
(s:'&lotimes;';c:10804),
(s:'&lowast;';c:8727),
(s:'&lowbar;';c:95),
(s:'&LowerLeftArrow;';c:8601),
(s:'&LowerRightArrow;';c:8600),
(s:'&loz;';c:9674),
(s:'&lozenge;';c:9674),
(s:'&lozf;';c:10731),
(s:'&lpar;';c:40),
(s:'&lparlt;';c:10643),
(s:'&lrarr;';c:8646),
(s:'&lrcorner;';c:8991),
(s:'&lrhar;';c:8651),
(s:'&lrhard;';c:10605),
(s:'&lrm;';c:8206),
(s:'&lrtri;';c:8895),
(s:'&lsaquo;';c:8249),
(s:'&Lscr;';c:8466),
(s:'&lscr;';c:120001),
(s:'&Lsh;';c:8624),
(s:'&lsh;';c:8624),
(s:'&lsim;';c:8818),
(s:'&lsime;';c:10893),
(s:'&lsimg;';c:10895),
(s:'&lsqb;';c:91),
(s:'&lsquo;';c:8216),
(s:'&lsquor;';c:8218),
(s:'&Lstrok;';c:321),
(s:'&lstrok;';c:322),
(s:'&LT;';c:60),
(s:'&LT';c:60),
(s:'&Lt;';c:8810),
(s:'&lt;';c:60),
(s:'&lt';c:60),
(s:'&ltcc;';c:10918),
(s:'&ltcir;';c:10873),
(s:'&ltdot;';c:8918),
(s:'&lthree;';c:8907),
(s:'&ltimes;';c:8905),
(s:'&ltlarr;';c:10614),
(s:'&ltquest;';c:10875),
(s:'&ltri;';c:9667),
(s:'&ltrie;';c:8884),
(s:'&ltrif;';c:9666),
(s:'&ltrPar;';c:10646),
(s:'&lurdshar;';c:10570),
(s:'&luruhar;';c:10598),
(s:'&lvertneqq;';c:650240008808),
(s:'&lvnE;';c:650240008808),
(s:'&macr;';c:175),
(s:'&macr';c:175),
(s:'&male;';c:9794),
(s:'&malt;';c:10016),
(s:'&maltese;';c:10016),
(s:'&Map;';c:10501),
(s:'&map;';c:8614),
(s:'&mapsto;';c:8614),
(s:'&mapstodown;';c:8615),
(s:'&mapstoleft;';c:8612),
(s:'&mapstoup;';c:8613),
(s:'&marker;';c:9646),
(s:'&mcomma;';c:10793),
(s:'&Mcy;';c:1052),
(s:'&mcy;';c:1084),
(s:'&mdash;';c:8212),
(s:'&mDDot;';c:8762),
(s:'&measuredangle;';c:8737),
(s:'&MediumSpace;';c:8287),
(s:'&Mellintrf;';c:8499),
(s:'&Mfr;';c:120080),
(s:'&mfr;';c:120106),
(s:'&mho;';c:8487),
(s:'&micro;';c:181),
(s:'&micro';c:181),
(s:'&mid;';c:8739),
(s:'&midast;';c:42),
(s:'&midcir;';c:10992),
(s:'&middot;';c:183),
(s:'&middot';c:183),
(s:'&minus;';c:8722),
(s:'&minusb;';c:8863),
(s:'&minusd;';c:8760),
(s:'&minusdu;';c:10794),
(s:'&MinusPlus;';c:8723),
(s:'&mlcp;';c:10971),
(s:'&mldr;';c:8230),
(s:'&mnplus;';c:8723),
(s:'&models;';c:8871),
(s:'&Mopf;';c:120132),
(s:'&mopf;';c:120158),
(s:'&mp;';c:8723),
(s:'&Mscr;';c:8499),
(s:'&mscr;';c:120002),
(s:'&mstpos;';c:8766),
(s:'&Mu;';c:924),
(s:'&mu;';c:956),
(s:'&multimap;';c:8888),
(s:'&mumap;';c:8888),
(s:'&nabla;';c:8711),
(s:'&Nacute;';c:323),
(s:'&nacute;';c:324),
(s:'&nang;';c:84020008736),
(s:'&nap;';c:8777),
(s:'&napE;';c:8240010864),
(s:'&napid;';c:8240008779),
(s:'&napos;';c:329),
(s:'&napprox;';c:8777),
(s:'&natur;';c:9838),
(s:'&natural;';c:9838),
(s:'&naturals;';c:8469),
(s:'&nbsp;';c:160),
(s:'&nbsp';c:160),
(s:'&nbump;';c:8240008782),
(s:'&nbumpe;';c:8240008783),
(s:'&ncap;';c:10819),
(s:'&Ncaron;';c:327),
(s:'&ncaron;';c:328),
(s:'&Ncedil;';c:325),
(s:'&ncedil;';c:326),
(s:'&ncong;';c:8775),
(s:'&ncongdot;';c:8240010861),
(s:'&ncup;';c:10818),
(s:'&Ncy;';c:1053),
(s:'&ncy;';c:1085),
(s:'&ndash;';c:8211),
(s:'&ne;';c:8800),
(s:'&nearhk;';c:10532),
(s:'&neArr;';c:8663),
(s:'&nearr;';c:8599),
(s:'&nearrow;';c:8599),
(s:'&nedot;';c:8240008784),
(s:'&NegativeMediumSpace;';c:8203),
(s:'&NegativeThickSpace;';c:8203),
(s:'&NegativeThinSpace;';c:8203),
(s:'&NegativeVeryThinSpace;';c:8203),
(s:'&nequiv;';c:8802),
(s:'&nesear;';c:10536),
(s:'&nesim;';c:8240008770),
(s:'&NestedGreaterGreater;';c:8811),
(s:'&NestedLessLess;';c:8810),
(s:'&NewLine;';c:10),
(s:'&nexist;';c:8708),
(s:'&nexists;';c:8708),
(s:'&Nfr;';c:120081),
(s:'&nfr;';c:120107),
(s:'&ngE;';c:8240008807),
(s:'&nge;';c:8817),
(s:'&ngeq;';c:8817),
(s:'&ngeqq;';c:8240008807),
(s:'&ngeqslant;';c:8240010878),
(s:'&nges;';c:8240010878),
(s:'&nGg;';c:8240008921),
(s:'&ngsim;';c:8821),
(s:'&nGt;';c:84020008811),
(s:'&ngt;';c:8815),
(s:'&ngtr;';c:8815),
(s:'&nGtv;';c:8240008811),
(s:'&nhArr;';c:8654),
(s:'&nharr;';c:8622),
(s:'&nhpar;';c:10994),
(s:'&ni;';c:8715),
(s:'&nis;';c:8956),
(s:'&nisd;';c:8954),
(s:'&niv;';c:8715),
(s:'&NJcy;';c:1034),
(s:'&njcy;';c:1114),
(s:'&nlArr;';c:8653),
(s:'&nlarr;';c:8602),
(s:'&nldr;';c:8229),
(s:'&nlE;';c:8240008806),
(s:'&nle;';c:8816),
(s:'&nLeftarrow;';c:8653),
(s:'&nleftarrow;';c:8602),
(s:'&nLeftrightarrow;';c:8654),
(s:'&nleftrightarrow;';c:8622),
(s:'&nleq;';c:8816),
(s:'&nleqq;';c:8240008806),
(s:'&nleqslant;';c:8240010877),
(s:'&nles;';c:8240010877),
(s:'&nless;';c:8814),
(s:'&nLl;';c:8240008920),
(s:'&nlsim;';c:8820),
(s:'&nLt;';c:84020008810),
(s:'&nlt;';c:8814),
(s:'&nltri;';c:8938),
(s:'&nltrie;';c:8940),
(s:'&nLtv;';c:8240008810),
(s:'&nmid;';c:8740),
(s:'&NoBreak;';c:8288),
(s:'&NonBreakingSpace;';c:160),
(s:'&Nopf;';c:8469),
(s:'&nopf;';c:120159),
(s:'&Not;';c:10988),
(s:'&not;';c:172),
(s:'&not';c:172),
(s:'&NotCongruent;';c:8802),
(s:'&NotCupCap;';c:8813),
(s:'&NotDoubleVerticalBar;';c:8742),
(s:'&NotElement;';c:8713),
(s:'&NotEqual;';c:8800),
(s:'&NotEqualTilde;';c:8240008770),
(s:'&NotExists;';c:8708),
(s:'&NotGreater;';c:8815),
(s:'&NotGreaterEqual;';c:8817),
(s:'&NotGreaterFullEqual;';c:8240008807),
(s:'&NotGreaterGreater;';c:8240008811),
(s:'&NotGreaterLess;';c:8825),
(s:'&NotGreaterSlantEqual;';c:8240010878),
(s:'&NotGreaterTilde;';c:8821),
(s:'&NotHumpDownHump;';c:8240008782),
(s:'&NotHumpEqual;';c:8240008783),
(s:'&notin;';c:8713),
(s:'&notindot;';c:8240008949),
(s:'&notinE;';c:8240008953),
(s:'&notinva;';c:8713),
(s:'&notinvb;';c:8951),
(s:'&notinvc;';c:8950),
(s:'&NotLeftTriangle;';c:8938),
(s:'&NotLeftTriangleBar;';c:8240010703),
(s:'&NotLeftTriangleEqual;';c:8940),
(s:'&NotLess;';c:8814),
(s:'&NotLessEqual;';c:8816),
(s:'&NotLessGreater;';c:8824),
(s:'&NotLessLess;';c:8240008810),
(s:'&NotLessSlantEqual;';c:8240010877),
(s:'&NotLessTilde;';c:8820),
(s:'&NotNestedGreaterGreater;';c:8240010914),
(s:'&NotNestedLessLess;';c:8240010913),
(s:'&notni;';c:8716),
(s:'&notniva;';c:8716),
(s:'&notnivb;';c:8958),
(s:'&notnivc;';c:8957),
(s:'&NotPrecedes;';c:8832),
(s:'&NotPrecedesEqual;';c:8240010927),
(s:'&NotPrecedesSlantEqual;';c:8928),
(s:'&NotReverseElement;';c:8716),
(s:'&NotRightTriangle;';c:8939),
(s:'&NotRightTriangleBar;';c:8240010704),
(s:'&NotRightTriangleEqual;';c:8941),
(s:'&NotSquareSubset;';c:8240008847),
(s:'&NotSquareSubsetEqual;';c:8930),
(s:'&NotSquareSuperset;';c:8240008848),
(s:'&NotSquareSupersetEqual;';c:8931),
(s:'&NotSubset;';c:84020008834),
(s:'&NotSubsetEqual;';c:8840),
(s:'&NotSucceeds;';c:8833),
(s:'&NotSucceedsEqual;';c:8240010928),
(s:'&NotSucceedsSlantEqual;';c:8929),
(s:'&NotSucceedsTilde;';c:8240008831),
(s:'&NotSuperset;';c:84020008835),
(s:'&NotSupersetEqual;';c:8841),
(s:'&NotTilde;';c:8769),
(s:'&NotTildeEqual;';c:8772),
(s:'&NotTildeFullEqual;';c:8775),
(s:'&NotTildeTilde;';c:8777),
(s:'&NotVerticalBar;';c:8740),
(s:'&npar;';c:8742),
(s:'&nparallel;';c:8742),
(s:'&nparsl;';c:84210011005),
(s:'&npart;';c:8240008706),
(s:'&npolint;';c:10772),
(s:'&npr;';c:8832),
(s:'&nprcue;';c:8928),
(s:'&npre;';c:8240010927),
(s:'&nprec;';c:8832),
(s:'&npreceq;';c:8240010927),
(s:'&nrArr;';c:8655),
(s:'&nrarr;';c:8603),
(s:'&nrarrc;';c:8240010547),
(s:'&nrarrw;';c:8240008605),
(s:'&nRightarrow;';c:8655),
(s:'&nrightarrow;';c:8603),
(s:'&nrtri;';c:8939),
(s:'&nrtrie;';c:8941),
(s:'&nsc;';c:8833),
(s:'&nsccue;';c:8929),
(s:'&nsce;';c:8240010928),
(s:'&Nscr;';c:119977),
(s:'&nscr;';c:120003),
(s:'&nshortmid;';c:8740),
(s:'&nshortparallel;';c:8742),
(s:'&nsim;';c:8769),
(s:'&nsime;';c:8772),
(s:'&nsimeq;';c:8772),
(s:'&nsmid;';c:8740),
(s:'&nspar;';c:8742),
(s:'&nsqsube;';c:8930),
(s:'&nsqsupe;';c:8931),
(s:'&nsub;';c:8836),
(s:'&nsubE;';c:8240010949),
(s:'&nsube;';c:8840),
(s:'&nsubset;';c:84020008834),
(s:'&nsubseteq;';c:8840),
(s:'&nsubseteqq;';c:8240010949),
(s:'&nsucc;';c:8833),
(s:'&nsucceq;';c:8240010928),
(s:'&nsup;';c:8837),
(s:'&nsupE;';c:8240010950),
(s:'&nsupe;';c:8841),
(s:'&nsupset;';c:84020008835),
(s:'&nsupseteq;';c:8841),
(s:'&nsupseteqq;';c:8240010950),
(s:'&ntgl;';c:8825),
(s:'&Ntilde;';c:209),
(s:'&Ntilde';c:209),
(s:'&ntilde;';c:241),
(s:'&ntilde';c:241),
(s:'&ntlg;';c:8824),
(s:'&ntriangleleft;';c:8938),
(s:'&ntrianglelefteq;';c:8940),
(s:'&ntriangleright;';c:8939),
(s:'&ntrianglerighteq;';c:8941),
(s:'&Nu;';c:925),
(s:'&nu;';c:957),
(s:'&num;';c:35),
(s:'&numero;';c:8470),
(s:'&numsp;';c:8199),
(s:'&nvap;';c:84020008781),
(s:'&nVDash;';c:8879),
(s:'&nVdash;';c:8878),
(s:'&nvDash;';c:8877),
(s:'&nvdash;';c:8876),
(s:'&nvge;';c:84020008805),
(s:'&nvgt;';c:84020000062),
(s:'&nvHarr;';c:10500),
(s:'&nvinfin;';c:10718),
(s:'&nvlArr;';c:10498),
(s:'&nvle;';c:84020008804),
(s:'&nvlt;';c:84020000060),
(s:'&nvltrie;';c:84020008884),
(s:'&nvrArr;';c:10499),
(s:'&nvrtrie;';c:84020008885),
(s:'&nvsim;';c:84020008764),
(s:'&nwarhk;';c:10531),
(s:'&nwArr;';c:8662),
(s:'&nwarr;';c:8598),
(s:'&nwarrow;';c:8598),
(s:'&nwnear;';c:10535),
(s:'&Oacute;';c:211),
(s:'&Oacute';c:211),
(s:'&oacute;';c:243),
(s:'&oacute';c:243),
(s:'&oast;';c:8859),
(s:'&ocir;';c:8858),
(s:'&Ocirc;';c:212),
(s:'&Ocirc';c:212),
(s:'&ocirc;';c:244),
(s:'&ocirc';c:244),
(s:'&Ocy;';c:1054),
(s:'&ocy;';c:1086),
(s:'&odash;';c:8861),
(s:'&Odblac;';c:336),
(s:'&odblac;';c:337),
(s:'&odiv;';c:10808),
(s:'&odot;';c:8857),
(s:'&odsold;';c:10684),
(s:'&OElig;';c:338),
(s:'&oelig;';c:339),
(s:'&ofcir;';c:10687),
(s:'&Ofr;';c:120082),
(s:'&ofr;';c:120108),
(s:'&ogon;';c:731),
(s:'&Ograve;';c:210),
(s:'&Ograve';c:210),
(s:'&ograve;';c:242),
(s:'&ograve';c:242),
(s:'&ogt;';c:10689),
(s:'&ohbar;';c:10677),
(s:'&ohm;';c:937),
(s:'&oint;';c:8750),
(s:'&olarr;';c:8634),
(s:'&olcir;';c:10686),
(s:'&olcross;';c:10683),
(s:'&oline;';c:8254),
(s:'&olt;';c:10688),
(s:'&Omacr;';c:332),
(s:'&omacr;';c:333),
(s:'&Omega;';c:937),
(s:'&omega;';c:969),
(s:'&Omicron;';c:927),
(s:'&omicron;';c:959),
(s:'&omid;';c:10678),
(s:'&ominus;';c:8854),
(s:'&Oopf;';c:120134),
(s:'&oopf;';c:120160),
(s:'&opar;';c:10679),
(s:'&OpenCurlyDoubleQuote;';c:8220),
(s:'&OpenCurlyQuote;';c:8216),
(s:'&operp;';c:10681),
(s:'&oplus;';c:8853),
(s:'&Or;';c:10836),
(s:'&or;';c:8744),
(s:'&orarr;';c:8635),
(s:'&ord;';c:10845),
(s:'&order;';c:8500),
(s:'&orderof;';c:8500),
(s:'&ordf;';c:170),
(s:'&ordf';c:170),
(s:'&ordm;';c:186),
(s:'&ordm';c:186),
(s:'&origof;';c:8886),
(s:'&oror;';c:10838),
(s:'&orslope;';c:10839),
(s:'&orv;';c:10843),
(s:'&oS;';c:9416),
(s:'&Oscr;';c:119978),
(s:'&oscr;';c:8500),
(s:'&Oslash;';c:216),
(s:'&Oslash';c:216),
(s:'&oslash;';c:248),
(s:'&oslash';c:248),
(s:'&osol;';c:8856),
(s:'&Otilde;';c:213),
(s:'&Otilde';c:213),
(s:'&otilde;';c:245),
(s:'&otilde';c:245),
(s:'&Otimes;';c:10807),
(s:'&otimes;';c:8855),
(s:'&otimesas;';c:10806),
(s:'&Ouml;';c:214),
(s:'&Ouml';c:214),
(s:'&ouml;';c:246),
(s:'&ouml';c:246),
(s:'&ovbar;';c:9021),
(s:'&OverBar;';c:8254),
(s:'&OverBrace;';c:9182),
(s:'&OverBracket;';c:9140),
(s:'&OverParenthesis;';c:9180),
(s:'&par;';c:8741),
(s:'&para;';c:182),
(s:'&para';c:182),
(s:'&parallel;';c:8741),
(s:'&parsim;';c:10995),
(s:'&parsl;';c:11005),
(s:'&part;';c:8706),
(s:'&PartialD;';c:8706),
(s:'&Pcy;';c:1055),
(s:'&pcy;';c:1087),
(s:'&percnt;';c:37),
(s:'&period;';c:46),
(s:'&permil;';c:8240),
(s:'&perp;';c:8869),
(s:'&pertenk;';c:8241),
(s:'&Pfr;';c:120083),
(s:'&pfr;';c:120109),
(s:'&Phi;';c:934),
(s:'&phi;';c:966),
(s:'&phiv;';c:981),
(s:'&phmmat;';c:8499),
(s:'&phone;';c:9742),
(s:'&Pi;';c:928),
(s:'&pi;';c:960),
(s:'&pitchfork;';c:8916),
(s:'&piv;';c:982),
(s:'&planck;';c:8463),
(s:'&planckh;';c:8462),
(s:'&plankv;';c:8463),
(s:'&plus;';c:43),
(s:'&plusacir;';c:10787),
(s:'&plusb;';c:8862),
(s:'&pluscir;';c:10786),
(s:'&plusdo;';c:8724),
(s:'&plusdu;';c:10789),
(s:'&pluse;';c:10866),
(s:'&PlusMinus;';c:177),
(s:'&plusmn;';c:177),
(s:'&plusmn';c:177),
(s:'&plussim;';c:10790),
(s:'&plustwo;';c:10791),
(s:'&pm;';c:177),
(s:'&Poincareplane;';c:8460),
(s:'&pointint;';c:10773),
(s:'&Popf;';c:8473),
(s:'&popf;';c:120161),
(s:'&pound;';c:163),
(s:'&pound';c:163),
(s:'&Pr;';c:10939),
(s:'&pr;';c:8826),
(s:'&prap;';c:10935),
(s:'&prcue;';c:8828),
(s:'&prE;';c:10931),
(s:'&pre;';c:10927),
(s:'&prec;';c:8826),
(s:'&precapprox;';c:10935),
(s:'&preccurlyeq;';c:8828),
(s:'&Precedes;';c:8826),
(s:'&PrecedesEqual;';c:10927),
(s:'&PrecedesSlantEqual;';c:8828),
(s:'&PrecedesTilde;';c:8830),
(s:'&preceq;';c:10927),
(s:'&precnapprox;';c:10937),
(s:'&precneqq;';c:10933),
(s:'&precnsim;';c:8936),
(s:'&precsim;';c:8830),
(s:'&Prime;';c:8243),
(s:'&prime;';c:8242),
(s:'&primes;';c:8473),
(s:'&prnap;';c:10937),
(s:'&prnE;';c:10933),
(s:'&prnsim;';c:8936),
(s:'&prod;';c:8719),
(s:'&Product;';c:8719),
(s:'&profalar;';c:9006),
(s:'&profline;';c:8978),
(s:'&profsurf;';c:8979),
(s:'&prop;';c:8733),
(s:'&Proportion;';c:8759),
(s:'&Proportional;';c:8733),
(s:'&propto;';c:8733),
(s:'&prsim;';c:8830),
(s:'&prurel;';c:8880),
(s:'&Pscr;';c:119979),
(s:'&pscr;';c:120005),
(s:'&Psi;';c:936),
(s:'&psi;';c:968),
(s:'&puncsp;';c:8200),
(s:'&Qfr;';c:120084),
(s:'&qfr;';c:120110),
(s:'&qint;';c:10764),
(s:'&Qopf;';c:8474),
(s:'&qopf;';c:120162),
(s:'&qprime;';c:8279),
(s:'&Qscr;';c:119980),
(s:'&qscr;';c:120006),
(s:'&quaternions;';c:8461),
(s:'&quatint;';c:10774),
(s:'&quest;';c:63),
(s:'&questeq;';c:8799),
(s:'&QUOT;';c:34),
(s:'&QUOT';c:34),
(s:'&quot;';c:34),
(s:'&quot';c:34),
(s:'&rAarr;';c:8667),
(s:'&race;';c:8170008765),
(s:'&Racute;';c:340),
(s:'&racute;';c:341),
(s:'&radic;';c:8730),
(s:'&raemptyv;';c:10675),
(s:'&Rang;';c:10219),
(s:'&rang;';c:10217),
(s:'&rangd;';c:10642),
(s:'&range;';c:10661),
(s:'&rangle;';c:10217),
(s:'&raquo;';c:187),
(s:'&raquo';c:187),
(s:'&Rarr;';c:8608),
(s:'&rArr;';c:8658),
(s:'&rarr;';c:8594),
(s:'&rarrap;';c:10613),
(s:'&rarrb;';c:8677),
(s:'&rarrbfs;';c:10528),
(s:'&rarrc;';c:10547),
(s:'&rarrfs;';c:10526),
(s:'&rarrhk;';c:8618),
(s:'&rarrlp;';c:8620),
(s:'&rarrpl;';c:10565),
(s:'&rarrsim;';c:10612),
(s:'&Rarrtl;';c:10518),
(s:'&rarrtl;';c:8611),
(s:'&rarrw;';c:8605),
(s:'&rAtail;';c:10524),
(s:'&ratail;';c:10522),
(s:'&ratio;';c:8758),
(s:'&rationals;';c:8474),
(s:'&RBarr;';c:10512),
(s:'&rBarr;';c:10511),
(s:'&rbarr;';c:10509),
(s:'&rbbrk;';c:10099),
(s:'&rbrace;';c:125),
(s:'&rbrack;';c:93),
(s:'&rbrke;';c:10636),
(s:'&rbrksld;';c:10638),
(s:'&rbrkslu;';c:10640),
(s:'&Rcaron;';c:344),
(s:'&rcaron;';c:345),
(s:'&Rcedil;';c:342),
(s:'&rcedil;';c:343),
(s:'&rceil;';c:8969),
(s:'&rcub;';c:125),
(s:'&Rcy;';c:1056),
(s:'&rcy;';c:1088),
(s:'&rdca;';c:10551),
(s:'&rdldhar;';c:10601),
(s:'&rdquo;';c:8221),
(s:'&rdquor;';c:8221),
(s:'&rdsh;';c:8627),
(s:'&Re;';c:8476),
(s:'&real;';c:8476),
(s:'&realine;';c:8475),
(s:'&realpart;';c:8476),
(s:'&reals;';c:8477),
(s:'&rect;';c:9645),
(s:'&REG;';c:174),
(s:'&REG';c:174),
(s:'&reg;';c:174),
(s:'&reg';c:174),
(s:'&ReverseElement;';c:8715),
(s:'&ReverseEquilibrium;';c:8651),
(s:'&ReverseUpEquilibrium;';c:10607),
(s:'&rfisht;';c:10621),
(s:'&rfloor;';c:8971),
(s:'&Rfr;';c:8476),
(s:'&rfr;';c:120111),
(s:'&rHar;';c:10596),
(s:'&rhard;';c:8641),
(s:'&rharu;';c:8640),
(s:'&rharul;';c:10604),
(s:'&Rho;';c:929),
(s:'&rho;';c:961),
(s:'&rhov;';c:1009),
(s:'&RightAngleBracket;';c:10217),
(s:'&RightArrow;';c:8594),
(s:'&Rightarrow;';c:8658),
(s:'&rightarrow;';c:8594),
(s:'&RightArrowBar;';c:8677),
(s:'&RightArrowLeftArrow;';c:8644),
(s:'&rightarrowtail;';c:8611),
(s:'&RightCeiling;';c:8969),
(s:'&RightDoubleBracket;';c:10215),
(s:'&RightDownTeeVector;';c:10589),
(s:'&RightDownVector;';c:8642),
(s:'&RightDownVectorBar;';c:10581),
(s:'&RightFloor;';c:8971),
(s:'&rightharpoondown;';c:8641),
(s:'&rightharpoonup;';c:8640),
(s:'&rightleftarrows;';c:8644),
(s:'&rightleftharpoons;';c:8652),
(s:'&rightrightarrows;';c:8649),
(s:'&rightsquigarrow;';c:8605),
(s:'&RightTee;';c:8866),
(s:'&RightTeeArrow;';c:8614),
(s:'&RightTeeVector;';c:10587),
(s:'&rightthreetimes;';c:8908),
(s:'&RightTriangle;';c:8883),
(s:'&RightTriangleBar;';c:10704),
(s:'&RightTriangleEqual;';c:8885),
(s:'&RightUpDownVector;';c:10575),
(s:'&RightUpTeeVector;';c:10588),
(s:'&RightUpVector;';c:8638),
(s:'&RightUpVectorBar;';c:10580),
(s:'&RightVector;';c:8640),
(s:'&RightVectorBar;';c:10579),
(s:'&ring;';c:730),
(s:'&risingdotseq;';c:8787),
(s:'&rlarr;';c:8644),
(s:'&rlhar;';c:8652),
(s:'&rlm;';c:8207),
(s:'&rmoust;';c:9137),
(s:'&rmoustache;';c:9137),
(s:'&rnmid;';c:10990),
(s:'&roang;';c:10221),
(s:'&roarr;';c:8702),
(s:'&robrk;';c:10215),
(s:'&ropar;';c:10630),
(s:'&Ropf;';c:8477),
(s:'&ropf;';c:120163),
(s:'&roplus;';c:10798),
(s:'&rotimes;';c:10805),
(s:'&RoundImplies;';c:10608),
(s:'&rpar;';c:41),
(s:'&rpargt;';c:10644),
(s:'&rppolint;';c:10770),
(s:'&rrarr;';c:8649),
(s:'&Rrightarrow;';c:8667),
(s:'&rsaquo;';c:8250),
(s:'&Rscr;';c:8475),
(s:'&rscr;';c:120007),
(s:'&Rsh;';c:8625),
(s:'&rsh;';c:8625),
(s:'&rsqb;';c:93),
(s:'&rsquo;';c:8217),
(s:'&rsquor;';c:8217),
(s:'&rthree;';c:8908),
(s:'&rtimes;';c:8906),
(s:'&rtri;';c:9657),
(s:'&rtrie;';c:8885),
(s:'&rtrif;';c:9656),
(s:'&rtriltri;';c:10702),
(s:'&RuleDelayed;';c:10740),
(s:'&ruluhar;';c:10600),
(s:'&rx;';c:8478),
(s:'&Sacute;';c:346),
(s:'&sacute;';c:347),
(s:'&sbquo;';c:8218),
(s:'&Sc;';c:10940),
(s:'&sc;';c:8827),
(s:'&scap;';c:10936),
(s:'&Scaron;';c:352),
(s:'&scaron;';c:353),
(s:'&sccue;';c:8829),
(s:'&scE;';c:10932),
(s:'&sce;';c:10928),
(s:'&Scedil;';c:350),
(s:'&scedil;';c:351),
(s:'&Scirc;';c:348),
(s:'&scirc;';c:349),
(s:'&scnap;';c:10938),
(s:'&scnE;';c:10934),
(s:'&scnsim;';c:8937),
(s:'&scpolint;';c:10771),
(s:'&scsim;';c:8831),
(s:'&Scy;';c:1057),
(s:'&scy;';c:1089),
(s:'&sdot;';c:8901),
(s:'&sdotb;';c:8865),
(s:'&sdote;';c:10854),
(s:'&searhk;';c:10533),
(s:'&seArr;';c:8664),
(s:'&searr;';c:8600),
(s:'&searrow;';c:8600),
(s:'&sect;';c:167),
(s:'&sect';c:167),
(s:'&semi;';c:59),
(s:'&seswar;';c:10537),
(s:'&setminus;';c:8726),
(s:'&setmn;';c:8726),
(s:'&sext;';c:10038),
(s:'&Sfr;';c:120086),
(s:'&sfr;';c:120112),
(s:'&sfrown;';c:8994),
(s:'&sharp;';c:9839),
(s:'&SHCHcy;';c:1065),
(s:'&shchcy;';c:1097),
(s:'&SHcy;';c:1064),
(s:'&shcy;';c:1096),
(s:'&ShortDownArrow;';c:8595),
(s:'&ShortLeftArrow;';c:8592),
(s:'&shortmid;';c:8739),
(s:'&shortparallel;';c:8741),
(s:'&ShortRightArrow;';c:8594),
(s:'&ShortUpArrow;';c:8593),
(s:'&shy;';c:173),
(s:'&shy';c:173),
(s:'&Sigma;';c:931),
(s:'&sigma;';c:963),
(s:'&sigmaf;';c:962),
(s:'&sigmav;';c:962),
(s:'&sim;';c:8764),
(s:'&simdot;';c:10858),
(s:'&sime;';c:8771),
(s:'&simeq;';c:8771),
(s:'&simg;';c:10910),
(s:'&simgE;';c:10912),
(s:'&siml;';c:10909),
(s:'&simlE;';c:10911),
(s:'&simne;';c:8774),
(s:'&simplus;';c:10788),
(s:'&simrarr;';c:10610),
(s:'&slarr;';c:8592),
(s:'&SmallCircle;';c:8728),
(s:'&smallsetminus;';c:8726),
(s:'&smashp;';c:10803),
(s:'&smeparsl;';c:10724),
(s:'&smid;';c:8739),
(s:'&smile;';c:8995),
(s:'&smt;';c:10922),
(s:'&smte;';c:10924),
(s:'&smtes;';c:650240010924),
(s:'&SOFTcy;';c:1068),
(s:'&softcy;';c:1100),
(s:'&sol;';c:47),
(s:'&solb;';c:10692),
(s:'&solbar;';c:9023),
(s:'&Sopf;';c:120138),
(s:'&sopf;';c:120164),
(s:'&spades;';c:9824),
(s:'&spadesuit;';c:9824),
(s:'&spar;';c:8741),
(s:'&sqcap;';c:8851),
(s:'&sqcaps;';c:650240008851),
(s:'&sqcup;';c:8852),
(s:'&sqcups;';c:650240008852),
(s:'&Sqrt;';c:8730),
(s:'&sqsub;';c:8847),
(s:'&sqsube;';c:8849),
(s:'&sqsubset;';c:8847),
(s:'&sqsubseteq;';c:8849),
(s:'&sqsup;';c:8848),
(s:'&sqsupe;';c:8850),
(s:'&sqsupset;';c:8848),
(s:'&sqsupseteq;';c:8850),
(s:'&squ;';c:9633),
(s:'&Square;';c:9633),
(s:'&square;';c:9633),
(s:'&SquareIntersection;';c:8851),
(s:'&SquareSubset;';c:8847),
(s:'&SquareSubsetEqual;';c:8849),
(s:'&SquareSuperset;';c:8848),
(s:'&SquareSupersetEqual;';c:8850),
(s:'&SquareUnion;';c:8852),
(s:'&squarf;';c:9642),
(s:'&squf;';c:9642),
(s:'&srarr;';c:8594),
(s:'&Sscr;';c:119982),
(s:'&sscr;';c:120008),
(s:'&ssetmn;';c:8726),
(s:'&ssmile;';c:8995),
(s:'&sstarf;';c:8902),
(s:'&Star;';c:8902),
(s:'&star;';c:9734),
(s:'&starf;';c:9733),
(s:'&straightepsilon;';c:1013),
(s:'&straightphi;';c:981),
(s:'&strns;';c:175),
(s:'&Sub;';c:8912),
(s:'&sub;';c:8834),
(s:'&subdot;';c:10941),
(s:'&subE;';c:10949),
(s:'&sube;';c:8838),
(s:'&subedot;';c:10947),
(s:'&submult;';c:10945),
(s:'&subnE;';c:10955),
(s:'&subne;';c:8842),
(s:'&subplus;';c:10943),
(s:'&subrarr;';c:10617),
(s:'&Subset;';c:8912),
(s:'&subset;';c:8834),
(s:'&subseteq;';c:8838),
(s:'&subseteqq;';c:10949),
(s:'&SubsetEqual;';c:8838),
(s:'&subsetneq;';c:8842),
(s:'&subsetneqq;';c:10955),
(s:'&subsim;';c:10951),
(s:'&subsub;';c:10965),
(s:'&subsup;';c:10963),
(s:'&succ;';c:8827),
(s:'&succapprox;';c:10936),
(s:'&succcurlyeq;';c:8829),
(s:'&Succeeds;';c:8827),
(s:'&SucceedsEqual;';c:10928),
(s:'&SucceedsSlantEqual;';c:8829),
(s:'&SucceedsTilde;';c:8831),
(s:'&succeq;';c:10928),
(s:'&succnapprox;';c:10938),
(s:'&succneqq;';c:10934),
(s:'&succnsim;';c:8937),
(s:'&succsim;';c:8831),
(s:'&SuchThat;';c:8715),
(s:'&Sum;';c:8721),
(s:'&sum;';c:8721),
(s:'&sung;';c:9834),
(s:'&Sup;';c:8913),
(s:'&sup;';c:8835),
(s:'&sup1;';c:185),
(s:'&sup1';c:185),
(s:'&sup2;';c:178),
(s:'&sup2';c:178),
(s:'&sup3;';c:179),
(s:'&sup3';c:179),
(s:'&supdot;';c:10942),
(s:'&supdsub;';c:10968),
(s:'&supE;';c:10950),
(s:'&supe;';c:8839),
(s:'&supedot;';c:10948),
(s:'&Superset;';c:8835),
(s:'&SupersetEqual;';c:8839),
(s:'&suphsol;';c:10185),
(s:'&suphsub;';c:10967),
(s:'&suplarr;';c:10619),
(s:'&supmult;';c:10946),
(s:'&supnE;';c:10956),
(s:'&supne;';c:8843),
(s:'&supplus;';c:10944),
(s:'&Supset;';c:8913),
(s:'&supset;';c:8835),
(s:'&supseteq;';c:8839),
(s:'&supseteqq;';c:10950),
(s:'&supsetneq;';c:8843),
(s:'&supsetneqq;';c:10956),
(s:'&supsim;';c:10952),
(s:'&supsub;';c:10964),
(s:'&supsup;';c:10966),
(s:'&swarhk;';c:10534),
(s:'&swArr;';c:8665),
(s:'&swarr;';c:8601),
(s:'&swarrow;';c:8601),
(s:'&swnwar;';c:10538),
(s:'&szlig;';c:223),
(s:'&szlig';c:223),
(s:'&Tab;';c:9),
(s:'&target;';c:8982),
(s:'&Tau;';c:932),
(s:'&tau;';c:964),
(s:'&tbrk;';c:9140),
(s:'&Tcaron;';c:356),
(s:'&tcaron;';c:357),
(s:'&Tcedil;';c:354),
(s:'&tcedil;';c:355),
(s:'&Tcy;';c:1058),
(s:'&tcy;';c:1090),
(s:'&tdot;';c:8411),
(s:'&telrec;';c:8981),
(s:'&Tfr;';c:120087),
(s:'&tfr;';c:120113),
(s:'&there4;';c:8756),
(s:'&Therefore;';c:8756),
(s:'&therefore;';c:8756),
(s:'&Theta;';c:920),
(s:'&theta;';c:952),
(s:'&thetasym;';c:977),
(s:'&thetav;';c:977),
(s:'&thickapprox;';c:8776),
(s:'&thicksim;';c:8764),
(s:'&ThickSpace;';c:82020008287),
(s:'&thinsp;';c:8201),
(s:'&ThinSpace;';c:8201),
(s:'&thkap;';c:8776),
(s:'&thksim;';c:8764),
(s:'&THORN;';c:222),
(s:'&THORN';c:222),
(s:'&thorn;';c:254),
(s:'&thorn';c:254),
(s:'&Tilde;';c:8764),
(s:'&tilde;';c:732),
(s:'&TildeEqual;';c:8771),
(s:'&TildeFullEqual;';c:8773),
(s:'&TildeTilde;';c:8776),
(s:'&times;';c:215),
(s:'&times';c:215),
(s:'&timesb;';c:8864),
(s:'&timesbar;';c:10801),
(s:'&timesd;';c:10800),
(s:'&tint;';c:8749),
(s:'&toea;';c:10536),
(s:'&top;';c:8868),
(s:'&topbot;';c:9014),
(s:'&topcir;';c:10993),
(s:'&Topf;';c:120139),
(s:'&topf;';c:120165),
(s:'&topfork;';c:10970),
(s:'&tosa;';c:10537),
(s:'&tprime;';c:8244),
(s:'&TRADE;';c:8482),
(s:'&trade;';c:8482),
(s:'&triangle;';c:9653),
(s:'&triangledown;';c:9663),
(s:'&triangleleft;';c:9667),
(s:'&trianglelefteq;';c:8884),
(s:'&triangleq;';c:8796),
(s:'&triangleright;';c:9657),
(s:'&trianglerighteq;';c:8885),
(s:'&tridot;';c:9708),
(s:'&trie;';c:8796),
(s:'&triminus;';c:10810),
(s:'&TripleDot;';c:8411),
(s:'&triplus;';c:10809),
(s:'&trisb;';c:10701),
(s:'&tritime;';c:10811),
(s:'&trpezium;';c:9186),
(s:'&Tscr;';c:119983),
(s:'&tscr;';c:120009),
(s:'&TScy;';c:1062),
(s:'&tscy;';c:1094),
(s:'&TSHcy;';c:1035),
(s:'&tshcy;';c:1115),
(s:'&Tstrok;';c:358),
(s:'&tstrok;';c:359),
(s:'&twixt;';c:8812),
(s:'&twoheadleftarrow;';c:8606),
(s:'&twoheadrightarrow;';c:8608),
(s:'&Uacute;';c:218),
(s:'&Uacute';c:218),
(s:'&uacute;';c:250),
(s:'&uacute';c:250),
(s:'&Uarr;';c:8607),
(s:'&uArr;';c:8657),
(s:'&uarr;';c:8593),
(s:'&Uarrocir;';c:10569),
(s:'&Ubrcy;';c:1038),
(s:'&ubrcy;';c:1118),
(s:'&Ubreve;';c:364),
(s:'&ubreve;';c:365),
(s:'&Ucirc;';c:219),
(s:'&Ucirc';c:219),
(s:'&ucirc;';c:251),
(s:'&ucirc';c:251),
(s:'&Ucy;';c:1059),
(s:'&ucy;';c:1091),
(s:'&udarr;';c:8645),
(s:'&Udblac;';c:368),
(s:'&udblac;';c:369),
(s:'&udhar;';c:10606),
(s:'&ufisht;';c:10622),
(s:'&Ufr;';c:120088),
(s:'&ufr;';c:120114),
(s:'&Ugrave;';c:217),
(s:'&Ugrave';c:217),
(s:'&ugrave;';c:249),
(s:'&ugrave';c:249),
(s:'&uHar;';c:10595),
(s:'&uharl;';c:8639),
(s:'&uharr;';c:8638),
(s:'&uhblk;';c:9600),
(s:'&ulcorn;';c:8988),
(s:'&ulcorner;';c:8988),
(s:'&ulcrop;';c:8975),
(s:'&ultri;';c:9720),
(s:'&Umacr;';c:362),
(s:'&umacr;';c:363),
(s:'&uml;';c:168),
(s:'&uml';c:168),
(s:'&UnderBar;';c:95),
(s:'&UnderBrace;';c:9183),
(s:'&UnderBracket;';c:9141),
(s:'&UnderParenthesis;';c:9181),
(s:'&Union;';c:8899),
(s:'&UnionPlus;';c:8846),
(s:'&Uogon;';c:370),
(s:'&uogon;';c:371),
(s:'&Uopf;';c:120140),
(s:'&uopf;';c:120166),
(s:'&UpArrow;';c:8593),
(s:'&Uparrow;';c:8657),
(s:'&uparrow;';c:8593),
(s:'&UpArrowBar;';c:10514),
(s:'&UpArrowDownArrow;';c:8645),
(s:'&UpDownArrow;';c:8597),
(s:'&Updownarrow;';c:8661),
(s:'&updownarrow;';c:8597),
(s:'&UpEquilibrium;';c:10606),
(s:'&upharpoonleft;';c:8639),
(s:'&upharpoonright;';c:8638),
(s:'&uplus;';c:8846),
(s:'&UpperLeftArrow;';c:8598),
(s:'&UpperRightArrow;';c:8599),
(s:'&Upsi;';c:978),
(s:'&upsi;';c:965),
(s:'&upsih;';c:978),
(s:'&Upsilon;';c:933),
(s:'&upsilon;';c:965),
(s:'&UpTee;';c:8869),
(s:'&UpTeeArrow;';c:8613),
(s:'&upuparrows;';c:8648),
(s:'&urcorn;';c:8989),
(s:'&urcorner;';c:8989),
(s:'&urcrop;';c:8974),
(s:'&Uring;';c:366),
(s:'&uring;';c:367),
(s:'&urtri;';c:9721),
(s:'&Uscr;';c:119984),
(s:'&uscr;';c:120010),
(s:'&utdot;';c:8944),
(s:'&Utilde;';c:360),
(s:'&utilde;';c:361),
(s:'&utri;';c:9653),
(s:'&utrif;';c:9652),
(s:'&uuarr;';c:8648),
(s:'&Uuml;';c:220),
(s:'&Uuml';c:220),
(s:'&uuml;';c:252),
(s:'&uuml';c:252),
(s:'&uwangle;';c:10663),
(s:'&vangrt;';c:10652),
(s:'&varepsilon;';c:1013),
(s:'&varkappa;';c:1008),
(s:'&varnothing;';c:8709),
(s:'&varphi;';c:981),
(s:'&varpi;';c:982),
(s:'&varpropto;';c:8733),
(s:'&vArr;';c:8661),
(s:'&varr;';c:8597),
(s:'&varrho;';c:1009),
(s:'&varsigma;';c:962),
(s:'&varsubsetneq;';c:650240008842),
(s:'&varsubsetneqq;';c:650240010955),
(s:'&varsupsetneq;';c:650240008843),
(s:'&varsupsetneqq;';c:650240010956),
(s:'&vartheta;';c:977),
(s:'&vartriangleleft;';c:8882),
(s:'&vartriangleright;';c:8883),
(s:'&Vbar;';c:10987),
(s:'&vBar;';c:10984),
(s:'&vBarv;';c:10985),
(s:'&Vcy;';c:1042),
(s:'&vcy;';c:1074),
(s:'&VDash;';c:8875),
(s:'&Vdash;';c:8873),
(s:'&vDash;';c:8872),
(s:'&vdash;';c:8866),
(s:'&Vdashl;';c:10982),
(s:'&Vee;';c:8897),
(s:'&vee;';c:8744),
(s:'&veebar;';c:8891),
(s:'&veeeq;';c:8794),
(s:'&vellip;';c:8942),
(s:'&Verbar;';c:8214),
(s:'&verbar;';c:124),
(s:'&Vert;';c:8214),
(s:'&vert;';c:124),
(s:'&VerticalBar;';c:8739),
(s:'&VerticalLine;';c:124),
(s:'&VerticalSeparator;';c:10072),
(s:'&VerticalTilde;';c:8768),
(s:'&VeryThinSpace;';c:8202),
(s:'&Vfr;';c:120089),
(s:'&vfr;';c:120115),
(s:'&vltri;';c:8882),
(s:'&vnsub;';c:84020008834),
(s:'&vnsup;';c:84020008835),
(s:'&Vopf;';c:120141),
(s:'&vopf;';c:120167),
(s:'&vprop;';c:8733),
(s:'&vrtri;';c:8883),
(s:'&Vscr;';c:119985),
(s:'&vscr;';c:120011),
(s:'&vsubnE;';c:650240010955),
(s:'&vsubne;';c:650240008842),
(s:'&vsupnE;';c:650240010956),
(s:'&vsupne;';c:650240008843),
(s:'&Vvdash;';c:8874),
(s:'&vzigzag;';c:10650),
(s:'&Wcirc;';c:372),
(s:'&wcirc;';c:373),
(s:'&wedbar;';c:10847),
(s:'&Wedge;';c:8896),
(s:'&wedge;';c:8743),
(s:'&wedgeq;';c:8793),
(s:'&weierp;';c:8472),
(s:'&Wfr;';c:120090),
(s:'&wfr;';c:120116),
(s:'&Wopf;';c:120142),
(s:'&wopf;';c:120168),
(s:'&wp;';c:8472),
(s:'&wr;';c:8768),
(s:'&wreath;';c:8768),
(s:'&Wscr;';c:119986),
(s:'&wscr;';c:120012),
(s:'&xcap;';c:8898),
(s:'&xcirc;';c:9711),
(s:'&xcup;';c:8899),
(s:'&xdtri;';c:9661),
(s:'&Xfr;';c:120091),
(s:'&xfr;';c:120117),
(s:'&xhArr;';c:10234),
(s:'&xharr;';c:10231),
(s:'&Xi;';c:926),
(s:'&xi;';c:958),
(s:'&xlArr;';c:10232),
(s:'&xlarr;';c:10229),
(s:'&xmap;';c:10236),
(s:'&xnis;';c:8955),
(s:'&xodot;';c:10752),
(s:'&Xopf;';c:120143),
(s:'&xopf;';c:120169),
(s:'&xoplus;';c:10753),
(s:'&xotime;';c:10754),
(s:'&xrArr;';c:10233),
(s:'&xrarr;';c:10230),
(s:'&Xscr;';c:119987),
(s:'&xscr;';c:120013),
(s:'&xsqcup;';c:10758),
(s:'&xuplus;';c:10756),
(s:'&xutri;';c:9651),
(s:'&xvee;';c:8897),
(s:'&xwedge;';c:8896),
(s:'&Yacute;';c:221),
(s:'&Yacute';c:221),
(s:'&yacute;';c:253),
(s:'&yacute';c:253),
(s:'&YAcy;';c:1071),
(s:'&yacy;';c:1103),
(s:'&Ycirc;';c:374),
(s:'&ycirc;';c:375),
(s:'&Ycy;';c:1067),
(s:'&ycy;';c:1099),
(s:'&yen;';c:165),
(s:'&yen';c:165),
(s:'&Yfr;';c:120092),
(s:'&yfr;';c:120118),
(s:'&YIcy;';c:1031),
(s:'&yicy;';c:1111),
(s:'&Yopf;';c:120144),
(s:'&yopf;';c:120170),
(s:'&Yscr;';c:119988),
(s:'&yscr;';c:120014),
(s:'&YUcy;';c:1070),
(s:'&yucy;';c:1102),
(s:'&Yuml;';c:376),
(s:'&yuml;';c:255),
(s:'&yuml';c:255),
(s:'&Zacute;';c:377),
(s:'&zacute;';c:378),
(s:'&Zcaron;';c:381),
(s:'&zcaron;';c:382),
(s:'&Zcy;';c:1047),
(s:'&zcy;';c:1079),
(s:'&Zdot;';c:379),
(s:'&zdot;';c:380),
(s:'&zeetrf;';c:8488),
(s:'&ZeroWidthSpace;';c:8203),
(s:'&Zeta;';c:918),
(s:'&zeta;';c:950),
(s:'&Zfr;';c:8488),
(s:'&zfr;';c:120119),
(s:'&ZHcy;';c:1046),
(s:'&zhcy;';c:1078),
(s:'&zigrarr;';c:8669),
(s:'&Zopf;';c:8484),
(s:'&zopf;';c:120171),
(s:'&Zscr;';c:119989),
(s:'&zscr;';c:120015),
(s:'&zwj;';c:8205),
(s:'&zwnj;';c:8204)
);



function createEntityDecoder: string;
//Template for the strDecodeHTMLEntities function

var i: Integer;
    builder: TStrBuilder;
    codebuffer: string;
    tempEncodedEntityValue: string;

var codeStarts: array[char, char] of integer;
    codeTries: array[char, char] of TTrieNode;
  c2, c3: Char;
  lineLen: Integer;

begin
  FillChar(codeStarts,sizeof(codeStarts),$FF);
  FillChar(codeTries,sizeof(codeTries),0);
  c2 := #0; c3 := #0;
  for i := low(entities) to high(entities) do begin
    if length(entities[i].s) < 3 then Abort;
    if (entities[i].s[1] <> '&') or not (entities[i].s[2] in ['a'..'z','A'..'Z']) or not (entities[i].s[3] in ['a'..'z','A'..'Z']) then abort;

    if codeTries[entities[i].s[2], entities[i].s[3]] = nil then
      codeTries[entities[i].s[2], entities[i].s[3]] := TTrieNode.Create;

    tempEncodedEntityValue := entities[i].getUtf8;
    if length(tempEncodedEntityValue) > 255 then abort;
    tempEncodedEntityValue := chr(length(tempEncodedEntityValue)) + tempEncodedEntityValue;

    codeTries[entities[i].s[2], entities[i].s[3]].add(strCopyFrom(entities[i].s,4), tempEncodedEntityValue);
  end;



  builder.init(@codebuffer);
  for c2 in ['A'..'Z','a'..'z'] do
    for c3 in ['A'..'Z','a'..'z'] do begin
      if codeTries[c2,c3] = nil then continue;
      codeStarts[c2,c3] := builder.count;
      codeTries[c2,c3].compress;
      builder.append(codeTries[c2,c3].serialize);
    end;
  builder.final;

  //writeln(codeTries['a','m'].serialize());

  builder.init(@result);
  builder.append('const entityCodeStarts: array[0..51, 0..51] of integer = ('+LineEnding);
  for c2 in ['A'..'Z','a'..'z'] do begin
    builder.append('  ');
    if c2 <> 'A' then builder.append(',');
    builder.append('(');
    for c3 in ['A'..'Z','a'..'z'] do begin
      if c3 <> 'A' then builder.append(', ');
      builder.append(inttostr(codeStarts[c2,c3]));
    end;
    builder.append('  ) //'+c2+LineEnding);

  end;
  builder.append(');'+LineEnding);

  builder.append('const entityCode: array[0..'+IntToStr(length(codebuffer)-1)+'] of byte = ('+LineEnding);
  i := 1;
  while i <= length(codebuffer) do begin
    lineLen := min(length(codebuffer), i + 50);
    while i <= lineLen do begin
      if i <> 1 then builder.append(', ');
      builder.append(IntToStr(ord(codebuffer[i])));
      inc(i);
    end;
    builder.append(LineEnding);
  end;
  builder.append(');'+LineEnding);

  builder.final;
end;

function special(name: string) : string;
begin
  if name = 'INCLUDE-ENTITY-DECODER' then
    exit(createEntityDecoder);
  raise Exception.Create('Invlaid special: '+name);
end;

var
  i: Integer;

function TEntity.getUtf8: string;
var cp1, cp2: integer;
begin
  cp1 := c mod 10000000;
  cp2 := c div 10000000;
  result := strGetUnicodeCharacter(cp1);
  if cp2 <> 0 then result += strGetUnicodeCharacter(cp2);
  if (c div 10000000) div 10000000 <> 0 then abort;

end;

var testflags: array[boolean] of TDecodeHTMLEntitiesFlags = ([dhefAttribute],[dhefStrict,dhefAttribute]);

begin
  DefaultSystemCodePage:=CP_UTF8;
  {$ifdef trietests}TTrieNode.tests; exit; {$endif}


  for i:=low(entities)+1 to high(entities) do begin
    //if (entities[i-1].s > entities[i].s) and (entities[i-1].s <> entities[i].s+';') then raise Exception.Create('table not sorted: '+entities[i-1].s+' > '+entities[i].s);
    if length(entities[i].s) < 3 then raise Exception.Create('too short: '+entities[i].s);
  end;

  strSaveToFile('bbutils.inc', convertTemplate(strLoadFromFile('bbutils_template.inc'), @special));
  strSaveToFile('bbutilsh.inc', convertTemplate(strLoadFromFile('bbutils_templateh.inc'), @special));


{writeln(strDecodeHTMLEntities('&DoubleUpArrow;', CP_UTF8));
writeln(strDecodeHTMLEntities('&DoubleUpDownArrow;', CP_UTF8));}

  for i := low(entities) to high(entities) do
    if strDecodeHTMLEntities(entities[i].s, CP_UTF8, testflags[strEndsWith(entities[i].s, ';')]) <> entities[i].getUtf8 then
      writeln(stderr, 'Entity self test failed: ', entities[i].s, ' (this will happen when the entities are changed as it compares the old entities to the new ones. recompile and rerun) ');
 writeln(stderr, 'done');
 { try
  //readln(s);
  s:='&lt;&xyz;&gt;';
  WriteLn(StdErr, strDecodeHTMLEntities('Hallo:&#x20;&#x3C;&auml;&szlig;&nbsp; &lt; &gt;',eUTF8));
  WriteLn(StdErr, strDecodeHTMLEntities(s,eUTF8));
  WriteLn(StdErr, strDecodeHTMLEntities(s,eUTF8,false));
  except
  end;         }
end.

