unit sendBackError;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  Buttons;

type

  { TsendBackErrorForm }

  TsendBackErrorForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    username: TEdit;
    mail: TEdit;
    phone: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    applicationName: string;
    applicationVersion: string;
    class procedure openErrorWindow(errorInformation: string; version:string;programName:string='');
  end;

var
  sendBackErrorForm: TsendBackErrorForm;

implementation
uses internetAccess; //part of videlibri

{ TsendBackErrorForm }

class procedure TsendBackErrorForm.openErrorWindow(errorInformation: string; version:string;programName:string='');
var errorForm:TsendBackErrorForm;
begin
  errorForm:=TsendBackErrorForm.Create(nil);
  errorForm.memo1.lines.add(errorInformation);
  if programName<>'' then errorForm.applicationName:=programName
  else if application.name<>'' then errorForm.applicationName:=application.name
  else errorForm.applicationName:=ExtractFileName(ParamStr(0));

  errorForm.applicationVersion:=version;
  errorForm.ShowModal;
  errorForm.free;
end;

procedure TsendBackErrorForm.Button2Click(Sender: TObject);
begin
  close;
end;

procedure TsendBackErrorForm.Memo1Change(Sender: TObject);
begin

end;

procedure TsendBackErrorForm.Button1Click(Sender: TObject);
var internet: TInternetAccess;
    page:string;
begin
  if MessageDlg('Sollen die eingegebenen Fehlerinformationen jetzt abgeschickt werden?',mtConfirmation,mbOKCancel,0)=mrOK then begin
    internet:=defaultInternetAccessClass.create();
    if internet.needConnection() then begin
      page:=internet.post('http','www.benibela.de','/autoFeedback.php',
                    'app='+internet.urlEncodeData(applicationName)+
                    '&ver='+internet.urlEncodeData(applicationVersion)+
                    '&data='+internet.urlEncodeData('Name: '+username.text+#13#10'Mail:'+mail.text+#13#10'Tel: '+phone.text+#13#10#13#10+memo1.Lines.Text));
      if trim(page) <> 'PHPOK' then begin
         showMessage('Übertragung fehlgeschlagen. Aufgetretender Fehler:'#13#10+copy(page,1,100)+#13#10'Bitte melden Sie diesen Fehler.'#13#10'(Per E-Mail an benito@benibela.de, da das Formular ja nicht geht)');
         exit;
      end else showMessage('Übertragung scheint erfolgreich durchgeführt worden zu sein.');
      internet.closeOpenedConnections();
      close;
    end;
  end;
end;

initialization
  {$I sendBackError.lrs}

end.

