/*
 *	xcdrdata.h
 *	21.10.02 tn@xcdroast.org
 *
 *
 *  Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
 *
 *  This file is part of xcdroast.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <time.h>
#include <unistd.h>
#include <sys/types.h>
#include <cairo.h>

typedef struct geometry {
	gint x;
	gint y;
	gint width;
	gint height;	
} geometry_t;

typedef struct setup_data {
	gint writer_devnr;
	gint reader_devnr;

	GList *image_dirs;

	gchar *dsp_device;
	gchar *mix_device;
	gint notify_via;
	gint notify_at;

	gchar *cddb_host;
	gint cddb_port;
	gchar *cddb_proxy_host;
	gint cddb_proxy_port;
	gint cddb_use_http;
	gint cddb_use_proxy;
	
	gchar *logfile;
	gint loglevel;

	gchar *language;	

	gboolean option_tooltips;
	gboolean option_autoraise;
	gboolean option_savepos;
	gboolean option_personimage;
	gboolean option_overwritewarn;
	gboolean option_autodelete;
	gboolean option_titleprogress;
	gboolean option_displaycdtext;

	gint root_users_access;
	GList *root_users_lists;
	
	gint root_hosts_access;
	GList *root_hosts_lists;

	gboolean root_option_change_writer;
	gboolean root_option_change_writeparam;
	gboolean root_option_change_reader;
	gboolean root_option_change_readparam;
	gboolean root_option_change_imagedirs;
	gboolean root_option_change_logoptions;

	geometry_t mainwindow;
	geometry_t burnwindow;
	
} setup_data_t;

typedef struct scsi_devices {
	gint devnr;
	gint transport;
	gint bus;
	gint id;
	gchar vendor[9];
	gchar model[17];
	gchar rev[5];
	gint removable;
	gint type;
	gint alt_dev;
	gint sector_size;
} scsi_devices_t;

typedef struct writerreader_devices {
	gint devnr;
	gchar *devicestr;
	gchar vendor[9];
	gchar model[17];
	gchar rev[5];
	gint writer_readmaxspeed;
	gint writer_cdrmaxspeed;
	gint writer_dvdmaxspeed;
	gchar *writer_flags;
	gchar *writer_modes;
	gint is_cdrwriter;
	gint is_dvdreader;
	gint is_dvdwriter;
	gint sector_size;
	/* -- user editable values below -- */
	gint writer_drvmode;
	gint writer_mode;
	gint writer_speed;
	gint writer_fifo;
	gint audioread_speed;
	gint audioread_overlap;
	gint audioread_showhiddentrack;
	gint audioread_useparanoia;
	gint audioread_paranoiaretries;
	gint audioread_paranoiareadahead;
	gint audioread_paranoiaminoverlap;
} writerreader_devices_t;

typedef struct writerreader_bak {
	gint devnr;
	gint values[11];   /* 11 user editable values to backup in setup */
} writerreader_bak_t;

typedef struct writer_driver {
	gchar *driver;
	gchar *desc;
} writer_driver_t;

typedef struct current_set {
	gint isProDVD;
	gint writer_devnr;
	gint reader_devnr;
	gint image_index;  /* index in image_dir-glist, -1 = automatic */
	gint proc_view;
	gchar *file_prefix;
	gchar *tocfile;
	gint cdrtype;	   /* in minutes */
	gboolean writesimul;
	gboolean writeeject;
	gboolean writepad;
	gboolean writeswap;
	gboolean nofixate;
	gboolean multisession;
	gboolean writecdtext;
	gboolean writeoverburn;
	gboolean writeburnfree;
	gboolean writeaudiomaster;
	gboolean writeforcespeed;
	gint writevarirec;
	gboolean writeignsize;
	gboolean writeimmed;
	gint blankmode;
	gboolean blank_force;
	gboolean blank_eject;
	gboolean noaudioverify;
	gboolean verifyfailabort;
	gboolean indexscan;
	gboolean deemphasize;
	gboolean sync_cdtext_artist;
	gboolean mstr_auto_calc;
	gchar *sudo_passwd;
} current_set_t;

typedef struct cd_info {
	gint nr_tracks;  /* -1 = no disc loaded */
	gint total_size; /* all sizes in frames */
	gchar cddb_discid[9];
	gint have_cdtext;
	gint have_cdextra;
	gchar *title;
	gchar *artist;
	gchar *cddb_dtitle;
	gint leadout;
} cd_info_t;

typedef struct track_info {
	gint track_nr;
	gint start_sec;
	gint size;     /* in frames */
	gint type;     /* 0: data,        1: audio */
	gint rec_type; /* 0: incremental, 1: uninterrupted */
	gint preemp;   /* 0: linear,      1: preemp */
	gint copyperm; /* 0: denied,      1: allowed */
	gint stereo;   /* 0: quadro,      1: stereo */
	gchar *volname; 
	gchar *title;
	gchar *artist;
	gchar *cddb_ttitle;
	gint isosize;  /* only for datatracks, else set to -1 */
} track_info_t;

typedef struct cddb_match {
	gint exact;  /* 0: not exact match, 1: exact */
	gchar *categ;
	gchar *discid;
	gchar *dtitle;
} cddb_match_t;

typedef struct image_files {
	gchar *path;
	off_t size;    /* in bytes */
	time_t mtime;  /* modification time */
	gint type;     /* 0: iso9660 data, 1: valid audio, 2: invalid audio, 
			  3: unknown data, 4: toc-file */
	gint readable; /* 0: no, 1: yes */
	gint from_track;
	gchar *volname; 
	gchar *title;
	gchar *artist;
	gchar *cddb_ttitle;
	gchar *cd_discid;
	gint isosize;  /* in sectors */
	gint last_session_start;
	gint next_session_start;
} image_files_t;

typedef struct track_read_param {
	gint trackinfo_index;  
	gint starttrack;
	gint endtrack;      /* set to 0 when not used */
	gint tracktype;     /* 0: data,        1: audio */
	gint start_sec;	    /* for audio tracks */
	gint startoffset;   /* for data tracks: startsector */
	gint endoffset;     /* for data tracks: endsector */
	gfloat percent;	    /* how many percent does this track take on the disc */
	gint kbyte; 	   
	gint frames;
	gchar *trackfile;
} track_read_param_t;

typedef struct track_read_set {
	gint nrtracks;
	gint cdsize;	/* in frames */
	gchar *tocfile;
	gchar *cdtitle;
	gchar *cd_discid;
	GList *trackparams;
} track_read_set_t;

typedef struct image_dir_free {
	gchar *path;
	gint free;
} image_dir_free_t;

typedef struct write_track_param {
	gint nrtracks;
	gint simulation;
	gint *tracktype;
	gint *frames;
	gfloat *pct_so_far_arr;
	gfloat *pct_this_track_arr;
} write_track_param_t;

typedef struct mstr_redirect {
	gchar *mstr_path;
	gchar *redir_path;
} mstr_redirect_t;

typedef struct master_param {
	GList *mstr_redir;
	GList *exclude_paths;
	gint image_type;
	gboolean show_only_dirs;
	gboolean show_hidden_files;
	gboolean opt[24];
	gint bootable;
	gchar *boot_image;
	gchar *boot_catalog;
	gint boot_type;
	gint boot_load_size;
	gint boot_info_table;
	gchar *sparc_boot;
	gchar *volid;
	gchar *publisher;
	gchar *preparer;
	gchar *application;
	gchar *abstract;
	gchar *biblio;
	gchar *copyright;
	gchar *image_filename;
	gint old_session_size;	/* in 2048 byte blocks */
	gint session_size;	/* in 2048 byte blocks */
	gint charset;
	gchar *cust_charset;
	gint outcharset;
	gchar *cust_outcharset;
	gint redirtype;
	gchar *lastredirpath;
	gint redirtype2;
	gchar *lastredirpath2;
	gint last_session_start;
	gint next_session_start;
} master_param_t;

typedef struct nonroot_flags {
	gchar *path;
	uid_t uid;
	gid_t gid;
	mode_t mode;
} nonroot_flags_t;

typedef struct version_id {
	gint major;
	gint minor;
	gint branch;
	char devel;
	gint patch;
} version_id_t;

typedef struct cddb_connect {
	gchar *hostname;
	gchar *username;
  gchar *server;
  gint port;
  gchar *proxy;
	gchar *authstring;
  gint proxyport;
  gint useproxy;
  gint usehttp;
	gint useauth;
} cddb_connect_t;

typedef struct img_logo {
        cairo_surface_t *xcdrlogo;
        cairo_surface_t *xcdrlogo_middle;
        cairo_surface_t *xcdrlogo_small;
        cairo_surface_t *cddblogo;
} img_logo_t;

