/*
 *	rmtool.c
 *
 *	simple program that deletes some files on the hard disk
 *	and give nice parseable output.
 *	Because I do this in an external programm, the GUI-interface
 *	won't be lagging due the long unlink-calls.
 *
 *	does not complain when an .inf file can't be deleted
 *	22.09.99 tn
 *
 *
 *  Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
 *
 *  This file is part of xcdroast.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "largefile.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <glib.h>
#include "xcdroast.h"

gint main(gint argc, gchar **argv) {
gint i;
gchar tmp[MAXLINE];
gint inffile;
gchar *p;
gint errflag;

	if (argc <= 1) {
		g_print("Usage: rmtool [list of files to delete] (Version: %s)\n", XCDROAST_VERSION);
		exit(1);
	}

	g_print("\nStarting to delete files...\n");
	fflush(stdout);

	errflag = 0;
	/* loop through the arguments */
	for (i = 1; i < argc; i++) {
		
		/* check if an .inf file */
		inffile = 0;
		strncpy(tmp,argv[i],MAXLINE);
		p = rindex(tmp,'.');
		if (p != NULL) {
			if ((strncmp(p,XCDROAST_INFO_EXT,MAXLINE) == 0)
			    || (strncmp(p,CDDA2WAV_INFO_EXT,MAXLINE) == 0)) {
				inffile = 1;
			}
		}
		if (unlink(argv[i]) != 0) {
			if (inffile == 0) {
				/* keep silent when try to delete inffile */
				g_print("Error deleting %s: %s\n",argv[i],
					strerror(errno));
				errflag = 1;
			}
		} else {
			g_print("Deleted %s successfully.\n", argv[i]);
		}
		g_print(" %d%%\n", (gint) ( (gfloat)i/(argc-1)*100.0));
		fflush(stdout);
	}

	return errflag;
}	
