/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *
 * Modify:  2014/07/29  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/05/03  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/01/07  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2014/01/07  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify:  2006/24/10  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file contains the prototypes of all public versions
 * from misc source code files
 */
#ifndef _PROTOTYPES_H
#define _PROTOTYPES_H

#include "package.h"

/* package.c */
int update_package(const char *package, const char *tag, const char *value);

/* input.c */
int read_file(const char *filename);
int parse_files(const char *dir_from);

/* parse.c */
const char *parse_errstr(int err_code);
int parse_line(char *buffer, char **package, char **tag, char **lang, char **string);

/* wmconfig.c */
int main(int argc, char **argv);

/* package.c */
int init_packages(void);
void complete_packages(void);
void unselect_nonexistent_packages(void);

/* rootmenu.c */
int build_root(void);

/* debug.c */
void output_debug(struct group *root);

/* fvwm2.c */
void output_fvwm2(struct group *root, const char *use_term);

/* afterstep_dir.c */
void output_afterstep_dir(struct group *root, const char *use_term);

/* afterstep.c */
void output_afterstep(struct group *root, const char *use_term);

/* mwm.c */
void output_mwm(struct group *root, const char *use_term);

/* wmaker.c */
void output_wmaker(struct group *root, const char *use_term);

/* icewm.c */
void output_icewm(struct group *root, int level, const char *use_term);

/* blackbox.c */
void output_blackbox(struct group *root, int level, const char *use_term);

/* kde.c */
void output_kde(struct group *root);

/* twm.c */
void output_twm(struct group *root, const char *use_term, const int twm_type);

/* olwm.c */
void output_olwm(struct group *root, const char *use_term);

/* fvwm.c */
void output_fvwm(struct group *root, const char *use_term);

/* mlvwm.c */
void output_mlvwm(struct group *root, const char *use_term);

/* kde2.c */
void output_kde2(struct group *root);

/* qvwm.c */
void output_qvwm(struct group *root, const char *use_term);

/* pekwm.c */
void output_pekwm(struct group *root, const char *use_term);

/* golem.c */
void output_golem(struct group *root, const char *use_term);

/* gnome2.c */
void output_gnome2(struct group *root);

/* openbox.c */
void output_openbox(struct group *root, const char *use_term);

/* aewm.c */
void output_aewm(struct group *root, const char *use_term, const int aewm_type);

/* amiwm.c */
void output_amiwm(struct group *root, const char *use_term);

/* kahakai.c */
void output_kahakai(struct group *root, int level, const char *use_term);

/* pwm.c */
void output_pwm(struct group *root, const char *use_term);

/* sapphire.c */
void output_sapphire(struct group *root, int level, const char *use_term);

/* enlighenment.c */
void output_enlightenment(struct group *root, const char *use_term);

/* e17.c */
void output_e17(struct group *root, const char *use_term);

/* epiwm.c */
void output_epiwm(struct group *root, const char *use_term);

/* ede.c */
void output_ede(struct group *root);

/* ude.c */
void output_ude(struct group *root, int level, const char *use_term);

/* xfce.c */
void output_xfce(struct group *root, const char *use_term);

/* wmx.c */
void output_wmx(struct group *root, const char *use_term);

/* freedesktop.c */
void output_freedesktop(struct group *root, const int freedesktop_type);

/* jwm.c */
void output_jwm(struct group *root, int level, const char *use_term);

/* sawfish.c */
void output_sawfish(struct group *root, const char *use_term);

/* util.c */
char *single_string(const char *group_string);
char *valid_string (char *str);

#endif /* _PROTOTYPES_H */
