/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

/* Small and fast Pekwm
 something I really enjoy to support */

static void pekwm(struct group *root, int level,const char *use_term)
{
    int i;
    int z;
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }

    if (level>=0) {
	for (z=0; z<2; z++) {
	    for (i=0; i<level; i++) {
		printf(" ");
	    }
	    if (z == 0) {
		printf(" Submenu");
	    } else {
		printf("= \"%s\" {\n", root->name);
	    }
	}
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    pekwm(item->data, level+1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app != NULL) {
		for (i=0; i<level; i++) {
		    printf(" ");
		}
		if (app->restart) {
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			printf(" Entry = \"%s\" { Actions = \"Restart\" }\n", app->name);
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" Entry = \"%s\" { Actions = \"Exit\" }\n", app->name);
		    } else {
			printf(" Entry = \"%s\" { Actions = \"RestartOther %s\" }\n", app->name, app->exec);
		    }
		} else {
		    if (app->terminal) {
			printf (" Entry = \"%s\" { Actions = \"Exec %s -e %s\" }\n", app->name, use_term, app->exec);
		    } else {
			printf (" Entry = \"%s\" { Actions = \"Exec %s\" }\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf(" }\n");
    }
}
void output_pekwm(struct group *root,const char *use_term)
{
    pekwm(root, 0, use_term);
}
