/*
 * Copyright (C) 2002-2015 Tommy Scheunemann
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

/* Olwm and Olvwm output function */

static void olwm(struct group *root, int level,const char *use_term)
{
    int i;
    struct item *item;
    if (root == (struct group *)NULL) {
	return;
    }

    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("\"%s\" MENU\n", root->name);
    }
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    olwm(item->data, level+1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (app != NULL) {
		for (i=0; i<level; i++) {
		    printf(" ");
		}
		if (app->restart) {
		    if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" \"%s\" EXIT\n", app->name);
		    }
		} else {
		    if (app->terminal) {
			printf(" \"%s\" exec %s -e %s\n", app->name, use_term, app->exec);
		    } else {
			printf(" \"%s\" exec %s\n", app->name, app->exec);
		    }
		}
	    }
	}
	item++;
    }
    if (level>=0) {
	for (i=0; i<level; i++) {
	    printf(" ");
	}
	printf("\"%s\" END\n", root->name);
    }
}
void output_olwm(struct group *root,const char *use_term)
{
    olwm(root, 0, use_term);
}
