/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify: 2006-24-10  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify: 2004-08-09  Tommy Scheunemann <net@arrishq.net>
 *
 * Modify: 2004-07-10  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing an MotifWM (mwm) configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>

/*
 * Outputs on stdout the Mwm-compatible configuration
 */
void output_mwm(struct group *root,const char *use_term)
{
    struct item *item;

    if (root == (struct group *)NULL) {
	return;
    }

    printf("Menu \"%s\"\n{\n\t\"%s\"\tf.title\n", root->name, root->name);

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;

	    tmp = (struct group *)item->data;
	    printf("\t\"%s\"\tf.menu \"%s\"\n", tmp->name, tmp->name);
	}
	item++;
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;

	    app = (struct package *)item->data;

	    if (app->restart) {
		if (strncasecmp(app->restart, "restart", 7) == 0) {
		    printf(" \"%s\" f.restart\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    printf(" \"%s\" f.quit_mwm\n", app->name);
		}
	    } else {
		if (app->name && app->exec && app->terminal) {
		    printf("\t\"%s\"\tf.exec \"%s -e %s\"\n", app->name, use_term, app->exec);
		} else {
		    printf("\t\"%s\"\tf.exec \"%s\"\n", app->name, app->exec);
		}
	    }
	}
	item++;
    }

    printf("}\n\n");

    /* second pass, recursive output... */
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_mwm(item->data, use_term);
	}
	item++;
    }

    return;
}
