/*
 * Copyright (C) 2013-2015 Tommy Scheunemann
 *
 * Modify:  2015/20/01  Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing an Jwm configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <strings.h>
#include <string.h>

extern unsigned int flags;

/*
 * Outputs on configuration stdout
 */
void output_jwm (struct group *root, int level, const char *use_term)
{
    struct item *item;
    int sp;

    if (root == (struct group *)NULL) {
	return;
    }

    if (level > 0) {
	for (sp = 1; sp < level; sp++) putchar(' ');
	if ((is_set(NO_MINI_ICONS)) || (is_set(NO_ICONS))) {
	    printf("<Menu icon=\"folder.png\" label=\"%s\">\n", (level == 0) ? "Programs" : root->name);
	} else {
	    printf("<Menu label=\"%s\">\n", (level==0) ? "Programs" : root->name);
	}
    } else {
	printf("<?xml version=\"1.0\"?>\n");
	printf("<JWM>\n\n");
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *subgroup = (struct group *)item->data;
	    output_jwm(subgroup, level + 1, use_term);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;

	    if (app->restart) {
		if ((strncasecmp(app->restart, "restart", 7) == 0) && ((is_set(NO_MINI_ICONS)) || (is_set(NO_ICONS)))) {
		    printf(" <Restart label=\"%s\"/>\n", app->name);
		} else if (strncasecmp(app->restart, "restart", 7) ==0) {
		    printf(" <Restart label=\"%s\" icon=\"restart.png\"/>\n", app->name);
		} else if ((strncasecmp(app->restart, "quit", 4) == 0) && ((is_set(NO_MINI_ICONS)) || (is_set(NO_ICONS)))) {
		    printf(" <Exit label=\"%s\" confirm=\"true\"/>\n", app->name);
		} else if (strncasecmp(app->restart, "quit", 4) == 0) {
		    printf(" <Exit label=\"%s\" confirm=\"true\" icon=\"exit.png\"/>\n", app->name);
		}
	    } else if (app->name && app->exec) {
		for (sp = 1; sp <= level; sp++) {
		    putchar(' ');
		}
		if ((app->mini_icon != NULL) && ((!is_set(NO_MINI_ICONS)) || (!is_set(NO_ICONS)))) {
		    printf("<Program icon=\"%s\" label=\"%s\">", app->mini_icon, app->name);
		} else {
		    /* this removes ending '&' that should not be there */
		    char *b;
		    int l;
		    b = app->exec;
		    l = strlen(b);

		    printf("<Program label=\"%s\">", app->name);

		    /* Check for terminal */
		    if (app->terminal) {
			printf ("%s -e ", use_term);
		    }
		    while (l > 0 && b[l - 1] == ' ') {
			l--;
		    }
		    if (l > 0 && b[l - 1] == '&') {
			l--;
		    }
		    for (; l > 0; l--,b++) {
			putchar(*b);
		    }
		    printf("</Program>\n");
		}
	    }
	}
	item++;
    }

    if (level > 0) {
	for (sp = 1; sp < level; sp++) putchar(' ');
	printf("</Menu>\n");
    } else {
	printf("</JWM>\n");
    }
}
