/*
 * Copyright (C) 1997 Red Hat Software, Inc.
 *	Cristian Gafton <gafton@redhat.com>
 *
 * Modify: 2010/01/05 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing a FVWM2 configuration
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <strings.h>

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

extern unsigned int flags;

/* Outputs on stdout the FVWM2-compatible configuration */
static void fvwm2(struct group *root, int level, const char *menu_name,const char *use_term)
{
    struct item *item;
    int debug_icon = 0;
    char *root_name;

    if (root == (struct group *)NULL) {
	return;
    }

    printf("\n#\n# Starting configuration for menu \"%s\"\n#\n", root->name);

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;

	    if (!debug_icon) {
		printf("# Icon specification for Apps under \"%s\"\n", root->name);
		debug_icon++;
	    }

	    app = (struct package *)item->data;
	    if ((app->name && app->mini_icon) && !is_set(NO_MINI_ICONS)) {
		if (app->Xresource) {
		    printf("Style\t\"%s\"\tMiniIcon\t%s\n", app->Xresource, app->mini_icon);
		} else {
		    printf("Style\t\"%s\"\tMiniIcon\t%s\n", app->name, app->mini_icon);
		}
	    }
	    if ((app->name && app->icon) && !is_set(NO_ICONS)) {
		printf("Style\t\"%s\"\tIcon\t%s\n", app->name, app->icon);
	    }
	}
	item++;
    }

    root_name = single_string(root->name);
    printf("# The menus...\n");
    if (level) {
	printf("AddToMenu\t%s%s\t\"%s\"\tTitle\n", menu_name, root_name, root->name);
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;
	    char *c_tmp;

	    tmp = (struct group *)item->data;
	    c_tmp = single_string(tmp->name);
	    printf("AddToMenu\t%s%s\t\"%s\"\tPopup\t%s%s.%s\n", menu_name, root_name, tmp->name, menu_name, root_name, c_tmp);
	    free(c_tmp);
	} else if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    printf("# The following is added by package: %s\n", app->__package?app->__package:"");
	    if (app->name && app->exec) {
		if ((app->mini_icon != NULL) && !is_set(NO_MINI_ICONS)) {
		    printf("AddToMenu\t%s%s\t\"%s %%%s%%\"\t", menu_name, root_name, app->name, app->mini_icon);
		} else {
		    printf("AddToMenu\t%s%s\t\"%s\"\t", menu_name, root_name, app->name);
		}
		if (app->restart) {
		    if (strncasecmp(app->restart, "restart", 7) == 0) {
			printf(" Restart\n");
		    } else if (strncasecmp(app->restart, "quit", 4) == 0) {
			printf(" Quit\n");
		    } else {
			printf(" Restart %s\n", app->exec);
		    }
		} else {
		    if (app->terminal) {
			printf("Exec\t%s -e %s\n", use_term, app->exec);
		    } else {
			printf("Exec\t%s\n", app->exec);
		    }
		}
	    }
	}
	item++;
    }

    /* second pass, recursive output */
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    char *c_tmp;
	    c_tmp = malloc(BUFSIZ);
	    snprintf(c_tmp, BUFSIZ, "%s%s.", menu_name, root_name);
	    fvwm2(item->data, level+1, c_tmp, use_term);
	    free(c_tmp);
	}
	item++;
    }
    free(root_name);
}

void output_fvwm2(struct group *root,const char *use_term)
{
    fvwm2(root, 0, "", use_term);
}
