/*
 * Copyright (C) 2004-2015 Tommy Scheunemann <net@arrishq.net>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * Functions needed for producing an Epiwm configuration
 */

#include "wmconfig.h"
#include "prototypes.h"
#include "package.h"

#include <stdio.h>
#include <strings.h>

/*
 * Outputs on stdout the Epiwm configuration
 */
void output_epiwm(struct group *root,const char *use_term)
{
    struct item *item;

    printf("Menu \"%s\"\n", root->name);

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    struct group *tmp;

	    tmp = (struct group *)item->data;
	    printf("+ \"%s\"\n",tmp->name);
	}
	item++;
    }

    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_APP) {
	    struct package *app;
	    app = (struct package *)item->data;
	    if (! app->restart) {
		if (app->name && app->exec && app-> terminal) {
		    printf("- \"%s\" Exec %s -e %s\n", app->name, use_term, app->exec);
		} else if (app->name && app->exec) {
		    printf("- \"%s\" Exec %s\n", app->name, app->exec);
		}
	    }
	}
	item++;
    }

    printf("EndMenu\n\n");

    /* second pass, recursive output... */
    item = root->items;
    while (item->type != 0) {
	if (item->type == ITEM_MENU) {
	    output_epiwm(item->data, use_term);
	}
	item++;
    }

    return;
}
