/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import java.math.BigInteger;

abstract class SshPacket {
    protected byte[] byteArray = new byte[0];
    protected int offset;
    private boolean finished = false;
    private byte packet_type;

    public byte[] getData() {
        return this.byteArray;
    }

    public void putData(byte[] data) {
        this.byteArray = data;
        this.offset = 0;
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public abstract byte[] addPayload(byte[] var1);

    public byte getType() {
        return this.packet_type;
    }

    public void setType(byte ntype) {
        this.packet_type = ntype;
    }

    public abstract void putMpInt(BigInteger var1);

    public int getInt32() {
        short d0 = this.byteArray[this.offset++];
        short d1 = this.byteArray[this.offset++];
        short d2 = this.byteArray[this.offset++];
        short d3 = this.byteArray[this.offset++];
        if (d0 < 0) {
            d0 = (short)(256 + d0);
        }
        if (d1 < 0) {
            d1 = (short)(256 + d1);
        }
        if (d2 < 0) {
            d2 = (short)(256 + d2);
        }
        if (d3 < 0) {
            d3 = (short)(256 + d3);
        }
        return (d0 << 24) + (d1 << 16) + (d2 << 8) + d3;
    }

    public int getInt16() {
        short d0 = this.byteArray[this.offset++];
        short d1 = this.byteArray[this.offset++];
        if (d0 < 0) {
            d0 = (short)(256 + d0);
        }
        if (d1 < 0) {
            d1 = (short)(256 + d1);
        }
        return (d0 << 8) + d1;
    }

    public String getString() {
        int length = this.getInt32();
        String str = "";
        for (int i = 0; i < length; ++i) {
            str = this.byteArray[this.offset] >= 0 ? str + (char)this.byteArray[this.offset++] : str + (char)(256 + this.byteArray[this.offset++]);
        }
        return str;
    }

    public byte getByte() {
        return this.byteArray[this.offset++];
    }

    public byte[] getBytes(int cnt) {
        byte[] bytes = new byte[cnt];
        System.arraycopy(this.byteArray, this.offset, bytes, 0, cnt);
        this.offset += cnt;
        return bytes;
    }

    private void grow(int howmuch) {
        byte[] value = new byte[this.byteArray.length + howmuch];
        System.arraycopy(this.byteArray, 0, value, 0, this.byteArray.length);
        this.byteArray = value;
    }

    public void putInt16(int xint) {
        int boffset = this.byteArray.length;
        this.grow(2);
        this.byteArray[boffset + 1] = (byte)(xint & 0xFF);
        this.byteArray[boffset] = (byte)(xint >> 8 & 0xFF);
    }

    public void putInt32(int xint) {
        int boffset = this.byteArray.length;
        this.grow(4);
        this.byteArray[boffset + 3] = (byte)(xint & 0xFF);
        this.byteArray[boffset + 2] = (byte)(xint >> 8 & 0xFF);
        this.byteArray[boffset + 1] = (byte)(xint >> 16 & 0xFF);
        this.byteArray[boffset + 0] = (byte)(xint >> 24 & 0xFF);
    }

    public void putByte(byte xbyte) {
        this.grow(1);
        this.byteArray[this.byteArray.length - 1] = xbyte;
    }

    public void putBytes(byte[] bytes) {
        int oldlen = this.byteArray.length;
        this.grow(bytes.length);
        System.arraycopy(bytes, 0, this.byteArray, oldlen, bytes.length);
    }

    public void putString(String str) {
        this.putInt32(str.length());
        this.putBytes(str.getBytes());
    }
}

