/*
 * xmalloc.c - fail-safe malloc functions
 * Copyright (C) 2005 - 2008 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

static const char rcsid[] = "@(#) $Id: xmalloc.c,v 1.3 2008/05/20 20:45:52 michael Exp $";

#if STDC_HEADERS
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#else
char *strdup();
void *malloc(), *realloc();
void abort(), free();
#endif

#include <stdio.h>

#include <error.h>
#include <xmalloc.h>

static void
oom(const char *where) {
	file_fatal(where, "out of memory");
}

void
xfree(void *p) {
	if (p != NULL) {
		free(p);
	}
}

void*
xmalloc(size_t size) {
	void *p;

	if (size == 0) {
		return NULL;
	}
	p = malloc(size);
	if (p == NULL) {
		oom("xmalloc");
	}
	return p;
}

void*
xrealloc(void *p, size_t size) {
	if (size == 0) {
		xfree(p);
		return NULL;
	}
	p = p ? realloc(p, size) : malloc(size);
	if (p == NULL) {
		oom("xrealloc");
	}
	return p;
}

char*
xstrdup(const char *str) {
	char *s;

	if (str == NULL) {
		return NULL;
	}
	s = strdup(str);
	if (s == NULL) {
		oom("xstrdup");
	}
	return s;
}
