/*
 * x86_64.h - 64-bit specific definitions
 * Copyright (C) 2008 - 2013 Michael Riepe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _X86_64_H
#define _X86_64_H

static const char rcsid_x86_64_h[] = "@(#) $Id: x86_64.h,v 1.4 2013/03/04 20:48:41 michael Exp $";

/*
 * Note: __X32_SYSCALL_BIT is defined in asm/unistd.h,
 * but we can't include that file because we would get the wrong
 * syscall numbers.
 */
#define __X32_SYSCALL_BIT   0x40000000

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24)

#include <asm/unistd_64.h>

#else

#include <asm-x86_64/unistd.h>

#endif

#include <sys/user.h>

#define __nr	orig_rax
#define __a1	rdi
#define __a2	rsi
#define __a3	rdx
#define __a4	r10
#define __a5	r8
#define __res	rax
#define __ip	rip
#define __cs	cs

#endif /* _X86_64_H */
