.\" trexec.man - man page for trexec
.\" Copyright (C) 2005 - 2008 Michael Riepe
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.1 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.  A copy of the license is included
.\" in the file COPYING.DOC.
.\"
.\" @(#) $Id: trexec.man,v 1.2 2008/05/02 15:00:03 michael Exp $
.\"
.TH trexec 1 "May 2, 2008" "Linux" "User commands"
.SH NAME
trexec \- track program execution and file access
.SH SYNOPSIS
.BI "trexec [\-l " logfile "] [\-I " pattern "] " command " [" arg " ...]"
.br
.B trexec \-h
.SH DESCRIPTION
.B trexec
runs the specified
.I command
and watches over it by means of the
.BR ptrace (2)
system call. When the child (including all its direct and indirect
child processes) executes another program or opens a file system
object for reading,
.B trexec
logs the name of the object in the file specified with the
.B \-l
option.
.PP
Specifying the
.B \-I
option requests that file names matching
.I pattern
are ignored \- that is, neither logged nor backed up.  Note that
.I pattern
is a shell (wildcard) pattern, not a regular expression, and must
match the whole path.  This option may be given more than once.
.SH FILES
The
.I logfile
contains one line per file. The line format is supposed to be easily
parsed by humans as well as programs:
.sp 1
.RS 4
"%c %s\\n",
.IR indicator ", " pathname
.RE
.LP
The
.I indicator
character is one of
.RS 4
.TS
c l.
'e'	\fIpathname\fR was \fIe\fRxecuted
'r'	\fIpathname\fR was \fIr\fRead
.TE
.RE
.PP
Pathnames appear as often as they are executed/accessed successfully,
in chronological order.
.SH SEE ALSO
.BR trackfs "(1), " strace "(1), " ptrace "(2)."
.SH BUGS
.B trexec
only works on Linux/i386 and Linux/x86_64 systems with a 2.6 (or
later) kernel.
.PP
Please send bug reports to
.IR <trackfs@mr511.de> .
.SH AUTHOR
Michael "Tired" Riepe
.SH LICENSE
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
