.\" trackfs.man - man page for trackfs
.\" Copyright (C) 2005 - 2008 Michael Riepe
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.1 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.  A copy of the license is included
.\" in the file COPYING.DOC.
.\"
.\" @(#) $Id: trackfs.man,v 1.5 2008/05/02 14:57:55 michael Exp $
.\"
.TH trackfs 1 "May 2, 2008" "Linux" "User commands"
.SH NAME
trackfs \- track file system changes
.SH SYNOPSIS
.BI "trackfs [\-b " backupfile "] [\-l " logfile "] [\-I " pattern "] " command " [" arg " ...]"
.br
.B trackfs \-h
.SH DESCRIPTION
.B trackfs
runs the specified
.I command
and watches over it by means of the
.BR ptrace (2)
system call. When the child (including all its direct and indirect
child processes) makes a system call that modifies a file system
object,
.B trackfs
logs the name of the object in the file specified with the
.B \-l
option.
.PP
If the
.B \-b
option is specified,
.B trackfs
writes backup copies of all possibly modified files to
.IR backupfile .
Note that the existance of a file in the backup does
.I NOT
indicate that it has actually been modified: The system call that
triggers the backup may fail, leaving the file unchanged.  To find
out which files really have been modified, consult the
.IR logfile .
.PP
Specifying the
.B \-I
option requests that file names matching
.I pattern
are ignored \- that is, neither logged nor backed up.  Note that
.I pattern
is a shell (wildcard) pattern, not a regular expression, and must
match the whole path.  This option may be given more than once.
.SH FILES
The
.I logfile
contains one line per file. The line format is supposed to be easily
parsed by humans as well as programs:
.sp 1
.RS 4
"%c %s\\n",
.IR indicator ", " pathname
.RE
.LP
The
.I indicator
character is one of
.RS 4
.TS
c l.
'c'	\fIpathname\fR was \fIc\fRreated
'd'	\fIpathname\fR was \fId\fReleted
'u'	\fIpathname\fR was \fIu\fRpdated
't'	\fIpathname\fR was used \fIt\fRemporarily
	(that is, created and then deleted)
.TE
.RE
.PP
Since
.B trackfs
summarizes all uses of a file, pathnames appear at most once,
and in no particular order.
.PP
If a
.I backupfile
is written, it contains (at least) those files that are reported as
having been deleted or updated, in POSIX.1
.BR cpio (1)
format.  Note that
.B trackfs
reports absolute pathnames in the
.I logfile
but removes their leading slashes when
writing the
.IR backupfile .
.SH SEE ALSO
.BR trexec "(1), " cpio "(1), " strace "(1), " ptrace "(2)."
.SH BUGS
.B trackfs
only works on Linux/i386 and Linux/x86_64 systems with a 2.6 (or
later) kernel.
.PP
Please send bug reports to
.IR <trackfs@mr511.de> .
.SH AUTHOR
Michael "Tired" Riepe
.SH LICENSE
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
