/*
 * syscalls.h - generic linux system call list
 * Copyright (C) 2005 - 2011 Michael Riepe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __syscall__
#define __syscall__(x)	/* nothing */
#endif

#ifdef __NR__exit
__syscall__(_exit)
#endif
#ifdef __NR__llseek
__syscall__(_llseek)
#endif
#ifdef __NR__newselect
__syscall__(_newselect)
#endif
#ifdef __NR__sysctl
__syscall__(_sysctl)
#endif
#ifdef __NR_accept
__syscall__(accept)
#endif
#ifdef __NR_accept4
__syscall__(accept4)
#endif
#ifdef __NR_access
__syscall__(access)
#endif
#ifdef __NR_acct
__syscall__(acct)
#endif
#ifdef __NR_acl_get
__syscall__(acl_get)
#endif
#ifdef __NR_acl_set
__syscall__(acl_set)
#endif
#ifdef __NR_add_key
__syscall__(add_key)
#endif
#ifdef __NR_adjtimex
__syscall__(adjtimex)
#endif
#ifdef __NR_afs_syscall
__syscall__(afs_syscall)
#endif
#ifdef __NR_alarm
__syscall__(alarm)
#endif
#ifdef __NR_alloc_hugepages
__syscall__(alloc_hugepages)
#endif
#ifdef __NR_arch_prctl
__syscall__(arch_prctl)
#endif
#ifdef __NR_arm_fadvise64_64
__syscall__(arm_fadvise64_64)
#endif
#ifdef __NR_arm_sync_file_range
__syscall__(arm_sync_file_range)
#endif
#ifdef __NR_atomic_barrier
__syscall__(atomic_barrier)
#endif
#ifdef __NR_atomic_cmpxchg_32
__syscall__(atomic_cmpxchg_32)
#endif
#ifdef __NR_attrctl
__syscall__(attrctl)
#endif
#ifdef __NR_available115
__syscall__(available115)
#endif
#ifdef __NR_available165
__syscall__(available165)
#endif
#ifdef __NR_available170
__syscall__(available170)
#endif
#ifdef __NR_available171
__syscall__(available171)
#endif
#ifdef __NR_available179
__syscall__(available179)
#endif
#ifdef __NR_available222
__syscall__(available222)
#endif
#ifdef __NR_available238
__syscall__(available238)
#endif
#ifdef __NR_available255
__syscall__(available255)
#endif
#ifdef __NR_available259
__syscall__(available259)
#endif
#ifdef __NR_available271
__syscall__(available271)
#endif
#ifdef __NR_available275
__syscall__(available275)
#endif
#ifdef __NR_available279
__syscall__(available279)
#endif
#ifdef __NR_available287
__syscall__(available287)
#endif
#ifdef __NR_available302
__syscall__(available302)
#endif
#ifdef __NR_available303
__syscall__(available303)
#endif
#ifdef __NR_available4
__syscall__(available4)
#endif
#ifdef __NR_available5
__syscall__(available5)
#endif
#ifdef __NR_available51
__syscall__(available51)
#endif
#ifdef __NR_available6
__syscall__(available6)
#endif
#ifdef __NR_available62
__syscall__(available62)
#endif
#ifdef __NR_available7
__syscall__(available7)
#endif
#ifdef __NR_available8
__syscall__(available8)
#endif
#ifdef __NR_available9
__syscall__(available9)
#endif
#ifdef __NR_bdflush
__syscall__(bdflush)
#endif
#ifdef __NR_bfin_spinlock
__syscall__(bfin_spinlock)
#endif
#ifdef __NR_bind
__syscall__(bind)
#endif
#ifdef __NR_break
__syscall__(break)
#endif
#ifdef __NR_brk
__syscall__(brk)
#endif
#ifdef __NR_cachectl
__syscall__(cachectl)
#endif
#ifdef __NR_cacheflush
__syscall__(cacheflush)
#endif
#ifdef __NR_capget
__syscall__(capget)
#endif
#ifdef __NR_capset
__syscall__(capset)
#endif
#ifdef __NR_chdir
__syscall__(chdir)
#endif
#ifdef __NR_chmod
__syscall__(chmod)
#endif
#ifdef __NR_chown
__syscall__(chown)
#endif
#ifdef __NR_chown32
__syscall__(chown32)
#endif
#ifdef __NR_chroot
__syscall__(chroot)
#endif
#ifdef __NR_clock_getres
__syscall__(clock_getres)
#endif
#ifdef __NR_clock_gettime
__syscall__(clock_gettime)
#endif
#ifdef __NR_clock_nanosleep
__syscall__(clock_nanosleep)
#endif
#ifdef __NR_clock_settime
__syscall__(clock_settime)
#endif
#ifdef __NR_clone
__syscall__(clone)
#endif
#ifdef __NR_clone2
__syscall__(clone2)
#endif
#ifdef __NR_close
__syscall__(close)
#endif
#ifdef __NR_cmpxchg_badaddr
__syscall__(cmpxchg_badaddr)
#endif
#ifdef __NR_connect
__syscall__(connect)
#endif
#ifdef __NR_creat
__syscall__(creat)
#endif
#ifdef __NR_create_module
__syscall__(create_module)
#endif
#ifdef __NR_delete_module
__syscall__(delete_module)
#endif
#ifdef __NR_dipc
__syscall__(dipc)
#endif
#ifdef __NR_dma_memcpy
__syscall__(dma_memcpy)
#endif
#ifdef __NR_dup
__syscall__(dup)
#endif
#ifdef __NR_dup2
__syscall__(dup2)
#endif
#ifdef __NR_dup3
__syscall__(dup3)
#endif
#ifdef __NR_epoll_create
__syscall__(epoll_create)
#endif
#ifdef __NR_epoll_create1
__syscall__(epoll_create1)
#endif
#ifdef __NR_epoll_ctl
__syscall__(epoll_ctl)
#endif
#ifdef __NR_epoll_ctl_old
__syscall__(epoll_ctl_old)
#endif
#ifdef __NR_epoll_pwait
__syscall__(epoll_pwait)
#endif
#ifdef __NR_epoll_wait
__syscall__(epoll_wait)
#endif
#ifdef __NR_epoll_wait_old
__syscall__(epoll_wait_old)
#endif
#ifdef __NR_eventfd
__syscall__(eventfd)
#endif
#ifdef __NR_eventfd2
__syscall__(eventfd2)
#endif
#ifdef __NR_exec_with_loader
__syscall__(exec_with_loader)
#endif
#ifdef __NR_execv
__syscall__(execv)
#endif
#ifdef __NR_execve
__syscall__(execve)
#endif
#ifdef __NR_exit
__syscall__(exit)
#endif
#ifdef __NR_exit_group
__syscall__(exit_group)
#endif
#ifdef __NR_faccessat
__syscall__(faccessat)
#endif
#ifdef __NR_fadvise64
__syscall__(fadvise64)
#endif
#ifdef __NR_fadvise64_64
__syscall__(fadvise64_64)
#endif
#ifdef __NR_fallocate
__syscall__(fallocate)
#endif
#ifdef __NR_fanotify_init
__syscall__(fanotify_init)
#endif
#ifdef __NR_fanotify_mark
__syscall__(fanotify_mark)
#endif
#ifdef __NR_fchdir
__syscall__(fchdir)
#endif
#ifdef __NR_fchmod
__syscall__(fchmod)
#endif
#ifdef __NR_fchmodat
__syscall__(fchmodat)
#endif
#ifdef __NR_fchown
__syscall__(fchown)
#endif
#ifdef __NR_fchown32
__syscall__(fchown32)
#endif
#ifdef __NR_fchownat
__syscall__(fchownat)
#endif
#ifdef __NR_fcntl
__syscall__(fcntl)
#endif
#ifdef __NR_fcntl64
__syscall__(fcntl64)
#endif
#ifdef __NR_fdatasync
__syscall__(fdatasync)
#endif
#ifdef __NR_fgetxattr
__syscall__(fgetxattr)
#endif
#ifdef __NR_flistxattr
__syscall__(flistxattr)
#endif
#ifdef __NR_flock
__syscall__(flock)
#endif
#ifdef __NR_flush_cache
__syscall__(flush_cache)
#endif
#ifdef __NR_fork
__syscall__(fork)
#endif
#ifdef __NR_free_hugepages
__syscall__(free_hugepages)
#endif
#ifdef __NR_fremovexattr
__syscall__(fremovexattr)
#endif
#ifdef __NR_fsetxattr
__syscall__(fsetxattr)
#endif
#ifdef __NR_fstat
__syscall__(fstat)
#endif
#ifdef __NR_fstat64
__syscall__(fstat64)
#endif
#ifdef __NR_fstatat64
__syscall__(fstatat64)
#endif
#ifdef __NR_fstatfs
__syscall__(fstatfs)
#endif
#ifdef __NR_fstatfs64
__syscall__(fstatfs64)
#endif
#ifdef __NR_fsync
__syscall__(fsync)
#endif
#ifdef __NR_ftime
__syscall__(ftime)
#endif
#ifdef __NR_ftruncate
__syscall__(ftruncate)
#endif
#ifdef __NR_ftruncate64
__syscall__(ftruncate64)
#endif
#ifdef __NR_futex
__syscall__(futex)
#endif
#ifdef __NR_futimesat
__syscall__(futimesat)
#endif
#ifdef __NR_get_kernel_syms
__syscall__(get_kernel_syms)
#endif
#ifdef __NR_get_mempolicy
__syscall__(get_mempolicy)
#endif
#ifdef __NR_get_robust_list
__syscall__(get_robust_list)
#endif
#ifdef __NR_get_thread_area
__syscall__(get_thread_area)
#endif
#ifdef __NR_getcpu
__syscall__(getcpu)
#endif
#ifdef __NR_getcwd
__syscall__(getcwd)
#endif
#ifdef __NR_getdents
__syscall__(getdents)
#endif
#ifdef __NR_getdents64
__syscall__(getdents64)
#endif
#ifdef __NR_getdomainname
__syscall__(getdomainname)
#endif
#ifdef __NR_getdtablesize
__syscall__(getdtablesize)
#endif
#ifdef __NR_getegid
__syscall__(getegid)
#endif
#ifdef __NR_getegid32
__syscall__(getegid32)
#endif
#ifdef __NR_geteuid
__syscall__(geteuid)
#endif
#ifdef __NR_geteuid32
__syscall__(geteuid32)
#endif
#ifdef __NR_getgid
__syscall__(getgid)
#endif
#ifdef __NR_getgid32
__syscall__(getgid32)
#endif
#ifdef __NR_getgroups
__syscall__(getgroups)
#endif
#ifdef __NR_getgroups32
__syscall__(getgroups32)
#endif
#ifdef __NR_gethostname
__syscall__(gethostname)
#endif
#ifdef __NR_getitimer
__syscall__(getitimer)
#endif
#ifdef __NR_getpagesize
__syscall__(getpagesize)
#endif
#ifdef __NR_getpeername
__syscall__(getpeername)
#endif
#ifdef __NR_getpgid
__syscall__(getpgid)
#endif
#ifdef __NR_getpgrp
__syscall__(getpgrp)
#endif
#ifdef __NR_getpid
__syscall__(getpid)
#endif
#ifdef __NR_getpmsg
__syscall__(getpmsg)
#endif
#ifdef __NR_getppid
__syscall__(getppid)
#endif
#ifdef __NR_getpriority
__syscall__(getpriority)
#endif
#ifdef __NR_getresgid
__syscall__(getresgid)
#endif
#ifdef __NR_getresgid32
__syscall__(getresgid32)
#endif
#ifdef __NR_getresuid
__syscall__(getresuid)
#endif
#ifdef __NR_getresuid32
__syscall__(getresuid32)
#endif
#ifdef __NR_getrlimit
__syscall__(getrlimit)
#endif
#ifdef __NR_getrusage
__syscall__(getrusage)
#endif
#ifdef __NR_getsid
__syscall__(getsid)
#endif
#ifdef __NR_getsockname
__syscall__(getsockname)
#endif
#ifdef __NR_getsockopt
__syscall__(getsockopt)
#endif
#ifdef __NR_gettid
__syscall__(gettid)
#endif
#ifdef __NR_gettimeofday
__syscall__(gettimeofday)
#endif
#ifdef __NR_getuid
__syscall__(getuid)
#endif
#ifdef __NR_getuid32
__syscall__(getuid32)
#endif
#ifdef __NR_getunwind
__syscall__(getunwind)
#endif
#ifdef __NR_getxattr
__syscall__(getxattr)
#endif
#ifdef __NR_getxgid
__syscall__(getxgid)
#endif
#ifdef __NR_getxpid
__syscall__(getxpid)
#endif
#ifdef __NR_getxuid
__syscall__(getxuid)
#endif
#ifdef __NR_gtty
__syscall__(gtty)
#endif
#ifdef __NR_idle
__syscall__(idle)
#endif
#ifdef __NR_init_module
__syscall__(init_module)
#endif
#ifdef __NR_inotify_add_watch
__syscall__(inotify_add_watch)
#endif
#ifdef __NR_inotify_init
__syscall__(inotify_init)
#endif
#ifdef __NR_inotify_init1
__syscall__(inotify_init1)
#endif
#ifdef __NR_inotify_rm_watch
__syscall__(inotify_rm_watch)
#endif
#ifdef __NR_io_cancel
__syscall__(io_cancel)
#endif
#ifdef __NR_io_destroy
__syscall__(io_destroy)
#endif
#ifdef __NR_io_getevents
__syscall__(io_getevents)
#endif
#ifdef __NR_io_setup
__syscall__(io_setup)
#endif
#ifdef __NR_io_submit
__syscall__(io_submit)
#endif
#ifdef __NR_ioctl
__syscall__(ioctl)
#endif
#ifdef __NR_ioperm
__syscall__(ioperm)
#endif
#ifdef __NR_iopl
__syscall__(iopl)
#endif
#ifdef __NR_ioprio_get
__syscall__(ioprio_get)
#endif
#ifdef __NR_ioprio_set
__syscall__(ioprio_set)
#endif
#ifdef __NR_ipc
__syscall__(ipc)
#endif
#ifdef __NR_kexec_load
__syscall__(kexec_load)
#endif
#ifdef __NR_keyctl
__syscall__(keyctl)
#endif
#ifdef __NR_kill
__syscall__(kill)
#endif
#ifdef __NR_lchown
__syscall__(lchown)
#endif
#ifdef __NR_lchown32
__syscall__(lchown32)
#endif
#ifdef __NR_lgetxattr
__syscall__(lgetxattr)
#endif
#ifdef __NR_link
__syscall__(link)
#endif
#ifdef __NR_linkat
__syscall__(linkat)
#endif
#ifdef __NR_listen
__syscall__(listen)
#endif
#ifdef __NR_listxattr
__syscall__(listxattr)
#endif
#ifdef __NR_llistxattr
__syscall__(llistxattr)
#endif
#ifdef __NR_lock
__syscall__(lock)
#endif
#ifdef __NR_lookup_dcookie
__syscall__(lookup_dcookie)
#endif
#ifdef __NR_lremovexattr
__syscall__(lremovexattr)
#endif
#ifdef __NR_lseek
__syscall__(lseek)
#endif
#ifdef __NR_lsetxattr
__syscall__(lsetxattr)
#endif
#ifdef __NR_lstat
__syscall__(lstat)
#endif
#ifdef __NR_lstat64
__syscall__(lstat64)
#endif
#ifdef __NR_madvise
__syscall__(madvise)
#endif
#ifdef __NR_madvise1
__syscall__(madvise1)
#endif
#ifdef __NR_mbind
__syscall__(mbind)
#endif
#ifdef __NR_memory_ordering
__syscall__(memory_ordering)
#endif
#ifdef __NR_migrate_pages
__syscall__(migrate_pages)
#endif
#ifdef __NR_mincore
__syscall__(mincore)
#endif
#ifdef __NR_mkdir
__syscall__(mkdir)
#endif
#ifdef __NR_mkdirat
__syscall__(mkdirat)
#endif
#ifdef __NR_mknod
__syscall__(mknod)
#endif
#ifdef __NR_mknodat
__syscall__(mknodat)
#endif
#ifdef __NR_mlock
__syscall__(mlock)
#endif
#ifdef __NR_mlockall
__syscall__(mlockall)
#endif
#ifdef __NR_mmap
__syscall__(mmap)
#endif
#ifdef __NR_mmap2
__syscall__(mmap2)
#endif
#ifdef __NR_modify_ldt
__syscall__(modify_ldt)
#endif
#ifdef __NR_mount
__syscall__(mount)
#endif
#ifdef __NR_move_pages
__syscall__(move_pages)
#endif
#ifdef __NR_mprotect
__syscall__(mprotect)
#endif
#ifdef __NR_mpx
__syscall__(mpx)
#endif
#ifdef __NR_mq_getsetattr
__syscall__(mq_getsetattr)
#endif
#ifdef __NR_mq_notify
__syscall__(mq_notify)
#endif
#ifdef __NR_mq_open
__syscall__(mq_open)
#endif
#ifdef __NR_mq_timedreceive
__syscall__(mq_timedreceive)
#endif
#ifdef __NR_mq_timedsend
__syscall__(mq_timedsend)
#endif
#ifdef __NR_mq_unlink
__syscall__(mq_unlink)
#endif
#ifdef __NR_mremap
__syscall__(mremap)
#endif
#ifdef __NR_msgctl
__syscall__(msgctl)
#endif
#ifdef __NR_msgget
__syscall__(msgget)
#endif
#ifdef __NR_msgrcv
__syscall__(msgrcv)
#endif
#ifdef __NR_msgsnd
__syscall__(msgsnd)
#endif
#ifdef __NR_msync
__syscall__(msync)
#endif
#ifdef __NR_multiplexer
__syscall__(multiplexer)
#endif
#ifdef __NR_munlock
__syscall__(munlock)
#endif
#ifdef __NR_munlockall
__syscall__(munlockall)
#endif
#ifdef __NR_munmap
__syscall__(munmap)
#endif
#ifdef __NR_nanosleep
__syscall__(nanosleep)
#endif
#ifdef __NR_newfstatat
__syscall__(newfstatat)
#endif
#ifdef __NR_nfsservctl
__syscall__(nfsservctl)
#endif
#ifdef __NR_ni_syscall
__syscall__(ni_syscall)
#endif
#ifdef __NR_nice
__syscall__(nice)
#endif
#ifdef __NR_old_adjtimex
__syscall__(old_adjtimex)
#endif
#ifdef __NR_oldfstat
__syscall__(oldfstat)
#endif
#ifdef __NR_oldlstat
__syscall__(oldlstat)
#endif
#ifdef __NR_oldolduname
__syscall__(oldolduname)
#endif
#ifdef __NR_oldstat
__syscall__(oldstat)
#endif
#ifdef __NR_oldumount
__syscall__(oldumount)
#endif
#ifdef __NR_olduname
__syscall__(olduname)
#endif
#ifdef __NR_open
__syscall__(open)
#endif
#ifdef __NR_openat
__syscall__(openat)
#endif
#ifdef __NR_osf_adjtime
__syscall__(osf_adjtime)
#endif
#ifdef __NR_osf_afs_syscall
__syscall__(osf_afs_syscall)
#endif
#ifdef __NR_osf_alt_plock
__syscall__(osf_alt_plock)
#endif
#ifdef __NR_osf_alt_setsid
__syscall__(osf_alt_setsid)
#endif
#ifdef __NR_osf_alt_sigpending
__syscall__(osf_alt_sigpending)
#endif
#ifdef __NR_osf_asynch_daemon
__syscall__(osf_asynch_daemon)
#endif
#ifdef __NR_osf_audcntl
__syscall__(osf_audcntl)
#endif
#ifdef __NR_osf_audgen
__syscall__(osf_audgen)
#endif
#ifdef __NR_osf_chflags
__syscall__(osf_chflags)
#endif
#ifdef __NR_osf_execve
__syscall__(osf_execve)
#endif
#ifdef __NR_osf_exportfs
__syscall__(osf_exportfs)
#endif
#ifdef __NR_osf_fchflags
__syscall__(osf_fchflags)
#endif
#ifdef __NR_osf_fdatasync
__syscall__(osf_fdatasync)
#endif
#ifdef __NR_osf_fpathconf
__syscall__(osf_fpathconf)
#endif
#ifdef __NR_osf_fstatfs
__syscall__(osf_fstatfs)
#endif
#ifdef __NR_osf_fuser
__syscall__(osf_fuser)
#endif
#ifdef __NR_osf_getaddressconf
__syscall__(osf_getaddressconf)
#endif
#ifdef __NR_osf_getdirentries
__syscall__(osf_getdirentries)
#endif
#ifdef __NR_osf_getdomainname
__syscall__(osf_getdomainname)
#endif
#ifdef __NR_osf_getfh
__syscall__(osf_getfh)
#endif
#ifdef __NR_osf_getfsstat
__syscall__(osf_getfsstat)
#endif
#ifdef __NR_osf_gethostid
__syscall__(osf_gethostid)
#endif
#ifdef __NR_osf_getitimer
__syscall__(osf_getitimer)
#endif
#ifdef __NR_osf_getlogin
__syscall__(osf_getlogin)
#endif
#ifdef __NR_osf_getmnt
__syscall__(osf_getmnt)
#endif
#ifdef __NR_osf_getrusage
__syscall__(osf_getrusage)
#endif
#ifdef __NR_osf_getsysinfo
__syscall__(osf_getsysinfo)
#endif
#ifdef __NR_osf_gettimeofday
__syscall__(osf_gettimeofday)
#endif
#ifdef __NR_osf_kloadcall
__syscall__(osf_kloadcall)
#endif
#ifdef __NR_osf_kmodcall
__syscall__(osf_kmodcall)
#endif
#ifdef __NR_osf_memcntl
__syscall__(osf_memcntl)
#endif
#ifdef __NR_osf_mincore
__syscall__(osf_mincore)
#endif
#ifdef __NR_osf_mount
__syscall__(osf_mount)
#endif
#ifdef __NR_osf_mremap
__syscall__(osf_mremap)
#endif
#ifdef __NR_osf_msfs_syscall
__syscall__(osf_msfs_syscall)
#endif
#ifdef __NR_osf_msleep
__syscall__(osf_msleep)
#endif
#ifdef __NR_osf_mvalid
__syscall__(osf_mvalid)
#endif
#ifdef __NR_osf_mwakeup
__syscall__(osf_mwakeup)
#endif
#ifdef __NR_osf_naccept
__syscall__(osf_naccept)
#endif
#ifdef __NR_osf_nfssvc
__syscall__(osf_nfssvc)
#endif
#ifdef __NR_osf_ngetpeername
__syscall__(osf_ngetpeername)
#endif
#ifdef __NR_osf_ngetsockname
__syscall__(osf_ngetsockname)
#endif
#ifdef __NR_osf_nrecvfrom
__syscall__(osf_nrecvfrom)
#endif
#ifdef __NR_osf_nrecvmsg
__syscall__(osf_nrecvmsg)
#endif
#ifdef __NR_osf_nsendmsg
__syscall__(osf_nsendmsg)
#endif
#ifdef __NR_osf_ntp_adjtime
__syscall__(osf_ntp_adjtime)
#endif
#ifdef __NR_osf_ntp_gettime
__syscall__(osf_ntp_gettime)
#endif
#ifdef __NR_osf_old_creat
__syscall__(osf_old_creat)
#endif
#ifdef __NR_osf_old_fstat
__syscall__(osf_old_fstat)
#endif
#ifdef __NR_osf_old_getpgrp
__syscall__(osf_old_getpgrp)
#endif
#ifdef __NR_osf_old_killpg
__syscall__(osf_old_killpg)
#endif
#ifdef __NR_osf_old_lstat
__syscall__(osf_old_lstat)
#endif
#ifdef __NR_osf_old_open
__syscall__(osf_old_open)
#endif
#ifdef __NR_osf_old_sigaction
__syscall__(osf_old_sigaction)
#endif
#ifdef __NR_osf_old_sigblock
__syscall__(osf_old_sigblock)
#endif
#ifdef __NR_osf_old_sigreturn
__syscall__(osf_old_sigreturn)
#endif
#ifdef __NR_osf_old_sigsetmask
__syscall__(osf_old_sigsetmask)
#endif
#ifdef __NR_osf_old_sigvec
__syscall__(osf_old_sigvec)
#endif
#ifdef __NR_osf_old_stat
__syscall__(osf_old_stat)
#endif
#ifdef __NR_osf_old_vadvise
__syscall__(osf_old_vadvise)
#endif
#ifdef __NR_osf_old_vtrace
__syscall__(osf_old_vtrace)
#endif
#ifdef __NR_osf_old_wait
__syscall__(osf_old_wait)
#endif
#ifdef __NR_osf_oldquota
__syscall__(osf_oldquota)
#endif
#ifdef __NR_osf_pathconf
__syscall__(osf_pathconf)
#endif
#ifdef __NR_osf_pid_block
__syscall__(osf_pid_block)
#endif
#ifdef __NR_osf_pid_unblock
__syscall__(osf_pid_unblock)
#endif
#ifdef __NR_osf_plock
__syscall__(osf_plock)
#endif
#ifdef __NR_osf_priocntlset
__syscall__(osf_priocntlset)
#endif
#ifdef __NR_osf_profil
__syscall__(osf_profil)
#endif
#ifdef __NR_osf_proplist_syscall
__syscall__(osf_proplist_syscall)
#endif
#ifdef __NR_osf_reboot
__syscall__(osf_reboot)
#endif
#ifdef __NR_osf_revoke
__syscall__(osf_revoke)
#endif
#ifdef __NR_osf_sbrk
__syscall__(osf_sbrk)
#endif
#ifdef __NR_osf_security
__syscall__(osf_security)
#endif
#ifdef __NR_osf_select
__syscall__(osf_select)
#endif
#ifdef __NR_osf_set_program_attributes
__syscall__(osf_set_program_attributes)
#endif
#ifdef __NR_osf_set_speculative
__syscall__(osf_set_speculative)
#endif
#ifdef __NR_osf_sethostid
__syscall__(osf_sethostid)
#endif
#ifdef __NR_osf_setitimer
__syscall__(osf_setitimer)
#endif
#ifdef __NR_osf_setlogin
__syscall__(osf_setlogin)
#endif
#ifdef __NR_osf_setsysinfo
__syscall__(osf_setsysinfo)
#endif
#ifdef __NR_osf_settimeofday
__syscall__(osf_settimeofday)
#endif
#ifdef __NR_osf_shmat
__syscall__(osf_shmat)
#endif
#ifdef __NR_osf_signal
__syscall__(osf_signal)
#endif
#ifdef __NR_osf_sigprocmask
__syscall__(osf_sigprocmask)
#endif
#ifdef __NR_osf_sigsendset
__syscall__(osf_sigsendset)
#endif
#ifdef __NR_osf_sigstack
__syscall__(osf_sigstack)
#endif
#ifdef __NR_osf_sigwaitprim
__syscall__(osf_sigwaitprim)
#endif
#ifdef __NR_osf_sstk
__syscall__(osf_sstk)
#endif
#ifdef __NR_osf_statfs
__syscall__(osf_statfs)
#endif
#ifdef __NR_osf_subsys_info
__syscall__(osf_subsys_info)
#endif
#ifdef __NR_osf_swapctl
__syscall__(osf_swapctl)
#endif
#ifdef __NR_osf_swapon
__syscall__(osf_swapon)
#endif
#ifdef __NR_osf_syscall
__syscall__(osf_syscall)
#endif
#ifdef __NR_osf_sysinfo
__syscall__(osf_sysinfo)
#endif
#ifdef __NR_osf_table
__syscall__(osf_table)
#endif
#ifdef __NR_osf_uadmin
__syscall__(osf_uadmin)
#endif
#ifdef __NR_osf_usleep_thread
__syscall__(osf_usleep_thread)
#endif
#ifdef __NR_osf_uswitch
__syscall__(osf_uswitch)
#endif
#ifdef __NR_osf_utc_adjtime
__syscall__(osf_utc_adjtime)
#endif
#ifdef __NR_osf_utc_gettime
__syscall__(osf_utc_gettime)
#endif
#ifdef __NR_osf_utimes
__syscall__(osf_utimes)
#endif
#ifdef __NR_osf_utsname
__syscall__(osf_utsname)
#endif
#ifdef __NR_osf_wait4
__syscall__(osf_wait4)
#endif
#ifdef __NR_osf_waitid
__syscall__(osf_waitid)
#endif
#ifdef __NR_pause
__syscall__(pause)
#endif
#ifdef __NR_pciconfig_iobase
__syscall__(pciconfig_iobase)
#endif
#ifdef __NR_pciconfig_read
__syscall__(pciconfig_read)
#endif
#ifdef __NR_pciconfig_write
__syscall__(pciconfig_write)
#endif
#ifdef __NR_perf_event_open
__syscall__(perf_event_open)
#endif
#ifdef __NR_perfctr
__syscall__(perfctr)
#endif
#ifdef __NR_perfmonctl
__syscall__(perfmonctl)
#endif
#ifdef __NR_personality
__syscall__(personality)
#endif
#ifdef __NR_pipe
__syscall__(pipe)
#endif
#ifdef __NR_pipe2
__syscall__(pipe2)
#endif
#ifdef __NR_pivot_root
__syscall__(pivot_root)
#endif
#ifdef __NR_poll
__syscall__(poll)
#endif
#ifdef __NR_ppoll
__syscall__(ppoll)
#endif
#ifdef __NR_prctl
__syscall__(prctl)
#endif
#ifdef __NR_pread
__syscall__(pread)
#endif
#ifdef __NR_pread64
__syscall__(pread64)
#endif
#ifdef __NR_preadv
__syscall__(preadv)
#endif
#ifdef __NR_prlimit64
__syscall__(prlimit64)
#endif
#ifdef __NR_prof
__syscall__(prof)
#endif
#ifdef __NR_profil
__syscall__(profil)
#endif
#ifdef __NR_pselect6
__syscall__(pselect6)
#endif
#ifdef __NR_ptrace
__syscall__(ptrace)
#endif
#ifdef __NR_putpmsg
__syscall__(putpmsg)
#endif
#ifdef __NR_pwrite
__syscall__(pwrite)
#endif
#ifdef __NR_pwrite64
__syscall__(pwrite64)
#endif
#ifdef __NR_pwritev
__syscall__(pwritev)
#endif
#ifdef __NR_query_module
__syscall__(query_module)
#endif
#ifdef __NR_quotactl
__syscall__(quotactl)
#endif
#ifdef __NR_read
__syscall__(read)
#endif
#ifdef __NR_readahead
__syscall__(readahead)
#endif
#ifdef __NR_readdir
__syscall__(readdir)
#endif
#ifdef __NR_readlink
__syscall__(readlink)
#endif
#ifdef __NR_readlinkat
__syscall__(readlinkat)
#endif
#ifdef __NR_readv
__syscall__(readv)
#endif
#ifdef __NR_reboot
__syscall__(reboot)
#endif
#ifdef __NR_recv
__syscall__(recv)
#endif
#ifdef __NR_recvfrom
__syscall__(recvfrom)
#endif
#ifdef __NR_recvmmsg
__syscall__(recvmmsg)
#endif
#ifdef __NR_recvmsg
__syscall__(recvmsg)
#endif
#ifdef __NR_remap_file_pages
__syscall__(remap_file_pages)
#endif
#ifdef __NR_removexattr
__syscall__(removexattr)
#endif
#ifdef __NR_rename
__syscall__(rename)
#endif
#ifdef __NR_renameat
__syscall__(renameat)
#endif
#ifdef __NR_request_key
__syscall__(request_key)
#endif
#ifdef __NR_reserved152
__syscall__(reserved152)
#endif
#ifdef __NR_reserved153
__syscall__(reserved153)
#endif
#ifdef __NR_reserved177
__syscall__(reserved177)
#endif
#ifdef __NR_reserved193
__syscall__(reserved193)
#endif
#ifdef __NR_reserved221
__syscall__(reserved221)
#endif
#ifdef __NR_reserved244
__syscall__(reserved244)
#endif
#ifdef __NR_reserved286
__syscall__(reserved286)
#endif
#ifdef __NR_reserved82
__syscall__(reserved82)
#endif
#ifdef __NR_restart_syscall
__syscall__(restart_syscall)
#endif
#ifdef __NR_rmdir
__syscall__(rmdir)
#endif
#ifdef __NR_rt_sigaction
__syscall__(rt_sigaction)
#endif
#ifdef __NR_rt_sigpending
__syscall__(rt_sigpending)
#endif
#ifdef __NR_rt_sigprocmask
__syscall__(rt_sigprocmask)
#endif
#ifdef __NR_rt_sigqueueinfo
__syscall__(rt_sigqueueinfo)
#endif
#ifdef __NR_rt_sigreturn
__syscall__(rt_sigreturn)
#endif
#ifdef __NR_rt_sigsuspend
__syscall__(rt_sigsuspend)
#endif
#ifdef __NR_rt_sigtimedwait
__syscall__(rt_sigtimedwait)
#endif
#ifdef __NR_rt_tgsigqueueinfo
__syscall__(rt_tgsigqueueinfo)
#endif
#ifdef __NR_rtas
__syscall__(rtas)
#endif
#ifdef __NR_sched_get_affinity
__syscall__(sched_get_affinity)
#endif
#ifdef __NR_sched_get_priority_max
__syscall__(sched_get_priority_max)
#endif
#ifdef __NR_sched_get_priority_min
__syscall__(sched_get_priority_min)
#endif
#ifdef __NR_sched_getaffinity
__syscall__(sched_getaffinity)
#endif
#ifdef __NR_sched_getparam
__syscall__(sched_getparam)
#endif
#ifdef __NR_sched_getscheduler
__syscall__(sched_getscheduler)
#endif
#ifdef __NR_sched_rr_get_interval
__syscall__(sched_rr_get_interval)
#endif
#ifdef __NR_sched_set_affinity
__syscall__(sched_set_affinity)
#endif
#ifdef __NR_sched_setaffinity
__syscall__(sched_setaffinity)
#endif
#ifdef __NR_sched_setparam
__syscall__(sched_setparam)
#endif
#ifdef __NR_sched_setscheduler
__syscall__(sched_setscheduler)
#endif
#ifdef __NR_sched_yield
__syscall__(sched_yield)
#endif
#ifdef __NR_security
__syscall__(security)
#endif
#ifdef __NR_select
__syscall__(select)
#endif
#ifdef __NR_semctl
__syscall__(semctl)
#endif
#ifdef __NR_semget
__syscall__(semget)
#endif
#ifdef __NR_semop
__syscall__(semop)
#endif
#ifdef __NR_semtimedop
__syscall__(semtimedop)
#endif
#ifdef __NR_send
__syscall__(send)
#endif
#ifdef __NR_sendfile
__syscall__(sendfile)
#endif
#ifdef __NR_sendfile64
__syscall__(sendfile64)
#endif
#ifdef __NR_sendmsg
__syscall__(sendmsg)
#endif
#ifdef __NR_sendto
__syscall__(sendto)
#endif
#ifdef __NR_set_mempolicy
__syscall__(set_mempolicy)
#endif
#ifdef __NR_set_robust_list
__syscall__(set_robust_list)
#endif
#ifdef __NR_set_thread_area
__syscall__(set_thread_area)
#endif
#ifdef __NR_set_tid_address
__syscall__(set_tid_address)
#endif
#ifdef __NR_setdomainname
__syscall__(setdomainname)
#endif
#ifdef __NR_setfsgid
__syscall__(setfsgid)
#endif
#ifdef __NR_setfsgid32
__syscall__(setfsgid32)
#endif
#ifdef __NR_setfsuid
__syscall__(setfsuid)
#endif
#ifdef __NR_setfsuid32
__syscall__(setfsuid32)
#endif
#ifdef __NR_setgid
__syscall__(setgid)
#endif
#ifdef __NR_setgid32
__syscall__(setgid32)
#endif
#ifdef __NR_setgroups
__syscall__(setgroups)
#endif
#ifdef __NR_setgroups32
__syscall__(setgroups32)
#endif
#ifdef __NR_sethae
__syscall__(sethae)
#endif
#ifdef __NR_sethostname
__syscall__(sethostname)
#endif
#ifdef __NR_setitimer
__syscall__(setitimer)
#endif
#ifdef __NR_setpgid
__syscall__(setpgid)
#endif
#ifdef __NR_setpgrp
__syscall__(setpgrp)
#endif
#ifdef __NR_setpriority
__syscall__(setpriority)
#endif
#ifdef __NR_setregid
__syscall__(setregid)
#endif
#ifdef __NR_setregid32
__syscall__(setregid32)
#endif
#ifdef __NR_setresgid
__syscall__(setresgid)
#endif
#ifdef __NR_setresgid32
__syscall__(setresgid32)
#endif
#ifdef __NR_setresuid
__syscall__(setresuid)
#endif
#ifdef __NR_setresuid32
__syscall__(setresuid32)
#endif
#ifdef __NR_setreuid
__syscall__(setreuid)
#endif
#ifdef __NR_setreuid32
__syscall__(setreuid32)
#endif
#ifdef __NR_setrlimit
__syscall__(setrlimit)
#endif
#ifdef __NR_setsid
__syscall__(setsid)
#endif
#ifdef __NR_setsockopt
__syscall__(setsockopt)
#endif
#ifdef __NR_settimeofday
__syscall__(settimeofday)
#endif
#ifdef __NR_setuid
__syscall__(setuid)
#endif
#ifdef __NR_setuid32
__syscall__(setuid32)
#endif
#ifdef __NR_setxattr
__syscall__(setxattr)
#endif
#ifdef __NR_sgetmask
__syscall__(sgetmask)
#endif
#ifdef __NR_shmat
__syscall__(shmat)
#endif
#ifdef __NR_shmatcall
__syscall__(shmatcall)
#endif
#ifdef __NR_shmctl
__syscall__(shmctl)
#endif
#ifdef __NR_shmdt
__syscall__(shmdt)
#endif
#ifdef __NR_shmget
__syscall__(shmget)
#endif
#ifdef __NR_shutdown
__syscall__(shutdown)
#endif
#ifdef __NR_sigaction
__syscall__(sigaction)
#endif
#ifdef __NR_sigaltstack
__syscall__(sigaltstack)
#endif
#ifdef __NR_signal
__syscall__(signal)
#endif
#ifdef __NR_signalfd
__syscall__(signalfd)
#endif
#ifdef __NR_signalfd4
__syscall__(signalfd4)
#endif
#ifdef __NR_sigpending
__syscall__(sigpending)
#endif
#ifdef __NR_sigprocmask
__syscall__(sigprocmask)
#endif
#ifdef __NR_sigreturn
__syscall__(sigreturn)
#endif
#ifdef __NR_sigsuspend
__syscall__(sigsuspend)
#endif
#ifdef __NR_socket
__syscall__(socket)
#endif
#ifdef __NR_socketcall
__syscall__(socketcall)
#endif
#ifdef __NR_socketpair
__syscall__(socketpair)
#endif
#ifdef __NR_spill
__syscall__(spill)
#endif
#ifdef __NR_splice
__syscall__(splice)
#endif
#ifdef __NR_spu_create
__syscall__(spu_create)
#endif
#ifdef __NR_spu_run
__syscall__(spu_run)
#endif
#ifdef __NR_sram_alloc
__syscall__(sram_alloc)
#endif
#ifdef __NR_sram_free
__syscall__(sram_free)
#endif
#ifdef __NR_ssetmask
__syscall__(ssetmask)
#endif
#ifdef __NR_stat
__syscall__(stat)
#endif
#ifdef __NR_stat64
__syscall__(stat64)
#endif
#ifdef __NR_statfs
__syscall__(statfs)
#endif
#ifdef __NR_statfs64
__syscall__(statfs64)
#endif
#ifdef __NR_stime
__syscall__(stime)
#endif
#ifdef __NR_streams1
__syscall__(streams1)
#endif
#ifdef __NR_streams2
__syscall__(streams2)
#endif
#ifdef __NR_stty
__syscall__(stty)
#endif
#ifdef __NR_subpage_prot
__syscall__(subpage_prot)
#endif
#ifdef __NR_swapcontext
__syscall__(swapcontext)
#endif
#ifdef __NR_swapoff
__syscall__(swapoff)
#endif
#ifdef __NR_swapon
__syscall__(swapon)
#endif
#ifdef __NR_symlink
__syscall__(symlink)
#endif
#ifdef __NR_symlinkat
__syscall__(symlinkat)
#endif
#ifdef __NR_sync
__syscall__(sync)
#endif
#ifdef __NR_sync_file_range
__syscall__(sync_file_range)
#endif
#ifdef __NR_sync_file_range2
__syscall__(sync_file_range2)
#endif
#ifdef __NR_sys_debug_setcontext
__syscall__(sys_debug_setcontext)
#endif
#ifdef __NR_sys_epoll_create
__syscall__(sys_epoll_create)
#endif
#ifdef __NR_sys_epoll_ctl
__syscall__(sys_epoll_ctl)
#endif
#ifdef __NR_sys_epoll_wait
__syscall__(sys_epoll_wait)
#endif
#ifdef __NR_syscall
__syscall__(syscall)
#endif
#ifdef __NR_syscall_count
__syscall__(syscall_count)
#endif
#ifdef __NR_syscalls
__syscall__(syscalls)
#endif
#ifdef __NR_sysfs
__syscall__(sysfs)
#endif
#ifdef __NR_sysinfo
__syscall__(sysinfo)
#endif
#ifdef __NR_syslog
__syscall__(syslog)
#endif
#ifdef __NR_sysmips
__syscall__(sysmips)
#endif
#ifdef __NR_tas
__syscall__(tas)
#endif
#ifdef __NR_tee
__syscall__(tee)
#endif
#ifdef __NR_tgkill
__syscall__(tgkill)
#endif
#ifdef __NR_time
__syscall__(time)
#endif
#ifdef __NR_timer_create
__syscall__(timer_create)
#endif
#ifdef __NR_timer_delete
__syscall__(timer_delete)
#endif
#ifdef __NR_timer_getoverrun
__syscall__(timer_getoverrun)
#endif
#ifdef __NR_timer_gettime
__syscall__(timer_gettime)
#endif
#ifdef __NR_timer_settime
__syscall__(timer_settime)
#endif
#ifdef __NR_timerfd
__syscall__(timerfd)
#endif
#ifdef __NR_timerfd_create
__syscall__(timerfd_create)
#endif
#ifdef __NR_timerfd_gettime
__syscall__(timerfd_gettime)
#endif
#ifdef __NR_timerfd_settime
__syscall__(timerfd_settime)
#endif
#ifdef __NR_times
__syscall__(times)
#endif
#ifdef __NR_tkill
__syscall__(tkill)
#endif
#ifdef __NR_truncate
__syscall__(truncate)
#endif
#ifdef __NR_truncate64
__syscall__(truncate64)
#endif
#ifdef __NR_tuxcall
__syscall__(tuxcall)
#endif
#ifdef __NR_ugetrlimit
__syscall__(ugetrlimit)
#endif
#ifdef __NR_ulimit
__syscall__(ulimit)
#endif
#ifdef __NR_umask
__syscall__(umask)
#endif
#ifdef __NR_umount
__syscall__(umount)
#endif
#ifdef __NR_umount2
__syscall__(umount2)
#endif
#ifdef __NR_uname
__syscall__(uname)
#endif
#ifdef __NR_unlink
__syscall__(unlink)
#endif
#ifdef __NR_unlinkat
__syscall__(unlinkat)
#endif
#ifdef __NR_unshare
__syscall__(unshare)
#endif
#ifdef __NR_unused109
__syscall__(unused109)
#endif
#ifdef __NR_unused150
__syscall__(unused150)
#endif
#ifdef __NR_unused18
__syscall__(unused18)
#endif
#ifdef __NR_unused28
__syscall__(unused28)
#endif
#ifdef __NR_unused59
__syscall__(unused59)
#endif
#ifdef __NR_unused84
__syscall__(unused84)
#endif
#ifdef __NR_uselib
__syscall__(uselib)
#endif
#ifdef __NR_ustat
__syscall__(ustat)
#endif
#ifdef __NR_utime
__syscall__(utime)
#endif
#ifdef __NR_utimensat
__syscall__(utimensat)
#endif
#ifdef __NR_utimes
__syscall__(utimes)
#endif
#ifdef __NR_utrap_install
__syscall__(utrap_install)
#endif
#ifdef __NR_vfork
__syscall__(vfork)
#endif
#ifdef __NR_vhangup
__syscall__(vhangup)
#endif
#ifdef __NR_vm86
__syscall__(vm86)
#endif
#ifdef __NR_vm86old
__syscall__(vm86old)
#endif
#ifdef __NR_vmsplice
__syscall__(vmsplice)
#endif
#ifdef __NR_vserver
__syscall__(vserver)
#endif
#ifdef __NR_wait4
__syscall__(wait4)
#endif
#ifdef __NR_waitid
__syscall__(waitid)
#endif
#ifdef __NR_waitpid
__syscall__(waitpid)
#endif
#ifdef __NR_write
__syscall__(write)
#endif
#ifdef __NR_writev
__syscall__(writev)
#endif
#ifdef __NR_xtensa
__syscall__(xtensa)
#endif
