/*
 * process.h - interface definition for process.c
 * Copyright (C) 2005 - 2011 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _PROCESS_H
#define _PROCESS_H

static const char rcsid_process_h[] = "@(#) $Id: process.h,v 1.21 2011/04/09 18:42:49 michael Exp $";

struct path {
	char *name;
	unsigned hash;
	unsigned flags;
#define PATH_NOBACKUP	(1u << 0)
#define PATH_IGNORE		(1u << 1)
	struct path *next;
	struct path *pdir;
};

struct pstate {
	pid_t pid;
	long flags;
#define PROCESS_INSYSCALL	(1u << 0)
#define PROCESS_NEWFILE		(1u << 1)
#define PROCESS_SIGRETURN	(1u << 2)
#define PROCESS_EXEC		(1u << 3)
	struct path *name;
	struct path *path;
	struct path *path2;
	struct pstate *next;
};

extern struct pstate *find_process(pid_t __pid, int __attach);
extern void remove_process(struct pstate *__p);
extern struct path *add_path(const char *__path);
extern void ignore_path(const char *__path);

extern void forking_process(struct pstate *__p, int __start);
extern struct pstate *find_parent(struct pstate *__p);
extern void cancel_forking(struct pstate *__p);

extern void generic_syscall(struct pstate *__p, int __enter);

extern int run_first_process(char **__argv);

extern void vfork_warn(const struct pstate *__p);

#endif /* _PROCESS_H */
