/*
 * myptrace.h - interface definition for myptrace.c
 * Copyright (C) 2005 - 2009 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _MYPTRACE_H
#define _MYPTRACE_H

static const char rcsid_myptrace_h[] = "@(#) $Id: myptrace.h,v 1.7 2011/03/04 23:15:09 michael Exp $";

/* low-level */

extern void myptrace(int __what, pid_t __pid, long __addr, long __data);
extern void myptrace_reason(const char *__reason);

/* mid-level */

extern int peek_user(pid_t __pid, long __addr, long *__data);
extern int peek_data(pid_t __pid, long __addr, long *__data);
extern int peek_text(pid_t __pid, long __addr, long *__data);
extern void poke_user(pid_t __pid, long __addr, long __data);
extern void poke_data(pid_t __pid, long __addr, long __data);
extern void poke_text(pid_t __pid, long __addr, long __data);

extern int getregs(pid_t __pid, void *__regs);
extern int setregs(pid_t __pid, const void *__regs);

/* high-level */

extern long peek_user_safe(pid_t __pid, long __addr);
extern long peek_data_safe(pid_t __pid, long __addr);
extern long peek_text_safe(pid_t __pid, long __addr);
extern char *peek_string(pid_t __pid, long __addr);
extern int ptrace_traceme(void);

#endif /* _MYPTRACE_H */
