/*
 * i386.h - 32-bit specific definitions
 * Copyright (C) 2008 - 2009 Michael Riepe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _I386_H
#define _I386_H

static const char rcsid_i386_h[] = "@(#) $Id: i386.h,v 1.3 2009/03/25 16:23:59 michael Exp $";

/*
 * No matter how the kernel may be configured, we always need the
 * 32-bit <unistd.h>.  Besides that, we have to adapt to the "unified
 * architecture" changes in Linux 2.6.24...
 */

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24)

#include <asm/unistd_32.h>

#else /* LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 24) */

#include <asm-i386/unistd.h>

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 24) */

#include <sys/user.h>

#if defined(__i386__)

#define __nr    orig_eax
#define __a1    ebx
#define __a2    ecx
#define __a3    edx
#define __a4    esi
#define __a5    edi
#define __res   eax
#define __ip    eip
#define __cs    xcs

#elif defined(__x86_64__)

#define __nr	orig_rax
#define __a1	rbx
#define __a2	rcx
#define __a3	rdx
#define __a4	rsi
#define __a5	rdi
#define __res	rax
#define __ip	rip
#define __cs	cs

#endif /* defined(__i386__) */

#endif /* _I386_H */
