/*
 * error.h - interface definition for error.c
 * Copyright (C) 1995 - 2008 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _ERROR_H
#define _ERROR_H

static const char rcsid_error_h[] = "@(#) $Id: error.h,v 1.1 2008/05/12 10:29:45 michael Exp $";

extern void setprogname(const char *__name);

extern void warn(const char *__msg, ...);
extern void error(const char *__msg, ...);
extern void fatal(const char *__msg, ...);

extern void file_warn(const char *__fn, const char *__msg, ...);
extern void file_error(const char *__fn, const char *__msg, ...);
extern void file_fatal(const char *__fn, const char *__msg, ...);

#endif /* _ERROR_H */
