/*
 * cpio.h - interface definition for cpio.c
 * Copyright (C) 2005 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CPIO_H
#define _CPIO_H

static const char rcsid_cpio_h[] = "@(#) $Id: cpio.h,v 1.2 2005/07/08 17:14:56 michael Exp $";

extern int cpio_fd;

extern void cpio_write_header(struct stat *__stp, const char *__path);
extern void cpio_write_data(struct stat *__stp, const char *__path);
extern void cpio_write_link(struct stat *__stp, const char *__path);
extern void cpio_write_node(struct stat *__stp, const char *__path);
extern void cpio_write_trailer(void);

#endif /* _CPIO_H */
