/*
 * arm.h - ARM specific definitions
 * Copyright (C) 2008 - 2011 Michael Riepe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _ARM_H
#define _ARM_H

static const char rcsid_arm_h[] = "@(#) $Id: arm.h,v 1.1 2011/03/04 23:15:09 michael Exp $";

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24)

#include <asm/unistd.h>

#else /* LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 24) */

#include <asm-arm/unistd.h>

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 24) */

#include <sys/user.h>

#define __nr    uregs[7]
#define __a1    uregs[17]
#define __a2    uregs[1]
#define __a3    uregs[2]
#define __a4    uregs[3]
#define __a5    uregs[4]
#define __res   uregs[0]
#define __ip    uregs[15]

#endif /* _ARM_H */
