/*
 * action.h - trackfs action routines
 * Copyright (C) 2005 - 2008 Michael Riepe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _ACTION_H
#define _ACTION_H

static const char rcsid_action_h[] = "@(#) $Id: action.h,v 1.7 2011/04/18 22:34:29 michael Exp $";

struct action {
	int type;
#define ACTION_NONE		0
#define ACTION_CREATE	1
#define ACTION_UPDATE	2
#define ACTION_DELETE	3
#define ACTION_EXEC		4
#define ACTION_READ		5
	struct path *path;
	struct action *next;
};

extern void action_print(FILE *fp, const struct action *a);
extern void action(int what, struct path *path);
extern void action_report(FILE *fp);
extern struct path *translate_path(struct pstate *p, int base, long addr, int followsymlinks);
extern struct path *translate_fd(struct pstate *p, int fd);
extern void backup_file(struct pstate *p, struct path *path);
extern void backup_node(struct pstate *p, struct path *path);
extern void report_file(struct pstate *p, struct path *path);
extern void report_move(struct pstate *p, struct path *path, struct path *path2);
extern void report_node(struct pstate *p, struct path *path);
extern void report_read(struct pstate *p, struct path *path);
extern void report_remove(struct pstate *p, struct path *path);

#endif /* _ACTION_H */
