# aclocal.m4 - Local additions to Autoconf macros.
# Copyright (C) 1995 - 2005 Michael Riepe
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

rcsid='@(#) $Id: aclocal.m4,v 1.1 2005/07/04 13:30:17 michael Exp $'

AC_PREREQ(2.13)

dnl mr_PACKAGE(package-name)
AC_DEFUN(mr_PACKAGE, [changequote(<<, >>)dnl
  changequote([, ])dnl
  PACKAGE=$1
  VERSION=`cat $srcdir/VERSION`
  AC_SUBST(PACKAGE)
  AC_SUBST(VERSION)
  AC_ARG_ENABLE(maintainer-mode,
    [  --enable-maintainer-mode
                          enable maintainer-specific make rules (default: auto)],
    [mr_enable_maintainer_mode="$enableval"],
    [case :${I_AM_THE_MAINTAINER_OF}: in
      *:$1:*) mr_enable_maintainer_mode=yes;;
      *) mr_enable_maintainer_mode=no;;
    esac])
  if test x"$mr_enable_maintainer_mode" = x"yes"; then
    MAINT=
  else
    MAINT='maintainer-only-'
  fi
  AC_SUBST(MAINT)
])

# vi: set ts=8 sw=2 :
