#include "list/list.h"
#include "tap/tap.h"
#include "list/list.c"

struct parent {
	const char *name;
	struct list_head children;
	unsigned int num_children;
};

struct child {
	const char *name;
	struct list_node list;
};

static LIST_HEAD(static_list);

int main(int argc, char *argv[])
{
	struct parent parent;
	struct child c1, c2, c3, *c, *n;
	unsigned int i;

	plan_tests(41);
	/* Test LIST_HEAD, list_empty and check_list */
	ok1(list_empty(&static_list));
	ok1(list_check(&static_list, NULL));

	parent.num_children = 0;
	list_head_init(&parent.children);
	/* Test list_head_init */
	ok1(list_empty(&parent.children));
	ok1(list_check(&parent.children, NULL));

	c2.name = "c2";
	list_add(&parent.children, &c2.list);
	/* Test list_add and !list_empty. */
	ok1(!list_empty(&parent.children));
	ok1(c2.list.next == &parent.children.n);
	ok1(c2.list.prev == &parent.children.n);
	ok1(parent.children.n.next == &c2.list);
	ok1(parent.children.n.prev == &c2.list);
	/* Test list_check */
	ok1(list_check(&parent.children, NULL));

	c1.name = "c1";
	list_add(&parent.children, &c1.list);
	/* Test list_add and !list_empty. */
	ok1(!list_empty(&parent.children));
	ok1(c2.list.next == &parent.children.n);
	ok1(c2.list.prev == &c1.list);
	ok1(parent.children.n.next == &c1.list);
	ok1(parent.children.n.prev == &c2.list);
	ok1(c1.list.next == &c2.list);
	ok1(c1.list.prev == &parent.children.n);
	/* Test list_check */
	ok1(list_check(&parent.children, NULL));

	c3.name = "c3";
	list_add_tail(&parent.children, &c3.list);
	/* Test list_add_tail and !list_empty. */
	ok1(!list_empty(&parent.children));
	ok1(parent.children.n.next == &c1.list);
	ok1(parent.children.n.prev == &c3.list);
	ok1(c1.list.next == &c2.list);
	ok1(c1.list.prev == &parent.children.n);
	ok1(c2.list.next == &c3.list);
	ok1(c2.list.prev == &c1.list);
	ok1(c3.list.next == &parent.children.n);
	ok1(c3.list.prev == &c2.list);
	/* Test list_check */
	ok1(list_check(&parent.children, NULL));

	/* Test list_top */
	ok1(list_top(&parent.children, struct child, list) == &c1);

	/* Test list_for_each. */
	i = 0;
	list_for_each(&parent.children, c, list) {
		switch (i++) {
		case 0:
			ok1(c == &c1);
			break;
		case 1:
			ok1(c == &c2);
			break;
		case 2:
			ok1(c == &c3);
			break;
		}
		if (i > 2)
			break;
	}
	ok1(i == 3);

	/* Test list_for_each_safe and list_del. */
	i = 0;
	list_for_each_safe(&parent.children, c, n, list) {
		switch (i++) {
		case 0:
			ok1(c == &c1);
			break;
		case 1:
			ok1(c == &c2);
			break;
		case 2:
			ok1(c == &c3);
			break;
		}
		list_del(&c->list);
		ok1(list_check(&parent.children, NULL));
		if (i > 2)
			break;
	}
	ok1(i == 3);
	ok1(list_empty(&parent.children));
	return exit_status();
}
