.\"
.\"	$Id: par.man,v 1.2 2004/08/05 23:09:38 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- Quake pak archiving utility
.SH SYNOPSIS
.B [%s prg_name]
.B -c
|
.B -l
|
.B -x
.RB [ -fhtvV ]
.I archive
.RI [ "file list" ]

.SH DESCRIPTION
.B [%s Prg_name]
is an archiving program which processes pak files used by Quake and QuakeII.
A pak archive contains only the file names -- together with the path below id1
(QuakeI) and baseq2 (Quake2) -- and the file data. Neither access permissions
nor time stamps are stored.
.SH ACTIONS
One of the following actions must be specified:
.TP
.B -c
create a new archive
.TP
.B -l
list the contents of the specified archive
.TP
.B -x
extract files from the specified archive

.SH OPTIONS
.TP
.B -f
Force some actions, suppress error messages
.TP
.B -h
Display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully.
.TP
.B -t
the files to process are specified in the files given by
.IR "file list"
.TP
.B -v
be more talkative
.TP
.B -V
Display version and compilation info on 
.I [%s VERSION_CHANNEL_STR]
and exit successfully.

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH EXAMPLES
Extract map base1.bsp from pak0.pak:
.TP
.BR "[%s prg_name] -xv" " pak0.pak maps/base1.bsp"
.TP
Create a list with the names of all maps from in pak0.pak:
.TP
.BR "[%s prg_name] -l" " pak0.pak | grep .bsp > list"
.TP
Extract the files specified in list:
.TP
.BR "[%s prg_name] -xvt" " pak0.pak list"
.TP
Create a new archive from these maps:
.TP
.BR "[%s prg_name] -cvt" " pak9.pak list"
.TP
Replace pak0.pak by an empty archive :-)
.TP
.BR "[%s prg_name] -cv" " pak0.pak"

.SH BUGS
Tell me!

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR qstat (1)
