/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.OpenStegoPlugin;
import com.openstego.desktop.util.CommonUtil;
import com.openstego.desktop.util.StringUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluginManager {
    private static List<OpenStegoPlugin> plugins = new ArrayList<OpenStegoPlugin>();
    private static Map<String, OpenStegoPlugin> pluginsMap = new HashMap<String, OpenStegoPlugin>();

    private PluginManager() {
    }

    public static void loadPlugins() throws OpenStegoException {
        List<String> pluginList = null;
        OpenStegoPlugin plugin = null;
        try (InputStream is = PluginManager.class.getResourceAsStream("/OpenStegoPlugins.internal");
             InputStream isExt = PluginManager.class.getResourceAsStream("/OpenStegoPlugins.external");){
            pluginList = StringUtil.getStringLines(new String(CommonUtil.streamToBytes(is)));
            if (isExt != null) {
                pluginList.addAll(StringUtil.getStringLines(new String(CommonUtil.streamToBytes(isExt))));
            }
            for (int i = 0; i < pluginList.size(); ++i) {
                plugin = (OpenStegoPlugin)Class.forName(pluginList.get(i)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugins.add(plugin);
                pluginsMap.put(plugin.getName().toUpperCase(), plugin);
            }
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public static List<String> getPluginNames() {
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < plugins.size(); ++i) {
            nameList.add(plugins.get(i).getName());
        }
        return nameList;
    }

    public static List<OpenStegoPlugin> getPlugins() {
        return plugins;
    }

    public static List<OpenStegoPlugin> getDataHidingPlugins() {
        OpenStegoPlugin plugin = null;
        ArrayList<OpenStegoPlugin> dhPlugins = new ArrayList<OpenStegoPlugin>();
        for (int i = 0; i < plugins.size(); ++i) {
            plugin = plugins.get(i);
            if (!plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.DATA_HIDING)) continue;
            dhPlugins.add(plugin);
        }
        return dhPlugins;
    }

    public static List<OpenStegoPlugin> getWatermarkingPlugins() {
        OpenStegoPlugin plugin = null;
        ArrayList<OpenStegoPlugin> dhPlugins = new ArrayList<OpenStegoPlugin>();
        for (int i = 0; i < plugins.size(); ++i) {
            plugin = plugins.get(i);
            if (!plugin.getPurposes().contains((Object)OpenStegoPlugin.Purpose.WATERMARKING)) continue;
            dhPlugins.add(plugin);
        }
        return dhPlugins;
    }

    public static OpenStegoPlugin getPluginByName(String name) {
        return pluginsMap.get(name.toUpperCase());
    }
}

