/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.ui.OpenStegoUI;
import com.openstego.desktop.ui.PluginEmbedOptionsUI;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;

public abstract class OpenStegoPlugin {
    protected OpenStegoConfig config = null;

    public abstract String getName();

    public abstract List<Purpose> getPurposes();

    public abstract String getDescription();

    public final String getPurposesLabel() {
        StringBuffer sbf = new StringBuffer();
        LabelUtil labelUtil = LabelUtil.getInstance("OpenStego");
        List<Purpose> purposes = this.getPurposes();
        if (purposes == null || purposes.size() == 0) {
            return "";
        }
        sbf.append("(").append(labelUtil.getString("cmd.label.purpose.caption")).append(" ");
        for (int i = 0; i < purposes.size(); ++i) {
            if (i > 0) {
                sbf.append(", ");
            }
            sbf.append(labelUtil.getString("cmd.label.purpose." + (Object)((Object)purposes.get(i))));
        }
        sbf.append(")");
        return sbf.toString();
    }

    public abstract byte[] embedData(byte[] var1, String var2, byte[] var3, String var4, String var5) throws OpenStegoException;

    public abstract String extractMsgFileName(byte[] var1, String var2) throws OpenStegoException;

    public abstract byte[] extractData(byte[] var1, String var2, byte[] var3) throws OpenStegoException;

    public abstract byte[] generateSignature() throws OpenStegoException;

    public final double checkMark(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        return this.getWatermarkCorrelation(origSigData, this.extractData(stegoData, stegoFileName, origSigData));
    }

    public abstract double getWatermarkCorrelation(byte[] var1, byte[] var2) throws OpenStegoException;

    public abstract double getHighWatermarkLevel() throws OpenStegoException;

    public abstract double getLowWatermarkLevel() throws OpenStegoException;

    public abstract byte[] getDiff(byte[] var1, String var2, byte[] var3, String var4, String var5) throws OpenStegoException;

    public abstract boolean canHandle(byte[] var1);

    public abstract List<String> getReadableFileExtensions() throws OpenStegoException;

    public abstract List<String> getWritableFileExtensions() throws OpenStegoException;

    public abstract void populateStdCmdLineOptions(CmdLineOptions var1) throws OpenStegoException;

    public abstract String getUsage() throws OpenStegoException;

    public abstract PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoUI var1) throws OpenStegoException;

    public abstract Class<? extends OpenStegoConfig> getConfigClass();

    public final OpenStegoConfig createConfig() throws OpenStegoException {
        try {
            Constructor<? extends OpenStegoConfig> constructor = this.getConfigClass().getConstructor(new Class[0]);
            this.config = constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        return this.config;
    }

    public final OpenStegoConfig createConfig(Map<String, String> propMap) throws OpenStegoException {
        try {
            Constructor<? extends OpenStegoConfig> constructor = this.getConfigClass().getConstructor(Map.class);
            this.config = constructor.newInstance(propMap);
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        return this.config;
    }

    public final OpenStegoConfig createConfig(CmdLineOptions options) throws OpenStegoException {
        try {
            Constructor<? extends OpenStegoConfig> constructor = this.getConfigClass().getConstructor(CmdLineOptions.class);
            this.config = constructor.newInstance(options);
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        return this.config;
    }

    public final OpenStegoConfig getConfig() {
        return this.config;
    }

    public static enum Purpose {
        DATA_HIDING,
        WATERMARKING;

    }
}

