#line 982 "../../src/builtin/snarf.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 982
#ifdef HAVE_CONFIG_H
#line 982
# include <config.h>
#line 982
#endif
#line 982
#include <sys/types.h>
#line 982

#line 982
#include "mailfromd.h"
#line 982
#include "prog.h"
#line 982
#include "builtin.h"
#line 982

#line 982

#line 1022 "../../src/builtin/snarf.m4"

/* End of snarf.m4 */
#line 1 "string.bi"
/* This file is part of Mailfromd.             -*- c -*-
   Copyright (C) 2006-2020 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */



void
#line 19
bi_toupper(eval_environ_t env)
#line 19

#line 19

#line 19 "string.bi"
{
#line 19
	
#line 19

#line 19

#line 19
char * MFL_DATASEG string;
#line 19
        
#line 19
get_string_arg(env, 0, &string);
#line 19
        
#line 19

#line 19
        adjust_stack(env, 1);
#line 19

#line 19

#line 19
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 19
		prog_trace(env, "toupper %s",string);;
#line 19

{
	size_t off;
	char *s = strcpy((char*)env_data_ref(env, off = heap_reserve(env, strlen(string) + 1)), string);
	char *p;
	for (p = s; *p; p++)
		*p = toupper(*p);
	
#line 26
do {
#line 26
  push(env, (STKVAL) (mft_size) (off));
#line 26
  goto endlab;
#line 26
} while (0);
}
endlab:
#line 28
        env_function_cleanup_flush(env, NULL);
#line 28
	return;
#line 28
}

void
#line 30
bi_tolower(eval_environ_t env)
#line 30

#line 30

#line 30 "string.bi"
{
#line 30
	
#line 30

#line 30

#line 30
char * MFL_DATASEG string;
#line 30
        
#line 30
get_string_arg(env, 0, &string);
#line 30
        
#line 30

#line 30
        adjust_stack(env, 1);
#line 30

#line 30

#line 30
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 30
		prog_trace(env, "tolower %s",string);;
#line 30

{
	size_t off;
	char *s = strcpy((char*)env_data_ref(env, off = heap_reserve(env, strlen(string) + 1)), string);
	char *p;
	for (p = s; *p; p++)
		*p = tolower(*p);
	
#line 37
do {
#line 37
  push(env, (STKVAL) (mft_size) (off));
#line 37
  goto endlab;
#line 37
} while (0);
}
endlab:
#line 39
        env_function_cleanup_flush(env, NULL);
#line 39
	return;
#line 39
}

void
#line 41
bi_length(eval_environ_t env)
#line 41

#line 41

#line 41 "string.bi"
{
#line 41
	
#line 41

#line 41

#line 41
char *  string;
#line 41
        
#line 41
get_string_arg(env, 0, &string);
#line 41
        
#line 41

#line 41
        adjust_stack(env, 1);
#line 41

#line 41

#line 41
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 41
		prog_trace(env, "length %s",string);;
#line 41

{
	
#line 43
do {
#line 43
  push(env, (STKVAL)(mft_number)(strlen(string)));
#line 43
  goto endlab;
#line 43
} while (0);
}
endlab:
#line 45
        env_function_cleanup_flush(env, NULL);
#line 45
	return;
#line 45
}

void
#line 47
bi_substring(eval_environ_t env)
#line 47

#line 47

#line 47 "string.bi"
{
#line 47
	
#line 47

#line 47

#line 47
char * MFL_DATASEG string;
#line 47
        long  start;
#line 47
        long  end;
#line 47
        
#line 47
get_string_arg(env, 0, &string);
#line 47
        get_numeric_arg(env, 1, &start);
#line 47
        get_numeric_arg(env, 2, &end);
#line 47
        
#line 47

#line 47
        adjust_stack(env, 3);
#line 47

#line 47

#line 47
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 47
		prog_trace(env, "substring %s %lu %lu",string, start, end);;
#line 47

{
	size_t off;
	long len = strlen(string);
	char *s;
	
	if (end < 0)
		end = len + end;
	if (end < start) {
		long t = end;
		end = start;
		start = t;
	}

		if (!(start < len && end < len))
#line 61
		(
#line 61
	env_throw_bi(env, mfe_range, "substring", _("argument out of range"))
#line 61
)
;
	
	len = end - start + 1;
	s = (char*) env_data_ref(env, (off = heap_reserve(env, len + 1)));
	memcpy(s, string + start, len);
	s[len] = 0;
	
	
#line 69
do {
#line 69
  push(env, (STKVAL) (mft_size) (off));
#line 69
  goto endlab;
#line 69
} while (0);
}
endlab:
#line 71
        env_function_cleanup_flush(env, NULL);
#line 71
	return;
#line 71
}

void
#line 73
bi_substr(eval_environ_t env)
#line 73

#line 73

#line 73 "string.bi"
{
#line 73
	
#line 73

#line 73
long __bi_argcnt;
#line 73
char * MFL_DATASEG string;
#line 73
        long  start;
#line 73
        long  nbytes;
#line 73
        
#line 73
get_string_arg(env, 1, &string);
#line 73
        get_numeric_arg(env, 2, &start);
#line 73
        get_numeric_arg(env, 3, &nbytes);
#line 73
        
#line 73
get_numeric_arg(env, 0, &__bi_argcnt);
#line 73
        adjust_stack(env, __bi_argcnt + 1);
#line 73

#line 73

#line 73
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 73
		prog_trace(env, "substr %s %lu %lu",string, start, ((__bi_argcnt > 2) ? nbytes : 0));;
#line 73

{
	size_t off;
	long len = strlen(string);
	char *s;
	
		if (!(start >= 0))
#line 79
		(
#line 79
	env_throw_bi(env, mfe_range, "substr", _("argument out of range: start=%ld"),start)
#line 79
)
;
	if (!(__bi_argcnt > 2))
		nbytes = len - start;
		if (!(nbytes >= 0))
#line 83
		(
#line 83
	env_throw_bi(env, mfe_range, "substr", _("argument out of range: start=%ld, len=%ld"),start,len)
#line 83
)
;
	
	s = (char*) env_data_ref(env, (off = heap_reserve(env, nbytes + 1)));
	memcpy(s, string + start, nbytes);
	s[nbytes] = 0;
	
	
#line 90
do {
#line 90
  push(env, (STKVAL) (mft_size) (off));
#line 90
  goto endlab;
#line 90
} while (0);
}
endlab:
#line 92
        env_function_cleanup_flush(env, NULL);
#line 92
	return;
#line 92
}

void
#line 94
bi_index(eval_environ_t env)
#line 94

#line 94

#line 94 "string.bi"
{
#line 94
	
#line 94

#line 94
long __bi_argcnt;
#line 94
char *  str;
#line 94
        char *  sub;
#line 94
        long  from;
#line 94
        
#line 94
get_string_arg(env, 1, &str);
#line 94
        get_string_arg(env, 2, &sub);
#line 94
        get_numeric_arg(env, 3, &from);
#line 94
        
#line 94
get_numeric_arg(env, 0, &__bi_argcnt);
#line 94
        adjust_stack(env, __bi_argcnt + 1);
#line 94

#line 94

#line 94
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 94
		prog_trace(env, "index %s %s %lu",str, sub, ((__bi_argcnt > 2) ? from : 0));;
#line 94

{
	long start = 0;
	char *p;

	if ((__bi_argcnt > 2))
		start = from;
		if (!(start >= 0 && start <= strlen(str)))
#line 101
		(
#line 101
	env_throw_bi(env, mfe_range, "index", _("argument out of range: start=%ld"),start)
#line 101
)
;
	p = strstr(str + start, sub);
	
#line 104
do {
#line 104
  push(env, (STKVAL)(mft_number)(p ? p - str : -1));
#line 104
  goto endlab;
#line 104
} while (0);
}
endlab:
#line 106
        env_function_cleanup_flush(env, NULL);
#line 106
	return;
#line 106
}


void
#line 109
bi_rindex(eval_environ_t env)
#line 109

#line 109

#line 109 "string.bi"
{
#line 109
	
#line 109

#line 109
long __bi_argcnt;
#line 109
char * MFL_DATASEG str;
#line 109
        char * MFL_DATASEG sub;
#line 109
        long  from;
#line 109
        
#line 109
get_string_arg(env, 1, &str);
#line 109
        get_string_arg(env, 2, &sub);
#line 109
        get_numeric_arg(env, 3, &from);
#line 109
        
#line 109
get_numeric_arg(env, 0, &__bi_argcnt);
#line 109
        adjust_stack(env, __bi_argcnt + 1);
#line 109

#line 109

#line 109
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 109
		prog_trace(env, "rindex %s %s %lu",str, sub, ((__bi_argcnt > 2) ? from : 0));;
#line 109

{
	size_t start = 0;
	int slen, xlen, rc;
	char *p, *s, *x;
	char *temp;

	slen = strlen(str);
	xlen = strlen(sub);
	temp = mf_c_val(heap_tempspace(env, xlen + slen + 2), ptr);
	s = temp;
	x = s + slen + 1;
	
	if ((__bi_argcnt > 2)) {
			if (!(from >=0 && from <= slen))
#line 123
		(
#line 123
	env_throw_bi(env, mfe_range, "rindex", _("argument out of range: start=%ld"),from)
#line 123
)
;
		start = slen - from;
	}
	
	/* Reverse str */                     
#define REV(v,s,l)                                         \
	l = strlen(s);                                     \
	v[l] = 0;                                          \
	for (p = v + l - 1; p >= v; p--, s++)              \
		*p = *s;

	REV(s,str,slen);
	REV(x,sub,xlen);

	p = strstr(s + start, x);
	if (p)
		rc = slen - (p - s + xlen);
	else
		rc = -1;
	
	
#line 144
do {
#line 144
  push(env, (STKVAL)(mft_number)(rc));
#line 144
  goto endlab;
#line 144
} while (0);
}
endlab:
#line 146
        env_function_cleanup_flush(env, NULL);
#line 146
	return;
#line 146
}

void
#line 148
bi_revstr(eval_environ_t env)
#line 148

#line 148

#line 148 "string.bi"
{
#line 148
	
#line 148

#line 148

#line 148
char * MFL_DATASEG str;
#line 148
        
#line 148
get_string_arg(env, 0, &str);
#line 148
        
#line 148

#line 148
        adjust_stack(env, 1);
#line 148

#line 148

#line 148
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 148
		prog_trace(env, "revstr %s",str);;
#line 148

{
	int len = strlen(str);
	char *p;
	size_t off;
	char *s = (char*) env_data_ref(env, (off = heap_reserve(env, len + 1)));

	s[len] = 0;
	for (p = s + len - 1; p >= s; p--, str++)
		*p = *str;
	
#line 158
do {
#line 158
  push(env, (STKVAL) (mft_size) (off));
#line 158
  goto endlab;
#line 158
} while (0);
}
endlab:
#line 160
        env_function_cleanup_flush(env, NULL);
#line 160
	return;
#line 160
}

void
#line 162
bi_replstr(eval_environ_t env)
#line 162

#line 162

#line 162 "string.bi"
{
#line 162
	
#line 162

#line 162

#line 162
char * MFL_DATASEG text;
#line 162
        long  count;
#line 162
        
#line 162
get_string_arg(env, 0, &text);
#line 162
        get_numeric_arg(env, 1, &count);
#line 162
        
#line 162

#line 162
        adjust_stack(env, 2);
#line 162

#line 162

#line 162
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 162
		prog_trace(env, "replstr %s %lu",text, count);;
#line 162

{
	size_t size, len, i;
	size_t off;
	char *s;

		if (!(count >= 0))
#line 168
		(
#line 168
	env_throw_bi(env, mfe_range, "replstr", _("argument out of range: count=%ld"),count)
#line 168
)
;
	if (count == 0)
		
#line 171
do {
#line 171
  pushs(env, "");
#line 171
  goto endlab;
#line 171
} while (0);

	len = strlen(text);
	size = len * count;
	s = (char*) env_data_ref(env, (off = heap_reserve(env, size + 1)));
	for (i = 0; i < count; i++, s += len) 
		memcpy(s, text, len);
	*s = 0;
	
#line 179
do {
#line 179
  push(env, (STKVAL) (mft_size) (off));
#line 179
  goto endlab;
#line 179
} while (0);
}
endlab:
#line 181
        env_function_cleanup_flush(env, NULL);
#line 181
	return;
#line 181
}

void
#line 183
bi_message_header_decode(eval_environ_t env)
#line 183

#line 183

#line 183 "string.bi"
{
#line 183
	
#line 183

#line 183
long __bi_argcnt;
#line 183
char * MFL_DATASEG text;
#line 183
        char * MFL_DATASEG charset;
#line 183
        
#line 183
get_string_arg(env, 1, &text);
#line 183
        get_string_arg(env, 2, &charset);
#line 183
        
#line 183
get_numeric_arg(env, 0, &__bi_argcnt);
#line 183
        adjust_stack(env, __bi_argcnt + 1);
#line 183

#line 183

#line 183
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 183
		prog_trace(env, "message_header_decode %s %s",text, ((__bi_argcnt > 1) ? charset : ""));;
#line 183

{
	char *p;
	int rc = mu_rfc2047_decode (((__bi_argcnt > 1) ? charset : "utf-8"), text, &p);
		if (!(rc == 0))
#line 187
		(
#line 187
	env_throw_bi(env, mfe_failure, "message_header_decode", _("error decoding string: %s"),mu_strerror(rc))
#line 187
)
#line 190
;
	pushs(env, p);
	free(p);
}

#line 194
        env_function_cleanup_flush(env, NULL);
#line 194
	return;
#line 194
}

void
#line 196
bi_message_header_encode(eval_environ_t env)
#line 196

#line 196

#line 196 "string.bi"
{
#line 196
	
#line 196

#line 196
long __bi_argcnt;
#line 196
char * MFL_DATASEG text;
#line 196
        char * MFL_DATASEG encoding;
#line 196
        char * MFL_DATASEG charset;
#line 196
        
#line 196
get_string_arg(env, 1, &text);
#line 196
        get_string_arg(env, 2, &encoding);
#line 196
        get_string_arg(env, 3, &charset);
#line 196
        
#line 196
get_numeric_arg(env, 0, &__bi_argcnt);
#line 196
        adjust_stack(env, __bi_argcnt + 1);
#line 196

#line 196

#line 196
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 196
		prog_trace(env, "message_header_encode %s %s %s",text, ((__bi_argcnt > 1) ? encoding : ""), ((__bi_argcnt > 2) ? charset : ""));;

{
	char *p;
	int rc = mu_rfc2047_encode (((__bi_argcnt > 2) ? charset : "utf-8"),
				    ((__bi_argcnt > 1) ? encoding : "quoted-printable"),
				    text, &p);
		if (!(rc == 0))
#line 203
		(
#line 203
	env_throw_bi(env, mfe_failure, "message_header_encode", _("error encoding string: %s"),mu_strerror(rc))
#line 203
)
#line 206
;
	pushs(env, p);
	free(p);
}

#line 210
        env_function_cleanup_flush(env, NULL);
#line 210
	return;
#line 210
}

void
#line 212
bi_unfold(eval_environ_t env)
#line 212

#line 212

#line 212 "string.bi"
{
#line 212
	
#line 212

#line 212

#line 212
char * MFL_DATASEG text;
#line 212
        
#line 212
get_string_arg(env, 0, &text);
#line 212
        
#line 212

#line 212
        adjust_stack(env, 1);
#line 212

#line 212

#line 212
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 212
		prog_trace(env, "unfold %s",text);;
#line 212

{
	size_t off;
	char *s = strcpy((char*)env_data_ref(env, off = heap_reserve(env, strlen(text) + 1)), text);
	mu_string_unfold(s, NULL);
	
#line 217
do {
#line 217
  push(env, (STKVAL) (mft_size) (off));
#line 217
  goto endlab;
#line 217
} while (0);
}
endlab:
#line 219
        env_function_cleanup_flush(env, NULL);
#line 219
	return;
#line 219
}

void
#line 221
bi_escape(eval_environ_t env)
#line 221

#line 221

#line 221 "string.bi"
{
#line 221
	
#line 221

#line 221
long __bi_argcnt;
#line 221
char * MFL_DATASEG text;
#line 221
        char * MFL_DATASEG chars;
#line 221
        
#line 221
get_string_arg(env, 1, &text);
#line 221
        get_string_arg(env, 2, &chars);
#line 221
        
#line 221
get_numeric_arg(env, 0, &__bi_argcnt);
#line 221
        adjust_stack(env, __bi_argcnt + 1);
#line 221

#line 221

#line 221
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 221
		prog_trace(env, "escape %s %s",text, ((__bi_argcnt > 1) ? chars : ""));;
#line 221

{
	char *charmap = ((__bi_argcnt > 1) ? chars : "\\\"");
	
	if (text[strcspn(text, charmap)] == 0)
		
#line 226
do {
#line 226
  pushs(env, text);
#line 226
  goto endlab;
#line 226
} while (0);
	
	heap_obstack_begin(env);
	for (;;) {
		size_t len = strcspn(text, charmap);
		if (len)
			heap_obstack_grow(env, text, len);
		if (text[len]) {
			do { char __c = '\\'; heap_obstack_grow(env, &__c, 1); } while(0);
			do { char __c = text[len]; heap_obstack_grow(env, &__c, 1); } while(0);
			text += len + 1;
		} else
			break;
	}
	do { char __c = 0; heap_obstack_grow(env, &__c, 1); } while(0);
	
#line 241
do {
#line 241
  push(env, (STKVAL) (heap_obstack_finish(env)));
#line 241
  goto endlab;
#line 241
} while (0);
}
endlab:
#line 243
        env_function_cleanup_flush(env, NULL);
#line 243
	return;
#line 243
}

void
#line 245
bi_qr(eval_environ_t env)
#line 245

#line 245

#line 245 "string.bi"
{
#line 245
	
#line 245

#line 245
long __bi_argcnt;
#line 245
long  regex_flags;
#line 245
        char * MFL_DATASEG text;
#line 245
        char * MFL_DATASEG delim;
#line 245
        
#line 245
get_numeric_arg(env, 1, &regex_flags);
#line 245
        get_string_arg(env, 2, &text);
#line 245
        get_string_arg(env, 3, &delim);
#line 245
        
#line 245
get_numeric_arg(env, 0, &__bi_argcnt);
#line 245
        adjust_stack(env, __bi_argcnt + 1);
#line 245

#line 245

#line 245
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 245
		prog_trace(env, "qr %lu %s %s",regex_flags, text, ((__bi_argcnt > 2) ? delim : ""));;
#line 245

{
	static char *qc[] = {
		/* Basic regular expressions */
		"\\+*?[]",
		/* Extended regular expressions */
		"\\+*?[](){}"
	};
	char charmap[13];
	
	strcpy(charmap, qc[!!(regex_flags & REG_EXTENDED)]);
	
	if ((__bi_argcnt > 2)) {
		char *p = charmap + strlen(charmap);
		*p++ = *delim++;
		if (*delim)
			*p++ = *delim;
		*p = 0;
	}
	
	if (text[strcspn(text, charmap)] == 0)
		
#line 266
do {
#line 266
  pushs(env, text);
#line 266
  goto endlab;
#line 266
} while (0);
	heap_obstack_begin(env);
	for (;;) {
		size_t len = strcspn(text, charmap);
		if (len)
			heap_obstack_grow(env, text, len);
		if (text[len]) {
			do { char __c = '\\'; heap_obstack_grow(env, &__c, 1); } while(0);
			do { char __c = text[len]; heap_obstack_grow(env, &__c, 1); } while(0);
			text += len + 1;
		} else
			break;
	}
	do { char __c = 0; heap_obstack_grow(env, &__c, 1); } while(0);
	
#line 280
do {
#line 280
  push(env, (STKVAL) (heap_obstack_finish(env)));
#line 280
  goto endlab;
#line 280
} while (0);	
}
endlab:
#line 282
        env_function_cleanup_flush(env, NULL);
#line 282
	return;
#line 282
}

void
#line 284
bi_unescape(eval_environ_t env)
#line 284

#line 284

#line 284 "string.bi"
{
#line 284
	
#line 284

#line 284

#line 284
char * MFL_DATASEG text;
#line 284
        
#line 284
get_string_arg(env, 0, &text);
#line 284
        
#line 284

#line 284
        adjust_stack(env, 1);
#line 284

#line 284

#line 284
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 284
		prog_trace(env, "unescape %s",text);;
#line 284

{
	heap_obstack_begin(env);
	for (;;) {
		size_t len = strcspn(text, "\\");
		if (len)
			heap_obstack_grow(env, text, len);
		if (text[len]) {
			char c = text[len + 1];
			if (!c)
				break;
			do { char __c = text[len+1]; heap_obstack_grow(env, &__c, 1); } while(0);
			text += len + 2;
		} else
			break;
	}
	do { char __c = 0; heap_obstack_grow(env, &__c, 1); } while(0);
	
#line 301
do {
#line 301
  push(env, (STKVAL) (heap_obstack_finish(env)));
#line 301
  goto endlab;
#line 301
} while (0);
}
endlab:
#line 303
        env_function_cleanup_flush(env, NULL);
#line 303
	return;
#line 303
}

void
#line 305
bi_ltrim(eval_environ_t env)
#line 305

#line 305

#line 305 "string.bi"
{
#line 305
	
#line 305

#line 305
long __bi_argcnt;
#line 305
char * MFL_DATASEG input;
#line 305
        char * MFL_DATASEG cset;
#line 305
        
#line 305
get_string_arg(env, 1, &input);
#line 305
        get_string_arg(env, 2, &cset);
#line 305
        
#line 305
get_numeric_arg(env, 0, &__bi_argcnt);
#line 305
        adjust_stack(env, __bi_argcnt + 1);
#line 305

#line 305

#line 305
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 305
		prog_trace(env, "ltrim %s %s",input, ((__bi_argcnt > 1) ? cset : ""));;
#line 305

{
	char *p = ((__bi_argcnt > 1) ? cset : " \t\r\n\f");
	for (; *input && strchr(p, *input); input++);
	
#line 309
do {
#line 309
  pushs(env, input);
#line 309
  goto endlab;
#line 309
} while (0);
}
endlab:
#line 311
        env_function_cleanup_flush(env, NULL);
#line 311
	return;
#line 311
}

void
#line 313
bi_rtrim(eval_environ_t env)
#line 313

#line 313

#line 313 "string.bi"
{
#line 313
	
#line 313

#line 313
long __bi_argcnt;
#line 313
char * MFL_DATASEG input;
#line 313
        char * MFL_DATASEG cset;
#line 313
        
#line 313
get_string_arg(env, 1, &input);
#line 313
        get_string_arg(env, 2, &cset);
#line 313
        
#line 313
get_numeric_arg(env, 0, &__bi_argcnt);
#line 313
        adjust_stack(env, __bi_argcnt + 1);
#line 313

#line 313

#line 313
	if (builtin_module_trace(BUILTIN_IDX_string))
#line 313
		prog_trace(env, "rtrim %s %s",input, ((__bi_argcnt > 1) ? cset : ""));;
#line 313

{
	char *p = ((__bi_argcnt > 1) ? cset : " \t\r\n\f");
	size_t len = strlen(input);
	size_t off;

	for (; len > 0 && strchr(p, input[len-1]); len--);
	p = (char*) env_data_ref(env, (off = heap_reserve(env, len+1)));
	memcpy(p, input, len);
	p[len] = 0;
	
#line 323
do {
#line 323
  push(env, (STKVAL) (mft_size) (off));
#line 323
  goto endlab;
#line 323
} while (0);
}
endlab:
#line 325
        env_function_cleanup_flush(env, NULL);
#line 325
	return;
#line 325
}

#line 982 "../../src/builtin/snarf.m4"

#line 982

#line 982

#line 982
void
#line 982
string_init_builtin(void)
#line 982
{
#line 982
	
#line 982
	#line 19 "string.bi"
va_builtin_install_ex("toupper", bi_toupper, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 30 "string.bi"
va_builtin_install_ex("tolower", bi_tolower, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 41 "string.bi"
va_builtin_install_ex("length", bi_length, 0, dtype_number, 1, 0, 0|0, dtype_string);
#line 47 "string.bi"
va_builtin_install_ex("substring", bi_substring, 0, dtype_string, 3, 0, 0|0, dtype_string, dtype_number, dtype_number);
#line 73 "string.bi"
va_builtin_install_ex("substr", bi_substr, 0, dtype_string, 3, 1, 0|0, dtype_string, dtype_number, dtype_number);
#line 94 "string.bi"
va_builtin_install_ex("index", bi_index, 0, dtype_number, 3, 1, 0|0, dtype_string, dtype_string, dtype_number);
#line 109 "string.bi"
va_builtin_install_ex("rindex", bi_rindex, 0, dtype_number, 3, 1, 0|0, dtype_string, dtype_string, dtype_number);
#line 148 "string.bi"
va_builtin_install_ex("revstr", bi_revstr, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 162 "string.bi"
va_builtin_install_ex("replstr", bi_replstr, 0, dtype_string, 2, 0, 0|0, dtype_string, dtype_number);
#line 183 "string.bi"
va_builtin_install_ex("message_header_decode", bi_message_header_decode, 0, dtype_string, 2, 1, 0|0, dtype_string, dtype_string);
#line 196 "string.bi"
va_builtin_install_ex("message_header_encode", bi_message_header_encode, 0, dtype_string, 3, 2, 0|0, dtype_string, dtype_string, dtype_string);
#line 212 "string.bi"
va_builtin_install_ex("unfold", bi_unfold, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 221 "string.bi"
va_builtin_install_ex("escape", bi_escape, 0, dtype_string, 2, 1, 0|0, dtype_string, dtype_string);
#line 245 "string.bi"
va_builtin_install_ex("qr", bi_qr, 0, dtype_string, 3, 1, MFD_BUILTIN_REGEX_FLAGS|MFD_BUILTIN_REGEX_FLAGS|0, dtype_number, dtype_string, dtype_string);
#line 284 "string.bi"
va_builtin_install_ex("unescape", bi_unescape, 0, dtype_string, 1, 0, 0|0, dtype_string);
#line 305 "string.bi"
va_builtin_install_ex("ltrim", bi_ltrim, 0, dtype_string, 2, 1, 0|0, dtype_string, dtype_string);
#line 313 "string.bi"
va_builtin_install_ex("rtrim", bi_rtrim, 0, dtype_string, 2, 1, 0|0, dtype_string, dtype_string);

#line 982 "../../src/builtin/snarf.m4"
	
#line 982
}
#line 982 "../../src/builtin/snarf.m4"

