#line 982 "../../src/builtin/snarf.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 982
#ifdef HAVE_CONFIG_H
#line 982
# include <config.h>
#line 982
#endif
#line 982
#include <sys/types.h>
#line 982

#line 982
#include "mailfromd.h"
#line 982
#include "prog.h"
#line 982
#include "builtin.h"
#line 982

#line 180 "io.bi"
static mu_debug_handle_t debug_handle;
#line 982 "../../src/builtin/snarf.m4"

#line 1022 "../../src/builtin/snarf.m4"

/* End of snarf.m4 */
#line 1 "io.bi"
/* This file is part of Mailfromd.             -*- c -*-
   Copyright (C) 2006-2020 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */



#include <mflib/status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include "global.h"
#include "msg.h"

static size_t nstreams = MAX_IOSTREAMS;

static struct mu_cfg_param io_cfg_param[] = {
	{ "max-streams", mu_c_size, &nstreams, 0, NULL,
	  N_("Maximum number of stream descriptors.") },
	{ NULL }
};

struct io_stream {
	char *name;
	mu_locker_t lock;
	int fd[2];
	pid_t pid;
	char *buf;
	size_t bufsize;
	int (*shutdown)(struct io_stream *, int what);
	void (*cleanup)(void*);
	void *cleanup_data;
	char *delim;
};

#define IFD(s) ((s).fd[0])
#define OFD(s) ((s).fd[1] == -1 ? (s).fd[0] : (s).fd[1])

static void
flush_stream(struct io_stream *str)
{
	/*FIXME*/
}

static void
close_stream(struct io_stream *str)
{
	if (OFD(*str) == -1)
		return;
	flush_stream(str);
	close(OFD(*str));
	if (IFD(*str) != -1)
		close(IFD(*str));
	if (str->pid) {
		int status;
		waitpid(str->pid, &status, 0);
	}
	str->fd[0] = -1;
	str->fd[1] = -1;
	str->pid = 0;
	if (str->cleanup)
		str->cleanup(str->cleanup_data);
	str->cleanup = NULL;
	str->cleanup_data = NULL;
	if (str->name) {
		free(str->name);
		str->name = NULL;
	}
	if (str->delim) {
		free(str->delim);
		str->delim = NULL;
	}
}

/* Read bytes from the stream STR into its buffer, until
   DELIM is encountered. Return number of bytes read. */
static int
read_stream_delim(struct io_stream *str, char *delim)
{
	int fd = IFD(*str);
	size_t i = 0;
	int rc;
	size_t delim_len = strlen(delim);
	
	for (;;) {
		if (str->bufsize == i) {
			if (str->bufsize == 0) 
				str->bufsize = 16;
			str->buf = mu_2nrealloc(str->buf, &str->bufsize,
					      sizeof str->buf[1]);
		}
		rc = read(fd, str->buf + i, 1);
		if (rc == -1)
			return -1;
		else if (rc == 0)
			return 0;
		i++;
		if (i >= delim_len &&
		    memcmp(str->buf + i - delim_len, delim, delim_len) == 0) {
			str->buf[i - delim_len] = 0;
			break;
		}
	}
	return i;
}

#define REDIRECT_STDIN_P(f) ((f) & (O_WRONLY|O_RDWR))
#define REDIRECT_STDOUT_P(f) (!((f) & O_WRONLY))

#define STDERR_SHUT        0
#define STDERR_NULL        1
#define STDERR_LOG         2
#define STDERR_FILE        3
#define STDERR_FILE_APPEND 4

#define LOG_TAG_PFX "mailfromd:"
#define LOG_TAG_PFX_LEN (sizeof(LOG_TAG_PFX)-1)

static void
stderr_to_log(char *arg, const char *cmd)
{
	int p[2];
	pid_t pid;
	
	if (pipe(p)) {
		mu_error(_("pipe failed: %s"), mu_strerror(errno));
		close(2);
		return;
	}

	pid = fork();

	if (pid == (pid_t) -1) {
		mu_error(_("fork failed: %s"), mu_strerror(errno));
		close(p[0]);
		close(p[1]);
		close(2);
		return;
	}
	
	/* Child */
	if (pid == 0) {
		FILE *fp;
		fd_set fdset;
		size_t len;
		char buf[1024];
		char *tag;
		int fac = mu_log_facility, pri = LOG_ERR;
		
		if (arg) {
			char *p = strchr(arg, '.');

			if (p)
				*p++ = 0;
			if (mu_string_to_syslog_facility(arg, &fac)) {
				mu_error(_("unknown syslog facility (%s), "
					   "redirecting stderr to %s"),
					 arg,
					 mu_syslog_facility_to_string(fac));
			}
			
			if (p && mu_string_to_syslog_priority(p, &pri)) {
				mu_error(_("unknown syslog priority (%s), "
					   "redirecting stderr to %s"),
					 arg,
					 mu_syslog_priority_to_string(pri));
			}
		}
		
#line 180 "io.bi"

#line 180
mu_debug(debug_handle, MU_DEBUG_TRACE2,("redirecting stderr to syslog %s.%s",
		           mu_syslog_facility_to_string(fac),
		           mu_syslog_priority_to_string(pri)));
#line 184
		
		len = strcspn(cmd, " \t");
		tag = malloc(LOG_TAG_PFX_LEN + len + 1);
		if (!tag)
			tag = (char*) cmd;
		else {
			strcpy(tag, LOG_TAG_PFX);
			memcpy(tag + LOG_TAG_PFX_LEN, cmd, len);
			tag[LOG_TAG_PFX_LEN + len] = 0;
		}
		mf_proctitle_format("%s redirector", cmd);

		FD_ZERO(&fdset);
		FD_SET(p[0], &fdset);
		logger_fdset(&fdset);
		close_fds_except(&fdset);

		fp = fdopen(p[0], "r");
		logger_open();
		while (fgets(buf, sizeof(buf), fp))
			syslog(pri, "%s", buf);
		exit(0);
	}

	/* Parent */
	close(p[0]);
	dup2(p[1], 2);
	close(p[1]);
}
	
static void
stderr_handler(int mode, char *arg, const char *cmd)
{
	int fd;
	int append = O_TRUNC;
	
	switch (mode) {
	case STDERR_SHUT:
		close(2);
		break;

	case STDERR_NULL:
		arg = "/dev/null";
	case STDERR_FILE_APPEND:
		append = O_APPEND;
	case STDERR_FILE:
		if (!arg || !*arg) {
			close(2);
			break;
		}
		
#line 234

#line 234
mu_debug(debug_handle, MU_DEBUG_TRACE2,("redirecting stderr to %s", arg));
		fd = open(arg, O_CREAT|O_WRONLY|append, 0644);
		if (fd < 0) {
			mu_error(_("cannot open file %s for appending: %s"),
				 arg, mu_strerror(errno));
			close(2);
			return;
		}
		if (fd != 2) {
			dup2(fd, 2);
			close(fd);
		}
		break;

	case STDERR_LOG:
		stderr_to_log(arg, cmd);
	}
}

static void
parse_stderr_redirect(const char **pcmd, int *perr, char **parg)
{
	int err;
	size_t len;
	char *arg;
	const char *cmdline = *pcmd;
	
	while (*cmdline && mu_isspace(*cmdline))
		cmdline++;
	if (strncmp(cmdline, "2>file:", 7) == 0) {
		cmdline += 7;
		err = STDERR_FILE;
	} else if (strncmp(cmdline, "2>>file:", 8) == 0) {
		cmdline += 8;
		err = STDERR_FILE_APPEND;
	} else if (strncmp(cmdline, "2>null:", 7) == 0) {
		cmdline += 7;
		err = STDERR_NULL;
	} else if (strncmp(cmdline, "2>syslog:", 9) == 0) {
		cmdline += 9;
		err = STDERR_LOG;
	} else
		return;

	len = strcspn(cmdline, " \t");
	if (len > 0 && cmdline[len-1] == 0)
		return;
	if (len == 0)
		arg = NULL;
	else {
		arg = malloc(len + 1);
		if (!arg)
			return;
		memcpy(arg, cmdline, len);
		arg[len] = 0;
	}

	*pcmd = cmdline + len;
	*perr = err;
	*parg = arg;
}


static int
open_program_stream_ioe(eval_environ_t env,
			struct io_stream *str, const char *cmdline,
			int flags,
			int ioe[2])
{
	int rightp[2], leftp[2];
	int rc = 0;
	pid_t pid;
	int err = STDERR_SHUT;
	char *arg = NULL;
	struct mu_wordsplit ws;
	
	parse_stderr_redirect(&cmdline, &err, &arg);
	while (*cmdline && (*cmdline == ' ' || *cmdline == '\t'))
		cmdline++;
	
	if (REDIRECT_STDIN_P(flags)) {
		if (pipe(leftp)) {
			mu_diag_funcall(MU_DIAG_ERROR, "pipe", "leftp",
					errno);
			free(arg);
			(
#line 319
	env_throw_bi(env, mfe_failure, NULL, "pipe failed")
#line 319
);
		}
	}
	
	if (REDIRECT_STDOUT_P(flags)) {
		if (pipe(rightp)) {
			mu_diag_funcall(MU_DIAG_ERROR, "pipe", "rightp",
					errno);
			free(arg);
			if (REDIRECT_STDIN_P(flags)) {
				close(leftp[0]);
				close(leftp[1]);
			}
		}
	}
	
	switch (pid = fork()) {
		/* The child branch.  */
	case 0:
		/* attach the pipes */

		/* Right-end */
		if (REDIRECT_STDOUT_P(flags)) {
			if (rightp[1] != 1)
				dup2(rightp[1], 1);
		} else if (ioe && ioe[1] != -1 && ioe[1] != 1) {
			dup2(ioe[1], 1);
		}

		/* Left-end */
		if (REDIRECT_STDIN_P(flags)) {
			if (leftp[0] != 0)
				dup2(leftp[0], 0);
		} else if (ioe && ioe[0] != -1 && ioe[0] != 0) {
			dup2(ioe[0], 0);
		}

		if (ioe && ioe[2] != -1 && ioe[2] != 2)
			dup2(ioe[2], 2);
		else
			stderr_handler(err, arg, cmdline);
		
		/* Close unneeded descriptors */
		close_fds_above(2);

		
#line 364

#line 364
mu_debug(debug_handle, MU_DEBUG_TRACE3,("running %s", cmdline));
		if (mu_wordsplit(cmdline, &ws,
				 MU_WRDSF_DEFFLAGS & ~MU_WRDSF_CESCAPES)) {
			mu_error(_("cannot parse command line %s: %s"),
				 cmdline, mu_wordsplit_strerror(&ws));
			exit(127);
		}
		execvp(ws.ws_wordv[0], ws.ws_wordv);
		mu_error(_("cannot run %s: %s"),
			 cmdline, mu_strerror(errno));
		exit(127);
		/********************/

		/* Parent branches: */
	case -1:
		/* Fork has failed */
		/* Restore things */
		rc = errno;
		if (REDIRECT_STDOUT_P(flags)) {
			close(rightp[0]);
			close(rightp[1]);
		}
		if (REDIRECT_STDIN_P(flags)) {
			close(leftp[0]);
			close(leftp[1]);
		}
		break;
		
	default:
		str->pid = pid;
		if (REDIRECT_STDOUT_P(flags)) {
			str->fd[0] = rightp[0];
			close(rightp[1]);
		} else
			str->fd[0] = -1;

		if (REDIRECT_STDIN_P(flags)) {
			str->fd[1] = leftp[1];
			close(leftp[0]);
		} else
			str->fd[1] = -1;
	}
	free(arg);
	return rc;
}

static int
open_program_stream(eval_environ_t env,
		    struct io_stream *str, const char *cmdline,
		    int flags)
{
	return open_program_stream_ioe(env, str, cmdline, flags, NULL);
}

static int
open_file_stream(eval_environ_t env,
		 struct io_stream *str, const char *file, int flags)
{
	str->fd[0] = open(file, flags, 0644); /* FIXME: mode? */
	if (str->fd[0] == -1)
		return errno;
	return 0;
}



static int
open_parsed_inet_stream(eval_environ_t env,
			struct io_stream *str,
			const char *cstr,
			char *proto, char *port, char *path,
			int flags)
{
	union {
		struct sockaddr sa;
		struct sockaddr_in s_in;
		struct sockaddr_un s_un;
#ifdef GACOPYZ_IPV6
		struct sockaddr_in6 s_in6;
#endif
	} addr;

	socklen_t socklen;
	int fd;
	int rc;

	if (!proto
	    || strcmp(proto, "unix") == 0 || strcmp(proto, "local") == 0) {
		struct stat st;
		
			if (!(port == NULL))
#line 454
		(
#line 454
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "port is meaningless for UNIX sockets"),cstr)
#line 454
)
#line 458
;
		
			if (!(strlen(path) <= sizeof addr.s_un.sun_path))
#line 460
		(
#line 460
	env_throw_bi(env, mfe_range, NULL, _("%s: UNIX socket name too long"),path)
#line 460
)
#line 463
;
		
		addr.sa.sa_family = PF_UNIX;
		socklen = sizeof(addr.s_un);
		strcpy(addr.s_un.sun_path, path);
		
		if (stat(path, &st)) {
			(
#line 470
	env_throw_bi(env, mfe_failure, NULL, _("%s: cannot stat socket: %s"),path,strerror(errno))
#line 470
);
#line 473
		} else {
			/* FIXME: Check permissions? */
				if (!(S_ISSOCK(st.st_mode)))
#line 475
		(
#line 475
	env_throw_bi(env, mfe_failure, NULL, _("%s: not a socket"),path)
#line 475
)
#line 478
;
		}

	} else if (strcmp(proto, "inet") == 0) {
		short pnum;
		long num;
		char *p;
		
		addr.sa.sa_family = PF_INET;
		socklen = sizeof(addr.s_in);

			if (!(port != NULL))
#line 489
		(
#line 489
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "missing port number"),cstr)
#line 489
)
#line 493
;

		num = pnum = strtol(port, &p, 0);
		if (*p == 0) {
				if (!(num == pnum))
#line 497
		(
#line 497
	env_throw_bi(env, mfe_range, NULL, _("invalid connection type: "
				    "%s; bad port number"),cstr)
#line 497
)
#line 501
;
			pnum = htons(pnum);
		} else {
			struct servent *sp = getservbyname(port, "tcp");

				if (!(sp != NULL))
#line 506
		(
#line 506
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: "
				    "%s; unknown port name"),cstr)
#line 506
)
#line 510
;
			pnum = sp->s_port;
		}
		
		if (!path)
			addr.s_in.sin_addr.s_addr = INADDR_ANY;
		else {
			struct hostent *hp = gethostbyname(path);
				if (!(hp != NULL))
#line 518
		(
#line 518
	env_throw_bi(env, mfe_failure, NULL, _("unknown host name %s"),path)
#line 518
)
#line 521
;
			addr.sa.sa_family = hp->h_addrtype;
			switch (hp->h_addrtype) {
			case AF_INET:
				memmove(&addr.s_in.sin_addr, hp->h_addr, 4);
				addr.s_in.sin_port = pnum;
				break;

			default:
				(
#line 530
	env_throw_bi(env, mfe_range, NULL, _("invalid connection type: "
					   "%s; unsupported address family"),cstr)
#line 530
);
#line 534
			}
		}
#ifdef GACOPYZ_IPV6
	} else if (strcmp(proto, "inet6") == 0) {
		struct addrinfo hints;
		struct addrinfo *res;
		
			if (!(port != NULL))
#line 541
		(
#line 541
	env_throw_bi(env, mfe_failure, NULL, _("invalid connection type: %s; "
			    "missing port number"),cstr)
#line 541
)
#line 545
;

		memset(&hints, 0, sizeof(hints));
		hints.ai_family = AF_INET6;
		hints.ai_socktype = SOCK_STREAM;
		if (!path)
			hints.ai_flags |= AI_PASSIVE;
		
		rc = getaddrinfo(path, port, &hints, &res);
				
		switch (rc) {
		case 0:
			break;
			
		case EAI_SYSTEM:
			(
#line 560
	env_throw_bi(env, mfe_failure, NULL, _("%s:%s: cannot parse address: %s"),path,port,strerror(errno))
#line 560
);
#line 563
			
		case EAI_BADFLAGS:
		case EAI_SOCKTYPE:
			(
#line 566
	env_throw_bi(env, mfe_failure, NULL, _("%s:%d: internal error converting %s:%s"),__FILE__,__LINE__,path,port)
#line 566
);
#line 569
			
		case EAI_MEMORY:
			mu_alloc_die();
			
		default:
			(
#line 574
	env_throw_bi(env, mfe_failure, NULL, "%s:%s: %s",path,port,gai_strerror(rc))
#line 574
);
#line 577
		}

		socklen = res->ai_addrlen;
		if (socklen > sizeof(addr)) {
			freeaddrinfo(res);
			(
#line 582
	env_throw_bi(env, mfe_failure, NULL, _("%s:%s: address length too big (%lu)"),path,port,(unsigned long) socklen)
#line 582
);
#line 586
		}
		memcpy(&addr, res->ai_addr, res->ai_addrlen);
		freeaddrinfo(res);
#endif
	} else {
		(
#line 591
	env_throw_bi(env, mfe_range, NULL, _("unsupported protocol: %s"),proto)
#line 591
);
#line 594
	}

	fd = socket(addr.sa.sa_family, SOCK_STREAM, 0);
		if (!(fd != -1))
#line 597
		(
#line 597
	env_throw_bi(env, mfe_failure, NULL, _("unable to create new socket: %s"),strerror(errno))
#line 597
)
#line 600
;

	/* FIXME: Bind to the source ? */

	rc = connect(fd, &addr.sa, socklen);
	if (rc) {
		close(fd);
		(
#line 607
	env_throw_bi(env, mfe_failure, NULL, _("cannot connect to %s: %s"),cstr,strerror(errno))
#line 607
);
#line 610
	}
	
	str->fd[0] = fd;
	return 0;
}

static int
shutdown_inet_stream(struct io_stream *str, int how)
{
	switch (how) {
	case 0:
		how = SHUT_RD;
		break;

	case 1:
		how = SHUT_WR;
		break;

	case 2:
		how = SHUT_RDWR;
		break;

	default:
		return EINVAL;
	}
	if (shutdown(str->fd[0], how))
		return errno;
	return 0;
}

static int
open_inet_stream(eval_environ_t env,
		 struct io_stream *str, const char *addr, int flags)
{
	int rc;
	char *proto, *port, *path;

	if (gacopyz_parse_connection(addr, &proto, &port, &path)
	    != MI_SUCCESS) 
		rc = ENOMEM; /* FIXME: or EINVAL? */
	else {
		rc = open_parsed_inet_stream(env,
					     str, addr,
					     proto, port, path, flags);
		str->shutdown = shutdown_inet_stream;
		free(proto);
		free(port);
		free(path);
	}
	return rc;
}


static void *
alloc_streams()
{
	struct io_stream *p, *stab = mu_calloc(nstreams, sizeof *stab);
	for (p = stab; p < stab + nstreams; p++) 
		p->fd[0] = p->fd[1] = -1;
	return stab;
}

static void
destroy_streams(void *data)
{
	struct io_stream *stab = data;
	struct io_stream *p;
	for (p = stab; p < stab + nstreams; p++) {
		close_stream(p);
		free(p->buf);
	}
	free(stab);
}
		

#line 684

#line 684
static int IO_id;
#line 684 "io.bi"


int
_bi_io_fd(eval_environ_t env, int fd, int what)
{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int descr;

		if (!(fd >= 0 && fd < nstreams && what>=0 && what<=1))
#line 692
		(
#line 692
	env_throw_bi(env, mfe_range, NULL, _("invalid file descriptor"))
#line 692
)
#line 694
;
	descr = what == 0 ? IFD(iotab[fd]) : OFD(iotab[fd]);
		if (!(descr >= 0))
#line 696
		(
#line 696
	env_throw_bi(env, mfe_range, NULL, _("invalid file descriptor"))
#line 696
)
#line 698
;
	return descr;
}


void
#line 703
bi_open(eval_environ_t env)
#line 703

#line 703

#line 703 "io.bi"
{
#line 703
	
#line 703

#line 703

#line 703
char *  name;
#line 703
        
#line 703
get_string_arg(env, 0, &name);
#line 703
        
#line 703

#line 703
        adjust_stack(env, 1);
#line 703

#line 703

#line 703
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 703
		prog_trace(env, "open %s",name);;
#line 703

{
	int i, rc;
	int flags = 0;
	int (*opf)(eval_environ_t env,
		   struct io_stream *, const char *, int) = open_file_stream;
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	
	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 715
		(
#line 715
	env_throw_bi(env, mfe_failure, "open", _("no more files available"))
#line 715
)
#line 717
;

	
#line 719

#line 719
mu_debug(debug_handle, MU_DEBUG_TRACE1,("opening stream %s", name));
	iotab[i].name = mu_strdup(name);
	iotab[i].delim = NULL;
	if (*name == '>') {
		flags |= O_RDWR|O_CREAT;
		name++;
		if (*name == '>') {
			flags |= O_APPEND;
			name++;
		} else
			flags |= O_TRUNC;
	} else if (*name == '|') {
		opf = open_program_stream;
		flags = O_WRONLY;
		name++;
		if (*name == '&') {
			flags = O_RDWR;
			name++;
		} else if (*name == '<') {
			flags = O_RDONLY;
			name++;
		}
	} else if (*name == '@') {
		name++;
		opf = open_inet_stream;
		flags = O_RDWR;
	} else
		flags = O_RDONLY;
	
	for (;*name && mu_isspace(*name); name++)
		;
	
	rc = opf(env, &iotab[i], name, flags);
	
		if (!(rc == 0))
#line 753
		(
#line 753
	env_throw_bi(env, mfe_failure, "open", _("cannot open stream %s: %s"),name,mu_strerror(rc))
#line 753
)
#line 756
;
	
#line 757

#line 757
mu_debug(debug_handle, MU_DEBUG_TRACE1,("open(%s) = %d", name, i));
	
#line 758
do {
#line 758
  push(env, (STKVAL)(mft_number)(i));
#line 758
  goto endlab;
#line 758
} while (0);
}
endlab:
#line 760
        env_function_cleanup_flush(env, NULL);
#line 760
	return;
#line 760
}

void
#line 762
bi_spawn(eval_environ_t env)
#line 762

#line 762

#line 762 "io.bi"
{
#line 762
	
#line 762

#line 762
long __bi_argcnt;
#line 762
char *  name;
#line 762
        long  fin;
#line 762
        long  fout;
#line 762
        long  ferr;
#line 762
        
#line 762
get_string_arg(env, 1, &name);
#line 762
        get_numeric_arg(env, 2, &fin);
#line 762
        get_numeric_arg(env, 3, &fout);
#line 762
        get_numeric_arg(env, 4, &ferr);
#line 762
        
#line 762
get_numeric_arg(env, 0, &__bi_argcnt);
#line 762
        adjust_stack(env, __bi_argcnt + 1);
#line 762

#line 762

#line 762
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 762
		prog_trace(env, "spawn %s %lu %lu %lu",name, ((__bi_argcnt > 1) ? fin : 0), ((__bi_argcnt > 2) ? fout : 0), ((__bi_argcnt > 3) ? ferr : 0));;

{
	int i, rc;
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int ioe[3];
	int flags;
	
	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 774
		(
#line 774
	env_throw_bi(env, mfe_failure, "spawn", _("no more files available"))
#line 774
)
#line 776
;

	
#line 778

#line 778
mu_debug(debug_handle, MU_DEBUG_TRACE1,("spawning %s", name));
	iotab[i].name = mu_strdup(name);
	iotab[i].delim = NULL;

	flags = O_WRONLY;
	if (*name == '|')
		name++;
	if (*name == '&') {
		flags = O_RDWR;
		name++;
	} else if (*name == '<') {
		flags = O_RDONLY;
		name++;
	}

	for (;*name && mu_isspace(*name); name++)
		;

	if ((__bi_argcnt > 1))
		ioe[0] = _bi_io_fd(env, ((__bi_argcnt > 1) ? fin : 0), 0);
	else
		ioe[0] = -1;
	if ((__bi_argcnt > 2))
		ioe[1] = _bi_io_fd(env, ((__bi_argcnt > 2) ? fout : 0), 1);
	else
		ioe[1] = -1;
	if ((__bi_argcnt > 3))
		ioe[2] = _bi_io_fd(env, ((__bi_argcnt > 2) ? fout : 0), 1);
	else
		ioe[2] = -1;
	
	rc = open_program_stream_ioe(env, &iotab[i], name, flags, ioe);
	
		if (!(rc == 0))
#line 811
		(
#line 811
	env_throw_bi(env, mfe_failure, "spawn", _("cannot open stream %s: %s"),name,mu_strerror(rc))
#line 811
)
#line 814
;
	
#line 815

#line 815
mu_debug(debug_handle, MU_DEBUG_TRACE1,("spawn(%s) = %d", name, i));
	
#line 816
do {
#line 816
  push(env, (STKVAL)(mft_number)(i));
#line 816
  goto endlab;
#line 816
} while (0);
	
}
endlab:
#line 819
        env_function_cleanup_flush(env, NULL);
#line 819
	return;
#line 819
}


void
#line 822
bi_tempfile(eval_environ_t env)
#line 822

#line 822

#line 822 "io.bi"
{
#line 822
	
#line 822

#line 822
long __bi_argcnt;
#line 822
char * MFL_DATASEG tempdir;
#line 822
        
#line 822
get_string_arg(env, 1, &tempdir);
#line 822
        
#line 822
get_numeric_arg(env, 0, &__bi_argcnt);
#line 822
        adjust_stack(env, __bi_argcnt + 1);
#line 822

#line 822

#line 822
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 822
		prog_trace(env, "tempfile %s",((__bi_argcnt > 0) ? tempdir : ""));;
#line 822

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int i;
	char *dir = ((__bi_argcnt > 0) ? tempdir : "/tmp");
	size_t dirlen = strlen(dir);
	mode_t u;
	int fd;
	char *template;
#define PATTERN "mfdXXXXXX"

	for (i = 0; i < nstreams; i++) {
		if (iotab[i].fd[0] == -1) 
			break;
	}
		if (!(i < nstreams))
#line 837
		(
#line 837
	env_throw_bi(env, mfe_failure, "tempfile", _("no more files available"))
#line 837
)
#line 839
;


	while (dirlen > 0 && dir[dirlen-1] == '/')
		dirlen--;

	template = mf_c_val(heap_tempspace(env, (dirlen ? dirlen + 1 : 0) +
#line 845
				      sizeof(PATTERN)), ptr);
#line 847
	if (dirlen) {
		memcpy(template, dir, dirlen);
		template[dirlen++] = '/';
	}
	strcpy(template + dirlen, PATTERN);
	u = umask(077);
	fd = mkstemp(template);
	umask(u);
		if (!(fd >= 0))
#line 855
		(
#line 855
	env_throw_bi(env, mfe_failure, "tempfile", "mkstemp failed: %s",mu_strerror(errno))
#line 855
)
#line 858
;
	unlink(template);

	iotab[i].fd[0] = fd;
	
	
#line 863
do {
#line 863
  push(env, (STKVAL)(mft_number)(i));
#line 863
  goto endlab;
#line 863
} while (0);
#undef PATTERN
}
endlab:
#line 866
        env_function_cleanup_flush(env, NULL);
#line 866
	return;
#line 866
}

void
#line 868
bi_close(eval_environ_t env)
#line 868

#line 868

#line 868 "io.bi"
{
#line 868
	
#line 868

#line 868

#line 868
long  fd;
#line 868
        
#line 868
get_numeric_arg(env, 0, &fd);
#line 868
        
#line 868

#line 868
        adjust_stack(env, 1);
#line 868

#line 868

#line 868
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 868
		prog_trace(env, "close %lu",fd);;
#line 868

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);

		if (!(fd >= 0 && fd < nstreams))
#line 872
		(
#line 872
	env_throw_bi(env, mfe_range, "close", _("invalid file descriptor"))
#line 872
)
#line 874
;
	close_stream(&iotab[fd]);
}

#line 877
        env_function_cleanup_flush(env, NULL);
#line 877
	return;
#line 877
}	

static struct builtin_const_trans shutdown_modes[] = {
	{ _MFL_SHUT_RD, SHUT_RD },
	{ _MFL_SHUT_WR, SHUT_WR },
	{ _MFL_SHUT_RDWR, SHUT_RDWR }
};

void
#line 885
bi_shutdown(eval_environ_t env)
#line 885

#line 885

#line 885 "io.bi"
{
#line 885
	
#line 885

#line 885

#line 885
long  fd;
#line 885
        long  how;
#line 885
        
#line 885
get_numeric_arg(env, 0, &fd);
#line 885
        get_numeric_arg(env, 1, &how);
#line 885
        
#line 885

#line 885
        adjust_stack(env, 2);
#line 885

#line 885

#line 885
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 885
		prog_trace(env, "shutdown %lu %lu",fd, how);;
#line 885

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int mode;
	
		if (!(fd >= 0 && fd < nstreams))
#line 891
		(
#line 891
	env_throw_bi(env, mfe_range, "shutdown", _("invalid file descriptor"))
#line 891
)
#line 893
;
		if (!(how >= 0 && how <= 2))
#line 894
		(
#line 894
	env_throw_bi(env, mfe_range, "shutdown", _("invalid file descriptor"))
#line 894
)
#line 896
;
		if (!(_builtin_const_to_c(shutdown_modes,
#line 897
				      MU_ARRAY_SIZE(shutdown_modes),
#line 897
				      how,
#line 897
				      &mode) == 0))
#line 897
		(
#line 897
	env_throw_bi(env, mfe_failure, "shutdown", "bad shutdown mode")
#line 897
)
#line 902
;
	
	ioptr = &iotab[fd];
	if (ioptr->shutdown) {
		int rc = ioptr->shutdown(ioptr, mode);
			if (!(rc == 0))
#line 907
		(
#line 907
	env_throw_bi(env, mfe_io, "shutdown", "shutdown failed: %s",mu_strerror(rc))
#line 907
)
#line 910
;
	} else if (how == 2)
		close_stream(ioptr);
	else if (ioptr->fd[how]) {
		close(ioptr->fd[how]);
		ioptr->fd[how] = -1;
	}
}

#line 918
        env_function_cleanup_flush(env, NULL);
#line 918
	return;
#line 918
}

void
#line 920
bi_write(eval_environ_t env)
#line 920

#line 920

#line 920 "io.bi"
{
#line 920
	
#line 920

#line 920
long __bi_argcnt;
#line 920
long  fd;
#line 920
        char *  str;
#line 920
        long  n;
#line 920
        
#line 920
get_numeric_arg(env, 1, &fd);
#line 920
        get_string_arg(env, 2, &str);
#line 920
        get_numeric_arg(env, 3, &n);
#line 920
        
#line 920
get_numeric_arg(env, 0, &__bi_argcnt);
#line 920
        adjust_stack(env, __bi_argcnt + 1);
#line 920

#line 920

#line 920
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 920
		prog_trace(env, "write %lu %s %lu",fd, str, ((__bi_argcnt > 2) ? n : 0));;
#line 920

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;
	
	
#line 925

#line 925
mu_debug(debug_handle, MU_DEBUG_TRACE1,("writing %s to %lu", str, fd));
		if (!(fd >= 0 && fd < nstreams && OFD(iotab[fd]) != -1))
#line 926
		(
#line 926
	env_throw_bi(env, mfe_range, "write", _("invalid file descriptor"))
#line 926
)
#line 928
;
	if (!(__bi_argcnt > 2))
		n = strlen (str);
	rc = write(OFD(iotab[fd]), str, n);
		if (!(n == rc))
#line 932
		(
#line 932
	env_throw_bi(env, mfe_io, "write", _("write error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 932
)
#line 935
;
}

#line 937
        env_function_cleanup_flush(env, NULL);
#line 937
	return;
#line 937
}


void
#line 940
bi_write_body(eval_environ_t env)
#line 940

#line 940

#line 940 "io.bi"
{
#line 940
	
#line 940

#line 940

#line 940
long  fd;
#line 940
        void *  str;
#line 940
        long  n;
#line 940
        
#line 940
get_numeric_arg(env, 0, &fd);
#line 940
        get_pointer_arg(env, 1, &str);
#line 940
        get_numeric_arg(env, 2, &n);
#line 940
        
#line 940

#line 940
        adjust_stack(env, 3);
#line 940

#line 940

#line 940
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 940
		prog_trace(env, "write_body %lu %p %lu",fd, str, n);;
#line 940

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;

		if (!(fd >= 0 && fd < nstreams && OFD(iotab[fd]) != -1))
#line 945
		(
#line 945
	env_throw_bi(env, mfe_range, "write_body", _("invalid file descriptor"))
#line 945
)
#line 947
;
	rc = write(OFD(iotab[fd]), str, n);
		if (!(n == rc))
#line 949
		(
#line 949
	env_throw_bi(env, mfe_io, "write_body", _("write error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 949
)
#line 952
;
}

#line 954
        env_function_cleanup_flush(env, NULL);
#line 954
	return;
#line 954
}

void
#line 956
bi_read(eval_environ_t env)
#line 956

#line 956

#line 956 "io.bi"
{
#line 956
	
#line 956

#line 956

#line 956
long  fd;
#line 956
        long  size;
#line 956
        
#line 956
get_numeric_arg(env, 0, &fd);
#line 956
        get_numeric_arg(env, 1, &size);
#line 956
        
#line 956

#line 956
        adjust_stack(env, 2);
#line 956

#line 956

#line 956
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 956
		prog_trace(env, "read %lu %lu",fd, size);;
#line 956

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int rc;
	size_t off;
	char *s = (char*) env_data_ref(env, (off = heap_reserve(env, size + 1)));

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 963
		(
#line 963
	env_throw_bi(env, mfe_range, "read", _("invalid file descriptor"))
#line 963
)
#line 965
;
	
	rc = read(IFD(iotab[fd]), s, size);
	if (rc == 0)
		(
#line 969
	env_throw_bi(env, mfe_eof, "read", _("EOF on %s"),iotab[fd].name)
#line 969
);
#line 971
		if (!(rc == size))
#line 971
		(
#line 971
	env_throw_bi(env, mfe_io, "read", _("read error on %s: %s"),iotab[fd].name,mu_strerror(errno))
#line 971
)
#line 974
;
	s[size] = 0;
	
#line 976
do {
#line 976
  push(env, (STKVAL) (mft_size) (off));
#line 976
  goto endlab;
#line 976
} while (0);
}	
endlab:
#line 978
        env_function_cleanup_flush(env, NULL);
#line 978
	return;
#line 978
}

void
#line 980
bi_rewind(eval_environ_t env)
#line 980

#line 980

#line 980 "io.bi"
{
#line 980
	
#line 980

#line 980

#line 980
long  fd;
#line 980
        
#line 980
get_numeric_arg(env, 0, &fd);
#line 980
        
#line 980

#line 980
        adjust_stack(env, 1);
#line 980

#line 980

#line 980
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 980
		prog_trace(env, "rewind %lu",fd);;
#line 980

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 984
		(
#line 984
	env_throw_bi(env, mfe_range, "rewind", _("invalid file descriptor"))
#line 984
)
#line 986
;
	if (lseek(IFD(iotab[fd]), 0, SEEK_SET) == -1)
		(
#line 988
	env_throw_bi(env, mfe_io, "rewind", "seek failed: %s",mu_strerror(errno))
#line 988
);
#line 991
}

#line 992
        env_function_cleanup_flush(env, NULL);
#line 992
	return;
#line 992
}
	

#define MINBUFSIZE 128
#define MAXBUFSIZE 65535

void
#line 998
bi_copy(eval_environ_t env)
#line 998

#line 998

#line 998 "io.bi"
{
#line 998
	
#line 998

#line 998

#line 998
long  dst;
#line 998
        long  src;
#line 998
        
#line 998
get_numeric_arg(env, 0, &dst);
#line 998
        get_numeric_arg(env, 1, &src);
#line 998
        
#line 998

#line 998
        adjust_stack(env, 2);
#line 998

#line 998

#line 998
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 998
		prog_trace(env, "copy %lu %lu",dst, src);;
#line 998

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	int ifd, ofd;
	char *buffer;
	size_t bufsize = MAXBUFSIZE;
	char bs[MINBUFSIZE];
	off_t cur, end;
	size_t total = 0;
	ssize_t rdbytes;
	
		if (!(src >= 0 && src < nstreams && (ifd = IFD(iotab[src])) != -1))
#line 1009
		(
#line 1009
	env_throw_bi(env, mfe_range, "copy", _("invalid source file descriptor"))
#line 1009
)
#line 1011
;
		if (!(dst >= 0 && dst < nstreams && (ofd = OFD(iotab[dst])) != -1))
#line 1012
		(
#line 1012
	env_throw_bi(env, mfe_range, "copy", _("invalid destination file descriptor"))
#line 1012
)
#line 1014
;

	cur = lseek (ifd, 0, SEEK_CUR);
	if (cur != -1) {
		end = lseek (ifd, 0, SEEK_END);
		if (end != -1) {
			if (end < MAXBUFSIZE)
				bufsize = end;
			lseek (ifd, cur, SEEK_SET);
		}
	}

	for (; (buffer = malloc (bufsize)) == NULL; bufsize >>= 1)
		if (bufsize < MINBUFSIZE) {
			buffer = bs;
			bufsize = MINBUFSIZE;
			break;
		}

	while ((rdbytes = read(ifd, buffer, bufsize)) > 0) {
		char *p = buffer;
		while (rdbytes) {
			ssize_t wrbytes = write(ofd, p, rdbytes);
			if (wrbytes == -1) {
				if (buffer != bs)
					free(buffer);
				(
#line 1040
	env_throw_bi(env, mfe_io, "copy", "write error: %s",mu_strerror(errno))
#line 1040
);
#line 1043
			} else if (wrbytes == 0) {
				if (buffer != bs)
					free(buffer);
				(
#line 1046
	env_throw_bi(env, mfe_io, "copy", "short write")
#line 1046
);
#line 1048
			}
			p += wrbytes;
			rdbytes -= wrbytes;
			total += wrbytes;
		}
	}
	if (buffer != bs)
		free(buffer);
	
#line 1056
do {
#line 1056
  push(env, (STKVAL)(mft_number)(total));
#line 1056
  goto endlab;
#line 1056
} while (0);
}
endlab:
#line 1058
        env_function_cleanup_flush(env, NULL);
#line 1058
	return;
#line 1058
}

void
#line 1060
bi_getdelim(eval_environ_t env)
#line 1060

#line 1060

#line 1060 "io.bi"
{
#line 1060
	
#line 1060

#line 1060

#line 1060
long  fd;
#line 1060
        char * MFL_DATASEG delim;
#line 1060
        
#line 1060
get_numeric_arg(env, 0, &fd);
#line 1060
        get_string_arg(env, 1, &delim);
#line 1060
        
#line 1060

#line 1060
        adjust_stack(env, 2);
#line 1060

#line 1060

#line 1060
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1060
		prog_trace(env, "getdelim %lu %s",fd, delim);;
#line 1060

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int rc;
	
		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1066
		(
#line 1066
	env_throw_bi(env, mfe_range, "getdelim", _("invalid file descriptor"))
#line 1066
)
#line 1068
;
	ioptr = &iotab[fd];
	rc = read_stream_delim(ioptr, delim); 
	if (rc == 0)
		(
#line 1072
	env_throw_bi(env, mfe_eof, "getdelim", _("EOF on %s"),ioptr->name)
#line 1072
);
		if (!(rc > 0))
#line 1073
		(
#line 1073
	env_throw_bi(env, mfe_io, "getdelim", _("read error on %s: %s"),ioptr->name,mu_strerror(errno))
#line 1073
)
#line 1076
;
	
#line 1077
do {
#line 1077
  pushs(env, ioptr->buf);
#line 1077
  goto endlab;
#line 1077
} while (0);
}	
endlab:
#line 1079
        env_function_cleanup_flush(env, NULL);
#line 1079
	return;
#line 1079
}

void
#line 1081
bi_getline(eval_environ_t env)
#line 1081

#line 1081

#line 1081 "io.bi"
{
#line 1081
	
#line 1081

#line 1081

#line 1081
long  fd;
#line 1081
        
#line 1081
get_numeric_arg(env, 0, &fd);
#line 1081
        
#line 1081

#line 1081
        adjust_stack(env, 1);
#line 1081

#line 1081

#line 1081
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1081
		prog_trace(env, "getline %lu",fd);;
#line 1081

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;
	int rc;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1087
		(
#line 1087
	env_throw_bi(env, mfe_range, "getline", _("invalid file descriptor"))
#line 1087
)
#line 1089
;
	ioptr = &iotab[fd];
	rc = read_stream_delim(ioptr, ioptr->delim ? ioptr->delim : "\n");
	if (rc == 0)
		(
#line 1093
	env_throw_bi(env, mfe_eof, "getline", _("EOF on %s"),ioptr->name)
#line 1093
);
#line 1095
		if (!(rc > 0))
#line 1095
		(
#line 1095
	env_throw_bi(env, mfe_io, "getline", _("read error on %s: %s"),ioptr->name,mu_strerror(errno))
#line 1095
)
#line 1098
;
	
#line 1099
do {
#line 1099
  pushs(env, ioptr->buf);
#line 1099
  goto endlab;
#line 1099
} while (0);
}	
endlab:
#line 1101
        env_function_cleanup_flush(env, NULL);
#line 1101
	return;
#line 1101
}

void
#line 1103
bi_fd_set_delimiter(eval_environ_t env)
#line 1103

#line 1103

#line 1103 "io.bi"
{
#line 1103
	
#line 1103

#line 1103

#line 1103
long  fd;
#line 1103
        char *  delim;
#line 1103
        
#line 1103
get_numeric_arg(env, 0, &fd);
#line 1103
        get_string_arg(env, 1, &delim);
#line 1103
        
#line 1103

#line 1103
        adjust_stack(env, 2);
#line 1103

#line 1103

#line 1103
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1103
		prog_trace(env, "fd_set_delimiter %lu %s",fd, delim);;
#line 1103

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1108
		(
#line 1108
	env_throw_bi(env, mfe_range, "fd_set_delimiter", _("invalid file descriptor"))
#line 1108
)
#line 1110
;
	ioptr = &iotab[fd];
	free(ioptr->delim);
	ioptr->delim = mu_strdup(delim);
}

#line 1115
        env_function_cleanup_flush(env, NULL);
#line 1115
	return;
#line 1115
}

void
#line 1117
bi_fd_delimiter(eval_environ_t env)
#line 1117

#line 1117

#line 1117 "io.bi"
{
#line 1117
	
#line 1117

#line 1117

#line 1117
long  fd;
#line 1117
        char * MFL_DATASEG delim;
#line 1117
        
#line 1117
get_numeric_arg(env, 0, &fd);
#line 1117
        get_string_arg(env, 1, &delim);
#line 1117
        
#line 1117

#line 1117
        adjust_stack(env, 2);
#line 1117

#line 1117

#line 1117
	if (builtin_module_trace(BUILTIN_IDX_io))
#line 1117
		prog_trace(env, "fd_delimiter %lu %s",fd, delim);;
#line 1117

{
	struct io_stream *iotab = env_get_builtin_priv(env,IO_id);
	struct io_stream *ioptr;

		if (!(fd >= 0 && fd < nstreams && IFD(iotab[fd]) != -1))
#line 1122
		(
#line 1122
	env_throw_bi(env, mfe_range, "fd_delimiter", _("invalid file descriptor"))
#line 1122
)
#line 1124
;
	ioptr = &iotab[fd];
	
#line 1126
do {
#line 1126
  pushs(env, ioptr->delim ? ioptr->delim : "\n");
#line 1126
  goto endlab;
#line 1126
} while (0);
}
endlab:
#line 1128
        env_function_cleanup_flush(env, NULL);
#line 1128
	return;
#line 1128
}

 
#line 982 "../../src/builtin/snarf.m4"

#line 982

#line 982

#line 982
void
#line 982
io_init_builtin(void)
#line 982
{
#line 982
		debug_handle = mu_debug_register_category("bi_io");
#line 982

#line 982
	#line 684 "io.bi"
IO_id = builtin_priv_register(alloc_streams, destroy_streams,
#line 684
NULL);
#line 703 "io.bi"
va_builtin_install_ex("open", bi_open, 0, dtype_number, 1, 0, 0|0, dtype_string);
#line 762 "io.bi"
va_builtin_install_ex("spawn", bi_spawn, 0, dtype_number, 4, 3, 0|0, dtype_string, dtype_number, dtype_number, dtype_number);
#line 822 "io.bi"
va_builtin_install_ex("tempfile", bi_tempfile, 0, dtype_number, 1, 1, 0|0, dtype_string);
#line 868 "io.bi"
va_builtin_install_ex("close", bi_close, 0, dtype_unspecified, 1, 0, 0|0, dtype_number);
#line 885 "io.bi"
va_builtin_install_ex("shutdown", bi_shutdown, 0, dtype_unspecified, 2, 0, 0|0, dtype_number, dtype_number);
#line 920 "io.bi"
va_builtin_install_ex("write", bi_write, 0, dtype_unspecified, 3, 1, 0|0, dtype_number, dtype_string, dtype_number);
#line 940 "io.bi"
va_builtin_install_ex("write_body", bi_write_body, STATMASK(smtp_state_body), dtype_unspecified, 3, 0, 0|0, dtype_number, dtype_pointer, dtype_number);
#line 956 "io.bi"
va_builtin_install_ex("read", bi_read, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_number);
#line 980 "io.bi"
va_builtin_install_ex("rewind", bi_rewind, 0, dtype_unspecified, 1, 0, 0|0, dtype_number);
#line 998 "io.bi"
va_builtin_install_ex("copy", bi_copy, 0, dtype_number, 2, 0, 0|0, dtype_number, dtype_number);
#line 1060 "io.bi"
va_builtin_install_ex("getdelim", bi_getdelim, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_string);
#line 1081 "io.bi"
va_builtin_install_ex("getline", bi_getline, 0, dtype_string, 1, 0, 0|0, dtype_number);
#line 1103 "io.bi"
va_builtin_install_ex("fd_set_delimiter", bi_fd_set_delimiter, 0, dtype_unspecified, 2, 0, 0|0, dtype_number, dtype_string);
#line 1117 "io.bi"
va_builtin_install_ex("fd_delimiter", bi_fd_delimiter, 0, dtype_string, 2, 0, 0|0, dtype_number, dtype_string);

#line 982 "../../src/builtin/snarf.m4"
	
#line 982
	 mf_add_runtime_params(io_cfg_param);
#line 982
	 
#line 982
}
#line 982 "../../src/builtin/snarf.m4"

