/* This file is part of Mailfromd.             -*- c -*-
   Copyright (C) 2006-2020 Sergey Poznyakoff

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

/* Run-time support for callout functions */
MF_BUILTIN_MODULE
#include "filenames.h"
#include "callout.h"

MF_VAR(ehlo_domain, STRING, SYM_PRECIOUS);
MF_VAR(mailfrom_address, STRING, SYM_PRECIOUS);

int provide_callout;

/* #pragma provide-callout */
MF_PRAGMA(provide-callout, 1, 1)
{
	provide_callout = 1;
}

MF_DEFUN(default_callout_server_url, STRING)
{
	MF_RETURN(callout_server_url ?
		  callout_server_url : DEFAULT_CALLOUT_SOCKET);
}
END

static void
initvar(const char *name, const char *str)
{
	 struct value val;
	 
	 val.type = dtype_string;
	 val.v.literal = string_alloc(str, strlen(str));
	 ensure_initialized_variable(name, &val);
}	

MF_INIT([<
	 if (ehlo_domain)
		 initvar("ehlo_domain", ehlo_domain);
	 if (mailfrom_address)
		 initvar("mailfrom_address", mailfrom_address);
>])
	


