.TH LBENCH 1 2016-11-25 "Linux" "lbench man page"

.SH NAME
   lbench - a multithreaded benchmark program

.SH SYNOPSIS
   \fBlbench\fR 

.SH DESCRIPTION
   Various aspects of CPU and OS performance are measured for 1-10 parallel 
   threads. The objective is to measure how well performance scales with 
   multiple CPU processor cores and multiple process threads.

 Benchmarks include the following:  
   + CPU speed for integer and double arithmetic and some math functions
   + Memory speed for small (cache) and large (main) memory regions
     Sequential and random access speeds are measured separately
   + Time required to call and return from a minimal function
   + Time for shared mutex lock and unlock
   + Time for thread creation and termination
   + Time for process creation and termination
   + Time for global resource lock and unlock
   + Time to compute fibonacci numbers using the recursion method
   + Time to perform calculations using a large 2D matrix
   + Classic Whetstone benchmark (double precision)
   + Classic Linpack benchmark (double precision)
   + Disk random and serial I/O performance for different block sizes
   + A utility to fully load all processor cores, track CPU temperature, 
     and report slowdown due to clock speed throttling 
   + A utility to load memory with random numbers, read them back and
     check for errors. This can be used as a "burn-in" memory test.

.SH SEE ALSO
   The online user manual is available using the help toolbar button.
   This manual explains lbench operation in great detail.
 
.SH UNINSTALL
   Debian package: use command: sudo apt remove lbench
   Tarball: use command: sudo make uninstall
   Appimage package: use command: lbench -uninstall
 
.SH AUTHORS
   Written by Michael Cornelison <kornelix@posteo.de>
   https://kornelix.net


