#include <gtk/gtk.h>
#include <unistd.h>
#include <libintl.h>
#include <locale.h>
#define _(String) gettext (String)
#define N_(String) String
#include "config.h"

#include "gencfs.h"
#include "encryptedfolders.h"


void gtk_widget_show_adddialog (GtkWidget *widget, gpointer user_data) {
	gtk_widget_show ((GtkWidget *) gtk_builder_get_object (widgetstree, "adddialog"));
}


void gtk_widget_hide_adddialog (GtkWidget *widget, gpointer user_data) {
	gtk_widget_hide ((GtkWidget *) gtk_builder_get_object (widgetstree, "adddialog"));
}


void gtk_widget_show_aboutdialog (GtkWidget *widget, gpointer user_data) {
	gtk_widget_show ((GtkWidget *) gtk_builder_get_object (widgetstree, "aboutdialog"));
}


int main (int argc, char *argv[]) {
	GtkWindow *mainwindow;
	GtkAboutDialog *aboutdialog;
	
	setlocale (LC_ALL, "");
	bindtextdomain (PROJECT_NAME, LOCALE_DIR);
	textdomain (PROJECT_NAME);
	
	gtk_init (&argc, &argv);
	widgetstree = gtk_builder_new();
	gtk_builder_add_from_file (widgetstree, UI_FILE, NULL);
	gtk_builder_connect_signals (widgetstree, NULL);
	
	load_encryptedfolders_wrapper();
	
	mainwindow = (GtkWindow *) gtk_builder_get_object (widgetstree, "mainwindow");
	gtk_window_set_icon_from_file (mainwindow, APP_ICON, NULL);
	aboutdialog = (GtkAboutDialog *) gtk_builder_get_object (widgetstree, "aboutdialog");
	gtk_about_dialog_set_version (aboutdialog, PROJECT_VERSION);
	gtk_widget_show ((GtkWidget *) mainwindow);
	gtk_main();
	
	return 0;
}
